/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Utilities;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.FileHandler;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import ArmyC2.C2SD.Utilities.XMLUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class TacticalGraphicLookup {
    private ArrayList<String> alSymbolID = new ArrayList();
    private ArrayList<Integer> alMapping = new ArrayList();
    private Map<String, Integer> lookup = new HashMap<String, Integer>();
    private static TacticalGraphicLookup _instance = null;

    private TacticalGraphicLookup() {
        this.init();
    }

    public static synchronized TacticalGraphicLookup getInstance() {
        if (_instance == null) {
            _instance = new TacticalGraphicLookup();
        }
        return _instance;
    }

    private void init() {
        this.xmlLoaded();
    }

    private void xmlLoaded() {
        InputStream xmlStream = this.getClass().getClassLoader().getResourceAsStream("XML/TacticalGraphics.xml");
        String lookupXml = FileHandler.InputStreamToString(xmlStream);
        this.populateLookup(lookupXml);
    }

    private void populateLookup(String xml) {
        ArrayList<String> al = XMLUtil.getItemList(xml, "<SYMBOL>", "</SYMBOL>");
        for (int i = 0; i < al.size(); ++i) {
            String data = al.get(i);
            String basicID = XMLUtil.parseTagValue(data, "<SYMBOLID>", "</SYMBOLID>");
            String mapping = XMLUtil.parseTagValue(data, "<MAPPING>", "</MAPPING>");
            mapping = TacticalGraphicLookup.checkMappingIndex(mapping);
            this.lookup.put(basicID, Integer.parseInt(mapping));
        }
    }

    private static String checkMappingIndex(String index) {
        int i = -1;
        if (SymbolUtilities.isNumber(index)) {
            i = Integer.valueOf(index);
            return String.valueOf(i + 57000);
        }
        return index;
    }

    public int getCharCodeFromSymbol(String symbolCode) {
        int symStd = RendererSettings.getInstance().getSymbologyStandard();
        return this.getCharCodeFromSymbol(symbolCode, symStd);
    }

    public int getCharCodeFromSymbol(String symbolCode, int symStd) {
        try {
            String basicID = symbolCode;
            int charCode = -1;
            if (!SymbolUtilities.isWeather(symbolCode)) {
                basicID = SymbolUtilities.getBasicSymbolID(symbolCode);
            }
            if (this.lookup.containsKey(basicID) && (charCode = this.lookup.get(basicID).intValue()) == 59053 && symStd == 1) {
                charCode = 59052;
            }
            return charCode;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("TacticalGraphicLookup", "getCharCodeFromSymbol", exc, Level.WARNING);
            return -1;
        }
    }
}

