/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.JavaLineArray;

import armyc2.c5isr.JavaLineArray.POINT2;
import armyc2.c5isr.JavaLineArray.arraysupport;
import armyc2.c5isr.JavaLineArray.lineutility;
import armyc2.c5isr.JavaLineArray.ref;
import armyc2.c5isr.JavaTacticalRenderer.TGLight;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.RendererException;

public final class flot {
    private static final String _className = "flot";

    protected static int GetAnchorageFlotSegment(int[] vbPoints, int x1, int y1, int x2, int y2, int segment, double floatDiameter, int[] points, ref<int[]> bFlip, ref<int[]> lDirection, ref<int[]> lLastDirection) {
        int lSegCounter = 0;
        try {
            int j = 0;
            double dDistance = 0.0;
            int nNumSegs = 0;
            int m = 0;
            int lLocx = 0;
            int lLocy = 0;
            double dAngle = 0.0;
            int[] arcPoints = new int[30];
            double dRemainder = 0.0;
            double dNum = 0.0;
            double dDen = 0.0;
            if (segment == 0 && vbPoints[0] >= vbPoints[2]) {
                ((int[])bFlip.value)[0] = 1;
            }
            if (segment == 0 && vbPoints[0] < vbPoints[2]) {
                ((int[])bFlip.value)[0] = 0;
            }
            dNum = vbPoints[2 * segment + 3] - vbPoints[2 * segment + 1];
            dDen = vbPoints[2 * segment + 2] - vbPoints[2 * segment];
            dAngle = dDen == 0.0 ? 1.5707963267948966 : Math.abs(Math.atan(dNum / dDen));
            dAngle = 57.29577951308232 * dAngle;
            if (vbPoints[2 * segment + 0] <= vbPoints[2 * segment + 2] && vbPoints[2 * segment + 1] >= vbPoints[2 * segment + 3]) {
                dAngle = 90.0 - dAngle;
            } else if (vbPoints[2 * segment + 0] <= vbPoints[2 * segment + 2] && vbPoints[2 * segment + 1] <= vbPoints[2 * segment + 3]) {
                dAngle += 90.0;
            } else if (vbPoints[2 * segment + 0] >= vbPoints[2 * segment + 2] && vbPoints[2 * segment + 1] <= vbPoints[2 * segment + 3]) {
                dAngle = 270.0 - dAngle;
            } else if (vbPoints[2 * segment + 0] >= vbPoints[2 * segment + 2] && vbPoints[2 * segment + 1] >= vbPoints[2 * segment + 3]) {
                dAngle = 270.0 + dAngle;
            }
            dDistance = lineutility.CalcDistance2(x1, y1, x2, y2);
            nNumSegs = (int)(dDistance / floatDiameter);
            if (nNumSegs % 2 == 0) {
                --nNumSegs;
            }
            dRemainder = (double)nNumSegs * floatDiameter - dDistance;
            dDistance += dRemainder;
            if (vbPoints[2 * segment] >= vbPoints[2 * segment + 2]) {
                dAngle += 90.0;
                ((int[])lDirection.value)[0] = 1;
            } else {
                dAngle -= 90.0;
                ((int[])lDirection.value)[0] = 0;
            }
            if (segment > 0 && ((int[])lDirection.value)[0] != ((int[])lLastDirection.value)[0]) {
                ((int[])bFlip.value)[0] = ((int[])bFlip.value)[0] == 1 ? 0 : 1;
            }
            if (((int[])bFlip.value)[0] == 1) {
                dAngle += 180.0;
            }
            for (m = 0; m < nNumSegs; m += 2) {
                lLocx = (int)((double)x1 + ((double)m + 0.5) * (double)(x2 - x1) * floatDiameter / dDistance);
                lLocy = (int)((double)y1 + ((double)m + 0.5) * (double)(y2 - y1) * floatDiameter / dDistance);
                flot.CalcAnglePoints(lLocx, lLocy, dAngle, arcPoints, dDistance / ((double)nNumSegs * 2.0));
                for (j = 0; j < 30; ++j) {
                    points[lSegCounter] = arcPoints[j];
                    ++lSegCounter;
                }
            }
            ((int[])lLastDirection.value)[0] = ((int[])lDirection.value)[0];
            arcPoints = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetAnchorageFlotSegment", new RendererException("Failed inside GetAnchorageFlotSegment", exc));
        }
        return lSegCounter;
    }

    protected static int GetAnchorageCountDouble(POINT2[] vbPoints, double floatDiameter, int numPts) {
        int lTotalpts = 0;
        try {
            int j = 0;
            int lNumSegs = 0;
            double dDistance = 0.0;
            POINT2[] vbPoints2 = null;
            vbPoints2 = new POINT2[numPts];
            for (j = 0; j < numPts; ++j) {
                vbPoints2[j] = new POINT2(vbPoints[j]);
            }
            for (j = 0; j < numPts - 1; ++j) {
                dDistance = lineutility.CalcDistanceDouble(vbPoints2[j], vbPoints2[j + 1]);
                lNumSegs = (int)(dDistance / floatDiameter);
                if (lNumSegs > 0) {
                    lTotalpts += lNumSegs * 12;
                    continue;
                }
                ++lTotalpts;
            }
            ++lTotalpts;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetAnchorageCountDouble", new RendererException("Failed inside GetAnchorageCountDouble", exc));
        }
        return lTotalpts;
    }

    protected static int GetFlotCount2Double(TGLight tg, POINT2[] vbPoints, int numPts) {
        int lTotalpts = 0;
        try {
            int j = 0;
            int lNumSegs = 0;
            double dDistance = 0.0;
            double dIncrement = 0.0;
            int nFactor = 10;
            switch (tg.get_LineType()) {
                case 31132000: 
                case 31132100: {
                    dIncrement = arraysupport.getScaledSize(40.0, tg.get_LineThickness());
                    break;
                }
                case 31132200: {
                    dIncrement = arraysupport.getScaledSize(60.0, tg.get_LineThickness());
                    nFactor = 17;
                    break;
                }
                case 31132300: {
                    dIncrement = arraysupport.getScaledSize(60.0, tg.get_LineThickness());
                    nFactor = 20;
                    break;
                }
                default: {
                    dIncrement = arraysupport.getScaledSize(20.0, tg.get_LineThickness());
                }
            }
            block10: for (j = 0; j < numPts - 1; ++j) {
                dDistance = lineutility.CalcDistanceDouble(vbPoints[j], vbPoints[j + 1]);
                lNumSegs = (int)(dDistance / dIncrement);
                lTotalpts += lNumSegs * nFactor;
                switch (tg.get_LineType()) {
                    case 31132200: 
                    case 31132300: {
                        if (lNumSegs != 0) continue block10;
                        lTotalpts += 2;
                        continue block10;
                    }
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetFlotCount2Double", new RendererException("Failed inside GetFlotCount2Double", exc));
        }
        return lTotalpts;
    }

    protected static int GetFlot2Double(TGLight tg, POINT2[] vbPoints2, int numPts) {
        int lFlotCounter = 0;
        try {
            int lineType = tg.get_LineType();
            int j = 0;
            int k = 0;
            int l = 0;
            int x1 = 0;
            int y1 = 0;
            int x2 = 0;
            int y2 = 0;
            int z2 = 0;
            int numSegPts = -1;
            int z = 0;
            int lFlotCount = 0;
            int lNumSegs = 0;
            double dDistance = 0.0;
            int[] vbPoints = null;
            int[] points = null;
            double dIncrement = 0.0;
            POINT2[] style10Points = null;
            int style10Counter = 0;
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            POINT2 crossPt1 = new POINT2();
            POINT2 crossPt2 = new POINT2();
            ref<int[]> bFlip = new ref<int[]>();
            ref<int[]> lDirection = new ref<int[]>();
            ref<int[]> lLastDirection = new ref<int[]>();
            bFlip.value = new int[1];
            lDirection.value = new int[1];
            lLastDirection.value = new int[1];
            ((int[])bFlip.value)[0] = -1;
            ((int[])lDirection.value)[0] = -1;
            ((int[])lLastDirection.value)[0] = -1;
            lFlotCount = flot.GetFlotCount2Double(tg, vbPoints2, numPts);
            if (lFlotCount <= 0) {
                return 0;
            }
            style10Points = new POINT2[lFlotCount];
            lineutility.InitializePOINT2Array(style10Points);
            vbPoints = new int[2 * numPts];
            switch (lineType) {
                case 31132000: 
                case 31132100: {
                    dIncrement = arraysupport.getScaledSize(40.0, tg.get_LineThickness());
                    break;
                }
                case 31132200: 
                case 31132300: {
                    dIncrement = arraysupport.getScaledSize(60.0, tg.get_LineThickness());
                    break;
                }
                default: {
                    dIncrement = arraysupport.getScaledSize(20.0, tg.get_LineThickness());
                }
            }
            for (j = 0; j < numPts; ++j) {
                vbPoints[k] = (int)vbPoints2[j].x;
                vbPoints[++k] = (int)vbPoints2[j].y;
                ++k;
            }
            k = 0;
            j = 0;
            for (l = 0; l < numPts - 1; ++l) {
                dDistance = lineutility.CalcDistance2(vbPoints[2 * l], vbPoints[2 * l + 1], vbPoints[2 * l + 2], vbPoints[2 * l + 3]);
                lNumSegs = (int)(dDistance / dIncrement);
                if (lNumSegs > 0) {
                    points = new int[lNumSegs * 30];
                    numSegPts = flot.GetFlotSegment2(tg, vbPoints, l, points, bFlip, lDirection, lLastDirection);
                    for (j = 0; j < numSegPts; ++j) {
                        x1 = points[k];
                        y1 = points[k + 1];
                        z = points[k + 2];
                        pt0.x = x1;
                        pt0.y = y1;
                        pt0.style = z;
                        if (j < numSegPts - 1) {
                            x2 = points[k + 3];
                            y2 = points[k + 4];
                            z2 = points[k + 5];
                            pt1.x = x2;
                            pt1.y = y2;
                            pt1.style = z2;
                        }
                        k += 3;
                        if (lFlotCounter >= lFlotCount) continue;
                        vbPoints2[lFlotCounter].x = x1;
                        vbPoints2[lFlotCounter].y = y1;
                        switch (lineType) {
                            case 31132000: 
                            case 31132200: 
                            case 31132300: {
                                if ((lFlotCounter + 1) % 10 == 0) {
                                    vbPoints2[lFlotCounter].style = 10;
                                    if (j < numSegPts - 1) {
                                        style10Points[style10Counter] = new POINT2(vbPoints2[lFlotCounter]);
                                        style10Points[style10Counter].style = 0;
                                        ++style10Counter;
                                        if (j >= numSegPts - 2) break;
                                        if (lineType == 31132200) {
                                            pt2 = new POINT2(style10Points[style10Counter - 1]);
                                            style10Points[style10Counter++] = lineutility.ExtendAlongLineDouble(pt2, pt1, arraysupport.getScaledSize(10.0, tg.get_LineThickness()), 5);
                                            style10Points[style10Counter++] = lineutility.ExtendAlongLineDouble(pt2, pt1, arraysupport.getScaledSize(20.0, tg.get_LineThickness()), 20);
                                            style10Points[style10Counter++] = lineutility.ExtendAlongLineDouble(pt2, pt1, arraysupport.getScaledSize(30.0, tg.get_LineThickness()), 0);
                                            style10Points[style10Counter++] = lineutility.ExtendAlongLineDouble(pt2, pt1, arraysupport.getScaledSize(70.0, tg.get_LineThickness()), 5);
                                        }
                                        if (lineType != 31132300) break;
                                        pt2 = new POINT2(style10Points[style10Counter - 1]);
                                        style10Points[style10Counter++] = lineutility.ExtendAlongLineDouble(pt2, pt1, arraysupport.getScaledSize(10.0, tg.get_LineThickness()), 5);
                                        style10Points[style10Counter++] = lineutility.ExtendAlongLineDouble(pt2, pt1, arraysupport.getScaledSize(15.0, tg.get_LineThickness()), 0);
                                        crossPt1 = lineutility.ExtendDirectedLine(style10Points[style10Counter - 1], pt1, style10Points[style10Counter - 1], 3, arraysupport.getScaledSize(5.0, tg.get_LineThickness()), 0);
                                        style10Points[style10Counter++] = lineutility.ExtendAlongLineDouble(pt2, pt1, arraysupport.getScaledSize(25.0, tg.get_LineThickness()), 5);
                                        crossPt2 = lineutility.ExtendDirectedLine(style10Points[style10Counter - 1], pt1, style10Points[style10Counter - 1], 2, arraysupport.getScaledSize(5.0, tg.get_LineThickness()), 5);
                                        style10Points[style10Counter++] = new POINT2(crossPt1);
                                        style10Points[style10Counter++] = new POINT2(crossPt2);
                                        style10Points[style10Counter++] = lineutility.ExtendAlongLineDouble(pt2, pt1, arraysupport.getScaledSize(30.0, tg.get_LineThickness()), 0);
                                        style10Points[style10Counter++] = lineutility.ExtendAlongLineDouble(pt2, pt1, arraysupport.getScaledSize(60.0, tg.get_LineThickness()), 5);
                                        break;
                                    }
                                    pt2.x = vbPoints[2 * l];
                                    pt2.y = vbPoints[2 * l + 1];
                                    pt2.style = 0;
                                    style10Points[style10Counter++] = new POINT2(pt2);
                                    style10Points[style10Counter++] = lineutility.ExtendAlongLineDouble(pt2, pt1, arraysupport.getScaledSize(40.0, tg.get_LineThickness()), 5);
                                    pt2.x = vbPoints[2 * l + 2];
                                    pt2.y = vbPoints[2 * l + 3];
                                    pt2.style = 5;
                                    style10Points[style10Counter] = new POINT2(vbPoints2[lFlotCounter]);
                                    style10Points[style10Counter++].style = 0;
                                    style10Points[style10Counter++] = new POINT2(pt2);
                                    break;
                                }
                                vbPoints2[lFlotCounter].style = 9;
                                break;
                            }
                            default: {
                                vbPoints2[lFlotCounter].style = 0;
                            }
                        }
                        ++lFlotCounter;
                    }
                    switch (lineType) {
                        case 31132000: 
                        case 31132200: 
                        case 31132300: {
                            vbPoints2[lFlotCounter - 1].style = 10;
                            break;
                        }
                        default: {
                            vbPoints2[lFlotCounter - 1].style = 5;
                        }
                    }
                    k = 0;
                    points = null;
                    continue;
                }
                style10Points[style10Counter].x = vbPoints[2 * l];
                style10Points[style10Counter].y = vbPoints[2 * l + 1];
                style10Points[style10Counter++].style = 0;
                style10Points[style10Counter].x = vbPoints[2 * l + 2];
                style10Points[style10Counter].y = vbPoints[2 * l + 3];
                style10Points[style10Counter++].style = 5;
            }
            switch (lineType) {
                case 31132200: 
                case 31132300: {
                    break;
                }
                default: {
                    vbPoints = null;
                    return lFlotCounter;
                }
            }
            for (j = 0; j < style10Counter; ++j) {
                vbPoints2[lFlotCounter++] = new POINT2(style10Points[j]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetFlot2Double", new RendererException("Failed inside GetFlot2Double", exc));
        }
        return lFlotCounter;
    }

    private static int GetFlotSegment2(TGLight tg, int[] vbPoints, int segment, int[] points, ref<int[]> bFlip, ref<int[]> lDirection, ref<int[]> lLastDirection) {
        int nNumSegs = 0;
        try {
            int lineType = tg.get_LineType();
            int j = 0;
            double dDistance = 0.0;
            int m = 0;
            int lLocx = 0;
            int lLocy = 0;
            int lSegCounter = 0;
            double dAngle = 0.0;
            int[] arcpoints = new int[30];
            double dRemainder = 0.0;
            double dNum = 0.0;
            double dDen = 0.0;
            double dIncrement = 0.0;
            switch (lineType) {
                case 31132000: 
                case 31132100: {
                    dIncrement = arraysupport.getScaledSize(40.0, tg.get_LineThickness());
                    break;
                }
                case 31132200: 
                case 31132300: {
                    dIncrement = arraysupport.getScaledSize(60.0, tg.get_LineThickness());
                    break;
                }
                case 31133000: 
                case 31133100: {
                    dIncrement = arraysupport.getScaledSize(50.0, tg.get_LineThickness());
                    break;
                }
                case 31134000: 
                case 31134100: 
                case 31134200: 
                case 31134300: {
                    dIncrement = arraysupport.getScaledSize(80.0, tg.get_LineThickness());
                    break;
                }
                case 31133200: {
                    dIncrement = arraysupport.getScaledSize(80.0, tg.get_LineThickness());
                    break;
                }
                default: {
                    dIncrement = arraysupport.getScaledSize(20.0, tg.get_LineThickness());
                }
            }
            lSegCounter = 0;
            if (segment == 0 && vbPoints[0] >= vbPoints[2]) {
                ((int[])bFlip.value)[0] = lineType != 31134000 && lineType != 31134100 && lineType != 31134200 && lineType != 31134300 ? 1 : 0;
            }
            if (segment == 0 && vbPoints[0] < vbPoints[2]) {
                ((int[])bFlip.value)[0] = lineType != 31134000 && lineType != 31134100 && lineType != 31134200 && lineType != 31134300 ? 0 : 1;
            }
            dNum = vbPoints[2 * segment + 3] - vbPoints[2 * segment + 1];
            dDen = vbPoints[2 * segment + 2] - vbPoints[2 * segment];
            dAngle = dDen == 0.0 ? 1.5707963267948966 : Math.abs(Math.atan(dNum / dDen));
            dAngle = 57.29577951308232 * dAngle;
            if (vbPoints[2 * segment + 0] <= vbPoints[2 * segment + 2] && vbPoints[2 * segment + 1] >= vbPoints[2 * segment + 3]) {
                dAngle = 90.0 - dAngle;
            } else if (vbPoints[2 * segment + 0] <= vbPoints[2 * segment + 2] && vbPoints[2 * segment + 1] <= vbPoints[2 * segment + 3]) {
                dAngle += 90.0;
            } else if (vbPoints[2 * segment + 0] >= vbPoints[2 * segment + 2] && vbPoints[2 * segment + 1] <= vbPoints[2 * segment + 3]) {
                dAngle = 270.0 - dAngle;
            } else if (vbPoints[2 * segment + 0] >= vbPoints[2 * segment + 2] && vbPoints[2 * segment + 1] >= vbPoints[2 * segment + 3]) {
                dAngle = 270.0 + dAngle;
            }
            dDistance = lineutility.CalcDistance2(vbPoints[2 * segment], vbPoints[2 * segment + 1], vbPoints[2 * segment + 2], vbPoints[2 * segment + 3]);
            nNumSegs = (int)(dDistance / dIncrement);
            dRemainder = (double)nNumSegs * dIncrement - dDistance;
            dDistance += dRemainder;
            if (vbPoints[2 * segment] >= vbPoints[2 * segment + 2]) {
                dAngle += 90.0;
                ((int[])lDirection.value)[0] = 1;
            } else {
                dAngle -= 90.0;
                ((int[])lDirection.value)[0] = 0;
            }
            if (segment > 0 && ((int[])lDirection.value)[0] != ((int[])lLastDirection.value)[0]) {
                ((int[])bFlip.value)[0] = ((int[])bFlip.value)[0] == 1 ? 0 : 1;
            }
            if (((int[])bFlip.value)[0] == 1) {
                dAngle += 180.0;
            }
            for (m = 0; m < nNumSegs; ++m) {
                lLocx = (int)((double)vbPoints[2 * segment] + ((double)m + 0.5) * (double)(vbPoints[2 * segment + 2] - vbPoints[2 * segment]) * dIncrement / dDistance);
                lLocy = (int)((double)vbPoints[2 * segment + 1] + ((double)m + 0.5) * (double)(vbPoints[2 * segment + 3] - vbPoints[2 * segment + 1]) * dIncrement / dDistance);
                flot.CalcAnglePoints(lLocx, lLocy, dAngle, arcpoints, arraysupport.getScaledSize(10.0, tg.get_LineThickness()));
                for (j = 0; j < 30; ++j) {
                    points[lSegCounter] = arcpoints[j];
                    ++lSegCounter;
                }
            }
            ((int[])lLastDirection.value)[0] = ((int[])lDirection.value)[0];
            arcpoints = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetFlotSegment2", new RendererException("Failed inside GetFlotSegment2", exc));
        }
        return nNumSegs * 10;
    }

    protected static int GetOFYCountDouble(POINT2[] pLinePoints, double interval, int numPts) {
        int lTotalpts = 0;
        try {
            int j = 0;
            int lNumSegs = 0;
            int lNumFlots = 0;
            int lNumSpikes = 0;
            double dDistance = 0.0;
            int nFactor = 7;
            for (j = 0; j < numPts - 1; ++j) {
                dDistance = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                lNumFlots = lNumSegs = (int)(dDistance / interval);
                lNumSpikes = lNumSegs;
                if (lNumFlots < 1) {
                    lNumFlots = 1;
                }
                if (lNumSpikes < 1) {
                    lNumSpikes = 1;
                }
                lTotalpts += lNumFlots * 18;
                lTotalpts += lNumSpikes * nFactor;
            }
            if (lTotalpts < (nFactor + 15) * numPts) {
                lTotalpts = 25 * numPts;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetOFYCountDoulbe", new RendererException("Failed inside GetOFYCountDouble", exc));
        }
        return lTotalpts;
    }

    protected static int GetOccludedPointsDouble(TGLight tg, POINT2[] pLinePoints, int numPts) {
        int nTotalCounter = 0;
        try {
            int lineType = tg.get_LineType();
            int j = 0;
            int k = 0;
            int lNumSegs = 0;
            int l = 0;
            int lNumFlots = 0;
            int lNumSpikes = 0;
            double dDistance = 0.0;
            ref<double[]> m = new ref<double[]>();
            int lTotalPoints = 0;
            int[] points = null;
            POINT2[] pSpikePoints = null;
            POINT2 pt0 = new POINT2();
            POINT2 tempPoint = new POINT2();
            POINT2[] pFlotPoints = null;
            double dSpikeSize = arraysupport.getScaledSize(20.0, tg.get_LineThickness());
            double dIncrement = arraysupport.getScaledSize(50.0, tg.get_LineThickness());
            int[] vbPoints = null;
            int nFlotCounter = 0;
            int nSpikeCounter = 0;
            int[] flots = null;
            int sumOfFlots = 0;
            double segmentLength = 0.0;
            double spikeLength = 0.0;
            boolean bolTooLong = false;
            double d1 = 0.0;
            double d2 = 0.0;
            int bolVertical = 0;
            ref<int[]> bFlip = new ref<int[]>();
            ref<int[]> lDirection = new ref<int[]>();
            ref<int[]> lLastDirection = new ref<int[]>();
            m.value = new double[1];
            bFlip.value = new int[1];
            lDirection.value = new int[1];
            lLastDirection.value = new int[1];
            ((int[])bFlip.value)[0] = -1;
            ((int[])lDirection.value)[0] = -1;
            ((int[])lLastDirection.value)[0] = -1;
            lTotalPoints = flot.GetOccludedCountDouble(pLinePoints, numPts);
            vbPoints = new int[numPts * 2];
            pSpikePoints = new POINT2[3 * lTotalPoints / 13];
            pFlotPoints = new POINT2[10 * lTotalPoints / 13];
            int n = pSpikePoints.length;
            for (j = 0; j < n; ++j) {
                pSpikePoints[j] = new POINT2(pLinePoints[0]);
                pSpikePoints[j].style = 5;
            }
            n = pFlotPoints.length;
            for (j = 0; j < n; ++j) {
                pFlotPoints[j] = new POINT2(pLinePoints[0]);
                pFlotPoints[j].style = 5;
            }
            flots = new int[numPts + 1];
            for (j = 0; j < numPts; ++j) {
                vbPoints[k] = (int)pLinePoints[j].x;
                vbPoints[++k] = (int)pLinePoints[j].y;
                ++k;
            }
            k = 0;
            flots[0] = 0;
            for (j = 0; j < numPts; ++j) {
                flots[j + 1] = 0;
            }
            for (j = 0; j < numPts - 1; ++j) {
                bolVertical = lineutility.CalcTrueSlopeDouble(pLinePoints[j], pLinePoints[j + 1], m);
                ((double[])m.value)[0] = -((double[])m.value)[0];
                dDistance = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                lNumFlots = lNumSegs = (int)(dDistance / dIncrement);
                lNumSpikes = lNumSegs;
                flots[j + 1] = lNumSegs;
                k = 0;
                if (lNumFlots > 0) {
                    points = new int[lNumFlots * 30];
                    flot.GetFlotSegment2(tg, vbPoints, j, points, bFlip, lDirection, lLastDirection);
                    for (l = 0; l < lNumFlots * 10; ++l) {
                        pFlotPoints[nFlotCounter].x = points[k];
                        pFlotPoints[nFlotCounter].y = points[k + 1];
                        pFlotPoints[nFlotCounter].style = 9;
                        if (nFlotCounter % 10 == 0) {
                            d1 = lineutility.CalcDistanceDouble(pLinePoints[j], pFlotPoints[nFlotCounter]);
                            d2 = lineutility.CalcDistanceDouble(pLinePoints[j + 1], pFlotPoints[nFlotCounter]);
                            pFlotPoints[nFlotCounter] = d2 > d1 ? lineutility.ExtendLineDouble(pLinePoints[j + 1], pLinePoints[j], -d1) : lineutility.ExtendLineDouble(pLinePoints[j], pLinePoints[j + 1], -d2);
                            pFlotPoints[nFlotCounter].style = 9;
                            if ((long)lineType == 31133100L) {
                                pFlotPoints[nFlotCounter].style = 0;
                            }
                        }
                        if ((nFlotCounter + 1) % 10 == 0) {
                            if ((long)lineType == 31133000L || (long)lineType == 31133100L) {
                                d1 = lineutility.CalcDistanceDouble(pLinePoints[j], pFlotPoints[nFlotCounter - 9]);
                                d2 = lineutility.CalcDistanceDouble(pLinePoints[j + 1], pFlotPoints[nFlotCounter - 9]);
                                pFlotPoints[nFlotCounter] = d2 > d1 ? lineutility.ExtendLineDouble(pLinePoints[j + 1], pLinePoints[j], -d1 - dSpikeSize) : lineutility.ExtendLineDouble(pLinePoints[j], pLinePoints[j + 1], -d2 + dSpikeSize);
                                if ((long)lineType == 31133000L) {
                                    pFlotPoints[nFlotCounter].style = 10;
                                }
                                if ((long)lineType == 31133100L) {
                                    pFlotPoints[nFlotCounter].style = 5;
                                }
                            }
                            if ((long)lineType == 31134000L) {
                                pFlotPoints[nFlotCounter].style = 23;
                            }
                        }
                        k += 3;
                        ++nFlotCounter;
                    }
                    points = null;
                }
                segmentLength = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                for (k = 0; k < lNumSpikes - 1; ++k) {
                    bolTooLong = false;
                    sumOfFlots = 0;
                    for (l = 0; l <= j; ++l) {
                        sumOfFlots += flots[l];
                    }
                    d1 = lineutility.CalcDistanceDouble(pLinePoints[j], pFlotPoints[sumOfFlots * 10 + 10 * k]);
                    d2 = lineutility.CalcDistanceDouble(pLinePoints[j + 1], pFlotPoints[sumOfFlots * 10 + 10 * k]);
                    switch (lineType) {
                        case 31133000: 
                        case 31133100: {
                            if (d2 > d1) {
                                tempPoint = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], -d1 - dIncrement / 2.0, 0);
                                break;
                            }
                            tempPoint = lineutility.ExtendLine2Double(pLinePoints[j], pLinePoints[j + 1], -d2 + dIncrement / 2.0, 0);
                            break;
                        }
                        case 31134000: {
                            if (d2 > d1) {
                                tempPoint = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], -d1 - dIncrement / 8.0, 0);
                                break;
                            }
                            tempPoint = lineutility.ExtendLine2Double(pLinePoints[j], pLinePoints[j + 1], -d2 + dIncrement / 8.0, 0);
                            break;
                        }
                    }
                    spikeLength = lineutility.CalcDistanceDouble(pLinePoints[j], tempPoint);
                    if (spikeLength + dSpikeSize < segmentLength) {
                        pSpikePoints[nSpikeCounter] = new POINT2(tempPoint);
                    } else {
                        pSpikePoints[nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                        bolTooLong = true;
                    }
                    pSpikePoints[nSpikeCounter].style = 9;
                    d1 = lineutility.CalcDistanceDouble(pLinePoints[j], pSpikePoints[++nSpikeCounter - 1]);
                    d2 = lineutility.CalcDistanceDouble(pLinePoints[j + 1], pSpikePoints[nSpikeCounter - 1]);
                    pt0 = d1 > d2 ? lineutility.ExtendLineDouble(pLinePoints[j], pSpikePoints[nSpikeCounter - 1], dSpikeSize / 2.0) : lineutility.ExtendLineDouble(pLinePoints[j + 1], pSpikePoints[nSpikeCounter - 1], -dSpikeSize / 2.0);
                    if (!bolTooLong) {
                        if (bolVertical != 0) {
                            pSpikePoints[nSpikeCounter] = pLinePoints[j].x < pLinePoints[j + 1].x ? lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 2, dSpikeSize) : lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 3, dSpikeSize);
                            pSpikePoints[nSpikeCounter].style = 0;
                            ++nSpikeCounter;
                        } else {
                            pSpikePoints[nSpikeCounter].x = pLinePoints[j].y > pLinePoints[j + 1].y ? pt0.x - dSpikeSize : pt0.x + dSpikeSize;
                            pSpikePoints[nSpikeCounter].y = pt0.y;
                            ++nSpikeCounter;
                        }
                    } else {
                        pSpikePoints[nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                        ++nSpikeCounter;
                    }
                    pSpikePoints[nSpikeCounter - 1].style = 9;
                    if (!bolTooLong) {
                        d1 = lineutility.CalcDistanceDouble(pLinePoints[j], pSpikePoints[nSpikeCounter - 2]);
                        pSpikePoints[nSpikeCounter] = d1 > (d2 = lineutility.CalcDistanceDouble(pLinePoints[j + 1], pSpikePoints[nSpikeCounter - 2])) ? lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nSpikeCounter - 2], dSpikeSize, 0) : lineutility.ExtendLine2Double(pLinePoints[j + 1], pSpikePoints[nSpikeCounter - 2], -dSpikeSize, 0);
                        if ((long)lineType == 31133000L) {
                            pSpikePoints[nSpikeCounter].style = 10;
                        }
                        if ((long)lineType == 31133100L) {
                            pSpikePoints[nSpikeCounter].style = 5;
                        }
                        if ((long)lineType == 31134000L) {
                            pSpikePoints[nSpikeCounter].style = 24;
                        }
                    } else {
                        pSpikePoints[nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                        pSpikePoints[nSpikeCounter].style = 5;
                    }
                    ++nSpikeCounter;
                }
                if (nSpikeCounter == 0) {
                    pSpikePoints[nSpikeCounter] = new POINT2(pLinePoints[j]);
                    pSpikePoints[nSpikeCounter].style = 5;
                    pSpikePoints[++nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                    pSpikePoints[nSpikeCounter].style = 5;
                    pSpikePoints[++nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                    pSpikePoints[nSpikeCounter].style = 5;
                    ++nSpikeCounter;
                    continue;
                }
                pSpikePoints[nSpikeCounter] = new POINT2(pSpikePoints[nSpikeCounter - 1]);
                pSpikePoints[nSpikeCounter].style = 5;
                pSpikePoints[nSpikeCounter + 1] = new POINT2(pSpikePoints[nSpikeCounter - 1]);
                pSpikePoints[nSpikeCounter + 1].style = 5;
                pSpikePoints[nSpikeCounter + 2] = new POINT2(pSpikePoints[nSpikeCounter - 1]);
                pSpikePoints[nSpikeCounter + 2].style = 5;
                nSpikeCounter += 3;
            }
            for (j = 0; j < pLinePoints.length; ++j) {
                pLinePoints[j] = new POINT2(pSpikePoints[0]);
                pLinePoints[j].style = 5;
            }
            nFlotCounter = 0;
            nSpikeCounter = 0;
            for (j = 0; j < lTotalPoints / 13; ++j) {
                for (k = 0; k < 10; ++k) {
                    pLinePoints[nTotalCounter] = new POINT2(pFlotPoints[j * 10 + k]);
                    ++nTotalCounter;
                    ++nFlotCounter;
                }
                for (k = 0; k < 3; ++k) {
                    pLinePoints[nTotalCounter] = new POINT2(pSpikePoints[j * 3 + k]);
                    ++nTotalCounter;
                    ++nSpikeCounter;
                }
            }
            n = pLinePoints.length;
            for (j = nTotalCounter; j < n; ++j) {
                pLinePoints[j] = new POINT2(pLinePoints[nTotalCounter - 1]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetOccludedPointsDouble", new RendererException("Failed inside GetOccludedPointsDouble", exc));
        }
        return nTotalCounter;
    }

    protected static int GetOccludedCountDouble(POINT2[] pLinePoints, int numPts) {
        int lTotalpts = 0;
        try {
            int j = 0;
            int lNumSegs = 0;
            int lNumFlots = 0;
            int lNumSpikes = 0;
            double dDistance = 0.0;
            for (j = 0; j < numPts - 1; ++j) {
                dDistance = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                lNumFlots = lNumSegs = (int)(dDistance / 50.0);
                lNumSpikes = lNumSegs;
                if (lNumFlots < 1) {
                    lNumFlots = 1;
                }
                if (lNumSpikes < 1) {
                    lNumSpikes = 1;
                }
                lTotalpts += lNumFlots * 10;
                lTotalpts += lNumSpikes * 3;
            }
            if (lTotalpts < 13 * numPts) {
                lTotalpts = 13 * numPts;
            }
            if (lTotalpts < numPts) {
                lTotalpts = numPts;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetOccludedCountDouble", new RendererException("Failed inside GetOccludedCountDouble", exc));
        }
        return lTotalpts;
    }

    private static int CalcNewPoint(int locx, int locY, double angle, int[] point, double dist) {
        try {
            double m = 0.0;
            double deltaX = 0.0;
            double deltaY = 0.0;
            double dx = 0.0;
            double dy = 0.0;
            int nQuadrant = -1;
            if (angle < 0.0) {
                angle += 360.0;
            }
            if (angle > 360.0) {
                angle -= 360.0;
            }
            if (0.0 <= angle && angle <= 90.0) {
                nQuadrant = 0;
                angle = 90.0 - angle;
                angle = Math.abs(angle) * (Math.PI / 180);
            }
            if (90.0 < angle && angle <= 180.0) {
                nQuadrant = 1;
                angle -= 90.0;
                angle = Math.abs(angle) * (Math.PI / 180);
            }
            if (180.0 < angle && angle <= 270.0) {
                nQuadrant = 2;
                angle = 270.0 - angle;
                angle = Math.abs(angle) * (Math.PI / 180);
            }
            if (270.0 < angle && angle <= 360.0) {
                nQuadrant = 3;
                angle -= 270.0;
                angle = Math.abs(angle) * (Math.PI / 180);
            }
            m = Math.abs(Math.tan(angle));
            deltaX = Math.abs(dist / Math.sqrt(1.0 + m * m));
            deltaY = Math.abs(m * deltaX);
            switch (nQuadrant) {
                case 0: {
                    dx = (double)locx + deltaX;
                    dy = (double)locY - deltaY;
                    break;
                }
                case 1: {
                    dx = (double)locx + deltaX;
                    dy = (double)locY + deltaY;
                    break;
                }
                case 2: {
                    dx = (double)locx - deltaX;
                    dy = (double)locY + deltaY;
                    break;
                }
                case 3: {
                    dx = (double)locx - deltaX;
                    dy = (double)locY - deltaY;
                    break;
                }
            }
            point[0] = (int)dx;
            point[1] = (int)dy;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcNewPoint", new RendererException("Failed inside CalcNewPoint", exc));
        }
        return 1;
    }

    private static int GetFlotSegment(int[] vbPoints, int segment, int[] points, double flotDiameter, ref<int[]> bFlip, ref<int[]> lDirection, ref<int[]> lLastDirection) {
        int nNumSegs = 0;
        try {
            int j = 0;
            double dDistance = 0.0;
            int m = 0;
            int lLocx = 0;
            int lLocy = 0;
            int lSegCounter = 0;
            double dAngle = 0.0;
            int[] arcPoints = new int[30];
            double dRemainder = 0.0;
            double dNum = 0.0;
            double dDen = 0.0;
            lSegCounter = 0;
            if (segment == 0 && vbPoints[0] >= vbPoints[2]) {
                ((int[])bFlip.value)[0] = 1;
            }
            if (segment == 0 && vbPoints[0] < vbPoints[2]) {
                ((int[])bFlip.value)[0] = 0;
            }
            dNum = vbPoints[2 * segment + 3] - vbPoints[2 * segment + 1];
            dDen = vbPoints[2 * segment + 2] - vbPoints[2 * segment];
            dAngle = dDen == 0.0 ? 1.5707963267948966 : Math.abs(Math.atan(dNum / dDen));
            dAngle = 57.29577951308232 * dAngle;
            if (vbPoints[2 * segment + 0] <= vbPoints[2 * segment + 2] && vbPoints[2 * segment + 1] >= vbPoints[2 * segment + 3]) {
                dAngle = 90.0 - dAngle;
            } else if (vbPoints[2 * segment + 0] <= vbPoints[2 * segment + 2] && vbPoints[2 * segment + 1] <= vbPoints[2 * segment + 3]) {
                dAngle += 90.0;
            } else if (vbPoints[2 * segment + 0] >= vbPoints[2 * segment + 2] && vbPoints[2 * segment + 1] <= vbPoints[2 * segment + 3]) {
                dAngle = 270.0 - dAngle;
            } else if (vbPoints[2 * segment + 0] >= vbPoints[2 * segment + 2] && vbPoints[2 * segment + 1] >= vbPoints[2 * segment + 3]) {
                dAngle = 270.0 + dAngle;
            }
            dDistance = lineutility.CalcDistance2(vbPoints[2 * segment], vbPoints[2 * segment + 1], vbPoints[2 * segment + 2], vbPoints[2 * segment + 3]);
            nNumSegs = (int)(dDistance / flotDiameter);
            dRemainder = (double)nNumSegs * flotDiameter - dDistance;
            dDistance += dRemainder;
            if (vbPoints[2 * segment] >= vbPoints[2 * segment + 2]) {
                dAngle += 90.0;
                ((int[])lDirection.value)[0] = 1;
            } else {
                dAngle -= 90.0;
                ((int[])lDirection.value)[0] = 0;
            }
            if (segment > 0 && ((int[])lDirection.value)[0] != ((int[])lLastDirection.value)[0]) {
                ((int[])bFlip.value)[0] = ((int[])bFlip.value)[0] == 1 ? 0 : 1;
            }
            if (((int[])bFlip.value)[0] == 1) {
                dAngle += 180.0;
            }
            for (m = 0; m < nNumSegs; ++m) {
                lLocx = (int)((double)vbPoints[2 * segment] + ((double)m + 0.5) * (double)(vbPoints[2 * segment + 2] - vbPoints[2 * segment]) * flotDiameter / dDistance);
                lLocy = (int)((double)vbPoints[2 * segment + 1] + ((double)m + 0.5) * (double)(vbPoints[2 * segment + 3] - vbPoints[2 * segment + 1]) * flotDiameter / dDistance);
                flot.CalcAnglePoints(lLocx, lLocy, dAngle, arcPoints, dDistance / (double)(nNumSegs * 2));
                if (points == null) continue;
                for (j = 0; j < 30; ++j) {
                    points[lSegCounter] = arcPoints[j];
                    ++lSegCounter;
                }
            }
            ((int[])lLastDirection.value)[0] = ((int[])lDirection.value)[0];
            arcPoints = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetFlotSegment", new RendererException("Failed inside GetFlotSegment", exc));
        }
        return nNumSegs * 10;
    }

    protected static int GetFlotDouble(POINT2[] vbPoints2, double flotDiameter, int numPts) {
        int lFlotCounter = 0;
        try {
            ref<int[]> bFlip = new ref<int[]>();
            bFlip.value = new int[1];
            ((int[])bFlip.value)[0] = -1;
            ref<int[]> lDirection = new ref<int[]>();
            lDirection.value = new int[1];
            ((int[])lDirection.value)[0] = -1;
            ref<int[]> lLastDirection = new ref<int[]>();
            lLastDirection.value = new int[1];
            ((int[])lLastDirection.value)[0] = -1;
            int j = 0;
            int k = 0;
            int l = 0;
            int m = 0;
            int x1 = 0;
            int y1 = 0;
            int numSegPts = -1;
            int z = 0;
            int lFlotCount = 0;
            int lNumSegs = 0;
            double dDistance = 0.0;
            int[] vbPoints = null;
            int[] points = null;
            lFlotCount = flot.GetFlotCountDouble(vbPoints2, flotDiameter, numPts);
            vbPoints = new int[2 * numPts];
            for (j = 0; j < numPts; ++j) {
                vbPoints[k] = (int)vbPoints2[j].x;
                vbPoints[++k] = (int)vbPoints2[j].y;
                ++k;
            }
            k = 0;
            for (l = 0; l < numPts - 1; ++l) {
                dDistance = lineutility.CalcDistance2(vbPoints[m], vbPoints[m + 1], vbPoints[m + 2], vbPoints[m + 3]);
                m += 2;
                lNumSegs = (int)(dDistance / flotDiameter);
                if (lNumSegs > 0) {
                    points = new int[lNumSegs * 30];
                    numSegPts = flot.GetFlotSegment(vbPoints, l, points, flotDiameter, bFlip, lDirection, lLastDirection);
                    for (j = 0; j < numSegPts; ++j) {
                        x1 = points[k];
                        y1 = points[k + 1];
                        z = points[k + 2];
                        k += 3;
                        if (lFlotCounter >= lFlotCount) continue;
                        vbPoints2[lFlotCounter].x = x1;
                        vbPoints2[lFlotCounter].y = y1;
                        ++lFlotCounter;
                    }
                    k = 0;
                    points = null;
                    continue;
                }
                points = null;
                numSegPts = flot.GetFlotSegment(vbPoints, l, points, flotDiameter, bFlip, lDirection, lLastDirection);
                if (lFlotCounter >= lFlotCount) continue;
                vbPoints2[lFlotCounter].x = vbPoints[2 * l];
                vbPoints2[lFlotCounter].y = vbPoints[2 * l + 1];
                ++lFlotCounter;
            }
            int n = vbPoints2.length;
            for (j = lFlotCounter - 1; j < n; ++j) {
                vbPoints2[j].style = 5;
            }
            vbPoints = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetFlotDouble", new RendererException("Failed inside GetFlotDouble", exc));
        }
        return lFlotCounter;
    }

    private static int CalcAnglePoints(int locx, int locY, double angle, int[] points, double dist) {
        try {
            int j = 0;
            int k = 0;
            int[] lTemp = new int[2];
            for (j = 0; j < 10; ++j) {
                flot.CalcNewPoint(locx, locY, angle - 90.0 + (double)(20 * j), lTemp, dist);
                points[k] = lTemp[0];
                points[k + 1] = lTemp[1];
                k += 3;
            }
            lTemp = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcAnglePoints", new RendererException("Failed inside CalcAnglePoints", exc));
        }
        return 1;
    }

    protected static int GetFlotCountDouble(POINT2[] vbPoints, double flotDiameter, int numPts) {
        int lTotalpts = 0;
        try {
            int j = 0;
            int lNumSegs = 0;
            double dDistance = 0.0;
            POINT2[] vbPoints2 = null;
            vbPoints2 = new POINT2[numPts];
            for (j = 0; j < numPts; ++j) {
                vbPoints2[j] = vbPoints[j];
            }
            for (j = 0; j < numPts - 1; ++j) {
                dDistance = lineutility.CalcDistanceDouble(vbPoints2[j], vbPoints2[j + 1]);
                lNumSegs = (int)(dDistance / flotDiameter);
                if (lNumSegs > 0) {
                    lTotalpts += lNumSegs * 10;
                    continue;
                }
                ++lTotalpts;
            }
            ++lTotalpts;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetFlotCountDouble", new RendererException("Failed inside GetFlotCountDouble", exc));
        }
        return lTotalpts;
    }

    protected static int GetOFYPointsDouble(TGLight tg, POINT2[] pLinePoints, int numPts) {
        int nTotalCounter = 0;
        try {
            int j = 0;
            int k = 0;
            int lNumSegs = 0;
            int l = 0;
            int lNumFlots = 0;
            int lNumSpikes = 0;
            double dDistance = 0.0;
            ref<double[]> m = new ref<double[]>();
            int lTotalPoints = 0;
            int[] points = null;
            POINT2[] pSpikePoints = null;
            POINT2 pt0 = new POINT2();
            POINT2 tempPoint = new POINT2();
            POINT2[] pFlotPoints = null;
            POINT2[] pSegmentPoints = null;
            double dSpikeSize = arraysupport.getScaledSize(20.0, tg.get_LineThickness());
            double dIncrement = arraysupport.getScaledSize(80.0, tg.get_LineThickness());
            int[] vbPoints = null;
            int nFlotCounter = 0;
            int nSpikeCounter = 0;
            int nSegmentCounter = 0;
            int[] flots = null;
            double segmentLength = 0.0;
            double spikeLength = 0.0;
            boolean bolTooLong = false;
            double d1 = 0.0;
            double d2 = 0.0;
            int bolVertical = 0;
            POINT2[] pFlotStart = null;
            POINT2[] pFlotEnd = null;
            POINT2[] pSpikeStart = null;
            POINT2[] pSpikeEnd = null;
            int nSpikeEndCounter = 0;
            int nFlotEndCounter = 0;
            ref<int[]> bFlip = new ref<int[]>();
            ref<int[]> lDirection = new ref<int[]>();
            ref<int[]> lLastDirection = new ref<int[]>();
            m.value = new double[1];
            bFlip.value = new int[1];
            lDirection.value = new int[1];
            lLastDirection.value = new int[1];
            lTotalPoints = flot.GetOFYCountDouble(pLinePoints, dIncrement, numPts);
            vbPoints = new int[numPts * 2];
            pSpikePoints = new POINT2[lTotalPoints];
            pFlotPoints = new POINT2[lTotalPoints];
            pSegmentPoints = new POINT2[lTotalPoints];
            int n = pSpikePoints.length;
            for (j = 0; j < n; ++j) {
                pSpikePoints[j] = new POINT2(pLinePoints[0]);
                pSpikePoints[j].style = 5;
            }
            n = pFlotPoints.length;
            for (j = 0; j < n; ++j) {
                pFlotPoints[j] = new POINT2(pLinePoints[0]);
                pFlotPoints[j].style = 5;
            }
            lineutility.InitializePOINT2Array(pSegmentPoints);
            flots = new int[numPts + 1];
            for (j = 0; j < numPts; ++j) {
                vbPoints[k] = (int)pLinePoints[j].x;
                vbPoints[++k] = (int)pLinePoints[j].y;
                ++k;
            }
            k = 0;
            flots[0] = 0;
            for (j = 0; j < numPts; ++j) {
                flots[j + 1] = 0;
            }
            for (j = 0; j < numPts - 1; ++j) {
                nSpikeEndCounter = 0;
                nFlotEndCounter = 0;
                bolVertical = lineutility.CalcTrueSlopeDouble(pLinePoints[j], pLinePoints[j + 1], m);
                ((double[])m.value)[0] = -((double[])m.value)[0];
                dDistance = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                lNumFlots = lNumSegs = (int)(dDistance / dIncrement);
                lNumSpikes = lNumSegs;
                flots[j + 1] = lNumSegs;
                k = 0;
                if (lNumFlots > 0) {
                    points = new int[lNumFlots * 30];
                    pFlotStart = new POINT2[lNumFlots];
                    pFlotEnd = new POINT2[lNumFlots];
                    flot.GetFlotSegment2(tg, vbPoints, j, points, bFlip, lDirection, lLastDirection);
                    for (l = 0; l < lNumFlots * 10; ++l) {
                        pFlotPoints[nFlotCounter].x = points[k];
                        pFlotPoints[nFlotCounter].y = points[k + 1];
                        pFlotPoints[nFlotCounter].style = 9;
                        if (nFlotCounter % 10 == 0) {
                            pFlotStart[l / 10] = new POINT2(pFlotPoints[nFlotCounter]);
                            d1 = lineutility.CalcDistanceDouble(pLinePoints[j], pFlotPoints[nFlotCounter]);
                            d2 = lineutility.CalcDistanceDouble(pLinePoints[j + 1], pFlotPoints[nFlotCounter]);
                            pFlotPoints[nFlotCounter] = d2 > d1 ? lineutility.ExtendLineDouble(pLinePoints[j + 1], pLinePoints[j], -d1) : lineutility.ExtendLineDouble(pLinePoints[j], pLinePoints[j + 1], -d2);
                            pFlotPoints[nFlotCounter].style = 9;
                        }
                        if ((nFlotCounter + 1) % 10 == 0) {
                            pFlotEnd[l / 10] = new POINT2(pFlotPoints[nFlotCounter]);
                            ++nFlotEndCounter;
                            d1 = lineutility.CalcDistanceDouble(pLinePoints[j], pFlotPoints[nFlotCounter - 9]);
                            d2 = lineutility.CalcDistanceDouble(pLinePoints[j + 1], pFlotPoints[nFlotCounter - 9]);
                            pFlotPoints[nFlotCounter] = d2 > d1 ? lineutility.ExtendLineDouble(pLinePoints[j + 1], pLinePoints[j], -d1 - dSpikeSize) : lineutility.ExtendLineDouble(pLinePoints[j], pLinePoints[j + 1], -d2 + dSpikeSize);
                            pFlotPoints[nFlotCounter].style = 10;
                        }
                        k += 3;
                        ++nFlotCounter;
                    }
                    points = null;
                } else {
                    pSegmentPoints[nSegmentCounter] = new POINT2(pLinePoints[j]);
                    pSegmentPoints[nSegmentCounter++].style = 0;
                    pSegmentPoints[nSegmentCounter] = new POINT2(pLinePoints[j + 1]);
                    pSegmentPoints[nSegmentCounter++].style = 5;
                }
                segmentLength = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                pSpikeStart = new POINT2[lNumSpikes];
                pSpikeEnd = new POINT2[lNumSpikes];
                for (k = 0; k < lNumSpikes - 1; ++k) {
                    bolTooLong = false;
                    d1 = lineutility.CalcDistanceDouble(pFlotEnd[k], pFlotEnd[k + 1]);
                    tempPoint = lineutility.ExtendAlongLineDouble(pFlotEnd[k], pLinePoints[j + 1], d1 = d1 / 2.0 - dSpikeSize, 0);
                    spikeLength = lineutility.CalcDistanceDouble(pLinePoints[j], tempPoint);
                    if (spikeLength + dSpikeSize < segmentLength) {
                        pSpikePoints[nSpikeCounter] = new POINT2(tempPoint);
                        pSpikeStart[k] = new POINT2(tempPoint);
                    } else {
                        pSpikePoints[nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                        bolTooLong = true;
                    }
                    pSpikePoints[nSpikeCounter].style = 9;
                    pt0 = lineutility.ExtendAlongLineDouble(pSpikePoints[++nSpikeCounter - 1], pLinePoints[j + 1], dSpikeSize / 2.0);
                    if (!bolTooLong) {
                        if (bolVertical != 0) {
                            pSpikePoints[nSpikeCounter] = pLinePoints[j].x < pLinePoints[j + 1].x ? lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 2, dSpikeSize) : lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 3, dSpikeSize);
                            pSpikePoints[nSpikeCounter].style = 0;
                            ++nSpikeCounter;
                        } else {
                            pSpikePoints[nSpikeCounter].x = pLinePoints[j].y > pLinePoints[j + 1].y ? pt0.x - dSpikeSize : pt0.x + dSpikeSize;
                            pSpikePoints[nSpikeCounter].y = pt0.y;
                            ++nSpikeCounter;
                        }
                    } else {
                        pSpikePoints[nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                        ++nSpikeCounter;
                    }
                    pSpikePoints[nSpikeCounter - 1].style = 9;
                    if (!bolTooLong) {
                        d1 = lineutility.CalcDistanceDouble(pLinePoints[j], pSpikePoints[nSpikeCounter - 2]);
                        pSpikePoints[nSpikeCounter] = d1 > (d2 = lineutility.CalcDistanceDouble(pLinePoints[j + 1], pSpikePoints[nSpikeCounter - 2])) ? lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nSpikeCounter - 2], dSpikeSize, 0) : lineutility.ExtendLine2Double(pLinePoints[j + 1], pSpikePoints[nSpikeCounter - 2], -dSpikeSize, 0);
                        pSpikeEnd[k] = new POINT2(pSpikePoints[nSpikeCounter]);
                        ++nSpikeEndCounter;
                        pSpikePoints[nSpikeCounter].style = 10;
                    } else {
                        pSpikePoints[nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                        pSpikePoints[nSpikeCounter].style = 5;
                    }
                    ++nSpikeCounter;
                }
                if (nSpikeEndCounter == 0 && nFlotEndCounter == 1) {
                    pSegmentPoints[nSegmentCounter] = new POINT2(pLinePoints[j]);
                    pSegmentPoints[nSegmentCounter++].style = 0;
                    pSegmentPoints[nSegmentCounter] = new POINT2(pFlotStart[0]);
                    pSegmentPoints[nSegmentCounter++].style = 5;
                    pSegmentPoints[nSegmentCounter] = new POINT2(pLinePoints[j + 1]);
                    pSegmentPoints[nSegmentCounter++].style = 0;
                    pSegmentPoints[nSegmentCounter] = new POINT2(pFlotEnd[0]);
                    pSegmentPoints[nSegmentCounter++].style = 5;
                }
                for (l = 0; l < nSpikeEndCounter; ++l) {
                    if (l == 0) {
                        pSegmentPoints[nSegmentCounter] = new POINT2(pLinePoints[j]);
                        pSegmentPoints[nSegmentCounter++].style = 0;
                        pSegmentPoints[nSegmentCounter] = new POINT2(pFlotStart[0]);
                        pSegmentPoints[nSegmentCounter++].style = 5;
                    }
                    if (l == nSpikeEndCounter - 1) {
                        pSegmentPoints[nSegmentCounter] = new POINT2(pLinePoints[j + 1]);
                        pSegmentPoints[nSegmentCounter++].style = 0;
                        pSegmentPoints[nSegmentCounter] = new POINT2(pFlotEnd[l + 1]);
                        pSegmentPoints[nSegmentCounter++].style = 5;
                    }
                    pSegmentPoints[nSegmentCounter] = new POINT2(pSpikeEnd[l]);
                    pSegmentPoints[nSegmentCounter++].style = 0;
                    pSegmentPoints[nSegmentCounter] = new POINT2(pFlotStart[l + 1]);
                    pSegmentPoints[nSegmentCounter++].style = 5;
                    d1 = lineutility.CalcDistanceDouble(pSpikeStart[l], pFlotEnd[l]);
                    pSegmentPoints[nSegmentCounter++] = lineutility.ExtendAlongLineDouble(pSpikeStart[l], pLinePoints[j], d1 / 3.0, 0);
                    pSegmentPoints[nSegmentCounter++] = lineutility.ExtendAlongLineDouble(pSpikeStart[l], pLinePoints[j], 2.0 * d1 / 3.0, 5);
                    tempPoint = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pSegmentPoints[nSegmentCounter - 2], 2, arraysupport.getScaledSize(5.0, tg.get_LineThickness()), 0);
                    pSegmentPoints[nSegmentCounter++] = new POINT2(tempPoint);
                    tempPoint = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pSegmentPoints[nSegmentCounter - 2], 3, arraysupport.getScaledSize(5.0, tg.get_LineThickness()), 5);
                    pSegmentPoints[nSegmentCounter++] = new POINT2(tempPoint);
                }
                if (nSpikeCounter == 0) {
                    pSpikePoints[nSpikeCounter] = new POINT2(pLinePoints[j]);
                    pSpikePoints[nSpikeCounter].style = 5;
                    pSpikePoints[++nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                    pSpikePoints[nSpikeCounter].style = 5;
                    pSpikePoints[++nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                    pSpikePoints[nSpikeCounter].style = 5;
                    ++nSpikeCounter;
                    continue;
                }
                pSpikePoints[nSpikeCounter] = new POINT2(pSpikePoints[nSpikeCounter - 1]);
                pSpikePoints[nSpikeCounter].style = 5;
                pSpikePoints[nSpikeCounter + 1] = new POINT2(pSpikePoints[nSpikeCounter - 1]);
                pSpikePoints[nSpikeCounter + 1].style = 5;
                pSpikePoints[nSpikeCounter + 2] = new POINT2(pSpikePoints[nSpikeCounter - 1]);
                pSpikePoints[nSpikeCounter + 2].style = 5;
                nSpikeCounter += 3;
            }
            nTotalCounter = 0;
            for (j = 0; j < nFlotCounter; ++j) {
                pLinePoints[nTotalCounter++] = new POINT2(pFlotPoints[j]);
            }
            for (j = 0; j < nSpikeCounter; ++j) {
                pLinePoints[nTotalCounter++] = new POINT2(pSpikePoints[j]);
            }
            for (j = 0; j < nSegmentCounter; ++j) {
                pLinePoints[nTotalCounter++] = new POINT2(pSegmentPoints[j]);
            }
            n = pLinePoints.length;
            for (j = nTotalCounter; j < n; ++j) {
                pLinePoints[j] = new POINT2(pLinePoints[nTotalCounter - 1]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetOFYPointsDouble", new RendererException("Failed inside GetOFYPointsDouble", exc));
        }
        return nTotalCounter;
    }

    protected static int GetSFPointsDouble(TGLight tg, POINT2[] pLinePoints, int numPts) {
        int nTotalCounter = 0;
        try {
            int lineType = tg.get_LineType();
            int lTotalPoints = 0;
            int j = 0;
            int k = 0;
            int lNumSegs = 0;
            int l = 0;
            int lNumFlots = 0;
            int lNumSpikes = 0;
            double dDistance = 0.0;
            ref<double[]> m = new ref<double[]>();
            int[] points = null;
            POINT2[] pSpikePoints = null;
            POINT2 pt0 = new POINT2();
            POINT2 tempPoint = new POINT2();
            POINT2[] pFlotPoints = null;
            double dSpikeSize = arraysupport.getScaledSize(20.0, tg.get_LineThickness());
            double dIncrement = arraysupport.getScaledSize(80.0, tg.get_LineThickness());
            int[] vbPoints = null;
            int nFlotCounter = 0;
            int nSpikeCounter = 0;
            int nSegCounter = 0;
            int[] flots = null;
            double segmentLength = 0.0;
            double spikeLength = 0.0;
            boolean bolTooLong = false;
            double d1 = 0.0;
            double d2 = 0.0;
            int bolVertical = 0;
            POINT2[] pFlotStart = null;
            POINT2[] pFlotEnd = null;
            POINT2[] pSpikeStart = null;
            POINT2[] pSpikeEnd = null;
            POINT2[] pSegPoints = null;
            ref<int[]> bFlip = new ref<int[]>();
            ref<int[]> lDirection = new ref<int[]>();
            ref<int[]> lLastDirection = new ref<int[]>();
            lTotalPoints = flot.GetSFCountDouble(pLinePoints, numPts);
            m.value = new double[1];
            lDirection.value = new int[1];
            ((int[])lDirection.value)[0] = -1;
            lLastDirection.value = new int[1];
            ((int[])lLastDirection.value)[0] = -1;
            bFlip.value = new int[1];
            ((int[])bFlip.value)[0] = -1;
            vbPoints = new int[numPts * 2];
            pSpikePoints = new POINT2[lTotalPoints];
            pFlotPoints = new POINT2[lTotalPoints];
            int n = pSpikePoints.length;
            for (j = 0; j < n; ++j) {
                pSpikePoints[j] = new POINT2(pLinePoints[0]);
                pSpikePoints[j].style = 5;
            }
            n = pFlotPoints.length;
            for (j = 0; j < n; ++j) {
                pFlotPoints[j] = new POINT2(pLinePoints[0]);
                pFlotPoints[j].style = 5;
            }
            pSegPoints = new POINT2[4 * (numPts - 1)];
            lineutility.InitializePOINT2Array(pSegPoints);
            flots = new int[numPts + 1];
            for (j = 0; j < numPts; ++j) {
                vbPoints[k] = (int)pLinePoints[j].x;
                vbPoints[++k] = (int)pLinePoints[j].y;
                ++k;
            }
            k = 0;
            flots[0] = 0;
            for (j = 0; j < numPts; ++j) {
                flots[j + 1] = 0;
            }
            for (j = 0; j < numPts - 1; ++j) {
                bolVertical = lineutility.CalcTrueSlopeDouble(pLinePoints[j], pLinePoints[j + 1], m);
                ((double[])m.value)[0] = -((double[])m.value)[0];
                dDistance = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                lNumFlots = lNumSegs = (int)(dDistance / dIncrement);
                lNumSpikes = lNumSegs;
                flots[j + 1] = lNumSegs;
                k = 0;
                if (lNumFlots > 0) {
                    points = new int[lNumFlots * 30];
                    pFlotStart = new POINT2[lNumFlots];
                    lineutility.InitializePOINT2Array(pFlotStart);
                    pFlotEnd = new POINT2[lNumFlots];
                    lineutility.InitializePOINT2Array(pFlotEnd);
                    flot.GetFlotSegment2(tg, vbPoints, j, points, bFlip, lDirection, lLastDirection);
                    for (l = 0; l < lNumFlots * 10; ++l) {
                        pFlotPoints[nFlotCounter].x = points[k];
                        pFlotPoints[nFlotCounter].y = points[k + 1];
                        pFlotPoints[nFlotCounter].style = lineType == 31134100 || lineType == 31134000 ? 19 : 9;
                        if (nFlotCounter % 10 == 0) {
                            pFlotStart[l / 10] = pFlotPoints[nFlotCounter];
                            d1 = lineutility.CalcDistanceDouble(pLinePoints[j], pFlotPoints[nFlotCounter]);
                            d2 = lineutility.CalcDistanceDouble(pLinePoints[j + 1], pFlotPoints[nFlotCounter]);
                            pFlotPoints[nFlotCounter] = d2 > d1 ? lineutility.ExtendLineDouble(pLinePoints[j + 1], pLinePoints[j], -d1) : lineutility.ExtendLineDouble(pLinePoints[j], pLinePoints[j + 1], -d2);
                            pFlotPoints[nFlotCounter].style = lineType == 31134100 || lineType == 31134000 ? 19 : 9;
                        }
                        if ((nFlotCounter + 1) % 10 == 0) {
                            pFlotPoints[nFlotCounter].style = lineType == 31134100 || lineType == 31134000 ? 5 : 23;
                            pFlotEnd[l / 10] = new POINT2(pFlotPoints[nFlotCounter]);
                        }
                        if (l == 0) {
                            pSegPoints[nSegCounter] = new POINT2(pLinePoints[j]);
                            pSegPoints[nSegCounter++].style = 19;
                            pSegPoints[nSegCounter] = new POINT2(pFlotStart[l]);
                            pSegPoints[nSegCounter++].style = 5;
                        }
                        if (l == lNumFlots * 10 - 1) {
                            pSegPoints[nSegCounter] = new POINT2(pLinePoints[j + 1]);
                            pSegPoints[nSegCounter++].style = 19;
                            pSegPoints[nSegCounter] = new POINT2(pFlotStart[l / 10]);
                            pSegPoints[nSegCounter++].style = 5;
                        }
                        k += 3;
                        ++nFlotCounter;
                    }
                    points = null;
                } else {
                    pSegPoints[nSegCounter] = new POINT2(pLinePoints[j]);
                    pSegPoints[nSegCounter++].style = 0;
                    pSegPoints[nSegCounter] = new POINT2(pLinePoints[j + 1]);
                    pSegPoints[nSegCounter++].style = 5;
                }
                segmentLength = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                pSpikeStart = new POINT2[lNumSpikes];
                lineutility.InitializePOINT2Array(pSpikeStart);
                pSpikeEnd = new POINT2[lNumSpikes];
                lineutility.InitializePOINT2Array(pSpikeEnd);
                for (k = 0; k < lNumSpikes - 1; ++k) {
                    bolTooLong = false;
                    d1 = lineutility.CalcDistanceDouble(pFlotStart[k], pFlotStart[k + 1]);
                    tempPoint = lineutility.ExtendAlongLineDouble(pFlotStart[k], pLinePoints[j + 1], d1 = d1 / 2.0 - dSpikeSize, 0);
                    spikeLength = lineutility.CalcDistanceDouble(pLinePoints[j], tempPoint);
                    if (spikeLength + dSpikeSize < segmentLength) {
                        pSpikePoints[nSpikeCounter] = new POINT2(tempPoint);
                        pSpikeStart[k] = new POINT2(tempPoint);
                    } else {
                        pSpikePoints[nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                        bolTooLong = true;
                    }
                    pSpikePoints[nSpikeCounter].style = lineType == 31134100 || lineType == 31134000 ? 25 : 9;
                    pt0 = lineutility.ExtendAlongLineDouble(pSpikePoints[++nSpikeCounter - 1], pLinePoints[j + 1], dSpikeSize / 2.0);
                    if (!bolTooLong) {
                        if (bolVertical != 0) {
                            pSpikePoints[nSpikeCounter] = pLinePoints[j].x < pLinePoints[j + 1].x ? lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 2, dSpikeSize) : lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 3, dSpikeSize);
                            pSpikePoints[nSpikeCounter].style = 0;
                            ++nSpikeCounter;
                        } else {
                            pSpikePoints[nSpikeCounter].x = pLinePoints[j].y > pLinePoints[j + 1].y ? pt0.x - dSpikeSize : pt0.x + dSpikeSize;
                            pSpikePoints[nSpikeCounter].y = pt0.y;
                            ++nSpikeCounter;
                        }
                    } else {
                        pSpikePoints[nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                        ++nSpikeCounter;
                    }
                    pSpikePoints[nSpikeCounter - 1].style = lineType == 31134100 || lineType == 31134000 ? 25 : 9;
                    if (!bolTooLong) {
                        pSpikePoints[nSpikeCounter] = lineutility.ExtendAlongLineDouble(pSpikePoints[nSpikeCounter - 2], pLinePoints[j + 1], dSpikeSize);
                        pSpikePoints[nSpikeCounter].style = lineType == 31134100 || lineType == 31134000 ? 5 : 24;
                        pSpikeEnd[k] = new POINT2(pSpikePoints[nSpikeCounter]);
                    } else {
                        pSpikePoints[nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                        pSpikePoints[nSpikeCounter].style = 5;
                    }
                    ++nSpikeCounter;
                    if ((long)lineType == 31134000L || (long)lineType == 31134100L) {
                        d1 = lineutility.CalcDistanceDouble(pFlotStart[k], pSpikeStart[k]);
                        pSpikePoints[nSpikeCounter] = new POINT2(pFlotStart[k]);
                        pSpikePoints[nSpikeCounter++].style = 19;
                        pSpikePoints[nSpikeCounter++] = lineutility.ExtendAlongLineDouble(pFlotStart[k], pLinePoints[j + 1], d1 / 2.0, 5);
                        pSpikePoints[nSpikeCounter] = new POINT2(pFlotEnd[k]);
                        pSpikePoints[nSpikeCounter++].style = 19;
                        pSpikePoints[nSpikeCounter++] = lineutility.ExtendAlongLineDouble(pFlotEnd[k], pLinePoints[j], d1 / 2.0, 5);
                        if (k == lNumSpikes - 2) {
                            pSpikePoints[nSpikeCounter] = new POINT2(pFlotStart[k + 1]);
                            pSpikePoints[nSpikeCounter++].style = 19;
                            pSpikePoints[nSpikeCounter++] = lineutility.ExtendAlongLineDouble(pFlotStart[k + 1], pLinePoints[j + 1], d1 / 2.0, 5);
                            pSpikePoints[nSpikeCounter] = new POINT2(pFlotEnd[k + 1]);
                            pSpikePoints[nSpikeCounter++].style = 19;
                            pSpikePoints[nSpikeCounter++] = lineutility.ExtendAlongLineDouble(pFlotEnd[k + 1], pLinePoints[j], d1 / 2.0, 5);
                        }
                        pSpikePoints[nSpikeCounter] = new POINT2(pSpikeStart[k]);
                        pSpikePoints[nSpikeCounter++].style = 25;
                        pSpikePoints[nSpikeCounter++] = lineutility.ExtendAlongLineDouble(pSpikeStart[k], pLinePoints[j], d1 / 2.0, 5);
                        pSpikePoints[nSpikeCounter] = new POINT2(pSpikeEnd[k]);
                        pSpikePoints[nSpikeCounter++].style = 25;
                        pSpikePoints[nSpikeCounter++] = lineutility.ExtendAlongLineDouble(pSpikeEnd[k], pLinePoints[j + 1], d1 / 2.0, 5);
                        if ((long)lineType == 31134100L) {
                            pSpikePoints[nSpikeCounter] = new POINT2(pFlotEnd[k]);
                            pSpikePoints[nSpikeCounter++].style = 19;
                            pSpikePoints[nSpikeCounter] = new POINT2(pFlotStart[k]);
                            pSpikePoints[nSpikeCounter++].style = 5;
                            if (k == lNumSpikes - 2) {
                                pSpikePoints[nSpikeCounter] = new POINT2(pFlotEnd[k + 1]);
                                pSpikePoints[nSpikeCounter++].style = 19;
                                pSpikePoints[nSpikeCounter] = new POINT2(pFlotStart[k + 1]);
                                pSpikePoints[nSpikeCounter++].style = 5;
                            }
                            pSpikePoints[nSpikeCounter] = new POINT2(pSpikeEnd[k]);
                            pSpikePoints[nSpikeCounter++].style = 25;
                            pSpikePoints[nSpikeCounter] = new POINT2(pSpikeStart[k]);
                            pSpikePoints[nSpikeCounter++].style = 5;
                        }
                    }
                    if ((long)lineType == 31134200L) {
                        pSpikePoints[nSpikeCounter++] = lineutility.ExtendAlongLineDouble(pSpikeStart[k], pLinePoints[j], dSpikeSize / 2.0, 22);
                        pSpikePoints[nSpikeCounter++] = lineutility.ExtendAlongLineDouble(pSpikeEnd[k], pLinePoints[j + 1], dSpikeSize / 2.0, 20);
                    }
                    if ((long)lineType != 31134300L) continue;
                    d1 = lineutility.CalcDistanceDouble(pFlotStart[k], pSpikeStart[k]);
                    pSpikePoints[nSpikeCounter] = lineutility.ExtendAlongLineDouble(pSpikeStart[k], pLinePoints[j], d1 / 4.0);
                    pSpikePoints[nSpikeCounter].style = 25;
                    pSpikePoints[nSpikeCounter + 1] = lineutility.ExtendAlongLineDouble(pSpikeStart[k], pLinePoints[j], d1 / 2.0);
                    pSpikePoints[nSpikeCounter + 1].style = 5;
                    pSpikePoints[nSpikeCounter + 2] = lineutility.ExtendAlongLineDouble(pSpikeStart[k], pLinePoints[j], d1 / 2.0);
                    pSpikePoints[nSpikeCounter + 2].style = 19;
                    pSpikePoints[nSpikeCounter + 3] = lineutility.ExtendAlongLineDouble(pSpikeStart[k], pLinePoints[j], 3.0 * d1 / 4.0);
                    pSpikePoints[nSpikeCounter + 3].style = 5;
                    pSpikePoints[nSpikeCounter + 4] = lineutility.ExtendDirectedLine(pSpikePoints[nSpikeCounter], pLinePoints[j], pSpikePoints[nSpikeCounter], 2, arraysupport.getScaledSize(5.0, tg.get_LineThickness()), 25);
                    pSpikePoints[nSpikeCounter + 5] = lineutility.ExtendDirectedLine(pSpikePoints[nSpikeCounter + 3], pLinePoints[j], pSpikePoints[nSpikeCounter + 3], 3, arraysupport.getScaledSize(5.0, tg.get_LineThickness()), 5);
                    d1 = lineutility.CalcDistanceDouble(pFlotEnd[k + 1], pSpikeEnd[k]);
                    pSpikePoints[nSpikeCounter += 6] = lineutility.ExtendAlongLineDouble(pSpikeEnd[k], pLinePoints[j + 1], d1 / 4.0);
                    pSpikePoints[nSpikeCounter].style = 25;
                    pSpikePoints[nSpikeCounter + 1] = lineutility.ExtendAlongLineDouble(pSpikeEnd[k], pLinePoints[j + 1], d1 / 2.0);
                    pSpikePoints[nSpikeCounter + 1].style = 5;
                    pSpikePoints[nSpikeCounter + 2] = lineutility.ExtendAlongLineDouble(pSpikeEnd[k], pLinePoints[j + 1], d1 / 2.0);
                    pSpikePoints[nSpikeCounter + 2].style = 19;
                    pSpikePoints[nSpikeCounter + 3] = lineutility.ExtendAlongLineDouble(pSpikeEnd[k], pLinePoints[j + 1], 3.0 * d1 / 4.0);
                    pSpikePoints[nSpikeCounter + 3].style = 5;
                    pSpikePoints[nSpikeCounter + 4] = lineutility.ExtendDirectedLine(pSpikePoints[nSpikeCounter], pLinePoints[j + 1], pSpikePoints[nSpikeCounter], 3, arraysupport.getScaledSize(5.0, tg.get_LineThickness()), 19);
                    pSpikePoints[nSpikeCounter + 5] = lineutility.ExtendDirectedLine(pSpikePoints[nSpikeCounter + 3], pLinePoints[j + 1], pSpikePoints[nSpikeCounter + 3], 2, arraysupport.getScaledSize(5.0, tg.get_LineThickness()), 5);
                    nSpikeCounter += 6;
                }
                if (nSpikeCounter == 0) {
                    pSpikePoints[nSpikeCounter] = new POINT2(pLinePoints[j]);
                    pSpikePoints[nSpikeCounter].style = 5;
                    pSpikePoints[++nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                    pSpikePoints[nSpikeCounter].style = 5;
                    pSpikePoints[++nSpikeCounter] = new POINT2(pLinePoints[j + 1]);
                    pSpikePoints[nSpikeCounter].style = 5;
                    ++nSpikeCounter;
                    continue;
                }
                pSpikePoints[nSpikeCounter] = new POINT2(pSpikePoints[nSpikeCounter - 1]);
                pSpikePoints[nSpikeCounter].style = 5;
                pSpikePoints[nSpikeCounter + 1] = new POINT2(pSpikePoints[nSpikeCounter - 1]);
                pSpikePoints[nSpikeCounter + 1].style = 5;
                pSpikePoints[nSpikeCounter + 2] = new POINT2(pSpikePoints[nSpikeCounter - 1]);
                pSpikePoints[nSpikeCounter + 2].style = 5;
                nSpikeCounter += 3;
            }
            n = pLinePoints.length;
            for (j = 0; j < n; ++j) {
                pLinePoints[j] = new POINT2(pSpikePoints[0]);
                pLinePoints[j].style = 5;
            }
            nTotalCounter = 0;
            for (j = 0; j < nFlotCounter; ++j) {
                pLinePoints[nTotalCounter++] = new POINT2(pFlotPoints[j]);
            }
            for (j = 0; j < nSpikeCounter; ++j) {
                pLinePoints[nTotalCounter++] = new POINT2(pSpikePoints[j]);
            }
            for (j = 0; j < nSegCounter; ++j) {
                pLinePoints[nTotalCounter++] = new POINT2(pSegPoints[j]);
            }
            n = pLinePoints.length;
            for (j = nTotalCounter; j < n; ++j) {
                pLinePoints[j] = new POINT2(pLinePoints[nTotalCounter - 1]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSFPointsDouble", new RendererException("Failed inside GetSFPointsDouble", exc));
        }
        return nTotalCounter;
    }

    protected static int GetSFCountDouble(POINT2[] pLinePoints, int numPts) {
        int lTotalpts = 0;
        try {
            int j = 0;
            int lNumSegs = 0;
            int lNumFlots = 0;
            int lNumSpikes = 0;
            double dDistance = 0.0;
            for (j = 0; j < numPts - 1; ++j) {
                dDistance = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                lNumFlots = lNumSegs = (int)(dDistance / 80.0);
                lNumSpikes = lNumSegs;
                if (lNumFlots < 1) {
                    lNumFlots = 1;
                }
                if (lNumSpikes < 1) {
                    lNumSpikes = 1;
                }
                lTotalpts += lNumFlots * 10;
                lTotalpts += lNumSpikes * 3;
                lTotalpts += lNumSegs * 16;
                lTotalpts += numPts * 4;
            }
            if (lTotalpts < 25 * numPts) {
                lTotalpts = 25 * numPts;
            }
            if (lTotalpts < numPts) {
                lTotalpts = numPts;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSFCountDouble", new RendererException("Failed inside GetSFCountDouble", exc));
        }
        return lTotalpts;
    }
}

