/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.IPointConversion;
import java.awt.Point;
import java.awt.geom.Point2D;

public class PointConversion
implements IPointConversion {
    int _pixelWidth = 0;
    int _PixelHeight = 0;
    double _geoTop = 0.0;
    double _geoLeft = 0.0;
    double _geoBottom = 0.0;
    double _geoRight = 0.0;
    boolean _normalize = true;
    double _pixelMultiplierX = 0.0;
    double _pixelMultiplierY = 0.0;

    public void set_normalize(boolean value) {
        this._normalize = value;
    }

    public PointConversion(int pixelWidth, int pixelHeight, double geoTop, double geoLeft, double geoBottom, double geoRight) {
        this.UpdateExtents(pixelWidth, pixelHeight, geoTop, geoLeft, geoBottom, geoRight);
    }

    public void UpdateExtents(int pixelWidth, int pixelHeight, double geoTop, double geoLeft, double geoBottom, double geoRight) {
        this._pixelWidth = pixelWidth;
        this._PixelHeight = pixelHeight;
        this._geoTop = geoTop;
        this._geoLeft = geoLeft;
        this._geoBottom = geoBottom;
        this._geoRight = geoRight;
        this._pixelMultiplierX = (this._geoRight - this._geoLeft) / (double)this._pixelWidth;
        this._pixelMultiplierY = (this._geoTop - this._geoBottom) / (double)this._PixelHeight;
        if (this._geoRight - this._geoLeft < -180.0) {
            this._pixelMultiplierX = (this._geoRight - this._geoLeft + 360.0) / (double)this._pixelWidth;
        }
        if (this._geoRight - this._geoLeft > 180.0) {
            this._pixelMultiplierX = (360.0 - (this._geoRight - this._geoLeft)) / (double)this._pixelWidth;
        }
        this._pixelMultiplierY = this._geoTop < this._geoBottom ? -Math.abs(this._pixelMultiplierY) : Math.abs(this._pixelMultiplierY);
    }

    public Point2D.Double PixelsToGeo(Point pixel) {
        Point2D.Double coords = new Point2D.Double();
        coords.x = (double)pixel.x * this._pixelMultiplierX + this._geoLeft;
        coords.y = this._geoTop - (double)pixel.y * this._pixelMultiplierY;
        if (coords.x > 180.0) {
            coords.x -= 360.0;
        }
        if (coords.x < -180.0) {
            coords.x += 360.0;
        }
        return coords;
    }

    public Point GeoToPixels(Point2D.Double coord) {
        Point pixel = new Point();
        double calcValue = coord.getX() - this._geoLeft;
        if (this._normalize) {
            if (calcValue < -180.0) {
                calcValue += 360.0;
            } else if (calcValue > 180.0) {
                calcValue -= 360.0;
            }
        }
        double temp = calcValue / this._pixelMultiplierX;
        pixel.x = (int)temp;
        temp = (this._geoTop - coord.y) / this._pixelMultiplierY;
        pixel.y = (int)temp;
        return pixel;
    }

    @Override
    public Point2D PixelsToGeo(Point2D pixel) {
        Point2D.Double coords = new Point2D.Double();
        coords.x = pixel.getX() * this._pixelMultiplierX + this._geoLeft;
        coords.y = this._geoTop - pixel.getY() * this._pixelMultiplierY;
        if (coords.x < -180.0) {
            coords.x += 360.0;
        }
        if (coords.x > 180.0) {
            coords.x -= 360.0;
        }
        return coords;
    }

    @Override
    public Point2D GeoToPixels(Point2D coord) {
        double temp;
        Point2D.Double pixel = new Point2D.Double();
        double calcValue = coord.getX() - this._geoLeft;
        if (this._normalize) {
            if (calcValue < -180.0) {
                calcValue += 360.0;
            } else if (calcValue > 180.0) {
                calcValue -= 360.0;
            }
        }
        pixel.x = temp = calcValue / this._pixelMultiplierX;
        pixel.y = temp = (this._geoTop - coord.getY()) / this._pixelMultiplierY;
        return pixel;
    }

    public int getPixelWidth() {
        return this._pixelWidth;
    }

    public int getPixelHeight() {
        return this._PixelHeight;
    }

    public double getUpperLat() {
        return this._geoTop;
    }

    public double getLowerLat() {
        return this._geoBottom;
    }

    public double getLeftLon() {
        return this._geoLeft;
    }

    public double getRightLon() {
        return this._geoRight;
    }
}

