/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.RenderMultipoints;

import armyc2.c5isr.JavaLineArray.POINT2;
import armyc2.c5isr.JavaLineArray.Shape2;
import armyc2.c5isr.JavaLineArray.lineutility;
import armyc2.c5isr.JavaTacticalRenderer.TGLight;
import armyc2.c5isr.JavaTacticalRenderer.clsMETOC;
import armyc2.c5isr.RenderMultipoints.clsUtility;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.RendererException;
import armyc2.c5isr.renderer.utilities.ShapeInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;

public final class clsUtilityGE {
    private static final String _className = "clsUtilityGE";

    protected static void setSplineLinetype(TGLight tg) {
        switch (tg.get_LineType()) {
            case 22623000: {
                tg.set_LineType(22623001);
                break;
            }
            case 22612000: {
                tg.set_LineType(22612001);
                break;
            }
            case 32164000: {
                tg.set_LineType(32164001);
                break;
            }
            case 32163000: {
                tg.set_LineType(32163001);
                break;
            }
            case 32156000: {
                tg.set_LineType(32156001);
                break;
            }
            case 32162000: {
                tg.set_LineType(32162001);
                break;
            }
            case 31430000: {
                tg.set_LineType(31430001);
                break;
            }
            case 31440000: {
                tg.set_LineType(31440001);
                break;
            }
            case 32273000: {
                tg.set_LineType(32273001);
                break;
            }
            case 32272000: {
                tg.set_LineType(32272001);
                break;
            }
            case 32234300: {
                tg.set_LineType(32234301);
                break;
            }
            case 32234200: {
                tg.set_LineType(32234201);
                break;
            }
            case 32234100: {
                tg.set_LineType(32234101);
                break;
            }
            case 32233700: {
                tg.set_LineType(32233701);
                break;
            }
            case 32233600: {
                tg.set_LineType(32233601);
                break;
            }
            case 32231700: {
                tg.set_LineType(32231701);
                break;
            }
            case 32221000: {
                tg.set_LineType(32221001);
                break;
            }
            case 32213000: {
                tg.set_LineType(32213001);
                break;
            }
            case 32212000: {
                tg.set_LineType(32212001);
                break;
            }
            case 32161000: {
                tg.set_LineType(32161001);
                break;
            }
            case 32155000: {
                tg.set_LineType(32155001);
                break;
            }
            case 32154000: {
                tg.set_LineType(32154001);
                break;
            }
            case 31830000: {
                tg.set_LineType(31830001);
                break;
            }
            case 31820000: {
                tg.set_LineType(31820001);
                break;
            }
            case 31810000: {
                tg.set_LineType(31810001);
                break;
            }
            case 31850000: {
                tg.set_LineType(31850001);
                break;
            }
            case 31840000: {
                tg.set_LineType(31840001);
                break;
            }
            case 31860000: {
                tg.set_LineType(31860001);
                break;
            }
        }
    }

    private static void createDashedPolylines(ArrayList<ArrayList<Point2D>> polylines, ShapeInfo shape) {
        try {
            if (shape.getLineColor() == null) {
                return;
            }
            BasicStroke stroke = shape.getStroke();
            float[] dash = stroke.getDashArray();
            if (dash == null || dash.length < 2) {
                return;
            }
            ArrayList<ArrayList<Point2D>> dashedPolylines = new ArrayList<ArrayList<Point2D>>();
            for (ArrayList<Point2D> polyline : polylines) {
                int dashIndex = 0;
                double remainingInIndex = dash[dashIndex];
                block3: for (int i = 0; i < polyline.size() - 1; ++i) {
                    Point2D segStartPt = polyline.get(i);
                    Point2D segEndPt = polyline.get(i + 1);
                    while (true) {
                        double d;
                        double segLength = lineutility.CalcDistanceDouble(segStartPt, segEndPt);
                        if (!(d > 0.0)) continue block3;
                        if (segLength < remainingInIndex) {
                            if (dashIndex % 2 == 0) {
                                ArrayList<Point2D> dashedPolyline = new ArrayList<Point2D>(Arrays.asList(segStartPt, segEndPt));
                                dashedPolylines.add(dashedPolyline);
                            }
                            remainingInIndex -= segLength;
                            continue block3;
                        }
                        Point2D dashFlipPoint = lineutility.ExtendAlongLineDouble2(segStartPt, segEndPt, remainingInIndex);
                        if (dashIndex % 2 == 0) {
                            ArrayList<Point2D> dashedPolyline = new ArrayList<Point2D>(Arrays.asList(segStartPt, dashFlipPoint));
                            dashedPolylines.add(dashedPolyline);
                        }
                        if (++dashIndex >= dash.length) {
                            dashIndex = 0;
                        }
                        remainingInIndex = dash[dashIndex];
                        segStartPt = dashFlipPoint;
                    }
                }
            }
            polylines.clear();
            polylines.addAll(dashedPolylines);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "createDashedPolylines", new RendererException("Failed inside createDashedPolylines", exc));
        }
    }

    private static ShapeInfo createSimpleFillShape(TGLight tg, ShapeInfo shape, ArrayList<ArrayList<Point2D>> polylines) {
        try {
            BasicStroke s = shape.getStroke();
            float[] dash = s.getDashArray();
            if (!armyc2.c5isr.JavaTacticalRenderer.clsUtility.isClosedPolygon(tg.get_LineType()) && !armyc2.c5isr.JavaTacticalRenderer.clsUtility.IsChange1Area(tg.get_LineType())) {
                return null;
            }
            if (dash == null || dash.length < 2) {
                return null;
            }
            if (shape.getFillColor() == null) {
                return null;
            }
            int j = 0;
            int k = 0;
            ShapeInfo shape2 = new ShapeInfo(shape.getShape());
            shape2.setShapeType(ShapeInfo.SHAPE_TYPE_FILL);
            ArrayList<ArrayList<Point2D>> polylines2 = new ArrayList<ArrayList<Point2D>>();
            ArrayList<Point2D> polyline = null;
            ArrayList<Point2D.Double> polyline2 = null;
            Point2D.Double pt2d = null;
            s = new BasicStroke(0.0f);
            shape2.setStroke(s);
            shape2.setFillColor(shape.getFillColor());
            int n = polylines.size();
            for (j = 0; j < n; ++j) {
                polyline = polylines.get(j);
                polyline2 = new ArrayList<Point2D.Double>();
                int t = polyline.size();
                for (k = 0; k < t; ++k) {
                    pt2d = new Point2D.Double(polyline.get(k).getX(), polyline.get(k).getY());
                    polyline2.add(pt2d);
                }
                polylines2.add(polyline2);
            }
            shape.setShapeType(ShapeInfo.SHAPE_TYPE_POLYLINE);
            shape.setFillColor(null);
            shape2.setPolylines(polylines2);
            return shape2;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "createSimpleFillShape", new RendererException("Failed inside createSimpleFillShape", exc));
            return null;
        }
    }

    private static ShapeInfo createSimplePatternFillShape(TGLight tg, ShapeInfo shape, ArrayList<ArrayList<Point2D>> polylines) {
        try {
            BasicStroke s = shape.getStroke();
            float[] dash = s.getDashArray();
            if (!armyc2.c5isr.JavaTacticalRenderer.clsUtility.isClosedPolygon(tg.get_LineType()) && !armyc2.c5isr.JavaTacticalRenderer.clsUtility.IsChange1Area(tg.get_LineType())) {
                return null;
            }
            if (dash == null || dash.length < 2) {
                return null;
            }
            if (shape.getPatternFillImage() == null) {
                return null;
            }
            int j = 0;
            int k = 0;
            ShapeInfo shape2 = new ShapeInfo(shape.getShape());
            shape2.setShapeType(ShapeInfo.SHAPE_TYPE_FILL);
            ArrayList<ArrayList<Point2D>> polylines2 = new ArrayList<ArrayList<Point2D>>();
            ArrayList<Point2D> polyline = null;
            ArrayList<Point2D.Double> polyline2 = null;
            Point2D.Double pt2d = null;
            s = new BasicStroke(0.0f);
            shape2.setStroke(s);
            shape2.setPatternFillImage(shape.getPatternFillImage());
            shape2.setTexturePaint(shape.getTexturePaint());
            int n = polylines.size();
            for (j = 0; j < n; ++j) {
                polyline = polylines.get(j);
                polyline2 = new ArrayList<Point2D.Double>();
                int t = polyline.size();
                for (k = 0; k < t; ++k) {
                    pt2d = new Point2D.Double(polyline.get(k).getX(), polyline.get(k).getY());
                    polyline2.add(pt2d);
                }
                polylines2.add(polyline2);
            }
            shape.setShapeType(ShapeInfo.SHAPE_TYPE_POLYLINE);
            shape.setPatternFillImage(null);
            shape.setTexturePaint(null);
            shape2.setPolylines(polylines2);
            return shape2;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "createSimplePatternFillShape", new RendererException("Failed inside createSimplePatternFillShape", exc));
            return null;
        }
    }

    private static boolean allowFillForThese(TGLight tg) {
        try {
            int linetype = tg.get_LineType();
            int bolMETOC = clsMETOC.IsWeather(tg.get_SymbolId());
            if (bolMETOC >= 0) {
                return true;
            }
            switch (linetype) {
                case 21700000: 
                case 21710000: 
                case 22139000: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: 
                case 23131200: 
                case 23132000: 
                case 23172000: 
                case 23173000: 
                case 23174000: 
                case 23211000: 
                case 23212000: 
                case 23213000: 
                case 23223000: 
                case 25200700: 
                case 32214000: 
                case 243111000: 
                case 243112000: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "allowFillForThese", new RendererException("Failed inside allowFillForThese", exc));
            return false;
        }
    }

    protected static void SetShapeInfosPolylines(TGLight tg, ArrayList<ShapeInfo> shapeInfos, Object clipBounds) {
        try {
            int j = 0;
            Shape shape = null;
            ShapeInfo shapeInfo = null;
            ArrayList<ArrayList<Point2D>> polylines = null;
            int type = -1;
            ShapeInfo simpleFillShape = null;
            Boolean isClosed = armyc2.c5isr.JavaTacticalRenderer.clsUtility.isClosedPolygon(tg.get_LineType());
            int linetype = tg.get_LineType();
            Color fillColor = null;
            int n = shapeInfos.size();
            for (j = 0; j < n; ++j) {
                shapeInfo = shapeInfos.get(j);
                type = shapeInfo.getShapeType();
                shape = shapeInfo.getShape();
                polylines = isClosed == false && type != Shape2.SHAPE_TYPE_FILL ? clsUtilityGE.createRenderablesFromShape(tg, shape, type, clipBounds) : clsUtilityGE.createRenderablesFromShape(tg, shape, type, null);
                if (simpleFillShape == null) {
                    simpleFillShape = clsUtilityGE.createSimpleFillShape(tg, shapeInfo, polylines);
                }
                if (simpleFillShape == null) {
                    simpleFillShape = clsUtilityGE.createSimplePatternFillShape(tg, shapeInfo, polylines);
                }
                fillColor = shapeInfo.getFillColor();
                if (simpleFillShape != null && !clsUtilityGE.allowFillForThese(tg)) {
                    shapeInfo.setFillColor(null);
                }
                if (!tg.get_UseDashArray()) {
                    clsUtilityGE.createDashedPolylines(polylines, shapeInfo);
                }
                shapeInfo.setPolylines(polylines);
            }
            if (simpleFillShape != null) {
                shapeInfos.add(0, simpleFillShape);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "SetShapeInfosPolylines", new RendererException("Failed inside SetShapeInfosPolylines", exc));
        }
    }

    private static ArrayList<ArrayList<Point2D>> createRenderablesFromShape(TGLight tg, Shape shape, int shapeType, Object clipArea) {
        ArrayList<Point2D.Double> ptsPoly = new ArrayList<Point2D.Double>();
        ArrayList<ArrayList<Point2D>> polylines2 = new ArrayList<ArrayList<Point2D>>();
        Point2D.Double ptPoly = null;
        try {
            double[] coords = new double[6];
            PathIterator i = shape.getPathIterator(null);
            while (!i.isDone()) {
                int type = i.currentSegment(coords);
                switch (type) {
                    case 0: {
                        if (ptsPoly.size() > 0) {
                            if (shapeType == ShapeInfo.SHAPE_TYPE_FILL && (((Point2D)ptsPoly.get(ptsPoly.size() - 1)).getX() != ((Point2D)ptsPoly.get(0)).getX() || ((Point2D)ptsPoly.get(ptsPoly.size() - 1)).getY() != ((Point2D)ptsPoly.get(0)).getY())) {
                                Point2D.Double pt2d = new Point2D.Double(((Point2D)ptsPoly.get(0)).getX(), ((Point2D)ptsPoly.get(0)).getY());
                                ptsPoly.add(pt2d);
                            }
                            if (ptsPoly.size() > 1) {
                                polylines2.add(ptsPoly);
                            }
                        }
                        ptsPoly = new ArrayList();
                        ptPoly = new Point2D.Double(coords[0], coords[1]);
                        ptsPoly.add(ptPoly);
                        break;
                    }
                    case 1: {
                        ptPoly = new Point2D.Double(coords[0], coords[1]);
                        ptsPoly.add(ptPoly);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                i.next();
            }
            if (ptsPoly.size() > 1) {
                if (shapeType == ShapeInfo.SHAPE_TYPE_FILL && (((Point2D)ptsPoly.get(ptsPoly.size() - 1)).getX() != ((Point2D)ptsPoly.get(0)).getX() || ((Point2D)ptsPoly.get(ptsPoly.size() - 1)).getY() != ((Point2D)ptsPoly.get(0)).getY())) {
                    Point2D.Double pt2d = new Point2D.Double(((Point2D)ptsPoly.get(0)).getX(), ((Point2D)ptsPoly.get(0)).getY());
                    ptsPoly.add(pt2d);
                }
                polylines2.add(ptsPoly);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "createRenderableFromShape", new RendererException("Failed inside createRenderableFromShape", exc));
        }
        return polylines2;
    }

    protected static ArrayList<Point2D> expandPolygon(ArrayList<Point2D> pts, double expand) {
        ArrayList<Point2D.Double> lgPoly = null;
        try {
            int j = 0;
            Object destPts = null;
            boolean isClosed = false;
            if (pts.get(pts.size() - 1).getX() == pts.get(0).getX() && pts.get(pts.size() - 1).getY() == pts.get(0).getY()) {
                pts.remove(pts.size() - 1);
                isClosed = true;
            }
            ArrayList<POINT2> pts2 = clsUtility.Points2DToPOINT2(pts);
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            double m = 0.0;
            double m1 = 0.0;
            double b = 0.0;
            double b1 = 0.0;
            ArrayList<Line2D.Double> lineSegments = new ArrayList<Line2D.Double>();
            int n = pts2.size();
            for (j = 0; j < n - 1; ++j) {
                pt0 = new POINT2(pts2.get(j));
                pt1 = new POINT2(pts2.get(j + 1));
                if (pt0.x != pt1.x) continue;
                pt1.x += 1.0;
                pts2.set(j + 1, pt1);
            }
            POINT2 ptn = pts2.get(pts2.size() - 1);
            pt0 = new POINT2(pts2.get(0));
            if (ptn.x == pt0.x) {
                ptn.x += 1.0;
                pts2.set(pts2.size() - 1, ptn);
            }
            pts2.add(pt0);
            Polygon poly = new Polygon();
            n = pts2.size();
            for (j = 0; j < n; ++j) {
                poly.addPoint((int)pts2.get((int)j).x, (int)pts2.get((int)j).y);
            }
            Line2D.Double lineSegment = null;
            POINT2 midPt = null;
            n = pts2.size();
            for (j = 0; j < n - 1; ++j) {
                pt0 = new POINT2(pts2.get(j));
                pt1 = new POINT2(pts2.get(j + 1));
                m = (pt0.y - pt1.y) / (pt0.x - pt1.x);
                if (Math.abs(m) < 1.0) {
                    pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 2, expand);
                    pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 2, expand);
                    midPt = lineutility.MidPointDouble(pt2, pt3, 0);
                    if (poly.contains(midPt.x, midPt.y)) {
                        pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 3, expand);
                        pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 3, expand);
                    }
                } else {
                    pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 0, expand);
                    pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 0, expand);
                    midPt = lineutility.MidPointDouble(pt2, pt3, 0);
                    if (poly.contains(midPt.x, midPt.y)) {
                        pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 1, expand);
                        pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 1, expand);
                    }
                }
                lineSegment = new Line2D.Double(pt2.x, pt2.y, pt3.x, pt3.y);
                lineSegments.add(lineSegment);
            }
            ArrayList<POINT2> expandPts = new ArrayList<POINT2>();
            Line2D thisLine = null;
            Line2D nextLine = null;
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            double x = 0.0;
            double y = 0.0;
            int t = lineSegments.size();
            for (j = 0; j < t; ++j) {
                thisLine = (Line2D)lineSegments.get(j);
                x1 = thisLine.getX1();
                y1 = thisLine.getY1();
                x2 = thisLine.getX2();
                y2 = thisLine.getY2();
                m = (y1 - y2) / (x1 - x2);
                b = y1 - m * x1;
                nextLine = j == lineSegments.size() - 1 ? (Line2D)lineSegments.get(0) : (Line2D)lineSegments.get(j + 1);
                x1 = nextLine.getX1();
                y1 = nextLine.getY1();
                x2 = nextLine.getX2();
                y2 = nextLine.getY2();
                m1 = (y1 - y2) / (x1 - x2);
                b1 = y1 - m1 * x1;
                if (m != m1) {
                    x = (b1 - b) / (m - m1);
                    y = m * x + b;
                } else {
                    x = thisLine.getX2();
                    y = thisLine.getY2();
                }
                expandPts.add(new POINT2(x, y));
            }
            lgPoly = new ArrayList<Point2D.Double>();
            t = expandPts.size();
            for (j = 0; j < t; ++j) {
                lgPoly.add(new Point2D.Double(((POINT2)expandPts.get((int)j)).x, ((POINT2)expandPts.get((int)j)).y));
            }
            if (isClosed) {
                lgPoly.add(new Point2D.Double(((Point2D)lgPoly.get(0)).getX(), ((Point2D)lgPoly.get(0)).getY()));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "expandPolygon2", new RendererException("Failed inside expandPolygon2", exc));
        }
        return lgPoly;
    }

    protected static ArrayList<Point2D> expandPolygon2(ArrayList<Point2D> pts, double expandX, double expandY) {
        ArrayList<Point2D> lgPoly = null;
        try {
            double avgX = 0.0;
            double avgY = 0.0;
            double totalX = 0.0;
            double totalY = 0.0;
            int j = 0;
            boolean isClosed = false;
            if (pts.get(pts.size() - 1).getX() == pts.get(0).getX() && pts.get(pts.size() - 1).getY() == pts.get(0).getY()) {
                pts.remove(pts.size() - 1);
                isClosed = true;
            }
            int n = pts.size();
            for (j = 0; j < n; ++j) {
                totalX += pts.get(j).getX();
                totalY += pts.get(j).getY();
            }
            avgX = totalX / (double)pts.size();
            avgY = totalY / (double)pts.size();
            Point2D.Double[] srcPts = new Point2D.Double[pts.size()];
            n = pts.size();
            for (j = 0; j < n; ++j) {
                srcPts[j] = new Point2D.Double(pts.get(j).getX(), pts.get(j).getY());
            }
            Point2D[] destPts = new Point2D[pts.size()];
            lgPoly = new ArrayList<Point2D>();
            int t = destPts.length;
            for (j = 0; j < t; ++j) {
                lgPoly.add(destPts[j]);
            }
            if (isClosed) {
                lgPoly.add(new Point2D.Double(destPts[0].getX(), destPts[0].getY()));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "expandPolygon", new RendererException("Failed inside expandPolygon", exc));
        }
        return lgPoly;
    }

    private static ArrayList<ArrayList<Point2D>> ptsPolyToPtsPoly(TGLight tg, ArrayList<ArrayList<Point2D>> ptsPoly, Rectangle2D clipBounds) {
        ArrayList ptsPoly2 = null;
        try {
            if (armyc2.c5isr.JavaTacticalRenderer.clsUtility.IsChange1Area(tg.get_LineType())) {
                return ptsPoly;
            }
            int j = 0;
            int k = 0;
            ArrayList<Point2D> pts = null;
            ArrayList<Point2D> addPts = null;
            Point2D pt0 = null;
            Point2D pt1 = null;
            Line2D.Double line = null;
            ptsPoly2 = new ArrayList();
            int n = ptsPoly.size();
            for (j = 0; j < n; ++j) {
                addPts = null;
                pts = ptsPoly.get(j);
                int t = pts.size();
                for (k = 0; k < t - 1; ++k) {
                    pt0 = pts.get(k);
                    pt1 = pts.get(k + 1);
                    line = new Line2D.Double(pt0, pt1);
                    if (!clipBounds.contains(pt0) && !clipBounds.contains(pt1)) {
                        if (!clipBounds.intersectsLine(line)) {
                            addPts = null;
                            continue;
                        }
                        if (addPts == null) {
                            addPts = new ArrayList<Point2D>();
                            addPts.add(pt0);
                        }
                        if (!addPts.contains(pt0)) {
                            addPts.add(pt0);
                        }
                        addPts.add(pt1);
                        ptsPoly2.add(addPts);
                        addPts = null;
                        continue;
                    }
                    if (!clipBounds.contains(pt0) && clipBounds.contains(pt1)) {
                        if (addPts == null) {
                            addPts = new ArrayList();
                            addPts.add(pt0);
                        }
                        if (!addPts.contains(pt0)) {
                            addPts.add(pt0);
                        }
                        addPts.add(pt1);
                        continue;
                    }
                    if (clipBounds.contains(pt0) && clipBounds.contains(pt1)) {
                        if (addPts == null) {
                            addPts = new ArrayList();
                            addPts.add(pt0);
                        }
                        if (!addPts.contains(pt0)) {
                            addPts.add(pt0);
                        }
                        addPts.add(pt1);
                        continue;
                    }
                    if (!clipBounds.contains(pt0) || clipBounds.contains(pt1)) continue;
                    if (addPts == null) {
                        addPts = new ArrayList();
                        addPts.add(pt0);
                    }
                    if (!addPts.contains(pt0)) {
                        addPts.add(pt0);
                    }
                    addPts.add(pt1);
                    ptsPoly2.add(addPts);
                    addPts = null;
                }
                if (addPts == null || addPts.size() <= 0) continue;
                ptsPoly2.add(addPts);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ptsPolyToPtsPoly", new RendererException("Failed inside ptsPolyToPtsPoly", exc));
        }
        return ptsPoly2;
    }

    private static ArrayList<ArrayList<Point2D>> ptsPolyToPtsPoly(TGLight tg, ArrayList<ArrayList<Point2D>> ptsPoly, ArrayList<Point2D> clipBounds) {
        ArrayList ptsPoly2 = null;
        try {
            if (armyc2.c5isr.JavaTacticalRenderer.clsUtility.IsChange1Area(tg.get_LineType())) {
                return ptsPoly;
            }
            int j = 0;
            int k = 0;
            ArrayList<Point2D> pts = null;
            ArrayList<Point2D> addPts = null;
            Point2D pt0 = null;
            Point2D pt1 = null;
            Line2D.Double line = null;
            ptsPoly2 = new ArrayList();
            Polygon clipPoly = new Polygon();
            int n = clipBounds.size();
            for (j = 0; j < n; ++j) {
                clipPoly.addPoint((int)clipBounds.get(j).getX(), (int)clipBounds.get(j).getY());
            }
            n = ptsPoly.size();
            for (j = 0; j < n; ++j) {
                addPts = null;
                pts = ptsPoly.get(j);
                int t = pts.size();
                for (k = 0; k < t - 1; ++k) {
                    pt0 = pts.get(k);
                    pt1 = pts.get(k + 1);
                    line = new Line2D.Double(pt0, pt1);
                    if (!clipPoly.contains(pt0) && !clipPoly.contains(pt1)) {
                        if (!clsUtilityGE.lineIntersectsClipArea(line, clipBounds)) {
                            addPts = null;
                            continue;
                        }
                        if (addPts == null) {
                            addPts = new ArrayList<Point2D>();
                            addPts.add(pt0);
                        }
                        if (!addPts.contains(pt0)) {
                            addPts.add(pt0);
                        }
                        addPts.add(pt1);
                        ptsPoly2.add(addPts);
                        addPts = null;
                        continue;
                    }
                    if (!clipPoly.contains(pt0) && clipPoly.contains(pt1)) {
                        if (addPts == null) {
                            addPts = new ArrayList();
                            addPts.add(pt0);
                        }
                        if (!addPts.contains(pt0)) {
                            addPts.add(pt0);
                        }
                        addPts.add(pt1);
                        continue;
                    }
                    if (clipPoly.contains(pt0) && clipPoly.contains(pt1)) {
                        if (addPts == null) {
                            addPts = new ArrayList();
                            addPts.add(pt0);
                        }
                        if (!addPts.contains(pt0)) {
                            addPts.add(pt0);
                        }
                        addPts.add(pt1);
                        continue;
                    }
                    if (!clipPoly.contains(pt0) || clipPoly.contains(pt1)) continue;
                    if (addPts == null) {
                        addPts = new ArrayList();
                        addPts.add(pt0);
                    }
                    if (!addPts.contains(pt0)) {
                        addPts.add(pt0);
                    }
                    addPts.add(pt1);
                    ptsPoly2.add(addPts);
                    addPts = null;
                }
                if (addPts == null || addPts.size() <= 0) continue;
                ptsPoly2.add(addPts);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ptsPolyToPtsPoly", new RendererException("Failed inside ptsPolyToPtsPoly", exc));
        }
        return ptsPoly2;
    }

    protected static void removeTrailingPoints(TGLight tg, Object clipArea) {
        try {
            boolean isClosed = armyc2.c5isr.JavaTacticalRenderer.clsUtility.isClosedPolygon(tg.get_LineType());
            if (isClosed) {
                return;
            }
            Polygon poly = new Polygon();
            Area area = null;
            Rectangle2D.Double clipBounds = null;
            ArrayList clipPoints = null;
            Object pt2d = null;
            int j = 0;
            if (clipArea == null) {
                return;
            }
            if (clipArea.getClass().isAssignableFrom(Rectangle2D.Double.class)) {
                clipBounds = (Rectangle2D.Double)clipArea;
            } else if (clipArea.getClass().isAssignableFrom(Rectangle.class)) {
                Rectangle rectx = (Rectangle)clipArea;
                clipBounds = new Rectangle2D.Double(rectx.x, rectx.y, rectx.width, rectx.height);
            } else if (clipArea.getClass().isAssignableFrom(ArrayList.class)) {
                clipPoints = (ArrayList)clipArea;
            }
            if (clipBounds != null) {
                clipPoints = new ArrayList();
                clipPoints.add(new Point2D.Double(((RectangularShape)clipBounds).getX(), ((RectangularShape)clipBounds).getY()));
                clipPoints.add(new Point2D.Double(((RectangularShape)clipBounds).getX() + ((RectangularShape)clipBounds).getWidth(), ((RectangularShape)clipBounds).getY()));
                clipPoints.add(new Point2D.Double(((RectangularShape)clipBounds).getX() + ((RectangularShape)clipBounds).getWidth(), ((RectangularShape)clipBounds).getY() + ((RectangularShape)clipBounds).getHeight()));
                clipPoints.add(new Point2D.Double(((RectangularShape)clipBounds).getX(), ((RectangularShape)clipBounds).getY() + ((RectangularShape)clipBounds).getHeight()));
                clipPoints.add(new Point2D.Double(((RectangularShape)clipBounds).getX(), ((RectangularShape)clipBounds).getY()));
            }
            Point2D ptLast = (Point2D)clipPoints.get(clipPoints.size() - 1);
            Point2D pt02d = (Point2D)clipPoints.get(0);
            Object pt12d = null;
            if (pt02d.getX() != ptLast.getX() || pt02d.getY() != ptLast.getY()) {
                clipPoints.add(new Point2D.Double(pt02d.getX(), pt02d.getY()));
            }
            int n = clipPoints.size();
            for (j = 0; j < n; ++j) {
                pt02d = (Point2D)clipPoints.get(j);
                poly.addPoint((int)pt02d.getX(), (int)pt02d.getY());
            }
            area = new Area(poly);
            Line2D.Double line = null;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            boolean intersects = false;
            int frontIndex = 0;
            int backIndex = tg.Pixels.size() - 1;
            n = tg.Pixels.size();
            for (j = 0; j < n - 1; ++j) {
                pt0 = tg.Pixels.get(j);
                pt1 = tg.Pixels.get(j + 1);
                line = new Line2D.Double(pt0.x, pt0.y, pt1.x, pt1.y);
                intersects = clsUtilityGE.lineIntersectsClipArea(line, clipPoints);
                if (intersects) {
                    frontIndex = j;
                    break;
                }
                if (!area.contains((int)pt0.x, (int)pt0.y) && !area.contains((int)pt1.x, (int)pt1.y)) continue;
                frontIndex = j;
                break;
            }
            n = tg.Pixels.size();
            for (j = n - 1; j > 0; --j) {
                pt0 = tg.Pixels.get(j);
                pt1 = tg.Pixels.get(j - 1);
                line = new Line2D.Double(pt0.x, pt0.y, pt1.x, pt1.y);
                intersects = clsUtilityGE.lineIntersectsClipArea(line, clipPoints);
                if (intersects) {
                    backIndex = j;
                    break;
                }
                if (!area.contains((int)pt0.x, (int)pt0.y) && !area.contains((int)pt1.x, (int)pt1.y)) continue;
                backIndex = j;
                break;
            }
            ArrayList<POINT2> pts = new ArrayList<POINT2>();
            for (j = frontIndex; j <= backIndex; ++j) {
                pt0 = new POINT2(tg.Pixels.get(j));
                pts.add(pt0);
            }
            tg.Pixels = pts;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("clsRenderer", "removeTrailingPoints", new RendererException("Failed inside removeTrailingPoints", exc));
        }
    }

    private static boolean lineIntersectsClipArea(Line2D line, ArrayList<Point2D> clipPts) {
        boolean result = false;
        try {
            int j = 0;
            Polygon poly = new Polygon();
            int n = clipPts.size();
            for (j = 0; j < n; ++j) {
                poly.addPoint((int)clipPts.get(j).getX(), (int)clipPts.get(j).getY());
            }
            if (poly.contains(line.getX1(), line.getY1())) {
                return true;
            }
            if (poly.contains(line.getX2(), line.getY2())) {
                return true;
            }
            Line2D.Double currentSegment = null;
            n = clipPts.size();
            for (j = 0; j < n - 1; ++j) {
                currentSegment = new Line2D.Double(clipPts.get(j).getX(), clipPts.get(j).getY(), clipPts.get(j + 1).getX(), clipPts.get(j + 1).getY());
                if (!line.intersectsLine(currentSegment)) continue;
                return true;
            }
            Point2D pt0 = clipPts.get(0);
            Point2D ptLast = clipPts.get(clipPts.size() - 1);
            if ((pt0.getX() != ptLast.getX() || pt0.getY() != ptLast.getY()) && line.intersectsLine(currentSegment = new Line2D.Double(ptLast.getX(), ptLast.getY(), pt0.getX(), pt0.getY()))) {
                return true;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "lineIntersectsClipArea", new RendererException("Failed inside lineIntersectsClipArea", exc));
        }
        return result;
    }

    protected static boolean segmentColorsSet(TGLight tg) {
        try {
            switch (tg.get_LineType()) {
                case 22121000: 
                case 25221000: 
                case 25222000: 
                case 25330500: {
                    break;
                }
                default: {
                    return false;
                }
            }
            String strH = tg.get_H();
            if (strH == null || strH.isEmpty()) {
                return false;
            }
            String[] strs = strH.split(",");
            if (strs.length > 1) {
                return true;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "segmentColorsSet", new RendererException("Failed inside segmentColorsSet", exc));
        }
        return false;
    }

    protected static double getZoomFactor(Rectangle2D rect, ArrayList<Point2D> clipPoints, ArrayList<POINT2> pixels) {
        double factor = -1.0;
        try {
            if (pixels == null || pixels.size() < 2) {
                return factor;
            }
            if (clipPoints == null && rect == null) {
                return factor;
            }
            double maxLengthPixels = 0.0;
            double maxLengthClipArea = 0.0;
            double temp = 0.0;
            int j = 0;
            Point2D pt2d0 = null;
            Point2D pt2d1 = null;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            for (j = 0; j < pixels.size() - 1; ++j) {
                pt0 = pixels.get(j);
                temp = lineutility.CalcDistanceDouble(pt0, pt1 = pixels.get(j + 1));
                if (!(temp > maxLengthPixels)) continue;
                maxLengthPixels = temp;
            }
            temp = 0.0;
            if (clipPoints != null) {
                for (j = 0; j < clipPoints.size() - 1; ++j) {
                    pt2d0 = clipPoints.get(j);
                    pt2d1 = clipPoints.get(j + 1);
                    pt0 = new POINT2(pt2d0.getX(), pt2d0.getY());
                    pt1 = new POINT2(pt2d1.getX(), pt2d1.getY());
                    temp = lineutility.CalcDistanceDouble(pt0, pt1);
                }
            } else if (rect != null && (temp = rect.getMaxX() - rect.getMinX()) < rect.getMaxY() - rect.getMinY()) {
                temp = rect.getMaxY() - rect.getMinY();
            }
            if (temp > maxLengthClipArea) {
                maxLengthClipArea = temp;
            }
            if (maxLengthPixels > 0.0 && maxLengthClipArea > 0.0) {
                factor = maxLengthClipArea / maxLengthPixels;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getZoomFactor", new RendererException("Failed inside getZoomFactor", exc));
        }
        return factor;
    }
}

