/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer;

import armyc2.c5isr.renderer.utilities.GENCLookup;
import armyc2.c5isr.renderer.utilities.ImageInfo;
import armyc2.c5isr.renderer.utilities.MSInfo;
import armyc2.c5isr.renderer.utilities.MSLookup;
import armyc2.c5isr.renderer.utilities.RectUtilities;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.RendererUtilities;
import armyc2.c5isr.renderer.utilities.SVGSymbolInfo;
import armyc2.c5isr.renderer.utilities.SettingsEventListener;
import armyc2.c5isr.renderer.utilities.Shape2SVG;
import armyc2.c5isr.renderer.utilities.ShapeUtilities;
import armyc2.c5isr.renderer.utilities.SymbolDimensionInfo;
import armyc2.c5isr.renderer.utilities.SymbolID;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import armyc2.c5isr.renderer.utilities.TextInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public class ModifierRenderer
implements SettingsEventListener {
    private static ModifierRenderer _instance = null;
    private static String _className = "ModifierRenderer";
    private static RendererSettings RS = RendererSettings.getInstance();
    private static Font _modifierFont = RS.getLabelFont();
    private static float _modifierFontHeight = 11.0f;
    private static float _modifierFontDescent = 2.0f;
    private static BufferedImage _bmp = new BufferedImage(2, 2, 2);

    @Override
    public void SettingsEventChanged(String type) {
        if (type.equals("FONT_CHANGED")) {
            _modifierFont = RendererSettings.getInstance().getLabelFont();
            Graphics2D _g2d = _bmp.createGraphics();
            FontMetrics fm = _g2d.getFontMetrics(_modifierFont);
            _modifierFontHeight = fm.getHeight();
            _modifierFontDescent = fm.getMaxDescent();
            fm = null;
            _g2d.dispose();
            Object var2_2 = null;
        }
    }

    private ModifierRenderer() {
    }

    public static synchronized ModifierRenderer getInstance() {
        if (_instance == null) {
            _instance = new ModifierRenderer();
        }
        RendererSettings.getInstance().addEventListener(_instance);
        _instance.SettingsEventChanged("FONT_CHANGED");
        return _instance;
    }

    public static SymbolDimensionInfo processUnitDisplayModifiers(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        String strQ;
        ImageInfo ii = null;
        SVGSymbolInfo ssi = null;
        SymbolDimensionInfo newsdi = null;
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Rectangle2D imageBounds = sdi.getImageBounds();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Point2D.Double symbolCenter = new Point2D.Double(symbolBounds.getCenterX(), symbolBounds.getCenterY());
        TextInfo tiEchelon = null;
        TextInfo tiAM = null;
        Rectangle2D echelonBounds = null;
        Rectangle2D amBounds = null;
        Color textColor = Color.BLACK;
        Color textBackgroundColor = null;
        float strokeWidth = 3.0f;
        float strokeWidthNL = 3.0f;
        Color lineColor = Color.BLACK;
        Color fillColor = SymbolUtilities.getFillColorOfAffiliation(symbolID);
        boolean buffer = false;
        float alpha = -1.0f;
        boolean offsetX = false;
        int offsetY = 0;
        int pixelSize = RendererSettings.getInstance().getDefaultPixelSize();
        int ss = SymbolID.getSymbolSet(symbolID);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        if (attributes.containsKey("TEXTCOLOR")) {
            textColor = RendererUtilities.getColorFromHexString(attributes.get("TEXTCOLOR"));
        }
        textBackgroundColor = attributes.containsKey("TEXTBACKGROUNDCOLOR") ? RendererUtilities.getColorFromHexString(attributes.get("TEXTBACKGROUNDCOLOR")) : RendererUtilities.getIdealOutlineColor(textColor);
        if (attributes.containsKey("LINECOLOR")) {
            lineColor = RendererUtilities.getColorFromHexString(attributes.get("LINECOLOR"));
        }
        if (attributes.containsKey("FILLCOLOR")) {
            fillColor = RendererUtilities.getColorFromHexString(attributes.get("FILLCOLOR"));
        }
        if (attributes.containsKey("PIXELSIZE")) {
            pixelSize = Integer.parseInt(attributes.get("PIXELSIZE"));
        }
        strokeWidth = pixelSize <= 100 ? 2.0f : 2.0f + (float)(pixelSize - 100) / 100.0f;
        Rectangle2D mobilityBounds = null;
        int ad = SymbolID.getAmplifierDescriptor(symbolID);
        ArrayList shapes = new ArrayList();
        Shape mobilityPath = null;
        Shape mobilityPathFill = null;
        if (ad >= 31 && (SymbolUtilities.hasModifier(symbolID, "R_MOBILITY_INDICATOR").booleanValue() || SymbolUtilities.hasModifier(symbolID, "AG_AUX_EQUIP_INDICATOR").booleanValue())) {
            int fifth = (int)(symbolBounds.getWidth() * 0.2 + 0.5);
            int x = 0;
            int y = 0;
            int centerX = 0;
            int bottomY = 0;
            int height = 0;
            int width = 0;
            int middleY = 0;
            int wheelOffset = 2;
            int wheelSize = fifth;
            int rrHeight = fifth;
            int rrArcWidth = (int)((double)fifth * 1.5 + 0.5);
            x = (int)symbolBounds.getX() + 1;
            y = (int)symbolBounds.getY();
            height = (int)symbolBounds.getHeight();
            width = (int)Math.round(symbolBounds.getWidth()) - 3;
            bottomY = y + height + 3;
            if (ad >= 31 && ad < 61 && SymbolUtilities.canSymbolHaveModifier(symbolID, "R_MOBILITY_INDICATOR").booleanValue()) {
                mobilityPath = new Path2D.Double();
                if (ad == 31) {
                    ((Path2D)mobilityPath).append(new Line2D.Double(x, bottomY, x + width, bottomY), false);
                    ((Path2D)mobilityPath).append(new Ellipse2D.Double(x, bottomY + wheelOffset, wheelSize, wheelSize), false);
                    ((Path2D)mobilityPath).append(new Ellipse2D.Double(x + width - wheelSize, bottomY + wheelOffset, wheelSize, wheelSize), false);
                } else if (ad == 32) {
                    ((Path2D)mobilityPath).append(new Line2D.Double(x, bottomY, x + width, bottomY), false);
                    ((Path2D)mobilityPath).append(new Ellipse2D.Double(x, bottomY + wheelOffset, wheelSize, wheelSize), false);
                    ((Path2D)mobilityPath).append(new Ellipse2D.Double(x + width - wheelSize, bottomY + wheelOffset, wheelSize, wheelSize), false);
                    ((Path2D)mobilityPath).append(new Ellipse2D.Double(x + width / 2 - wheelSize / 2, bottomY + wheelOffset, wheelSize, wheelSize), false);
                } else if (ad == 33) {
                    ((Path2D)mobilityPath).append(new RoundRectangle2D.Double(x, bottomY, width, rrHeight, rrArcWidth, rrHeight), false);
                } else if (ad == 34) {
                    ((Path2D)mobilityPath).append(new RoundRectangle2D.Double(x, bottomY, width, rrHeight, rrArcWidth, rrHeight), false);
                    ((Path2D)mobilityPath).append(new Ellipse2D.Double(x - wheelSize - wheelSize, bottomY, wheelSize, wheelSize), false);
                } else if (ad == 35) {
                    ((Path2D)mobilityPath).append(new Line2D.Double(x + wheelSize, bottomY + wheelSize / 2, x + width - wheelSize, bottomY + wheelSize / 2), false);
                    ((Path2D)mobilityPath).append(new Ellipse2D.Double(x, bottomY, wheelSize, wheelSize), false);
                    ((Path2D)mobilityPath).append(new Ellipse2D.Double(x + width - wheelSize, bottomY, wheelSize, wheelSize), false);
                } else if (ad == 36) {
                    ((Path2D)mobilityPath).append(new Line2D.Double(x, bottomY, x + width, bottomY), false);
                    ((Path2D)mobilityPath).append(new Ellipse2D.Double(x + wheelSize, bottomY + wheelOffset, wheelSize, wheelSize), false);
                    ((Path2D)mobilityPath).append(new Ellipse2D.Double(x, bottomY + wheelOffset, wheelSize, wheelSize), false);
                    ((Path2D)mobilityPath).append(new Ellipse2D.Double(x + width - wheelSize, bottomY + wheelOffset, wheelSize, wheelSize), false);
                    ((Path2D)mobilityPath).append(new Ellipse2D.Double(x + width - wheelSize - wheelSize, bottomY + wheelOffset, wheelSize, wheelSize), false);
                } else if (ad == 41) {
                    ((Path2D)mobilityPath).moveTo(x, bottomY);
                    ((Path2D)mobilityPath).lineTo(x + 5, bottomY + 5);
                    ((Path2D)mobilityPath).lineTo(x + width, bottomY + 5);
                } else if (ad == 42) {
                    ((Path2D)mobilityPath).moveTo(x, bottomY);
                    ((Path2D)mobilityPath).curveTo(x, bottomY, x - rrHeight, bottomY + rrHeight / 2, x, bottomY + rrHeight);
                    ((Path2D)mobilityPath).lineTo(x + width, bottomY + rrHeight);
                    ((Path2D)mobilityPath).curveTo(x + width, bottomY + rrHeight, x + width + rrHeight, bottomY + rrHeight / 2, x + width, bottomY);
                } else if (ad == 37) {
                    centerX = (int)Math.round(symbolBounds.getCenterX());
                    int angleWidth = rrHeight / 2;
                    ((Path2D)mobilityPath).moveTo(centerX, bottomY + rrHeight + 2);
                    ((Path2D)mobilityPath).lineTo(centerX - angleWidth, bottomY);
                    ((Path2D)mobilityPath).lineTo(centerX - angleWidth * 2, bottomY + rrHeight + 2);
                    ((Path2D)mobilityPath).moveTo(centerX, bottomY + rrHeight + 2);
                    ((Path2D)mobilityPath).lineTo(centerX + angleWidth, bottomY);
                    ((Path2D)mobilityPath).lineTo(centerX + angleWidth * 2, bottomY + rrHeight + 2);
                } else if (ad == 51) {
                    centerX = (int)symbolBounds.getCenterX();
                    double quarterX = (centerX - x) / 2;
                    double quarterY = (bottomY + rrHeight - bottomY) / 2;
                    ((Path2D)mobilityPath).moveTo(x + width, bottomY);
                    ((Path2D)mobilityPath).lineTo(x, bottomY);
                    ((Path2D)mobilityPath).curveTo((double)x + quarterX, bottomY + rrHeight, (double)centerX + quarterX, bottomY + rrHeight, x + width, bottomY);
                } else if (ad == 52) {
                    double incrementX = width / 7;
                    middleY = (bottomY + rrHeight - bottomY) / 2;
                    ((Path2D)mobilityPath).append(new Arc2D.Double(x, bottomY + middleY, incrementX, rrHeight, 0.0, 180.0, 0), false);
                    ((Path2D)mobilityPath).append(new Arc2D.Double((double)x + incrementX, bottomY + middleY, incrementX, rrHeight, 0.0, -180.0, 0), false);
                    ((Path2D)mobilityPath).append(new Arc2D.Double((double)x + incrementX * 2.0, bottomY + middleY, incrementX, rrHeight, 0.0, 180.0, 0), false);
                    ((Path2D)mobilityPath).append(new Arc2D.Double((double)x + incrementX * 3.0, bottomY + middleY, incrementX, rrHeight, 0.0, -180.0, 0), false);
                    ((Path2D)mobilityPath).append(new Arc2D.Double((double)x + incrementX * 4.0, bottomY + middleY, incrementX, rrHeight, 0.0, 180.0, 0), false);
                    ((Path2D)mobilityPath).append(new Arc2D.Double((double)x + incrementX * 5.0, bottomY + middleY, incrementX, rrHeight, 0.0, -180.0, 0), false);
                    ((Path2D)mobilityPath).append(new Arc2D.Double((double)x + incrementX * 6.0, bottomY + middleY, incrementX, rrHeight, 0.0, 180.0, 0), false);
                }
            }
            if ((ad == 61 || ad == 62) && SymbolUtilities.canSymbolHaveModifier(symbolID, "AG_AUX_EQUIP_INDICATOR").booleanValue()) {
                mobilityPath = new Path2D.Double();
                int boxHeight = (int)((float)rrHeight * 0.5f + 0.5f);
                if (boxHeight < 5) {
                    strokeWidthNL = 1.0f;
                }
                bottomY = y + height + boxHeight / 7;
                mobilityPathFill = new Path2D.Double();
                offsetY = boxHeight / 7;
                centerX = (int)symbolBounds.getCenterX();
                int squareOffset = Math.round((float)boxHeight * 0.5f);
                middleY = boxHeight / 2 + bottomY + offsetY;
                if (ad == 61) {
                    ((Path2D)mobilityPath).append(new Line2D.Double(centerX, bottomY - 1, centerX, bottomY + offsetY + boxHeight + offsetY), false);
                    ((Path2D)mobilityPath).append(new Line2D.Double(x, middleY, x + width, middleY), false);
                    ((Path2D)mobilityPathFill).append(new Rectangle2D.Double(x - squareOffset, bottomY + offsetY, boxHeight, boxHeight), false);
                    ((Path2D)mobilityPathFill).append(new Rectangle2D.Double(Math.round(centerX - squareOffset), bottomY + offsetY, boxHeight, boxHeight), false);
                    ((Path2D)mobilityPathFill).append(new Rectangle2D.Double(x + width - squareOffset, bottomY + offsetY, boxHeight, boxHeight), false);
                } else if (ad == 62) {
                    int leftX = x + (centerX - x) / 2;
                    int rightX = centerX + (x + width - centerX) / 2;
                    ((Path2D)mobilityPath).append(new Line2D.Double(leftX, bottomY - 1, leftX, bottomY + offsetY + boxHeight + offsetY), false);
                    ((Path2D)mobilityPath).append(new Line2D.Double(rightX, bottomY - 1, rightX, bottomY + offsetY + boxHeight + offsetY), false);
                    ((Path2D)mobilityPath).append(new Line2D.Double(x, middleY, x + width, middleY), false);
                    ((Path2D)mobilityPathFill).append(new Rectangle2D.Double(x - squareOffset, bottomY + offsetY, boxHeight, boxHeight), false);
                    ((Path2D)mobilityPathFill).append(new Rectangle2D.Double(centerX - squareOffset, bottomY + offsetY, boxHeight, boxHeight), false);
                    ((Path2D)mobilityPathFill).append(new Rectangle2D.Double(x + width - squareOffset, bottomY + offsetY, boxHeight, boxHeight), false);
                    ((Path2D)mobilityPathFill).append(new Rectangle2D.Double(leftX - squareOffset, bottomY + offsetY, boxHeight, boxHeight), false);
                    ((Path2D)mobilityPathFill).append(new Rectangle2D.Double(rightX - squareOffset, bottomY + offsetY, boxHeight, boxHeight), false);
                }
            }
            if (mobilityPath != null) {
                mobilityBounds = mobilityPath.getBounds2D();
                RectUtilities.shiftBR(mobilityBounds, 0, 1);
                if (mobilityPathFill != null) {
                    Rectangle2D mobilityFillBounds = mobilityPathFill.getBounds2D();
                    mobilityBounds = mobilityBounds.createUnion(mobilityFillBounds);
                }
                if (ad == 61 || ad == 62) {
                    ShapeUtilities.grow(mobilityBounds, (int)Math.ceil(strokeWidthNL / 2.0f));
                } else {
                    ShapeUtilities.grow(mobilityBounds, (int)Math.ceil(strokeWidth / 2.0f));
                }
                imageBounds = imageBounds.createUnion(mobilityBounds);
            }
        }
        Rectangle2D liBounds = null;
        Path2D.Double liPath = null;
        Point2D.Double liTop = null;
        Point2D.Double liLeft = null;
        Point2D.Double liRight = null;
        if (ad == 71 && ss == 27 && (SymbolID.getFrameShape(symbolID) == '6' || SymbolID.getFrameShape(symbolID) == '0')) {
            liPath = new Path2D.Double();
            int si = SymbolID.getStandardIdentity(symbolID);
            int af = SymbolID.getAffiliation(symbolID);
            int c = SymbolID.getContext(symbolID);
            double centerOffset = 0.0;
            double sideOffset = 0.0;
            double left = symbolBounds.getX();
            double right = symbolBounds.getX() + symbolBounds.getWidth();
            if (af == 1 || af == 0) {
                centerOffset = symbolBounds.getHeight() * 0.1012528735632184;
                sideOffset = (right - left) * 0.3583513488109785;
            }
            if (af == 4) {
                centerOffset = symbolBounds.getHeight() * 0.2537878787878788;
                sideOffset = (right - left) * 0.2051402812352822;
            }
            if (SymbolUtilities.isReality(symbolID).booleanValue() || SymbolUtilities.isSimulation(symbolID).booleanValue()) {
                if (af == 3 || af == 2) {
                    centerOffset = symbolBounds.getHeight() * 0.08;
                    sideOffset = (right - left) * 0.282714524168219;
                } else if (af == 6 || af == 5) {
                    left = symbolBounds.getCenterX() - symbolBounds.getWidth() / 2.0 * 1.0653694149;
                    right = symbolBounds.getCenterX() + symbolBounds.getWidth() / 2.0 * 1.0653694149;
                    centerOffset = symbolBounds.getHeight() * 0.08;
                    sideOffset = (right - left) * 0.4923255424955992;
                }
            } else if (af != 1 || af == 4) {
                centerOffset = symbolBounds.getHeight() * 0.08;
                sideOffset = (right - left) * 0.282714524168219;
            }
            liTop = new Point2D.Double(symbolBounds.getCenterX(), symbolBounds.getY() - centerOffset);
            liLeft = new Point2D.Double(left, ((Point2D)liTop).getY() + sideOffset);
            liRight = new Point2D.Double(right, ((Point2D)liTop).getY() + sideOffset);
            ((Path2D)liPath).moveTo(((Point2D)liTop).getX(), ((Point2D)liTop).getY());
            ((Path2D)liPath).lineTo(((Point2D)liLeft).getX(), ((Point2D)liLeft).getY());
            ((Path2D)liPath).moveTo(((Point2D)liTop).getX(), ((Point2D)liTop).getY());
            ((Path2D)liPath).lineTo(((Point2D)liRight).getX(), ((Point2D)liRight).getY());
            liBounds = liPath.getBounds2D();
            liBounds = new Rectangle2D.Double(((Point2D)liLeft).getX(), ((Point2D)liTop).getY(), ((Point2D)liRight).getX() - ((Point2D)liLeft).getX(), ((Point2D)liLeft).getY() - ((Point2D)liTop).getY());
            RectUtilities.grow(liBounds, 2);
            imageBounds = imageBounds.createUnion(liBounds);
        }
        int intEchelon = SymbolID.getAmplifierDescriptor(symbolID);
        String strEchelon = null;
        if (intEchelon > 10 && intEchelon < 29 && SymbolUtilities.canSymbolHaveModifier(symbolID, "B_ECHELON").booleanValue()) {
            strEchelon = SymbolUtilities.getEchelonText(intEchelon);
        }
        if (strEchelon != null && !SymbolUtilities.isInstallation(symbolID).booleanValue() && SymbolUtilities.hasModifier(symbolID, "B_ECHELON").booleanValue()) {
            int echelonOffset = 2;
            int outlineOffset = RS.getTextOutlineWidth();
            Font modifierFont = RS.getLabelFont();
            tiEchelon = new TextInfo(strEchelon, 0, 0, modifierFont, frc);
            echelonBounds = tiEchelon.getTextBounds();
            int y = (int)Math.round(symbolBounds.getY() - (double)echelonOffset);
            int x = (int)((double)Math.round(symbolBounds.getX()) + symbolBounds.getWidth() / 2.0 - echelonBounds.getWidth() / 2.0);
            tiEchelon.setLocation(x, y);
            ShapeUtilities.grow(echelonBounds, outlineOffset);
            tiEchelon.setLocation(x, y - outlineOffset);
            imageBounds = imageBounds.createUnion(echelonBounds);
        }
        Rectangle2D.Double tfBounds = null;
        Rectangle2D.Double tfRectangle = null;
        int hqtfd = SymbolID.getHQTFD(symbolID);
        if (SymbolUtilities.isTaskForce(symbolID).booleanValue()) {
            int height = (int)Math.round(symbolBounds.getHeight() / 4.0);
            int width = (int)Math.round(symbolBounds.getWidth() / 3.0);
            if (!SymbolUtilities.hasRectangleFrame(symbolID)) {
                height = (int)Math.round(symbolBounds.getHeight() / 6.0);
            }
            tfRectangle = new Rectangle2D.Double((int)(symbolBounds.getX() + (double)width), (int)(symbolBounds.getY() - (double)height), width, height);
            tfBounds = new Rectangle2D.Double((int)(((RectangularShape)tfRectangle).getX() - 1.0), (int)(((RectangularShape)tfRectangle).getY() - 1.0), (int)(((RectangularShape)tfRectangle).getWidth() + 2.0), (int)(((RectangularShape)tfRectangle).getHeight() + 2.0));
            if (echelonBounds != null) {
                double tfx = ((RectangularShape)tfRectangle).getX();
                double tfw = ((RectangularShape)tfRectangle).getWidth();
                double tfy = ((RectangularShape)tfRectangle).getY();
                double tfh = ((RectangularShape)tfRectangle).getHeight();
                if (echelonBounds.getWidth() > ((RectangularShape)tfRectangle).getWidth()) {
                    tfx = symbolBounds.getX() + symbolBounds.getWidth() / 2.0 - echelonBounds.getWidth() / 2.0 - 1.0;
                    tfw = echelonBounds.getWidth() + 2.0;
                }
                if (echelonBounds.getHeight() > ((RectangularShape)tfRectangle).getHeight()) {
                    tfy = echelonBounds.getY() - 1.0;
                    tfh = echelonBounds.getHeight() + 2.0;
                }
                tfRectangle = new Rectangle2D.Double(tfx, tfy, tfw, tfh);
                tfBounds = new Rectangle2D.Double((int)(((RectangularShape)tfRectangle).getX() - 1.0), (int)(((RectangularShape)tfRectangle).getY() - 1.0), (int)(((RectangularShape)tfRectangle).getWidth() + 2.0), (int)(((RectangularShape)tfRectangle).getHeight() + 2.0));
            }
            imageBounds = imageBounds.createUnion(tfBounds);
        }
        RectangularShape fdiBounds = null;
        Point2D.Double fdiTop = null;
        Point2D.Double fdiLeft = null;
        Point2D.Double fdiRight = null;
        if (SymbolUtilities.hasFDI(symbolID).booleanValue() && SymbolUtilities.canSymbolHaveModifier(symbolID, "AB_FEINT_DUMMY_INDICATOR").booleanValue()) {
            fdiLeft = new Point2D.Double(symbolBounds.getX(), symbolBounds.getY());
            fdiRight = new Point2D.Double(symbolBounds.getX() + symbolBounds.getWidth(), symbolBounds.getY());
            fdiTop = new Point2D.Double(Math.round(symbolBounds.getCenterX()), Math.round(symbolBounds.getY() - symbolBounds.getWidth() * 0.5));
            fdiBounds = new Rectangle2D.Double(((Point2D)fdiLeft).getX(), ((Point2D)fdiTop).getY(), ((Point2D)fdiRight).getX() - ((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY() - ((Point2D)fdiTop).getY());
            if (echelonBounds != null) {
                int shiftY = (int)Math.round(symbolBounds.getY() - echelonBounds.getHeight() - 2.0);
                ((Point2D)fdiLeft).setLocation(((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY() + (double)shiftY);
                ((Point2D)fdiTop).setLocation(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY() + (double)shiftY);
                ((Point2D)fdiRight).setLocation(((Point2D)fdiRight).getX(), ((Point2D)fdiRight).getY() + (double)shiftY);
                fdiBounds = new Rectangle2D.Double(((Point2D)fdiLeft).getX(), ((Point2D)fdiTop).getY(), ((Point2D)fdiRight).getX() - ((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY() - ((Point2D)fdiTop).getY());
            }
            imageBounds = imageBounds.createUnion((Rectangle2D)fdiBounds);
        }
        String strAO = null;
        Rectangle2D.Double ebRectangle = null;
        RectangularShape ebBounds = null;
        Rectangle2D ebTextBounds = null;
        TextInfo tiAO = null;
        int ebTop = 0;
        int ebLeft = 0;
        int ebWidth = 0;
        int ebHeight = 0;
        Color ebColor = null;
        ebColor = attributes.containsKey("ENGAGEMENTBARCOLOR") ? RendererUtilities.getColorFromHexString(attributes.get("ENGAGEMENTBARCOLOR")) : fillColor;
        if (SymbolUtilities.hasModifier(symbolID, "AO_ENGAGEMENT_BAR").booleanValue() && modifiers.containsKey("AO_ENGAGEMENT_BAR")) {
            strAO = modifiers.get("AO_ENGAGEMENT_BAR");
        }
        if (strAO != null) {
            tiAO = new TextInfo(strAO, 0, 0, _modifierFont, frc);
            ebTextBounds = tiAO.getTextBounds();
            ebHeight = (int)ebTextBounds.getHeight() + 4;
            ebTop = fdiBounds != null ? (int)fdiBounds.getY() - ebHeight - 4 : (tfBounds != null ? (int)((RectangularShape)tfBounds).getY() - ebHeight - 4 : (echelonBounds != null ? (int)echelonBounds.getY() - ebHeight - 4 : (SymbolUtilities.canSymbolHaveModifier(symbolID, "C_QUANTITY") != false && modifiers.containsKey("C_QUANTITY") ? (int)symbolBounds.getY() - ebHeight * 2 - 4 : (ss == 20 ? (int)symbolBounds.getY() - ebHeight - 8 : (int)symbolBounds.getY() - ebHeight - 4))));
            if (ebTextBounds.getWidth() + 4.0 > symbolBounds.getWidth()) {
                ebWidth = (int)ebTextBounds.getWidth() + 4;
                ebLeft = (int)((Point2D)symbolCenter).getX() - ebWidth / 2;
            } else {
                ebLeft = (int)symbolBounds.getX() + 1;
                ebWidth = (int)symbolBounds.getWidth() - 2;
            }
            tiAO.setLocation((int)(((Point2D)symbolCenter).getX() - ebTextBounds.getWidth() / 2.0), (int)((double)(ebTop + ebHeight - 2) - ((double)ebHeight - ebTextBounds.getHeight()) / 2.0));
            ebRectangle = new Rectangle2D.Double(ebLeft, ebTop, ebWidth, ebHeight);
            ebBounds = RectUtilities.copyRect(ebRectangle);
            RectUtilities.grow((Rectangle2D)ebBounds, 1);
            imageBounds = imageBounds.createUnion((Rectangle2D)ebBounds);
        }
        String affiliationModifier = null;
        if (!RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            int x;
            int y;
            int amOffset = 2;
            int outlineOffset = RS.getTextOutlineWidth();
            tiAM = new TextInfo(affiliationModifier, 0, 0, RS.getLabelFont(), frc);
            amBounds = tiAM.getTextBounds();
            if (echelonBounds != null && echelonBounds.getMinX() + echelonBounds.getWidth() > symbolBounds.getMinX() + symbolBounds.getWidth()) {
                y = (int)Math.round(symbolBounds.getMinY() - (double)amOffset);
                int n = (int)(echelonBounds.getMinX() + echelonBounds.getWidth() + (double)amOffset);
            }
            if (ebBounds != null && ebBounds.getMinX() + ebBounds.getWidth() > symbolBounds.getMinX() + symbolBounds.getWidth()) {
                y = (int)Math.round(symbolBounds.getMinY() - (double)amOffset);
                x = (int)(ebBounds.getMinX() + ebBounds.getWidth() + (double)amOffset + (double)RendererSettings.getInstance().getTextOutlineWidth());
            } else {
                y = (int)Math.round(symbolBounds.getMinY() - (double)amOffset);
                x = (int)Math.round(symbolBounds.getMinX() + symbolBounds.getWidth() + (double)amOffset + (double)RendererSettings.getInstance().getTextOutlineWidth());
            }
            tiAM.setLocation(x, y);
            ShapeUtilities.grow(amBounds, outlineOffset);
            ShapeUtilities.offset(amBounds, 0, -outlineOffset);
            tiAM.setLocation(x, y - outlineOffset);
            imageBounds = imageBounds.createUnion(amBounds);
        }
        Point2D.Double pt1HQ = null;
        Point2D.Double pt2HQ = null;
        Rectangle2D.Double hqBounds = null;
        if (SymbolUtilities.isHQ(symbolID)) {
            int affiliation = SymbolID.getAffiliation(symbolID);
            int context = SymbolID.getContext(symbolID);
            pt1HQ = SymbolUtilities.hasRectangleFrame(symbolID) ? new Point2D.Double(symbolBounds.getX() + 1.0, symbolBounds.getY() + symbolBounds.getHeight()) : new Point2D.Double((int)symbolBounds.getX() + 1, (int)(symbolBounds.getY() + symbolBounds.getHeight() / 2.0));
            pt2HQ = new Point2D.Double(((Point2D)pt1HQ).getX(), ((Point2D)pt1HQ).getY() + symbolBounds.getHeight());
            hqBounds = new Rectangle2D.Double(((Point2D)pt1HQ).getX(), ((Point2D)pt1HQ).getY(), 2.0, ((Point2D)pt2HQ).getY() - ((Point2D)pt1HQ).getY());
            imageBounds = imageBounds.createUnion(new Rectangle2D.Double(((Point2D)pt1HQ).getX(), ((Point2D)pt1HQ).getY(), ((Point2D)pt2HQ).getX() - ((Point2D)pt1HQ).getX(), ((Point2D)pt2HQ).getY() - ((Point2D)pt1HQ).getY()));
            centerPoint.setLocation(((Point2D)pt2HQ).getX(), ((Point2D)pt2HQ).getY());
        }
        Point2D[] domPoints = null;
        Rectangle2D domBounds = null;
        if (modifiers.containsKey("Q_DIRECTION_OF_MOVEMENT") && SymbolUtilities.canSymbolHaveModifier(symbolID, "Q_DIRECTION_OF_MOVEMENT").booleanValue() && (strQ = modifiers.get("Q_DIRECTION_OF_MOVEMENT")) != null && SymbolUtilities.isNumber(strQ)) {
            float q = Float.valueOf(strQ).floatValue();
            boolean isY = modifiers.containsKey("Y_LOCATION");
            domPoints = ModifierRenderer.createDOMArrowPoints(symbolID, symbolBounds, centerPoint, q, isY, frc);
            domBounds = new Rectangle2D.Double(domPoints[0].getX(), domPoints[0].getY(), 1.0, 1.0);
            Point2D temp = null;
            for (int i = 1; i < 6; ++i) {
                temp = domPoints[i];
                if (temp == null) continue;
                domBounds = ((Rectangle2D)domBounds).createUnion(new Rectangle2D.Double(temp.getX(), temp.getY(), 1.0, 1.0));
            }
            imageBounds = imageBounds.createUnion(domBounds);
        }
        Rectangle2D ociBounds = null;
        Rectangle2D ociShape = null;
        Path2D ociSlashShape = null;
        int ociOffset = 4;
        if (SymbolUtilities.hasModifier(symbolID, "AL_OPERATIONAL_CONDITION").booleanValue()) {
            if (mobilityBounds != null) {
                ociOffset = (int)Math.round(mobilityBounds.getY() + mobilityBounds.getHeight() - (symbolBounds.getY() + symbolBounds.getHeight())) + 4;
            }
            if (RendererSettings.getInstance().getOperationalConditionModifierType() == RendererSettings.OperationalConditionModifierType_BAR) {
                ociShape = ModifierRenderer.processOperationalConditionIndicator(symbolID, symbolBounds, ociOffset);
                if (ociShape != null) {
                    Rectangle2D temp = (Rectangle2D)ociShape.clone();
                    ShapeUtilities.grow(temp, 1);
                    ociBounds = temp;
                    imageBounds = imageBounds.createUnion(ociBounds);
                }
            } else {
                ociSlashShape = ModifierRenderer.processOperationalConditionIndicatorSlash(symbolID, symbolBounds);
                if (ociSlashShape != null) {
                    ociBounds = ociSlashShape.getBounds2D();
                    imageBounds = imageBounds.createUnion(ociBounds);
                }
            }
        }
        if (sdi instanceof ImageInfo && (imageBounds.getX() < 0.0 || imageBounds.getY() < 0.0)) {
            int shiftX = (int)Math.abs(imageBounds.getX());
            int shiftY = (int)Math.abs(imageBounds.getY());
            if (hqBounds != null) {
                ShapeUtilities.offset((Point2D)pt1HQ, shiftX, shiftY);
                ShapeUtilities.offset((Point2D)pt2HQ, shiftX, shiftY);
            }
            if (echelonBounds != null) {
                tiEchelon.setLocation((int)tiEchelon.getLocation().getX() + shiftX, (int)tiEchelon.getLocation().getY() + shiftY);
            }
            if (amBounds != null) {
                tiAM.setLocation((int)tiAM.getLocation().getX() + shiftX, (int)tiAM.getLocation().getY() + shiftY);
            }
            if (tfBounds != null) {
                ShapeUtilities.offset((Rectangle2D)tfRectangle, shiftX, shiftY);
                ShapeUtilities.offset((Rectangle2D)tfBounds, shiftX, shiftY);
            }
            if (ebBounds != null) {
                ShapeUtilities.offset(ebRectangle, shiftX, shiftY);
                ShapeUtilities.offset((Rectangle2D)ebBounds, shiftX, shiftY);
                tiAO.shift(shiftX, shiftY);
                ShapeUtilities.offset(ebTextBounds, shiftX, shiftY);
            }
            if (fdiBounds != null) {
                ShapeUtilities.offset((Rectangle2D)fdiBounds, shiftX, shiftY);
                ShapeUtilities.offset((Point2D)fdiLeft, shiftX, shiftY);
                ShapeUtilities.offset((Point2D)fdiTop, shiftX, shiftY);
                ShapeUtilities.offset((Point2D)fdiRight, shiftX, shiftY);
            }
            if (liBounds != null) {
                ShapeUtilities.offset(liBounds, shiftX, shiftY);
                ShapeUtilities.offset((Point2D)liLeft, shiftX, shiftY);
                ShapeUtilities.offset((Point2D)liTop, shiftX, shiftY);
                ShapeUtilities.offset((Point2D)liRight, shiftX, shiftY);
                if (liPath != null) {
                    ShapeUtilities.offset(liPath, shiftX, shiftY);
                }
            }
            if (ociBounds != null) {
                ShapeUtilities.offset(ociBounds, shiftX, shiftY);
                if (ociShape != null) {
                    ShapeUtilities.offset(ociShape, shiftX, shiftY);
                }
                if (ociSlashShape != null) {
                    ShapeUtilities.offset(ociSlashShape, shiftX, shiftY);
                }
            }
            if (domBounds != null) {
                for (int i = 0; i < 6; ++i) {
                    Point2D temp = domPoints[i];
                    if (temp == null) continue;
                    ShapeUtilities.offset(temp, shiftX, shiftY);
                }
                ShapeUtilities.offset(domBounds, shiftX, shiftY);
            }
            if (mobilityBounds != null) {
                ShapeUtilities.offset((Path2D)mobilityPath, shiftX, shiftY);
                if (mobilityPathFill != null) {
                    ShapeUtilities.offset((Path2D)mobilityPathFill, shiftX, shiftY);
                }
                ShapeUtilities.offset(mobilityBounds, shiftX, shiftY);
            }
            ShapeUtilities.offset((Point2D)centerPoint, shiftX, shiftY);
            ShapeUtilities.offset(symbolBounds, shiftX, shiftY);
            ShapeUtilities.offset(imageBounds, shiftX, shiftY);
        }
        if (sdi instanceof SVGSymbolInfo) {
            StringBuilder sbSVG = new StringBuilder();
            Path2D.Double temp = null;
            String svgStroke = RendererUtilities.colorToHexString(lineColor, false);
            String svgFill = RendererUtilities.colorToHexString(fillColor, false);
            String svgTextColor = RendererUtilities.colorToHexString(textColor, false);
            String svgTextBGColor = RendererUtilities.colorToHexString(textBackgroundColor, false);
            String svgStrokeWidth = String.valueOf(strokeWidth);
            String svgTextOutlineWidth = String.valueOf(RendererSettings.getInstance().getTextOutlineWidth());
            String svgAlpha = null;
            if (alpha >= 0.0f && alpha <= 1.0f) {
                svgAlpha = String.valueOf(alpha);
            }
            Object svgDashArray = null;
            if (hqBounds != null) {
                Line2D.Double hqStaff = new Line2D.Double(pt1HQ, pt2HQ);
                temp = new Path2D.Double();
                temp.append(hqStaff, false);
                sbSVG.append(Shape2SVG.Convert(temp, svgStroke, null, svgStrokeWidth, svgAlpha, svgAlpha, null));
            }
            if (echelonBounds != null) {
                sbSVG.append(Shape2SVG.Convert(tiEchelon, svgTextBGColor, svgTextColor, svgTextOutlineWidth, svgAlpha, svgAlpha, null));
            }
            if (amBounds != null) {
                sbSVG.append(Shape2SVG.Convert(tiAM, svgTextBGColor, svgTextColor, svgTextOutlineWidth, svgAlpha, svgAlpha, null));
            }
            if (tfBounds != null) {
                sbSVG.append(Shape2SVG.Convert(tfRectangle, svgStroke, null, svgStrokeWidth, svgAlpha, svgAlpha, null));
            }
            if (ebBounds != null) {
                String svgEBFill = RendererUtilities.colorToHexString(ebColor, false);
                sbSVG.append(Shape2SVG.Convert(ebRectangle, svgStroke, svgEBFill, svgStrokeWidth, svgAlpha, svgAlpha, null));
                sbSVG.append(Shape2SVG.Convert(tiAO, null, "#000000", null, svgAlpha, svgAlpha, null));
            }
            if (fdiBounds != null) {
                String svgFDIDashArray = "6 4";
                float[] dashArray = new float[]{6.0f, 4.0f};
                if (symbolBounds.getHeight() < 20.0) {
                    svgFDIDashArray = "5 3";
                }
                Path2D.Double fdiPath = new Path2D.Double();
                ((Path2D)fdiPath).moveTo(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY());
                ((Path2D)fdiPath).lineTo(((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY());
                ((Path2D)fdiPath).moveTo(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY());
                ((Path2D)fdiPath).lineTo(((Point2D)fdiRight).getX(), ((Point2D)fdiRight).getY());
                sbSVG.append(Shape2SVG.Convert(fdiPath, svgStroke, null, svgStrokeWidth, svgAlpha, svgAlpha, svgFDIDashArray));
            }
            if (liBounds != null) {
                int liStrokeWidth = 2;
                if (pixelSize < 100) {
                    liStrokeWidth = 1;
                }
                sbSVG.append(Shape2SVG.Convert(liPath, svgStroke, null, String.valueOf(liStrokeWidth), svgAlpha, svgAlpha, null));
            }
            if (ociBounds != null && ociShape != null) {
                int status = SymbolID.getStatus(symbolID);
                Color statusColor = null;
                switch (status) {
                    case 2: {
                        statusColor = Color.green;
                        break;
                    }
                    case 3: {
                        statusColor = Color.yellow;
                        break;
                    }
                    case 4: {
                        statusColor = Color.red;
                        break;
                    }
                    case 5: {
                        statusColor = Color.blue;
                        break;
                    }
                }
                String svgOCIStatusColor = RendererUtilities.colorToHexString(statusColor, false);
                sbSVG.append(Shape2SVG.Convert(ociBounds, null, svgStroke, svgStrokeWidth, svgAlpha, svgAlpha, null));
                sbSVG.append(Shape2SVG.Convert(ociShape, null, svgOCIStatusColor, svgStrokeWidth, svgAlpha, svgAlpha, null));
                ociBounds = null;
                ociShape = null;
            }
            if (mobilityBounds != null) {
                String svgMobilitySW = svgStrokeWidth;
                if (ad <= 30 || ad >= 60) {
                    svgMobilitySW = String.valueOf(strokeWidthNL);
                }
                sbSVG.append(Shape2SVG.Convert(mobilityPath, svgStroke, null, svgMobilitySW, svgAlpha, svgAlpha, null));
                if (mobilityPathFill != null) {
                    sbSVG.append(Shape2SVG.Convert(mobilityPathFill, "none", svgStroke, "0", svgAlpha, svgAlpha, null));
                }
                mobilityBounds = null;
            }
            ssi = (SVGSymbolInfo)sdi;
            sbSVG.append(ssi.getSVG());
            if (ociBounds != null && ociSlashShape != null) {
                double size = symbolBounds.getWidth();
                float ociStrokeWidth = 3.0f;
                ociStrokeWidth = (float)size / 20.0f;
                if (ociStrokeWidth < 1.0f) {
                    ociStrokeWidth = 1.0f;
                }
                sbSVG.append(Shape2SVG.Convert(ociSlashShape, svgStroke, null, String.valueOf(ociStrokeWidth), svgAlpha, svgAlpha, null));
                ociBounds = null;
                ociSlashShape = null;
            }
            if (domBounds != null) {
                Path2D.Double domPath = new Path2D.Double();
                ((Path2D)domPath).moveTo(domPoints[0].getX(), domPoints[0].getY());
                if (domPoints[1] != null) {
                    ((Path2D)domPath).lineTo(domPoints[1].getX(), domPoints[1].getY());
                }
                if (domPoints[2] != null) {
                    ((Path2D)domPath).lineTo(domPoints[2].getX(), domPoints[2].getY());
                }
                sbSVG.append(Shape2SVG.Convert(domPath, svgStroke, null, svgStrokeWidth, svgAlpha, svgAlpha, null));
                domPath.reset();
                ((Path2D)domPath).moveTo(domPoints[3].getX(), domPoints[3].getY());
                ((Path2D)domPath).lineTo(domPoints[4].getX(), domPoints[4].getY());
                ((Path2D)domPath).lineTo(domPoints[5].getX(), domPoints[5].getY());
                sbSVG.append(Shape2SVG.Convert(domPath, "none", svgStroke, "0", svgAlpha, svgAlpha, null));
                domBounds = null;
                domPoints = null;
            }
            newsdi = new SVGSymbolInfo(sbSVG.toString(), centerPoint, symbolBounds, imageBounds);
        }
        if (sdi instanceof ImageInfo) {
            BufferedImage bmp = new BufferedImage((int)Math.ceil(imageBounds.getWidth()), (int)Math.ceil(imageBounds.getHeight()), 2);
            Graphics2D g2d = bmp.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            lineColor = RendererUtilities.setColorAlpha(lineColor, alpha);
            textColor = RendererUtilities.setColorAlpha(textColor, alpha);
            textBackgroundColor = RendererUtilities.setColorAlpha(textBackgroundColor, alpha);
            ebColor = RendererUtilities.setColorAlpha(ebColor, alpha);
            g2d.setColor(lineColor);
            g2d.setFont(RS.getLabelFont());
            ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>();
            if (echelonBounds != null) {
                tiArray.add(tiEchelon);
            }
            if (amBounds != null) {
                tiArray.add(tiAM);
            }
            if (!tiArray.isEmpty()) {
                ModifierRenderer.renderText(g2d, tiArray, textColor, textBackgroundColor);
            }
            BasicStroke stroke = new BasicStroke(strokeWidth, 0, 0, 10.0f);
            g2d.setColor(lineColor);
            g2d.setStroke(stroke);
            if (hqBounds != null) {
                g2d.drawLine((int)((Point2D)pt1HQ).getX(), (int)((Point2D)pt1HQ).getY(), (int)((Point2D)pt2HQ).getX(), (int)((Point2D)pt2HQ).getY());
            }
            if (tfBounds != null) {
                g2d.draw(tfRectangle);
            }
            if (ebBounds != null) {
                stroke = new BasicStroke(strokeWidth, 0, 0, 4.0f);
                g2d.setColor(ebColor);
                g2d.fillRect((int)((RectangularShape)ebRectangle).getX(), (int)((RectangularShape)ebRectangle).getY(), (int)((RectangularShape)ebRectangle).getWidth(), (int)((RectangularShape)ebRectangle).getHeight());
                g2d.setColor(lineColor);
                g2d.setStroke(stroke);
                g2d.drawRect((int)((RectangularShape)ebRectangle).getX(), (int)((RectangularShape)ebRectangle).getY(), (int)((RectangularShape)ebRectangle).getWidth(), (int)((RectangularShape)ebRectangle).getHeight());
                TextInfo[] aTiAO = new TextInfo[]{tiAO};
                ModifierRenderer.renderText(g2d, aTiAO, RendererUtilities.setColorAlpha(Color.BLACK, alpha), new Color(0, 0, 0, 0));
                amBounds = null;
                tiAO = null;
                ebBounds = null;
                tiAO = null;
                ebRectangle = null;
            }
            if (echelonBounds != null) {
                TextInfo[] aTiEchelon = new TextInfo[]{tiEchelon};
                ModifierRenderer.renderText(g2d, aTiEchelon, textColor, textBackgroundColor);
                echelonBounds = null;
                tiEchelon = null;
            }
            if (amBounds != null) {
                TextInfo[] aTiAM = new TextInfo[]{tiAM};
                ModifierRenderer.renderText(g2d, aTiAM, textColor, textBackgroundColor);
                amBounds = null;
                tiAM = null;
            }
            if (fdiBounds != null) {
                float[] dashArray = new float[]{6.0f, 4.0f};
                g2d.setColor(lineColor);
                if (symbolBounds.getHeight() < 20.0) {
                    dashArray[0] = 5.0f;
                    dashArray[1] = 3.0f;
                }
                stroke = new BasicStroke(2.0f, 0, 0, 10.0f, dashArray, 0.0f);
                g2d.setStroke(stroke);
                Path2D.Double fdiPath = new Path2D.Double();
                ((Path2D)fdiPath).moveTo(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY());
                ((Path2D)fdiPath).lineTo(((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY());
                ((Path2D)fdiPath).moveTo(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY());
                ((Path2D)fdiPath).lineTo(((Point2D)fdiRight).getX(), ((Point2D)fdiRight).getY());
                g2d.draw(fdiPath);
                fdiBounds = null;
            }
            if (liBounds != null) {
                g2d.setColor(lineColor);
                int liStrokeWidth = 2;
                if (pixelSize < 100) {
                    liStrokeWidth = 1;
                }
                stroke = new BasicStroke(liStrokeWidth, 0, 0, 10.0f);
                g2d.setStroke(stroke);
                g2d.draw(liPath);
                liBounds = null;
            }
            if (mobilityBounds != null) {
                stroke = new BasicStroke(strokeWidth, 0, 0, 10.0f);
                g2d.setColor(lineColor);
                if (ad <= 30 || ad >= 60) {
                    stroke = new BasicStroke(strokeWidthNL, 0, 0, 10.0f);
                }
                g2d.setStroke(stroke);
                g2d.draw(mobilityPath);
                if (mobilityPathFill != null) {
                    g2d.fill(mobilityPathFill);
                }
                mobilityBounds = null;
            }
            if (ociBounds != null && ociShape != null) {
                Color statusColor = null;
                int status = SymbolID.getStatus(symbolID);
                switch (status) {
                    case 2: {
                        statusColor = Color.green;
                        break;
                    }
                    case 3: {
                        statusColor = Color.yellow;
                        break;
                    }
                    case 4: {
                        statusColor = Color.red;
                        break;
                    }
                    case 5: {
                        statusColor = Color.blue;
                        break;
                    }
                }
                statusColor = RendererUtilities.setColorAlpha(statusColor, alpha);
                g2d.setColor(lineColor);
                g2d.fillRect((int)ociBounds.getX(), (int)ociBounds.getY(), (int)ociBounds.getWidth(), (int)ociBounds.getHeight());
                g2d.setColor(statusColor);
                g2d.fillRect((int)ociShape.getX(), (int)ociShape.getY(), (int)ociShape.getWidth(), (int)ociShape.getHeight());
                ociBounds = null;
                ociShape = null;
            }
            ii = (ImageInfo)sdi;
            g2d.drawImage((Image)ii.getImage(), (int)symbolBounds.getX(), (int)symbolBounds.getY(), null);
            if (domBounds != null) {
                ModifierRenderer.drawDOMArrow(g2d, domPoints, lineColor, strokeWidth);
                domBounds = null;
                domPoints = null;
            }
            if (ociBounds != null && ociSlashShape != null) {
                g2d.setColor(lineColor);
                double size = symbolBounds.getWidth();
                float ociStrokeWidth = 3.0f;
                ociStrokeWidth = (float)size / 20.0f;
                if (ociStrokeWidth < 1.0f) {
                    ociStrokeWidth = 1.0f;
                }
                stroke = new BasicStroke(ociStrokeWidth, 0, 0, 10.0f);
                g2d.setStroke(stroke);
                g2d.draw(ociSlashShape);
                ociBounds = null;
                ociSlashShape = null;
            }
            if (bmp != null) {
                newsdi = new ImageInfo(bmp, centerPoint, symbolBounds);
            }
        }
        if (newsdi != null) {
            return newsdi;
        }
        return null;
    }

    private static double getYPositionForSCC(String symbolID) {
        double yPosition = 0.32;
        return yPosition;
    }

    private static Point2D[] createDOMArrowPoints(String symbolID, Rectangle2D bounds, Point2D center, float angle, boolean isY, FontRenderContext frc) {
        int x2;
        Point2D[] arrowPoints = new Point2D.Double[6];
        Point2D.Double pt1 = null;
        Point2D.Double pt2 = null;
        Point2D.Double pt3 = null;
        int length = 40;
        if (SymbolUtilities.isCBRNEvent(symbolID)) {
            length = (int)Math.round(bounds.getHeight() / 2.0);
        } else if (SymbolUtilities.isHQ(symbolID)) {
            length = SymbolUtilities.hasRectangleFrame(symbolID) ? (int)Math.round(bounds.getHeight()) : (int)Math.round(bounds.getHeight() * 0.7);
        } else if (bounds.getHeight() >= 100.0) {
            length = (int)Math.round(bounds.getHeight() * 0.7);
        }
        int x1 = (int)Math.round(center.getX());
        int y1 = (int)Math.round(center.getY());
        pt1 = new Point2D.Double(x1, y1);
        if (SymbolUtilities.canSymbolHaveModifier(symbolID, "Q_DIRECTION_OF_MOVEMENT").booleanValue() && SymbolUtilities.isCBRNEvent(symbolID) || SymbolUtilities.isLand(symbolID).booleanValue()) {
            if (!SymbolUtilities.isHQ(symbolID)) {
                y1 = (int)(bounds.getY() + bounds.getHeight());
                pt1 = new Point2D.Double(x1, y1);
                if (isY && SymbolUtilities.isCBRNEvent(symbolID)) {
                    int yModifierOffset = (int)_modifierFontHeight;
                    ((Point2D)pt1).setLocation(((Point2D)pt1).getX(), ((Point2D)pt1).getY() + (double)(yModifierOffset += RS.getTextOutlineWidth()));
                }
                pt2 = new Point2D.Double(x1, y1 += length);
            } else {
                x1 = (int)bounds.getX() + 1;
                if (SymbolUtilities.hasRectangleFrame(symbolID)) {
                    y1 = (int)(bounds.getY() + bounds.getHeight());
                    pt1 = new Point2D.Double(x1, y1);
                    pt2 = new Point2D.Double(x1, y1 += length);
                } else {
                    y1 = (int)(bounds.getY() + bounds.getHeight() / 2.0);
                    pt1 = new Point2D.Double(x1, y1);
                    x2 = x1;
                    y1 = (int)(((Point2D)pt1).getY() + bounds.getHeight());
                    pt2 = new Point2D.Double(x2, y1);
                }
            }
        }
        double radians = 0.0;
        radians = (double)(angle -= 90.0f) * (Math.PI / 180);
        int dx2 = x1 + (int)((double)length * Math.cos(radians));
        int dy2 = y1 + (int)((double)length * Math.sin(radians));
        x2 = Math.round(dx2);
        int y2 = Math.round(dy2);
        float arrowWidth = 10.0f;
        float theta = 0.423f;
        if (length < 50) {
            theta = 0.55f;
        }
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        int[] vecLine = new int[2];
        int[] vecLeft = new int[2];
        xPoints[0] = x2;
        yPoints[0] = y2;
        vecLine[0] = xPoints[0] - x1;
        vecLine[1] = yPoints[0] - y1;
        vecLeft[0] = -vecLine[1];
        vecLeft[1] = vecLine[0];
        double fLength = Math.sqrt(vecLine[0] * vecLine[0] + vecLine[1] * vecLine[1]);
        double th = (double)arrowWidth / (2.0 * fLength);
        double ta = (double)arrowWidth / (2.0 * (Math.tan(theta) / 2.0) * fLength);
        double baseX = (double)xPoints[0] - ta * (double)vecLine[0];
        double baseY = (double)yPoints[0] - ta * (double)vecLine[1];
        xPoints[1] = (int)Math.round(baseX + th * (double)vecLeft[0]);
        yPoints[1] = (int)Math.round(baseY + th * (double)vecLeft[1]);
        xPoints[2] = (int)Math.round(baseX - th * (double)vecLeft[0]);
        yPoints[2] = (int)Math.round(baseY - th * (double)vecLeft[1]);
        pt3 = new Point2D.Double(Math.round(baseX), Math.round(baseY));
        arrowPoints[0] = pt1;
        arrowPoints[1] = pt2;
        arrowPoints[2] = pt3;
        arrowPoints[3] = new Point2D.Double(xPoints[0], yPoints[0]);
        arrowPoints[4] = new Point2D.Double(xPoints[1], yPoints[1]);
        arrowPoints[5] = new Point2D.Double(xPoints[2], yPoints[2]);
        return arrowPoints;
    }

    private static void drawDOMArrow(Graphics2D g2d, Point2D[] domPoints, Color color, float strokeWidth) {
        BasicStroke stroke = new BasicStroke(strokeWidth, 0, 0, 10.0f);
        Path2D.Double domPath = new Path2D.Double();
        ((Path2D)domPath).moveTo(domPoints[0].getX(), domPoints[0].getY());
        if (domPoints[1] != null) {
            ((Path2D)domPath).lineTo(domPoints[1].getX(), domPoints[1].getY());
        }
        if (domPoints[2] != null) {
            ((Path2D)domPath).lineTo(domPoints[2].getX(), domPoints[2].getY());
        }
        g2d.setStroke(stroke);
        g2d.setColor(color);
        g2d.draw(domPath);
        domPath.reset();
        ((Path2D)domPath).moveTo(domPoints[3].getX(), domPoints[3].getY());
        ((Path2D)domPath).lineTo(domPoints[4].getX(), domPoints[4].getY());
        ((Path2D)domPath).lineTo(domPoints[5].getX(), domPoints[5].getY());
        g2d.fill(domPath);
    }

    private static Rectangle2D processOperationalConditionIndicator(String symbolID, Rectangle2D symbolBounds, int offsetY) {
        Rectangle2D.Double bar = null;
        int barSize = 0;
        int pixelSize = (int)symbolBounds.getHeight();
        int status = SymbolID.getStatus(symbolID);
        if (status == 2 || status == 3 || status == 4 || status == 5) {
            if (pixelSize > 0) {
                barSize = Math.round(pixelSize / 5);
            }
            if (barSize < 2) {
                barSize = 2;
            }
            offsetY = (int)((long)offsetY + Math.round(symbolBounds.getY() + symbolBounds.getHeight()));
            bar = new Rectangle2D.Double((int)symbolBounds.getX() + 2, offsetY, (int)Math.round(symbolBounds.getWidth()) - 4, barSize);
        }
        return bar;
    }

    private static Path2D processOperationalConditionIndicatorSlash(String symbolID, Rectangle2D symbolBounds) {
        Path2D.Double path = null;
        int status = SymbolID.getStatus(symbolID);
        if (status == 3 || status == 4) {
            float widthRatio = SymbolUtilities.getUnitRatioWidth(symbolID);
            float heightRatio = SymbolUtilities.getUnitRatioHeight(symbolID);
            double slashHeight = symbolBounds.getHeight() / (double)heightRatio * (double)1.47f;
            double slashWidth = symbolBounds.getWidth() / (double)widthRatio * (double)0.85f;
            double centerX = symbolBounds.getCenterX();
            double centerY = symbolBounds.getCenterY();
            path = new Path2D.Double();
            if (status == 3) {
                ((Path2D)path).moveTo(centerX - slashWidth / 2.0, centerY + slashHeight / 2.0);
                ((Path2D)path).lineTo(centerX + slashWidth / 2.0, centerY - slashHeight / 2.0);
            } else if (status == 4) {
                ((Path2D)path).moveTo(centerX - slashWidth / 2.0, centerY + slashHeight / 2.0);
                ((Path2D)path).lineTo(centerX + slashWidth / 2.0, centerY - slashHeight / 2.0);
                ((Path2D)path).moveTo(centerX - slashWidth / 2.0, centerY - slashHeight / 2.0);
                ((Path2D)path).lineTo(centerX + slashWidth / 2.0, centerY + slashHeight / 2.0);
            }
            return path;
        }
        return path;
    }

    public static SymbolDimensionInfo processUnknownTextModifiers(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        String text;
        String cc;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle2D bounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        if ((cc = GENCLookup.getInstance().get3CharCode(SymbolID.getCountryCode(symbolID))) != null && !cc.equals("")) {
            modifiers.put("AS_COUNTRY", cc);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("C_QUANTITY") && SymbolUtilities.hasModifier(symbolID, "C_QUANTITY").booleanValue() && (text = modifiers.get("C_QUANTITY")) != null) {
            tiTemp = new TextInfo(text, 0, 0, _modifierFont, frc);
            labelBounds = RectUtilities.toRectangle(tiTemp.getTextBounds());
            labelWidth = (int)labelBounds.getWidth();
            x = (int)Math.round(symbolBounds.getX() + symbolBounds.getWidth() * 0.5 - (double)((float)labelWidth * 0.5f));
            y = (int)Math.round(symbolBounds.getY() - (double)bufferY - tiTemp.getDescent());
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("X_ALTITUDE_DEPTH") || modifiers.containsKey("Y_LOCATION")) {
            modifierValue = null;
            String xm = null;
            String ym = null;
            if (modifiers.containsKey("X_ALTITUDE_DEPTH") && SymbolUtilities.hasModifier(symbolID, "X_ALTITUDE_DEPTH").booleanValue()) {
                xm = modifiers.get("X_ALTITUDE_DEPTH");
            }
            if (modifiers.containsKey("Y_LOCATION")) {
                ym = modifiers.get("Y_LOCATION");
            }
            if (xm == null && ym != null) {
                modifierValue = ym;
            } else if (xm != null && ym == null) {
                modifierValue = xm;
            } else if (xm != null && ym != null) {
                modifierValue = xm + "  " + ym;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                if (!byLabelHeight) {
                    x = (int)Math.round(bounds.getX() - labelBounds.getWidth() - (double)bufferXL);
                    y = (int)Math.round(bounds.getY() + (double)labelHeight - tiTemp.getDescent());
                } else {
                    x = (int)(bounds.getX() - labelBounds.getWidth() - (double)bufferXL);
                    y = (int)bounds.getHeight();
                    y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                    y -= labelHeight + bufferText;
                    y = (int)(bounds.getY() + (double)y);
                }
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("G_STAFF_COMMENTS") && SymbolUtilities.hasModifier(symbolID, "G_STAFF_COMMENTS").booleanValue() && (modifierValue = modifiers.get("G_STAFF_COMMENTS")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
            if (!byLabelHeight) {
                y = (int)(bounds.getY() + (double)labelHeight - tiTemp.getDescent());
            } else {
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= labelHeight + bufferText;
                y = (int)(bounds.getY() + (double)y);
            }
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("V_EQUIP_TYPE") || modifiers.containsKey("AD_PLATFORM_TYPE") || modifiers.containsKey("AE_EQUIPMENT_TEARDOWN_TIME")) {
            String vm = null;
            String adm = null;
            String aem = null;
            if (modifiers.containsKey("V_EQUIP_TYPE") && SymbolUtilities.hasModifier(symbolID, "V_EQUIP_TYPE").booleanValue()) {
                vm = modifiers.get("V_EQUIP_TYPE");
            }
            if (modifiers.containsKey("AD_PLATFORM_TYPE") && SymbolUtilities.hasModifier(symbolID, "AD_PLATFORM_TYPE").booleanValue()) {
                adm = modifiers.get("AD_PLATFORM_TYPE");
            }
            if (modifiers.containsKey("AE_EQUIPMENT_TEARDOWN_TIME") && SymbolUtilities.hasModifier(symbolID, "AE_EQUIPMENT_TEARDOWN_TIME").booleanValue()) {
                aem = modifiers.get("AE_EQUIPMENT_TEARDOWN_TIME");
            }
            modifierValue = "";
            if (vm != null && !vm.equals("")) {
                modifierValue = vm;
            }
            if (adm != null && !adm.equals("")) {
                modifierValue = modifierValue + " " + adm;
            }
            if (aem != null && !aem.equals("")) {
                modifierValue = modifierValue + " " + aem;
            }
            if (modifierValue != null) {
                modifierValue = modifierValue.trim();
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - labelBounds.getWidth() - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)((float)y * 0.5f) + ((double)labelHeight - tiTemp.getDescent()) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("H_ADDITIONAL_INFO_1") || modifiers.containsKey("AF_COMMON_IDENTIFIER")) {
            modifierValue = "";
            String hm = "";
            String afm = "";
            hm = modifiers.get("H_ADDITIONAL_INFO_1");
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                hm = modifiers.get("H_ADDITIONAL_INFO_1");
            }
            if (modifiers.containsKey("AF_COMMON_IDENTIFIER") && SymbolUtilities.hasModifier(symbolID, "AF_COMMON_IDENTIFIER").booleanValue()) {
                afm = modifiers.get("AF_COMMON_IDENTIFIER");
            }
            modifierValue = hm + " " + afm;
            if ((modifierValue = modifierValue.trim()) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + ((double)labelHeight - tiTemp.getDescent()) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            if (!byLabelHeight) {
                x = (int)bounds.getX() - labelWidth - bufferXL;
                y = (int)(bounds.getY() + bounds.getHeight());
            } else {
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y = (int)((double)y + ((double)(labelHeight + bufferText) - tiTemp.getDescent()));
                y = (int)(bounds.getY() + (double)y);
            }
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("M_HIGHER_FORMATION") || modifiers.containsKey("AS_COUNTRY")) {
            modifierValue = "";
            if (modifiers.containsKey("M_HIGHER_FORMATION") && SymbolUtilities.hasModifier(symbolID, "M_HIGHER_FORMATION").booleanValue()) {
                modifierValue = modifierValue + modifiers.get("M_HIGHER_FORMATION");
            }
            if (modifiers.containsKey("AS_COUNTRY")) {
                if (modifierValue.length() > 0) {
                    modifierValue = modifierValue + " ";
                }
                modifierValue = modifierValue + modifiers.get("AS_COUNTRY");
            }
            if (!modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                if (!byLabelHeight) {
                    y = (int)(bounds.getY() + bounds.getHeight());
                } else {
                    y = (int)bounds.getHeight();
                    y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                    y = (int)((double)y + ((double)(labelHeight + bufferText) - tiTemp.getDescent()));
                    y = (int)bounds.getY() + y;
                }
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("Z_SPEED") && SymbolUtilities.hasModifier(symbolID, "Z_SPEED").booleanValue() && (modifierValue = modifiers.get("Z_SPEED")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
            if (!byLabelHeight) {
                y = (int)Math.round(bounds.getY() + bounds.getHeight() + (double)labelHeight + (double)bufferText);
            } else {
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y = (int)((double)(y + (labelHeight + bufferText) * 2) - tiTemp.getDescent() * 2.0);
                y = (int)Math.round(bounds.getY() + (double)y);
            }
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("J_EVALUATION_RATING") || modifiers.containsKey("K_COMBAT_EFFECTIVENESS") || modifiers.containsKey("L_SIGNATURE_EQUIP") || modifiers.containsKey("N_HOSTILE") || modifiers.containsKey("P_IFF_SIF_AIS")) {
            modifierValue = null;
            String jm = null;
            String km = null;
            String lm = null;
            String nm = null;
            String pm = null;
            if (modifiers.containsKey("J_EVALUATION_RATING")) {
                jm = modifiers.get("J_EVALUATION_RATING");
            }
            if (modifiers.containsKey("K_COMBAT_EFFECTIVENESS") && SymbolUtilities.hasModifier(symbolID, "K_COMBAT_EFFECTIVENESS").booleanValue()) {
                km = modifiers.get("K_COMBAT_EFFECTIVENESS");
            }
            if (modifiers.containsKey("L_SIGNATURE_EQUIP") && SymbolUtilities.hasModifier(symbolID, "L_SIGNATURE_EQUIP").booleanValue()) {
                lm = modifiers.get("L_SIGNATURE_EQUIP");
            }
            if (modifiers.containsKey("N_HOSTILE") && SymbolUtilities.hasModifier(symbolID, "N_HOSTILE").booleanValue()) {
                nm = modifiers.get("N_HOSTILE");
            }
            if (modifiers.containsKey("P_IFF_SIF_AIS") && SymbolUtilities.hasModifier(symbolID, "P_IFF_SIF_AIS").booleanValue()) {
                pm = modifiers.get("P_IFF_SIF_AIS");
            }
            modifierValue = "";
            if (jm != null && !jm.equals("")) {
                modifierValue = modifierValue + jm;
            }
            if (km != null && !km.equals("")) {
                modifierValue = modifierValue + " " + km;
            }
            if (lm != null && !lm.equals("")) {
                modifierValue = modifierValue + " " + lm;
            }
            if (nm != null && !nm.equals("")) {
                modifierValue = modifierValue + " " + nm;
            }
            if (pm != null && !pm.equals("")) {
                modifierValue = modifierValue + " " + pm;
            }
            if (modifierValue.length() > 2 && modifierValue.charAt(0) == ' ') {
                modifierValue = modifierValue.substring(1);
            }
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                if (!byLabelHeight) {
                    y = (int)Math.round(bounds.getY() + bounds.getHeight() + (double)labelHeight + (double)bufferText);
                } else {
                    y = (int)bounds.getHeight();
                    y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                    y = (int)((double)(y + (labelHeight + bufferText) * 2) - tiTemp.getDescent() * 2.0);
                    y = (int)Math.round(bounds.getY() + (double)y);
                }
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("W_DTG_1") && (modifierValue = modifiers.get("W_DTG_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            if (!byLabelHeight) {
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)(bounds.getY() - (double)bufferY - tiTemp.getDescent());
            } else {
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getY() + y;
            }
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("F_REINFORCED_REDUCED") || modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
            modifierValue = null;
            String E = null;
            String F = null;
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("F_REINFORCED_REDUCED") && SymbolUtilities.hasModifier(symbolID, "F_REINFORCED_REDUCED").booleanValue()) {
                F = modifiers.get("F_REINFORCED_REDUCED");
            }
            if (E != null && !E.equals("")) {
                modifierValue = E;
            }
            if (F != null && !F.equals("")) {
                if (F.toUpperCase(Locale.US) == "R") {
                    F = "(+)";
                } else if (F.toUpperCase(Locale.US) == "D") {
                    F = "(-)";
                } else if (F.toUpperCase(Locale.US) == "RD") {
                    F = "(\u00b1)";
                }
            }
            if (F != null && !F.equals("")) {
                modifierValue = modifierValue != null && !modifierValue.equals("") ? modifierValue + " " + F : F;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                if (!byLabelHeight) {
                    x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                    y = (int)(bounds.getY() - (double)bufferY - tiTemp.getDescent());
                } else {
                    x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                    y = (int)bounds.getHeight();
                    y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                    y -= (labelHeight + bufferText) * 2;
                    y = (int)bounds.getY() + y;
                }
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("AA_SPECIAL_C2_HQ") && SymbolUtilities.hasModifier(symbolID, "AA_SPECIAL_C2_HQ").booleanValue() && (modifierValue = modifiers.get("AA_SPECIAL_C2_HQ")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(symbolBounds.getX() + symbolBounds.getWidth() * 0.5 - (double)((float)labelWidth * 0.5f));
            y = (int)symbolBounds.getHeight();
            y = (int)((double)y * 0.5 + ((double)labelHeight - tiTemp.getDescent()) * 0.5);
            y = (int)symbolBounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processLandUnitTextModifiers(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        String cc;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        int ss = SymbolID.getSymbolSet(symbolID);
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        if ((cc = GENCLookup.getInstance().get3CharCode(SymbolID.getCountryCode(symbolID))) != null && !cc.equals("")) {
            modifiers.put("AS_COUNTRY", cc);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("X_ALTITUDE_DEPTH") || modifiers.containsKey("Y_LOCATION")) {
            modifierValue = null;
            String xm = null;
            String ym = null;
            if (modifiers.containsKey("X_ALTITUDE_DEPTH") && SymbolUtilities.hasModifier(symbolID, "X_ALTITUDE_DEPTH").booleanValue()) {
                xm = modifiers.get("X_ALTITUDE_DEPTH");
            }
            if (modifiers.containsKey("Y_LOCATION")) {
                ym = modifiers.get("Y_LOCATION");
            }
            if (xm == null && ym != null) {
                modifierValue = ym;
            } else if (xm != null && ym == null) {
                modifierValue = xm;
            } else if (xm != null && ym != null) {
                modifierValue = xm + "  " + ym;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - labelBounds.getWidth() - (double)bufferXL);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)(bufferText / 2) - (double)descent));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("G_STAFF_COMMENTS") && SymbolUtilities.hasModifier(symbolID, "G_STAFF_COMMENTS").booleanValue() && (modifierValue = modifiers.get("G_STAFF_COMMENTS")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y -= labelHeight + bufferText;
            y = (int)bounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
            modifierValue = null;
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                modifierValue = modifiers.get("H_ADDITIONAL_INFO_1");
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
            y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 + (double)labelHeight + (double)(bufferText / 2) - (double)descent));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("M_HIGHER_FORMATION")) {
            modifierValue = "";
            if (modifiers.containsKey("M_HIGHER_FORMATION")) {
                modifierValue = modifierValue + modifiers.get("M_HIGHER_FORMATION");
            }
            if (!modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y += labelHeight + bufferText - descent;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("Z_SPEED") && (modifierValue = modifiers.get("Z_SPEED")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)bounds.getX() - labelWidth - bufferXL;
            y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 + (double)((labelHeight - descent + bufferText) * 2)));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("J_EVALUATION_RATING") || modifiers.containsKey("K_COMBAT_EFFECTIVENESS") || modifiers.containsKey("P_IFF_SIF_AIS")) {
            modifierValue = "";
            String jm = null;
            String km = null;
            String pm = null;
            if (modifiers.containsKey("J_EVALUATION_RATING")) {
                jm = modifiers.get("J_EVALUATION_RATING");
            }
            if (modifiers.containsKey("K_COMBAT_EFFECTIVENESS")) {
                km = modifiers.get("K_COMBAT_EFFECTIVENESS");
            }
            if (modifiers.containsKey("P_IFF_SIF_AIS")) {
                pm = modifiers.get("P_IFF_SIF_AIS");
            }
            if (jm != null && !jm.equals("")) {
                modifierValue = modifierValue + jm;
            }
            if (km != null && !km.equals("")) {
                modifierValue = modifierValue + " " + km;
            }
            if (pm != null && !pm.equals("")) {
                modifierValue = modifierValue + " " + pm;
            }
            if (modifierValue.length() > 2 && modifierValue.charAt(0) == ' ') {
                modifierValue = modifierValue.substring(1);
            }
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y = y + (labelHeight + bufferText) * 2 - descent * 2;
                y = Math.round((int)bounds.getY() + y);
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("W_DTG_1") && (modifierValue = modifiers.get("W_DTG_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
            y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)bufferText - (double)descent - (double)labelHeight));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("F_REINFORCED_REDUCED") || modifiers.containsKey("E_FRAME_SHAPE_MODIFIER") || modifiers.containsKey("AS_COUNTRY")) {
            modifierValue = null;
            String E = null;
            String F = null;
            String AS = null;
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("F_REINFORCED_REDUCED")) {
                F = modifiers.get("F_REINFORCED_REDUCED");
            }
            if (modifiers.containsKey("AS_COUNTRY")) {
                AS = modifiers.get("AS_COUNTRY");
            }
            if (E != null && !E.equals("")) {
                modifierValue = E;
            }
            if (F != null && !F.equals("")) {
                if (F.toUpperCase(Locale.US) == "R") {
                    F = "(+)";
                } else if (F.toUpperCase(Locale.US) == "D") {
                    F = "(-)";
                } else if (F.toUpperCase(Locale.US) == "RD") {
                    F = "(\u00b1)";
                }
            }
            if (F != null && !F.equals("")) {
                modifierValue = modifierValue != null && !modifierValue.equals("") ? modifierValue + " " + F : F;
            }
            if (AS != null && !AS.equals("")) {
                modifierValue = modifierValue != null && !modifierValue.equals("") ? modifierValue + " " + AS : AS;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("AA_SPECIAL_C2_HQ") && SymbolUtilities.hasModifier(symbolID, "AA_SPECIAL_C2_HQ").booleanValue() && (modifierValue = modifiers.get("AA_SPECIAL_C2_HQ")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(symbolBounds.getX() + symbolBounds.getWidth() * 0.5 - (double)((float)labelWidth * 0.5f));
            y = (int)symbolBounds.getHeight();
            y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
            y = (int)symbolBounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processLandUnitTextModifiersE(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        String cc;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Color textBackgroundColor = RendererUtilities.getIdealOutlineColor(textColor);
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        int ss = SymbolID.getSymbolSet(symbolID);
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        if ((cc = GENCLookup.getInstance().get3CharCode(SymbolID.getCountryCode(symbolID))) != null && !cc.equals("")) {
            modifiers.put("AS_COUNTRY", cc);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("X_ALTITUDE_DEPTH") || modifiers.containsKey("Y_LOCATION")) {
            modifierValue = null;
            String xm = null;
            String ym = null;
            if (modifiers.containsKey("X_ALTITUDE_DEPTH") && SymbolUtilities.hasModifier(symbolID, "X_ALTITUDE_DEPTH").booleanValue()) {
                xm = modifiers.get("X_ALTITUDE_DEPTH");
            }
            if (modifiers.containsKey("Y_LOCATION")) {
                ym = modifiers.get("Y_LOCATION");
            }
            if (xm == null && ym != null) {
                modifierValue = ym;
            } else if (xm != null && ym == null) {
                modifierValue = xm;
            } else if (xm != null && ym != null) {
                modifierValue = xm + "  " + ym;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= labelHeight + bufferText;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("G_STAFF_COMMENTS") || modifiers.containsKey("AQ_GUARDED_UNIT")) {
            modifierValue = null;
            String gm = null;
            String aqm = null;
            if (modifiers.containsKey("G_STAFF_COMMENTS") && SymbolUtilities.hasModifier(symbolID, "G_STAFF_COMMENTS").booleanValue()) {
                gm = modifiers.get("G_STAFF_COMMENTS");
            }
            if (modifiers.containsKey("AQ_GUARDED_UNIT")) {
                aqm = modifiers.get("AQ_GUARDED_UNIT");
            }
            if (gm == null && aqm != null) {
                modifierValue = aqm;
            } else if (gm != null && aqm == null) {
                modifierValue = gm;
            } else if (gm != null && aqm != null) {
                modifierValue = gm + "  " + aqm;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= labelHeight + bufferText;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("H_ADDITIONAL_INFO_1") || modifiers.containsKey("AF_COMMON_IDENTIFIER")) {
            modifierValue = null;
            String hm = null;
            String afm = null;
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                hm = modifiers.get("H_ADDITIONAL_INFO_1");
            }
            if (modifiers.containsKey("AF_COMMON_IDENTIFIER")) {
                afm = modifiers.get("AF_COMMON_IDENTIFIER");
            }
            if (hm == null && afm != null) {
                modifierValue = afm;
            } else if (hm != null && afm == null) {
                modifierValue = hm;
            } else if (hm != null && afm != null) {
                modifierValue = hm + "  " + afm;
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("V_EQUIP_TYPE") || modifiers.containsKey("AD_PLATFORM_TYPE") || modifiers.containsKey("AE_EQUIPMENT_TEARDOWN_TIME")) {
            modifierValue = "";
            String vm = null;
            String adm = null;
            String aem = null;
            if (modifiers.containsKey("V_EQUIP_TYPE")) {
                vm = modifiers.get("V_EQUIP_TYPE");
            }
            if (modifiers.containsKey("AD_PLATFORM_TYPE")) {
                adm = modifiers.get("AD_PLATFORM_TYPE");
            }
            if (modifiers.containsKey("AE_EQUIPMENT_TEARDOWN_TIME")) {
                aem = modifiers.get("AE_EQUIPMENT_TEARDOWN_TIME");
            }
            if (vm != null && !vm.equals("")) {
                modifierValue = modifierValue + vm;
            }
            if (adm != null && !adm.equals("")) {
                modifierValue = modifierValue + " " + adm;
            }
            if (aem != null && !aem.equals("")) {
                modifierValue = modifierValue + " " + aem;
            }
            if ((modifierValue = modifierValue.trim()) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y += labelHeight + bufferText - descent;
            y = (int)bounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("M_HIGHER_FORMATION")) {
            modifierValue = "";
            if (modifiers.containsKey("M_HIGHER_FORMATION")) {
                modifierValue = modifierValue + modifiers.get("M_HIGHER_FORMATION");
            }
            if (!modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y += labelHeight + bufferText - descent;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("Z_SPEED") && (modifierValue = modifiers.get("Z_SPEED")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)bounds.getX() - labelWidth - bufferXL;
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y = y + (labelHeight + bufferText) * 2 - descent * 2;
            y = Math.round((int)bounds.getY() + y);
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("J_EVALUATION_RATING") || modifiers.containsKey("K_COMBAT_EFFECTIVENESS") || modifiers.containsKey("L_SIGNATURE_EQUIP") || modifiers.containsKey("P_IFF_SIF_AIS")) {
            modifierValue = "";
            String jm = null;
            String km = null;
            String lm = null;
            String pm = null;
            if (modifiers.containsKey("J_EVALUATION_RATING")) {
                jm = modifiers.get("J_EVALUATION_RATING");
            }
            if (modifiers.containsKey("K_COMBAT_EFFECTIVENESS")) {
                km = modifiers.get("K_COMBAT_EFFECTIVENESS");
            }
            if (modifiers.containsKey("L_SIGNATURE_EQUIP")) {
                lm = modifiers.get("L_SIGNATURE_EQUIP");
            }
            if (modifiers.containsKey("P_IFF_SIF_AIS")) {
                pm = modifiers.get("P_IFF_SIF_AIS");
            }
            if (jm != null && !jm.equals("")) {
                modifierValue = modifierValue + jm;
            }
            if (km != null && !km.equals("")) {
                modifierValue = modifierValue + " " + km;
            }
            if (lm != null && !lm.equals("")) {
                modifierValue = modifierValue + " " + lm;
            }
            if (pm != null && !pm.equals("")) {
                modifierValue = modifierValue + " " + pm;
            }
            if (modifierValue.length() > 2 && modifierValue.charAt(0) == ' ') {
                modifierValue = modifierValue.substring(1);
            }
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y = y + (labelHeight + bufferText) * 2 - descent * 2;
                y = Math.round((int)bounds.getY() + y);
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("W_DTG_1") && (modifierValue = modifiers.get("W_DTG_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y -= (labelHeight + bufferText) * 2;
            y = (int)bounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("F_REINFORCED_REDUCED") || modifiers.containsKey("E_FRAME_SHAPE_MODIFIER") || modifiers.containsKey("AS_COUNTRY")) {
            modifierValue = null;
            String E = null;
            String F = null;
            String AS = null;
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("F_REINFORCED_REDUCED")) {
                F = modifiers.get("F_REINFORCED_REDUCED");
            }
            if (modifiers.containsKey("AS_COUNTRY")) {
                AS = modifiers.get("AS_COUNTRY");
            }
            if (E != null && !E.equals("")) {
                modifierValue = E;
            }
            if (F != null && !F.equals("")) {
                if (F.toUpperCase(Locale.US) == "R") {
                    F = "(+)";
                } else if (F.toUpperCase(Locale.US) == "D") {
                    F = "(-)";
                } else if (F.toUpperCase(Locale.US) == "RD") {
                    F = "(\u00b1)";
                }
            }
            if (F != null && !F.equals("")) {
                modifierValue = modifierValue != null && !modifierValue.equals("") ? modifierValue + " " + F : F;
            }
            if (AS != null && !AS.equals("")) {
                modifierValue = modifierValue != null && !modifierValue.equals("") ? modifierValue + " " + AS : AS;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("AA_SPECIAL_C2_HQ") && SymbolUtilities.canSymbolHaveModifier(symbolID, "AA_SPECIAL_C2_HQ").booleanValue() && (modifierValue = modifiers.get("AA_SPECIAL_C2_HQ")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(symbolBounds.getX() + symbolBounds.getWidth() * 0.5 - (double)((float)labelWidth * 0.5f));
            y = (int)symbolBounds.getHeight();
            y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
            y = (int)symbolBounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processAirSpaceUnitTextModifiers(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("G_STAFF_COMMENTS") || modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
            String gm = "";
            String hm = "";
            if (modifiers.containsKey("G_STAFF_COMMENTS")) {
                gm = modifiers.get("G_STAFF_COMMENTS");
            }
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                hm = modifiers.get("H_ADDITIONAL_INFO_1");
            }
            modifierValue = gm + " " + hm;
            if ((modifierValue = modifierValue.trim()) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + bounds.getHeight());
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("Z_SPEED") || modifiers.containsKey("X_ALTITUDE_DEPTH")) {
            modifierValue = "";
            String zm = "";
            String xm = "";
            if (modifiers.containsKey("Z_SPEED")) {
                zm = modifiers.get("Z_SPEED");
            }
            if (modifiers.containsKey("X_ALTITUDE_DEPTH")) {
                xm = modifiers.get("X_ALTITUDE_DEPTH");
            }
            modifierValue = zm + " " + xm;
            if ((modifierValue = modifierValue.trim()) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + bounds.getHeight() - (double)labelHeight);
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("V_EQUIP_TYPE") && (modifierValue = modifiers.get("V_EQUIP_TYPE")) != null && !modifierValue.equals("")) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
            y = (int)(bounds.getY() + bounds.getHeight() - (double)(labelHeight * 2));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (SymbolUtilities.isAir(symbolID).booleanValue()) {
            if (modifiers.containsKey("P_IFF_SIF_AIS") && (modifierValue = modifiers.get("P_IFF_SIF_AIS")) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + bounds.getHeight() - (double)(labelHeight * 3));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
            if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + bounds.getHeight() - (double)(labelHeight * 4));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER") && (modifierValue = modifiers.get("E_FRAME_SHAPE_MODIFIER")) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + bounds.getHeight() - (double)(labelHeight * 5));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        } else {
            if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + bounds.getHeight() - (double)(labelHeight * 3));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER") && (modifierValue = modifiers.get("E_FRAME_SHAPE_MODIFIER")) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + bounds.getHeight() - (double)(labelHeight * 4));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processAirSpaceUnitTextModifiersE(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("G_STAFF_COMMENTS") || modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
            String gm = "";
            String hm = "";
            if (modifiers.containsKey("G_STAFF_COMMENTS")) {
                gm = modifiers.get("G_STAFF_COMMENTS");
            }
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                hm = modifiers.get("H_ADDITIONAL_INFO_1");
            }
            modifierValue = gm + " " + hm;
            if ((modifierValue = modifierValue.trim()) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + bounds.getHeight());
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("Z_SPEED") || modifiers.containsKey("X_ALTITUDE_DEPTH")) {
            modifierValue = null;
            String zm = "";
            String xm = "";
            if (modifiers.containsKey("Z_SPEED")) {
                zm = modifiers.get("Z_SPEED");
            }
            if (modifiers.containsKey("X_ALTITUDE_DEPTH")) {
                xm = modifiers.get("X_ALTITUDE_DEPTH");
            }
            modifierValue = xm + " " + zm;
            if ((modifierValue = modifierValue.trim()) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + bounds.getHeight() - (double)labelHeight);
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("V_EQUIP_TYPE") || modifiers.containsKey("AF_COMMON_IDENTIFIER")) {
            modifierValue = null;
            String vm = "";
            String afm = "";
            if (modifiers.containsKey("V_EQUIP_TYPE")) {
                vm = modifiers.get("V_EQUIP_TYPE");
            }
            if (modifiers.containsKey("AF_COMMON_IDENTIFIER") && SymbolID.getSymbolSet(symbolID) == 1) {
                afm = modifiers.get("AF_COMMON_IDENTIFIER");
            }
            modifierValue = vm + " " + afm;
            if ((modifierValue = modifierValue.trim()) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + bounds.getHeight() - (double)(labelHeight * 2));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null && !modifierValue.equals("")) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
            y = (int)(bounds.getY() + bounds.getHeight() - (double)(labelHeight * 3));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("AS_COUNTRY") || modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
            modifierValue = null;
            String em = "";
            String asm = "";
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                em = modifiers.get("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("AS_COUNTRY")) {
                asm = modifiers.get("AS_COUNTRY");
            }
            modifierValue = em + " " + asm;
            if ((modifierValue = modifierValue.trim()) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + bounds.getHeight() - (double)(labelHeight * 4));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processLandEquipmentTextModifiers(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        String text;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("C_QUANTITY") && (text = modifiers.get("C_QUANTITY")) != null) {
            tiTemp = new TextInfo(text, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)Math.round(symbolBounds.getX() + symbolBounds.getWidth() * 0.5 - (double)((float)labelWidth * 0.5f));
            y = (int)Math.round(symbolBounds.getY() - (double)bufferY - (double)descent);
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("X_ALTITUDE_DEPTH") || modifiers.containsKey("Y_LOCATION")) {
            modifierValue = null;
            String xm = null;
            String ym = null;
            if (modifiers.containsKey("X_ALTITUDE_DEPTH")) {
                xm = modifiers.get("X_ALTITUDE_DEPTH");
            }
            if (modifiers.containsKey("Y_LOCATION")) {
                ym = modifiers.get("Y_LOCATION");
            }
            if (xm == null && ym != null) {
                modifierValue = ym;
            } else if (xm != null && ym == null) {
                modifierValue = xm;
            } else if (xm != null && ym != null) {
                modifierValue = xm + "  " + ym;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - labelBounds.getWidth() - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= labelHeight + bufferText;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("G_STAFF_COMMENTS") || modifiers.containsKey("AQ_GUARDED_UNIT")) {
            modifierValue = "";
            String mg = "";
            String maq = "";
            if (modifiers.containsKey("G_STAFF_COMMENTS")) {
                mg = modifiers.get("G_STAFF_COMMENTS");
            }
            if (modifiers.containsKey("AQ_GUARDED_UNIT")) {
                maq = modifiers.get("AQ_GUARDED_UNIT");
            }
            modifierValue = mg + " " + maq;
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= labelHeight + bufferText;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("H_ADDITIONAL_INFO_1") | modifiers.containsKey("AF_COMMON_IDENTIFIER")) {
            modifierValue = "";
            String hm = "";
            String afm = "";
            hm = modifiers.get("H_ADDITIONAL_INFO_1");
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                hm = modifiers.get("H_ADDITIONAL_INFO_1");
            }
            if (modifiers.containsKey("AF_COMMON_IDENTIFIER")) {
                afm = modifiers.get("AF_COMMON_IDENTIFIER");
            }
            modifierValue = hm + " " + afm;
            if ((modifierValue = modifierValue.trim()) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - labelBounds.getWidth() - (double)bufferXL);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y += labelHeight + bufferText - descent;
            y = (int)bounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("Z_SPEED") && (modifierValue = modifiers.get("Z_SPEED")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y = y + (labelHeight + bufferText) * 2 - descent * 2;
            y = (int)Math.round(bounds.getY() + (double)y);
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("J_EVALUATION_RATING") || modifiers.containsKey("L_SIGNATURE_EQUIP") || modifiers.containsKey("N_HOSTILE") || modifiers.containsKey("P_IFF_SIF_AIS")) {
            modifierValue = null;
            String jm = null;
            String lm = null;
            String nm = null;
            String pm = null;
            if (modifiers.containsKey("J_EVALUATION_RATING")) {
                jm = modifiers.get("J_EVALUATION_RATING");
            }
            if (modifiers.containsKey("L_SIGNATURE_EQUIP") && SymbolUtilities.canSymbolHaveModifier(symbolID, "L_SIGNATURE_EQUIP").booleanValue()) {
                lm = modifiers.get("L_SIGNATURE_EQUIP");
            }
            if (modifiers.containsKey("N_HOSTILE") && SymbolUtilities.canSymbolHaveModifier(symbolID, "N_HOSTILE").booleanValue()) {
                nm = modifiers.get("N_HOSTILE");
            }
            if (modifiers.containsKey("P_IFF_SIF_AIS") && SymbolUtilities.canSymbolHaveModifier(symbolID, "P_IFF_SIF_AIS").booleanValue()) {
                pm = modifiers.get("P_IFF_SIF_AIS");
            }
            modifierValue = "";
            if (jm != null && !jm.equals("")) {
                modifierValue = modifierValue + jm;
            }
            if (lm != null && !lm.equals("")) {
                modifierValue = modifierValue + " " + lm;
            }
            if (nm != null && !nm.equals("")) {
                modifierValue = modifierValue + " " + nm;
            }
            if (pm != null && !pm.equals("")) {
                modifierValue = modifierValue + " " + pm;
            }
            if (modifierValue.length() > 2 && modifierValue.charAt(0) == ' ') {
                modifierValue = modifierValue.substring(1);
            }
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y += labelHeight + bufferText - descent;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("W_DTG_1") || modifiers.containsKey("AR_SPECIAL_DESIGNATOR")) {
            modifierValue = "";
            String mw = "";
            String mar = "";
            mw = modifiers.getOrDefault("W_DTG_1", "");
            if (modifiers.containsKey("AR_SPECIAL_DESIGNATOR")) {
                mar = modifiers.get("AR_SPECIAL_DESIGNATOR");
            }
            modifierValue = mw + " " + mar;
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
            modifierValue = null;
            String E = null;
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (E != null && !E.equals("")) {
                modifierValue = E;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("V_EQUIP_TYPE") || modifiers.containsKey("AD_PLATFORM_TYPE") || modifiers.containsKey("AE_EQUIPMENT_TEARDOWN_TIME")) {
            String mv = null;
            String mad = null;
            String mae = null;
            if (modifiers.containsKey("V_EQUIP_TYPE")) {
                mv = modifiers.get("V_EQUIP_TYPE");
            }
            if (modifiers.containsKey("AD_PLATFORM_TYPE")) {
                mad = modifiers.get("AD_PLATFORM_TYPE");
            }
            if (modifiers.containsKey("AE_EQUIPMENT_TEARDOWN_TIME")) {
                mae = modifiers.get("AE_EQUIPMENT_TEARDOWN_TIME");
            }
            modifierValue = "";
            if (mv != null && !mv.equals("")) {
                modifierValue = modifierValue + mv;
            }
            if (mad != null && !mad.equals("")) {
                modifierValue = modifierValue + " " + mad;
            }
            if (mae != null && !mae.equals("")) {
                modifierValue = modifierValue + " " + mae;
            }
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processLandEquipmentTextModifiersE(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        String text;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("C_QUANTITY") && (text = modifiers.get("C_QUANTITY")) != null) {
            tiTemp = new TextInfo(text, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)Math.round(symbolBounds.getX() + symbolBounds.getWidth() * 0.5 - (double)((float)labelWidth * 0.5f));
            y = (int)Math.round(symbolBounds.getY() - (double)bufferY - (double)descent);
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("X_ALTITUDE_DEPTH") || modifiers.containsKey("Y_LOCATION")) {
            modifierValue = null;
            String xm = null;
            String ym = null;
            if (modifiers.containsKey("X_ALTITUDE_DEPTH")) {
                xm = modifiers.get("X_ALTITUDE_DEPTH");
            }
            if (modifiers.containsKey("Y_LOCATION")) {
                ym = modifiers.get("Y_LOCATION");
            }
            if (xm == null && ym != null) {
                modifierValue = ym;
            } else if (xm != null && ym == null) {
                modifierValue = xm;
            } else if (xm != null && ym != null) {
                modifierValue = xm + "  " + ym;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - labelBounds.getWidth() - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= labelHeight + bufferText;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("G_STAFF_COMMENTS") || modifiers.containsKey("AQ_GUARDED_UNIT")) {
            modifierValue = "";
            String mg = "";
            String maq = "";
            if (modifiers.containsKey("G_STAFF_COMMENTS")) {
                mg = modifiers.get("G_STAFF_COMMENTS");
            }
            if (modifiers.containsKey("AQ_GUARDED_UNIT")) {
                maq = modifiers.get("AQ_GUARDED_UNIT");
            }
            modifierValue = mg + " " + maq;
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= labelHeight + bufferText;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("H_ADDITIONAL_INFO_1") || modifiers.containsKey("AF_COMMON_IDENTIFIER")) {
            modifierValue = "";
            String hm = "";
            String afm = "";
            hm = modifiers.get("H_ADDITIONAL_INFO_1");
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                hm = modifiers.get("H_ADDITIONAL_INFO_1");
            }
            if (modifiers.containsKey("AF_COMMON_IDENTIFIER")) {
                afm = modifiers.get("AF_COMMON_IDENTIFIER");
            }
            modifierValue = hm + " " + afm;
            if ((modifierValue = modifierValue.trim()) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - labelBounds.getWidth() - (double)bufferXL);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y += labelHeight + bufferText - descent;
            y = (int)bounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("M_HIGHER_FORMATION")) {
            modifierValue = "";
            if (modifiers.containsKey("M_HIGHER_FORMATION")) {
                modifierValue = modifierValue + modifiers.get("M_HIGHER_FORMATION");
            }
            if (!modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y += labelHeight + bufferText - descent;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("Z_SPEED") && (modifierValue = modifiers.get("Z_SPEED")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y = y + (labelHeight + bufferText) * 2 - descent * 2;
            y = (int)Math.round(bounds.getY() + (double)y);
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("J_EVALUATION_RATING") || modifiers.containsKey("K_COMBAT_EFFECTIVENESS") || modifiers.containsKey("L_SIGNATURE_EQUIP") || modifiers.containsKey("P_IFF_SIF_AIS")) {
            modifierValue = null;
            String jm = null;
            String km = null;
            String lm = null;
            String pm = null;
            if (modifiers.containsKey("J_EVALUATION_RATING")) {
                jm = modifiers.get("J_EVALUATION_RATING");
            }
            if (modifiers.containsKey("K_COMBAT_EFFECTIVENESS")) {
                km = modifiers.get("K_COMBAT_EFFECTIVENESS");
            }
            if (modifiers.containsKey("L_SIGNATURE_EQUIP") && SymbolUtilities.canSymbolHaveModifier(symbolID, "L_SIGNATURE_EQUIP").booleanValue()) {
                lm = modifiers.get("L_SIGNATURE_EQUIP");
            }
            if (modifiers.containsKey("P_IFF_SIF_AIS") && SymbolUtilities.canSymbolHaveModifier(symbolID, "P_IFF_SIF_AIS").booleanValue()) {
                pm = modifiers.get("P_IFF_SIF_AIS");
            }
            modifierValue = "";
            if (jm != null && !jm.equals("")) {
                modifierValue = modifierValue + jm;
            }
            if (km != null && !km.equals("")) {
                modifierValue = modifierValue + km;
            }
            if (lm != null && !lm.equals("")) {
                modifierValue = modifierValue + " " + lm;
            }
            if (pm != null && !pm.equals("")) {
                modifierValue = modifierValue + " " + pm;
            }
            if (modifierValue.length() > 2 && modifierValue.charAt(0) == ' ') {
                modifierValue = modifierValue.substring(1);
            }
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y = y + (labelHeight + bufferText) * 2 - descent * 2;
                y = Math.round((int)bounds.getY() + y);
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("W_DTG_1") && (modifierValue = modifiers.get("W_DTG_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y -= (labelHeight + bufferText) * 2;
            y = (int)bounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("V_EQUIP_TYPE") || modifiers.containsKey("AD_PLATFORM_TYPE") || modifiers.containsKey("AE_EQUIPMENT_TEARDOWN_TIME")) {
            String mv = null;
            String mad = null;
            String mae = null;
            if (modifiers.containsKey("V_EQUIP_TYPE")) {
                mv = modifiers.get("V_EQUIP_TYPE");
            }
            if (modifiers.containsKey("AD_PLATFORM_TYPE")) {
                mad = modifiers.get("AD_PLATFORM_TYPE");
            }
            if (modifiers.containsKey("AE_EQUIPMENT_TEARDOWN_TIME")) {
                mae = modifiers.get("AE_EQUIPMENT_TEARDOWN_TIME");
            }
            modifierValue = "";
            if (mv != null && !mv.equals("")) {
                modifierValue = modifierValue + mv;
            }
            if (mad != null && !mad.equals("")) {
                modifierValue = modifierValue + " " + mad;
            }
            if (mae != null && !mae.equals("")) {
                modifierValue = modifierValue + " " + mae;
            }
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("AS_COUNTRY") || modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
            modifierValue = "";
            String E = null;
            String AS = null;
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("AS_COUNTRY")) {
                AS = modifiers.get("AS_COUNTRY");
            }
            if (E != null && !E.equals("")) {
                modifierValue = modifierValue + E;
            }
            if (AS != null && !AS.equals("")) {
                modifierValue = modifierValue + " " + AS;
            }
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processLandInstallationTextModifiers(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("G_STAFF_COMMENTS")) {
            modifierValue = "";
            if (modifiers.containsKey("G_STAFF_COMMENTS")) {
                modifierValue = modifiers.get("G_STAFF_COMMENTS");
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= labelHeight + bufferText;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
            modifierValue = "";
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                modifierValue = modifiers.get("H_ADDITIONAL_INFO_1");
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - labelBounds.getWidth() - (double)bufferXL);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y += labelHeight + bufferText - descent;
            y = (int)bounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("J_EVALUATION_RATING") || modifiers.containsKey("K_COMBAT_EFFECTIVENESS") || modifiers.containsKey("P_IFF_SIF_AIS")) {
            modifierValue = null;
            String jm = null;
            String km = null;
            String pm = null;
            if (modifiers.containsKey("J_EVALUATION_RATING")) {
                jm = modifiers.get("J_EVALUATION_RATING");
            }
            if (modifiers.containsKey("K_COMBAT_EFFECTIVENESS") && SymbolUtilities.canSymbolHaveModifier(symbolID, "K_COMBAT_EFFECTIVENESS").booleanValue()) {
                km = modifiers.get("K_COMBAT_EFFECTIVENESS");
            }
            if (modifiers.containsKey("P_IFF_SIF_AIS") && SymbolUtilities.canSymbolHaveModifier(symbolID, "P_IFF_SIF_AIS").booleanValue()) {
                pm = modifiers.get("P_IFF_SIF_AIS");
            }
            modifierValue = "";
            if (jm != null && !jm.equals("")) {
                modifierValue = modifierValue + jm;
            }
            if (km != null && !km.equals("")) {
                modifierValue = modifierValue + " " + km;
            }
            if (pm != null && !pm.equals("")) {
                modifierValue = modifierValue + " " + pm;
            }
            if (modifierValue.length() > 2 && modifierValue.charAt(0) == ' ') {
                modifierValue = modifierValue.substring(1);
            }
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y += labelHeight + bufferText - descent;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("W_DTG_1")) {
            modifierValue = "";
            String mw = "";
            String mar = "";
            modifierValue = modifiers.get("W_DTG_1");
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= labelHeight + bufferText;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
            modifierValue = null;
            String E = null;
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (E != null && !E.equals("")) {
                modifierValue = E;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("X_ALTITUDE_DEPTH") || modifiers.containsKey("Y_LOCATION")) {
            String mx = null;
            String my = null;
            if (modifiers.containsKey("X_ALTITUDE_DEPTH")) {
                mx = modifiers.get("X_ALTITUDE_DEPTH");
            }
            if (modifiers.containsKey("Y_LOCATION")) {
                my = modifiers.get("Y_LOCATION");
            }
            modifierValue = "";
            if (mx != null && !mx.equals("")) {
                modifierValue = modifierValue + mx;
            }
            if (my != null && !my.equals("")) {
                modifierValue = modifierValue + " " + my;
            }
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processLandInstallationTextModifiersE(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("G_STAFF_COMMENTS") || modifiers.containsKey("AQ_GUARDED_UNIT")) {
            modifierValue = "";
            String mg = "";
            String maq = "";
            if (modifiers.containsKey("G_STAFF_COMMENTS")) {
                mg = modifiers.get("G_STAFF_COMMENTS");
            }
            if (modifiers.containsKey("AQ_GUARDED_UNIT")) {
                maq = modifiers.get("AQ_GUARDED_UNIT");
            }
            modifierValue = mg + " " + maq;
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= labelHeight + bufferText;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
            modifierValue = "";
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                modifierValue = modifiers.get("H_ADDITIONAL_INFO_1");
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("AE_EQUIPMENT_TEARDOWN_TIME") && (modifierValue = modifiers.get("AE_EQUIPMENT_TEARDOWN_TIME")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - labelBounds.getWidth() - (double)bufferXL);
            y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 + (double)labelHeight + (double)(bufferText / 2) - (double)descent));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - labelBounds.getWidth() - (double)bufferXL);
            y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 + (double)((labelHeight - descent + bufferText) * 2)));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("M_HIGHER_FORMATION")) {
            modifierValue = "";
            if (modifiers.containsKey("M_HIGHER_FORMATION")) {
                modifierValue = modifierValue + modifiers.get("M_HIGHER_FORMATION");
            }
            if (!modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y += labelHeight + bufferText - descent;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("J_EVALUATION_RATING") || modifiers.containsKey("K_COMBAT_EFFECTIVENESS") || modifiers.containsKey("P_IFF_SIF_AIS")) {
            modifierValue = null;
            String jm = null;
            String km = null;
            String pm = null;
            if (modifiers.containsKey("J_EVALUATION_RATING")) {
                jm = modifiers.get("J_EVALUATION_RATING");
            }
            if (modifiers.containsKey("K_COMBAT_EFFECTIVENESS") && SymbolUtilities.canSymbolHaveModifier(symbolID, "K_COMBAT_EFFECTIVENESS").booleanValue()) {
                km = modifiers.get("K_COMBAT_EFFECTIVENESS");
            }
            if (modifiers.containsKey("P_IFF_SIF_AIS") && SymbolUtilities.canSymbolHaveModifier(symbolID, "P_IFF_SIF_AIS").booleanValue()) {
                pm = modifiers.get("P_IFF_SIF_AIS");
            }
            modifierValue = "";
            if (jm != null && !jm.equals("")) {
                modifierValue = modifierValue + jm;
            }
            if (km != null && !km.equals("")) {
                modifierValue = modifierValue + " " + km;
            }
            if (pm != null && !pm.equals("")) {
                modifierValue = modifierValue + " " + pm;
            }
            if (modifierValue.length() > 2 && modifierValue.charAt(0) == ' ') {
                modifierValue = modifierValue.substring(1);
            }
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y = y + (labelHeight + bufferText) * 2 - descent * 2;
                y = Math.round((int)bounds.getY() + y);
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("W_DTG_1")) {
            modifierValue = "";
            String mw = "";
            String mar = "";
            modifierValue = modifiers.get("W_DTG_1");
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)bufferText - (double)descent - (double)labelHeight));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("AS_COUNTRY") || modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
            modifierValue = "";
            String E = null;
            String AS = null;
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("AS_COUNTRY")) {
                AS = modifiers.get("AS_COUNTRY");
            }
            if (E != null && !E.equals("")) {
                modifierValue = modifierValue + E;
            }
            if (AS != null && !AS.equals("")) {
                modifierValue = modifierValue + " " + AS;
            }
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("X_ALTITUDE_DEPTH") || modifiers.containsKey("Y_LOCATION")) {
            String mx = null;
            String my = null;
            if (modifiers.containsKey("X_ALTITUDE_DEPTH")) {
                mx = modifiers.get("X_ALTITUDE_DEPTH");
            }
            if (modifiers.containsKey("Y_LOCATION")) {
                my = modifiers.get("Y_LOCATION");
            }
            modifierValue = "";
            if (mx != null && !mx.equals("")) {
                modifierValue = modifierValue + mx;
            }
            if (my != null && !my.equals("")) {
                modifierValue = modifierValue + " " + my;
            }
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)(bufferText / 2) - (double)descent));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processDismountedIndividualsTextModifiers(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("X_ALTITUDE_DEPTH") || modifiers.containsKey("Y_LOCATION")) {
            modifierValue = null;
            String xm = null;
            String ym = null;
            if (modifiers.containsKey("X_ALTITUDE_DEPTH")) {
                xm = modifiers.get("X_ALTITUDE_DEPTH");
            }
            if (modifiers.containsKey("Y_LOCATION")) {
                ym = modifiers.get("Y_LOCATION");
            }
            if (xm == null && ym != null) {
                modifierValue = ym;
            } else if (xm != null && ym == null) {
                modifierValue = xm;
            } else if (xm != null && ym != null) {
                modifierValue = xm + "  " + ym;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - labelBounds.getWidth() - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= labelHeight + bufferText;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("G_STAFF_COMMENTS")) {
            modifierValue = null;
            if (modifiers.containsKey("G_STAFF_COMMENTS")) {
                modifierValue = modifiers.get("G_STAFF_COMMENTS");
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= labelHeight + bufferText;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
            modifierValue = null;
            String hm = "";
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                modifierValue = modifiers.get("H_ADDITIONAL_INFO_1");
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - labelBounds.getWidth() - (double)bufferXL);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y += labelHeight + bufferText - descent;
            y = (int)bounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("M_HIGHER_FORMATION")) {
            modifierValue = "";
            if (modifiers.containsKey("M_HIGHER_FORMATION")) {
                modifierValue = modifierValue + modifiers.get("M_HIGHER_FORMATION");
            }
            if (!modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y += labelHeight + bufferText - descent;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("Z_SPEED") && (modifierValue = modifiers.get("Z_SPEED")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y = y + (labelHeight + bufferText) * 2 - descent * 2;
            y = (int)Math.round(bounds.getY() + (double)y);
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("J_EVALUATION_RATING") || modifiers.containsKey("K_COMBAT_EFFECTIVENESS") || modifiers.containsKey("P_IFF_SIF_AIS")) {
            modifierValue = null;
            String jm = null;
            String km = null;
            String pm = null;
            if (modifiers.containsKey("J_EVALUATION_RATING")) {
                jm = modifiers.get("J_EVALUATION_RATING");
            }
            if (modifiers.containsKey("K_COMBAT_EFFECTIVENESS") && SymbolUtilities.canSymbolHaveModifier(symbolID, "K_COMBAT_EFFECTIVENESS").booleanValue()) {
                km = modifiers.get("K_COMBAT_EFFECTIVENESS");
            }
            if (modifiers.containsKey("P_IFF_SIF_AIS") && SymbolUtilities.canSymbolHaveModifier(symbolID, "P_IFF_SIF_AIS").booleanValue()) {
                pm = modifiers.get("P_IFF_SIF_AIS");
            }
            modifierValue = "";
            if (jm != null && !jm.equals("")) {
                modifierValue = modifierValue + jm;
            }
            if (km != null && !km.equals("")) {
                modifierValue = modifierValue + " " + km;
            }
            if (pm != null && !pm.equals("")) {
                modifierValue = modifierValue + " " + pm;
            }
            if (modifierValue.length() > 2 && modifierValue.charAt(0) == ' ') {
                modifierValue = modifierValue.substring(1);
            }
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y = y + (labelHeight + bufferText) * 2 - descent * 2;
                y = Math.round((int)bounds.getY() + y);
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("W_DTG_1")) {
            modifierValue = null;
            modifierValue = modifiers.get("W_DTG_1");
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("V_EQUIP_TYPE") || modifiers.containsKey("AF_COMMON_IDENTIFIER")) {
            String mv = null;
            String maf = null;
            if (modifiers.containsKey("V_EQUIP_TYPE")) {
                mv = modifiers.get("V_EQUIP_TYPE");
            }
            if (modifiers.containsKey("AF_COMMON_IDENTIFIER")) {
                maf = modifiers.get("AF_COMMON_IDENTIFIER");
            }
            modifierValue = "";
            if (mv != null && !mv.equals("")) {
                modifierValue = modifierValue + mv;
            }
            if (maf != null && !maf.equals("")) {
                modifierValue = modifierValue + " " + maf;
            }
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("AS_COUNTRY") || modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
            modifierValue = "";
            String E = null;
            String AS = null;
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("AS_COUNTRY")) {
                AS = modifiers.get("AS_COUNTRY");
            }
            if (E != null && !E.equals("")) {
                modifierValue = modifierValue + E;
            }
            if (AS != null && !AS.equals("")) {
                modifierValue = modifierValue + " " + AS;
            }
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processSeaSurfaceTextModifiers(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("V_EQUIP_TYPE") && (modifierValue = modifiers.get("V_EQUIP_TYPE")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y -= labelHeight + bufferText;
            y = (int)bounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("P_IFF_SIF_AIS")) {
            modifierValue = null;
            if (modifiers.containsKey("P_IFF_SIF_AIS")) {
                modifierValue = modifiers.get("P_IFF_SIF_AIS");
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("G_STAFF_COMMENTS") || modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
            modifierValue = "";
            String mg = "";
            String mh = "";
            if (modifiers.containsKey("G_STAFF_COMMENTS")) {
                mg = mg + modifiers.get("G_STAFF_COMMENTS");
            }
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                mh = mh + modifiers.get("H_ADDITIONAL_INFO_1");
            }
            modifierValue = mg + " " + mh;
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y += labelHeight + bufferText - descent;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("Y_LOCATION") || modifiers.containsKey("Z_SPEED")) {
            modifierValue = null;
            String ym = "";
            String zm = "";
            if (modifiers.containsKey("Y_LOCATION")) {
                ym = modifiers.get("Y_LOCATION");
            }
            if (modifiers.containsKey("Z_SPEED")) {
                zm = modifiers.get("Z_SPEED");
            }
            modifierValue = ym + " " + zm;
            if ((modifierValue = modifierValue.trim()).length() > 2 && modifierValue.charAt(0) == ' ') {
                modifierValue = modifierValue.substring(1);
            }
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y = y + (labelHeight + bufferText) * 2 - descent * 2;
                y = (int)Math.round(bounds.getY() + (double)y);
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("AQ_GUARDED_UNIT") || modifiers.containsKey("AR_SPECIAL_DESIGNATOR")) {
            modifierValue = null;
            String maq = "";
            String mar = "";
            if (modifiers.containsKey("AQ_GUARDED_UNIT")) {
                maq = modifiers.get("AQ_GUARDED_UNIT");
            }
            if (modifiers.containsKey("AR_SPECIAL_DESIGNATOR")) {
                mar = modifiers.get("AR_SPECIAL_DESIGNATOR");
            }
            modifierValue = maq + " " + mar;
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getY() + y;
                if ((double)y <= bounds.getY() + (double)labelHeight) {
                    y = (int)bounds.getY() + labelHeight;
                }
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER") || modifiers.containsKey("T_UNIQUE_DESIGNATION_1")) {
            modifierValue = null;
            String E = null;
            String T = null;
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1")) {
                T = modifiers.get("T_UNIQUE_DESIGNATION_1");
            }
            if (E != null && !E.equals("")) {
                modifierValue = E;
            }
            if (T != null && !T.equals("")) {
                modifierValue = modifierValue != null && !modifierValue.equals("") ? modifierValue + " " + T : T;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processSeaSurfaceTextModifiersE(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("V_EQUIP_TYPE") && (modifierValue = modifiers.get("V_EQUIP_TYPE")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
            y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)(bufferText / 2) - (double)descent));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("P_IFF_SIF_AIS")) {
            modifierValue = null;
            if (modifiers.containsKey("P_IFF_SIF_AIS")) {
                modifierValue = modifiers.get("P_IFF_SIF_AIS");
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 + (double)labelHeight + (double)(bufferText / 2) - (double)descent));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("G_STAFF_COMMENTS") || modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
            modifierValue = "";
            String mg = "";
            String mh = "";
            if (modifiers.containsKey("G_STAFF_COMMENTS")) {
                mg = mg + modifiers.get("G_STAFF_COMMENTS");
            }
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                mh = mh + modifiers.get("H_ADDITIONAL_INFO_1");
            }
            modifierValue = mg + " " + mh;
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 + (double)((labelHeight - descent + bufferText) * 2)));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("Y_LOCATION") || modifiers.containsKey("Z_SPEED")) {
            modifierValue = null;
            String ym = "";
            String zm = "";
            if (modifiers.containsKey("Y_LOCATION")) {
                ym = modifiers.get("Y_LOCATION");
            }
            if (modifiers.containsKey("Z_SPEED")) {
                zm = modifiers.get("Z_SPEED");
            }
            modifierValue = ym + " " + zm;
            if ((modifierValue = modifierValue.trim()).length() > 2 && modifierValue.charAt(0) == ' ') {
                modifierValue = modifierValue.substring(1);
            }
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 + (double)((labelHeight - descent + bufferText) * 3)));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("AQ_GUARDED_UNIT") || modifiers.containsKey("AR_SPECIAL_DESIGNATOR")) {
            modifierValue = null;
            String maq = "";
            String mar = "";
            if (modifiers.containsKey("AQ_GUARDED_UNIT")) {
                maq = modifiers.get("AQ_GUARDED_UNIT");
            }
            if (modifiers.containsKey("AR_SPECIAL_DESIGNATOR")) {
                mar = modifiers.get("AR_SPECIAL_DESIGNATOR");
            }
            modifierValue = maq + " " + mar;
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)bufferText - (double)descent - (double)(labelHeight * 2)));
                if ((double)y <= bounds.getY() + (double)labelHeight) {
                    y = (int)bounds.getY() + labelHeight - descent;
                }
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER") || modifiers.containsKey("AS_COUNTRY")) {
            modifierValue = null;
            String E = null;
            String AS = null;
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("AS_COUNTRY")) {
                AS = modifiers.get("AS_COUNTRY");
            }
            if (E != null && !E.equals("")) {
                modifierValue = E;
            }
            if (AS != null && !AS.equals("")) {
                modifierValue = modifierValue != null && !modifierValue.equals("") ? modifierValue + " " + AS : AS;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)bufferText - (double)descent - (double)(labelHeight * 2)));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1")) {
            modifierValue = null;
            if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1")) {
                modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1");
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)bufferText - (double)descent - (double)labelHeight));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processSeaSubSurfaceTextModifiers(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER") || modifiers.containsKey("T_UNIQUE_DESIGNATION_1")) {
            String em = "";
            String tm = "";
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                em = modifiers.get("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1")) {
                tm = modifiers.get("T_UNIQUE_DESIGNATION_1");
            }
            modifierValue = em + " " + tm;
            if ((modifierValue = modifierValue.trim()) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getMinY() + (double)labelHeight - (double)descent);
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("V_EQUIP_TYPE")) {
            modifierValue = "";
            if (modifiers.containsKey("V_EQUIP_TYPE")) {
                modifierValue = modifiers.get("V_EQUIP_TYPE");
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getMinY() - (double)descent + (double)(labelHeight * 2));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("X_ALTITUDE_DEPTH") && (modifierValue = modifiers.get("X_ALTITUDE_DEPTH")) != null && !modifierValue.equals("")) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
            y = (int)(bounds.getMinY() - (double)descent + (double)(labelHeight * 3));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("G_STAFF_COMMENTS") && (modifierValue = modifiers.get("G_STAFF_COMMENTS")) != null && !modifierValue.equals("")) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
            y = (int)(bounds.getMinY() - (double)descent + (double)(labelHeight * 4));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("H_ADDITIONAL_INFO_1") && (modifierValue = modifiers.get("H_ADDITIONAL_INFO_1")) != null && !modifierValue.equals("")) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
            y = (int)(bounds.getMinY() - (double)descent + (double)(labelHeight * 5));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("AR_SPECIAL_DESIGNATOR")) {
            modifierValue = "";
            if (modifiers.containsKey("AR_SPECIAL_DESIGNATOR")) {
                modifierValue = modifiers.get("AR_SPECIAL_DESIGNATOR");
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() - (double)labelWidth - (double)bufferXL);
                y = (int)(bounds.getMinY() + (double)labelHeight - (double)descent);
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processSeaSubSurfaceTextModifiersE(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("V_EQUIP_TYPE") && (modifierValue = modifiers.get("V_EQUIP_TYPE")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
            y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)(bufferText / 2) - (double)descent));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("X_ALTITUDE_DEPTH") || modifiers.containsKey("P_IFF_SIF_AIS")) {
            modifierValue = "";
            String mx = "";
            String mp = "";
            if (modifiers.containsKey("X_ALTITUDE_DEPTH")) {
                modifierValue = modifiers.get("X_ALTITUDE_DEPTH");
            }
            if (modifiers.containsKey("P_IFF_SIF_AIS")) {
                modifierValue = modifierValue + " " + modifiers.get("P_IFF_SIF_AIS");
            }
            if ((modifierValue = modifierValue.trim()) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 + (double)labelHeight + (double)(bufferText / 2) - (double)descent));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("G_STAFF_COMMENTS") || modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
            modifierValue = "";
            String mg = "";
            String mh = "";
            if (modifiers.containsKey("G_STAFF_COMMENTS")) {
                mg = mg + modifiers.get("G_STAFF_COMMENTS");
            }
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                mh = mh + modifiers.get("H_ADDITIONAL_INFO_1");
            }
            modifierValue = mg + " " + mh;
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 + (double)((labelHeight - descent + bufferText) * 2)));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("Y_LOCATION") || modifiers.containsKey("Z_SPEED")) {
            modifierValue = null;
            String ym = "";
            String zm = "";
            if (modifiers.containsKey("Y_LOCATION")) {
                ym = modifiers.get("Y_LOCATION");
            }
            if (modifiers.containsKey("Z_SPEED")) {
                zm = modifiers.get("Z_SPEED");
            }
            modifierValue = ym + " " + zm;
            if ((modifierValue = modifierValue.trim()).length() > 2 && modifierValue.charAt(0) == ' ') {
                modifierValue = modifierValue.substring(1);
            }
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 + (double)((labelHeight - descent + bufferText) * 3)));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("AR_SPECIAL_DESIGNATOR") && (modifierValue = modifiers.get("AR_SPECIAL_DESIGNATOR")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getX() - (double)labelWidth - (double)bufferXL);
            y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)bufferText - (double)descent - (double)(labelHeight * 2)));
            if ((double)y <= bounds.getY() + (double)labelHeight) {
                y = (int)bounds.getY() + labelHeight - descent;
            }
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER") || modifiers.containsKey("AS_COUNTRY")) {
            modifierValue = null;
            String E = null;
            String AS = null;
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("AS_COUNTRY")) {
                AS = modifiers.get("AS_COUNTRY");
            }
            if (E != null && !E.equals("")) {
                modifierValue = E;
            }
            if (AS != null && !AS.equals("")) {
                modifierValue = modifierValue != null && !modifierValue.equals("") ? modifierValue + " " + AS : AS;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)bufferText - (double)descent - (double)(labelHeight * 2)));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1")) {
            modifierValue = null;
            if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1")) {
                modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1");
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)bufferText - (double)descent - (double)labelHeight));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processActivitiesTextModifiers(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        String cc;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        if ((cc = GENCLookup.getInstance().get3CharCode(SymbolID.getCountryCode(symbolID))) != null && !cc.equals("")) {
            modifiers.put("AS_COUNTRY", cc);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("Y_LOCATION")) {
            modifierValue = null;
            if (modifiers.containsKey("Y_LOCATION")) {
                modifierValue = modifiers.get("Y_LOCATION");
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() - labelBounds.getWidth() - (double)bufferXL);
                y = (int)(bounds.getMinY() + (bounds.getHeight() / 2.0 - (double)(bufferText / 2) - (double)descent));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("G_STAFF_COMMENTS") && (modifierValue = modifiers.get("G_STAFF_COMMENTS")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
            y = (int)(bounds.getMinY() + (bounds.getHeight() / 2.0 - (double)(bufferText / 2) - (double)descent));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
            modifierValue = null;
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                modifierValue = modifiers.get("H_ADDITIONAL_INFO_1");
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getMinY() + (bounds.getHeight() / 2.0 + (double)labelHeight + (double)(bufferText / 2) - (double)descent));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("J_EVALUATION_RATING")) {
            modifierValue = null;
            if (modifiers.containsKey("J_EVALUATION_RATING")) {
                modifierValue = modifiers.get("J_EVALUATION_RATING");
            }
            if (!modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getMinY() + (bounds.getHeight() / 2.0 + (double)((labelHeight - descent + bufferText) * 2)));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("W_DTG_1") && (modifierValue = modifiers.get("W_DTG_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getMinX() - (double)labelWidth - (double)bufferXL);
            y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)bufferText - (double)descent - (double)labelHeight));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER") || modifiers.containsKey("AS_COUNTRY")) {
            modifierValue = null;
            String E = "";
            String AS = "";
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("AS_COUNTRY")) {
                AS = modifiers.get("AS_COUNTRY");
            }
            modifierValue = E + " " + AS;
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)bufferText - (double)descent - (double)labelHeight));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processActivitiesTextModifiersE(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        String cc;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        if ((cc = GENCLookup.getInstance().get3CharCode(SymbolID.getCountryCode(symbolID))) != null && !cc.equals("")) {
            modifiers.put("AS_COUNTRY", cc);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("Y_LOCATION")) {
            modifierValue = null;
            if (modifiers.containsKey("Y_LOCATION")) {
                modifierValue = modifiers.get("Y_LOCATION");
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() - labelBounds.getWidth() - (double)bufferXL);
                y = (int)(bounds.getMinY() + (bounds.getHeight() / 2.0 - (double)(bufferText / 2) - (double)descent));
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (modifierValue = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y -= labelHeight + bufferText;
            y = (int)bounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("G_STAFF_COMMENTS") && (modifierValue = modifiers.get("G_STAFF_COMMENTS")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
            y = (int)bounds.getY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
            modifierValue = null;
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                modifierValue = modifiers.get("H_ADDITIONAL_INFO_1");
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y += labelHeight + bufferText - descent;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("J_EVALUATION_RATING")) {
            modifierValue = null;
            if (modifiers.containsKey("J_EVALUATION_RATING")) {
                modifierValue = modifiers.get("J_EVALUATION_RATING");
            }
            if (!modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y = y + (labelHeight + bufferText) * 2 - descent * 2;
                y = Math.round((int)bounds.getY() + y);
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("W_DTG_1") && (modifierValue = modifiers.get("W_DTG_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getMinX() - (double)labelWidth - (double)bufferXL);
            y = (int)(bounds.getY() + (bounds.getHeight() / 2.0 - (double)bufferText - (double)descent - (double)labelHeight));
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER") || modifiers.containsKey("AS_COUNTRY")) {
            modifierValue = null;
            String E = "";
            String AS = "";
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("AS_COUNTRY")) {
                AS = modifiers.get("AS_COUNTRY");
            }
            modifierValue = E + " " + AS;
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo processCyberSpaceTextModifiers(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, FontRenderContext frc) {
        int labelWidth;
        String cc;
        Object ii = null;
        Object ssi = null;
        int bufferXL = 7;
        int bufferXR = 7;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        SymbolDimensionInfo newsdi = null;
        float alpha = -1.0f;
        Color textColor = Color.BLACK;
        Object textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D labelBounds = null;
        Rectangle bounds = RectUtilities.toRectangle(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = (Rectangle2D)sdi.getSymbolBounds().clone();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle imageBounds = new Rectangle((int)sdi.getImageBounds().getX(), (int)sdi.getImageBounds().getY(), (int)sdi.getImageBounds().getWidth(), (int)sdi.getImageBounds().getHeight());
        Rectangle2D imageBoundsOld = (Rectangle2D)imageBounds.clone();
        String echelonText = SymbolUtilities.getEchelonText(SymbolID.getAmplifierDescriptor(symbolID));
        String amText = SymbolUtilities.getStandardIdentityModifier(symbolID);
        bounds = RectUtilities.toRectangle(((RectangularShape)imageBounds).getX(), bounds.getY(), ((RectangularShape)imageBounds).getWidth(), bounds.getHeight());
        boolean byLabelHeight = true;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = (int)bounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getStandardIdentityModifier(symbolID);
        }
        if (affiliationModifier != null) {
            modifiers.put("E_FRAME_SHAPE_MODIFIER", affiliationModifier);
        }
        if ((cc = GENCLookup.getInstance().get3CharCode(SymbolID.getCountryCode(symbolID))) != null && !cc.equals("")) {
            modifiers.put("AS_COUNTRY", cc);
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.containsKey("Y_LOCATION")) {
            modifierValue = null;
            if (modifiers.containsKey("Y_LOCATION")) {
                modifierValue = modifiers.get("Y_LOCATION");
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getMinY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("G_STAFF_COMMENTS") && (modifierValue = modifiers.get("G_STAFF_COMMENTS")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y -= labelHeight + bufferText;
            y = (int)bounds.getMinY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
            modifierValue = null;
            if (modifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                modifierValue = modifiers.get("H_ADDITIONAL_INFO_1");
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = (int)bounds.getMinY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") || modifiers.containsKey("V_EQUIP_TYPE")) {
            modifierValue = "";
            String mt = "";
            String mv = "";
            if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1")) {
                mt = modifiers.get("T_UNIQUE_DESIGNATION_1");
            }
            if (modifiers.containsKey("V_EQUIP_TYPE")) {
                mv = modifiers.get("V_EQUIP_TYPE");
            }
            modifierValue = mt + " " + mv;
            if ((modifierValue = modifierValue.trim()) != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() - (double)labelWidth - (double)bufferXL);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y += labelHeight + bufferText - descent;
                y = (int)bounds.getMinY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("M_HIGHER_FORMATION")) {
            modifierValue = "";
            if (modifiers.containsKey("M_HIGHER_FORMATION")) {
                modifierValue = modifierValue + modifiers.get("M_HIGHER_FORMATION");
            }
            if (!modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y += labelHeight + bufferText - descent;
                y = (int)bounds.getMinY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("K_COMBAT_EFFECTIVENESS") || modifiers.containsKey("L_SIGNATURE_EQUIP")) {
            modifierValue = null;
            String km = null;
            String lm = null;
            if (modifiers.containsKey("K_COMBAT_EFFECTIVENESS")) {
                km = modifiers.get("K_COMBAT_EFFECTIVENESS");
            }
            if (modifiers.containsKey("L_SIGNATURE_EQUIP")) {
                lm = modifiers.get("L_SIGNATURE_EQUIP");
            }
            modifierValue = km + " " + lm;
            if (!(modifierValue = modifierValue.trim()).equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y = y + (labelHeight + bufferText) * 2 - descent * 2;
                y = (int)Math.round(bounds.getMinY() + (double)y);
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.containsKey("W_DTG_1") && (modifierValue = modifiers.get("W_DTG_1")) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = (int)labelBounds.getWidth();
            x = (int)(bounds.getMinX() - (double)labelWidth - (double)bufferXL);
            y = (int)bounds.getHeight();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y -= labelHeight + bufferText;
            y = (int)bounds.getMinY() + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.containsKey("F_REINFORCED_REDUCED") || modifiers.containsKey("E_FRAME_SHAPE_MODIFIER") || modifiers.containsKey("AS_COUNTRY")) {
            modifierValue = null;
            String E = null;
            String F = null;
            String AS = null;
            if (modifiers.containsKey("E_FRAME_SHAPE_MODIFIER")) {
                E = modifiers.get("E_FRAME_SHAPE_MODIFIER");
                modifiers.remove("E_FRAME_SHAPE_MODIFIER");
            }
            if (modifiers.containsKey("F_REINFORCED_REDUCED")) {
                F = modifiers.get("F_REINFORCED_REDUCED");
            }
            if (modifiers.containsKey("AS_COUNTRY")) {
                AS = modifiers.get("AS_COUNTRY");
            }
            if (E != null && !E.equals("")) {
                modifierValue = E;
            }
            if (F != null && !F.equals("")) {
                if (F.toUpperCase(Locale.US) == "R") {
                    F = "(+)";
                } else if (F.toUpperCase(Locale.US) == "D") {
                    F = "(-)";
                } else if (F.toUpperCase(Locale.US) == "RD") {
                    F = "(\u00b1)";
                }
            }
            if (F != null && !F.equals("")) {
                modifierValue = modifierValue != null && !modifierValue.equals("") ? modifierValue + " " + F : F;
            }
            if (AS != null && !AS.equals("")) {
                modifierValue = modifierValue != null && !modifierValue.equals("") ? modifierValue + " " + AS : AS;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont, frc);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = (int)labelBounds.getWidth();
                x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                y = (int)bounds.getHeight();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = (int)bounds.getMinY() + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        newsdi = ModifierRenderer.shiftUnitPointsAndDraw(tiArray, sdi, attributes);
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newsdi;
    }

    public static SymbolDimensionInfo ProcessTGSPWithSpecialModifierLayout(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, Color lineColor, FontRenderContext frc) {
        int i;
        ImageInfo ii = null;
        SVGSymbolInfo ssi = null;
        int bufferXL = 6;
        int bufferXR = 4;
        int bufferY = 2;
        int bufferText = 2;
        boolean centerOffset = true;
        int x = 0;
        int y = 0;
        int x2 = 0;
        int y2 = 0;
        int outlineOffset = RS.getTextOutlineWidth();
        int labelHeight = 0;
        int labelWidth = 0;
        float strokeWidth = 2.0f;
        float alpha = -1.0f;
        SymbolDimensionInfo newsdi = null;
        Color textColor = lineColor;
        Color textBackgroundColor = null;
        int ss = SymbolID.getSymbolSet(symbolID);
        int ec = SymbolID.getEntityCode(symbolID);
        int e = SymbolID.getEntity(symbolID);
        int et = SymbolID.getEntityType(symbolID);
        int est = SymbolID.getEntitySubtype(symbolID);
        Rectangle2D.Double fdiBounds = null;
        Point2D.Double fdiTop = null;
        Point2D.Double fdiLeft = null;
        Point2D.Double fdiRight = null;
        ArrayList<TextInfo> arrMods = new ArrayList<TextInfo>();
        boolean duplicate = false;
        Rectangle2D bounds = RectUtilities.copyRect(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = RectUtilities.copyRect(sdi.getSymbolBounds());
        Point centerPoint = new Point(sdi.getSymbolCenterPoint());
        Rectangle2D imageBounds = RectUtilities.copyRect(sdi.getImageBounds());
        if (attributes.containsKey("PIXELSIZE")) {
            int pixelSize = Integer.parseInt(attributes.get("PIXELSIZE"));
            strokeWidth = pixelSize <= 100 ? 2.0f : 2.0f + (float)(pixelSize - 100) / 100.0f;
        }
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        centerPoint = new Point(Math.round(sdi.getSymbolCenterPoint().x), Math.round(sdi.getSymbolCenterPoint().y));
        boolean byLabelHeight = false;
        labelHeight = (int)(_modifierFontHeight + 0.5f);
        int maxHeight = (int)symbolBounds.getHeight();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        int descent = (int)(_modifierFontDescent + 0.5f);
        int yForY = -1;
        Object labelBounds1 = null;
        Object labelBounds2 = null;
        String strText = "";
        String strText1 = "";
        String strText2 = "";
        Object text1 = null;
        Object text2 = null;
        outlineOffset = outlineOffset > 2 ? (outlineOffset - 1) / 2 : 0;
        TextInfo ti = null;
        if (SymbolUtilities.isCBRNEvent(symbolID) && (double)(labelHeight * 3) > bounds.getHeight()) {
            byLabelHeight = true;
        }
        if (ss == 25) {
            TextInfo ti2;
            if (ec == 130500 || ec == 130700) {
                if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (strText = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getMinX() + (double)((int)(bounds.getWidth() * 0.5)));
                    y = (int)(bounds.getMinY() + (double)((int)(bounds.getHeight() * (double)0.4f)));
                    ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y += (int)((float)labelHeight * 0.5f)));
                    arrMods.add(ti);
                }
            } else if (ec == 212800) {
                if (modifiers.containsKey("H_ADDITIONAL_INFO_1") && (strText = modifiers.get("H_ADDITIONAL_INFO_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getMinX() + (double)((int)(bounds.getWidth() * 0.5)));
                    y = (int)(bounds.getMinY() + (double)((int)(bounds.getHeight() * 0.5)));
                    ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y += (int)((float)labelHeight * 0.5f)));
                    arrMods.add(ti);
                }
            } else if (ec == 131300) {
                if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (strText = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getMinX() + (double)((int)(bounds.getWidth() * 0.5)));
                    y = (int)(bounds.getMinY() + (double)((int)(bounds.getHeight() * 0.25)));
                    ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y += (int)((float)labelHeight * 0.5f)));
                    arrMods.add(ti);
                }
            } else if (ec == 131800 || ec == 240900) {
                if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (strText = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    x = ec == 131800 ? (int)(bounds.getMinX() + bounds.getWidth() * 0.75) : (int)(bounds.getMinX() + bounds.getWidth());
                    y = (int)(bounds.getMinY() + bounds.getHeight() * 0.5);
                    ti.setLocation(Math.round(x), Math.round(y += (int)((float)(labelHeight - descent) * 0.5f)));
                    arrMods.add(ti);
                }
            } else if (ec == 131900) {
                if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (strText = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    x = (int)(bounds.getMinX() + (bounds.getWidth() + (double)bufferXR));
                    y = (int)(bounds.getMinY() + bounds.getHeight() * 0.5);
                    ti.setLocation(Math.round(x), Math.round(y += (int)((float)(labelHeight - descent) * 0.5f)));
                    arrMods.add(ti);
                }
            } else if (ec == 180100 || ec == 180200) {
                if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (strText = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)ti.getTextBounds().getWidth();
                    x = (int)(bounds.getMinX() + bounds.getWidth() * 0.5);
                    y = (int)(bounds.getMinY() + bounds.getHeight() * 0.5);
                    y = y + (int)((bounds.getHeight() * 0.5 - (double)labelHeight) / 2.0) + labelHeight - descent;
                    ti.setLocation(Math.round(x -= (int)((double)labelWidth * 0.5)), Math.round(y));
                    arrMods.add(ti);
                }
            } else if (ec == 160300 || ec == 132000 || ec == 240601 || ec == 240602) {
                if (modifiers.containsKey("H_ADDITIONAL_INFO_1") && ec == 240601 && (strText = modifiers.get("H_ADDITIONAL_INFO_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    x = (int)(bounds.getCenterX() + bounds.getWidth() * (double)0.15f);
                    y = (int)(bounds.getMinY() + bounds.getHeight() * 0.75);
                    ti.setLocation(Math.round(x), Math.round(y += (int)((float)labelHeight * 0.5f)));
                    arrMods.add(ti);
                }
                if (modifiers.containsKey("X_ALTITUDE_DEPTH") && ec == 240601 && (strText = modifiers.get("X_ALTITUDE_DEPTH")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getCenterX() - (double)((int)(bounds.getWidth() * (double)0.15f)));
                    y = (int)(bounds.getMinY() + bounds.getHeight() * 0.75);
                    ti.setLocation(Math.round(x -= labelWidth), Math.round(y += (int)((float)labelHeight * 0.5f)));
                    arrMods.add(ti);
                }
                if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (ec == 160300 || ec == 132000)) {
                    strText = modifiers.get("T_UNIQUE_DESIGNATION_1");
                }
                if (ec == 240601 || ec == 240602) {
                    if (modifiers.containsKey("AP_TARGET_NUMBER")) {
                        strText = modifiers.get("AP_TARGET_NUMBER");
                    }
                    if (ec == 240601 && modifiers.containsKey("AP1_TARGET_NUMBER_EXTENSION")) {
                        strText = strText != null ? strText + "  " + modifiers.get("AP1_TARGET_NUMBER_EXTENSION") : modifiers.get("AP1_TARGET_NUMBER_EXTENSION");
                    }
                }
                if (strText != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    x = (int)(bounds.getCenterX() + bounds.getWidth() * (double)0.15f);
                    y = (int)(bounds.getMinY() + bounds.getHeight() * 0.25);
                    ti.setLocation(Math.round(x), Math.round(y += (int)((float)labelHeight * 0.5f)));
                    arrMods.add(ti);
                }
            } else if (ec == 132100) {
                if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (strText = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    x = (int)(bounds.getMinX() + (bounds.getWidth() * 0.5 + (double)bufferXR));
                    y = (int)(bounds.getMinY() + bounds.getHeight() * 0.5);
                    ti.setLocation(Math.round(x), Math.round(y += (int)((float)(labelHeight - descent) * 0.5f)));
                    arrMods.add(ti);
                }
            } else if (SymbolUtilities.isCBRNEvent(symbolID)) {
                if (modifiers.containsKey("N_HOSTILE") && (strText = modifiers.get("N_HOSTILE")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                    y = !byLabelHeight ? (int)(bounds.getMinY() + bounds.getHeight()) : (int)(bounds.getMinY() + (bounds.getHeight() * 0.5 + (double)(labelHeight - descent) * 0.5 + (double)(labelHeight - descent + bufferText)));
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
                if (modifiers.containsKey("H_ADDITIONAL_INFO_1") && (strText = modifiers.get("H_ADDITIONAL_INFO_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                    y = !byLabelHeight ? (int)(bounds.getMinY() + (double)labelHeight - (double)descent) : (int)(bounds.getMinY() + (bounds.getHeight() * 0.5 - (double)(labelHeight - descent) * 0.5 + (double)(-descent - bufferText)));
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
                if (modifiers.containsKey("W_DTG_1") && (strText = modifiers.get("W_DTG_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)bounds.getMinX() - labelWidth - bufferXL;
                    y = !byLabelHeight ? (int)bounds.getMinY() + labelHeight - descent : (int)(bounds.getMinY() + (bounds.getHeight() * 0.5 - (double)(labelHeight - descent) * 0.5 + (double)(-descent - bufferText)));
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
                if ((ec == 281500 || ec == 281600) && modifiers.containsKey("V_EQUIP_TYPE") && (strText = modifiers.get("V_EQUIP_TYPE")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)bounds.getMinX() - labelWidth - bufferXL;
                    y = (int)(bounds.getMinY() + (bounds.getHeight() * 0.5 + (double)(labelHeight - descent) * 0.5));
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
                if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (strText = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)bounds.getMinX() - labelWidth - bufferXL;
                    y = !byLabelHeight ? (int)(bounds.getMinY() + bounds.getHeight()) : (int)(bounds.getMinY() + (bounds.getHeight() * 0.5 + (double)(labelHeight - descent) * 0.5 + (double)(labelHeight - descent + bufferText)));
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
                if (modifiers.containsKey("Y_LOCATION") && (strText = modifiers.get("Y_LOCATION")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getMinX() + bounds.getWidth() * 0.5);
                    y = !byLabelHeight ? (int)(bounds.getMinY() + bounds.getHeight() + (double)labelHeight - (double)descent + (double)bufferY) : (int)(bounds.getMinY() + (double)((int)(bounds.getHeight() * 0.5 + (double)(labelHeight - descent) * 0.5 + (double)((labelHeight + bufferText) * 2) - (double)descent)));
                    yForY = y + descent;
                    ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y));
                    arrMods.add(ti);
                }
                if (modifiers.containsKey("C_QUANTITY") && (strText = modifiers.get("C_QUANTITY")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getMinX() + bounds.getWidth() * 0.5);
                    y = (int)bounds.getMinY() - descent;
                    ti.setLocation(Math.round(x -= (int)((double)labelWidth * 0.5)), Math.round(y));
                    arrMods.add(ti);
                }
            } else if (ec == 270701) {
                if (modifiers.containsKey("H_ADDITIONAL_INFO_1") && (strText = modifiers.get("H_ADDITIONAL_INFO_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getMinX() + bounds.getWidth() * 0.5);
                    y = (int)bounds.getMinY() - descent;
                    ti.setLocation(Math.round(x -= (int)((double)labelWidth * 0.5)), Math.round(y));
                    arrMods.add(ti);
                }
                if (modifiers.containsKey("W_DTG_1") && (strText = modifiers.get("W_DTG_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getMinX() + (double)((int)(bounds.getWidth() * 0.5)));
                    y = (int)(bounds.getMinY() + bounds.getHeight());
                    ti.setLocation(Math.round(x -= (int)((double)labelWidth * 0.5)), Math.round(y += labelHeight));
                    arrMods.add(ti);
                }
                if (modifiers.containsKey("N_HOSTILE") && (strText = modifiers.get("N_HOSTILE")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    ti2 = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                    duplicate = true;
                    x2 = (int)bounds.getMinX();
                    x2 = x2 - labelWidth - bufferXL;
                    y = (int)(bounds.getMinY() + (double)((int)(bounds.getHeight() * 0.5)));
                    y2 = y += (int)((double)(labelHeight - descent) * 0.5);
                    ti.setLocation(Math.round(x), Math.round(y));
                    ti2.setLocation(Math.round(x2), Math.round(y2));
                    arrMods.add(ti);
                    arrMods.add(ti2);
                }
            } else if (e == 21 && et == 35) {
                centerPoint = SymbolUtilities.getCMSymbolAnchorPoint(symbolID, RectUtilities.copyRect(bounds));
                if (modifiers.containsKey("H_ADDITIONAL_INFO_1") && (strText = modifiers.get("H_ADDITIONAL_INFO_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    ti2 = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                    y = centerPoint.y;
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
                if ((est == 0 || est == 1 || est == 4 || est == 7 || est == 8 || est == 15) && modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (strText = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    ti2 = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
                    y = centerPoint.y - labelHeight;
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
            } else if (ec == 282001 || ec == 282002) {
                if (modifiers.containsKey("X_ALTITUDE_DEPTH") && (strText = modifiers.get("X_ALTITUDE_DEPTH")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getMinX() + bounds.getWidth() * 0.7);
                    y = (int)bounds.getMinY() + labelHeight;
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
            } else if (ec == 21060) {
                if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (strText = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    x = (int)(bounds.getMinX() + (bounds.getWidth() + (double)bufferXR));
                    y = (int)(bounds.getMinY() + (double)labelHeight);
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
            } else if (ec == 210300) {
                if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (strText = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    x = (int)(bounds.getMinX() - (double)labelWidth - (double)bufferXL);
                    y = (int)(bounds.getMinY() + (double)labelHeight);
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
            } else if (ec == 21060) {
                if (modifiers.containsKey("X_ALTITUDE_DEPTH") && (strText = modifiers.get("X_ALTITUDE_DEPTH")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    x = (int)(bounds.getMinX() + (bounds.getWidth() + (double)bufferXR));
                    y = (int)(bounds.getMinY() + (double)labelHeight);
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
            } else if (ec == 210800) {
                if (modifiers.containsKey("X_ALTITUDE_DEPTH") && (strText = modifiers.get("X_ALTITUDE_DEPTH")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    x = (int)(bounds.getX() + bounds.getWidth() * (double)0.65f);
                    y = (int)(bounds.getY() + bounds.getHeight() * 0.25);
                    ti.setLocation(Math.round(x), Math.round(y += (int)((float)labelHeight * 0.5f)));
                    arrMods.add(ti);
                }
            } else if (ec == 211000) {
                if (modifiers.containsKey("H_ADDITIONAL_INFO_1") && (strText = modifiers.get("H_ADDITIONAL_INFO_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getX() + bounds.getWidth() * 0.5 - (double)(labelWidth / 2));
                    y = (int)(bounds.getY() - (double)bufferY);
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
            } else if (ec == 214900 || ec == 215600) {
                if (modifiers.containsKey("W_DTG_1") && (strText = modifiers.get("W_DTG_1")) != null) {
                    ti = new TextInfo(strText + " - ", 0, 0, _modifierFont, frc);
                    x = (int)(bounds.getMinX() + (bounds.getWidth() + (double)bufferXR));
                    y = (int)(bounds.getMinY() + (double)labelHeight);
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
                if (modifiers.containsKey("W1_DTG_2") && (strText = modifiers.get("W1_DTG_2")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    x = (int)(bounds.getMinX() + (bounds.getWidth() + (double)bufferXR));
                    y = (int)(bounds.getMinY() + (double)(labelHeight * 2));
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
                if (modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (strText = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    x = (int)(bounds.getMinX() + (bounds.getWidth() + (double)bufferXR));
                    y = (int)(bounds.getMinY() + (double)(labelHeight * 3));
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
            } else if (ec == 217000) {
                if (modifiers.containsKey("H_ADDITIONAL_INFO_1") && (strText = modifiers.get("H_ADDITIONAL_INFO_1")) != null) {
                    ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                    labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                    x = (int)(bounds.getX() + bounds.getWidth() * 0.5 - (double)(labelWidth / 2));
                    y = (int)(bounds.getY() + bounds.getHeight() + (double)labelHeight + (double)bufferY);
                    ti.setLocation(Math.round(x), Math.round(y));
                    arrMods.add(ti);
                }
            } else if (ec == 250600 && modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (strText = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                x = (int)(bounds.getX() + (bounds.getWidth() + (double)bufferXR));
                y = (int)(bounds.getY() + bounds.getHeight() * 0.25);
                ti.setLocation(Math.round(x), Math.round(y += (int)((float)labelHeight * 0.5f)));
                arrMods.add(ti);
            }
        } else if (ss == 45) {
            String modX = null;
            if (modifiers.containsKey("X_ALTITUDE_DEPTH")) {
                modX = modifiers.get("X_ALTITUDE_DEPTH");
            }
            if (ec == 162300) {
                strText = "0\u00b0:";
                strText = modX != null ? strText + modX : strText + "?";
                ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                x = (int)(bounds.getMinX() + bounds.getWidth() * 0.5);
                y = (int)(bounds.getMinY() + bounds.getHeight() * 0.5);
                ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y += (int)(((float)labelHeight - _modifierFontDescent) * 0.5f)));
                arrMods.add(ti);
            } else if (ec == 162200) {
                strText = "X?";
                if (modX != null) {
                    strText = modX;
                }
                ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                x = (int)(bounds.getMinX() + bounds.getWidth() * 0.5);
                y = (int)(bounds.getMinY() + bounds.getHeight() * 0.5);
                ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y += (int)(((float)labelHeight - _modifierFontDescent) * 0.5f)));
                arrMods.add(ti);
            } else if (ec == 110102) {
                strText = "X?";
                if (modX != null) {
                    strText = modX;
                }
                ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                x = (int)(bounds.getMinX() + (double)((int)(bounds.getWidth() * 0.5)));
                y = (int)(bounds.getMinY() + (double)((int)(bounds.getHeight() * 0.5)));
                ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y -= descent));
                arrMods.add(ti);
            } else if (ec == 110202) {
                strText = "X?";
                if (modX != null) {
                    strText = modX;
                }
                ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                x = (int)(bounds.getMinX() + (double)((int)(bounds.getWidth() * 0.5)));
                y = (int)(bounds.getMinY() + (double)((int)(bounds.getHeight() * 0.5)));
                ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y += (int)((float)labelHeight * 0.5f - (float)(labelHeight / 2) + (float)labelHeight - (float)descent)));
                arrMods.add(ti);
            }
        }
        Point2D[] domPoints = null;
        Rectangle2D domBounds = null;
        if (modifiers.containsKey("Q_DIRECTION_OF_MOVEMENT") && SymbolUtilities.isCBRNEvent(symbolID) && (strText = modifiers.get("Q_DIRECTION_OF_MOVEMENT")) != null && SymbolUtilities.isNumber(strText)) {
            float q = Float.parseFloat(strText);
            Rectangle2D tempBounds = RectUtilities.copyRect(bounds);
            tempBounds = tempBounds.createUnion(new Rectangle2D.Double(bounds.getCenterX(), yForY, 0.0, 0.0));
            domPoints = ModifierRenderer.createDOMArrowPoints(symbolID, tempBounds, sdi.getSymbolCenterPoint(), q, false, frc);
            domBounds = new Rectangle2D.Double(domPoints[0].getX(), domPoints[0].getY(), 1.0, 1.0);
            Point2D temp = null;
            for (i = 1; i < 6; ++i) {
                temp = domPoints[i];
                if (temp == null) continue;
                domBounds = ((Rectangle2D)domBounds).createUnion(new Rectangle2D.Double(temp.getX(), temp.getY(), 0.0, 0.0));
            }
            imageBounds = imageBounds.createUnion(domBounds);
        }
        if (SymbolUtilities.hasFDI(symbolID).booleanValue()) {
            fdiLeft = new Point2D.Double(bounds.getX(), bounds.getY());
            fdiRight = new Point2D.Double(bounds.getX() + bounds.getWidth(), bounds.getY());
            fdiTop = new Point2D.Double(Math.round(bounds.getCenterX()), Math.round(bounds.getY() - bounds.getWidth() * 0.5));
            fdiBounds = new Rectangle2D.Double(((Point2D)fdiLeft).getX(), ((Point2D)fdiTop).getY(), ((Point2D)fdiRight).getX() - ((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY() - ((Point2D)fdiTop).getY());
            ti = new TextInfo("TEST", 0, 0, _modifierFont, frc);
            if (ti != null && SymbolUtilities.isCBRNEvent(symbolID)) {
                int shiftY = (int)Math.round(bounds.getY() - ti.getTextBounds().getHeight() - 2.0);
                ((Point2D)fdiLeft).setLocation(((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY() + (double)shiftY);
                ((Point2D)fdiTop).setLocation(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY() + (double)shiftY);
                ((Point2D)fdiRight).setLocation(((Point2D)fdiRight).getX(), ((Point2D)fdiRight).getY() + (double)shiftY);
                fdiBounds = new Rectangle2D.Double(((Point2D)fdiLeft).getX(), ((Point2D)fdiTop).getY(), ((Point2D)fdiRight).getX() - ((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY() - ((Point2D)fdiTop).getY());
            }
            imageBounds = imageBounds.createUnion(fdiBounds);
        }
        Rectangle2D modifierBounds = null;
        if (arrMods != null && arrMods.size() > 0) {
            modifierBounds = ((TextInfo)arrMods.get(0)).getTextOutlineBounds();
            int size = arrMods.size();
            TextInfo tempShape = null;
            for (i = 1; i < size; ++i) {
                tempShape = (TextInfo)arrMods.get(i);
                modifierBounds = modifierBounds.createUnion(tempShape.getTextOutlineBounds());
            }
        }
        if (modifierBounds != null || domBounds != null || fdiBounds != null) {
            if (modifierBounds != null) {
                imageBounds = imageBounds.createUnion(modifierBounds);
            }
            if (domBounds != null) {
                imageBounds = imageBounds.createUnion(domBounds);
            }
            if (fdiBounds != null) {
                imageBounds = imageBounds.createUnion(fdiBounds);
            }
            if (sdi instanceof ImageInfo && (imageBounds.getMinX() < 0.0 || imageBounds.getMinY() < 0.0)) {
                int i2;
                int shiftX = Math.abs((int)imageBounds.getMinX());
                int shiftY = Math.abs((int)imageBounds.getMinY());
                int size = arrMods.size();
                TextInfo tempShape = null;
                for (i2 = 0; i2 < size; ++i2) {
                    tempShape = (TextInfo)arrMods.get(i2);
                    tempShape.shift(shiftX, shiftY);
                }
                if (modifierBounds != null) {
                    RectUtilities.shift(modifierBounds, shiftX, shiftY);
                }
                if (domBounds != null) {
                    for (i2 = 0; i2 < 6; ++i2) {
                        Point2D temp = domPoints[i2];
                        if (temp == null) continue;
                        temp.setLocation(temp.getX() + (double)shiftX, temp.getY() + (double)shiftY);
                    }
                    RectUtilities.shift(domBounds, shiftX, shiftY);
                }
                if (fdiBounds != null) {
                    ShapeUtilities.offset(fdiBounds, shiftX, shiftY);
                    ShapeUtilities.offset((Point2D)fdiLeft, shiftX, shiftY);
                    ShapeUtilities.offset((Point2D)fdiTop, shiftX, shiftY);
                    ShapeUtilities.offset((Point2D)fdiRight, shiftX, shiftY);
                }
                centerPoint.setLocation(centerPoint.getX() + (double)shiftX, centerPoint.getX() + (double)shiftY);
                RectUtilities.shift(symbolBounds, shiftX, shiftY);
                RectUtilities.shift(imageBounds, shiftX, shiftY);
            }
            if (attributes.containsKey("TEXTCOLOR")) {
                textColor = RendererUtilities.getColorFromHexString(attributes.get("TEXTCOLOR"));
            }
            if (attributes.containsKey("TEXTBACKGROUNDCOLOR")) {
                textBackgroundColor = RendererUtilities.getColorFromHexString(attributes.get("TEXTBACKGROUNDCOLOR"));
            }
            textColor = RendererUtilities.setColorAlpha(textColor, alpha);
            textBackgroundColor = RendererUtilities.setColorAlpha(textBackgroundColor, alpha);
            if (sdi instanceof ImageInfo) {
                ii = (ImageInfo)sdi;
                BufferedImage bmp = new BufferedImage((int)imageBounds.getWidth(), (int)Math.round(imageBounds.getHeight()), 2);
                Graphics2D g2d = (Graphics2D)bmp.getGraphics();
                g2d.drawImage((Image)ii.getImage(), (int)symbolBounds.getX(), (int)symbolBounds.getY(), null);
                ModifierRenderer.renderText(g2d, arrMods, textColor, textBackgroundColor);
                newsdi = new ImageInfo(bmp, centerPoint, symbolBounds);
                lineColor = RendererUtilities.setColorAlpha(lineColor, alpha);
                if (domBounds != null) {
                    ModifierRenderer.drawDOMArrow(g2d, domPoints, lineColor, strokeWidth);
                }
                if (fdiBounds != null) {
                    float[] dashArray = new float[]{6.0f, 4.0f};
                    g2d.setColor(lineColor);
                    if (symbolBounds.getHeight() < 20.0) {
                        dashArray[0] = 5.0f;
                        dashArray[1] = 3.0f;
                    }
                    BasicStroke stroke = new BasicStroke(2.0f, 0, 0, 10.0f, dashArray, 0.0f);
                    g2d.setStroke(stroke);
                    Path2D.Double fdiPath = new Path2D.Double();
                    ((Path2D)fdiPath).moveTo(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY());
                    ((Path2D)fdiPath).lineTo(((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY());
                    ((Path2D)fdiPath).moveTo(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY());
                    ((Path2D)fdiPath).lineTo(((Point2D)fdiRight).getX(), ((Point2D)fdiRight).getY());
                    g2d.draw(fdiPath);
                    fdiBounds = null;
                }
                newsdi = new ImageInfo(bmp, centerPoint, symbolBounds);
                g2d = null;
            } else if (sdi instanceof SVGSymbolInfo) {
                String svgStroke = RendererUtilities.colorToHexString(lineColor, false);
                String svgStrokeWidth = String.valueOf(strokeWidth);
                String svgAlpha = null;
                if (alpha > -1.0f) {
                    svgAlpha = String.valueOf(alpha);
                }
                ssi = (SVGSymbolInfo)sdi;
                StringBuilder sbSVG = new StringBuilder();
                sbSVG.append(ssi.getSVG());
                sbSVG.append(ModifierRenderer.renderTextElements(arrMods, textColor, textBackgroundColor));
                if (domBounds != null) {
                    Path2D.Double domPath = new Path2D.Double();
                    ((Path2D)domPath).moveTo(domPoints[0].getX(), domPoints[0].getY());
                    if (domPoints[1] != null) {
                        ((Path2D)domPath).lineTo(domPoints[1].getX(), domPoints[1].getY());
                    }
                    if (domPoints[2] != null) {
                        ((Path2D)domPath).lineTo(domPoints[2].getX(), domPoints[2].getY());
                    }
                    sbSVG.append(Shape2SVG.Convert(domPath, svgStroke, null, svgStrokeWidth, svgAlpha, svgAlpha, null));
                    domPath.reset();
                    ((Path2D)domPath).moveTo(domPoints[3].getX(), domPoints[3].getY());
                    ((Path2D)domPath).lineTo(domPoints[4].getX(), domPoints[4].getY());
                    ((Path2D)domPath).lineTo(domPoints[5].getX(), domPoints[5].getY());
                    sbSVG.append(Shape2SVG.Convert(domPath, "none", svgStroke, "0", svgAlpha, svgAlpha, null));
                    domBounds = null;
                    domPoints = null;
                }
                if (fdiBounds != null) {
                    String svgFDIDashArray = "6 4";
                    float[] dashArray = new float[]{6.0f, 4.0f};
                    if (symbolBounds.getHeight() < 20.0) {
                        svgFDIDashArray = "5 3";
                    }
                    Path2D.Double fdiPath = new Path2D.Double();
                    ((Path2D)fdiPath).moveTo(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY());
                    ((Path2D)fdiPath).lineTo(((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY());
                    ((Path2D)fdiPath).moveTo(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY());
                    ((Path2D)fdiPath).lineTo(((Point2D)fdiRight).getX(), ((Point2D)fdiRight).getY());
                    sbSVG.append(Shape2SVG.Convert(fdiPath, svgStroke, null, svgStrokeWidth, svgAlpha, svgAlpha, svgFDIDashArray));
                }
                newsdi = new SVGSymbolInfo(sbSVG.toString(), centerPoint, symbolBounds, imageBounds);
            }
            return newsdi;
        }
        return null;
    }

    public static SymbolDimensionInfo ProcessTGSPModifiers(SymbolDimensionInfo sdi, String symbolID, Map<String, String> modifiers, Map<String, String> attributes, Color lineColor, FontRenderContext frc) {
        int maxHeight;
        ImageInfo ii = null;
        SVGSymbolInfo ssi = null;
        int bufferXL = 6;
        int bufferXR = 4;
        int bufferY = 2;
        int bufferText = 2;
        boolean centerOffset = true;
        int x = 0;
        int y = 0;
        boolean x2 = false;
        boolean y2 = false;
        Rectangle2D fdiBounds = null;
        Point2D.Double fdiTop = null;
        Point2D.Double fdiLeft = null;
        Point2D.Double fdiRight = null;
        int outlineOffset = RS.getTextOutlineWidth();
        int labelHeight = 0;
        int labelWidth = 0;
        float alpha = -1.0f;
        SymbolDimensionInfo newsdi = null;
        Color textColor = lineColor;
        Color textBackgroundColor = null;
        ArrayList<TextInfo> arrMods = new ArrayList<TextInfo>();
        boolean duplicate = false;
        MSInfo msi = MSLookup.getInstance().getMSLInfo(symbolID);
        if (attributes.containsKey("ALPHA")) {
            alpha = Float.parseFloat(attributes.get("ALPHA")) / 255.0f;
        }
        Rectangle2D bounds = RectUtilities.copyRect(sdi.getSymbolBounds());
        Rectangle2D symbolBounds = RectUtilities.copyRect(sdi.getSymbolBounds());
        Point centerPoint = new Point(sdi.getSymbolCenterPoint());
        Rectangle2D imageBounds = RectUtilities.copyRect(sdi.getImageBounds());
        centerPoint = new Point(Math.round(sdi.getSymbolCenterPoint().x), Math.round(sdi.getSymbolCenterPoint().y));
        boolean byLabelHeight = false;
        labelHeight = Math.round(_modifierFontHeight + 0.5f);
        if (labelHeight * 3 > (maxHeight = (int)symbolBounds.getHeight())) {
            byLabelHeight = true;
        }
        int descent = (int)(_modifierFontDescent + 0.5f);
        int yForY = -1;
        Object labelBounds1 = null;
        Object labelBounds2 = null;
        String strText = "";
        String strText1 = "";
        String strText2 = "";
        Object text1 = null;
        Object text2 = null;
        String basicID = SymbolUtilities.getBasicSymbolID(symbolID);
        outlineOffset = outlineOffset > 2 ? (outlineOffset - 1) / 2 : 0;
        TextInfo ti = null;
        if (msi.getModifiers().contains("N_HOSTILE") && modifiers.containsKey("N_HOSTILE") && (strText = modifiers.get("N_HOSTILE")) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
            x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
            if (!byLabelHeight) {
                y = (int)(bounds.getHeight() / 3.0 * 2.0);
                y = (int)bounds.getMinY() + y;
            } else {
                y = (int)(bounds.getMinY() + bounds.getHeight());
            }
            ti.setLocation(x, y);
            arrMods.add(ti);
        }
        if (msi.getModifiers().contains("H_ADDITIONAL_INFO_1") && modifiers.containsKey("H_ADDITIONAL_INFO_1") && (strText = modifiers.get("H_ADDITIONAL_INFO_1")) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
            labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
            x = (int)(bounds.getMinX() + bounds.getWidth() * 0.5);
            y = (int)bounds.getMinY() - descent;
            ti.setLocation(x -= (int)((float)labelWidth * 0.5f), y);
            arrMods.add(ti);
        }
        if (msi.getModifiers().contains("H1_ADDITIONAL_INFO_2") && modifiers.containsKey("H1_ADDITIONAL_INFO_2") && (strText = modifiers.get("H1_ADDITIONAL_INFO_2")) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
            labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
            x = (int)(bounds.getMinX() + bounds.getWidth() * 0.5);
            y = (int)(bounds.getMinY() + (double)labelHeight - (double)descent + bounds.getHeight() * 0.07);
            ti.setLocation(x -= (int)((double)labelWidth * 0.5), y);
            arrMods.add(ti);
        }
        if (msi.getModifiers().contains("A_SYMBOL_ICON")) {
            if (modifiers.containsKey("A_SYMBOL_ICON")) {
                strText = modifiers.get("A_SYMBOL_ICON");
            } else if (SymbolID.getEntityCode(symbolID) == 321706) {
                strText = "ALL?";
            }
            if (strText != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
                labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
                x = (int)(bounds.getMinX() + bounds.getWidth() * 0.5);
                y = (int)(bounds.getMinY() + (double)labelHeight - (double)descent + bounds.getHeight() * 0.07);
                ti.setLocation(x -= (int)((double)labelWidth * 0.5), y);
                arrMods.add(ti);
            }
        }
        if (msi.getModifiers().contains("W_DTG_1") && modifiers.containsKey("W_DTG_1") && (strText = modifiers.get("W_DTG_1")) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
            labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
            x = (int)(bounds.getMinX() - (double)labelWidth - (double)bufferXL);
            y = (int)(bounds.getMinY() + (double)labelHeight - (double)descent);
            ti.setLocation(x, y);
            arrMods.add(ti);
        }
        if (msi.getModifiers().contains("W1_DTG_2") && modifiers.containsKey("W1_DTG_2") && (strText = modifiers.get("W1_DTG_2")) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
            labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
            x = (int)bounds.getMinX() - labelWidth - bufferXL;
            y = (labelHeight - descent + bufferText) * 2;
            y = (int)bounds.getMinY() + y;
            ti.setLocation(x, y);
            arrMods.add(ti);
        }
        if (msi.getModifiers().contains("T_UNIQUE_DESIGNATION_1") && modifiers.containsKey("T_UNIQUE_DESIGNATION_1") && (strText = modifiers.get("T_UNIQUE_DESIGNATION_1")) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
            x = (int)(bounds.getMinX() + bounds.getWidth() + (double)bufferXR);
            y = (int)bounds.getMinY() + labelHeight - descent;
            ti.setLocation(x, y);
            arrMods.add(ti);
        }
        if (msi.getModifiers().contains("T1_UNIQUE_DESIGNATION_2") && modifiers.containsKey("T1_UNIQUE_DESIGNATION_2") && (strText = modifiers.get("T1_UNIQUE_DESIGNATION_2")) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont, frc);
            labelWidth = (int)Math.round(ti.getTextBounds().getWidth());
            x = (int)(bounds.getMinX() + bounds.getWidth() * 0.5);
            y = (int)(bounds.getHeight() * 0.55);
            y = (int)bounds.getMinY() + y;
            ti.setLocation(x -= (int)((double)labelWidth * 0.5), y);
            arrMods.add(ti);
        }
        if (SymbolUtilities.hasFDI(symbolID).booleanValue()) {
            fdiLeft = new Point2D.Double(bounds.getX(), bounds.getY());
            fdiRight = new Point2D.Double(bounds.getX() + bounds.getWidth(), bounds.getY());
            fdiTop = new Point2D.Double(Math.round(bounds.getCenterX()), Math.round(bounds.getY() - bounds.getWidth() * 0.5));
            fdiBounds = new Rectangle2D.Double(((Point2D)fdiLeft).getX(), ((Point2D)fdiTop).getY(), ((Point2D)fdiRight).getX() - ((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY() - ((Point2D)fdiTop).getY());
            ti = new TextInfo("TEST", 0, 0, _modifierFont, frc);
            if (ti != null) {
                int shiftY = (int)Math.round(bounds.getY() - ti.getTextBounds().getHeight() - 2.0);
                ((Point2D)fdiLeft).setLocation(((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY() + (double)shiftY);
                ((Point2D)fdiTop).setLocation(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY() + (double)shiftY);
                ((Point2D)fdiRight).setLocation(((Point2D)fdiRight).getX(), ((Point2D)fdiRight).getY() + (double)shiftY);
                fdiBounds = new Rectangle2D.Double(((Point2D)fdiLeft).getX(), ((Point2D)fdiTop).getY(), ((Point2D)fdiRight).getX() - ((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY() - ((Point2D)fdiTop).getY());
            }
            imageBounds = imageBounds.createUnion(fdiBounds);
        }
        Rectangle2D modifierBounds = null;
        if (arrMods != null && arrMods.size() > 0) {
            modifierBounds = ((TextInfo)arrMods.get(0)).getTextOutlineBounds();
            int size = arrMods.size();
            TextInfo tempShape = null;
            for (int i = 1; i < size; ++i) {
                tempShape = (TextInfo)arrMods.get(i);
                modifierBounds = modifierBounds.createUnion(tempShape.getTextOutlineBounds());
            }
        }
        if (fdiBounds != null) {
            modifierBounds = modifierBounds != null ? modifierBounds.createUnion(fdiBounds) : fdiBounds;
        }
        if (modifierBounds != null) {
            imageBounds = imageBounds.createUnion(modifierBounds);
            if (sdi instanceof ImageInfo && (imageBounds.getMinX() < 0.0 || imageBounds.getMinY() < 0.0)) {
                int shiftX = (int)Math.abs(imageBounds.getMinX());
                int shiftY = (int)Math.abs(imageBounds.getMinY());
                int size = arrMods.size();
                TextInfo tempShape = null;
                for (int i = 0; i < size; ++i) {
                    tempShape = (TextInfo)arrMods.get(i);
                    tempShape.shift(shiftX, shiftY);
                }
                RectUtilities.shift(modifierBounds, shiftX, shiftY);
                centerPoint.setLocation(centerPoint.getX() + (double)shiftX, centerPoint.getY() + (double)shiftY);
                RectUtilities.shift(symbolBounds, shiftX, shiftY);
                RectUtilities.shift(imageBounds, shiftX, shiftY);
                if (fdiBounds != null) {
                    ShapeUtilities.offset(fdiBounds, shiftX, shiftY);
                    ShapeUtilities.offset((Point2D)fdiLeft, shiftX, shiftY);
                    ShapeUtilities.offset((Point2D)fdiTop, shiftX, shiftY);
                    ShapeUtilities.offset((Point2D)fdiRight, shiftX, shiftY);
                }
            }
            if (attributes.containsKey("TEXTCOLOR")) {
                textColor = RendererUtilities.getColorFromHexString(attributes.get("TEXTCOLOR"));
            }
            if (attributes.containsKey("TEXTBACKGROUNDCOLOR")) {
                textBackgroundColor = RendererUtilities.getColorFromHexString(attributes.get("TEXTBACKGROUNDCOLOR"));
            }
            textColor = RendererUtilities.setColorAlpha(textColor, alpha);
            textBackgroundColor = RendererUtilities.setColorAlpha(textBackgroundColor, alpha);
            if (sdi instanceof ImageInfo) {
                ii = (ImageInfo)sdi;
                BufferedImage bmp = new BufferedImage((int)imageBounds.getWidth(), (int)Math.round(imageBounds.getHeight()), 2);
                Graphics2D g2d = (Graphics2D)bmp.getGraphics();
                g2d.drawImage((Image)ii.getImage(), (int)symbolBounds.getX(), (int)symbolBounds.getY(), null);
                ModifierRenderer.renderText(g2d, arrMods, textColor, textBackgroundColor);
                if (fdiBounds != null) {
                    float[] dashArray = new float[]{6.0f, 4.0f};
                    g2d.setColor(lineColor);
                    if (symbolBounds.getHeight() < 20.0) {
                        dashArray[0] = 5.0f;
                        dashArray[1] = 3.0f;
                    }
                    BasicStroke stroke = new BasicStroke(2.0f, 0, 0, 10.0f, dashArray, 0.0f);
                    g2d.setStroke(stroke);
                    Path2D.Double fdiPath = new Path2D.Double();
                    ((Path2D)fdiPath).moveTo(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY());
                    ((Path2D)fdiPath).lineTo(((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY());
                    ((Path2D)fdiPath).moveTo(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY());
                    ((Path2D)fdiPath).lineTo(((Point2D)fdiRight).getX(), ((Point2D)fdiRight).getY());
                    g2d.draw(fdiPath);
                    fdiBounds = null;
                }
                newsdi = new ImageInfo(bmp, centerPoint, symbolBounds);
                g2d = null;
            } else if (sdi instanceof SVGSymbolInfo) {
                String svgStroke = RendererUtilities.colorToHexString(lineColor, false);
                String svgStrokeWidth = "3";
                String svgAlpha = null;
                if (alpha > -1.0f) {
                    svgAlpha = String.valueOf(alpha);
                }
                ssi = (SVGSymbolInfo)sdi;
                StringBuilder sbSVG = new StringBuilder();
                sbSVG.append(ssi.getSVG());
                sbSVG.append(ModifierRenderer.renderTextElements(arrMods, textColor, textBackgroundColor));
                if (fdiBounds != null) {
                    String svgFDIDashArray = "6 4";
                    float[] dashArray = new float[]{6.0f, 4.0f};
                    if (symbolBounds.getHeight() < 20.0) {
                        svgFDIDashArray = "5 3";
                    }
                    Path2D.Double fdiPath = new Path2D.Double();
                    ((Path2D)fdiPath).moveTo(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY());
                    ((Path2D)fdiPath).lineTo(((Point2D)fdiLeft).getX(), ((Point2D)fdiLeft).getY());
                    ((Path2D)fdiPath).moveTo(((Point2D)fdiTop).getX(), ((Point2D)fdiTop).getY());
                    ((Path2D)fdiPath).lineTo(((Point2D)fdiRight).getX(), ((Point2D)fdiRight).getY());
                    sbSVG.append(Shape2SVG.Convert(fdiPath, svgStroke, null, svgStrokeWidth, svgAlpha, svgAlpha, svgFDIDashArray));
                }
                newsdi = new SVGSymbolInfo(sbSVG.toString(), centerPoint, symbolBounds, imageBounds);
            }
        }
        return newsdi;
    }

    private static SymbolDimensionInfo shiftUnitPointsAndDraw(ArrayList<TextInfo> tiArray, SymbolDimensionInfo sdi, Map<String, String> attributes) {
        ImageInfo ii = null;
        SVGSymbolInfo ssi = null;
        SymbolDimensionInfo newsdi = null;
        int alpha = -1;
        if (attributes != null && attributes.containsKey("ALPHA")) {
            alpha = Integer.parseInt(attributes.get("ALPHA"));
        }
        Color textColor = Color.BLACK;
        Color textBackgroundColor = null;
        Rectangle2D symbolBounds = sdi.getSymbolBounds();
        Point centerPoint = sdi.getSymbolCenterPoint();
        Rectangle2D imageBounds = sdi.getImageBounds();
        Rectangle2D imageBoundsOld = sdi.getImageBounds();
        Rectangle2D modifierBounds = null;
        if (tiArray != null && tiArray.size() > 0) {
            modifierBounds = tiArray.get(0).getTextOutlineBounds();
            int size = tiArray.size();
            TextInfo tempShape = null;
            for (int i = 1; i < size; ++i) {
                tempShape = tiArray.get(i);
                Rectangle2D.union(modifierBounds, tempShape.getTextOutlineBounds(), modifierBounds);
            }
        }
        if (modifierBounds != null) {
            Rectangle2D.union(imageBounds, modifierBounds, imageBounds);
            if (sdi instanceof ImageInfo && (imageBounds.getX() < 0.0 || imageBounds.getY() < 0.0)) {
                int shiftX = (int)Math.round(Math.abs(imageBounds.getX()));
                int shiftY = (int)Math.round(Math.abs(imageBounds.getY()));
                int size = tiArray.size();
                TextInfo tempShape = null;
                for (int i = 0; i < size; ++i) {
                    tempShape = tiArray.get(i);
                    tempShape.shift(shiftX, shiftY);
                }
                RectUtilities.shift(modifierBounds, shiftX, shiftY);
                centerPoint.setLocation(centerPoint.getX() + (double)shiftX, centerPoint.getY() + (double)shiftY);
                RectUtilities.shift(symbolBounds, shiftX, shiftY);
                RectUtilities.shift(imageBounds, shiftX, shiftY);
                RectUtilities.shift(imageBoundsOld, shiftX, shiftY);
            }
            if (attributes.containsKey("TEXTCOLOR")) {
                textColor = RendererUtilities.getColorFromHexString(attributes.get("TEXTCOLOR"));
            }
            if (attributes.containsKey("TEXTBACKGROUNDCOLOR")) {
                textBackgroundColor = RendererUtilities.getColorFromHexString(attributes.get("TEXTBACKGROUNDCOLOR"));
            }
            textColor = RendererUtilities.setColorAlpha(textColor, alpha);
            textBackgroundColor = RendererUtilities.setColorAlpha(textBackgroundColor, alpha);
            if (sdi instanceof ImageInfo) {
                ii = (ImageInfo)sdi;
                BufferedImage bmp = new BufferedImage((int)imageBounds.getWidth(), (int)Math.round(imageBounds.getHeight()), 2);
                Graphics2D g2d = (Graphics2D)bmp.getGraphics();
                g2d.drawImage((Image)ii.getImage(), (int)imageBoundsOld.getX(), (int)imageBoundsOld.getY(), null);
                ModifierRenderer.renderText(g2d, tiArray, textColor, textBackgroundColor);
                newsdi = new ImageInfo(bmp, centerPoint, symbolBounds);
            } else if (sdi instanceof SVGSymbolInfo) {
                ssi = (SVGSymbolInfo)sdi;
                StringBuilder sb = new StringBuilder();
                sb.append(ModifierRenderer.renderTextElements(tiArray, textColor, textBackgroundColor));
                sb.append(ssi.getSVG());
                newsdi = new SVGSymbolInfo(sb.toString(), centerPoint, symbolBounds, imageBounds);
            }
        }
        return newsdi;
    }

    private static String renderTextElement(ArrayList<TextInfo> tiArray, Color color, Color backgroundColor) {
        StringBuilder sbSVG = new StringBuilder();
        String svgStroke = RendererUtilities.colorToHexString(RendererUtilities.getIdealOutlineColor(color), false);
        if (backgroundColor != null) {
            svgStroke = RendererUtilities.colorToHexString(backgroundColor, false);
        }
        String svgFill = RendererUtilities.colorToHexString(color, false);
        String svgStrokeWidth = "2";
        for (TextInfo ti : tiArray) {
            sbSVG.append(Shape2SVG.Convert(ti, svgStroke, svgFill, svgStrokeWidth, null, null, null));
            sbSVG.append("\n");
        }
        return sbSVG.toString();
    }

    private static String renderTextElements(ArrayList<TextInfo> tiArray, Color color, Color backgroundColor) {
        Object style = null;
        String name = RendererSettings.getInstance().getLabelFont().getFontName() + ", sans-serif";
        String size = String.valueOf(RendererSettings.getInstance().getLabelFont().getSize());
        String weight = null;
        Object anchor = null;
        if (RendererSettings.getInstance().getLabelFont().isBold()) {
            weight = "bold";
        }
        StringBuilder sbSVG = new StringBuilder();
        String svgStroke = RendererUtilities.colorToHexString(RendererUtilities.getIdealOutlineColor(color), false);
        if (backgroundColor != null) {
            svgStroke = RendererUtilities.colorToHexString(backgroundColor, false);
        }
        String svgFill = RendererUtilities.colorToHexString(color, false);
        String svgStrokeWidth = "2";
        sbSVG.append("\n<g");
        sbSVG.append(" font-family=\"" + name + '\"');
        sbSVG.append(" font-size=\"" + size + "px\"");
        if (weight != null) {
            sbSVG.append(" font-weight=\"" + weight + "\"");
        }
        sbSVG.append(" alignment-baseline=\"alphabetic\"");
        sbSVG.append(">");
        for (TextInfo ti : tiArray) {
            sbSVG.append(Shape2SVG.ConvertForGroup(ti, svgStroke, svgFill, svgStrokeWidth, null, null, null));
            sbSVG.append("\n");
        }
        sbSVG.append("</g>\n");
        return sbSVG.toString();
    }

    private static void renderText(Graphics2D g2d, ArrayList<TextInfo> tiArray, Color color, Color backgroundColor) {
        ModifierRenderer.renderText(g2d, tiArray.toArray(new TextInfo[0]), color, backgroundColor);
    }

    public static void renderText(Graphics2D g2d, TextInfo[] tiArray, Color color, Color backgroundColor) {
        block14: {
            int tbm;
            int size;
            block16: {
                TextInfo textInfo;
                Color outlineColor;
                block15: {
                    TextInfo textInfo2;
                    block13: {
                        TextInfo textInfo3;
                        size = tiArray.length;
                        tbm = RendererSettings.getInstance().getTextBackgroundMethod();
                        int outlineWidth = RendererSettings.getInstance().getTextOutlineWidth();
                        if (outlineWidth > 2) {
                            outlineWidth = 2;
                        }
                        if (color == null) {
                            color = Color.BLACK;
                        }
                        outlineColor = null;
                        outlineColor = backgroundColor != null ? backgroundColor : RendererUtilities.getIdealOutlineColor(color);
                        if (color.getAlpha() != 255 && outlineColor.getAlpha() == 255) {
                            outlineColor = RendererUtilities.setColorAlpha(outlineColor, (float)color.getAlpha() / 255.0f);
                        }
                        g2d.setFont(RendererSettings.getInstance().getLabelFont());
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        if (tbm != 3) break block13;
                        if (outlineWidth > 0) {
                            g2d.setColor(outlineColor);
                            for (int i = 0; i < size; ++i) {
                                textInfo3 = tiArray[i];
                                if (outlineWidth <= 0) continue;
                                for (int j = 1; j <= outlineWidth; ++j) {
                                    if (j == 1) {
                                        g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX() - (float)j, (float)textInfo3.getLocation().getY() - (float)j);
                                        g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX() + (float)j, (float)textInfo3.getLocation().getY() - (float)j);
                                        g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX() - (float)j, (float)textInfo3.getLocation().getY() + (float)j);
                                        g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX() + (float)j, (float)textInfo3.getLocation().getY() + (float)j);
                                        g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX() - (float)j, (float)textInfo3.getLocation().getY());
                                        g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX() + (float)j, (float)textInfo3.getLocation().getY());
                                        continue;
                                    }
                                    g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX() - (float)j, (float)textInfo3.getLocation().getY() - (float)j);
                                    g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX() + (float)j, (float)textInfo3.getLocation().getY() - (float)j);
                                    g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX() - (float)j, (float)textInfo3.getLocation().getY() + (float)j);
                                    g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX() + (float)j, (float)textInfo3.getLocation().getY() + (float)j);
                                    g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX() - (float)j, (float)textInfo3.getLocation().getY());
                                    g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX() + (float)j, (float)textInfo3.getLocation().getY());
                                    g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX(), (float)textInfo3.getLocation().getY() + (float)j);
                                    g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX(), (float)textInfo3.getLocation().getY() - (float)j);
                                }
                            }
                        }
                        g2d.setColor(color);
                        for (int j = 0; j < size; ++j) {
                            textInfo3 = tiArray[j];
                            g2d.drawString(textInfo3.getText(), (float)textInfo3.getLocation().getX(), (float)textInfo3.getLocation().getY());
                        }
                        break block14;
                    }
                    if (tbm != 2) break block15;
                    FontRenderContext frc = g2d.getFontRenderContext();
                    Font font = RendererSettings.getInstance().getLabelFont();
                    for (int k = 0; k < size; ++k) {
                        textInfo2 = tiArray[k];
                        TextLayout tl = new TextLayout(textInfo2.getText(), RendererSettings.getInstance().getLabelFont(), frc);
                        AffineTransform at = new AffineTransform();
                        at.translate(textInfo2.getLocation().getX(), textInfo2.getLocation().getY());
                        Shape shape = tl.getOutline(null);
                        g2d.setTransform(at);
                        g2d.setColor(outlineColor);
                        g2d.setStroke(new BasicStroke(4.0f, 0, 0, 3.0f));
                        g2d.draw(shape);
                        g2d.setTransform(new AffineTransform());
                    }
                    g2d.setColor(color);
                    for (int j = 0; j < size; ++j) {
                        textInfo2 = tiArray[j];
                        g2d.drawString(textInfo2.getText(), (float)textInfo2.getLocation().getX(), (float)textInfo2.getLocation().getY());
                    }
                    break block14;
                }
                if (tbm != 1) break block16;
                g2d.setColor(outlineColor);
                for (int k = 0; k < size; ++k) {
                    textInfo = tiArray[k];
                    g2d.fill(textInfo.getTextOutlineBounds());
                }
                g2d.setColor(color);
                for (int j = 0; j < size; ++j) {
                    textInfo = tiArray[j];
                    g2d.drawString(textInfo.getText(), (float)textInfo.getLocation().getX(), (float)textInfo.getLocation().getY());
                }
                break block14;
            }
            if (tbm != 0) break block14;
            g2d.setColor(color);
            for (int j = 0; j < size; ++j) {
                TextInfo textInfo = tiArray[j];
                g2d.drawString(textInfo.getText(), (float)textInfo.getLocation().getX(), (float)textInfo.getLocation().getY());
            }
        }
    }

    public static boolean hasDisplayModifiers(String symbolID, Map<String, String> modifiers) {
        boolean hasModifiers = false;
        int ss = SymbolID.getSymbolSet(symbolID);
        int status = SymbolID.getStatus(symbolID);
        int context = SymbolID.getContext(symbolID);
        if (ss == 25) {
            if (SymbolUtilities.isCBRNEvent(symbolID) && modifiers.containsKey("Q_DIRECTION_OF_MOVEMENT")) {
                hasModifiers = true;
            } else if (SymbolUtilities.hasFDI(symbolID).booleanValue()) {
                hasModifiers = true;
            }
        } else if (ss != 45 && ss != 46 && ss != 47) {
            if (context > 0) {
                hasModifiers = true;
            }
            if (SymbolID.getAmplifierDescriptor(symbolID) > 0 || modifiers.containsKey("Q_DIRECTION_OF_MOVEMENT")) {
                hasModifiers = true;
            }
            if (modifiers.containsKey("AO_ENGAGEMENT_BAR")) {
                hasModifiers = true;
            }
            if (SymbolID.getHQTFD(symbolID) > 0) {
                hasModifiers = true;
            }
            if (status > 1) {
                hasModifiers = true;
            }
        }
        return hasModifiers;
    }

    public static boolean hasTextModifiers(String symbolID, Map<String, String> modifiers) {
        int ss = SymbolID.getSymbolSet(symbolID);
        int ec = SymbolID.getEntityCode(symbolID);
        if (ss == 45) {
            switch (ec) {
                case 110102: 
                case 110202: 
                case 162200: 
                case 162300: {
                    return true;
                }
            }
            return false;
        }
        if (ss == 46 || ss == 47) {
            return false;
        }
        if (ss == 25) {
            MSInfo msi = MSLookup.getInstance().getMSLInfo(symbolID);
            return msi.getModifiers().size() > 0 && modifiers != null && modifiers.size() > 0;
        }
        if (SymbolUtilities.getStandardIdentityModifier(symbolID) != null) {
            return true;
        }
        int cc = SymbolID.getCountryCode(symbolID);
        if (cc > 0 && !GENCLookup.getInstance().get3CharCode(cc).equals("")) {
            return true;
        }
        return modifiers.size() > 0;
    }
}

