/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer;

import armyc2.c5isr.renderer.ModifierRenderer;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.ImageInfo;
import armyc2.c5isr.renderer.utilities.LRUCache;
import armyc2.c5isr.renderer.utilities.MSInfo;
import armyc2.c5isr.renderer.utilities.MSLookup;
import armyc2.c5isr.renderer.utilities.RectUtilities;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.RendererUtilities;
import armyc2.c5isr.renderer.utilities.SVGInfo;
import armyc2.c5isr.renderer.utilities.SVGLookup;
import armyc2.c5isr.renderer.utilities.SettingsEventListener;
import armyc2.c5isr.renderer.utilities.SymbolDimensionInfo;
import armyc2.c5isr.renderer.utilities.SymbolID;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class SinglePointRenderer
implements SettingsEventListener {
    private final String TAG = "SinglePointRenderer";
    private static SinglePointRenderer _instance = null;
    public static final String RENDERER_ID = "2525D";
    private BufferedImage _buffer = null;
    private FontRenderContext _fontRenderContext = null;
    private LRUCache _unitCache = new LRUCache(1536);
    private LRUCache _tgCache = new LRUCache(512);
    private final int maxMemory = (int)Runtime.getRuntime().maxMemory();
    private int cacheSize = 5;
    private int maxCachedEntrySize = this.cacheSize / 5;
    private boolean cacheEnabled = RendererSettings.getInstance().getCacheEnabled();

    private void init() {
        try {
            SVGLookup.getInstance();
            ModifierRenderer.getInstance();
            if (this._buffer == null) {
                this._buffer = new BufferedImage(8, 8, 2);
                Graphics2D g2d = this._buffer.createGraphics();
                this._fontRenderContext = g2d.getFontRenderContext();
            }
            RendererSettings.getInstance().addEventListener(_instance);
            this.SettingsEventChanged("CACHE_CHANGED");
            this.SettingsEventChanged("CACHE_TOGGLED");
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SinglePointRenderer", "init", exc);
        }
    }

    public static synchronized SinglePointRenderer getInstance() {
        if (_instance == null) {
            _instance = new SinglePointRenderer();
            _instance.init();
        }
        return _instance;
    }

    public ImageInfo render(String symbolID, Map<String, String> modifiers, Map<String, String> attributes) {
        ImageInfo ii = null;
        if (modifiers == null) {
            modifiers = new HashMap<String, String>();
        }
        ii = SymbolID.getSymbolSet(symbolID) == 25 || SymbolID.getSymbolSet(symbolID) == 45 || SymbolID.getSymbolSet(symbolID) == 46 || SymbolID.getSymbolSet(symbolID) == 47 ? this.RenderSP2(symbolID, modifiers, attributes) : this.RenderUnit2(symbolID, modifiers, attributes);
        return ii;
    }

    public ImageInfo RenderUnit2(String symbolID, Map<String, String> modifiers, Map<String, String> attributes) {
        ImageInfo ii = null;
        try {
            String lineColor = null;
            String fillColor = null;
            if (SymbolID.getSymbolSet(symbolID) == 36 && RendererSettings.getInstance().getSeaMineRenderMethod() == 1) {
                lineColor = RendererUtilities.colorToHexString(SymbolUtilities.getLineColorOfAffiliation(symbolID), false);
                fillColor = RendererUtilities.colorToHexString(SymbolUtilities.getFillColorOfAffiliation(symbolID), true);
            }
            String iconColor = null;
            float alpha = -1.0f;
            String frameID = null;
            String iconID = null;
            String mod1ID = null;
            String mod2ID = null;
            SVGInfo siFrame = null;
            SVGInfo siIcon = null;
            SVGInfo siMod1 = null;
            SVGInfo siMod2 = null;
            int top = 0;
            int left = 0;
            int width = 0;
            int height = 0;
            String svgStart = null;
            String strSVG = null;
            String strSVGFrame = null;
            Rectangle2D symbolBounds = null;
            Object fullBounds = null;
            Object fullBMP = null;
            boolean hasDisplayModifiers = false;
            boolean hasTextModifiers = false;
            int pixelSize = 50;
            boolean keepUnitRatio = true;
            double scale = 1.0;
            boolean icon = false;
            boolean asIcon = false;
            boolean noFrame = false;
            int ver = SymbolID.getVersion(symbolID);
            try {
                if (attributes != null) {
                    pixelSize = attributes.containsKey("PIXELSIZE") ? Integer.valueOf(attributes.get("PIXELSIZE")).intValue() : RendererSettings.getInstance().getDefaultPixelSize();
                    if (attributes.containsKey("LINECOLOR")) {
                        lineColor = attributes.get("LINECOLOR");
                    }
                    if (attributes.containsKey("FILLCOLOR")) {
                        fillColor = attributes.get("FILLCOLOR");
                    }
                    if (attributes.containsKey("ICONCOLOR")) {
                        iconColor = attributes.get("ICONCOLOR");
                    }
                    if (attributes.containsKey("ALPHA")) {
                        alpha = Float.parseFloat(attributes.get("ALPHA"));
                    }
                    if (attributes.containsKey("DRAWASICON")) {
                        asIcon = Boolean.parseBoolean(attributes.get("DRAWASICON"));
                    }
                    if (attributes.containsKey("KEEPUNITRATIO")) {
                        keepUnitRatio = Boolean.valueOf(attributes.get("KEEPUNITRATIO"));
                    }
                }
                if (icon) {
                    keepUnitRatio = false;
                    hasDisplayModifiers = false;
                    hasTextModifiers = false;
                } else {
                    hasDisplayModifiers = ModifierRenderer.hasDisplayModifiers(symbolID, modifiers);
                    hasTextModifiers = ModifierRenderer.hasTextModifiers(symbolID, modifiers);
                }
            }
            catch (Exception excModifiers) {
                ErrorLogger.LogException("MilStdIconRenderer", "RenderUnit", excModifiers);
            }
            String key = SinglePointRenderer.makeCacheKey(symbolID, lineColor, fillColor, iconColor, pixelSize, keepUnitRatio, false);
            if (this._unitCache != null) {
                ii = this._unitCache.get(key);
            }
            if (ii == null) {
                int version = SymbolID.getVersion(symbolID);
                frameID = SVGLookup.getFrameID(symbolID);
                iconID = SVGLookup.getMainIconID(symbolID);
                mod1ID = SVGLookup.getMod1ID(symbolID);
                mod2ID = SVGLookup.getMod2ID(symbolID);
                siFrame = SVGLookup.getInstance().getSVGLInfo(frameID, version);
                siIcon = SVGLookup.getInstance().getSVGLInfo(iconID, version);
                if (siFrame == null) {
                    frameID = SVGLookup.getFrameID(SymbolUtilities.reconcileSymbolID(symbolID));
                    siFrame = SVGLookup.getInstance().getSVGLInfo(frameID, version);
                    if (siFrame == null) {
                        frameID = SVGLookup.getFrameID(SymbolID.setSymbolSet(symbolID, 0));
                        siFrame = SVGLookup.getInstance().getSVGLInfo(frameID, version);
                    }
                }
                if (siIcon == null) {
                    if (!iconID.substring(2, 8).equals("000000") && MSLookup.getInstance().getMSLInfo(symbolID) == null) {
                        siIcon = SVGLookup.getInstance().getSVGLInfo("98100000", version);
                    } else if (SymbolID.getSymbolSet(symbolID) == 0) {
                        siIcon = SVGLookup.getInstance().getSVGLInfo("00000000", version);
                    }
                }
                siMod1 = SVGLookup.getInstance().getSVGLInfo(mod1ID, version);
                siMod2 = SVGLookup.getInstance().getSVGLInfo(mod2ID, version);
                top = (int)Math.round(siFrame.getBbox().getY());
                left = (int)Math.round(siFrame.getBbox().getX());
                width = (int)Math.round(siFrame.getBbox().getWidth());
                height = (int)Math.round(siFrame.getBbox().getHeight());
                svgStart = siFrame.getBbox().getMaxY() > 400.0 ? "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 612 792\">" : "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 400 400\">";
                strSVGFrame = lineColor != null || fillColor != null ? RendererUtilities.setSVGFrameColors(symbolID, siFrame.getSVG(), RendererUtilities.getColorFromHexString(lineColor), RendererUtilities.getColorFromHexString(fillColor)) : siFrame.getSVG();
                if (frameID.equals("octagon")) {
                    noFrame = true;
                    strSVGFrame = strSVGFrame.replaceFirst("<g id=\"octagon\">", "<g id=\"octagon\" display=\"none\">");
                }
                symbolBounds = RectUtilities.toRectangle(left, top, width, height);
                Rectangle2D rect = RectUtilities.copyRect(symbolBounds);
                float ratio = -1.0f;
                if (pixelSize > 0 && keepUnitRatio) {
                    float heightRatio = SymbolUtilities.getUnitRatioHeight(symbolID);
                    float widthRatio = SymbolUtilities.getUnitRatioWidth(symbolID);
                    if (noFrame) {
                        heightRatio = 1.0f;
                        widthRatio = 1.0f;
                    }
                    pixelSize = heightRatio > widthRatio ? (int)((float)pixelSize / 1.5f * heightRatio) : (int)((float)pixelSize / 1.5f * widthRatio);
                }
                if (pixelSize > 0) {
                    float p = pixelSize;
                    float h = (float)rect.getHeight();
                    float w = (float)rect.getWidth();
                    ratio = Math.min(p / h, p / w);
                    symbolBounds = RectUtilities.makeRectangle2DFromRect(0.0f, 0.0f, w * ratio, h * ratio);
                }
                Point centerOctagon = new Point(306, 396);
                centerOctagon.translate(-left, -top);
                Point centerPoint = centerOctagon = new Point((int)((float)centerOctagon.x * ratio), (int)((float)centerOctagon.y * ratio));
                Point centerCache = new Point(centerOctagon.x, centerOctagon.y);
                RectUtilities.shift(symbolBounds, 0, (int)(-symbolBounds.getY()));
                BufferedImage bmp = new BufferedImage((int)symbolBounds.getWidth(), (int)symbolBounds.getHeight(), 2);
                String svgAlpha = "";
                if (alpha >= 0.0f) {
                    svgAlpha = " opacity=\"" + alpha / 255.0f + "\"";
                }
                svgStart = "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"" + rect.getX() + " " + rect.getY() + " " + rect.getWidth() + " " + rect.getHeight() + "\" " + svgAlpha + ">";
                StringBuilder sb = new StringBuilder();
                sb.append(svgStart);
                if (strSVGFrame != null) {
                    sb.append(strSVGFrame);
                }
                String color = "";
                if (iconColor != null) {
                    if ((iconColor = RendererUtilities.colorToHexString(RendererUtilities.getColorFromHexString(iconColor), false)) != null && iconColor != "#000000" && iconColor != "") {
                        color = " stroke=\"" + iconColor + "\" fill=\"" + iconColor + "\" ";
                    } else {
                        iconColor = null;
                    }
                }
                String unit = "<g" + color + ">";
                if (siIcon != null) {
                    unit = unit + siIcon.getSVG();
                }
                if (siMod1 != null) {
                    unit = unit + siMod1.getSVG();
                }
                if (siMod2 != null) {
                    unit = unit + siMod2.getSVG();
                }
                if (iconColor != null) {
                    unit = unit.replaceAll("#000000", iconColor);
                }
                sb.append(unit + "</g>");
                sb.append("</svg>");
                strSVG = sb.toString();
                SVGLoader loader = new SVGLoader();
                SVGDocument svgDocument = null;
                ByteArrayInputStream stream = new ByteArrayInputStream(strSVG.getBytes(StandardCharsets.UTF_8));
                svgDocument = loader.load((InputStream)stream);
                ViewBox vb = new ViewBox(0.0f, 0.0f, (float)bmp.getWidth(), (float)bmp.getHeight());
                Graphics2D g = bmp.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                svgDocument.render(null, g, vb);
                g.dispose();
                Point center = SymbolUtilities.getCMSymbolAnchorPoint(symbolID, RectUtilities.makeRectangle2DFromRect(0.0, 0.0, symbolBounds.getWidth(), symbolBounds.getHeight()));
                ii = new ImageInfo(bmp, center, symbolBounds);
                if (this.cacheEnabled && this._unitCache != null && !asIcon && pixelSize <= 200 && this._unitCache.get(key) == null) {
                    this._unitCache.put(key, ii);
                }
            }
            ImageInfo iiNew = null;
            SymbolDimensionInfo sdiTemp = null;
            hasDisplayModifiers = ModifierRenderer.hasDisplayModifiers(symbolID, modifiers);
            hasTextModifiers = ModifierRenderer.hasTextModifiers(symbolID, modifiers);
            if (hasDisplayModifiers) {
                sdiTemp = ModifierRenderer.processUnitDisplayModifiers(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                iiNew = sdiTemp instanceof ImageInfo ? (ImageInfo)sdiTemp : null;
                sdiTemp = null;
            }
            if (iiNew != null) {
                ii = iiNew;
            }
            iiNew = null;
            if (hasTextModifiers) {
                int ss = SymbolID.getSymbolSet(symbolID);
                switch (ss) {
                    case 10: 
                    case 11: {
                        if (ver >= 13) {
                            sdiTemp = ModifierRenderer.processLandUnitTextModifiersE(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        sdiTemp = ModifierRenderer.processLandUnitTextModifiers(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 15: 
                    case 52: {
                        if (ver >= 13) {
                            sdiTemp = ModifierRenderer.processLandEquipmentTextModifiersE(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        sdiTemp = ModifierRenderer.processLandEquipmentTextModifiers(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 20: {
                        if (ver >= 13) {
                            sdiTemp = ModifierRenderer.processLandInstallationTextModifiersE(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        sdiTemp = ModifierRenderer.processLandInstallationTextModifiers(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 27: {
                        sdiTemp = ModifierRenderer.processDismountedIndividualsTextModifiers(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 51: {
                        if (ver >= 13) {
                            sdiTemp = ModifierRenderer.processAirSpaceUnitTextModifiersE(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        sdiTemp = ModifierRenderer.processAirSpaceUnitTextModifiers(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 50: {
                        if (ver < 13) {
                            sdiTemp = ModifierRenderer.processAirSpaceUnitTextModifiers(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        char frameShape = SymbolID.getFrameShape(symbolID);
                        if (frameShape == '1' || frameShape == '2') {
                            sdiTemp = ModifierRenderer.processAirSpaceUnitTextModifiersE(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        if (frameShape == '4') {
                            sdiTemp = ModifierRenderer.processLandEquipmentTextModifiersE(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        if (frameShape == '7') {
                            sdiTemp = ModifierRenderer.processSeaSubSurfaceTextModifiersE(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        sdiTemp = ModifierRenderer.processLandEquipmentTextModifiersE(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 30: 
                    case 53: {
                        if (ver >= 13) {
                            sdiTemp = ModifierRenderer.processSeaSurfaceTextModifiersE(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        sdiTemp = ModifierRenderer.processSeaSurfaceTextModifiers(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 35: 
                    case 54: {
                        if (ver >= 13) {
                            sdiTemp = ModifierRenderer.processSeaSubSurfaceTextModifiersE(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        sdiTemp = ModifierRenderer.processSeaSubSurfaceTextModifiers(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 40: {
                        if (ver >= 13) {
                            sdiTemp = ModifierRenderer.processActivitiesTextModifiersE(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        sdiTemp = ModifierRenderer.processActivitiesTextModifiers(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 60: {
                        sdiTemp = ModifierRenderer.processCyberSpaceTextModifiers(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 36: {
                        break;
                    }
                    default: {
                        sdiTemp = ModifierRenderer.processUnknownTextModifiers(ii, symbolID, modifiers, attributes, this._fontRenderContext);
                    }
                }
            }
            ImageInfo imageInfo = iiNew = sdiTemp instanceof ImageInfo ? (ImageInfo)sdiTemp : null;
            if (iiNew != null) {
                ii = iiNew;
            }
            iiNew = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SinglePointRenderer", "renderUnit", exc);
        }
        return ii;
    }

    public ImageInfo RenderSP2(String symbolID, Map<String, String> modifiers, Map<String, String> attributes) {
        int pixelSize = 50;
        double scale = 1.0;
        String lineColor = null;
        String fillColor = null;
        float alpha = -1.0f;
        boolean keepUnitRatio = true;
        boolean asIcon = false;
        boolean hasDisplayModifiers = false;
        boolean hasTextModifiers = false;
        boolean outlineSymbol = false;
        MSInfo msi = null;
        String iconID = null;
        SVGInfo siIcon = null;
        String mod1ID = null;
        SVGInfo siMod1 = null;
        int top = 0;
        int left = 0;
        int width = 0;
        int height = 0;
        String svgStart = null;
        String strSVG = null;
        double ratio = 0.0;
        RectangularShape symbolBounds = null;
        Object fullBounds = null;
        Object fullBMP = null;
        ImageInfo ii = null;
        try {
            msi = MSLookup.getInstance().getMSLInfo(symbolID);
            int ss = SymbolID.getSymbolSet(symbolID);
            int ec = SymbolID.getEntityCode(symbolID);
            int mod1 = 0;
            int drawRule = 0;
            boolean hasAPFill = false;
            if (msi != null) {
                drawRule = msi.getDrawRule();
            }
            if ((SymbolUtilities.isActionPoint(symbolID) || drawRule == 210 || ec == 180100 || ec == 180200 || ec == 180400) && SymbolID.getSymbolSet(symbolID) == 25) {
                lineColor = "#000000";
                hasAPFill = true;
            }
            if (lineColor == null) {
                lineColor = RendererUtilities.colorToHexString(SymbolUtilities.getDefaultLineColor(symbolID), false);
            }
            if (attributes != null) {
                if (attributes.containsKey("PIXELSIZE")) {
                    pixelSize = Integer.valueOf(attributes.get("PIXELSIZE"));
                }
                if (attributes.containsKey("LINECOLOR")) {
                    lineColor = attributes.get("LINECOLOR");
                }
                if (attributes.containsKey("FILLCOLOR")) {
                    fillColor = attributes.get("FILLCOLOR");
                }
                if (attributes.containsKey("DRAWASICON")) {
                    asIcon = Boolean.parseBoolean(attributes.get("DRAWASICON"));
                }
                if (attributes.containsKey("KEEPUNITRATIO")) {
                    keepUnitRatio = Boolean.parseBoolean(attributes.get("KEEPUNITRATIO"));
                }
                if (attributes.containsKey("ALPHA")) {
                    alpha = Float.parseFloat(attributes.get("ALPHA"));
                }
                if (!asIcon) {
                    outlineSymbol = attributes.containsKey("OUTLINESYMBOL") ? Boolean.parseBoolean(attributes.get("OUTLINESYMBOL")) : RendererSettings.getInstance().getOutlineSPControlMeasures();
                }
                if (SymbolUtilities.isMultiPoint(symbolID)) {
                    outlineSymbol = false;
                }
            }
            if (keepUnitRatio) {
                pixelSize = (int)Math.ceil((float)pixelSize / 1.5f * 1.75f);
            }
            if (ss == 25 && ec == 270701 && ((mod1 = SymbolID.getModifier1(symbolID)) < 13 || mod1 > 50)) {
                symbolID = SymbolID.setModifier1(symbolID, 13);
            }
            String key = SinglePointRenderer.makeCacheKey(symbolID, lineColor, fillColor, pixelSize, keepUnitRatio, outlineSymbol);
            if (this._tgCache != null) {
                ii = this._tgCache.get(key);
            }
            if (ii == null) {
                int version = SymbolID.getVersion(symbolID);
                Rectangle2D rect = null;
                iconID = SVGLookup.getMainIconID(symbolID);
                siIcon = SVGLookup.getInstance().getSVGLInfo(iconID, version);
                mod1ID = SVGLookup.getMod1ID(symbolID);
                siMod1 = SVGLookup.getInstance().getSVGLInfo(mod1ID, version);
                float borderPadding = 0.0f;
                if (outlineSymbol) {
                    borderPadding = RendererUtilities.findWidestStrokeWidth(siIcon.getSVG());
                }
                top = (int)Math.round(siIcon.getBbox().getY());
                left = (int)Math.round(siIcon.getBbox().getX());
                width = (int)Math.round(siIcon.getBbox().getWidth());
                height = (int)Math.round(siIcon.getBbox().getHeight());
                svgStart = siIcon.getBbox().getMaxX() > 400.0 ? "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 612 792\">" : "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 400 400\">";
                String strSVGIcon = null;
                if (drawRule == 201) {
                    siIcon = new SVGInfo(siIcon.getID(), siIcon.getBbox(), siIcon.getSVG().replaceAll("stroke-width=\"4\"", "stroke-width=\"6\""));
                }
                if (hasAPFill) {
                    String apFill = fillColor != null ? fillColor : RendererUtilities.colorToHexString(SymbolUtilities.getFillColorOfAffiliation(symbolID), false);
                    siIcon = new SVGInfo(siIcon.getID(), siIcon.getBbox(), siIcon.getSVG().replaceAll("fill=\"none\"", "fill=\"" + apFill + "\""));
                }
                if (msi.getSymbolSet() == 25 && (lineColor != null || fillColor != null)) {
                    if (outlineSymbol) {
                        strSVGIcon = RendererUtilities.setSVGSPCMColors(symbolID, siIcon.getSVG(), RendererUtilities.getIdealOutlineColor(RendererUtilities.getColorFromHexString(lineColor)), RendererUtilities.getColorFromHexString(fillColor), true);
                    }
                    strSVGIcon = strSVGIcon + RendererUtilities.setSVGSPCMColors(symbolID, siIcon.getSVG(), RendererUtilities.getColorFromHexString(lineColor), RendererUtilities.getColorFromHexString(fillColor), false);
                } else {
                    strSVGIcon = siIcon.getSVG();
                }
                if (SymbolID.getEntityCode(symbolID) == 270701 && siMod1 != null) {
                    if (outlineSymbol) {
                        strSVGIcon = strSVGIcon + RendererUtilities.setSVGSPCMColors(mod1ID, siMod1.getSVG(), RendererUtilities.getIdealOutlineColor(RendererUtilities.getColorFromHexString("#00A651")), RendererUtilities.getColorFromHexString("#00A651"), true);
                    }
                    strSVGIcon = strSVGIcon + RendererUtilities.setSVGSPCMColors(mod1ID, siMod1.getSVG(), RendererUtilities.getColorFromHexString(lineColor), RendererUtilities.getColorFromHexString(fillColor), false);
                }
                if (pixelSize > 0) {
                    symbolBounds = RectUtilities.toRectangle(left, top, width, height);
                    rect = RectUtilities.copyRect((Rectangle2D)symbolBounds);
                    float p = pixelSize;
                    double h = rect.getHeight();
                    double w = rect.getWidth();
                    ratio = Math.min((double)p / h, (double)p / w);
                    symbolBounds = RectUtilities.toRectangle(0.0, 0.0, w * ratio, h * ratio);
                    w = symbolBounds.getWidth();
                    h = symbolBounds.getHeight();
                    if (h / (h + (double)borderPadding) > 0.1) {
                        borderPadding = (float)(h * 0.1);
                    } else if (w / (w + (double)borderPadding) > 0.1) {
                        borderPadding = (float)(w * 0.1);
                    }
                }
                BufferedImage bmp = new BufferedImage((int)(symbolBounds.getWidth() + (double)Math.round(borderPadding)), (int)(symbolBounds.getHeight() + (double)Math.round(borderPadding)), 2);
                symbolBounds = RectUtilities.toRectangle(0.0, 0.0, bmp.getWidth(), bmp.getHeight());
                int offset = 0;
                if (outlineSymbol) {
                    RectUtilities.grow(rect, 4);
                    offset = 4;
                }
                String svgAlpha = "";
                if (alpha >= 0.0f) {
                    svgAlpha = " opacity=\"" + alpha / 255.0f + "\"";
                }
                svgStart = "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"" + rect.getX() + " " + rect.getY() + " " + rect.getWidth() + " " + rect.getHeight() + "\" " + svgAlpha + ">";
                strSVG = svgStart + strSVGIcon + "</svg>";
                SVGLoader loader = new SVGLoader();
                SVGDocument svgDocument = null;
                ByteArrayInputStream stream = new ByteArrayInputStream(strSVG.getBytes(StandardCharsets.UTF_8));
                svgDocument = loader.load((InputStream)stream);
                ViewBox vb = new ViewBox(0.0f, 0.0f, (float)bmp.getWidth(), (float)bmp.getHeight());
                Graphics2D g = bmp.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                svgDocument.render(null, g, vb);
                g.dispose();
                Point centerPoint = SymbolUtilities.getCMSymbolAnchorPoint(symbolID, RectUtilities.makeRectangle2DFromRect((double)offset, (double)offset, symbolBounds.getWidth(), symbolBounds.getHeight()));
                ii = new ImageInfo(bmp, centerPoint, (Rectangle2D)symbolBounds);
                if (this.cacheEnabled && this._tgCache != null && !asIcon && pixelSize <= 200 && this._tgCache.get(key) == null) {
                    this._tgCache.put(key, ii);
                }
            }
            ImageInfo iiNew = null;
            hasDisplayModifiers = ModifierRenderer.hasDisplayModifiers(symbolID, modifiers);
            hasTextModifiers = ModifierRenderer.hasTextModifiers(symbolID, modifiers);
            if (SymbolUtilities.isMultiPoint(symbolID)) {
                hasTextModifiers = false;
                hasDisplayModifiers = false;
            }
            if (!asIcon && (hasTextModifiers || hasDisplayModifiers)) {
                SymbolDimensionInfo sdiTemp = null;
                Color cLineColor = RendererUtilities.getColorFromHexString(lineColor);
                sdiTemp = SymbolUtilities.isSPWithSpecialModifierLayout(symbolID) ? ModifierRenderer.ProcessTGSPWithSpecialModifierLayout(ii, symbolID, modifiers, attributes, cLineColor, this._fontRenderContext) : ModifierRenderer.ProcessTGSPModifiers(ii, symbolID, modifiers, attributes, cLineColor, this._fontRenderContext);
                ImageInfo imageInfo = iiNew = sdiTemp instanceof ImageInfo ? (ImageInfo)sdiTemp : null;
            }
            if (iiNew != null) {
                ii = iiNew;
            }
            if ((iiNew = null) != null) {
                ii = iiNew;
            }
            iiNew = null;
            if (asIcon) {
                ii = ii.getSquareImageInfo();
                return ii;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdIconRenderer", "RenderSP", exc);
            return null;
        }
        return ii;
    }

    public ImageInfo RenderModifier2(String symbolID, Map<String, String> attributes) {
        Object temp = null;
        Object basicSymbolID = null;
        String lineColor = null;
        String fillColor = null;
        int alpha = -1;
        MSInfo msi = null;
        String iconID = null;
        SVGInfo siIcon = null;
        int top = 0;
        int left = 0;
        int width = 0;
        int height = 0;
        String svgStart = null;
        String strSVG = null;
        float ratio = 0.0f;
        Rectangle2D symbolBounds = null;
        Object fullBounds = null;
        Object fullBMP = null;
        boolean drawAsIcon = false;
        int pixelSize = -1;
        boolean keepUnitRatio = true;
        boolean hasDisplayModifiers = false;
        boolean hasTextModifiers = false;
        boolean drawCustomOutline = false;
        try {
            msi = MSLookup.getInstance().getMSLInfo(symbolID);
            if (attributes != null) {
                lineColor = RendererUtilities.colorToHexString(SymbolUtilities.getLineColorOfAffiliation(symbolID), false);
                if (attributes.containsKey("LINECOLOR")) {
                    lineColor = attributes.get("LINECOLOR");
                }
                if (attributes.containsKey("FILLCOLOR")) {
                    fillColor = attributes.get("FILLCOLOR");
                }
                if (attributes.containsKey("ALPHA")) {
                    alpha = Integer.parseInt(attributes.get("ALPHA"));
                }
                if (attributes.containsKey("DRAWASICON")) {
                    drawAsIcon = Boolean.parseBoolean(attributes.get("DRAWASICON"));
                }
                if (attributes.containsKey("PIXELSIZE")) {
                    pixelSize = Integer.parseInt(attributes.get("PIXELSIZE"));
                    if (msi.getSymbolSet() == 25 && SymbolID.getEntityCode(symbolID) == 270701) {
                        pixelSize = (int)((double)pixelSize * 0.9);
                    }
                }
            }
            if (!drawAsIcon) {
                drawCustomOutline = attributes.containsKey("OUTLINESYMBOL") ? Boolean.parseBoolean(attributes.get("OUTLINESYMBOL")) : RendererSettings.getInstance().getOutlineSPControlMeasures();
            }
        }
        catch (Exception excModifiers) {
            ErrorLogger.LogException("MilStdIconRenderer", "RenderSP", excModifiers);
        }
        try {
            ImageInfo ii = null;
            if (ii == null) {
                int version = SymbolID.getVersion(symbolID);
                Rectangle2D rect = null;
                iconID = SVGLookup.getMod1ID(symbolID);
                siIcon = SVGLookup.getInstance().getSVGLInfo(iconID, version);
                top = (int)Math.round(siIcon.getBbox().getY());
                left = (int)Math.round(siIcon.getBbox().getX());
                width = (int)Math.round(siIcon.getBbox().getWidth());
                height = (int)Math.round(siIcon.getBbox().getHeight());
                svgStart = siIcon.getBbox().getMaxY() > 400.0 ? "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 612 792\">" : "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 400 400\">";
                String strSVGIcon = "";
                Object strSVGOutline = null;
                if (msi.getSymbolSet() == 25 && (lineColor != null || fillColor != null)) {
                    if (drawCustomOutline) {
                        strSVGIcon = strSVGIcon + RendererUtilities.setSVGSPCMColors(iconID, siIcon.getSVG(), RendererUtilities.getIdealOutlineColor(RendererUtilities.getColorFromHexString(lineColor)), RendererUtilities.getColorFromHexString(fillColor), true);
                    }
                    strSVGIcon = strSVGIcon + RendererUtilities.setSVGSPCMColors(iconID, siIcon.getSVG(), RendererUtilities.getColorFromHexString(lineColor), RendererUtilities.getColorFromHexString(fillColor));
                } else {
                    strSVGIcon = siIcon.getSVG();
                }
                if (pixelSize > 0) {
                    symbolBounds = RectUtilities.toRectangle(left, top, width, height);
                    rect = RectUtilities.copyRect(symbolBounds);
                    float p = pixelSize;
                    float h = (float)rect.getHeight();
                    float w = (float)rect.getWidth();
                    ratio = Math.min(p / h, p / w);
                    symbolBounds = RectUtilities.makeRectangle2DFromRect(0.0f, 0.0f, w * ratio, h * ratio);
                }
                int offset = 0;
                if (drawCustomOutline) {
                    RectUtilities.grow(rect, 3);
                    offset = 3;
                }
                BufferedImage bmp = keepUnitRatio ? new BufferedImage((int)(symbolBounds.getWidth() + (double)(offset * 2)), (int)(symbolBounds.getHeight() + (double)(offset * 2)), 2) : new BufferedImage((int)symbolBounds.getWidth(), (int)symbolBounds.getHeight(), 2);
                symbolBounds = RectUtilities.makeRectangle2DFromRect(offset, offset, bmp.getWidth() - offset, bmp.getHeight() - offset);
                svgStart = siIcon.getBbox().getMaxX() > 400.0 ? "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"" + rect.getX() + " " + rect.getY() + " " + rect.getWidth() + " " + rect.getHeight() + "\">" : "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"" + rect.getX() + " " + rect.getY() + " " + rect.getWidth() + " " + rect.getHeight() + "\">";
                strSVG = svgStart + strSVGIcon + "</svg>";
                SVGLoader loader = new SVGLoader();
                SVGDocument svgDocument = null;
                ByteArrayInputStream stream = new ByteArrayInputStream(strSVG.getBytes(StandardCharsets.UTF_8));
                svgDocument = loader.load((InputStream)stream);
                ViewBox vb = new ViewBox(0.0f, 0.0f, (float)bmp.getWidth(), (float)bmp.getHeight());
                Graphics2D g = bmp.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                svgDocument.render(null, g, vb);
                g.dispose();
                Point centerPoint = SymbolUtilities.getCMSymbolAnchorPoint(symbolID, RectUtilities.toRectangle(offset, offset, symbolBounds.getWidth(), symbolBounds.getHeight()));
                ii = new ImageInfo(bmp, centerPoint, symbolBounds);
            }
            symbolBounds = null;
            fullBMP = null;
            fullBounds = null;
            if (drawAsIcon) {
                return ii.getSquareImageInfo();
            }
            return ii;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdIconRenderer", "RenderSP", exc);
            return null;
        }
    }

    private String makeDynamicSVG() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Object svgStart = null;
        pw.println("<svg width=\"35\" height=\"35\" style=\"fill:none;stroke-width:16\">");
        pw.println("</svg>");
        pw.close();
        return sw.toString();
    }

    private String getSVGString(String symbolID, boolean isOutline) {
        int version = SymbolID.getVersion(symbolID);
        SVGInfo svgi = SVGLookup.getInstance().getSVGLInfo(SymbolUtilities.getBasicSymbolID(symbolID), version);
        String strSVG = svgi.getSVG();
        if (isOutline) {
            strSVG = strSVG.replaceFirst("<g id=\"" + SymbolUtilities.getBasicSymbolID(symbolID) + "\">", "<g id=\"" + SymbolUtilities.getBasicSymbolID(symbolID) + "_outline\">");
        }
        String svgStart = null;
        svgStart = svgi.getBbox().getMaxY() > 400.0 ? "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 612 792\">" : "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 400 400\">";
        strSVG = svgStart + strSVG + "</svg>";
        return strSVG;
    }

    private static String makeCacheKey(String symbolID, String lineColor, String fillColor, String iconColor, int size, boolean keepUnitRatio, boolean drawOutline) {
        String key = symbolID.substring(0, 7) + symbolID.substring(10, 20) + SymbolID.getFrameShape(symbolID) + lineColor + fillColor + iconColor + size + keepUnitRatio + drawOutline;
        return key;
    }

    private static String makeCacheKey(String symbolID, String lineColor, String fillColor, int size, boolean keepUnitRatio, boolean drawOutline) {
        return SinglePointRenderer.makeCacheKey(symbolID, lineColor, fillColor, "null", size, keepUnitRatio, drawOutline);
    }

    @Override
    public void SettingsEventChanged(String type) {
        if (type.equals("CACHE_TOGGLED")) {
            this.cacheEnabled = RendererSettings.getInstance().getCacheEnabled();
        }
    }
}

