/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.web.render;

import armyc2.c5isr.renderer.utilities.RendererSettings;

public class GeoPixelConversion {
    public static final double INCHES_PER_METER = 39.3700787;
    public static final double METERS_PER_DEG = 111319.49166666667;

    public static double metersPerPixel(double scale) {
        double step1 = scale / (double)RendererSettings.getInstance().getDeviceDPI();
        return step1 / 39.3700787;
    }

    public static double lat2y(double latitude, double scale, double latOrigin, double metPerPix) {
        double latRem = -(latitude - latOrigin);
        double pixDis = latRem * 111319.49166666667 / metPerPix;
        return pixDis;
    }

    public static double y2lat(double yPosition, double scale, double latOrigin, double metPerPix) {
        double latitude = latOrigin - yPosition * metPerPix / 111319.49166666667;
        return latitude;
    }

    public static double long2x(double longitude, double scale, double longOrigin, double latitude, double metPerPix, boolean normalize) {
        double longRem = longitude - longOrigin;
        if (normalize) {
            if (longRem > 180.0) {
                longRem -= 360.0;
            }
            if (longRem < -180.0) {
                longRem += 360.0;
            }
        }
        double metersPerDeg = GeoPixelConversion.GetMetersPerDegAtLat(latitude);
        double pixDis = longRem * metersPerDeg / metPerPix;
        return pixDis;
    }

    public static double x2long(double xPosition, double scale, double longOrigin, double latitude, double metPerPix) {
        double metersPerDeg = GeoPixelConversion.GetMetersPerDegAtLat(latitude);
        double longitude = longOrigin + xPosition * metPerPix / metersPerDeg;
        if (longitude < -180.0) {
            longitude += 360.0;
        } else if (longitude > 180.0) {
            longitude -= 360.0;
        }
        return longitude;
    }

    public static double Deg2Rad(double deg) {
        double conv_factor = Math.PI / 180;
        return deg * conv_factor;
    }

    public static double GetMetersPerDegAtLat(double lat) {
        lat = GeoPixelConversion.Deg2Rad(lat);
        double p1 = 111412.84;
        double p2 = -93.5;
        double p3 = 0.118;
        double longlen = p1 * Math.cos(lat) + p2 * Math.cos(3.0 * lat) + p3 * Math.cos(5.0 * lat);
        return longlen;
    }
}

