/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.JavaLineArray;

import armyc2.c5isr.JavaLineArray.CELineArray;
import armyc2.c5isr.JavaLineArray.DISMSupport;
import armyc2.c5isr.JavaLineArray.POINT2;
import armyc2.c5isr.JavaLineArray.Shape2;
import armyc2.c5isr.JavaLineArray.countsupport;
import armyc2.c5isr.JavaLineArray.flot;
import armyc2.c5isr.JavaLineArray.lineutility;
import armyc2.c5isr.JavaLineArray.ref;
import armyc2.c5isr.JavaTacticalRenderer.TGLight;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.renderer.utilities.RendererException;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public final class arraysupport {
    private static final double maxLength = 100.0;
    private static final double minLength = 2.5;
    private static double dACP = 0.0;
    private static final String _className = "arraysupport";

    private static void FillPoints(POINT2[] pLinePoints, int counter, ArrayList<POINT2> points) {
        points.clear();
        for (int j = 0; j < counter; ++j) {
            points.add(pLinePoints[j]);
        }
    }

    public static ArrayList<POINT2> GetLineArray2(TGLight tg, ArrayList<POINT2> pts, ArrayList<Shape2> shapes, Rectangle2D clipBounds, IPointConversion converter) {
        ArrayList<POINT2> points = null;
        try {
            int vblCounter;
            POINT2 pt = null;
            Object pLinePoints2 = null;
            POINT2[] pLinePoints = null;
            int vblSaveCounter = pts.size();
            int j = 0;
            if (pLinePoints2 == null || (pLinePoints2).length == 0) {
                pLinePoints = new POINT2[vblSaveCounter];
                for (j = 0; j < vblSaveCounter; ++j) {
                    pt = pts.get(j);
                    pLinePoints[j] = new POINT2(pt.x, pt.y, pt.style);
                }
            }
            if ((vblCounter = countsupport.GetCountersDouble(tg, vblSaveCounter, pLinePoints, clipBounds)) <= 0) {
                shapes = null;
                return null;
            }
            pLinePoints = new POINT2[vblCounter];
            lineutility.InitializePOINT2Array(pLinePoints);
            if (vblSaveCounter > pts.size()) {
                vblSaveCounter = pts.size();
            }
            if (vblSaveCounter > pLinePoints.length) {
                vblSaveCounter = pLinePoints.length;
            }
            for (j = 0; j < vblSaveCounter; ++j) {
                pt = pts.get(j);
                pLinePoints[j] = new POINT2(pt.x, pt.y, pt.style);
            }
            points = arraysupport.GetLineArray2Double(tg, pLinePoints, vblCounter, vblSaveCounter, shapes, clipBounds, converter);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetLineArray2", new RendererException("GetLineArray2 " + Integer.toString(tg.get_LineType()), exc));
        }
        return points;
    }

    private static int GetFORTLPointsDouble(TGLight tg, POINT2[] pLinePoints, int vblSaveCounter) {
        int nCounter = 0;
        try {
            int j = 0;
            int k = 0;
            int bolVertical = 0;
            int lCount = 0;
            double dIncrement = arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale());
            ref<double[]> m = new ref<double[]>();
            POINT2[] pSpikePoints = null;
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            lCount = countsupport.GetFORTLCountDouble(tg, pLinePoints, vblSaveCounter);
            int numGlyphs = 0;
            double dGlyphSize = dIncrement / 2.0;
            pSpikePoints = new POINT2[lCount];
            lineutility.InitializePOINT2Array(pSpikePoints);
            for (j = 0; j < vblSaveCounter - 1; ++j) {
                bolVertical = lineutility.CalcTrueSlopeDouble(pLinePoints[j], pLinePoints[j + 1], m);
                double dLengthSegment = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                if (dLengthSegment / dIncrement < 1.0) {
                    pSpikePoints[nCounter] = new POINT2(pLinePoints[j]);
                    pSpikePoints[++nCounter] = new POINT2(pLinePoints[j + 1]);
                    ++nCounter;
                    continue;
                }
                numGlyphs = (int)(dLengthSegment / dIncrement);
                double dSegIncrement = dLengthSegment / (double)numGlyphs;
                for (k = 0; k < numGlyphs; ++k) {
                    pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dSegIncrement, 0);
                    pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dSegIncrement - dSegIncrement / 2.0, 0);
                    pt0 = new POINT2(pSpikePoints[++nCounter - 1]);
                    pt1 = lineutility.ExtendLineDouble(pLinePoints[j], pSpikePoints[nCounter - 1], dSegIncrement / 2.0);
                    if (pLinePoints[j].x > pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 3, dGlyphSize);
                        pSpikePoints[++nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt1, 3, dGlyphSize);
                        ++nCounter;
                    }
                    if (pLinePoints[j].x < pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 2, dGlyphSize);
                        pSpikePoints[++nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt1, 2, dGlyphSize);
                        ++nCounter;
                    }
                    if (pLinePoints[j].x == pLinePoints[j + 1].x) {
                        if (pLinePoints[j].y < pLinePoints[j + 1].y) {
                            pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 1, dGlyphSize);
                            pSpikePoints[++nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt1, 1, dGlyphSize);
                            ++nCounter;
                        }
                        if (pLinePoints[j].y > pLinePoints[j + 1].y) {
                            pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 0, dGlyphSize);
                            pSpikePoints[++nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt1, 0, dGlyphSize);
                            ++nCounter;
                        }
                    }
                    pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nCounter - 3], dSegIncrement / 2.0, 0);
                    ++nCounter;
                }
                pSpikePoints[nCounter] = new POINT2(pLinePoints[j + 1]);
                ++nCounter;
            }
            for (j = 0; j < nCounter; ++j) {
                pLinePoints[j] = new POINT2(pSpikePoints[j]);
            }
            return nCounter;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetFORTLPointsDouble", new RendererException("GetFORTLPointsDouble " + Integer.toString(tg.get_LineType()), exc));
            return nCounter;
        }
    }

    private static int GetATWallPointsDouble2(TGLight tg, POINT2[] pLinePoints, int vblSaveCounter) {
        int nCounter = 0;
        try {
            int j = 0;
            int k = 0;
            int lCount = 0;
            double dLengthSegment = 0.0;
            double dIncrement = 0.0;
            POINT2[] pSpikePoints = null;
            double dSpikeSize = 0.0;
            int limit = 0;
            int numSpikes = 0;
            lCount = countsupport.GetFORTLCountDouble(tg, pLinePoints, vblSaveCounter);
            pSpikePoints = new POINT2[lCount];
            lineutility.InitializePOINT2Array(pSpikePoints);
            pSpikePoints[nCounter++] = new POINT2(pLinePoints[0]);
            for (j = 0; j < vblSaveCounter - 1; ++j) {
                dLengthSegment = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                dSpikeSize = arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale());
                dIncrement = 2.0 * dSpikeSize;
                numSpikes = (int)Math.round((dLengthSegment - dSpikeSize) / dIncrement);
                dIncrement = dLengthSegment / (double)numSpikes;
                limit = numSpikes - 1;
                for (k = -1; k < limit; ++k) {
                    pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - dSpikeSize * 3.0, 0);
                    POINT2 pt0 = lineutility.ExtendLineDouble(pLinePoints[j], pSpikePoints[++nCounter - 1], dSpikeSize / 2.0);
                    if (pLinePoints[j].x > pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pSpikePoints[nCounter - 1], pt0, 2, dSpikeSize);
                    }
                    if (pLinePoints[j].x < pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pSpikePoints[nCounter - 1], pt0, 3, dSpikeSize);
                    }
                    if (pLinePoints[j].x == pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = new POINT2(pt0);
                        pSpikePoints[nCounter].x = pLinePoints[j].y < pLinePoints[j + 1].y ? pt0.x - dSpikeSize : pt0.x + dSpikeSize;
                    }
                    pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nCounter - 2], dSpikeSize, 0);
                    ++nCounter;
                }
                pSpikePoints[nCounter] = new POINT2(pLinePoints[j + 1]);
                pSpikePoints[nCounter].style = 0;
                ++nCounter;
            }
            for (j = 0; j < nCounter; ++j) {
                pLinePoints[j] = new POINT2(pSpikePoints[j]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetATWallPointsDouble", new RendererException("GetATWallPointsDouble", exc));
        }
        return nCounter;
    }

    public static int GetInsideOutsideDouble2(POINT2 pt0, POINT2 pt1, POINT2[] pLinePoints, int vblCounter, int index, int lineType) {
        int nDirection = 0;
        try {
            ref<double[]> m = new ref<double[]>();
            ref<double[]> m0 = new ref<double[]>();
            double b0 = 0.0;
            double b2 = 0.0;
            double b = 0.0;
            double X0 = 0.0;
            double Y0 = 0.0;
            double X = 0.0;
            double Y = 0.0;
            int nInOutCounter = 0;
            int j = 0;
            int bolVertical = 0;
            int bolVertical2 = 0;
            boolean nOrientation = false;
            int extendLeft = 0;
            int extendRight = 1;
            int extendAbove = 2;
            int extendBelow = 3;
            POINT2 pt2 = new POINT2();
            bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m0);
            if (m0.value == null) {
                return 0;
            }
            X0 = (pt0.x + pt1.x) / 2.0;
            Y0 = (pt0.y + pt1.y) / 2.0;
            if (Math.abs(((double[])m0.value)[0]) >= 1.0 || bolVertical == 0) {
                nOrientation = false;
                for (j = 0; j < vblCounter - 1; ++j) {
                    if (index == j || !(pLinePoints[j].y < Y0 && pLinePoints[j + 1].y > Y0 || pLinePoints[j].y > Y0 && pLinePoints[j + 1].y < Y0 || pLinePoints[j].y < Y0 && pLinePoints[j + 1].y == Y0) && (pLinePoints[j].y != Y0 || !(pLinePoints[j + 1].y < Y0))) continue;
                    bolVertical2 = lineutility.CalcTrueSlopeDouble(pLinePoints[j], pLinePoints[j + 1], m);
                    if (bolVertical2 == 1 && ((double[])m.value)[0] == 0.0) {
                        ++nInOutCounter;
                        --nInOutCounter;
                    }
                    if (bolVertical2 == 0 && pLinePoints[j].x < X0) {
                        ++nInOutCounter;
                    }
                    if (((double[])m.value)[0] == 0.0 || bolVertical2 != 1 || !((X = (Y0 - (b = pLinePoints[j].y - ((double[])m.value)[0] * pLinePoints[j].x)) / ((double[])m.value)[0]) < X0)) continue;
                    ++nInOutCounter;
                }
            } else {
                nOrientation = true;
                for (j = 0; j < vblCounter - 1; ++j) {
                    if (index == j || !(pLinePoints[j].x < X0 && pLinePoints[j + 1].x > X0 || pLinePoints[j].x > X0 && pLinePoints[j + 1].x < X0 || pLinePoints[j].x < X0 && pLinePoints[j + 1].x == X0) && (pLinePoints[j].x != X0 || !(pLinePoints[j + 1].x < X0))) continue;
                    bolVertical2 = lineutility.CalcTrueSlopeDouble(pLinePoints[j], pLinePoints[j + 1], m);
                    if (bolVertical2 == 0) {
                        ++nInOutCounter;
                        --nInOutCounter;
                    }
                    if (bolVertical2 == 1 && ((double[])m.value)[0] == 0.0 && pLinePoints[j].y < Y0) {
                        ++nInOutCounter;
                    }
                    if (((double[])m.value)[0] == 0.0 || bolVertical2 != 1 || !((Y = ((double[])m.value)[0] * X0 + (b = pLinePoints[j].y - ((double[])m.value)[0] * pLinePoints[j].x)) < Y0)) continue;
                    ++nInOutCounter;
                }
            }
            switch (nInOutCounter % 2) {
                case 0: {
                    if (!nOrientation) {
                        nDirection = extendLeft;
                        break;
                    }
                    nDirection = extendAbove;
                    break;
                }
                case 1: {
                    if (!nOrientation) {
                        nDirection = extendRight;
                        break;
                    }
                    nDirection = extendBelow;
                    break;
                }
            }
            switch (lineType) {
                case 31740000: {
                    if (nDirection == extendLeft) {
                        nDirection = extendRight;
                        break;
                    }
                    if (nDirection == extendRight) {
                        nDirection = extendLeft;
                        break;
                    }
                    if (nDirection == extendAbove) {
                        nDirection = extendBelow;
                        break;
                    }
                    if (nDirection != extendBelow) break;
                    nDirection = extendAbove;
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetInsideOutsideDouble2", new RendererException("GetInsideOutsideDouble2", exc));
        }
        return nDirection;
    }

    protected static int GetZONEPointsDouble2(TGLight tg, POINT2[] pLinePoints, int vblSaveCounter) {
        int nCounter = 0;
        try {
            int lineType = tg.get_LineType();
            int j = 0;
            int k = 0;
            int n = 0;
            int lCount = 0;
            double dLengthSegment = 0.0;
            POINT2 pt0 = new POINT2(pLinePoints[0]);
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            POINT2[] pSpikePoints = null;
            int nDirection = 0;
            double dIncrement = arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale());
            lCount = countsupport.GetFORTLCountDouble(tg, pLinePoints, vblSaveCounter);
            pSpikePoints = new POINT2[lCount];
            lineutility.InitializePOINT2Array(pSpikePoints);
            double remainder = 0.0;
            for (j = 0; j < vblSaveCounter - 1; ++j) {
                pt1 = new POINT2(pLinePoints[j]);
                pt2 = new POINT2(pLinePoints[j + 1]);
                nDirection = arraysupport.GetInsideOutsideDouble2(pt1, pt2, pLinePoints, vblSaveCounter, j, lineType);
                dLengthSegment = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                if (dLengthSegment < dIncrement) {
                    pSpikePoints[nCounter] = new POINT2(pLinePoints[j]);
                    pSpikePoints[++nCounter] = new POINT2(pLinePoints[j + 1]);
                    ++nCounter;
                    continue;
                }
                block1 : switch (lineType) {
                    case 23114000: 
                    case 23115000: {
                        switch (nDirection) {
                            case 0: {
                                nDirection = 1;
                                break block1;
                            }
                            case 1: {
                                nDirection = 0;
                                break block1;
                            }
                            case 2: {
                                nDirection = 3;
                                break block1;
                            }
                            case 3: {
                                nDirection = 2;
                                break block1;
                            }
                        }
                        break;
                    }
                }
                n = (int)(dLengthSegment / dIncrement);
                remainder = dLengthSegment - (double)n * dIncrement;
                for (k = 0; k < n; ++k) {
                    if (k > 0) {
                        pSpikePoints[nCounter++] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - remainder / 2.0, 0);
                        pSpikePoints[nCounter++] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - dIncrement / 2.0 - remainder / 2.0, 0);
                    } else {
                        pSpikePoints[nCounter++] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement, 0);
                        pSpikePoints[nCounter++] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - dIncrement / 2.0, 0);
                    }
                    switch (lineType) {
                        case 22624000: 
                        case 23113000: 
                        case 23114000: 
                        case 23115000: {
                            pt0 = lineutility.ExtendLineDouble(pLinePoints[j], pSpikePoints[nCounter - 1], dIncrement / 4.0);
                            break;
                        }
                        case 22134000: 
                        case 23350000: 
                        case 1322134000: {
                            pt0 = new POINT2(pSpikePoints[nCounter - 1]);
                            break;
                        }
                    }
                    pSpikePoints[nCounter++] = lineutility.ExtendDirectedLine(pt1, pt2, pt0, nDirection, dIncrement / 2.0);
                    switch (lineType) {
                        case 22624000: 
                        case 23113000: 
                        case 23114000: 
                        case 23115000: {
                            pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nCounter - 2], dIncrement / 2.0, 0);
                            break;
                        }
                        case 23350000: {
                            pSpikePoints[nCounter] = new POINT2(pSpikePoints[nCounter - 2]);
                            break;
                        }
                        case 22134000: 
                        case 1322134000: {
                            pt3 = lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nCounter - 2], dIncrement / 2.0, 0);
                            pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pt1, pt2, pt3, nDirection, dIncrement / 2.0);
                            pSpikePoints[++nCounter] = new POINT2(pt3);
                            break;
                        }
                    }
                    ++nCounter;
                    if (lineType != 22624000) continue;
                    pSpikePoints[nCounter++] = new POINT2(pSpikePoints[nCounter - 4]);
                }
                pSpikePoints[nCounter++] = new POINT2(pLinePoints[j + 1]);
            }
            for (j = 0; j < nCounter; ++j) {
                if ((long)lineType != 23115000L) continue;
                pSpikePoints[j].style = 11;
            }
            if ((long)lineType == 23115000L) {
                pSpikePoints[nCounter - 1].style = 12;
            } else if (nCounter > 0) {
                pSpikePoints[nCounter - 1].style = 5;
            }
            for (j = 0; j < nCounter; ++j) {
                pLinePoints[j] = new POINT2(pSpikePoints[j]);
                if (j != nCounter - 1 || (long)lineType == 23115000L) continue;
                pLinePoints[j].style = 5;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetZONEPointsDouble2", new RendererException("GetZONEPointsDouble2", exc));
        }
        return nCounter;
    }

    private static boolean IsTurnArcReversed(POINT2[] pPoints) {
        try {
            if (pPoints.length < 3) {
                return false;
            }
            POINT2[] ptsSeize = new POINT2[]{new POINT2(pPoints[0]), new POINT2(pPoints[1])};
            lineutility.CalcClockwiseCenterDouble(ptsSeize);
            double d = lineutility.CalcDistanceDouble(ptsSeize[0], pPoints[2]);
            ptsSeize[0] = new POINT2(pPoints[1]);
            ptsSeize[1] = new POINT2(pPoints[0]);
            lineutility.CalcClockwiseCenterDouble(ptsSeize);
            double dArcReversed = lineutility.CalcDistanceDouble(ptsSeize[0], pPoints[2]);
            ptsSeize = null;
            return dArcReversed > d;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "IsTurnArcReversed", new RendererException("IsTurnArcReversed", exc));
            return false;
        }
    }

    private static void GetIsolatePointsDouble(POINT2[] pLinePoints, int lineType, IPointConversion converter) {
        try {
            POINT2 pt0 = new POINT2(pLinePoints[0]);
            POINT2 pt1 = new POINT2(pLinePoints[1]);
            POINT2 pt2 = new POINT2(pLinePoints[0]);
            if (pt0.x == pt1.x && pt0.y == pt1.y) {
                pt1.x += 1.0;
            }
            POINT2 C = new POINT2();
            POINT2 E = new POINT2();
            int j = 0;
            int k = 0;
            int l = 0;
            POINT2[] ptsArc = new POINT2[26];
            POINT2[] midPts = new POINT2[7];
            POINT2[] trianglePts = new POINT2[21];
            POINT2[] pArrowPoints = new POINT2[3];
            double dRadius = lineutility.CalcDistanceDouble(pt0, pt1);
            double dLength = Math.abs(dRadius - 20.0);
            if (dRadius < 40.0) {
                dLength = dRadius / 1.5;
            }
            double d = lineutility.MBRDistance(pLinePoints, 2);
            POINT2[] ptsSeize = new POINT2[2];
            POINT2[] savepoints = new POINT2[3];
            for (j = 0; j < 2; ++j) {
                savepoints[j] = new POINT2(pLinePoints[j]);
            }
            if (pLinePoints.length >= 3) {
                savepoints[2] = new POINT2(pLinePoints[2]);
            }
            lineutility.InitializePOINT2Array(ptsArc);
            lineutility.InitializePOINT2Array(midPts);
            lineutility.InitializePOINT2Array(trianglePts);
            lineutility.InitializePOINT2Array(pArrowPoints);
            lineutility.InitializePOINT2Array(ptsSeize);
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (d / 7.0 > 100.0 * DPIScaleFactor) {
                d = 700.0 * DPIScaleFactor;
            }
            if (d / 7.0 < 2.5 * DPIScaleFactor) {
                d = 17.5 * DPIScaleFactor;
            }
            if (d > 140.0 * DPIScaleFactor) {
                d = 140.0 * DPIScaleFactor;
            }
            POINT2[] ptsArc2 = new POINT2[26];
            lineutility.InitializePOINT2Array(ptsArc2);
            E.x = 2.0 * pt1.x - pt0.x;
            E.y = 2.0 * pt1.y - pt0.y;
            ptsArc[0] = new POINT2(pLinePoints[1]);
            ptsArc[1] = new POINT2(E);
            if (converter != null) {
                ptsArc[0] = new POINT2(pLinePoints[0]);
                ptsArc[1] = new POINT2(pLinePoints[1]);
            }
            lineutility.ArcArrayDouble(ptsArc, 0, dRadius, lineType, converter);
            for (j = 0; j < 26; ++j) {
                ptsArc[j].style = 0;
                pLinePoints[j] = new POINT2(ptsArc[j]);
                pLinePoints[j].style = 0;
            }
            if (lineType != 211600000) {
                lineutility.GetArrowHead4Double(ptsArc[24], ptsArc[25], (int)d / 7, (int)d / 7, pArrowPoints, 0);
            } else {
                lineutility.GetArrowHead4Double(ptsArc[24], ptsArc[25], (int)d / 7, (int)(1.75 * d) / 7, pArrowPoints, 0);
            }
            pLinePoints[25].style = 5;
            switch (lineType) {
                case 211400000: 
                case 212500000: 
                case 212600000: {
                    if (dRadius > 100.0) {
                        dLength = 0.8 * dRadius;
                    }
                    for (j = 1; j <= 23; ++j) {
                        if (j % 3 != 0) continue;
                        midPts[k].x = pt0.x - (double)((long)(dLength / dRadius * (pt0.x - ptsArc[j].x)));
                        midPts[k].y = pt0.y - (double)((long)(dLength / dRadius * (pt0.y - ptsArc[j].y)));
                        midPts[k].style = 0;
                        trianglePts[l] = new POINT2(ptsArc[j - 1]);
                        trianglePts[++l] = new POINT2(midPts[k]);
                        trianglePts[++l] = new POINT2(ptsArc[j + 1]);
                        trianglePts[l].style = 5;
                        ++l;
                        ++k;
                    }
                    for (j = 26; j < 47; ++j) {
                        pLinePoints[j] = new POINT2(trianglePts[j - 26]);
                    }
                    pLinePoints[46].style = 5;
                    for (j = 47; j < 50; ++j) {
                        pLinePoints[j] = new POINT2(pArrowPoints[j - 47]);
                        pLinePoints[j].style = 0;
                    }
                    break;
                }
                case 211600000: {
                    for (j = 26; j < 29; ++j) {
                        pLinePoints[j] = new POINT2(pArrowPoints[j - 26]);
                    }
                    pLinePoints[29] = lineutility.ExtendAlongLineDouble(pArrowPoints[0], pArrowPoints[1], lineutility.CalcDistanceDouble(pArrowPoints[0], pArrowPoints[1]) * 2.0);
                    pLinePoints[30] = new POINT2(pArrowPoints[1]);
                    pLinePoints[31] = lineutility.ExtendAlongLineDouble(pArrowPoints[2], pArrowPoints[1], lineutility.CalcDistanceDouble(pArrowPoints[2], pArrowPoints[1]) * 2.0);
                    break;
                }
                case 212100000: {
                    for (j = 26; j < 29; ++j) {
                        pLinePoints[j] = new POINT2(pArrowPoints[j - 26]);
                        pLinePoints[j].style = 0;
                    }
                    pLinePoints[28].style = 5;
                    break;
                }
                case 23173000: {
                    boolean changeArc = arraysupport.IsTurnArcReversed(savepoints);
                    if (changeArc) {
                        pt0.x = pt1.x;
                        pt0.y = pt1.y;
                        pt1.x = pt2.x;
                        pt1.y = pt2.y;
                    }
                    ptsSeize[0] = new POINT2(pt0);
                    ptsSeize[1] = new POINT2(pt1);
                    dRadius = lineutility.CalcClockwiseCenterDouble(ptsSeize);
                    C = new POINT2(ptsSeize[0]);
                    E = new POINT2(ptsSeize[1]);
                    ptsArc[0] = new POINT2(pt0);
                    ptsArc[1] = new POINT2(E);
                    lineutility.ArcArrayDouble(ptsArc, 0, dRadius, lineType, null);
                    for (j = 0; j < 26; ++j) {
                        ptsArc[j].style = 0;
                        pLinePoints[j] = new POINT2(ptsArc[j]);
                        pLinePoints[j].style = 0;
                    }
                    if (changeArc) {
                        lineutility.GetArrowHead4Double(ptsArc[1], pt0, (int)d / 7, (int)d / 7, pArrowPoints, 5);
                    } else {
                        lineutility.GetArrowHead4Double(ptsArc[24], pt1, (int)d / 7, (int)d / 7, pArrowPoints, 5);
                    }
                    pLinePoints[25].style = 5;
                    for (j = 26; j < 29; ++j) {
                        pLinePoints[j] = new POINT2(pArrowPoints[j - 26]);
                        pLinePoints[j].style = 9;
                    }
                    pLinePoints[28].style = 10;
                    break;
                }
                case 211900000: {
                    for (j = 26; j < 29; ++j) {
                        pLinePoints[j] = new POINT2(pArrowPoints[j - 26]);
                        pLinePoints[j].style = 0;
                    }
                    pLinePoints[28].style = 5;
                    k = 29;
                    for (j = 1; j < 24; ++j) {
                        pLinePoints[k] = new POINT2(ptsArc[j]);
                        pLinePoints[k].style = 0;
                        pLinePoints[++k] = lineutility.ExtendLineDouble(pt0, ptsArc[j], (long)d / 7L);
                        pLinePoints[k].style = 5;
                        ++k;
                    }
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetIsolatePointsDouble", new RendererException("GetIsolatePointsDouble " + Integer.toString(lineType), exc));
        }
    }

    private static void AirfieldCenterFeature(POINT2[] pLinePoints, int vblCounter) {
        try {
            double d = lineutility.MBRDistance(pLinePoints, vblCounter - 5);
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (d > 350.0 * DPIScaleFactor) {
                d = 350.0 * DPIScaleFactor;
            } else if (d < 100.0 * DPIScaleFactor) {
                d = 100.0 * DPIScaleFactor;
            }
            for (int k = 0; k < vblCounter; ++k) {
                pLinePoints[k].style = 0;
            }
            pLinePoints[vblCounter - 5] = new POINT2(pLinePoints[0]);
            pLinePoints[vblCounter - 5].style = 5;
            pLinePoints[vblCounter - 4] = lineutility.CalcCenterPointDouble(pLinePoints, vblCounter - 6);
            pLinePoints[vblCounter - 4].x -= d / 10.0;
            pLinePoints[vblCounter - 4].style = 0;
            pLinePoints[vblCounter - 3] = new POINT2(pLinePoints[vblCounter - 4]);
            pLinePoints[vblCounter - 3].x = pLinePoints[vblCounter - 4].x + d / 5.0;
            pLinePoints[vblCounter - 3].style = 5;
            pLinePoints[vblCounter - 2] = new POINT2(pLinePoints[vblCounter - 4]);
            pLinePoints[vblCounter - 2].y += d / 20.0;
            pLinePoints[vblCounter - 2].style = 0;
            pLinePoints[vblCounter - 1] = new POINT2(pLinePoints[vblCounter - 3]);
            pLinePoints[vblCounter - 1].y -= d / 20.0;
            pLinePoints[vblCounter - 1].style = 0;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AirfieldCenterFeature", new RendererException("AirfieldCenterFeature", exc));
        }
    }

    private static int GetATWallPointsDouble(TGLight tg, POINT2[] pLinePoints, int vblSaveCounter) {
        int nCounter = 0;
        try {
            int lineType = tg.get_LineType();
            int j = 0;
            int k = 0;
            int lCount = 0;
            double dLengthSegment = 0.0;
            double dIncrement = 0.0;
            POINT2[] pSpikePoints = null;
            double dRemainder = 0.0;
            double dSpikeSize = 0.0;
            int limit = 0;
            lCount = countsupport.GetFORTLCountDouble(tg, pLinePoints, vblSaveCounter);
            pSpikePoints = new POINT2[lCount];
            switch (lineType) {
                case 31131200: 
                case 31131300: {
                    pSpikePoints[nCounter] = pLinePoints[0];
                    pSpikePoints[nCounter].style = 0;
                    ++nCounter;
                    break;
                }
            }
            for (j = 0; j < vblSaveCounter - 1; ++j) {
                dLengthSegment = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                switch (lineType) {
                    case 31131000: 
                    case 31131100: 
                    case 31131200: 
                    case 31131300: {
                        dIncrement = arraysupport.getScaledSize(60.0, tg.get_LineThickness(), tg.get_patternScale());
                        dSpikeSize = arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale());
                        dRemainder = dLengthSegment / dIncrement - (double)((int)(dLengthSegment / dIncrement));
                        if (dRemainder < 0.75) {
                            limit = (int)(dLengthSegment / dIncrement);
                            break;
                        }
                        limit = (int)(dLengthSegment / dIncrement) + 1;
                        break;
                    }
                    default: {
                        dIncrement = arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale());
                        dSpikeSize = arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale());
                        limit = (int)(dLengthSegment / dIncrement) - 1;
                    }
                }
                if (limit < 1) {
                    pSpikePoints[nCounter] = pLinePoints[j];
                    pSpikePoints[++nCounter] = pLinePoints[j + 1];
                    ++nCounter;
                    continue;
                }
                for (k = 0; k < limit; ++k) {
                    switch (lineType) {
                        case 31131200: {
                            if (k > 0) {
                                pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement + arraysupport.getScaledSize(45.0, tg.get_LineThickness(), tg.get_patternScale()), 0);
                                pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement + arraysupport.getScaledSize(4.0, tg.get_LineThickness(), tg.get_patternScale()), 5);
                                pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - arraysupport.getScaledSize(1.0, tg.get_LineThickness(), tg.get_patternScale()), 20);
                                pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale()), 0);
                                break;
                            }
                            pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - arraysupport.getScaledSize(45.0, tg.get_LineThickness(), tg.get_patternScale()), 0);
                            break;
                        }
                        case 31131300: {
                            if (k > 0) {
                                pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement + arraysupport.getScaledSize(45.0, tg.get_LineThickness(), tg.get_patternScale()), 0);
                                pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement + arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale()), 5);
                                pSpikePoints[++nCounter] = lineutility.ExtendAlongLineDouble(pSpikePoints[nCounter - 1], pLinePoints[j + 1], arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale()), 0);
                                pSpikePoints[++nCounter] = lineutility.ExtendAlongLineDouble(pSpikePoints[nCounter - 1], pLinePoints[j + 1], arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale()), 5);
                                POINT2 crossPt1 = lineutility.ExtendDirectedLine(pSpikePoints[++nCounter - 2], pSpikePoints[nCounter - 1], pSpikePoints[nCounter - 1], 3, arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale()), 0);
                                POINT2 crossPt2 = lineutility.ExtendDirectedLine(pSpikePoints[nCounter - 1], pSpikePoints[nCounter - 2], pSpikePoints[nCounter - 2], 2, arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale()), 5);
                                pSpikePoints[nCounter] = crossPt1;
                                pSpikePoints[++nCounter] = crossPt2;
                                pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale()), 0);
                                break;
                            }
                            pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - arraysupport.getScaledSize(45.0, tg.get_LineThickness(), tg.get_patternScale()), 0);
                            break;
                        }
                        default: {
                            pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - arraysupport.getScaledSize(30.0, tg.get_LineThickness(), tg.get_patternScale()), 0);
                        }
                    }
                    if (lineType == 31131000) {
                        pSpikePoints[nCounter].style = 0;
                    }
                    pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - dSpikeSize, 0);
                    if (lineType == 31131000 || lineType == 31131200 || lineType == 31131300) {
                        pSpikePoints[nCounter].style = 9;
                    }
                    POINT2 pt0 = lineutility.ExtendLineDouble(pLinePoints[j], pSpikePoints[++nCounter - 1], dSpikeSize / 2.0);
                    if (pLinePoints[j].x > pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pSpikePoints[nCounter - 1], pt0, 2, dSpikeSize);
                    }
                    if (pLinePoints[j].x < pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pSpikePoints[nCounter - 1], pt0, 3, dSpikeSize);
                    }
                    if (pLinePoints[j].x == pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = pt0;
                        pSpikePoints[nCounter].x = pLinePoints[j].y < pLinePoints[j + 1].y ? pt0.x - dSpikeSize : pt0.x + dSpikeSize;
                    }
                    ++nCounter;
                    if (lineType == 31131000 || lineType == 31131200 || lineType == 31131300) {
                        pSpikePoints[nCounter - 1].style = 9;
                    }
                    pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nCounter - 2], dSpikeSize, 0);
                    switch (lineType) {
                        case 31131000: {
                            pSpikePoints[nCounter].style = 10;
                            break;
                        }
                        case 31131200: 
                        case 31131300: {
                            pSpikePoints[nCounter].style = 10;
                            pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nCounter - 3], dSpikeSize, 0);
                            break;
                        }
                    }
                    ++nCounter;
                }
                pSpikePoints[nCounter] = pLinePoints[j + 1];
                pSpikePoints[nCounter].style = 0;
                ++nCounter;
            }
            for (j = 0; j < nCounter; ++j) {
                pLinePoints[j] = pSpikePoints[j];
            }
            pLinePoints[nCounter - 1].style = 5;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetATWallPointsDouble", new RendererException("GetATWallPointsDouble " + Integer.toString(tg.get_LineType()), exc));
        }
        return nCounter;
    }

    private static int GetRidgePointsDouble(TGLight tg, POINT2[] pLinePoints, int vblSaveCounter) {
        int nCounter = 0;
        try {
            int j = 0;
            int k = 0;
            int lCount = 0;
            double dLengthSegment = 0.0;
            double dIncrement = arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale());
            ref<double[]> m = new ref<double[]>();
            POINT2[] pSpikePoints = null;
            double dSpikeSize = arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale());
            int limit = 0;
            double d = 0.0;
            int bolVertical = 0;
            m.value = new double[1];
            lCount = countsupport.GetFORTLCountDouble(tg, pLinePoints, vblSaveCounter);
            pSpikePoints = new POINT2[lCount];
            lineutility.InitializePOINT2Array(pSpikePoints);
            for (j = 0; j < vblSaveCounter - 1; ++j) {
                bolVertical = lineutility.CalcTrueSlopeDouble(pLinePoints[j], pLinePoints[j + 1], m);
                dLengthSegment = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                limit = (int)(dLengthSegment / dIncrement);
                if (limit < 1) {
                    pSpikePoints[nCounter] = new POINT2(pLinePoints[j]);
                    pSpikePoints[++nCounter] = new POINT2(pLinePoints[j + 1]);
                    ++nCounter;
                    continue;
                }
                for (k = 0; k < limit; ++k) {
                    pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement, 0);
                    d = lineutility.CalcDistanceDouble(pLinePoints[j], pSpikePoints[++nCounter - 1]);
                    POINT2 pt0 = lineutility.ExtendLineDouble(pLinePoints[j + 1], pLinePoints[j], -d - dSpikeSize / 2.0);
                    pSpikePoints[nCounter] = bolVertical != 0 ? (pLinePoints[j].x < pLinePoints[j + 1].x ? lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 2, dSpikeSize) : lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 3, dSpikeSize)) : (pLinePoints[j + 1].y < pLinePoints[j].y ? lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 0, dSpikeSize) : lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 1, dSpikeSize));
                    pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], -d - dSpikeSize, 0);
                    ++nCounter;
                }
                pSpikePoints[nCounter] = new POINT2(pLinePoints[j + 1]);
                ++nCounter;
            }
            for (j = 0; j < nCounter; ++j) {
                pLinePoints[j] = new POINT2(pSpikePoints[j]);
            }
            for (j = nCounter; j < lCount; ++j) {
                pLinePoints[j] = new POINT2(pSpikePoints[nCounter - 1]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetRidgePointsDouble", new RendererException("GetRidgePointsDouble " + Integer.toString(tg.get_LineType()), exc));
        }
        return nCounter;
    }

    protected static int GetSquallDouble(POINT2[] pLinePoints, double amplitude, int quantity, double length, int numPoints) {
        int counter = 0;
        try {
            int j = 0;
            int k = 0;
            POINT2 savePoint1 = new POINT2(pLinePoints[0]);
            POINT2 savePoint2 = new POINT2(pLinePoints[numPoints - 1]);
            ref<int[]> sign = new ref<int[]>();
            int segQty = 0;
            int totalQty = countsupport.GetSquallQty(pLinePoints, quantity, length, numPoints);
            POINT2[] pSquallPts = new POINT2[totalQty];
            POINT2[] pSquallSegPts = null;
            lineutility.InitializePOINT2Array(pSquallPts);
            sign.value = new int[1];
            ((int[])sign.value)[0] = -1;
            if (totalQty == 0) {
                return 0;
            }
            for (j = 0; j < numPoints - 1; ++j) {
                POINT2 StartSegPt = new POINT2(pLinePoints[j]);
                POINT2 EndSegPt = new POINT2(pLinePoints[j + 1]);
                segQty = countsupport.GetSquallSegQty(StartSegPt, EndSegPt, quantity, length);
                if (segQty <= 0) {
                    pSquallPts[counter].x = StartSegPt.x;
                    pSquallPts[counter++].y = StartSegPt.y;
                    pSquallPts[counter].x = EndSegPt.x;
                    pSquallPts[counter++].y = EndSegPt.y;
                    continue;
                }
                pSquallSegPts = new POINT2[segQty];
                lineutility.InitializePOINT2Array(pSquallSegPts);
                ((int[])sign.value)[0] = -1;
                lineutility.GetSquallSegment(StartSegPt, EndSegPt, pSquallSegPts, sign, amplitude, quantity, length);
                for (k = 0; k < segQty; ++k) {
                    pSquallPts[counter].x = pSquallSegPts[k].x;
                    pSquallPts[counter].y = pSquallSegPts[k].y;
                    if (k == 0) {
                        pSquallPts[counter] = new POINT2(pLinePoints[j]);
                    }
                    if (k == segQty - 1) {
                        pSquallPts[counter] = new POINT2(pLinePoints[j + 1]);
                    }
                    pSquallPts[counter].style = 0;
                    ++counter;
                }
            }
            for (j = 0; j < counter; ++j) {
                if (j >= totalQty) continue;
                pLinePoints[j].x = pSquallPts[j].x;
                pLinePoints[j].y = pSquallPts[j].y;
                if (j == 0) {
                    pLinePoints[j] = new POINT2(savePoint1);
                }
                if (j == counter - 1) {
                    pLinePoints[j] = new POINT2(savePoint2);
                }
                pLinePoints[j].style = pSquallPts[j].style;
            }
            if (counter == 0) {
                for (j = 0; j < pLinePoints.length; ++j) {
                    pLinePoints[j] = j == 0 ? new POINT2(savePoint1) : new POINT2(savePoint2);
                }
                counter = pLinePoints.length;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSquallDouble", new RendererException("GetSquallDouble", exc));
        }
        return counter;
    }

    protected static int GetSevereSquall(POINT2[] pLinePoints, double length, int numPoints) {
        int l = 0;
        try {
            int quantity = 5;
            int j = 0;
            int k = 0;
            int totalQty = countsupport.GetSquallQty(pLinePoints, quantity, length, numPoints) + 2 * numPoints;
            POINT2[] squallPts = new POINT2[totalQty];
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            POINT2 pt3 = new POINT2();
            POINT2 pt4 = new POINT2();
            POINT2 pt5 = new POINT2();
            POINT2 pt6 = new POINT2();
            POINT2 pt7 = new POINT2();
            POINT2 pt8 = new POINT2();
            int segQty = 0;
            double dist = 0.0;
            lineutility.InitializePOINT2Array(squallPts);
            for (j = 0; j < numPoints - 1; ++j) {
                dist = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                segQty = (int)(dist / length);
                for (k = 0; k < segQty; ++k) {
                    pt0 = lineutility.ExtendAlongLineDouble2(pLinePoints[j], pLinePoints[j + 1], (double)k * length);
                    pt1 = lineutility.ExtendAlongLineDouble(pLinePoints[j], pLinePoints[j + 1], (double)k * length + length / 6.0 * 4.0);
                    pt1.style = 5;
                    squallPts[l++] = new POINT2(pt0);
                    squallPts[l++] = new POINT2(pt1);
                    pt5 = lineutility.ExtendAlongLineDouble(pLinePoints[j], pLinePoints[j + 1], (double)k * length + length / 6.0 * 5.0);
                    pt6 = lineutility.ExtendAlongLineDouble(pLinePoints[j], pLinePoints[j + 1], (double)k * length + length);
                    pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 2, length / 6.0, 0);
                    pt3 = lineutility.ExtendDirectedLine(pt0, pt5, pt5, 3, length / 6.0, 0);
                    pt4 = lineutility.ExtendDirectedLine(pt0, pt6, pt6, 2, length / 6.0, 5);
                    pt4.style = 5;
                    squallPts[l++] = new POINT2(pt2);
                    squallPts[l++] = new POINT2(pt3);
                    squallPts[l++] = new POINT2(pt4);
                }
                squallPts[l++] = new POINT2(pLinePoints[j + 1]);
                pt0 = lineutility.ExtendAlongLineDouble(pLinePoints[j + 1], pLinePoints[j], dist - (double)segQty * length);
                pt0.style = 5;
                squallPts[l++] = new POINT2(pt0);
            }
            if (l > pLinePoints.length) {
                l = pLinePoints.length;
            }
            for (j = 0; j < l && j < totalQty; ++j) {
                pLinePoints[j] = new POINT2(squallPts[j]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSevereSquall", new RendererException("GetSevereSquall", exc));
        }
        return l;
    }

    private static int GetConvergencePointsDouble(POINT2[] pLinePoints, double length, int vblCounter) {
        int counter = vblCounter;
        try {
            int j = 0;
            int k = 0;
            double d = 0.0;
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2[] tempPts = new POINT2[vblCounter];
            POINT2 tempPt = new POINT2();
            int numJags = 0;
            for (j = 0; j < vblCounter; ++j) {
                tempPts[j] = new POINT2(pLinePoints[j]);
            }
            pLinePoints[vblCounter - 1].style = 5;
            for (j = 0; j < vblCounter - 1; ++j) {
                pt0 = new POINT2(tempPts[j]);
                pt1 = new POINT2(tempPts[j + 1]);
                d = lineutility.CalcDistanceDouble(pt0, pt1);
                if (d - (double)(numJags = (int)(d / length)) * length < 5.0) {
                    --numJags;
                }
                for (k = 0; k < numJags; ++k) {
                    tempPt = lineutility.ExtendAlongLineDouble(pt0, pt1, (double)k * length + length / 2.0, 0);
                    pLinePoints[counter++] = new POINT2(tempPt);
                    tempPt = lineutility.ExtendAlongLineDouble(tempPt, pt1, length / 2.0);
                    tempPt = lineutility.ExtendDirectedLine(pt0, tempPt, tempPt, 2, length / 2.0, 5);
                    pLinePoints[counter++] = new POINT2(tempPt);
                    tempPt = lineutility.ExtendAlongLineDouble(pt0, pt1, (double)(k + 1) * length, 0);
                    pLinePoints[counter++] = new POINT2(tempPt);
                    tempPt = lineutility.ExtendAlongLineDouble(tempPt, pt1, length / 2.0);
                    tempPt = lineutility.ExtendDirectedLine(pt0, tempPt, tempPt, 3, length / 2.0, 5);
                    pLinePoints[counter++] = new POINT2(tempPt);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetConvergencePointsDouble", new RendererException("GetConvergencePointsDouble", exc));
        }
        return counter;
    }

    private static int GetITDPointsDouble(POINT2[] pLinePoints, double length, int vblCounter) {
        int counter = 0;
        try {
            int j = 0;
            int k = 0;
            double d = 0.0;
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2[] tempPts = new POINT2[vblCounter];
            POINT2 tempPt = new POINT2();
            int numJags = 0;
            int lineStyle = 19;
            for (j = 0; j < vblCounter; ++j) {
                tempPts[j] = new POINT2(pLinePoints[j]);
            }
            for (j = 0; j < vblCounter - 1; ++j) {
                pt0 = new POINT2(tempPts[j]);
                pt1 = new POINT2(tempPts[j + 1]);
                d = lineutility.CalcDistanceDouble(pt0, pt1);
                if (d - (double)(numJags = (int)(d / length)) * length / 3.0 * 2.0 < length / 3.0) {
                    --numJags;
                }
                if (numJags == 0) {
                    pt0.style = 19;
                    pLinePoints[counter++] = new POINT2(pt0);
                    pt1.style = 5;
                    pLinePoints[counter++] = new POINT2(pt1);
                }
                for (k = 0; k < numJags; ++k) {
                    tempPt = lineutility.ExtendAlongLineDouble(pt0, pt1, (double)k * length + length / 3.0, lineStyle);
                    pLinePoints[counter++] = new POINT2(tempPt);
                    if (k < numJags - 1) {
                        tempPt = lineutility.ExtendAlongLineDouble(tempPt, pt1, length * 2.0 / 3.0, 5);
                    } else {
                        tempPt = new POINT2(tempPts[j + 1]);
                        tempPt.style = 5;
                    }
                    pLinePoints[counter++] = new POINT2(tempPt);
                    lineStyle = lineStyle == 19 ? 25 : 19;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetITDPointsDouble", new RendererException("GetITDPointsDouble", exc));
        }
        return counter;
    }

    private static int GetXPoints(POINT2[] pOriginalLinePoints, POINT2[] XPoints, double segmentLength, int vblCounter) {
        int xCounter = 0;
        try {
            int j = 0;
            int k = 0;
            double d = 0.0;
            POINT2 pt3 = new POINT2();
            POINT2 pt4 = new POINT2();
            POINT2 pt5 = new POINT2();
            POINT2 pt6 = new POINT2();
            int numThisSegment = 0;
            double distInterval = 0.0;
            double xSize = segmentLength / 6.0;
            for (j = 0; j < vblCounter - 1; ++j) {
                d = lineutility.CalcDistanceDouble(pOriginalLinePoints[j], pOriginalLinePoints[j + 1]);
                numThisSegment = (int)((d - segmentLength) / segmentLength);
                distInterval = d / (double)numThisSegment;
                for (k = 0; k < numThisSegment; ++k) {
                    POINT2 pt0 = lineutility.ExtendAlongLineDouble2(pOriginalLinePoints[j], pOriginalLinePoints[j + 1], distInterval / 2.0 + distInterval * (double)k);
                    POINT2 pt1 = lineutility.ExtendAlongLineDouble2(pt0, pOriginalLinePoints[j + 1], xSize);
                    POINT2 pt2 = lineutility.ExtendAlongLineDouble2(pt0, pOriginalLinePoints[j + 1], -xSize);
                    pt3 = lineutility.ExtendDirectedLine(pOriginalLinePoints[j], pt1, pt1, 2, xSize);
                    pt4 = lineutility.ExtendDirectedLine(pOriginalLinePoints[j], pt1, pt1, 3, xSize);
                    pt4.style = 5;
                    pt5 = lineutility.ExtendDirectedLine(pOriginalLinePoints[j], pt2, pt2, 2, xSize);
                    pt6 = lineutility.ExtendDirectedLine(pOriginalLinePoints[j], pt2, pt2, 3, xSize);
                    pt6.style = 5;
                    XPoints[xCounter++] = new POINT2(pt3);
                    XPoints[xCounter++] = new POINT2(pt6);
                    XPoints[xCounter++] = new POINT2(pt5);
                    XPoints[xCounter++] = new POINT2(pt4);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetXPointsDouble", new RendererException("GetXPointsDouble", exc));
        }
        return xCounter;
    }

    private static POINT2[] getEllipsePoints(POINT2 ptCenter, POINT2 ptWidth, POINT2 ptHeight) {
        POINT2[] pEllipsePoints = null;
        try {
            pEllipsePoints = new POINT2[37];
            int l = 0;
            double dFactor = 0.0;
            double a = lineutility.CalcDistanceDouble(ptCenter, ptWidth);
            double b = lineutility.CalcDistanceDouble(ptCenter, ptHeight);
            lineutility.InitializePOINT2Array(pEllipsePoints);
            for (l = 1; l < 37; ++l) {
                dFactor = 10.0 * (double)l * Math.PI / 180.0;
                pEllipsePoints[l - 1].x = ptCenter.x + (double)((int)(a * Math.cos(dFactor)));
                pEllipsePoints[l - 1].y = ptCenter.y + (double)((int)(b * Math.sin(dFactor)));
                pEllipsePoints[l - 1].style = 0;
            }
            pEllipsePoints[36] = new POINT2(pEllipsePoints[0]);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetEllipsePoints", new RendererException("GetEllipsePoints", exc));
        }
        return pEllipsePoints;
    }

    private static POINT2[] getRotatedEllipsePoints(POINT2 ptCenter, POINT2 ptWidth, POINT2 ptHeight, double azimuth, int lineType) {
        POINT2[] pResultPoints = null;
        try {
            POINT2[] pEllipsePoints = new POINT2[36];
            int l = 0;
            int j = 0;
            double dFactor = 0.0;
            double a = lineutility.CalcDistanceDouble(ptCenter, ptWidth);
            double b = lineutility.CalcDistanceDouble(ptCenter, ptHeight);
            lineutility.InitializePOINT2Array(pEllipsePoints);
            for (l = 1; l < 37; ++l) {
                dFactor = 10.0 * (double)l * Math.PI / 180.0;
                pEllipsePoints[l - 1].x = ptCenter.x + a * Math.cos(dFactor);
                pEllipsePoints[l - 1].y = ptCenter.y + b * Math.sin(dFactor);
                pEllipsePoints[l - 1].style = 0;
            }
            lineutility.RotateGeometryDouble(pEllipsePoints, 36, azimuth - 90.0);
            pResultPoints = new POINT2[37];
            for (j = 0; j < 36; ++j) {
                pResultPoints[j] = pEllipsePoints[j];
            }
            pResultPoints[36] = pEllipsePoints[0];
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetRotatedEllipsePoints", new RendererException("GetRotatedEllipsePoints", exc));
        }
        return pResultPoints;
    }

    private static int GetLVOPoints(POINT2[] pOriginalLinePoints, POINT2[] pLinePoints, double ovalWidth, double segmentLength, int vblCounter) {
        int lEllipseCounter = 0;
        try {
            double dAngle = 0.0;
            double d = 0.0;
            double ovalLength = ovalWidth * 2.0;
            double dFactor = 0.0;
            int lHowManyThisSegment = 0;
            int j = 0;
            int k = 0;
            int l = 0;
            boolean t = false;
            POINT2 ptCenter = new POINT2();
            POINT2[] pEllipsePoints2 = new POINT2[37];
            double distInterval = 0.0;
            for (j = 0; j < vblCounter - 1; ++j) {
                lineutility.InitializePOINT2Array(pEllipsePoints2);
                d = lineutility.CalcDistanceDouble(pOriginalLinePoints[j], pOriginalLinePoints[j + 1]);
                lHowManyThisSegment = (int)((d - segmentLength) / segmentLength);
                distInterval = d / (double)lHowManyThisSegment;
                dAngle = lineutility.CalcSegmentAngleDouble(pOriginalLinePoints[j], pOriginalLinePoints[j + 1]);
                dAngle += 1.5707963267948966;
                for (k = 0; k < lHowManyThisSegment; ++k) {
                    ptCenter = lineutility.ExtendAlongLineDouble2(pOriginalLinePoints[j], pOriginalLinePoints[j + 1], (double)k * distInterval);
                    for (l = 1; l < 37; ++l) {
                        dFactor = 20.0 * (double)l * Math.PI / 180.0;
                        pEllipsePoints2[l - 1].x = ptCenter.x + (double)((int)(ovalWidth * Math.cos(dFactor)));
                        pEllipsePoints2[l - 1].y = ptCenter.y + (double)((int)(ovalLength * Math.sin(dFactor)));
                        pEllipsePoints2[l - 1].style = 0;
                    }
                    lineutility.RotateGeometryDouble(pEllipsePoints2, 36, (int)(dAngle * 180.0 / Math.PI));
                    pEllipsePoints2[36] = new POINT2(pEllipsePoints2[35]);
                    pEllipsePoints2[36].style = 5;
                    for (l = 0; l < 37; ++l) {
                        pLinePoints[lEllipseCounter] = new POINT2(pEllipsePoints2[l]);
                        ++lEllipseCounter;
                    }
                }
                if (j != vblCounter - 2) continue;
                ptCenter = pOriginalLinePoints[j + 1];
                for (l = 1; l < 37; ++l) {
                    dFactor = 20.0 * (double)l * Math.PI / 180.0;
                    pEllipsePoints2[l - 1].x = ptCenter.x + (double)((int)(ovalWidth * Math.cos(dFactor)));
                    pEllipsePoints2[l - 1].y = ptCenter.y + (double)((int)(ovalLength * Math.sin(dFactor)));
                    pEllipsePoints2[l - 1].style = 0;
                }
                lineutility.RotateGeometryDouble(pEllipsePoints2, 36, (int)(dAngle * 180.0 / Math.PI));
                pEllipsePoints2[36] = new POINT2(pEllipsePoints2[35]);
                pEllipsePoints2[36].style = 5;
                for (l = 0; l < 37; ++l) {
                    pLinePoints[lEllipseCounter] = new POINT2(pEllipsePoints2[l]);
                    ++lEllipseCounter;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetLVOPointsDouble", new RendererException("GetLVOPointsDouble", exc));
        }
        return lEllipseCounter;
    }

    private static int GetIcingPointsDouble(POINT2[] pLinePoints, double length, int vblCounter) {
        int counter = 0;
        try {
            int j = 0;
            POINT2[] origPoints = new POINT2[vblCounter];
            int nDirection = -1;
            int k = 0;
            int numSegments = 0;
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 midPt = new POINT2();
            POINT2 pt2 = new POINT2();
            for (j = 0; j < vblCounter; ++j) {
                origPoints[j] = new POINT2(pLinePoints[j]);
            }
            double distInterval = 0.0;
            for (j = 0; j < vblCounter - 1; ++j) {
                numSegments = (int)lineutility.CalcDistanceDouble(origPoints[j], origPoints[j + 1]);
                numSegments = (int)((double)numSegments / length);
                distInterval = lineutility.CalcDistanceDouble(origPoints[j], origPoints[j + 1]) / (double)numSegments;
                nDirection = arraysupport.GetInsideOutsideDouble2(origPoints[j], origPoints[j + 1], origPoints, vblCounter, j, 31740000);
                for (k = 0; k < numSegments; ++k) {
                    pt0 = k == 0 ? new POINT2(origPoints[j]) : lineutility.ExtendAlongLineDouble(origPoints[j], origPoints[j + 1], (double)k * distInterval, 0);
                    pt1 = lineutility.ExtendAlongLineDouble(origPoints[j], origPoints[j + 1], (double)k * distInterval + length * 2.0 / 3.0, 5);
                    midPt = lineutility.ExtendAlongLineDouble(origPoints[j], origPoints[j + 1], (double)k * distInterval + length / 3.0, 0);
                    pt2 = lineutility.ExtendDirectedLine(origPoints[j], origPoints[j + 1], midPt, nDirection, length / 3.0, 5);
                    pLinePoints[counter] = new POINT2(pt0);
                    pLinePoints[counter + 1] = new POINT2(pt1);
                    pLinePoints[counter + 2] = new POINT2(midPt);
                    pLinePoints[counter + 3] = new POINT2(pt2);
                    counter += 4;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetIcingPointsDouble", new RendererException("GetIcingPointsDouble", exc));
        }
        return counter;
    }

    protected static int GetAnchorageDouble(POINT2[] vbPoints2, double floatDiameter, int numPts) {
        int lFlotCounter = 0;
        try {
            int j = 0;
            int k = 0;
            int l = 0;
            int x1 = 0;
            int y1 = 0;
            int numSegPts = -1;
            int lFlotCount = 0;
            int lNumSegs = 0;
            double dDistance = 0.0;
            int[] vbPoints = null;
            int[] points = null;
            int[] points2 = null;
            POINT2 pt = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            lFlotCount = flot.GetAnchorageCountDouble(vbPoints2, floatDiameter, numPts);
            vbPoints = new int[2 * numPts];
            for (j = 0; j < numPts; ++j) {
                vbPoints[k] = (int)vbPoints2[j].x;
                vbPoints[++k] = (int)vbPoints2[j].y;
                ++k;
            }
            k = 0;
            ref<int[]> bFlip = new ref<int[]>();
            bFlip.value = new int[1];
            ref<int[]> lDirection = new ref<int[]>();
            lDirection.value = new int[1];
            ref<int[]> lLastDirection = new ref<int[]>();
            lLastDirection.value = new int[1];
            for (l = 0; l < numPts - 1; ++l) {
                pt1.x = vbPoints[2 * l];
                pt1.y = vbPoints[2 * l + 1];
                pt2.x = vbPoints[2 * l + 2];
                pt2.y = vbPoints[2 * l + 3];
                if (l > 0) {
                    pt1 = lineutility.ExtendAlongLineDouble(pt1, pt2, floatDiameter);
                }
                if ((lNumSegs = (int)((dDistance = lineutility.CalcDistanceDouble(pt1, pt2)) / floatDiameter)) > 0) {
                    points2 = new int[lNumSegs * 32];
                    numSegPts = flot.GetAnchorageFlotSegment(vbPoints, (int)pt1.x, (int)pt1.y, (int)pt2.x, (int)pt2.y, l, floatDiameter, points2, bFlip, lDirection, lLastDirection);
                    points = new int[numSegPts];
                    for (j = 0; j < numSegPts; ++j) {
                        points[j] = points2[j];
                    }
                    for (j = 0; j < numSegPts / 3; ++j) {
                        x1 = points[k];
                        y1 = points[k + 1];
                        k += 3;
                        if (j % 10 == 0) {
                            pt.x = x1;
                            pt.y = y1;
                            pt.style = 5;
                        } else if ((j + 1) % 10 == 0) {
                            if (lFlotCounter >= lFlotCount) break;
                            vbPoints2[lFlotCounter].x = x1;
                            vbPoints2[lFlotCounter++].y = y1;
                            vbPoints2[lFlotCounter++] = new POINT2(pt);
                            continue;
                        }
                        if (lFlotCounter >= lFlotCount) break;
                        vbPoints2[lFlotCounter].x = x1;
                        vbPoints2[lFlotCounter].y = y1;
                        ++lFlotCounter;
                    }
                    k = 0;
                    points = null;
                    continue;
                }
                if (lFlotCounter >= lFlotCount) continue;
                vbPoints2[lFlotCounter].x = vbPoints[2 * l];
                vbPoints2[lFlotCounter].y = vbPoints[2 * l + 1];
                ++lFlotCounter;
            }
            for (j = lFlotCounter - 1; j < lFlotCount; ++j) {
                vbPoints2[j].style = 5;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetAnchorageDouble", new RendererException("GetAnchorageDouble", exc));
        }
        return lFlotCounter;
    }

    private static int GetPipePoints(POINT2[] pLinePoints, double length, int vblCounter) {
        int counter = 0;
        try {
            POINT2[] pOriginalPoints = new POINT2[vblCounter];
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            POINT2[] xPoints = new POINT2[pLinePoints.length];
            int xCounter = 0;
            int j = 0;
            int k = 0;
            for (j = 0; j < vblCounter; ++j) {
                pOriginalPoints[j] = new POINT2(pLinePoints[j]);
            }
            int numSegs = 0;
            double d = 0.0;
            lineutility.InitializePOINT2Array(xPoints);
            for (j = 0; j < vblCounter - 1; ++j) {
                d = lineutility.CalcDistanceDouble(pOriginalPoints[j], pOriginalPoints[j + 1]);
                numSegs = (int)(d / length);
                for (k = 0; k < numSegs; ++k) {
                    pt0 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], length * (double)k);
                    pt0.style = 0;
                    pt1 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], length * (double)k + length / 2.0);
                    pt1.style = 5;
                    pt2 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], length * (double)k + length / 2.0);
                    pt2.style = 20;
                    pLinePoints[counter++] = new POINT2(pt0);
                    pLinePoints[counter++] = new POINT2(pt1);
                    xPoints[xCounter++] = new POINT2(pt2);
                }
                if (numSegs == 0) {
                    pLinePoints[counter] = new POINT2(pOriginalPoints[j]);
                    pLinePoints[counter++].style = 0;
                    pLinePoints[counter] = new POINT2(pOriginalPoints[j + 1]);
                    pLinePoints[counter++].style = 5;
                    continue;
                }
                pLinePoints[counter] = new POINT2(pLinePoints[counter - 1]);
                pLinePoints[counter++].style = 0;
                pLinePoints[counter] = new POINT2(pOriginalPoints[j + 1]);
                pLinePoints[counter++].style = 5;
            }
            for (k = 0; k < xCounter; ++k) {
                pLinePoints[counter++] = new POINT2(xPoints[k]);
            }
            pLinePoints[counter++] = new POINT2(pLinePoints[counter]);
            pOriginalPoints = null;
            xPoints = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetPipePoints", new RendererException("GetPipePoints", exc));
        }
        return counter;
    }

    private static int GetReefPoints(POINT2[] pLinePoints, double length, int vblCounter) {
        int counter = 0;
        try {
            POINT2[] pOriginalPoints = new POINT2[vblCounter];
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            POINT2 pt3 = new POINT2();
            POINT2 pt4 = new POINT2();
            for (int j = 0; j < vblCounter; ++j) {
                pOriginalPoints[j] = new POINT2(pLinePoints[j]);
            }
            int numSegs = 0;
            int direction = 0;
            double d = 0.0;
            for (int j = 0; j < vblCounter - 1; ++j) {
                direction = pOriginalPoints[j].x < pOriginalPoints[j + 1].x ? 2 : 3;
                d = lineutility.CalcDistanceDouble(pOriginalPoints[j], pOriginalPoints[j + 1]);
                numSegs = (int)(d / length);
                for (int k = 0; k < numSegs; ++k) {
                    pt0 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], length * (double)k);
                    pt1 = lineutility.ExtendAlongLineDouble2(pt0, pOriginalPoints[j + 1], length * 0.35);
                    pt1 = lineutility.ExtendDirectedLine(pOriginalPoints[j], pOriginalPoints[j + 1], pt1, direction, length);
                    pt2 = lineutility.ExtendAlongLineDouble2(pt0, pOriginalPoints[j + 1], length * 0.4);
                    pt2 = lineutility.ExtendDirectedLine(pOriginalPoints[j], pOriginalPoints[j + 1], pt2, direction, length * 0.6);
                    pt3 = lineutility.ExtendAlongLineDouble2(pt0, pOriginalPoints[j + 1], length * 0.75);
                    pt3 = lineutility.ExtendDirectedLine(pOriginalPoints[j], pOriginalPoints[j + 1], pt3, direction, length * 1.35);
                    pt4 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], length * (double)(k + 1));
                    pLinePoints[counter++] = new POINT2(pt0);
                    pLinePoints[counter++] = new POINT2(pt1);
                    pLinePoints[counter++] = new POINT2(pt2);
                    pLinePoints[counter++] = new POINT2(pt3);
                    pLinePoints[counter++] = new POINT2(pt4);
                }
                if (numSegs != 0) continue;
                pLinePoints[counter++] = new POINT2(pOriginalPoints[j]);
                pLinePoints[counter++] = new POINT2(pOriginalPoints[j + 1]);
            }
            pLinePoints[counter++] = new POINT2(pOriginalPoints[vblCounter - 1]);
            pOriginalPoints = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetReefPoints", new RendererException("GetReefPoints", exc));
        }
        return counter;
    }

    private static int GetRestrictedAreaPoints(POINT2[] pLinePoints, double length, int vblCounter) {
        int counter = 0;
        try {
            POINT2[] pOriginalPoints = new POINT2[vblCounter];
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            POINT2 pt3 = new POINT2();
            for (int j = 0; j < vblCounter; ++j) {
                pOriginalPoints[j] = new POINT2(pLinePoints[j]);
            }
            int direction = 0;
            int numSegs = 0;
            double d = 0.0;
            for (int j = 0; j < vblCounter - 1; ++j) {
                d = lineutility.CalcDistanceDouble(pOriginalPoints[j], pOriginalPoints[j + 1]);
                numSegs = (int)(d / length);
                direction = pOriginalPoints[j].x < pOriginalPoints[j + 1].x ? 3 : 2;
                for (int k = 0; k < numSegs; ++k) {
                    pt0 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], length * (double)k);
                    pt0.style = 0;
                    pt1 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], length * (double)k + length * 2.0 / 3.0);
                    pt1.style = 5;
                    pt2 = lineutility.MidPointDouble(pt0, pt1, 0);
                    pt3 = lineutility.ExtendDirectedLine(pOriginalPoints[j], pOriginalPoints[j + 1], pt2, direction, length * 2.0 / 3.0);
                    pt3.style = 5;
                    pLinePoints[counter++] = new POINT2(pt2);
                    pLinePoints[counter++] = new POINT2(pt3);
                    pLinePoints[counter++] = new POINT2(pt0);
                    pLinePoints[counter++] = new POINT2(pt1);
                }
                if (numSegs != 0) continue;
                pLinePoints[counter++] = new POINT2(pOriginalPoints[j]);
                pLinePoints[counter++] = new POINT2(pOriginalPoints[j + 1]);
            }
            pLinePoints[counter - 1].style = 0;
            pLinePoints[counter++] = new POINT2(pOriginalPoints[vblCounter - 1]);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetRestrictedAreaPoints", new RendererException("GetRestrictedAreaPoints", exc));
        }
        return counter;
    }

    private static int getOverheadWire(TGLight tg, POINT2[] pLinePoints, int vblCounter) {
        int counter = 0;
        try {
            int j = 0;
            POINT2 pt = null;
            POINT2 pt2 = null;
            ArrayList<POINT2> pts = new ArrayList<POINT2>();
            for (j = 0; j < vblCounter; ++j) {
                pt = new POINT2(pLinePoints[j]);
                pt2 = new POINT2(pt);
                pt2.y -= arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale());
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x -= arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale());
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.y -= arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale());
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x += arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale());
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.y -= arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale());
                pt2.style = 5;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x -= arraysupport.getScaledSize(2.0, tg.get_LineThickness(), tg.get_patternScale());
                pt2.y -= arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale());
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x += arraysupport.getScaledSize(2.0, tg.get_LineThickness(), tg.get_patternScale());
                pt2.y -= arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale());
                pt2.style = 5;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x -= arraysupport.getScaledSize(7.0, tg.get_LineThickness(), tg.get_patternScale());
                pt2.y -= arraysupport.getScaledSize(17.0, tg.get_LineThickness(), tg.get_patternScale());
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x -= arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale());
                pt2.y -= arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale());
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x += arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale());
                pt2.y -= arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale());
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x += arraysupport.getScaledSize(7.0, tg.get_LineThickness(), tg.get_patternScale());
                pt2.y -= arraysupport.getScaledSize(17.0, tg.get_LineThickness(), tg.get_patternScale());
                pt2.style = 5;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.y -= arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale());
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x += arraysupport.getScaledSize(8.0, tg.get_LineThickness(), tg.get_patternScale());
                pt2.y -= arraysupport.getScaledSize(12.0, tg.get_LineThickness(), tg.get_patternScale());
                pt2.style = 5;
                pts.add(pt2);
            }
            for (j = 0; j < vblCounter - 1; ++j) {
                pt = new POINT2(pLinePoints[j]);
                pt2 = new POINT2(pLinePoints[j + 1]);
                if (pt.x < pt2.x) {
                    pt.x += arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale());
                    pt.y -= arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale());
                    pt2.x -= arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale());
                    pt2.y -= arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale());
                    pt2.style = 5;
                } else {
                    pt.x -= arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale());
                    pt.y -= arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale());
                    pt2.x += arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale());
                    pt2.y -= arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale());
                    pt2.style = 5;
                }
                pts.add(pt);
                pts.add(pt2);
            }
            for (j = 0; j < pts.size(); ++j) {
                pLinePoints[j] = (POINT2)pts.get(j);
                ++counter;
            }
            for (j = counter; j < pLinePoints.length; ++j) {
                pLinePoints[j] = new POINT2(pLinePoints[counter - 1]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetOverheadWire", new RendererException("GetOverheadWire", exc));
        }
        return counter;
    }

    private static ArrayList<POINT2> GetLineArray2Double(TGLight tg, POINT2[] pLinePoints, int vblCounter, int vblSaveCounter, ArrayList<Shape2> shapes, Rectangle2D clipBounds, IPointConversion converter) {
        ArrayList<POINT2> points = new ArrayList<POINT2>();
        try {
            int lineType = tg.get_LineType();
            String client = CELineArray.getClient();
            if (pLinePoints == null || pLinePoints.length < 2) {
                return null;
            }
            Object segments = null;
            double dMRR = 0.0;
            int n = 0;
            int bolVertical = 0;
            double dExtendLength = 0.0;
            double dWidth = 0.0;
            int nQuadrant = 0;
            int lLinestyle = 0;
            int pointCounter = 0;
            ref<double[]> offsetX = new ref<double[]>();
            ref<double[]> offsetY = new ref<double[]>();
            double b = 0.0;
            double b1 = 0.0;
            double dRadius = 0.0;
            double d1 = 0.0;
            double d = 0.0;
            ref<double[]> m = new ref<double[]>();
            int direction = 0;
            int nCounter = 0;
            int j = 0;
            int k = 0;
            int middleSegment = -1;
            double dMBR = lineutility.MBRDistance(pLinePoints, vblSaveCounter);
            POINT2 pt0 = new POINT2(pLinePoints[0]);
            POINT2 pt1 = new POINT2(pLinePoints[1]);
            POINT2 pt2 = new POINT2(pLinePoints[1]);
            POINT2 pt3 = new POINT2(pLinePoints[0]);
            POINT2 pt4 = new POINT2(pLinePoints[0]);
            POINT2 pt5 = new POINT2(pLinePoints[0]);
            POINT2 pt6 = new POINT2(pLinePoints[0]);
            POINT2 pt7 = new POINT2(pLinePoints[0]);
            POINT2 pt8 = new POINT2(pLinePoints[0]);
            POINT2 ptYIntercept = new POINT2(pLinePoints[0]);
            POINT2 ptYIntercept1 = new POINT2(pLinePoints[0]);
            POINT2 ptCenter = new POINT2(pLinePoints[0]);
            POINT2[] pArrowPoints = new POINT2[3];
            POINT2[] arcPts = new POINT2[26];
            POINT2[] circlePoints = new POINT2[100];
            POINT2[] pts = null;
            POINT2[] pts2 = null;
            POINT2 midpt = new POINT2(pLinePoints[0]);
            POINT2 midpt1 = new POINT2(pLinePoints[0]);
            POINT2[] pOriginalLinePoints = null;
            Object pUpperLinePoints = null;
            Object pLowerLinePoints = null;
            Object pUpperLowerLinePoints = null;
            POINT2 calcPoint0 = new POINT2();
            POINT2 calcPoint1 = new POINT2();
            POINT2 calcPoint2 = new POINT2();
            POINT2 calcPoint3 = new POINT2();
            POINT2 calcPoint4 = new POINT2();
            POINT2 ptTemp = new POINT2(pLinePoints[0]);
            int acCounter = 0;
            POINT2[] acPoints = new POINT2[6];
            int lFlotCount = 0;
            if (vblCounter > 2) {
                pt2 = new POINT2(pLinePoints[2]);
            }
            pt0.style = 0;
            pt1.style = 0;
            pt2.style = 0;
            ArrayList xPoints = null;
            pOriginalLinePoints = new POINT2[vblSaveCounter];
            for (j = 0; j < vblSaveCounter; ++j) {
                pOriginalLinePoints[j] = new POINT2(pLinePoints[j]);
            }
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            switch (lineType) {
                case 23200000: {
                    acCounter = arraysupport.getOverheadWire(tg, pLinePoints, vblSaveCounter);
                    break;
                }
                case 22121000: 
                case 231100000: {
                    acCounter = pLinePoints.length;
                    break;
                }
                case 322510000: {
                    acCounter = vblCounter = arraysupport.GetReefPoints(pLinePoints, arraysupport.getScaledSize(40.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 32530000: {
                    acCounter = vblCounter = arraysupport.GetRestrictedAreaPoints(pLinePoints, arraysupport.getScaledSize(15.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 32550000: {
                    dMBR = lineutility.MBRDistance(pLinePoints, vblSaveCounter);
                    d = 20.0 * DPIScaleFactor;
                    if (dMBR < 60.0 * DPIScaleFactor) {
                        d = dMBR / 4.0;
                    }
                    if (d < 5.0 * DPIScaleFactor) {
                        d = 5.0 * DPIScaleFactor;
                    }
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pLinePoints[j].style = 1;
                    }
                    pLinePoints[vblSaveCounter - 1].style = 5;
                    pt0 = lineutility.CalcCenterPointDouble(pLinePoints, vblSaveCounter - 1);
                    lineutility.CalcCircleDouble(pt0, d, 26, arcPts, 0);
                    for (j = vblSaveCounter; j < vblSaveCounter + 26; ++j) {
                        pLinePoints[j] = new POINT2(arcPts[j - vblSaveCounter]);
                    }
                    pLinePoints[j - 1].style = 5;
                    d = dMBR < 50.0 * DPIScaleFactor ? (d *= 0.6) : 12.0 * DPIScaleFactor;
                    pt1 = new POINT2(pt0);
                    pt1.y -= d;
                    pt1.style = 0;
                    pt2 = new POINT2(pt1);
                    pt2.y += d;
                    pt2.style = 5;
                    pt3 = new POINT2(pt2);
                    pt3.y += d / 4.0 + (double)tg.get_LineThickness();
                    pt3.style = 0;
                    pt4 = new POINT2(pt3);
                    pt4.y += d / 4.0;
                    pLinePoints[j++] = new POINT2(pt1);
                    pLinePoints[j++] = new POINT2(pt2);
                    pLinePoints[j++] = new POINT2(pt3);
                    pt4.style = 5;
                    pLinePoints[j++] = new POINT2(pt4);
                    acCounter = vblCounter = j;
                    break;
                }
                case 32680000: {
                    acCounter = vblCounter = arraysupport.GetPipePoints(pLinePoints, arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 32231500: {
                    n = arraysupport.GetInsideOutsideDouble2(pLinePoints[0], pLinePoints[1], pLinePoints, vblSaveCounter, 0, lineType);
                    nQuadrant = lineutility.GetQuadrantDouble(pLinePoints[0], pLinePoints[1]);
                    block89 : switch (nQuadrant) {
                        case 4: {
                            switch (n) {
                                case 1: 
                                case 2: {
                                    break block89;
                                }
                                case 0: 
                                case 3: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block89;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (n) {
                                case 1: 
                                case 3: {
                                    break block89;
                                }
                                case 0: 
                                case 2: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block89;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (n) {
                                case 1: 
                                case 2: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block89;
                                }
                                case 0: 
                                case 3: {
                                    break block89;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (n) {
                                case 1: 
                                case 3: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block89;
                                }
                                case 0: 
                                case 2: {
                                    break block89;
                                }
                            }
                            break;
                        }
                    }
                    acCounter = lFlotCount = arraysupport.GetAnchorageDouble(pLinePoints, arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 32231400: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    acCounter = arraysupport.GetAnchorageDouble(pLinePoints, arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 32153000: {
                    int xCount = countsupport.GetXPointsCount(pOriginalLinePoints, arraysupport.getScaledSize(30.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    POINT2[] xPoints2 = new POINT2[xCount];
                    int lvoCount = countsupport.GetLVOCount(pOriginalLinePoints, arraysupport.getScaledSize(30.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    POINT2[] lvoPoints = new POINT2[lvoCount];
                    xCount = arraysupport.GetXPoints(pOriginalLinePoints, xPoints2, arraysupport.getScaledSize(30.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    lvoCount = arraysupport.GetLVOPoints(pOriginalLinePoints, lvoPoints, arraysupport.getScaledSize(4.0, tg.get_LineThickness(), tg.get_patternScale()), arraysupport.getScaledSize(30.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    for (k = 0; k < xCount; ++k) {
                        pLinePoints[k] = new POINT2(xPoints2[k]);
                    }
                    if (xCount > 0) {
                        pLinePoints[xCount - 1].style = 5;
                    }
                    for (k = 0; k < lvoCount; ++k) {
                        pLinePoints[xCount + k] = new POINT2(lvoPoints[k]);
                    }
                    acCounter = xCount + lvoCount;
                    break;
                }
                case 32152000: {
                    if (pLinePoints[0].x < pLinePoints[1].x) {
                        lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    }
                    acCounter = lFlotCount = flot.GetFlotDouble(pLinePoints, arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 32151000: {
                    acCounter = arraysupport.GetLVOPoints(pOriginalLinePoints, pLinePoints, arraysupport.getScaledSize(4.0, tg.get_LineThickness(), tg.get_patternScale()), arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 31740000: {
                    acCounter = vblCounter = arraysupport.GetIcingPointsDouble(pLinePoints, arraysupport.getScaledSize(15.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 31720000: {
                    n = arraysupport.GetInsideOutsideDouble2(pLinePoints[0], pLinePoints[1], pLinePoints, vblSaveCounter, 0, lineType);
                    nQuadrant = lineutility.GetQuadrantDouble(pLinePoints[0], pLinePoints[1]);
                    block111 : switch (nQuadrant) {
                        case 4: {
                            switch (n) {
                                case 0: 
                                case 3: {
                                    break block111;
                                }
                                case 1: 
                                case 2: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block111;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (n) {
                                case 0: 
                                case 2: {
                                    break block111;
                                }
                                case 1: 
                                case 3: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block111;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (n) {
                                case 0: 
                                case 3: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block111;
                                }
                                case 1: 
                                case 2: {
                                    break block111;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (n) {
                                case 0: 
                                case 2: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block111;
                                }
                                case 1: 
                                case 3: {
                                    break block111;
                                }
                            }
                            break;
                        }
                    }
                    acCounter = lFlotCount = flot.GetFlotDouble(pLinePoints, arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 31148000: {
                    acCounter = arraysupport.GetITDPointsDouble(pLinePoints, arraysupport.getScaledSize(15.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 31147000: {
                    acCounter = arraysupport.GetConvergencePointsDouble(pLinePoints, arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 31142000: {
                    acCounter = vblCounter = arraysupport.GetRidgePointsDouble(tg, pLinePoints, vblSaveCounter);
                    break;
                }
                case 31141000: 
                case 31144000: 
                case 31145000: 
                case 45110402: {
                    acCounter = vblCounter = arraysupport.GetSquallDouble(pLinePoints, arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale()), 6, arraysupport.getScaledSize(30.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 32610000: {
                    acCounter = vblCounter = arraysupport.GetSquallDouble(pLinePoints, arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale()), 6, arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 31143000: {
                    acCounter = vblCounter = arraysupport.GetSevereSquall(pLinePoints, arraysupport.getScaledSize(30.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                case 31134000: 
                case 31134100: 
                case 31134200: 
                case 31134300: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    acCounter = vblCounter = flot.GetSFPointsDouble(tg, pLinePoints, vblSaveCounter);
                    break;
                }
                case 31133200: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    acCounter = vblCounter = flot.GetOFYPointsDouble(tg, pLinePoints, vblSaveCounter);
                    break;
                }
                case 31133000: 
                case 31133100: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    vblCounter = flot.GetOccludedPointsDouble(tg, pLinePoints, vblSaveCounter);
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pLinePoints[vblCounter + j] = pOriginalLinePoints[j];
                    }
                    acCounter = vblCounter += vblSaveCounter;
                    break;
                }
                case 31132000: 
                case 31132100: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    lFlotCount = flot.GetFlot2Double(tg, pLinePoints, vblSaveCounter);
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pLinePoints[vblCounter - vblSaveCounter + j] = pOriginalLinePoints[j];
                    }
                    acCounter = lFlotCount + vblSaveCounter;
                    break;
                }
                case 31132200: 
                case 31132300: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    acCounter = lFlotCount = flot.GetFlot2Double(tg, pLinePoints, vblSaveCounter);
                    break;
                }
                case 31131200: 
                case 31131300: {
                    acCounter = vblCounter = arraysupport.GetATWallPointsDouble(tg, pLinePoints, vblSaveCounter);
                    break;
                }
                case 31131000: 
                case 31131100: {
                    vblCounter = arraysupport.GetATWallPointsDouble(tg, pLinePoints, vblSaveCounter);
                    pLinePoints[vblCounter - 1].style = 5;
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pLinePoints[vblCounter + j] = pOriginalLinePoints[j];
                    }
                    pLinePoints[(vblCounter += vblSaveCounter) - 1].style = 5;
                    acCounter = vblCounter;
                    break;
                }
                case 22524000: 
                case 23191000: 
                case 23192000: 
                case 23193000: {
                    lineutility.LineRelativeToLine(pLinePoints[0], pLinePoints[1], pLinePoints[2], pt0, pt1);
                    d = lineutility.CalcDistanceDouble(pLinePoints[0], pt0);
                    pt4 = lineutility.ExtendLineDouble(pt0, pLinePoints[0], d);
                    lineutility.LineRelativeToLine(pLinePoints[0], pLinePoints[1], pt4, pt2, pt3);
                    pLinePoints[0] = new POINT2(pt0);
                    pLinePoints[1] = new POINT2(pt1);
                    pLinePoints[2] = new POINT2(pt3);
                    pLinePoints[3] = new POINT2(pt2);
                    switch (lineType) {
                        case 22524000: 
                        case 23193000: {
                            pLinePoints[0].style = 0;
                            pLinePoints[1].style = 5;
                            pLinePoints[2].style = 0;
                            break;
                        }
                        case 23191000: {
                            pLinePoints[0].style = 1;
                            pLinePoints[1].style = 5;
                            pLinePoints[2].style = 1;
                            break;
                        }
                        case 23192000: {
                            pLinePoints[1].style = 5;
                            if (pt0.x <= pt1.x) {
                                if (pLinePoints[1].y <= pLinePoints[2].y) {
                                    pLinePoints[0].style = 0;
                                    pLinePoints[2].style = 1;
                                    break;
                                }
                                pLinePoints[0].style = 1;
                                pLinePoints[2].style = 0;
                                break;
                            }
                            if (pLinePoints[1].y >= pLinePoints[2].y) {
                                pLinePoints[0].style = 0;
                                pLinePoints[2].style = 1;
                                break;
                            }
                            pLinePoints[0].style = 1;
                            pLinePoints[2].style = 0;
                            break;
                        }
                    }
                    acCounter = 4;
                    break;
                }
                case 23224000: {
                    lineutility.LineRelativeToLine(pLinePoints[0], pLinePoints[1], pLinePoints[2], pt0, pt1);
                    pLinePoints[0].style = 1;
                    pLinePoints[1].style = 5;
                    pLinePoints[2] = new POINT2(pt0);
                    pLinePoints[2].style = 1;
                    pLinePoints[3] = new POINT2(pt1);
                    pLinePoints[3].style = 5;
                    acCounter = 4;
                    break;
                }
                case 23194000: {
                    pts = new POINT2[4];
                    for (j = 0; j < 4; ++j) {
                        pts[j] = new POINT2(pLinePoints[j]);
                    }
                    dRadius = lineutility.CalcDistanceDouble(pLinePoints[0], pLinePoints[1]);
                    d = lineutility.CalcDistanceToLineDouble(pLinePoints[0], pLinePoints[1], pLinePoints[2]);
                    pLinePoints[0] = lineutility.ExtendTrueLinePerpDouble(pts[0], pts[1], pts[1], d, 0);
                    pLinePoints[1] = lineutility.ExtendTrueLinePerpDouble(pts[0], pts[1], pts[0], d, 5);
                    pLinePoints[2] = lineutility.ExtendTrueLinePerpDouble(pts[0], pts[1], pts[1], -d, 0);
                    pLinePoints[3] = lineutility.ExtendTrueLinePerpDouble(pts[0], pts[1], pts[0], -d, 5);
                    midpt = lineutility.MidPointDouble(pts[0], pts[1], 0);
                    midpt = lineutility.ExtendLineDouble(pts[0], midpt, d);
                    pLinePoints[4] = lineutility.ExtendAngledLine(pts[0], pts[1], midpt, 105.0, dRadius / 2.0);
                    pLinePoints[5] = lineutility.ExtendAngledLine(pts[0], pts[1], midpt, -75.0, dRadius / 2.0);
                    pLinePoints[5].style = 5;
                    midpt = lineutility.MidPointDouble(pts[0], pts[1], 0);
                    midpt = lineutility.ExtendLineDouble(pts[1], midpt, d);
                    pLinePoints[6] = lineutility.ExtendAngledLine(pts[0], pts[1], midpt, 105.0, dRadius / 2.0);
                    pLinePoints[7] = lineutility.ExtendAngledLine(pts[0], pts[1], midpt, -75.0, dRadius / 2.0);
                    pLinePoints[7].style = 5;
                    acCounter = 8;
                    break;
                }
                case 221311000: {
                    arraysupport.AirfieldCenterFeature(pLinePoints, vblCounter);
                    acCounter = vblCounter;
                    break;
                }
                case 22431100: 
                case 22528000: 
                case 24220000: {
                    for (j = 0; j < vblCounter; ++j) {
                        pLinePoints[j].style = 1;
                    }
                    acCounter = vblCounter;
                    break;
                }
                case 270801: {
                    arraysupport.FillPoints(pLinePoints, vblCounter, points);
                    xPoints = lineutility.LineOfXPoints(tg, pOriginalLinePoints);
                    for (j = 0; j < xPoints.size(); ++j) {
                        points.add((POINT2)xPoints.get(j));
                    }
                    acCounter = points.size();
                    break;
                }
                case 23340000: {
                    bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
                    if (bolVertical == 0) {
                        direction = pt0.y > pt1.y ? 0 : 1;
                    }
                    if (bolVertical != 0 && ((double[])m.value)[0] <= 1.0) {
                        direction = pt0.x < pt1.x ? 3 : 2;
                    }
                    if (bolVertical != 0 && ((double[])m.value)[0] > 1.0) {
                        if (pt0.x < pt1.x && pt0.y > pt1.y) {
                            direction = 1;
                        }
                        if (pt0.x < pt1.x && pt0.y < pt1.y) {
                            direction = 0;
                        }
                        if (pt0.x > pt1.x && pt0.y > pt1.y) {
                            direction = 1;
                        }
                        if (pt0.x > pt1.x && pt0.y < pt1.y) {
                            direction = 0;
                        }
                    }
                    if (dMBR / 20.0 > 100.0 * DPIScaleFactor) {
                        dMBR = 2000.0 * DPIScaleFactor;
                    }
                    if (dMBR / 20.0 < 2.5 * DPIScaleFactor) {
                        dMBR = 50.0 * DPIScaleFactor;
                    }
                    if (dMBR < 250.0 * DPIScaleFactor) {
                        dMBR = 250.0 * DPIScaleFactor;
                    }
                    if (dMBR > 500.0 * DPIScaleFactor) {
                        dMBR = 500.0 * DPIScaleFactor;
                    }
                    pLinePoints[0] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, direction, dMBR / 20.0);
                    pLinePoints[1] = new POINT2(pt0);
                    pLinePoints[2] = new POINT2(pt1);
                    pLinePoints[3] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, direction, dMBR / 20.0);
                    acCounter = 4;
                    break;
                }
                case 211400000: 
                case 212500000: 
                case 212600000: {
                    arraysupport.GetIsolatePointsDouble(pLinePoints, lineType, converter);
                    acCounter = 50;
                    break;
                }
                case 211600000: {
                    arraysupport.GetIsolatePointsDouble(pLinePoints, lineType, converter);
                    acCounter = 32;
                    break;
                }
                case 211900000: {
                    arraysupport.GetIsolatePointsDouble(pLinePoints, lineType, converter);
                    acCounter = 75;
                    break;
                }
                case 212100000: {
                    arraysupport.GetIsolatePointsDouble(pLinePoints, lineType, converter);
                    acCounter = 29;
                    break;
                }
                case 23173000: {
                    POINT2 swapPt = pLinePoints[0];
                    pLinePoints[0] = pLinePoints[1];
                    pLinePoints[1] = swapPt;
                    arraysupport.GetIsolatePointsDouble(pLinePoints, lineType, null);
                    acCounter = 29;
                    break;
                }
                case 22134000: 
                case 22624000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23350000: 
                case 1322134000: {
                    acCounter = arraysupport.GetZONEPointsDouble2(tg, pLinePoints, vblSaveCounter);
                    break;
                }
                case 23112000: 
                case 23134000: {
                    acCounter = arraysupport.GetATWallPointsDouble2(tg, pLinePoints, vblSaveCounter);
                    break;
                }
                case 22221000: 
                case 22222000: 
                case 22223000: 
                case 22224000: 
                case 22225000: 
                case 25170400: 
                case 25170600: {
                    boolean bolSegmentAC = false;
                    bolSegmentAC = true;
                    dMRR = dACP;
                    lineutility.InitializePOINT2Array(acPoints);
                    lineutility.InitializePOINT2Array(arcPts);
                    acCounter = 0;
                    if (!bolSegmentAC) {
                        for (j = 0; j < vblSaveCounter; ++j) {
                            if (pOriginalLinePoints[j].style > 0) continue;
                            pOriginalLinePoints[j].style = 1;
                        }
                    }
                    for (j = 0; j < vblSaveCounter - 1; ++j) {
                        dMBR = pOriginalLinePoints[j].style;
                        acPoints[0] = new POINT2(pOriginalLinePoints[j]);
                        acPoints[1] = new POINT2(pOriginalLinePoints[j + 1]);
                        lineutility.GetSAAFRSegment(acPoints, lineType, dMBR);
                        for (k = 0; k < 6; ++k) {
                            pLinePoints[acCounter] = new POINT2(acPoints[k]);
                            ++acCounter;
                        }
                    }
                    int currentCircleSize = 0;
                    if (!bolSegmentAC) {
                        for (j = 0; j < vblSaveCounter - 1; ++j) {
                            currentCircleSize = pOriginalLinePoints[j].style;
                            arcPts[0] = new POINT2(pOriginalLinePoints[j]);
                            dMBR = currentCircleSize;
                            lineutility.CalcCircleDouble(arcPts[0], dMBR, 26, arcPts, 0);
                            arcPts[25].style = 5;
                            for (k = 0; k < 26; ++k) {
                                pLinePoints[acCounter] = new POINT2(arcPts[k]);
                                ++acCounter;
                            }
                            arcPts[0] = new POINT2(pOriginalLinePoints[j + 1]);
                            dMBR = currentCircleSize;
                            lineutility.CalcCircleDouble(arcPts[0], dMBR, 26, arcPts, 0);
                            arcPts[25].style = 5;
                            for (k = 0; k < 26; ++k) {
                                pLinePoints[acCounter] = new POINT2(arcPts[k]);
                                ++acCounter;
                            }
                        }
                    } else {
                        int lastCircleSize = 0;
                        POINT2 lastCirclePoint = null;
                        for (j = 0; j < vblSaveCounter; ++j) {
                            currentCircleSize = pOriginalLinePoints[j].style;
                            if (j == 0) {
                                lastCircleSize = currentCircleSize;
                                lastCirclePoint = pOriginalLinePoints[j];
                                continue;
                            }
                            if (currentCircleSize < 0) continue;
                            arcPts[0] = new POINT2(pOriginalLinePoints[j]);
                            dMBR = lastCircleSize;
                            lineutility.CalcCircleDouble(arcPts[0], dMBR, 26, arcPts, 0);
                            arcPts[25].style = 5;
                            for (k = 0; k < 26; ++k) {
                                pLinePoints[acCounter] = new POINT2(arcPts[k]);
                                ++acCounter;
                            }
                            arcPts[0] = new POINT2(lastCirclePoint);
                            lineutility.CalcCircleDouble(arcPts[0], dMBR, 26, arcPts, 0);
                            arcPts[25].style = 5;
                            for (k = 0; k < 26; ++k) {
                                pLinePoints[acCounter] = new POINT2(arcPts[k]);
                                ++acCounter;
                            }
                            lastCircleSize = currentCircleSize;
                            lastCirclePoint = pOriginalLinePoints[j];
                        }
                    }
                    break;
                }
                case 220101: 
                case 220104: 
                case 220107: 
                case 220108: 
                case 23164000: 
                case 23180000: 
                case 26400000: 
                case 26410000: 
                case 26420000: 
                case 26430000: 
                case 26440000: {
                    acCounter = vblCounter;
                    break;
                }
                case 23410000: {
                    lineutility.InitializePOINT2Array(circlePoints);
                    pt3 = new POINT2(pLinePoints[3]);
                    if (converter == null) {
                        dRadius = lineutility.CalcDistanceDouble(pt0, pt1);
                        lineutility.CalcCircleDouble(pt0, dRadius, 100, circlePoints, 0);
                    } else {
                        lineutility.CalcCircleDouble2(pt0, pt1, 100, circlePoints, converter);
                    }
                    for (j = 0; j < 100; ++j) {
                        pLinePoints[j] = new POINT2(circlePoints[j]);
                    }
                    pLinePoints[99].style = 5;
                    if (converter == null) {
                        dRadius = lineutility.CalcDistanceDouble(pt0, pt2);
                        lineutility.CalcCircleDouble(pt0, dRadius, 100, circlePoints, 0);
                    } else {
                        lineutility.CalcCircleDouble2(pt0, pt2, 100, circlePoints, converter);
                    }
                    for (j = 0; j < 100; ++j) {
                        pLinePoints[100 + j] = new POINT2(circlePoints[j]);
                    }
                    pLinePoints[199].style = 5;
                    if (vblSaveCounter == 4) {
                        if (converter == null) {
                            dRadius = lineutility.CalcDistanceDouble(pt0, pt3);
                            lineutility.CalcCircleDouble(pt0, dRadius, 100, circlePoints, 0);
                        } else {
                            lineutility.CalcCircleDouble2(pt0, pt3, 100, circlePoints, converter);
                        }
                        for (j = 0; j < 100; ++j) {
                            pLinePoints[200 + j] = new POINT2(circlePoints[j]);
                        }
                    }
                    acCounter = vblCounter;
                    break;
                }
                case 25211000: {
                    if (dMBR < 150.0 * DPIScaleFactor) {
                        dMBR = 150.0 * DPIScaleFactor;
                    }
                    if (dMBR > 500.0 * DPIScaleFactor) {
                        dMBR = 500.0 * DPIScaleFactor;
                    }
                    dWidth = dMBR / 25.0;
                    pt0 = new POINT2(pLinePoints[0]);
                    pt1 = new POINT2(pLinePoints[1]);
                    bolVertical = lineutility.CalcTrueSlopeDouble(pt1, pt0, m);
                    pt0 = lineutility.ExtendLine2Double(pt1, pt0, -dWidth * 3.0, 0);
                    if (((double[])m.value)[0] < 1.0) {
                        pLinePoints[0] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 2, dWidth);
                        pLinePoints[1] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 2, dWidth);
                        pLinePoints[2] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 3, dWidth);
                        pLinePoints[3] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 3, dWidth);
                    } else {
                        pLinePoints[0] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 0, dWidth);
                        pLinePoints[1] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 0, dWidth);
                        pLinePoints[2] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 1, dWidth);
                        pLinePoints[3] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 1, dWidth);
                    }
                    pt2 = lineutility.ExtendLineDouble(pt1, pt0, dWidth * 3.0);
                    lineutility.GetArrowHead4Double(pt0, pt2, (int)(dWidth * 3.0), (int)(dWidth * 3.0), pArrowPoints, 0);
                    d = lineutility.CalcDistanceDouble(pLinePoints[0], pArrowPoints[0]);
                    d1 = lineutility.CalcDistanceDouble(pLinePoints[3], pArrowPoints[0]);
                    pLinePoints[3].style = 5;
                    if (d < d1) {
                        pLinePoints[4] = new POINT2(pLinePoints[0]);
                        pLinePoints[4].style = 0;
                        pLinePoints[5] = new POINT2(pArrowPoints[0]);
                        pLinePoints[5].style = 0;
                        pLinePoints[6] = new POINT2(pArrowPoints[1]);
                        pLinePoints[6].style = 0;
                        pLinePoints[7] = new POINT2(pArrowPoints[2]);
                        pLinePoints[7].style = 0;
                        pLinePoints[8] = new POINT2(pLinePoints[3]);
                    } else {
                        pLinePoints[4] = pLinePoints[3];
                        pLinePoints[4].style = 0;
                        pLinePoints[5] = pArrowPoints[0];
                        pLinePoints[5].style = 0;
                        pLinePoints[6] = pArrowPoints[1];
                        pLinePoints[6].style = 0;
                        pLinePoints[7] = pArrowPoints[2];
                        pLinePoints[7].style = 0;
                        pLinePoints[8] = pLinePoints[0];
                    }
                    acCounter = 9;
                    break;
                }
                case 25212000: {
                    if (dMBR < 150.0 * DPIScaleFactor) {
                        dMBR = 150.0 * DPIScaleFactor;
                    }
                    if (dMBR > 500.0 * DPIScaleFactor) {
                        dMBR = 500.0 * DPIScaleFactor;
                    }
                    dWidth = dMBR / 25.0;
                    pt0 = new POINT2(pLinePoints[0]);
                    pt1 = new POINT2(pLinePoints[1]);
                    pt2 = lineutility.ExtendAlongLineDouble(pt0, pt1, dWidth * 2.0);
                    lineutility.GetArrowHead4Double(pt0, pt2, (int)dWidth * 2, (int)dWidth * 2, pArrowPoints, 0);
                    bolVertical = lineutility.CalcTrueSlopeDouble(pt1, pt2, m);
                    if (((double[])m.value)[0] < 1.0) {
                        pLinePoints[0] = lineutility.ExtendDirectedLine(pt2, pt1, pt2, 2, dWidth);
                        pLinePoints[1] = lineutility.ExtendDirectedLine(pt2, pt1, pt1, 2, dWidth);
                        pLinePoints[2] = lineutility.ExtendDirectedLine(pt2, pt1, pt1, 3, dWidth);
                        pLinePoints[3] = lineutility.ExtendDirectedLine(pt2, pt1, pt2, 3, dWidth);
                    } else {
                        pLinePoints[0] = lineutility.ExtendDirectedLine(pt2, pt1, pt2, 0, dWidth);
                        pLinePoints[1] = lineutility.ExtendDirectedLine(pt2, pt1, pt1, 0, dWidth);
                        pLinePoints[2] = lineutility.ExtendDirectedLine(pt2, pt1, pt1, 1, dWidth);
                        pLinePoints[3] = lineutility.ExtendDirectedLine(pt2, pt1, pt2, 1, dWidth);
                    }
                    pLinePoints[4] = new POINT2(pLinePoints[0]);
                    pLinePoints[5] = new POINT2(pt2);
                    pLinePoints[5].style = 0;
                    pLinePoints[6] = new POINT2(pArrowPoints[1]);
                    pLinePoints[7] = new POINT2(pArrowPoints[0]);
                    pLinePoints[8] = new POINT2(pArrowPoints[2]);
                    pLinePoints[8].style = 0;
                    pLinePoints[9] = new POINT2(pArrowPoints[1]);
                    acCounter = 10;
                    break;
                }
                case 25330301: 
                case 25330302: 
                case 25330303: 
                case 25330401: 
                case 25330402: 
                case 25330403: 
                case 25330501: 
                case 25330502: {
                    nCounter = vblSaveCounter;
                    pLinePoints[vblSaveCounter - 1].style = 5;
                    for (j = 0; j < vblSaveCounter - 1; ++j) {
                        d = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                        if (d < 20.0) continue;
                        pt0 = new POINT2(pLinePoints[j]);
                        pt1 = new POINT2(pLinePoints[j + 1]);
                        pt2 = lineutility.ExtendLine2Double(pLinePoints[j], pLinePoints[j + 1], -3.0 * d / 4.0, 0);
                        pt3 = lineutility.ExtendLine2Double(pLinePoints[j], pLinePoints[j + 1], -1.0 * d / 4.0, 5);
                        double distFromLine = 10.0 * DPIScaleFactor;
                        direction = arraysupport.SupplyRouteArrowSide(pLinePoints[j], pLinePoints[j + 1]);
                        pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, direction, distFromLine);
                        pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, direction, distFromLine);
                        pLinePoints[nCounter] = new POINT2(pt2);
                        pLinePoints[++nCounter] = new POINT2(pt3);
                        ++nCounter;
                        d = distFromLine;
                        if (dMBR / 20.0 < 2.5 * DPIScaleFactor) {
                            d = 5.0 * DPIScaleFactor;
                        }
                        lineutility.GetArrowHead4Double(pt2, pt3, (int)d, (int)d, pArrowPoints, 0);
                        for (k = 0; k < 3; ++k) {
                            pLinePoints[nCounter] = new POINT2(pArrowPoints[k]);
                            ++nCounter;
                        }
                        if (lineType == 25330303 || lineType == 25330403 || lineType == 25330502) {
                            lineutility.GetArrowHead4Double(pt3, pt2, (int)d, (int)d, pArrowPoints, 0);
                            for (k = 0; k < 3; ++k) {
                                pLinePoints[nCounter] = new POINT2(pArrowPoints[k]);
                                ++nCounter;
                            }
                        }
                        if (lineType != 25330302 && lineType != 25330402) continue;
                        distFromLine = 15.0 * DPIScaleFactor;
                        pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, direction, distFromLine);
                        pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, direction, distFromLine);
                        pLinePoints[nCounter] = new POINT2(pt2);
                        pLinePoints[++nCounter] = new POINT2(pt3);
                        ++nCounter;
                        lineutility.GetArrowHead4Double(pt3, pt2, (int)d, (int)d, pArrowPoints, 0);
                        for (k = 0; k < 3; ++k) {
                            pLinePoints[nCounter] = new POINT2(pArrowPoints[k]);
                            ++nCounter;
                        }
                    }
                    acCounter = nCounter;
                    break;
                }
                case 23225000: {
                    double dist1;
                    double dist0;
                    lineutility.LineRelativeToLine(pLinePoints[0], pLinePoints[1], pLinePoints[2], pt4, pt5);
                    pLinePoints[2] = new POINT2(pt5);
                    pLinePoints[3] = new POINT2(pt4);
                    for (j = 0; j < vblCounter; ++j) {
                        pLinePoints[j].style = 1;
                    }
                    pt0 = lineutility.MidPointDouble(pLinePoints[0], pLinePoints[1], 0);
                    pt1 = lineutility.MidPointDouble(pLinePoints[2], pLinePoints[3], 0);
                    POINT2[] savepoints = null;
                    Boolean drawJaggies = true;
                    if (clipBounds != null) {
                        POINT2 lr;
                        POINT2 ul = new POINT2(clipBounds.getMinX(), clipBounds.getMinY());
                        savepoints = lineutility.BoundOneSegment(pt0, pt1, ul, lr = new POINT2(clipBounds.getMaxX(), clipBounds.getMaxY()));
                        if (savepoints != null && savepoints.length > 1) {
                            pt0 = savepoints[0];
                            pt1 = savepoints[1];
                        } else {
                            savepoints = new POINT2[]{new POINT2(pt0), new POINT2(pt1)};
                            drawJaggies = false;
                        }
                    }
                    if ((dist0 = lineutility.CalcDistanceDouble(midpt = lineutility.MidPointDouble(pt0, pt1, 0), pt0)) > (dist1 = lineutility.CalcDistanceDouble(midpt, pt1))) {
                        lineutility.LineRelativeToLine(pLinePoints[2], pLinePoints[3], pt0, pt4, pt5);
                        pLinePoints[0] = new POINT2(pt5.x, pt5.y, 1);
                        pLinePoints[1] = new POINT2(pt4.x, pt4.y, 1);
                    } else {
                        lineutility.LineRelativeToLine(pLinePoints[0], pLinePoints[1], pt1, pt4, pt5);
                        pLinePoints[2] = new POINT2(pt5.x, pt5.y, 1);
                        pLinePoints[3] = new POINT2(pt4.x, pt4.y, 1);
                    }
                    double spikeLength = arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale());
                    pt2 = lineutility.ExtendLine2Double(pLinePoints[0], pt0, -spikeLength, 0);
                    pt3 = lineutility.ExtendLine2Double(pLinePoints[3], pt1, -spikeLength, 0);
                    pt4 = lineutility.ExtendLine2Double(pLinePoints[0], pt0, spikeLength, 0);
                    pt5 = lineutility.ExtendLine2Double(pLinePoints[3], pt1, spikeLength, 0);
                    dWidth = lineutility.CalcDistanceDouble(pt0, pt1);
                    pointCounter = 4;
                    n = 1;
                    pLinePoints[pointCounter] = new POINT2(pt0);
                    pLinePoints[pointCounter].style = 0;
                    ++pointCounter;
                    if (drawJaggies.booleanValue()) {
                        while (dExtendLength < dWidth - spikeLength) {
                            dExtendLength = (double)n * spikeLength / 2.0;
                            pLinePoints[pointCounter] = lineutility.ExtendLine2Double(pt2, pt3, dExtendLength - dWidth, 0);
                            dExtendLength = (double)(++n) * spikeLength / 2.0;
                            pLinePoints[++pointCounter] = lineutility.ExtendLine2Double(pt4, pt5, dExtendLength - dWidth, 0);
                            if (++pointCounter >= pLinePoints.length - 1) break;
                            ++n;
                        }
                    }
                    pLinePoints[pointCounter] = new POINT2(pt1);
                    pLinePoints[pointCounter].style = 5;
                    acCounter = ++pointCounter;
                    break;
                }
                case 23131100: {
                    acCounter = lineutility.GetDitchSpikeDouble(tg, pLinePoints, vblSaveCounter, 0);
                    break;
                }
                case 23131200: {
                    pLinePoints[0].style = 9;
                    acCounter = lineutility.GetDitchSpikeDouble(tg, pLinePoints, vblSaveCounter, 0);
                    break;
                }
                case 23132000: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    pLinePoints[0].style = 9;
                    acCounter = lineutility.GetDitchSpikeDouble(tg, pLinePoints, vblSaveCounter, 0);
                    break;
                }
                case 22522210: {
                    if (dMBR / 30.0 > 100.0 * DPIScaleFactor) {
                        dMBR = 3000.0 * DPIScaleFactor;
                    }
                    if (dMBR / 30.0 < 2.5 * DPIScaleFactor) {
                        dMBR = 75.0 * DPIScaleFactor;
                    }
                    if (dMBR < 150.0 * DPIScaleFactor) {
                        dMBR = 150.0 * DPIScaleFactor;
                    }
                    if (dMBR > 500.0 * DPIScaleFactor) {
                        dMBR = 500.0 * DPIScaleFactor;
                    }
                    if ((d = lineutility.CalcDistanceDouble(pLinePoints[0], pLinePoints[1])) < dMBR / 40.0) {
                        pLinePoints[1] = lineutility.ExtendLineDouble(pLinePoints[0], pLinePoints[1], dMBR / 40.0 + 1.0);
                    }
                    pLinePoints[0] = lineutility.ExtendAlongLineDouble(pLinePoints[0], pLinePoints[1], dMBR / 40.0);
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    pt0 = new POINT2(pLinePoints[vblCounter - 12]);
                    pt1 = new POINT2(pLinePoints[vblCounter - 11]);
                    pt2 = lineutility.ExtendLineDouble(pt0, pt1, dMBR / 40.0);
                    lineutility.GetArrowHead4Double(pt0, pt1, (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[vblCounter - 10 + j] = new POINT2(pArrowPoints[j]);
                    }
                    lineutility.GetArrowHead4Double(pt0, pt2, (int)(dMBR / 13.33), (int)(dMBR / 13.33), pArrowPoints, 0);
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[vblCounter - 7 + j] = new POINT2(pArrowPoints[j]);
                    }
                    pLinePoints[vblCounter - 4] = new POINT2(pLinePoints[vblCounter - 10]);
                    pLinePoints[vblCounter - 4].style = 0;
                    pLinePoints[vblCounter - 3] = new POINT2(pLinePoints[vblCounter - 7]);
                    pLinePoints[vblCounter - 3].style = 5;
                    pLinePoints[vblCounter - 2] = new POINT2(pLinePoints[vblCounter - 8]);
                    pLinePoints[vblCounter - 2].style = 0;
                    pLinePoints[vblCounter - 1] = new POINT2(pLinePoints[vblCounter - 5]);
                    pLinePoints[vblCounter - 1].style = 5;
                    acCounter = vblCounter;
                    break;
                }
                case 23226000: 
                case 23227000: {
                    pt2 = lineutility.ExtendLineDouble(pLinePoints[vblCounter - 8], pLinePoints[vblCounter - 7], dMBR / 2.0);
                    pt3 = new POINT2(pLinePoints[vblCounter - 7]);
                    pt1 = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], dMBR / 2.0);
                    if (dMBR / 10.0 > 100.0 * DPIScaleFactor) {
                        dMBR = 1000.0 * DPIScaleFactor;
                    }
                    if (dMBR / 10.0 < 2.5 * DPIScaleFactor) {
                        dMBR = 25.0 * DPIScaleFactor;
                    }
                    if (dMBR > 250.0 * DPIScaleFactor) {
                        dMBR = 250.0 * DPIScaleFactor;
                    }
                    lineutility.GetArrowHead4Double(pt2, pt3, (int)dMBR / 10, (int)dMBR / 5, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 6 + k] = new POINT2(pArrowPoints[k]);
                    }
                    lineutility.GetArrowHead4Double(pt1, pt0, (int)dMBR / 10, (int)dMBR / 5, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 3 + k] = new POINT2(pArrowPoints[k]);
                    }
                    pLinePoints[vblSaveCounter - 1].style = 5;
                    acCounter = vblCounter;
                    break;
                }
                case 22522100: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    for (k = vblSaveCounter - 1; k > 0 && !((d += lineutility.CalcDistanceDouble(pLinePoints[k], pLinePoints[k - 1])) > 60.0); --k) {
                    }
                    if (d > 60.0) {
                        middleSegment = k;
                        pt2 = pLinePoints[middleSegment];
                        if (middleSegment >= 1) {
                            pt3 = pLinePoints[middleSegment - 1];
                        }
                    } else {
                        middleSegment = vblSaveCounter <= 3 ? 1 : 2;
                        pt2 = pLinePoints[middleSegment];
                        if (middleSegment >= 1) {
                            pt3 = pLinePoints[middleSegment - 1];
                        }
                    }
                    pt0 = new POINT2(pLinePoints[0]);
                    if (dMBR / 20.0 > 100.0 * DPIScaleFactor) {
                        dMBR = 2000.0 * DPIScaleFactor;
                    }
                    if (dMBR / 20.0 < 2.5 * DPIScaleFactor) {
                        dMBR = 50.0 * DPIScaleFactor;
                    }
                    if (dMBR < 150.0 * DPIScaleFactor) {
                        dMBR = 150.0 * DPIScaleFactor;
                    }
                    if (dMBR > 250.0 * DPIScaleFactor) {
                        dMBR = 250.0 * DPIScaleFactor;
                    }
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 11], pLinePoints[vblCounter - 10], (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[vblCounter - 9 + j] = new POINT2(pArrowPoints[j]);
                    }
                    pLinePoints[vblCounter - 6].x = (pLinePoints[vblCounter - 11].x + pLinePoints[vblCounter - 10].x) / 2.0;
                    pLinePoints[vblCounter - 6].y = (pLinePoints[vblCounter - 11].y + pLinePoints[vblCounter - 10].y) / 2.0;
                    pt0 = new POINT2(pLinePoints[vblCounter - 6]);
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 11], pt0, (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 9);
                    if (middleSegment >= 1) {
                        pt0 = lineutility.MidPointDouble(pt2, pt3, 0);
                        lineutility.GetArrowHead4Double(pt3, pt0, (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 9);
                    }
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[vblCounter - 6 + j] = new POINT2(pArrowPoints[j]);
                    }
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 10], pt0, (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 9);
                    if (middleSegment >= 1) {
                        pt0 = lineutility.MidPointDouble(pt2, pt3, 0);
                        lineutility.GetArrowHead4Double(pt2, pt0, (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 9);
                    }
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[vblCounter - 3 + j] = new POINT2(pArrowPoints[j]);
                    }
                    ArrayList<POINT2> airPts = new ArrayList<POINT2>();
                    pLinePoints[middleSegment - 1].style = 5;
                    if (vblSaveCounter == 2) {
                        pLinePoints[1].style = 5;
                    }
                    for (j = 0; j < vblCounter; ++j) {
                        airPts.add(new POINT2(pLinePoints[j]));
                    }
                    midpt = lineutility.MidPointDouble(pLinePoints[middleSegment - 1], pLinePoints[middleSegment], 0);
                    pt0 = lineutility.ExtendAlongLineDouble(midpt, pLinePoints[middleSegment], dMBR / 20.0, 0);
                    airPts.add(pt0);
                    pt1 = new POINT2(pLinePoints[middleSegment]);
                    pt1.style = 5;
                    airPts.add(pt1);
                    pt0 = lineutility.ExtendAlongLineDouble(midpt, pLinePoints[middleSegment - 1], dMBR / 20.0, 0);
                    airPts.add(pt0);
                    pt1 = new POINT2(pLinePoints[middleSegment - 1]);
                    pt1.style = 5;
                    airPts.add(pt1);
                    vblCounter = airPts.size();
                    pLinePoints = new POINT2[airPts.size()];
                    for (j = 0; j < airPts.size(); ++j) {
                        pLinePoints[j] = new POINT2((POINT2)airPts.get(j));
                    }
                    acCounter = vblCounter;
                    break;
                }
                case 22422000: {
                    pt0 = new POINT2(pLinePoints[1]);
                    pt1 = new POINT2(pLinePoints[0]);
                    pLinePoints[0] = new POINT2(pt0);
                    pLinePoints[1] = new POINT2(pt1);
                    pts2 = new POINT2[]{new POINT2(pt0), new POINT2(pt1), new POINT2(pt2)};
                    lineutility.GetPixelsMin(pts2, 3, offsetX, offsetY);
                    ((double[])offsetX.value)[0] = ((double[])offsetX.value)[0] < 0.0 ? ((double[])offsetX.value)[0] - 100.0 : 0.0;
                    pLinePoints[2].style = 5;
                    if (dMBR / 20.0 > 100.0 * DPIScaleFactor) {
                        dMBR = 2000.0 * DPIScaleFactor;
                    }
                    if (dMBR / 20.0 < 2.5 * DPIScaleFactor) {
                        dMBR = 50.0 * DPIScaleFactor;
                    }
                    if (dMBR > 500.0 * DPIScaleFactor) {
                        dMBR = 500.0 * DPIScaleFactor;
                    }
                    double rectWidth = arraysupport.getScaledSize(2.0, (double)tg.get_LineThickness() / 2.0, tg.get_patternScale());
                    pt2 = lineutility.ExtendLineDouble(pt0, pt1, -dMBR / 10.0);
                    bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
                    if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                        b = pt2.y + 1.0 / ((double[])m.value)[0] * pt2.x;
                        b1 = -1.0 / ((double[])m.value)[0] * ((double[])offsetX.value)[0] + b;
                        ptYIntercept.x = ((double[])offsetX.value)[0];
                        ptYIntercept.y = b1;
                        pLinePoints[3] = lineutility.ExtendLineDouble(ptYIntercept, pt2, -rectWidth);
                        pLinePoints[3].style = 0;
                        pLinePoints[4] = lineutility.ExtendLineDouble(ptYIntercept, pt2, rectWidth);
                        pLinePoints[4].style = 0;
                    }
                    if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                        pLinePoints[3] = new POINT2(pt2);
                        pLinePoints[3].y = pt2.y - rectWidth;
                        pLinePoints[3].style = 0;
                        pLinePoints[4] = new POINT2(pt2);
                        pLinePoints[4].y = pt2.y + rectWidth;
                        pLinePoints[4].style = 0;
                    }
                    if (bolVertical == 0) {
                        pLinePoints[3] = new POINT2(pt2);
                        pLinePoints[3].x = pt2.x - rectWidth;
                        pLinePoints[3].style = 0;
                        pLinePoints[4] = new POINT2(pt2);
                        pLinePoints[4].x = pt2.x + rectWidth;
                        pLinePoints[4].style = 0;
                    }
                    pt2 = lineutility.ExtendLineDouble(pt1, pt0, -dMBR / 10.0);
                    if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                        b = pt2.y + 1.0 / ((double[])m.value)[0] * pt2.x;
                        b1 = -1.0 / ((double[])m.value)[0] * ((double[])offsetX.value)[0] + b;
                        ptYIntercept.x = ((double[])offsetX.value)[0];
                        ptYIntercept.y = b1;
                        pLinePoints[5] = lineutility.ExtendLineDouble(ptYIntercept, pt2, rectWidth);
                        pLinePoints[5].style = 0;
                        pLinePoints[6] = lineutility.ExtendLineDouble(ptYIntercept, pt2, -rectWidth);
                    }
                    if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                        pLinePoints[5] = new POINT2(pt2);
                        pLinePoints[5].y = pt2.y + rectWidth;
                        pLinePoints[5].style = 0;
                        pLinePoints[6] = new POINT2(pt2);
                        pLinePoints[6].y = pt2.y - rectWidth;
                    }
                    if (bolVertical == 0) {
                        pLinePoints[5] = new POINT2(pt2);
                        pLinePoints[5].x = pt2.x + rectWidth;
                        pLinePoints[5].style = 0;
                        pLinePoints[6] = new POINT2(pt2);
                        pLinePoints[6].x = pt2.x - rectWidth;
                    }
                    pLinePoints[6].style = 0;
                    pLinePoints[7] = new POINT2(pLinePoints[3]);
                    pLinePoints[7].style = 5;
                    lineutility.GetArrowHead4Double(pLinePoints[1], pLinePoints[0], (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[8 + j] = new POINT2(pArrowPoints[j]);
                    }
                    lineutility.GetArrowHead4Double(pLinePoints[1], pLinePoints[2], (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[11 + j] = new POINT2(pArrowPoints[j]);
                        pLinePoints[11 + j].style = 0;
                    }
                    acCounter = 14;
                    break;
                }
                case 22522220: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    if (dMBR / 20.0 > 100.0 * DPIScaleFactor) {
                        dMBR = 2000.0 * DPIScaleFactor;
                    }
                    if (dMBR / 20.0 < 2.5 * DPIScaleFactor) {
                        dMBR = 50.0 * DPIScaleFactor;
                    }
                    if (dMBR < 150.0 * DPIScaleFactor) {
                        dMBR = 150.0 * DPIScaleFactor;
                    }
                    if (dMBR > 500.0 * DPIScaleFactor) {
                        dMBR = 500.0 * DPIScaleFactor;
                    }
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 5], pLinePoints[vblCounter - 4], (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - k - 1] = new POINT2(pArrowPoints[k]);
                    }
                    acCounter = vblCounter;
                    break;
                }
                case 23120000: {
                    pts2 = new POINT2[]{new POINT2(pt0), new POINT2(pt1)};
                    lineutility.GetPixelsMin(pts2, 2, offsetX, offsetY);
                    ((double[])offsetX.value)[0] = ((double[])offsetX.value)[0] <= 0.0 ? ((double[])offsetX.value)[0] - 100.0 : 0.0;
                    if (dMBR > 300.0 * DPIScaleFactor) {
                        dMBR = 300.0 * DPIScaleFactor;
                    }
                    pLinePoints[0] = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], -dMBR / 10.0);
                    bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
                    midpt.x = (pt0.x + pLinePoints[0].x) / 2.0;
                    midpt.y = (pt0.y + pLinePoints[0].y) / 2.0;
                    pLinePoints[vblCounter - 3] = new POINT2(pt0);
                    pLinePoints[vblCounter - 4].style = 5;
                    pLinePoints[vblCounter - 3].style = 0;
                    if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                        b = midpt.y + 1.0 / ((double[])m.value)[0] * midpt.x;
                        b1 = -1.0 / ((double[])m.value)[0] * ((double[])offsetX.value)[0] + b;
                        ptYIntercept.x = ((double[])offsetX.value)[0];
                        ptYIntercept.y = b1;
                        pLinePoints[vblCounter - 2] = lineutility.ExtendLineDouble(ptYIntercept, midpt, dMBR / 20.0);
                        if (pLinePoints[vblCounter - 2].y >= midpt.y) {
                            pLinePoints[vblCounter - 2] = lineutility.ExtendLineDouble(ptYIntercept, midpt, -dMBR / 20.0);
                        }
                    }
                    if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                        pLinePoints[vblCounter - 2] = new POINT2(midpt);
                        pLinePoints[vblCounter - 2].y = midpt.y - dMBR / 20.0;
                    }
                    if (bolVertical == 0) {
                        pLinePoints[vblCounter - 2] = new POINT2(midpt);
                        pLinePoints[vblCounter - 2].x = midpt.x - dMBR / 20.0;
                    }
                    pLinePoints[vblCounter - 2].style = 0;
                    pLinePoints[vblCounter - 1] = new POINT2(pLinePoints[0]);
                    acCounter = vblCounter;
                    break;
                }
                case 23157000: {
                    pts2 = new POINT2[2];
                    if (Math.abs(pt0.y - pt1.y) < 1.0) {
                        pt1.y = pt0.y + 1.0;
                    }
                    pts2[0] = new POINT2(pt0);
                    pts2[1] = new POINT2(pt1);
                    pts = new POINT2[26];
                    dRadius = lineutility.CalcDistanceDouble(pt0, pt1) / 2.0;
                    midpt.x = (pt1.x + pt0.x) / 2.0;
                    midpt.y = (pt1.y + pt0.y) / 2.0;
                    bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
                    if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                        b = midpt.y + 1.0 / ((double[])m.value)[0] * midpt.x;
                        ptYIntercept.x = 0.0;
                        ptYIntercept.y = b;
                        pt2 = lineutility.ExtendLineDouble(ptYIntercept, midpt, dRadius);
                        if (pLinePoints[0].x <= pLinePoints[1].x) {
                            if (pt2.y >= midpt.y) {
                                pt2 = lineutility.ExtendLineDouble(ptYIntercept, midpt, -dRadius);
                            }
                        } else if (pt2.y <= midpt.y) {
                            pt2 = lineutility.ExtendLineDouble(ptYIntercept, midpt, -dRadius);
                        }
                    }
                    if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                        pt2 = midpt;
                        pt2.y = pLinePoints[0].x <= pLinePoints[1].x ? midpt.y - dRadius : midpt.y + dRadius;
                    }
                    if (bolVertical == 0) {
                        pt2 = midpt;
                        pt2.x = pLinePoints[0].y <= pLinePoints[1].y ? midpt.x + dRadius : midpt.x - dRadius;
                    }
                    pt1 = lineutility.ExtendLineDouble(midpt, pt2, 100.0);
                    pts[0] = new POINT2(pt2);
                    pts[1] = new POINT2(pt1);
                    lineutility.ArcArrayDouble(pts, 0, dRadius, lineType, null);
                    pLinePoints[0].style = 1;
                    pLinePoints[1].style = 5;
                    for (j = 0; j < 26; ++j) {
                        pLinePoints[2 + j] = new POINT2(pts[j]);
                        pLinePoints[2 + j].style = 1;
                    }
                    acCounter = 28;
                    break;
                }
                case 211200000: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    if (dMBR / 10.0 > 100.0 * DPIScaleFactor) {
                        dMBR = 1000.0 * DPIScaleFactor;
                    }
                    if (dMBR / 10.0 < 2.5 * DPIScaleFactor) {
                        dMBR = 25.0 * DPIScaleFactor;
                    }
                    if (dMBR > 150.0 * DPIScaleFactor) {
                        dMBR = 150.0 * DPIScaleFactor;
                    }
                    pLinePoints[0] = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], -2.0 * dMBR / 10.0);
                    for (k = 0; k < vblCounter - 14; ++k) {
                        pLinePoints[k].style = 18;
                    }
                    pLinePoints[vblCounter - 15].style = 5;
                    pt0 = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], 5.0 * dMBR / 10.0);
                    lineutility.GetArrowHead4Double(pt0, pLinePoints[0], (int)dMBR / 10, (int)dMBR / 10, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 14 + k] = new POINT2(pArrowPoints[k]);
                    }
                    pt3 = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], dMBR / 10.0);
                    lineutility.GetArrowHead4Double(pt0, pt3, (int)dMBR / 10, (int)dMBR / 10, pArrowPoints, 0);
                    pLinePoints[vblCounter - 12].style = 0;
                    pLinePoints[vblCounter - 11] = new POINT2(pArrowPoints[2]);
                    pLinePoints[vblCounter - 11].style = 0;
                    pLinePoints[vblCounter - 10] = new POINT2(pArrowPoints[0]);
                    pLinePoints[vblCounter - 10].style = 0;
                    pLinePoints[vblCounter - 9] = new POINT2(pLinePoints[vblCounter - 14]);
                    pLinePoints[vblCounter - 9].style = 5;
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 16], pLinePoints[vblCounter - 15], (int)dMBR / 10, (int)dMBR / 10, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 8 + k] = new POINT2(pArrowPoints[k]);
                    }
                    pLinePoints[vblCounter - 6].style = 0;
                    pLinePoints[1] = pt3 = lineutility.ExtendLineDouble(pLinePoints[vblCounter - 16], pLinePoints[vblCounter - 15], -0.75 * dMBR / 10.0);
                    pLinePoints[1].style = 5;
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 16], pt3, (int)(dMBR / 10.0), (int)(dMBR / 10.0), pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 5 + k] = new POINT2(pArrowPoints[2 - k]);
                    }
                    pLinePoints[vblCounter - 5].style = 0;
                    pLinePoints[vblCounter - 2] = new POINT2(pLinePoints[vblCounter - 8]);
                    pLinePoints[vblCounter - 2].style = 5;
                    pLinePoints[vblCounter - 1] = new POINT2(pLinePoints[vblCounter - 7]);
                    acCounter = 16;
                    break;
                }
                case 211210000: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    if (dMBR / 15.0 > 100.0 * DPIScaleFactor) {
                        dMBR = 1500.0 * DPIScaleFactor;
                    }
                    if (dMBR / 15.0 < 2.5 * DPIScaleFactor) {
                        dMBR = 37.5 * DPIScaleFactor;
                    }
                    if (dMBR < 100.0 * DPIScaleFactor) {
                        dMBR = 100.0 * DPIScaleFactor;
                    }
                    if (dMBR > 500.0 * DPIScaleFactor) {
                        dMBR = 500.0 * DPIScaleFactor;
                    }
                    pLinePoints[0] = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], -dMBR / 8.75);
                    pLinePoints[vblCounter - 15].style = 5;
                    pt0 = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], dMBR / 4.0);
                    lineutility.GetArrowHead4Double(pt0, pLinePoints[0], (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 14 + k] = new POINT2(pArrowPoints[k]);
                    }
                    pLinePoints[vblCounter - 12].style = 0;
                    pt3 = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], dMBR / 15.0);
                    lineutility.GetArrowHead4Double(pt0, pt3, (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 11 + k] = new POINT2(pArrowPoints[2 - k]);
                        pLinePoints[vblCounter - 11 + k].style = 0;
                    }
                    pLinePoints[vblCounter - 8] = new POINT2(pLinePoints[vblCounter - 14]);
                    pLinePoints[vblCounter - 8].style = 5;
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 16], pLinePoints[vblCounter - 15], (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 9);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 7 + k] = new POINT2(pArrowPoints[k]);
                    }
                    for (k = 4; k > 0; --k) {
                        pLinePoints[vblCounter - k].style = 5;
                    }
                    acCounter = 12;
                    break;
                }
                case 23223000: {
                    lLinestyle = 9;
                    if (dMBR / 10.0 > 100.0 * DPIScaleFactor) {
                        dMBR = 1000.0 * DPIScaleFactor;
                    }
                    if (dMBR / 10.0 < 2.5 * DPIScaleFactor) {
                        dMBR = 25.0 * DPIScaleFactor;
                    }
                    if (dMBR > 250.0 * DPIScaleFactor) {
                        dMBR = 250.0 * DPIScaleFactor;
                    }
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 8], pLinePoints[vblCounter - 7], (int)dMBR / 10, (int)dMBR / 10, pArrowPoints, lLinestyle);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 6 + k] = new POINT2(pArrowPoints[k]);
                    }
                    lineutility.GetArrowHead4Double(pLinePoints[1], pLinePoints[0], (int)dMBR / 10, (int)dMBR / 10, pArrowPoints, lLinestyle);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 3 + k] = new POINT2(pArrowPoints[k]);
                    }
                    acCounter = 8;
                    break;
                }
                case 26220000: {
                    double extensionLength = arraysupport.getScaledSize(10.0, tg.get_LineThickness(), tg.get_patternScale());
                    pt3 = lineutility.ExtendLine2Double(pt1, pt0, -extensionLength, 0);
                    pt4 = lineutility.ExtendLine2Double(pt0, pt1, -extensionLength, 0);
                    pt5 = lineutility.ExtendTrueLinePerpDouble(pt0, pt1, pt3, extensionLength, 0);
                    pt6 = lineutility.ExtendTrueLinePerpDouble(pt0, pt1, pt3, -extensionLength, 0);
                    pt7 = lineutility.ExtendTrueLinePerpDouble(pt0, pt1, pt4, extensionLength, 0);
                    pt8 = lineutility.ExtendTrueLinePerpDouble(pt0, pt1, pt4, -extensionLength, 0);
                    pLinePoints[0] = pt5.y < pt6.y ? new POINT2(pt5) : new POINT2(pt6);
                    pLinePoints[3] = pt7.y > pt8.y ? new POINT2(pt7) : new POINT2(pt8);
                    pLinePoints[1] = new POINT2(pt0);
                    pLinePoints[2] = new POINT2(pt1);
                    acCounter = 4;
                    break;
                }
                case 23330000: {
                    acCounter = arraysupport.GetFORTLPointsDouble(tg, pLinePoints, vblSaveCounter);
                    break;
                }
                case 21400000: {
                    acCounter = DISMSupport.GetDISMCanalizeDouble(pLinePoints, lineType);
                    break;
                }
                case 21200000: {
                    acCounter = DISMSupport.GetDISMBreachDouble(pLinePoints, lineType);
                    break;
                }
                case 212210000: 
                case 212220000: 
                case 212230000: {
                    if (vblSaveCounter == 4) {
                        acCounter = DISMSupport.GetDISMCoverDoubleRevC(pLinePoints, lineType, vblSaveCounter);
                        break;
                    }
                    acCounter = DISMSupport.GetDISMCoverDouble(pLinePoints, lineType);
                    break;
                }
                case 22139000: {
                    acCounter = DISMSupport.GetDISMCoverDouble(pLinePoints, lineType);
                    POINT2[] saraPts = new POINT2[16];
                    for (j = 0; j < 4; ++j) {
                        saraPts[j] = pLinePoints[j];
                    }
                    for (j = 4; j < 8; ++j) {
                        saraPts[j] = pLinePoints[j + 4];
                    }
                    for (j = 8; j < 12; ++j) {
                        saraPts[j] = pLinePoints[j - 4];
                    }
                    for (j = 12; j < 16; ++j) {
                        saraPts[j] = pLinePoints[j];
                    }
                    pLinePoints = saraPts;
                    break;
                }
                case 211000000: {
                    acCounter = DISMSupport.GetDISMDisruptDouble(pLinePoints, lineType);
                    break;
                }
                case 21600000: {
                    acCounter = DISMSupport.GetDISMContainDouble(pLinePoints, lineType);
                    break;
                }
                case 211700000: {
                    DISMSupport.GetDISMPenetrateDouble(pLinePoints, lineType);
                    acCounter = 7;
                    break;
                }
                case 21100000: 
                case 23171000: {
                    DISMSupport.GetDISMBlockDouble2(pLinePoints, lineType);
                    acCounter = 4;
                    break;
                }
                case 24211000: 
                case 24250000: 
                case 24260000: {
                    acCounter = DISMSupport.GetDISMLinearTargetDouble(pLinePoints, lineType, vblCounter);
                    break;
                }
                case 23163000: 
                case 23221000: {
                    DISMSupport.GetDISMGapDouble(pLinePoints, lineType);
                    acCounter = 12;
                    break;
                }
                case 23174000: {
                    acCounter = DISMSupport.GetDISMMinefieldDisruptDouble(pLinePoints, lineType);
                    break;
                }
                case 22534000: {
                    acCounter = DISMSupport.GetDISMSupportByFireDouble(pLinePoints, lineType);
                    break;
                }
                case 22533000: {
                    acCounter = DISMSupport.GetDISMATKBYFIREDouble(pLinePoints, lineType);
                    break;
                }
                case 23213000: {
                    acCounter = DISMSupport.GetDISMByImpDouble(pLinePoints, lineType);
                    break;
                }
                case 21500000: {
                    acCounter = DISMSupport.GetDISMClearDouble(pLinePoints, lineType);
                    break;
                }
                case 23212000: {
                    acCounter = DISMSupport.GetDISMByDifDouble(pLinePoints, lineType, clipBounds);
                    break;
                }
                case 212300000: {
                    double radius = 0.0;
                    if (vblSaveCounter == 4) {
                        radius = lineutility.CalcDistanceDouble(pLinePoints[0], pLinePoints[1]);
                        pLinePoints[1] = new POINT2(pLinePoints[3]);
                        pLinePoints[2] = new POINT2(pLinePoints[2]);
                    }
                    acCounter = DISMSupport.GetDISMSeizeDouble(pLinePoints, lineType, radius);
                    break;
                }
                case 23172000: 
                case 211100000: {
                    acCounter = DISMSupport.GetDISMFixDouble(pLinePoints, lineType, clipBounds);
                    break;
                }
                case 211800000: {
                    acCounter = DISMSupport.GetDISMRIPDouble(pLinePoints, lineType);
                    break;
                }
                case 21800000: 
                case 25344100: 
                case 25344200: 
                case 212000000: 
                case 212400000: 
                case 212410000: {
                    acCounter = DISMSupport.GetDelayGraphicEtcDouble(pLinePoints);
                    break;
                }
                case 23211000: {
                    acCounter = DISMSupport.GetDISMEasyDouble(pLinePoints, lineType);
                    break;
                }
                case 21300000: {
                    acCounter = DISMSupport.GetDISMBypassDouble(pLinePoints, lineType);
                    break;
                }
                case 22611000: {
                    acCounter = DISMSupport.AmbushPointsDouble(pLinePoints);
                    break;
                }
                case 22122000: {
                    acCounter = flot.GetFlotDouble(pLinePoints, arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale()), vblSaveCounter);
                    break;
                }
                default: {
                    acCounter = vblSaveCounter;
                }
            }
            switch (lineType) {
                case 22121000: {
                    arraysupport.FillPoints(pLinePoints, acCounter, points);
                    return points;
                }
                case 240804: 
                case 21100000: 
                case 21200000: 
                case 21300000: 
                case 21400000: 
                case 21500000: 
                case 21600000: 
                case 22522100: 
                case 23120000: 
                case 23226000: 
                case 23410000: 
                case 24326100: 
                case 25211000: 
                case 25212000: 
                case 211000000: 
                case 211100000: 
                case 211200000: 
                case 211210000: 
                case 211400000: 
                case 211600000: 
                case 211700000: 
                case 211900000: 
                case 212100000: 
                case 212210000: 
                case 212220000: 
                case 212230000: 
                case 212300000: 
                case 212500000: 
                case 212600000: 
                case 221311000: {
                    arraysupport.FillPoints(pLinePoints, acCounter, points);
                    break;
                }
                default: {
                    if (shapes != null) break;
                    arraysupport.FillPoints(pLinePoints, acCounter, points);
                    return points;
                }
            }
            if (shapes == null) {
                return points;
            }
            Shape2 shape = null;
            Object gp = null;
            Shape2 redShape = null;
            Shape2 blueShape = null;
            Shape2 paleBlueShape = null;
            Shape2 whiteShape = null;
            Shape2 redFillShape = null;
            Shape2 blueFillShape = null;
            Object blackShape = null;
            Area blueArea = null;
            Area paleBlueArea = null;
            Area whiteArea = null;
            boolean beginLine = true;
            Polygon poly = null;
            switch (lineType) {
                case 22422000: {
                    arraysupport.addPolyline(pLinePoints, 3, shapes);
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.moveTo(pLinePoints[3]);
                    for (k = 4; k < 8; ++k) {
                        shape.lineTo(pLinePoints[k]);
                    }
                    shapes.add(shape);
                    POINT2[] secondPoly = new POINT2[6];
                    for (int i = 0; i < 6; ++i) {
                        secondPoly[i] = pLinePoints[i + 8];
                    }
                    arraysupport.addPolyline(secondPoly, 6, shapes);
                    break;
                }
                case 22522210: {
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.moveTo(pLinePoints[0]);
                    for (j = 0; j < acCounter - 10; ++j) {
                        shape.lineTo(pLinePoints[j]);
                    }
                    shapes.add(shape);
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.moveTo(pLinePoints[acCounter - 10]);
                    for (j = 9; j > 0; --j) {
                        if (pLinePoints[acCounter - j - 1].style == 5) {
                            shape.moveTo(pLinePoints[acCounter - j]);
                            continue;
                        }
                        shape.lineTo(pLinePoints[acCounter - j]);
                    }
                    shapes.add(shape);
                    break;
                }
                case 32214000: {
                    whiteShape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                    whiteShape.setFillColor(Color.WHITE);
                    blueShape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                    blueShape.setFillColor(new Color(30, 144, 255));
                    BasicStroke blueStroke = new BasicStroke((float)arraysupport.getScaledSize(14.0, tg.get_LineThickness(), tg.get_patternScale()));
                    paleBlueShape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                    paleBlueShape.setFillColor(new Color(153, 204, 255));
                    BasicStroke paleBlueStroke = new BasicStroke(blueStroke.getLineWidth() * 2.0f);
                    poly = new Polygon();
                    for (k = 0; k < vblSaveCounter; ++k) {
                        poly.addPoint((int)pLinePoints[k].x, (int)pLinePoints[k].y);
                        if (k == 0) {
                            whiteShape.moveTo(pLinePoints[k]);
                            continue;
                        }
                        whiteShape.lineTo(pLinePoints[k]);
                    }
                    whiteArea = new Area(poly);
                    blueArea = new Area(blueStroke.createStrokedShape(poly));
                    blueArea.intersect(whiteArea);
                    blueShape.setShape(lineutility.createStrokedShape(blueArea));
                    paleBlueArea = new Area(paleBlueStroke.createStrokedShape(poly));
                    paleBlueArea.intersect(whiteArea);
                    paleBlueShape.setShape(lineutility.createStrokedShape(paleBlueArea));
                    shapes.add(whiteShape);
                    shapes.add(paleBlueShape);
                    shapes.add(blueShape);
                    break;
                }
                case 32550000: {
                    redShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    redShape.set_Style(1);
                    blueShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    blueShape.set_Style(0);
                    redShape.moveTo(pLinePoints[0]);
                    for (k = 1; k < vblSaveCounter; ++k) {
                        redShape.lineTo(pLinePoints[k]);
                    }
                    beginLine = true;
                    for (k = vblSaveCounter; k < acCounter; ++k) {
                        if (pLinePoints[k].style == 0) {
                            if (beginLine) {
                                blueShape.moveTo(pLinePoints[k]);
                                beginLine = false;
                            } else {
                                blueShape.lineTo(pLinePoints[k]);
                            }
                        }
                        if (pLinePoints[k].style != 5) continue;
                        blueShape.lineTo(pLinePoints[k]);
                        beginLine = true;
                    }
                    shapes.add(redShape);
                    shapes.add(blueShape);
                    break;
                }
                case 31148000: {
                    redShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    redShape.setLineColor(Color.RED);
                    blueShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    blueShape.setLineColor(Color.GREEN);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style == 19 && pLinePoints[k + 1].style == 5) {
                            redShape.moveTo(pLinePoints[k]);
                            redShape.lineTo(pLinePoints[k + 1]);
                            continue;
                        }
                        if (pLinePoints[k].style != 25 || pLinePoints[k + 1].style != 5) continue;
                        blueShape.moveTo(pLinePoints[k]);
                        blueShape.lineTo(pLinePoints[k + 1]);
                    }
                    shapes.add(redShape);
                    shapes.add(blueShape);
                    tg.set_lineCap(0);
                    break;
                }
                case 31134300: {
                    redShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    redShape.setLineColor(Color.RED);
                    blueShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    blueShape.setLineColor(Color.BLUE);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style == 23) {
                            redFillShape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                            redFillShape.setFillColor(Color.RED);
                            redFillShape.moveTo(pLinePoints[k - 9]);
                            for (int l = k - 8; l <= k; ++l) {
                                redFillShape.lineTo(pLinePoints[l]);
                            }
                            shapes.add(redFillShape);
                        }
                        if (pLinePoints[k].style != 24) continue;
                        blueFillShape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                        blueFillShape.setFillColor(Color.BLUE);
                        blueFillShape.moveTo(pLinePoints[k - 2]);
                        blueFillShape.lineTo(pLinePoints[k - 1]);
                        blueFillShape.lineTo(pLinePoints[k]);
                        shapes.add(blueFillShape);
                    }
                    for (k = 0; k < vblSaveCounter; ++k) {
                        if (k == 0) {
                            d = arraysupport.getScaledSize(50.0, tg.get_LineThickness(), tg.get_patternScale());
                            redShape.moveTo(pOriginalLinePoints[0]);
                            d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[0], pOriginalLinePoints[1]);
                            if (d1 < d) {
                                d = d1;
                            }
                            pt0 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[0], pOriginalLinePoints[1], d);
                            redShape.lineTo(pt0);
                            continue;
                        }
                        if (k > 0 && k < vblSaveCounter - 1) {
                            d = arraysupport.getScaledSize(50.0, tg.get_LineThickness(), tg.get_patternScale());
                            d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[k], pOriginalLinePoints[k - 1]);
                            if (d1 < d) {
                                d = d1;
                            }
                            pt0 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[k], pOriginalLinePoints[k - 1], d);
                            pt1 = pOriginalLinePoints[k];
                            d = arraysupport.getScaledSize(50.0, tg.get_LineThickness(), tg.get_patternScale());
                            d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[k], pOriginalLinePoints[k + 1]);
                            if (d1 < d) {
                                d = d1;
                            }
                            pt2 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[k], pOriginalLinePoints[k + 1], d);
                            redShape.moveTo(pt0);
                            redShape.lineTo(pt1);
                            redShape.lineTo(pt2);
                            continue;
                        }
                        d = arraysupport.getScaledSize(50.0, tg.get_LineThickness(), tg.get_patternScale());
                        d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[vblSaveCounter - 1], pOriginalLinePoints[vblSaveCounter - 2]);
                        if (d1 < d) {
                            d = d1;
                        }
                        redShape.moveTo(pOriginalLinePoints[vblSaveCounter - 1]);
                        pt0 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[vblSaveCounter - 1], pOriginalLinePoints[vblSaveCounter - 2], d);
                        redShape.lineTo(pt0);
                    }
                    for (k = 0; k < vblCounter - 1; ++k) {
                        if (pLinePoints[k].style == 19 && pLinePoints[k + 1].style == 5) {
                            redShape.moveTo(pLinePoints[k]);
                            redShape.lineTo(pLinePoints[k + 1]);
                            continue;
                        }
                        if (pLinePoints[k].style != 25 || pLinePoints[k + 1].style != 5) continue;
                        blueShape.moveTo(pLinePoints[k]);
                        blueShape.lineTo(pLinePoints[k + 1]);
                    }
                    shapes.add(redShape);
                    shapes.add(blueShape);
                    break;
                }
                case 31134200: {
                    redShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    redShape.setLineColor(Color.RED);
                    blueShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    blueShape.setLineColor(Color.BLUE);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style == 23) {
                            redFillShape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                            redFillShape.setFillColor(Color.RED);
                            redFillShape.moveTo(pLinePoints[k - 9]);
                            for (int l = k - 8; l <= k; ++l) {
                                redFillShape.lineTo(pLinePoints[l]);
                            }
                            shapes.add(redFillShape);
                        }
                        if (pLinePoints[k].style != 24) continue;
                        blueFillShape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                        blueFillShape.setFillColor(Color.BLUE);
                        blueFillShape.moveTo(pLinePoints[k - 2]);
                        blueFillShape.lineTo(pLinePoints[k - 1]);
                        blueFillShape.lineTo(pLinePoints[k]);
                        shapes.add(blueFillShape);
                    }
                    for (k = 0; k < vblSaveCounter; ++k) {
                        if (k == 0) {
                            d = arraysupport.getScaledSize(50.0, tg.get_LineThickness(), tg.get_patternScale());
                            redShape.moveTo(pOriginalLinePoints[0]);
                            d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[0], pOriginalLinePoints[1]);
                            if (d1 < d) {
                                d = d1;
                            }
                            pt0 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[0], pOriginalLinePoints[1], d);
                            redShape.lineTo(pt0);
                            continue;
                        }
                        if (k > 0 && k < vblSaveCounter - 1) {
                            d = arraysupport.getScaledSize(50.0, tg.get_LineThickness(), tg.get_patternScale());
                            d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[k], pOriginalLinePoints[k - 1]);
                            if (d1 < d) {
                                d = d1;
                            }
                            pt0 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[k], pOriginalLinePoints[k - 1], d);
                            pt1 = pOriginalLinePoints[k];
                            d = arraysupport.getScaledSize(50.0, tg.get_LineThickness(), tg.get_patternScale());
                            d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[k], pOriginalLinePoints[k + 1]);
                            if (d1 < d) {
                                d = d1;
                            }
                            pt2 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[k], pOriginalLinePoints[k + 1], d);
                            redShape.moveTo(pt0);
                            redShape.lineTo(pt1);
                            redShape.lineTo(pt2);
                            continue;
                        }
                        d = arraysupport.getScaledSize(50.0, tg.get_LineThickness(), tg.get_patternScale());
                        d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[vblSaveCounter - 1], pOriginalLinePoints[vblSaveCounter - 2]);
                        if (d1 < d) {
                            d = d1;
                        }
                        redShape.moveTo(pOriginalLinePoints[vblSaveCounter - 1]);
                        pt0 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[vblSaveCounter - 1], pOriginalLinePoints[vblSaveCounter - 2], d);
                        redShape.lineTo(pt0);
                    }
                    shapes.add(redShape);
                    for (k = 0; k < acCounter; ++k) {
                        POINT2[] CirclePoints;
                        if (pLinePoints[k].style == 22) {
                            CirclePoints = new POINT2[8];
                            redShape = lineutility.CalcCircleShape(pLinePoints[k], arraysupport.getScaledSize(3.0, tg.get_LineThickness(), tg.get_patternScale()), 8, CirclePoints, 9);
                            redShape.setFillColor(Color.RED);
                            if (redShape != null && redShape.getShape() != null) {
                                shapes.add(redShape);
                            }
                        }
                        if (pLinePoints[k].style != 20) continue;
                        CirclePoints = new POINT2[8];
                        blueShape = lineutility.CalcCircleShape(pLinePoints[k], arraysupport.getScaledSize(3.0, tg.get_LineThickness(), tg.get_patternScale()), 8, CirclePoints, 9);
                        blueShape.setFillColor(Color.BLUE);
                        if (blueShape == null || blueShape.getShape() == null) continue;
                        shapes.add(blueShape);
                    }
                    break;
                }
                case 31134100: {
                    redShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    redShape.setLineColor(Color.RED);
                    blueShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    blueShape.setLineColor(Color.BLUE);
                    beginLine = true;
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style == 19 && pLinePoints[k + 1].style == 5) {
                            redShape.moveTo(pLinePoints[k]);
                            redShape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style == 19 && pLinePoints[k + 1].style == 19) {
                            redShape.moveTo(pLinePoints[k]);
                            redShape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style == 25 && pLinePoints[k + 1].style == 5) {
                            blueShape.moveTo(pLinePoints[k]);
                            blueShape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style == 25 && pLinePoints[k + 1].style == 25) {
                            blueShape.moveTo(pLinePoints[k]);
                            blueShape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style != 0 || pLinePoints[k + 1].style != 5) continue;
                        redShape.moveTo(pLinePoints[k]);
                        redShape.lineTo(pLinePoints[k + 1]);
                    }
                    shapes.add(redShape);
                    shapes.add(blueShape);
                    break;
                }
                case 31134000: {
                    redShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    redShape.setLineColor(Color.RED);
                    blueShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    blueShape.setLineColor(Color.BLUE);
                    redFillShape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                    redFillShape.setLineColor(Color.RED);
                    redFillShape.setFillColor(Color.RED);
                    blueFillShape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                    blueFillShape.setLineColor(Color.BLUE);
                    blueFillShape.setFillColor(Color.BLUE);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style == 19 && pLinePoints[k + 1].style == 5) {
                            redShape.moveTo(pLinePoints[k]);
                            redShape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style == 19 && pLinePoints[k + 1].style == 19) {
                            int l;
                            if (redFillShape.getPoints().isEmpty()) {
                                redFillShape.moveTo(pLinePoints[k + 9]);
                                for (l = k + 9; l >= k; --l) {
                                    redFillShape.lineTo(pLinePoints[l]);
                                }
                            } else {
                                redFillShape.moveTo(pLinePoints[k]);
                                for (l = k; l < k + 10; ++l) {
                                    redFillShape.lineTo(pLinePoints[l]);
                                }
                            }
                            k += 9;
                            shapes.add(redFillShape);
                            redFillShape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                            redFillShape.setLineColor(Color.RED);
                            redFillShape.setFillColor(Color.RED);
                        }
                        if (pLinePoints[k].style == 25 && pLinePoints[k + 1].style == 5) {
                            blueShape.moveTo(pLinePoints[k]);
                            blueShape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style == 25 && pLinePoints[k + 1].style == 25) {
                            if (blueFillShape.getPoints().isEmpty()) {
                                blueFillShape.moveTo(pLinePoints[k + 2]);
                                blueFillShape.lineTo(pLinePoints[k + 1]);
                                blueFillShape.lineTo(pLinePoints[k]);
                            } else {
                                blueFillShape.moveTo(pLinePoints[k]);
                                blueFillShape.lineTo(pLinePoints[k + 1]);
                                blueFillShape.lineTo(pLinePoints[k + 2]);
                            }
                            shapes.add(blueFillShape);
                            blueFillShape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                            blueFillShape.setLineColor(Color.BLUE);
                            blueFillShape.setFillColor(Color.BLUE);
                        }
                        if (pLinePoints[k].style != 0 || pLinePoints[k + 1].style != 5) continue;
                        redShape.moveTo(pLinePoints[k]);
                        redShape.lineTo(pLinePoints[k + 1]);
                    }
                    shapes.add(redShape);
                    shapes.add(blueShape);
                    break;
                }
                case 31132200: {
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style != 0 || pLinePoints[k + 1].style != 5) continue;
                        shape.moveTo(pLinePoints[k]);
                        shape.lineTo(pLinePoints[k + 1]);
                    }
                    shapes.add(shape);
                    for (k = 0; k < acCounter; ++k) {
                        if (pLinePoints[k].style != 20) continue;
                        POINT2[] CirclePoints = new POINT2[8];
                        shape = lineutility.CalcCircleShape(pLinePoints[k], arraysupport.getScaledSize(3.0, tg.get_LineThickness(), tg.get_patternScale()), 8, CirclePoints, 9);
                        if (shape == null || shape.getShape() == null) continue;
                        shapes.add(shape);
                    }
                    break;
                }
                case 211200000: {
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.set_Style(1);
                    shape.moveTo(pLinePoints[0]);
                    shape.lineTo(pLinePoints[1]);
                    shapes.add(shape);
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.set_Style(0);
                    for (j = 2; j < vblCounter; ++j) {
                        if (pLinePoints[j - 1].style != 5) {
                            shape.lineTo(pLinePoints[j]);
                            continue;
                        }
                        shape.moveTo(pLinePoints[j]);
                    }
                    shapes.add(shape);
                    break;
                }
                case 31131200: {
                    for (k = 0; k < acCounter; ++k) {
                        if (pLinePoints[k].style != 20) continue;
                        POINT2[] CirclePoints = new POINT2[8];
                        shape = lineutility.CalcCircleShape(pLinePoints[k], arraysupport.getScaledSize(3.0, tg.get_LineThickness(), tg.get_patternScale()), 8, CirclePoints, 9);
                        if (shape == null || shape.getShape() == null) continue;
                        shapes.add(shape);
                    }
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style == 0 && pLinePoints[k + 1].style == 0) {
                            shape.moveTo(pLinePoints[k]);
                            shape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style == 0 && pLinePoints[k + 1].style == 9) {
                            shape.moveTo(pLinePoints[k]);
                            shape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style == 0 && pLinePoints[k + 1].style == 5) {
                            d = lineutility.CalcDistanceDouble(pLinePoints[k], pLinePoints[k + 1]);
                            pt0 = lineutility.ExtendAlongLineDouble(pLinePoints[k], pLinePoints[k + 1], d - arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale()));
                            shape.moveTo(pLinePoints[k]);
                            shape.lineTo(pt0);
                        }
                        if (pLinePoints[k].style != 0 || k != acCounter - 2) continue;
                        shape.moveTo(pLinePoints[k]);
                        shape.lineTo(pLinePoints[k + 1]);
                    }
                    shapes.add(shape);
                    break;
                }
                case 32680000: {
                    for (k = 0; k < acCounter; ++k) {
                        if (pLinePoints[k].style != 20) continue;
                        POINT2[] CirclePoints = new POINT2[8];
                        shape = lineutility.CalcCircleShape(pLinePoints[k], arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale()), 8, CirclePoints, 9);
                        if (shape == null || shape.getShape() == null) continue;
                        shapes.add(shape);
                    }
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style != 0 || pLinePoints[k + 1].style != 5) continue;
                        shape.moveTo(pLinePoints[k]);
                        shape.lineTo(pLinePoints[k + 1]);
                    }
                    shapes.add(shape);
                    break;
                }
                case 23132000: {
                    for (k = 0; k < acCounter; ++k) {
                        if (pLinePoints[k].style == 20) {
                            POINT2[] CirclePoints = new POINT2[8];
                            shape = lineutility.CalcCircleShape(pLinePoints[k], arraysupport.getScaledSize(4.0, tg.get_LineThickness(), tg.get_patternScale()), 8, CirclePoints, 9);
                            if (shape == null || shape.getShape() == null) continue;
                            shapes.add(shape);
                            continue;
                        }
                        if (k < acCounter - 2) {
                            if (pLinePoints[k].style != 0 && pLinePoints[k + 1].style == 0) {
                                shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                                shape.set_Style(pLinePoints[k].style);
                                shape.moveTo(pLinePoints[k]);
                                shape.lineTo(pLinePoints[k]);
                            } else if (pLinePoints[k].style == 0 && pLinePoints[k + 1].style == 0) {
                                shape.moveTo(pLinePoints[k]);
                                shape.lineTo(pLinePoints[k + 1]);
                            } else if (pLinePoints[k].style == 0 && pLinePoints[k + 1].style == 10) {
                                shape.moveTo(pLinePoints[k]);
                                shape.lineTo(pLinePoints[k + 1]);
                                shapes.add(shape);
                            }
                        }
                        if (k >= acCounter - 2) continue;
                        if (pLinePoints[k].style == 5 && pLinePoints[k + 1].style == 0) {
                            shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                            shape.set_Style(pLinePoints[k].style);
                            shape.moveTo(pLinePoints[k]);
                            continue;
                        }
                        if (pLinePoints[k].style == 0 && pLinePoints[k + 1].style == 0) {
                            shape.lineTo(pLinePoints[k + 1]);
                            continue;
                        }
                        if (pLinePoints[k].style != 0 || pLinePoints[k + 1].style != 5) continue;
                        shape.lineTo(pLinePoints[k + 1]);
                        shapes.add(shape);
                    }
                    break;
                }
                case 23192000: {
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.set_Style(pLinePoints[0].style);
                    shape.moveTo(pLinePoints[0]);
                    shape.lineTo(pLinePoints[1]);
                    shapes.add(shape);
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.set_Style(pLinePoints[2].style);
                    shape.moveTo(pLinePoints[2]);
                    shape.lineTo(pLinePoints[3]);
                    shapes.add(shape);
                    break;
                }
                case 23225000: {
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.set_Style(pLinePoints[0].style);
                    shape.moveTo(pLinePoints[0]);
                    shape.lineTo(pLinePoints[1]);
                    shape.moveTo(pLinePoints[2]);
                    shape.lineTo(pLinePoints[3]);
                    shapes.add(shape);
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.set_Style(pLinePoints[4].style);
                    shape.moveTo(pLinePoints[4]);
                    for (k = 5; k < acCounter; ++k) {
                        if (pLinePoints[k - 1].style == 5) continue;
                        shape.lineTo(pLinePoints[k]);
                    }
                    if (shape == null || shape.getShape() == null) break;
                    shapes.add(shape);
                    break;
                }
                case 270801: {
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.set_Style(points.get((int)0).style);
                    shape.moveTo(points.get(0));
                    for (k = 1; k < vblCounter; ++k) {
                        shape.lineTo(points.get(k));
                    }
                    if (shape != null && shape.getShape() != null) {
                        shapes.add(shape);
                    }
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    beginLine = true;
                    for (k = vblCounter; k < points.size(); ++k) {
                        if (beginLine) {
                            if (k == 0) {
                                shape.set_Style(points.get((int)k).style);
                            }
                            if (k > 0 && points.get((int)k).style == 5 && points.get((int)(k - 1)).style == 5) {
                                shape.lineTo(points.get(k));
                            }
                            shape.moveTo(points.get(k));
                            beginLine = false;
                        } else {
                            shape.lineTo(points.get(k));
                            if (points.get((int)k).style == 5 || points.get((int)k).style == 10) {
                                beginLine = true;
                            }
                        }
                        if (k != points.size() - 1 || shape == null || shape.getShape() == null) continue;
                        shapes.add(shape);
                    }
                    break;
                }
                case 221311000: {
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.moveTo(pLinePoints[0]);
                    for (k = 1; k < acCounter - 5; ++k) {
                        shape.lineTo(pLinePoints[k]);
                    }
                    shapes.add(shape);
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.moveTo(pLinePoints[acCounter - 4]);
                    shape.lineTo(pLinePoints[acCounter - 3]);
                    shape.moveTo(pLinePoints[acCounter - 2]);
                    shape.lineTo(pLinePoints[acCounter - 1]);
                    shapes.add(shape);
                    break;
                }
                case 272101: {
                    arraysupport.addPolyline(pLinePoints, acCounter / 2, shapes);
                    POINT2[] secondPoly = new POINT2[acCounter / 2];
                    for (int i = 0; i < acCounter / 2; ++i) {
                        secondPoly[i] = pLinePoints[i + acCounter / 2];
                    }
                    arraysupport.addPolyline(secondPoly, acCounter / 2, shapes);
                    break;
                }
                case 22522100: {
                    int i;
                    POINT2[] secondPoly = new POINT2[9];
                    for (i = 0; i < 4; ++i) {
                        secondPoly[i] = pLinePoints[pLinePoints.length - 4 + i];
                    }
                    arraysupport.addPolyline(secondPoly, 4, shapes);
                    arraysupport.addPolyline(pLinePoints, acCounter - 13, shapes);
                    for (i = 0; i < 9; ++i) {
                        secondPoly[i] = pLinePoints[pLinePoints.length - 13 + i];
                    }
                    arraysupport.addPolyline(secondPoly, 9, shapes);
                    break;
                }
                case 22522220: {
                    arraysupport.addPolyline(pLinePoints, acCounter - 3, shapes);
                    POINT2[] secondPoly = new POINT2[3];
                    for (int i = 0; i < 3; ++i) {
                        secondPoly[i] = pLinePoints[pLinePoints.length - 3 + i];
                    }
                    arraysupport.addPolyline(secondPoly, 3, shapes);
                    break;
                }
                default: {
                    arraysupport.addPolyline(pLinePoints, acCounter, shapes);
                }
            }
            switch (lineType) {
                case 22221000: 
                case 22222000: 
                case 22223000: 
                case 22224000: 
                case 22225000: 
                case 25170400: 
                case 25170600: {
                    for (j = 0; j < vblSaveCounter - 1; ++j) {
                        dMBR = pOriginalLinePoints[j].style;
                        acPoints[0] = new POINT2(pOriginalLinePoints[j]);
                        acPoints[1] = new POINT2(pOriginalLinePoints[j + 1]);
                        lineutility.GetSAAFRFillSegment(acPoints, dMBR);
                        shape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                        shape.moveTo(acPoints[0]);
                        shape.lineTo(acPoints[1]);
                        shape.lineTo(acPoints[2]);
                        shape.lineTo(acPoints[3]);
                        shapes.add(0, shape);
                    }
                    break;
                }
                case 22522100: {
                    int outLineCounter = 0;
                    POINT2[] ptOutline = new POINT2[4];
                    for (k = 0; k < acCounter; ++k) {
                        if (pLinePoints[k].style != 10) continue;
                        shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                        shape.moveTo(pLinePoints[k - 2]);
                        shape.lineTo(pLinePoints[k]);
                        if (shape != null && shape.getShape() != null) {
                            shapes.add(shape);
                        }
                        ptOutline[outLineCounter++] = pLinePoints[k - 2];
                        ptOutline[outLineCounter++] = pLinePoints[k];
                    }
                    break;
                }
                case 22139000: 
                case 23131200: 
                case 23132000: 
                case 23172000: 
                case 23173000: 
                case 23174000: 
                case 23211000: 
                case 23212000: 
                case 23213000: 
                case 23223000: 
                case 31131000: 
                case 31131200: 
                case 31131300: 
                case 31132000: 
                case 31132200: 
                case 31132300: 
                case 31133000: 
                case 31133200: 
                case 211210000: {
                    for (k = 0; k < acCounter; ++k) {
                        if (k == 0) {
                            if (pLinePoints[k].style == 9) {
                                shape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                                shape.set_Style(pLinePoints[k].style);
                                shape.moveTo(pLinePoints[k]);
                            }
                        } else {
                            if (pLinePoints[k].style == 9 && pLinePoints[k - 1].style != 9) {
                                shape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                                shape.set_Style(pLinePoints[k].style);
                                shape.moveTo(pLinePoints[k]);
                            }
                            if (pLinePoints[k].style == 9 && pLinePoints[k - 1].style == 9) {
                                shape.lineTo(pLinePoints[k]);
                            }
                        }
                        if (pLinePoints[k].style != 10) continue;
                        shape.lineTo(pLinePoints[k]);
                        if (shape == null || shape.getShape() == null) continue;
                        shapes.add(0, shape);
                    }
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetLineArray2Double", new RendererException("GetLineArray2Dboule " + Integer.toString(tg.get_LineType()), exc));
        }
        return points;
    }

    private static void addPolyline(POINT2[] pLinePoints, int acCounter, ArrayList<Shape2> shapes) {
        Shape2 shape = null;
        boolean beginLine = true;
        for (int k = 0; k < acCounter; ++k) {
            if (shape == null) {
                shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
            }
            if (beginLine) {
                if (k == 0) {
                    shape.set_Style(pLinePoints[k].style);
                }
                if (k > 0 && (pLinePoints[k].style == 5 && pLinePoints[k - 1].style == 5 && k < acCounter - 1 || pLinePoints[k].style == 5 && pLinePoints[k - 1].style == 10) || k == 0 && pLinePoints.length > 1 && pLinePoints[k].style == 5 && pLinePoints[k + 1].style == 5) continue;
                shape.moveTo(pLinePoints[k]);
                beginLine = false;
            } else {
                shape.lineTo(pLinePoints[k]);
                if (pLinePoints[k].style == 5 || pLinePoints[k].style == 10) {
                    beginLine = true;
                }
            }
            if (k != acCounter - 1 || shape == null || shape.getShape() == null) continue;
            shapes.add(shape);
        }
    }

    public static int SupplyRouteArrowSide(POINT2 pt0, POINT2 pt1) {
        ref<double[]> m = new ref<double[]>();
        int bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
        if (pt0.x < pt1.x) {
            if (((double[])m.value)[0] < 1.0) {
                return 2;
            }
            if (((double[])m.value)[0] >= 1.0) {
                return 1;
            }
        } else if (pt0.x > pt1.x) {
            if (((double[])m.value)[0] < 1.0) {
                return 3;
            }
            if (((double[])m.value)[0] >= 1.0) {
                return 0;
            }
        } else if (bolVertical == 0) {
            if (pt0.y > pt1.y) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public static double getScaledSize(double originalSize, double lineWidth, double patternScale) {
        if (lineWidth <= 3.0) {
            return originalSize;
        }
        if (lineWidth > 100.0) {
            lineWidth = 100.0;
        }
        return originalSize * (1.0 + (lineWidth - 3.0) / 2.0 * patternScale);
    }
}

