/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.JavaTacticalRenderer;

import armyc2.c5isr.JavaLineArray.Channels;
import armyc2.c5isr.JavaLineArray.POINT2;
import armyc2.c5isr.JavaLineArray.Shape2;
import armyc2.c5isr.JavaLineArray.arraysupport;
import armyc2.c5isr.JavaLineArray.lineutility;
import armyc2.c5isr.JavaTacticalRenderer.TGLight;
import armyc2.c5isr.JavaTacticalRenderer.clsUtility;
import armyc2.c5isr.JavaTacticalRenderer.mdlGeodesic;
import armyc2.c5isr.renderer.SinglePointRenderer;
import armyc2.c5isr.renderer.utilities.EntityCode;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.renderer.utilities.ImageInfo;
import armyc2.c5isr.renderer.utilities.RendererException;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.RendererUtilities;
import armyc2.c5isr.renderer.utilities.ShapeInfo;
import armyc2.c5isr.renderer.utilities.SymbolID;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;

public class Modifier2 {
    private POINT2[] textPath = new POINT2[2];
    private String textID;
    private String featureID;
    private String text;
    private BufferedImage image;
    private int iteration;
    private int justify;
    private int type;
    private double lineFactor;
    private static final String _className = "Modifier2";
    @Deprecated
    private boolean isIntegral = false;
    private boolean fitsMBR = true;
    private static final int toEnd = 1;
    private static final int aboveMiddle = 2;
    private static final int area = 3;
    private static final int screen = 4;
    private static final int aboveEnd = 5;
    private static final int aboveMiddlePerpendicular = 6;
    private static final int aboveStartInside = 7;
    private static final int aboveEndInside = 8;
    private static final int areaImage = 9;
    private static double fillAlphaCanObscureText = 50.0;

    Modifier2() {
    }

    private static boolean DoublesBack(POINT2 pt0, POINT2 pt1, POINT2 pt2) {
        boolean result = true;
        try {
            double theta1 = Math.atan2(pt2.y - pt1.y, pt2.x - pt1.x);
            double theta0 = Math.atan2(pt0.y - pt1.y, pt0.x - pt1.x);
            double beta = Math.abs(theta0 - theta1);
            if (beta > 0.1) {
                result = false;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DoublesBack", new RendererException("Failed inside DoublesBack", exc));
        }
        return result;
    }

    private static String GetCenterLabel(TGLight tg) {
        String label = "";
        try {
            switch (tg.get_LineType()) {
                case 25200401: 
                case 25200402: {
                    label = "AOI";
                    break;
                }
                case 25200201: 
                case 25200202: {
                    label = "DA";
                    break;
                }
                case 25200300: {
                    label = "N";
                    break;
                }
                case 25200101: {
                    label = "LA";
                    break;
                }
                case 25170400: {
                    label = "SL";
                    break;
                }
                case 25170600: {
                    label = "TC";
                    break;
                }
                case 25171100: {
                    label = "AARROZ";
                    break;
                }
                case 25171200: {
                    label = "UAROZ";
                    break;
                }
                case 25171300: {
                    label = "WEZ";
                    break;
                }
                case 25171400: {
                    label = "FEZ";
                    break;
                }
                case 25171500: {
                    label = "JEZ";
                    break;
                }
                case 25190100: {
                    label = "IFF OFF";
                    break;
                }
                case 25190200: {
                    label = "IFF ON";
                    break;
                }
                case 25260400: 
                case 1325260400: {
                    label = "BCL";
                    break;
                }
                case 25300100: {
                    label = "ICL";
                    break;
                }
                case 25140400: {
                    label = "FEBA";
                    break;
                }
                case 25170800: {
                    label = "BDZ";
                    break;
                }
                case 150501: {
                    label = "JTAA";
                    break;
                }
                case 150502: {
                    label = "SAA";
                    break;
                }
                case 150503: {
                    label = "SGAA";
                    break;
                }
                case 22531000: {
                    label = "ASLT";
                    break;
                }
                case 22223000: {
                    label = "SAAFR";
                    break;
                }
                case 22221000: {
                    label = "AC";
                    break;
                }
                case 212100000: 
                case 212300000: {
                    label = "S";
                    break;
                }
                case 211900000: {
                    label = "R";
                    break;
                }
                case 211700000: {
                    label = "P";
                    break;
                }
                case 211600000: {
                    label = "O";
                    break;
                }
                case 211400000: {
                    label = "I";
                    break;
                }
                case 211100000: {
                    label = "F";
                    break;
                }
                case 211000000: {
                    label = "D";
                    break;
                }
                case 21400000: 
                case 21500000: {
                    label = "C";
                    break;
                }
                case 21200000: 
                case 21300000: {
                    label = "B";
                    break;
                }
                case 212600000: {
                    label = "C/K";
                    break;
                }
                case 212500000: {
                    label = "C/S";
                    break;
                }
                case 23180000: {
                    label = "UXO";
                    break;
                }
                case 212000000: {
                    label = "R";
                    break;
                }
                case 25344100: {
                    label = "P(F)";
                    break;
                }
                case 25344200: {
                    label = "P(R)";
                    break;
                }
                case 22623000: 
                case 22623001: {
                    if (SymbolID.getVersion(tg.get_SymbolId()) >= 13) {
                        label = "BL";
                        break;
                    }
                    label = "B";
                    break;
                }
                case 22612000: 
                case 22612001: {
                    label = "HL";
                    break;
                }
                case 22124000: {
                    label = "PL";
                    break;
                }
                case 22125000: {
                    label = "LL";
                    break;
                }
                case 110300: {
                    label = "EWL";
                    break;
                }
                case 212210000: {
                    label = "S";
                    break;
                }
                case 212230000: {
                    label = "C";
                    break;
                }
                case 212220000: {
                    label = "G";
                    break;
                }
                case 211800000: {
                    label = "RIP";
                    break;
                }
                case 212400000: {
                    label = "W";
                    break;
                }
                case 212410000: {
                    label = "WP";
                    break;
                }
                case 21700000: 
                case 21710000: {
                    label = "CATK";
                    break;
                }
                case 22122000: {
                    label = "FLOT";
                    break;
                }
                case 22123000: {
                    label = "LC";
                    break;
                }
                case 22132000: {
                    label = "AA";
                    break;
                }
                case 22133000: {
                    label = "EA";
                    break;
                }
                case 22135000: {
                    label = "DZ";
                    break;
                }
                case 22136000: {
                    label = "EZ";
                    break;
                }
                case 22137000: {
                    label = "LZ";
                    break;
                }
                case 221310000: {
                    label = "LAA";
                    break;
                }
                case 22138000: {
                    label = "PZ";
                    break;
                }
                case 22222000: {
                    label = "MRR";
                    break;
                }
                case 22224000: {
                    label = "SC";
                    break;
                }
                case 22225000: {
                    label = "LLTR";
                    break;
                }
                case 22231000: {
                    label = "ROZ";
                    break;
                }
                case 22232000: {
                    label = "SHORADEZ";
                    break;
                }
                case 22233000: {
                    label = "HIDACZ";
                    break;
                }
                case 22234000: {
                    label = "MEZ";
                    break;
                }
                case 22234100: {
                    label = "LOMEZ";
                    break;
                }
                case 22234200: {
                    label = "HIMEZ";
                    break;
                }
                case 22235000: {
                    label = "WFZ";
                    break;
                }
                case 270801: 
                case 23164000: {
                    label = "M";
                    break;
                }
                case 22431100: {
                    label = "(P)";
                    break;
                }
                case 22535000: {
                    label = "OBJ";
                    break;
                }
                case 22625000: {
                    label = "NAI";
                    break;
                }
                case 22626000: {
                    label = "TAI";
                    break;
                }
                case 11120500: 
                case 13120500: {
                    label = "BC";
                    break;
                }
                case 11120600: 
                case 13120600: {
                    label = "GB";
                    break;
                }
                case 24211000: {
                    label = "SMOKE";
                    break;
                }
                case 24260000: {
                    label = "FPF";
                    break;
                }
                case 22532000: {
                    label = "ATK";
                    break;
                }
                case 22523000: {
                    label = "FCL";
                    break;
                }
                case 22525000: {
                    label = "LOA";
                    break;
                }
                case 22526000: {
                    label = "LD";
                    break;
                }
                case 22528000: {
                    label = "PLD";
                    break;
                }
                case 21800000: {
                    label = "D";
                    break;
                }
                case 22613000: {
                    label = "RL";
                    break;
                }
                case 25141800: {
                    label = "HOL";
                    break;
                }
                case 2514190: {
                    label = "BHL";
                    break;
                }
                case 24314000: {
                    label = "SMOKE";
                    break;
                }
                case 24230000: {
                    label = "NFL";
                    break;
                }
                case 24225000: {
                    label = "MFP";
                    break;
                }
                case 24210000: {
                    label = "FSCL";
                    break;
                }
                case 24220000: {
                    label = "CFL";
                    break;
                }
                case 24240000: {
                    label = "RFL";
                    break;
                }
                case 22621000: {
                    label = "AO";
                    break;
                }
                case 24315000: {
                    label = "BOMB";
                    break;
                }
                case 24226000: {
                    label = "TGMF";
                    break;
                }
                case 24321100: {
                    label = "FSA";
                    break;
                }
                case 24321200: 
                case 24321300: {
                    label = "FSA";
                    break;
                }
                case 24322100: 
                case 24322200: 
                case 24322300: {
                    label = "ACA";
                    break;
                }
                case 24323100: 
                case 24323200: 
                case 24323300: {
                    label = "FFA";
                    break;
                }
                case 24324100: 
                case 24324200: 
                case 24324300: {
                    label = "NFA";
                    break;
                }
                case 24325100: 
                case 24325200: 
                case 24325300: {
                    label = "RFA";
                    break;
                }
                case 24331100: 
                case 24331200: 
                case 24331300: {
                    label = "ATI ZONE";
                    break;
                }
                case 24326100: 
                case 24326200: 
                case 243100000: {
                    label = "PAA";
                    break;
                }
                case 24332100: 
                case 24332200: 
                case 24332300: {
                    label = "CFF ZONE";
                    break;
                }
                case 24336100: 
                case 24336200: 
                case 24336300: {
                    label = "CF ZONE";
                    break;
                }
                case 24333100: 
                case 24333200: 
                case 24333300: {
                    label = "SENSOR ZONE";
                    break;
                }
                case 24334100: 
                case 24334200: 
                case 24334300: {
                    label = "CENSOR ZONE";
                    break;
                }
                case 24335100: 
                case 24335200: 
                case 24335300: {
                    label = "DA";
                    break;
                }
                case 24337100: 
                case 24337200: 
                case 24337300: {
                    label = "ZOR";
                    break;
                }
                case 24338100: 
                case 24338200: 
                case 24338300: {
                    label = "TBA";
                    break;
                }
                case 24339100: 
                case 24339200: 
                case 24339300: {
                    label = "TVAR";
                    break;
                }
                case 24351000: 
                case 24352000: 
                case 24353000: {
                    label = "BKB";
                    break;
                }
                case 24361000: 
                case 24362000: 
                case 24363000: {
                    label = "PKB";
                    break;
                }
                case 25221000: 
                case 25330301: 
                case 25330302: 
                case 25330303: {
                    label = "MSR";
                    break;
                }
                case 25222000: 
                case 25330401: 
                case 25330402: 
                case 25330403: {
                    label = "ASR";
                    break;
                }
                case 25330500: 
                case 25330501: 
                case 25330502: {
                    label = "ROUTE";
                    break;
                }
                case 22527000: {
                    label = "LD/LC";
                    break;
                }
                case 22622000: {
                    label = "AIRHEAD LINE";
                    break;
                }
                case 21100000: 
                case 26400000: {
                    label = "B";
                    break;
                }
                case 220107: {
                    label = "J";
                    break;
                }
                case 220108: {
                    label = "RDF";
                    break;
                }
                case 26410000: {
                    label = "E";
                    break;
                }
                case 220101: {
                    label = "EW";
                    break;
                }
                case 220104: 
                case 26420000: {
                    label = "A";
                    break;
                }
                case 26430000: {
                    label = "T";
                    break;
                }
                case 26440000: {
                    label = "O";
                    break;
                }
                case 1325310000: {
                    label = "DHA";
                    break;
                }
                case 25330000: {
                    label = "FARP";
                    break;
                }
                case 25351000: {
                    label = "BSA";
                    break;
                }
                case 25352000: {
                    label = "DSA";
                    break;
                }
                case 25310800: {
                    label = "CSA";
                    break;
                }
                case 25353000: {
                    label = "RSA";
                    break;
                }
                case 21600000: {
                    label = "C";
                    break;
                }
                case 23114000: {
                    label = "FREE";
                    break;
                }
                case 231100000: {
                    label = "t";
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetCenterLabel", new RendererException("Failed inside GetCenterLabel", exc));
        }
        return label;
    }

    public POINT2[] get_TextPath() {
        return this.textPath;
    }

    protected void set_TextPath(POINT2[] value) {
        this.textPath = value;
    }

    @Deprecated
    protected void set_IsIntegral(boolean value) {
        this.isIntegral = value;
    }

    @Deprecated
    protected boolean get_IsIntegral() {
        return this.isIntegral;
    }

    private static void AddOffsetModifier(TGLight tg, String text, int type, double lineFactor, int startIndex, int endIndex, double spaces, String rightOrLeft) {
        if (rightOrLeft == null || tg.Pixels == null || tg.Pixels.size() < 2 || endIndex >= tg.Pixels.size()) {
            return;
        }
        POINT2 pt0 = tg.Pixels.get(startIndex);
        POINT2 pt1 = tg.Pixels.get(endIndex);
        if (rightOrLeft.equals("left")) {
            pt0.x -= spaces;
            pt1.x -= spaces;
        } else {
            pt0.x += spaces;
            pt1.x += spaces;
        }
        Modifier2.AddModifier2(tg, text, type, lineFactor, pt0, pt1, false);
    }

    private static void AddModifier(TGLight tg, String text, int type, double lineFactor, POINT2 ptStart, POINT2 ptEnd) {
        if (tg.Pixels == null || tg.Pixels.size() < 2) {
            return;
        }
        Modifier2.AddModifier2(tg, text, type, lineFactor, ptStart, ptEnd, false);
    }

    private static void AddModifier2(TGLight tg, String text, int type, double lineFactor, POINT2 pt0, POINT2 pt1, boolean isIntegral) {
        Modifier2.AddModifier2(tg, text, type, lineFactor, pt0, pt1, isIntegral, null);
    }

    private static void AddModifier2(TGLight tg, String text, int type, double lineFactor, POINT2 pt0, POINT2 pt1, boolean isIntegral, String modifierType) {
        try {
            if (text == null || text.equals("")) {
                return;
            }
            Modifier2 modifier = new Modifier2();
            modifier.set_IsIntegral(isIntegral);
            modifier.text = text;
            modifier.type = type;
            modifier.lineFactor = lineFactor;
            modifier.textPath[0] = pt0;
            modifier.textPath[1] = pt1;
            modifier.textID = modifierType;
            tg.modifiers.add(modifier);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifier", new RendererException("Failed inside AddModifier", exc));
        }
    }

    private static void AddIntegralModifier(TGLight tg, String text, int type, double lineFactor, int startIndex, int endIndex) {
        Modifier2.AddIntegralModifier(tg, text, type, lineFactor, startIndex, endIndex, true);
    }

    private static void AddIntegralModifier(TGLight tg, String text, int type, double lineFactor, int startIndex, int endIndex, Boolean isIntegral) {
        Modifier2.AddIntegralModifier(tg, text, type, lineFactor, startIndex, endIndex, isIntegral, null);
    }

    private static void AddIntegralModifier(TGLight tg, String text, int type, double lineFactor, int startIndex, int endIndex, Boolean isIntegral, String modifierType) {
        if (tg.Pixels == null || tg.Pixels.isEmpty() || endIndex >= tg.Pixels.size()) {
            return;
        }
        Modifier2.AddIntegralAreaModifier(tg, text, type, lineFactor, tg.Pixels.get(startIndex), tg.Pixels.get(endIndex), isIntegral, modifierType);
    }

    private static void AddAreaModifier(TGLight tg, String text, int type, double lineFactor, POINT2 pt0, POINT2 pt1) {
        Modifier2.AddIntegralAreaModifier(tg, text, type, lineFactor, pt0, pt1, (Boolean)true);
    }

    private static void AddAreaModifier(TGLight tg, String text, int type, double lineFactor, POINT2 pt0, POINT2 pt1, String modifierType) {
        Modifier2.AddIntegralAreaModifier(tg, text, type, lineFactor, pt0, pt1, true, modifierType);
    }

    private static void AddIntegralAreaModifier(TGLight tg, String text, int type, double lineFactor, POINT2 pt0, POINT2 pt1, Boolean isIntegral) {
        Modifier2.AddIntegralAreaModifier(tg, text, type, lineFactor, pt0, pt1, isIntegral, null);
    }

    private static void AddIntegralAreaModifier(TGLight tg, BufferedImage image, int type, double lineFactor, POINT2 pt0, POINT2 pt1, Boolean isIntegral) {
        try {
            if (image == null || image.equals("")) {
                return;
            }
            Modifier2 modifier = new Modifier2();
            modifier.set_IsIntegral(isIntegral);
            modifier.image = image;
            if (image == null || image.equals("")) {
                return;
            }
            if (pt0 == null || pt1 == null) {
                return;
            }
            modifier.type = type;
            modifier.lineFactor = lineFactor;
            modifier.textPath[0] = pt0;
            modifier.textPath[1] = pt1;
            tg.modifiers.add(modifier);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddAreaModifier", new RendererException("Failed inside AddAreaModifier", exc));
        }
    }

    private static void AddIntegralAreaModifier(TGLight tg, String text, int type, double lineFactor, POINT2 pt0, POINT2 pt1, Boolean isIntegral, String modifierType) {
        if (pt0 == null || pt1 == null) {
            return;
        }
        Modifier2.AddModifier2(tg, text, type, lineFactor, pt0, pt1, isIntegral, modifierType);
    }

    public static void GetMBR(TGLight tg, POINT2 ptUl, POINT2 ptUr, POINT2 ptLr, POINT2 ptLl) {
        try {
            int j = 0;
            double x = 0.0;
            double y = 0.0;
            ptUl.x = tg.Pixels.get((int)0).x;
            ptUl.y = tg.Pixels.get((int)0).y;
            ptUr.x = tg.Pixels.get((int)0).x;
            ptUr.y = tg.Pixels.get((int)0).y;
            ptLl.x = tg.Pixels.get((int)0).x;
            ptLl.y = tg.Pixels.get((int)0).y;
            ptLr.x = tg.Pixels.get((int)0).x;
            ptLr.y = tg.Pixels.get((int)0).y;
            int n = tg.Pixels.size();
            for (j = 1; j < n; ++j) {
                x = tg.Pixels.get((int)j).x;
                y = tg.Pixels.get((int)j).y;
                if (x < ptLl.x) {
                    ptLl.x = x;
                    ptUl.x = x;
                }
                if (x > ptLr.x) {
                    ptLr.x = x;
                    ptUr.x = x;
                }
                if (y > ptLl.y) {
                    ptLl.y = y;
                    ptLr.y = y;
                }
                if (!(y < ptUl.y)) continue;
                ptUl.y = y;
                ptUr.y = y;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetMBR", new RendererException("Failed inside GetMBR", exc));
        }
    }

    private static boolean GetBoundarySegmentTooShort(TGLight tg, Graphics2D g2d, int middleSegment) {
        boolean lineTooShort = false;
        try {
            int totalWidth;
            g2d.setFont(tg.get_Font());
            FontMetrics metrics = g2d.getFontMetrics();
            String echelonSymbol = null;
            int stringWidthEchelonSymbol = 0;
            POINT2 pt0 = tg.Pixels.get(middleSegment);
            POINT2 pt1 = tg.Pixels.get(middleSegment + 1);
            double dist = lineutility.CalcDistanceDouble(pt0, pt1);
            echelonSymbol = tg.get_EchelonSymbol();
            if (echelonSymbol != null) {
                stringWidthEchelonSymbol = metrics.stringWidth(echelonSymbol);
            }
            int tWidth = 0;
            int t1Width = 0;
            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                tWidth = metrics.stringWidth(tg.get_Name());
            }
            if (tg.get_T1() != null && !tg.get_T1().isEmpty()) {
                t1Width = metrics.stringWidth(tg.get_T1());
            }
            if ((totalWidth = stringWidthEchelonSymbol) < tWidth) {
                totalWidth = tWidth;
            }
            if (totalWidth < t1Width) {
                totalWidth = t1Width;
            }
            switch (tg.get_LineType()) {
                case 22121000: {
                    if (!(dist < 1.25 * (double)totalWidth)) break;
                    lineTooShort = true;
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetBoundaryLineTooShort", new RendererException("Failed inside GetBoundaryLineTooShort", exc));
        }
        return lineTooShort;
    }

    private static void AddBoundaryModifiers(TGLight tg, Graphics2D g2d, Object clipBounds) {
        try {
            int middleSegment;
            int j = 0;
            double csFactor = 1.0;
            Boolean foundSegment = false;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            Object ptLast = null;
            double TLineFactor = 0.0;
            double T1LineFactor = 0.0;
            Boolean lineTooShort = false;
            Object countryCode = "";
            if (!tg.get_AS().equals("")) {
                countryCode = " (" + tg.get_AS() + ")";
            }
            if (tg.get_Client().equals("cpof3d")) {
                csFactor = 0.85;
            }
            for (j = middleSegment = Modifier2.getVisibleMiddleSegment(tg, clipBounds); j == middleSegment; ++j) {
                pt0 = tg.Pixels.get(j);
                pt1 = tg.Pixels.get(j + 1);
                if (pt0.x < pt1.x) {
                    TLineFactor = -1.3;
                    T1LineFactor = 1.0;
                } else if (pt0.x == pt1.x) {
                    if (pt1.y < pt0.y) {
                        TLineFactor = -1.0;
                        T1LineFactor = 1.0;
                    } else {
                        TLineFactor = 1.0;
                        T1LineFactor = -1.0;
                    }
                } else {
                    TLineFactor = 1.0;
                    T1LineFactor = -1.3;
                }
                lineTooShort = Modifier2.GetBoundarySegmentTooShort(tg, g2d, j);
                if (lineTooShort.booleanValue()) continue;
                foundSegment = true;
                Modifier2.AddIntegralModifier(tg, tg.get_Name() + (String)countryCode, 2, TLineFactor * csFactor, j, j + 1, true);
                if (tg.get_EchelonSymbol() != null && !tg.get_EchelonSymbol().equals("")) {
                    Modifier2.AddIntegralModifier(tg, tg.get_EchelonSymbol(), 2, -0.2 * csFactor, j, j + 1, true);
                }
                Modifier2.AddIntegralModifier(tg, tg.get_T1(), 2, T1LineFactor * csFactor, j, j + 1, true);
            }
            if (!foundSegment.booleanValue()) {
                pt0 = new POINT2();
                pt1 = new POINT2();
                String echelonSymbol = tg.get_EchelonSymbol();
                FontMetrics metrics = g2d.getFontMetrics();
                double modDist = 0.0;
                if (echelonSymbol != null) {
                    modDist = 1.5 * (double)metrics.stringWidth(echelonSymbol);
                }
                double segDist = lineutility.CalcDistanceDouble(tg.Pixels.get(middleSegment), tg.Pixels.get(middleSegment + 1));
                g2d.setFont(tg.get_Font());
                POINT2 midpt = lineutility.MidPointDouble(tg.Pixels.get(middleSegment), tg.Pixels.get(middleSegment + 1), 0);
                POINT2 ptTemp = null;
                if (segDist < modDist) {
                    ptTemp = lineutility.ExtendAlongLineDouble(midpt, tg.Pixels.get(middleSegment), modDist / 2.0);
                    pt0.x = ptTemp.x;
                    pt0.y = ptTemp.y;
                    ptTemp = lineutility.ExtendAlongLineDouble(midpt, tg.Pixels.get(middleSegment + 1), modDist / 2.0);
                } else {
                    ptTemp = tg.Pixels.get(middleSegment);
                    pt0.x = ptTemp.x;
                    pt0.y = ptTemp.y;
                    ptTemp = tg.Pixels.get(middleSegment + 1);
                }
                pt1.x = ptTemp.x;
                pt1.y = ptTemp.y;
                Modifier2.AddIntegralModifier(tg, tg.get_Name() + (String)countryCode, 2, TLineFactor * csFactor, middleSegment, middleSegment + 1, true);
                if (echelonSymbol != null && !echelonSymbol.equals("")) {
                    Modifier2.AddIntegralModifier(tg, echelonSymbol, 2, -0.202 * csFactor, middleSegment, middleSegment + 1, true);
                }
                Modifier2.AddIntegralModifier(tg, tg.get_T1(), 2, T1LineFactor * csFactor, middleSegment, middleSegment + 1, true);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddBoundaryModifiers", new RendererException("Failed inside AddBoundaryModifiers", exc));
        }
    }

    private static void AddNameAboveDTG(TGLight tg, FontMetrics metrics) {
        try {
            double csFactor = 1.0;
            if (tg.get_Client().equals("cpof3d")) {
                csFactor = 0.667;
            }
            String label = Modifier2.GetCenterLabel(tg);
            POINT2 pt0 = new POINT2(tg.Pixels.get(0));
            POINT2 pt1 = new POINT2(tg.Pixels.get(1));
            int lastIndex = tg.Pixels.size() - 1;
            int nextToLastIndex = tg.Pixels.size() - 2;
            POINT2 ptLast = new POINT2(tg.Pixels.get(lastIndex));
            POINT2 ptNextToLast = new POINT2(tg.Pixels.get(nextToLastIndex));
            Modifier2.shiftModifierPath(tg, pt0, pt1, ptLast, ptNextToLast);
            double stringWidth = metrics.stringWidth(label + " " + tg.get_Name());
            Modifier2.AddIntegralAreaModifier(tg, label + " " + tg.get_Name(), 1, 0.0, pt0, pt1, (Boolean)false);
            pt1 = lineutility.ExtendAlongLineDouble(tg.Pixels.get(0), tg.Pixels.get(1), -1.5 * stringWidth);
            Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
            Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
            Modifier2.AddIntegralAreaModifier(tg, label + " " + tg.get_Name(), 1, 0.0, ptLast, ptNextToLast, (Boolean)false);
            pt0 = tg.Pixels.get(lastIndex);
            pt1 = lineutility.ExtendAlongLineDouble(tg.Pixels.get(lastIndex), tg.Pixels.get(nextToLastIndex), -1.5 * stringWidth);
            Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
            Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddNameAboveDTG", new RendererException("Failed inside AddNameAboveDTG", exc));
        }
    }

    private static void shiftModifierPath(TGLight tg, POINT2 pt0, POINT2 pt1, POINT2 ptLast, POINT2 ptNextToLast) {
        try {
            POINT2 p0 = null;
            POINT2 p1 = null;
            double last = -1.0;
            switch (tg.get_LineType()) {
                case 22121000: {
                    for (int j = 0; j < tg.Pixels.size() - 1; ++j) {
                        p0 = tg.Pixels.get(j);
                        p1 = tg.Pixels.get(j + 1);
                        if (!(Math.abs(p0.x - p1.x) < 1.0)) continue;
                        p1.x += last;
                        last = -last;
                    }
                    break;
                }
                case 110300: 
                case 2514190: 
                case 22122000: 
                case 22123000: 
                case 22124000: 
                case 22125000: 
                case 22422000: 
                case 22523000: 
                case 22525000: 
                case 22526000: 
                case 22527000: 
                case 22528000: 
                case 22612000: 
                case 22612001: 
                case 22613000: 
                case 22623000: 
                case 22623001: 
                case 24230000: 
                case 25140400: 
                case 25141800: {
                    if (pt0 != null && pt1 != null && Math.abs(pt0.x - pt1.x) < 1.0) {
                        pt1.x += 1.0;
                    }
                    if (ptLast != null && ptNextToLast != null && Math.abs(ptNextToLast.x - ptLast.x) < 1.0) {
                        ptNextToLast.x += 1.0;
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "shiftModifierPath", new RendererException("Failed inside shiftModifierPath", exc));
        }
    }

    private static void addModifierOnLine(String label, TGLight tg, boolean twoLabelOnly) {
        if (label == null || label.isEmpty() || tg.Pixels.isEmpty()) {
            return;
        }
        try {
            POINT2 leftPt = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
            POINT2 rightPt = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
            POINT2 topPt = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
            POINT2 bottomPt = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
            for (int j = 1; j < tg.Pixels.size() - 1; ++j) {
                POINT2 midPt = lineutility.MidPointDouble(tg.Pixels.get(j), tg.Pixels.get(j + 1), 0);
                if (midPt.x <= leftPt.x) {
                    leftPt = midPt;
                }
                if (midPt.x >= rightPt.x) {
                    rightPt = midPt;
                }
                if (midPt.y <= topPt.y) {
                    topPt = midPt;
                }
                if (!(midPt.y >= bottomPt.y)) continue;
                bottomPt = midPt;
            }
            if (leftPt != rightPt) {
                Modifier2.AddAreaModifier(tg, label, 2, 0.0, leftPt, leftPt);
            }
            Modifier2.AddAreaModifier(tg, label, 2, 0.0, rightPt, rightPt);
            if (!twoLabelOnly) {
                if (bottomPt != leftPt && bottomPt != rightPt) {
                    Modifier2.AddAreaModifier(tg, label, 2, 0.0, bottomPt, bottomPt);
                }
                if (topPt != leftPt && topPt != rightPt && topPt != bottomPt) {
                    Modifier2.AddAreaModifier(tg, label, 2, 0.0, topPt, topPt);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "addModifierOnLine", new RendererException("Failed inside addModifierOnLine", exc));
        }
    }

    private static void addModifierOnLine(String label, TGLight tg) {
        Modifier2.addModifierOnLine(label, tg, false);
    }

    private static void addNModifier(TGLight tg) {
        if (tg.isHostile()) {
            Modifier2.addModifierOnLine(tg.get_N(), tg, true);
        }
    }

    private static void addModifierBottomSegment(TGLight tg, String text) {
        int index = 0;
        double y = tg.Pixels.get((int)index).y + tg.Pixels.get((int)(index + 1)).y;
        for (int i = 1; i < tg.Pixels.size() - 1; ++i) {
            if (!(tg.Pixels.get((int)i).y + tg.Pixels.get((int)(i + 1)).y > y)) continue;
            index = i;
            y = tg.Pixels.get((int)index).y + tg.Pixels.get((int)(index + 1)).y;
        }
        Modifier2.AddIntegralModifier(tg, text, 2, 0.0, index, index + 1, false);
    }

    private static void addModifierTopSegment(TGLight tg, String text) {
        int index = 0;
        double y = tg.Pixels.get((int)index).y + tg.Pixels.get((int)(index + 1)).y;
        for (int i = 1; i < tg.Pixels.size() - 1; ++i) {
            if (!(tg.Pixels.get((int)i).y + tg.Pixels.get((int)(i + 1)).y < y)) continue;
            index = i;
            y = tg.Pixels.get((int)index).y + tg.Pixels.get((int)(index + 1)).y;
        }
        Modifier2.AddIntegralModifier(tg, text, 2, 0.0, index, index + 1, false);
    }

    private static void addDTG(TGLight tg, int type, double lineFactor1, double lineFactor2, POINT2 pt0, POINT2 pt1, FontMetrics metrics) {
        String combinedDTG;
        double stringWidth;
        double maxDTGWidth;
        if (pt0 == null || pt1 == null) {
            return;
        }
        if (pt0.x == pt1.x && pt0.y == pt1.y) {
            POINT2 ptUl = new POINT2();
            POINT2 ptUr = new POINT2();
            POINT2 ptLr = new POINT2();
            POINT2 ptLl = new POINT2();
            Modifier2.GetMBR(tg, ptUl, ptUr, ptLr, ptLl);
            maxDTGWidth = lineutility.CalcDistanceDouble(ptUl, ptUr);
        } else {
            maxDTGWidth = lineutility.CalcDistanceDouble(pt0, pt1);
        }
        String dash = "";
        if (tg.get_DTG() != null && tg.get_DTG1() != null && !tg.get_DTG().isEmpty() && !tg.get_DTG1().isEmpty()) {
            dash = " - ";
        }
        if ((stringWidth = (double)metrics.stringWidth(combinedDTG = tg.get_DTG() + dash + tg.get_DTG1())) < maxDTGWidth) {
            Modifier2.AddModifier(tg, combinedDTG, type, lineFactor1, pt0, pt1);
        } else {
            Modifier2.AddModifier(tg, tg.get_DTG() + dash, type, Math.min(lineFactor1, lineFactor2), pt0, pt1);
            Modifier2.AddModifier(tg, tg.get_DTG1(), type, Math.max(lineFactor1, lineFactor2), pt0, pt1);
        }
    }

    private static int getVisibleMiddleSegment(TGLight tg, Object clipBounds) {
        int middleSegment = -1;
        try {
            int j;
            boolean useClipRect;
            Polygon clipBoundsPoly = null;
            Rectangle2D clipRect = null;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            double dist = 0.0;
            POINT2 lastPt = null;
            long lineType = tg.get_LineType();
            middleSegment = (tg.Pixels.size() + 1) / 2 - 1;
            boolean foundVisibleSegment = false;
            if (clipBounds == null) {
                return middleSegment;
            }
            if (ArrayList.class.isAssignableFrom(clipBounds.getClass())) {
                useClipRect = false;
                clipBoundsPoly = new Polygon();
                ArrayList clipArray = (ArrayList)clipBounds;
                for (int j2 = 0; j2 < clipArray.size(); ++j2) {
                    int x = (int)((Point2D)clipArray.get(j2)).getX();
                    int y = (int)((Point2D)clipArray.get(j2)).getY();
                    clipBoundsPoly.addPoint(x, y);
                }
            } else if (Rectangle2D.class.isAssignableFrom(clipBounds.getClass())) {
                useClipRect = true;
                clipRect = (Rectangle2D)clipBounds;
            } else {
                return middleSegment;
            }
            for (j = middleSegment; j < tg.Pixels.size() - 1; ++j) {
                pt0 = tg.Pixels.get(j);
                dist = lineutility.CalcDistanceDouble(pt0, pt1 = tg.Pixels.get(j + 1));
                if (dist < 5.0) continue;
                if (j > 0 && lineType == 22121000L) {
                    if (lastPt == null) {
                        lastPt = tg.Pixels.get(j - 1);
                    }
                    if (Modifier2.DoublesBack(lastPt, pt0, pt1)) continue;
                    lastPt = null;
                }
                if (!useClipRect) {
                    if (!clipBoundsPoly.contains(pt0.x, pt0.y) && !clipBoundsPoly.contains(pt1.x, pt1.y)) continue;
                    middleSegment = j;
                    foundVisibleSegment = true;
                    break;
                }
                if (!clipRect.contains(pt0.x, pt0.y) && !clipRect.contains(pt1.x, pt1.y)) continue;
                middleSegment = j;
                foundVisibleSegment = true;
                break;
            }
            if (!foundVisibleSegment) {
                for (j = middleSegment; j > 0; --j) {
                    pt0 = tg.Pixels.get(j);
                    dist = lineutility.CalcDistanceDouble(pt0, pt1 = tg.Pixels.get(j - 1));
                    if (dist < 5.0) continue;
                    if (lineType == 22121000L) {
                        if (lastPt == null) {
                            lastPt = tg.Pixels.get(j - 1);
                        }
                        if (Modifier2.DoublesBack(lastPt, pt0, pt1)) continue;
                        lastPt = null;
                    }
                    if (!useClipRect) {
                        if (!clipBoundsPoly.contains(pt0.x, pt0.y) && !clipBoundsPoly.contains(pt1.x, pt1.y)) continue;
                        middleSegment = j - 1;
                        foundVisibleSegment = true;
                        break;
                    }
                    if (!clipRect.contains(pt0.x, pt0.y) && !clipRect.contains(pt1.x, pt1.y)) continue;
                    middleSegment = j - 1;
                    foundVisibleSegment = true;
                    break;
                }
            }
            if (!foundVisibleSegment) {
                middleSegment = tg.Pixels.size() / 2 - 1;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getMiddleSegment", new RendererException("Failed inside getMiddleSegment", exc));
        }
        return middleSegment;
    }

    private static void removeModifier(TGLight tg, String modifierType) {
        try {
            int j = 0;
            Modifier2 modifier = null;
            int n = tg.Pixels.size();
            for (j = 0; j < n; ++j) {
                modifier = tg.modifiers.get(j);
                if (modifier.textID == null || !modifier.textID.equalsIgnoreCase(modifierType)) continue;
                tg.modifiers.remove(modifier);
                break;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "removeModifier", new RendererException("Failed inside removeModifier", exc));
        }
    }

    public static void RemoveModifiers(TGLight tg, Graphics2D g2d, boolean isTextFlipped, int iteration) {
        try {
            if (!tg.get_Client().equalsIgnoreCase("cpof2d") && !tg.get_Client().equalsIgnoreCase("cpof3d")) {
                return;
            }
            int j = 0;
            Polygon mbrPoly = null;
            switch (tg.get_LineType()) {
                case 24311000: 
                case 24312000: 
                case 24321200: 
                case 24321300: 
                case 24322200: 
                case 24322300: 
                case 24323200: 
                case 24323300: 
                case 24324200: 
                case 24324300: 
                case 24325200: 
                case 24325300: 
                case 24331200: 
                case 24331300: 
                case 24332200: 
                case 24332300: 
                case 24333200: 
                case 24333300: 
                case 24334200: 
                case 24334300: 
                case 24335200: 
                case 24335300: 
                case 24336200: 
                case 24336300: 
                case 24337200: 
                case 24337300: 
                case 24338200: 
                case 24338300: 
                case 24339200: 
                case 24339300: 
                case 24352000: 
                case 24353000: 
                case 24362000: 
                case 24363000: 
                case 25170800: 
                case 25200202: 
                case 25200300: 
                case 25200402: 
                case 25200600: {
                    if (tg.modifiers == null || tg.modifiers.isEmpty() || iteration != 1) {
                        return;
                    }
                    mbrPoly = new Polygon();
                    int n = tg.Pixels.size();
                    for (j = 0; j < n; ++j) {
                        mbrPoly.addPoint((int)tg.Pixels.get((int)j).x, (int)tg.Pixels.get((int)j).y);
                    }
                    break;
                }
                default: {
                    if (!clsUtility.isClosedPolygon(tg.get_LineType()) || iteration != 0) {
                        return;
                    }
                    if (tg.modifiers == null || tg.modifiers.isEmpty()) {
                        return;
                    }
                    mbrPoly = new Polygon();
                    int t = tg.Pixels.size();
                    for (j = 0; j < t; ++j) {
                        mbrPoly.addPoint((int)tg.Pixels.get((int)j).x, (int)tg.Pixels.get((int)j).y);
                    }
                }
            }
            Font font = null;
            font = tg.get_Font();
            if (font == null) {
                font = g2d.getFont();
            }
            g2d.setFont(font);
            FontMetrics metrics = g2d.getFontMetrics();
            double stringWidth = 0.0;
            double stringHeight = 0.0;
            boolean wfits = true;
            boolean w1fits = true;
            boolean ww1fits = true;
            boolean hfits = true;
            boolean h1fits = true;
            boolean h2fits = true;
            Modifier2 modifier = null;
            String modifierType = "";
            String s = "";
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            Object pt4 = null;
            double lineFactor = 0.0;
            double x = 0.0;
            double y = 0.0;
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            int n = tg.modifiers.size();
            for (j = 0; j < n; ++j) {
                modifier = tg.modifiers.get(j);
                if (modifier.textID == null || modifier.textID.isEmpty()) continue;
                modifierType = modifier.textID;
                lineFactor = modifier.lineFactor;
                if (isTextFlipped) {
                    lineFactor = -lineFactor;
                }
                if ((s = modifier.text) == null || s.equals("")) continue;
                stringWidth = (double)metrics.stringWidth(s) + 1.0;
                stringHeight = font.getSize();
                if (modifier.type == 3) {
                    pt0 = modifier.textPath[0];
                    x1 = pt0.x;
                    y1 = pt0.y;
                    x = (int)x1 - (int)stringWidth / 2;
                    y = (int)y1 + (int)(stringHeight / 2.0) + (int)(1.25 * lineFactor * stringHeight);
                    x2 = (int)x1 + (int)stringWidth / 2;
                    y2 = (int)y1 + (int)(stringHeight / 2.0) + (int)(1.25 * lineFactor * stringHeight);
                    if (mbrPoly.contains(x, y) && mbrPoly.contains(x2, y2)) {
                        modifier.fitsMBR = true;
                        continue;
                    }
                    modifier.fitsMBR = false;
                    continue;
                }
                if (modifier.type == 2) {
                    pt0 = modifier.textPath[0];
                    pt1 = modifier.textPath[1];
                    POINT2 ptCenter = lineutility.MidPointDouble(pt0, pt1, 0);
                    pt0 = lineutility.ExtendAlongLineDouble(ptCenter, pt0, stringWidth / 2.0);
                    pt1 = lineutility.ExtendAlongLineDouble(ptCenter, pt1, stringWidth / 2.0);
                    pt2 = lineFactor >= 0.0 ? lineutility.ExtendDirectedLine(ptCenter, pt0, pt0, 3, Math.abs(lineFactor * stringHeight)) : lineutility.ExtendDirectedLine(ptCenter, pt0, pt0, 2, Math.abs(lineFactor * stringHeight));
                    pt3 = lineFactor >= 0.0 ? lineutility.ExtendDirectedLine(ptCenter, pt1, pt1, 3, Math.abs(lineFactor * stringHeight)) : lineutility.ExtendDirectedLine(ptCenter, pt1, pt1, 2, Math.abs(lineFactor * stringHeight));
                    x1 = pt2.x;
                    y1 = pt2.y;
                    x2 = pt3.x;
                    y2 = pt3.y;
                    if (mbrPoly.contains(x1, y1) && mbrPoly.contains(x2, y2)) {
                        modifier.fitsMBR = true;
                        continue;
                    }
                    modifier.fitsMBR = false;
                    continue;
                }
                modifier.fitsMBR = true;
            }
            n = tg.modifiers.size();
            for (j = 0; j < n; ++j) {
                modifier = tg.modifiers.get(j);
                if (modifier.textID == null || modifier.textID.isEmpty() || modifier.fitsMBR) continue;
                if (modifier.textID.equalsIgnoreCase("W")) {
                    wfits = false;
                    continue;
                }
                if (modifier.textID.equalsIgnoreCase("W1")) {
                    w1fits = false;
                    continue;
                }
                if (modifier.textID.equalsIgnoreCase("W+W1")) {
                    ww1fits = false;
                    continue;
                }
                if (modifier.textID.equalsIgnoreCase("H")) {
                    hfits = false;
                    continue;
                }
                if (modifier.textID.equalsIgnoreCase("H1")) {
                    h1fits = false;
                    continue;
                }
                if (!modifier.textID.equalsIgnoreCase("H2")) continue;
                h2fits = false;
            }
            if (!wfits || !w1fits) {
                Modifier2.removeModifier(tg, "W");
                Modifier2.removeModifier(tg, "W1");
            }
            if (!ww1fits) {
                Modifier2.removeModifier(tg, "W+W1");
            }
            if (!(hfits && h1fits && h2fits)) {
                Modifier2.removeModifier(tg, "H");
                Modifier2.removeModifier(tg, "H1");
                Modifier2.removeModifier(tg, "H2");
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "RemoveModifeirs", new RendererException("Failed inside RemoveModifiers", exc));
        }
    }

    private static void getPixelsMiddleSegment(TGLight tg, double stringWidth, POINT2 segPt0, POINT2 segPt1) {
        try {
            switch (tg.get_LineType()) {
                case 24220000: {
                    break;
                }
                default: {
                    return;
                }
            }
            int totalLength = 0;
            int j = 0;
            double dist = 0.0;
            double mid = 0.0;
            double remainder = 0.0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            POINT2 midPt = null;
            int n = tg.Pixels.size();
            for (j = 0; j < n - 1; ++j) {
                dist = lineutility.CalcDistanceDouble(tg.Pixels.get(j), tg.Pixels.get(j + 1));
                totalLength = (int)((double)totalLength + dist);
            }
            mid = totalLength / 2;
            totalLength = 0;
            for (j = 0; j < n - 1; ++j) {
                dist = lineutility.CalcDistanceDouble(tg.Pixels.get(j), tg.Pixels.get(j + 1));
                if (!((double)(totalLength = (int)((double)totalLength + dist)) >= mid)) continue;
                remainder = (double)totalLength - mid;
                pt0 = tg.Pixels.get(j);
                pt1 = tg.Pixels.get(j + 1);
                midPt = lineutility.ExtendAlongLineDouble2(pt1, pt0, remainder);
                pt2 = lineutility.ExtendAlongLineDouble2(midPt, pt0, stringWidth / 2.0);
                pt3 = lineutility.ExtendAlongLineDouble2(midPt, pt1, stringWidth / 2.0);
                segPt0.x = pt2.x;
                segPt0.y = pt2.y;
                segPt1.x = pt3.x;
                segPt1.y = pt3.y;
                break;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getPixelsMidpoint", new RendererException("Failed inside getPixelsMidpoint", exc));
        }
    }

    private static double getChange1Height(TGLight tg) {
        double height = 0.0;
        try {
            switch (tg.get_LineType()) {
                case 24321200: 
                case 24322200: 
                case 24323200: 
                case 24324200: 
                case 24325200: 
                case 24331200: 
                case 24332200: 
                case 24333200: 
                case 24334200: 
                case 24335200: 
                case 24336200: 
                case 24337200: 
                case 24338200: 
                case 24339200: 
                case 24352000: 
                case 24362000: 
                case 25200202: 
                case 25200402: {
                    break;
                }
                default: {
                    return 0.0;
                }
            }
            double x1 = tg.Pixels.get((int)0).x;
            double y1 = tg.Pixels.get((int)0).y;
            double x2 = tg.Pixels.get((int)1).x;
            double y2 = tg.Pixels.get((int)1).y;
            double deltax = x2 - x1;
            double deltay = y2 - y1;
            height = Math.sqrt(deltax * deltax + deltay * deltay);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getChange1Height", new RendererException("Failed inside getChange1Height", exc));
        }
        return height;
    }

    private static void scaleModifiers(TGLight tg) {
        try {
            if (!RendererSettings.getInstance().getAutoCollapseModifiers()) {
                return;
            }
            if (!tg.get_Client().equalsIgnoreCase("ge")) {
                return;
            }
            if (tg.modifiers == null || tg.modifiers.isEmpty()) {
                return;
            }
            int linetype = tg.get_LineType();
            boolean isClosedPolygon = clsUtility.isClosedPolygon(linetype);
            boolean isChange1Area = clsUtility.IsChange1Area(linetype);
            if (!isClosedPolygon && !isChange1Area) {
                return;
            }
            switch (linetype) {
                case 240804: 
                case 24326100: 
                case 24326200: 
                case 25200700: 
                case 243111000: 
                case 243112000: {
                    return;
                }
            }
            POINT2 ptUl = new POINT2();
            POINT2 ptUr = new POINT2();
            POINT2 ptLr = new POINT2();
            POINT2 ptLl = new POINT2();
            Modifier2.GetMBR(tg, ptUl, ptUr, ptLr, ptLl);
            int sz = tg.get_Font().getSize();
            double heightMBR = 0.0;
            double change1Height = Modifier2.getChange1Height(tg);
            heightMBR = change1Height <= 0.0 ? Math.abs(ptLr.y - ptUr.y) / 2.0 : change1Height;
            double heightModifiers = 0.0;
            ArrayList<Modifier2> modifiers = tg.modifiers;
            Modifier2 modifier = null;
            double minLF = 2.147483647E9;
            int j = 0;
            boolean isValid = false;
            for (j = 0; j < modifiers.size(); ++j) {
                modifier = modifiers.get(j);
                if (modifier.type == 1 || modifier.type == 2 && !isChange1Area) continue;
                if (modifier.lineFactor < minLF) {
                    minLF = modifier.lineFactor;
                }
                isValid = true;
            }
            if (!isValid) {
                return;
            }
            heightModifiers = Math.abs(minLF) * (double)sz;
            boolean expandModifiers = false;
            boolean shrinkModifiers = false;
            if (heightModifiers > heightMBR) {
                shrinkModifiers = true;
            } else if (heightModifiers < 0.5 * heightMBR) {
                expandModifiers = true;
            }
            boolean addEllipsis = false;
            Modifier2 modifierE = new Modifier2();
            if (expandModifiers) {
                double factor = heightMBR / heightModifiers;
                if ((factor = 1.0 + (factor - 1.0) / 4.0) > 2.0) {
                    factor = 2.0;
                }
                for (j = 0; j < modifiers.size(); ++j) {
                    modifier = modifiers.get(j);
                    if (modifier.type == 2 ? !isChange1Area : modifier.type != 3) continue;
                    modifier.lineFactor *= factor;
                }
            } else if (shrinkModifiers) {
                double deltaLF = (heightModifiers - heightMBR) / (double)sz;
                double newLF = 0.0;
                double maxLF = 0.0;
                for (j = 0; j < modifiers.size(); ++j) {
                    modifier = modifiers.get(j);
                    if (modifier.type != 2 ? modifier.type != 3 : !isChange1Area) continue;
                    newLF = modifier.lineFactor + deltaLF;
                    if (Math.abs(newLF * (double)sz) >= heightMBR) {
                        if (modifier.lineFactor > minLF) {
                            modifierE.type = modifier.type;
                            modifier.type = 7;
                            if (!modifier.text.isEmpty()) {
                                addEllipsis = true;
                            }
                        }
                        modifier.lineFactor = newLF;
                        modifierE.textPath = modifier.textPath;
                        continue;
                    }
                    modifier.lineFactor = newLF;
                }
                ArrayList<Modifier2> modifiers2 = new ArrayList<Modifier2>();
                for (j = 0; j < modifiers.size(); ++j) {
                    modifier = modifiers.get(j);
                    if (modifier.type == 7) continue;
                    if (modifier.lineFactor > maxLF) {
                        maxLF = modifier.lineFactor;
                    }
                    modifiers2.add(modifier);
                }
                if (addEllipsis) {
                    Character letter = Character.valueOf('\u25cf');
                    String s = Character.toString(letter.charValue());
                    String echelonSymbol = s + s + s;
                    modifierE.text = echelonSymbol;
                    modifierE.lineFactor = maxLF + 1.0;
                    modifiers2.add(modifierE);
                }
                tg.modifiers = modifiers2;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "scaleModifiers", new RendererException("Failed inside scaleModifiers", exc));
        }
    }

    public static void AddModifiersGeo(TGLight tg, Graphics2D g2d, Object clipBounds, IPointConversion converter) {
        try {
            if (tg.Pixels == null || tg.Pixels.isEmpty()) {
                return;
            }
            ArrayList<POINT2> origPoints = null;
            Font font = tg.get_Font();
            if (font == null) {
                font = g2d.getFont();
            }
            g2d.setFont(font);
            boolean shiftLines = Channels.getShiftLines();
            boolean usas = false;
            boolean foundSegment = false;
            double csFactor = 1.0;
            double dist = 0.0;
            double dist2 = 0.0;
            POINT2 midPt = null;
            int northestPtIndex = 0;
            int southestPtIndex = 0;
            POINT2 northestPt = null;
            POINT2 southestPt = null;
            Rectangle2D.Double clipRect = null;
            ArrayList clipArray = null;
            if (clipBounds != null && ArrayList.class.isAssignableFrom(clipBounds.getClass())) {
                clipArray = (ArrayList)clipBounds;
            }
            if (clipBounds != null && Rectangle2D.Double.class.isAssignableFrom(clipBounds.getClass())) {
                clipRect = (Rectangle2D.Double)clipBounds;
            }
            FontMetrics metrics = g2d.getFontMetrics();
            int stringWidth = 0;
            int stringWidth2 = 0;
            String WDash = "";
            String TSpace = "";
            String TDash = "";
            if (tg.get_DTG() != null && tg.get_DTG1() != null && !tg.get_DTG().isEmpty() && !tg.get_DTG1().isEmpty()) {
                WDash = " - ";
            }
            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                TSpace = " ";
                TDash = " - ";
            }
            if (tg.get_Client().equals("cpof3d")) {
                csFactor = 0.9;
            }
            switch (tg.get_LineType()) {
                case 110300: 
                case 150501: 
                case 150502: 
                case 150503: 
                case 220101: 
                case 220104: 
                case 220107: 
                case 220108: 
                case 240804: 
                case 270801: 
                case 271900: 
                case 272101: 
                case 290101: 
                case 2514190: 
                case 11120500: 
                case 11120600: 
                case 13120500: 
                case 13120600: 
                case 21700000: 
                case 21710000: 
                case 21800000: 
                case 22121000: 
                case 22122000: 
                case 22123000: 
                case 22124000: 
                case 22125000: 
                case 22131000: 
                case 22132000: 
                case 22133000: 
                case 22134000: 
                case 22135000: 
                case 22136000: 
                case 22137000: 
                case 22138000: 
                case 22221000: 
                case 22222000: 
                case 22223000: 
                case 22224000: 
                case 22225000: 
                case 22231000: 
                case 22232000: 
                case 22233000: 
                case 22234000: 
                case 22234100: 
                case 22234200: 
                case 22235000: 
                case 22422000: 
                case 22431000: 
                case 22431100: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: 
                case 22522100: 
                case 22522210: 
                case 22522220: 
                case 22523000: 
                case 22524000: 
                case 22525000: 
                case 22526000: 
                case 22527000: 
                case 22528000: 
                case 22531000: 
                case 22532000: 
                case 22535000: 
                case 22612000: 
                case 22612001: 
                case 22613000: 
                case 22621000: 
                case 22622000: 
                case 22623000: 
                case 22623001: 
                case 22624000: 
                case 22625000: 
                case 22626000: 
                case 23112000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23162000: 
                case 23163000: 
                case 23164000: 
                case 23180000: 
                case 23221000: 
                case 23350000: 
                case 23410000: 
                case 23440000: 
                case 23450000: 
                case 23460000: 
                case 23490000: 
                case 24210000: 
                case 24211000: 
                case 24220000: 
                case 24225000: 
                case 24226000: 
                case 24230000: 
                case 24240000: 
                case 24250000: 
                case 24260000: 
                case 24311000: 
                case 24312000: 
                case 24313000: 
                case 24314000: 
                case 24315000: 
                case 24321100: 
                case 24322100: 
                case 24323100: 
                case 24324100: 
                case 24325100: 
                case 24330000: 
                case 24331100: 
                case 24332100: 
                case 24333100: 
                case 24334100: 
                case 24335100: 
                case 24336100: 
                case 24337100: 
                case 24338100: 
                case 24339100: 
                case 24351000: 
                case 24361000: 
                case 25110400: 
                case 25120700: 
                case 25140400: 
                case 25141800: 
                case 25170400: 
                case 25170600: 
                case 25171100: 
                case 25171200: 
                case 25171300: 
                case 25171400: 
                case 25171500: 
                case 25190100: 
                case 25190200: 
                case 25200101: 
                case 25200201: 
                case 25221000: 
                case 25222000: 
                case 25260400: 
                case 25300100: 
                case 25310000: 
                case 25310800: 
                case 25320000: 
                case 25330000: 
                case 25330301: 
                case 25330302: 
                case 25330303: 
                case 25330401: 
                case 25330402: 
                case 25330403: 
                case 25330500: 
                case 25330501: 
                case 25330502: 
                case 25340000: 
                case 25344100: 
                case 25344200: 
                case 25351000: 
                case 25352000: 
                case 25353000: 
                case 26400000: 
                case 26410000: 
                case 26420000: 
                case 26430000: 
                case 26440000: 
                case 31740000: 
                case 31770000: 
                case 32231400: 
                case 32231500: 
                case 211800000: 
                case 212000000: 
                case 212210000: 
                case 212220000: 
                case 212230000: 
                case 212400000: 
                case 212410000: 
                case 221310000: 
                case 221311000: 
                case 231100000: 
                case 243100000: 
                case 317100000: 
                case 1322134000: 
                case 1325260400: 
                case 1325310000: {
                    origPoints = lineutility.getDeepCopy(tg.Pixels);
                    break;
                }
                default: {
                    return;
                }
            }
            int linetype = tg.get_LineType();
            int j = 0;
            boolean k = false;
            double x = 0.0;
            double y = 0.0;
            int lastIndex = tg.Pixels.size() - 1;
            int nextToLastIndex = tg.Pixels.size() - 2;
            POINT2 pt0 = new POINT2(tg.Pixels.get(0));
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            POINT2 ptLast = new POINT2(tg.Pixels.get(lastIndex));
            POINT2 ptNextToLast = null;
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (lastIndex > 0) {
                ptNextToLast = new POINT2(tg.Pixels.get(nextToLastIndex));
            }
            if (tg.Pixels.size() > 1) {
                pt1 = new POINT2(tg.Pixels.get(1));
            }
            Modifier2.shiftModifierPath(tg, pt0, pt1, ptLast, ptNextToLast);
            String label = Modifier2.GetCenterLabel(tg);
            String v = tg.get_V();
            String ap = tg.get_AP();
            Object[] pts = tg.Pixels.toArray();
            POINT2 ptCenter = null;
            if (converter != null) {
                ptCenter = mdlGeodesic.geodesic_center(tg.LatLongs);
                if (ptCenter != null) {
                    Point2D pt22 = converter.GeoToPixels(new Point2D.Double(ptCenter.x, ptCenter.y));
                    ptCenter.x = pt22.getX();
                    ptCenter.y = pt22.getY();
                } else {
                    ptCenter = lineutility.CalcCenterPointDouble2(pts, pts.length);
                }
            } else {
                ptCenter = lineutility.CalcCenterPointDouble2(pts, pts.length);
            }
            int middleSegment = (tg.Pixels.size() + 1) / 2 - 1;
            int middleSegment2 = 0;
            if (clipRect != null) {
                middleSegment = Modifier2.getVisibleMiddleSegment(tg, clipRect);
            } else if (clipArray != null) {
                middleSegment = Modifier2.getVisibleMiddleSegment(tg, clipArray);
            }
            if (tg.Pixels.size() > 2) {
                pt2 = tg.Pixels.get(2);
            }
            if (tg.Pixels.size() > 3) {
                pt3 = tg.Pixels.get(3);
            }
            double TLineFactor = 0.0;
            double T1LineFactor = 0.0;
            POINT2 lr = new POINT2(tg.Pixels.get(0));
            POINT2 ll = new POINT2(tg.Pixels.get(0));
            POINT2 ul = new POINT2(tg.Pixels.get(0));
            POINT2 ur = new POINT2(tg.Pixels.get(0));
            int index = 0;
            boolean nextIndex = false;
            int size = tg.Pixels.size();
            Object line = null;
            switch (linetype) {
                case 22124000: {
                    Modifier2.AddIntegralAreaModifier(tg, label + TSpace + tg.get_Name(), 1, T1LineFactor, pt0, pt1, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, label + TSpace + tg.get_Name(), 1, T1LineFactor, ptLast, ptNextToLast, (Boolean)false);
                    break;
                }
                case 25140400: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, pt0, pt1, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, ptLast, ptNextToLast, (Boolean)false);
                    break;
                }
                case 24210000: {
                    pt0 = tg.Pixels.get(0);
                    pt1 = tg.Pixels.get(1);
                    pt2 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt3 = tg.Pixels.get(tg.Pixels.size() - 2);
                    dist = lineutility.CalcDistanceDouble(pt0, pt1);
                    dist2 = lineutility.CalcDistanceDouble(pt2, pt3);
                    stringWidth = (int)((double)metrics.stringWidth(tg.get_Name() + " " + label));
                    stringWidth2 = (int)((double)metrics.stringWidth(tg.get_DTG()));
                    if (stringWidth2 > stringWidth) {
                        stringWidth = stringWidth2;
                    }
                    if (tg.Pixels.size() == 2) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, tg.get_Name() + " " + label, 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        if (!(dist > 3.5 * (double)stringWidth)) break;
                        pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                        pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, tg.get_Name() + " " + label, 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        break;
                    }
                    double dist3 = lineutility.CalcDistanceDouble(pt0, pt2);
                    if (dist > (double)(stringWidth + 5) || dist >= dist2 || dist3 > (double)(stringWidth + 5)) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, tg.get_Name() + " " + label, 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                    }
                    if (!(dist2 > (double)(stringWidth + 5)) && !(dist2 > dist) && !(dist3 > (double)(stringWidth + 5))) break;
                    pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                    pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                    Modifier2.AddModifier2(tg, tg.get_Name() + " " + label, 2, -0.7 * csFactor, pt0, pt1, false);
                    Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                    Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                    break;
                }
                case 24230000: 
                case 24240000: 
                case 25260400: 
                case 25300100: {
                    pt0 = tg.Pixels.get(0);
                    pt1 = tg.Pixels.get(1);
                    pt2 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt3 = tg.Pixels.get(tg.Pixels.size() - 2);
                    dist = lineutility.CalcDistanceDouble(pt0, pt1);
                    dist2 = lineutility.CalcDistanceDouble(pt2, pt3);
                    stringWidth = (int)((double)metrics.stringWidth(tg.get_Name() + " " + label));
                    stringWidth2 = (int)((double)metrics.stringWidth(tg.get_DTG()));
                    if (stringWidth2 > stringWidth) {
                        stringWidth = stringWidth2;
                    }
                    if (tg.Pixels.size() == 2) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, label + TSpace + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        if (!(dist > 3.5 * (double)stringWidth)) break;
                        pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                        pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, label + TSpace + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        break;
                    }
                    double dist3 = lineutility.CalcDistanceDouble(pt0, pt2);
                    if (dist > (double)(stringWidth + 5) || dist >= dist2 || dist3 > (double)(stringWidth + 5)) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, label + TSpace + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                    }
                    if (!(dist2 > (double)(stringWidth + 5)) && !(dist2 > dist) && !(dist3 > (double)(stringWidth + 5))) break;
                    pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                    pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                    Modifier2.AddModifier2(tg, label + TSpace + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                    Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                    Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                    break;
                }
                case 1325260400: {
                    pt0 = tg.Pixels.get(0);
                    pt1 = tg.Pixels.get(1);
                    pt2 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt3 = tg.Pixels.get(tg.Pixels.size() - 2);
                    dist = lineutility.CalcDistanceDouble(pt0, pt1);
                    dist2 = lineutility.CalcDistanceDouble(pt2, pt3);
                    Object TMod = "";
                    if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                        TMod = " (" + tg.get_Name() + ")";
                    }
                    stringWidth = (int)((double)metrics.stringWidth(label + (String)TMod));
                    stringWidth2 = (int)((double)metrics.stringWidth(tg.get_DTG()));
                    if (stringWidth2 > stringWidth) {
                        stringWidth = stringWidth2;
                    }
                    if (tg.Pixels.size() == 2) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, label + (String)TMod, 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        if (!(dist > 3.5 * (double)stringWidth)) break;
                        pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                        pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, label + (String)TMod, 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        break;
                    }
                    double dist3 = lineutility.CalcDistanceDouble(pt0, pt2);
                    if (dist > (double)(stringWidth + 5) || dist >= dist2 || dist3 > (double)(stringWidth + 5)) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, label + (String)TMod, 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                    }
                    if (!(dist2 > (double)(stringWidth + 5)) && !(dist2 > dist) && !(dist3 > (double)(stringWidth + 5))) break;
                    pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                    pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                    Modifier2.AddModifier2(tg, label + (String)TMod, 2, -0.7 * csFactor, pt0, pt1, false);
                    Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                    Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                    break;
                }
                case 22522100: 
                case 22522210: 
                case 22522220: {
                    midPt = lineutility.MidPointDouble(pt0, pt1, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 0.0, pt0, midPt, (Boolean)false);
                    Modifier2.addDTG(tg, 2, csFactor, 2.0 * csFactor, pt0, pt1, metrics);
                    break;
                }
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: {
                    if (tg.Pixels.size() == 3) {
                        midPt = lineutility.MidPointDouble(pt0, pt1, 0);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + WDash, 2, 0.0, midPt, midPt, (Boolean)false);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 2, csFactor, midPt, midPt, (Boolean)false);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 2.0 * csFactor, midPt, midPt, (Boolean)false);
                        break;
                    }
                    if (tg.Pixels.size() == 4) {
                        midPt = lineutility.MidPointDouble(pt1, pt2, 0);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + WDash, 2, 0.0, midPt, midPt, (Boolean)false);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 2, csFactor, midPt, midPt, (Boolean)false);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 2.0 * csFactor, midPt, midPt, (Boolean)false);
                        break;
                    }
                    midPt = lineutility.MidPointDouble(pt1, pt2, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + WDash, 2, -csFactor / 2.0, midPt, midPt, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 2, csFactor / 2.0, midPt, midPt, (Boolean)false);
                    midPt = lineutility.MidPointDouble(pt2, pt3, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, -csFactor / 2.0, midPt, midPt, (Boolean)false);
                    break;
                }
                case 2514190: 
                case 22125000: 
                case 22523000: 
                case 22525000: 
                case 22526000: 
                case 22527000: 
                case 22528000: 
                case 22612000: 
                case 22612001: 
                case 22613000: 
                case 22623000: 
                case 22623001: 
                case 25141800: 
                case 25190100: 
                case 25190200: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 5, -csFactor, pt0, pt1, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 5, -csFactor, ptLast, ptNextToLast, (Boolean)false);
                    break;
                }
                case 110300: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 5, -csFactor, pt0, pt1, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 5, -csFactor, ptLast, ptNextToLast, (Boolean)false);
                    tg.set_EchelonSymbol("");
                    if (clipRect != null) {
                        Modifier2.AddBoundaryModifiers(tg, g2d, clipRect);
                        break;
                    }
                    Modifier2.AddBoundaryModifiers(tg, g2d, clipArray);
                    break;
                }
                case 221311000: {
                    ur = new POINT2();
                    ul = new POINT2();
                    ll = new POINT2();
                    lr = new POINT2();
                    Modifier2.GetMBR(tg, ul, ur, lr, ll);
                    stringWidth = metrics.stringWidth(tg.get_H());
                    pt0.x = ur.x + (double)(stringWidth / 2) + 1.0;
                    pt0.y = (ur.y + lr.y) / 2.0 - (double)font.getSize();
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_H(), 3, csFactor, pt0, pt0, (Boolean)false);
                    break;
                }
                case 25200101: 
                case 25200201: {
                    Modifier2.AddIntegralAreaModifier(tg, label + TDash + tg.get_Name(), 3, 0.0, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 150501: 
                case 150502: 
                case 150503: {
                    Modifier2.addNModifier(tg);
                    Modifier2.AddIntegralAreaModifier(tg, label + TDash + tg.get_Name(), 3, 0.0, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.addDTG(tg, 3, csFactor, 2.0 * csFactor, ptCenter, ptCenter, metrics);
                    break;
                }
                case 23113000: 
                case 1322134000: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 25170800: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt0, pt0, (Boolean)false);
                    break;
                }
                case 11120500: 
                case 11120600: 
                case 22132000: 
                case 22133000: 
                case 22135000: 
                case 22136000: 
                case 22137000: 
                case 22138000: 
                case 22531000: 
                case 22532000: 
                case 22535000: 
                case 22621000: 
                case 22625000: 
                case 22626000: {
                    Modifier2.AddIntegralAreaModifier(tg, label + TSpace + tg.get_Name(), 3, 0.0, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 13120500: 
                case 13120600: {
                    Modifier2.AddIntegralAreaModifier(tg, label + TSpace + tg.get_Name(), 3, -1.0 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddModifier(tg, tg.get_H(), 3, 0.0, ptCenter, ptCenter);
                    Modifier2.addDTG(tg, 3, 1.0 * csFactor, 2.0 * csFactor, ptCenter, ptCenter, metrics);
                    Modifier2.addNModifier(tg);
                    Modifier2.addModifierBottomSegment(tg, tg.get_EchelonSymbol());
                    break;
                }
                case 25120700: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_H() + " " + tg.get_Name(), 3, -0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.addDTG(tg, 3, 0.5 * csFactor, 1.5 * csFactor, ptCenter, ptCenter, metrics);
                    Modifier2.addNModifier(tg);
                    break;
                }
                case 22622000: {
                    Modifier2.GetMBR(tg, ul, ur, lr, ll);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, csFactor, ll, lr, (Boolean)false);
                    break;
                }
                case 22221000: 
                case 22222000: 
                case 22223000: 
                case 22224000: 
                case 22225000: 
                case 25170400: 
                case 25170600: {
                    Modifier2.AddIntegralModifier(tg, "Name: " + tg.get_Name(), 2, -7.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Width: " + tg.get_AM(), 2, -6.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Min Alt: " + tg.get_X(), 2, -5.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Max Alt: " + tg.get_X1(), 2, -4.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "DTG Start: " + tg.get_DTG(), 2, -3.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "DTG End: " + tg.get_DTG1(), 2, -2.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, label + TSpace + tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 220101: 
                case 220104: 
                case 220107: 
                case 220108: 
                case 26400000: 
                case 26410000: 
                case 26420000: 
                case 26430000: 
                case 26440000: {
                    midPt = lineutility.MidPointDouble(pt0, pt1, 0);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, 0.0, midPt, midPt, (Boolean)true);
                    pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 3, (double)font.getSize() / 2.0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_H(), 2, 1.0, pt3, pt3, (Boolean)true);
                    break;
                }
                case 24322100: {
                    Modifier2.AddIntegralAreaModifier(tg, label + TSpace + tg.get_Name(), 3, -3.0 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_T1(), 3, -2.0 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, "MIN ALT: " + tg.get_X(), 3, -1.0 * csFactor, ptCenter, ptCenter, false, "H");
                    Modifier2.AddIntegralAreaModifier(tg, "MAX ALT: " + tg.get_X1(), 3, 0.0, ptCenter, ptCenter, false, "H1");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Location(), 3, 1.0 * csFactor, ptCenter, ptCenter, false, "H2");
                    Modifier2.addDTG(tg, 3, 2.0 * csFactor, 3.0 * csFactor, ptCenter, ptCenter, metrics);
                    break;
                }
                case 24225000: {
                    pt0 = tg.Pixels.get(middleSegment);
                    pt1 = tg.Pixels.get(middleSegment + 1);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, middleSegment, middleSegment + 1, true);
                    Modifier2.AddIntegralModifier(tg, tg.get_DTG() + WDash, 5, 1.0 * csFactor, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, tg.get_DTG1(), 5, 2.0 * csFactor, 0, 1, false);
                    break;
                }
                case 24250000: {
                    Modifier2.AddIntegralModifier(tg, ap, 2, -0.7 * csFactor, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 24211000: {
                    Modifier2.AddIntegralModifier(tg, ap, 2, -0.7 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.7 * csFactor, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 24260000: {
                    Modifier2.AddIntegralModifier(tg, ap, 2, -0.7 * csFactor, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.7 * csFactor, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, tg.get_T1(), 2, 1.7 * csFactor, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, v, 2, 2.7 * csFactor, 0, 1, false);
                    break;
                }
                case 24330000: {
                    Modifier2.AddIntegralAreaModifier(tg, ap, 3, 0.0, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 24311000: 
                case 24312000: {
                    Modifier2.AddIntegralAreaModifier(tg, ap, 3, 0.0, pt0, pt0, (Boolean)false);
                    break;
                }
                case 240804: {
                    stringWidth = metrics.stringWidth(tg.get_Name());
                    POINT2 offsetCenterPoint = new POINT2(ptCenter.x + (double)stringWidth / 2.0, ptCenter.y);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -1.0 * csFactor, offsetCenterPoint, offsetCenterPoint, (Boolean)false);
                    break;
                }
                case 24314000: {
                    Modifier2.AddIntegralAreaModifier(tg, ap, 3, -csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.addDTG(tg, 3, 1.0 * csFactor, 2.0 * csFactor, ptCenter, ptCenter, metrics);
                    break;
                }
                case 23112000: {
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, csFactor, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 23164000: {
                    if (tg.isHostile()) {
                        pt1 = lineutility.MidPointDouble(pt0, pt1, 0);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, pt1, (Boolean)true);
                        if (middleSegment != 0) {
                            pt0 = tg.Pixels.get(middleSegment);
                            pt1 = tg.Pixels.get(middleSegment + 1);
                            pt1 = lineutility.MidPointDouble(pt0, pt1, 0);
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, pt1, (Boolean)true);
                        }
                    }
                    Modifier2.GetMBR(tg, ul, ur, lr, ll);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_H(), 2, -1.5 * csFactor, ul, ur, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 2, 1.5 * csFactor, ll, lr, (Boolean)false);
                    Modifier2.addModifierOnLine("M", tg);
                    Modifier2.AddIntegralAreaModifier(tg, Modifier2.getImageModifier(tg), 9, 0.0, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 270801: {
                    if (tg.isHostile()) {
                        pt1 = lineutility.MidPointDouble(pt0, pt1, 0);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, pt1, (Boolean)true);
                        if (middleSegment != 0) {
                            pt0 = tg.Pixels.get(middleSegment);
                            pt1 = tg.Pixels.get(middleSegment + 1);
                            pt1 = lineutility.MidPointDouble(pt0, pt1, 0);
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, pt1, (Boolean)true);
                        }
                    }
                    Modifier2.addModifierOnLine("M", tg);
                    Modifier2.AddIntegralAreaModifier(tg, Modifier2.getImageModifier(tg), 9, 0.0, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 23221000: {
                    if (tg.Pixels.get((int)1).y > tg.Pixels.get((int)0).y) {
                        pt0 = tg.Pixels.get(1);
                        pt1 = tg.Pixels.get(3);
                        pt2 = tg.Pixels.get(0);
                        pt3 = tg.Pixels.get(2);
                    } else {
                        pt0 = tg.Pixels.get(0);
                        pt1 = tg.Pixels.get(2);
                        pt2 = tg.Pixels.get(1);
                        pt3 = tg.Pixels.get(3);
                    }
                    pt2 = lineutility.ExtendAlongLineDouble2(pt0, pt2, -20.0);
                    pt3 = lineutility.ExtendAlongLineDouble2(pt1, pt3, -20.0);
                    Modifier2.addDTG(tg, 2, 0.0, csFactor, pt2, pt3, metrics);
                    break;
                }
                case 23490000: 
                case 24313000: {
                    Modifier2.addModifierTopSegment(tg, tg.get_Name());
                    break;
                }
                case 272101: {
                    Modifier2.AddIntegralModifier(tg, "1", 2, 0.0, index, index + 1, true);
                    Modifier2.AddIntegralModifier(tg, "2", 2, 0.0, size / 2, size / 2 + 1, true);
                    break;
                }
                case 212210000: 
                case 212220000: 
                case 212230000: {
                    if (tg.Pixels.size() == 4) {
                        pt1 = new POINT2(tg.Pixels.get(1));
                        pt2 = new POINT2(tg.Pixels.get(2));
                        Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt1, pt1, (Boolean)true);
                        Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt2, pt2, (Boolean)true);
                        break;
                    }
                    int stringHeight = (int)(0.5 * (double)font.getSize());
                    double dAngle0 = Math.atan2(tg.Pixels.get((int)0).y - tg.Pixels.get((int)1).y, tg.Pixels.get((int)0).x - tg.Pixels.get((int)1).x);
                    double dAngle1 = Math.atan2(tg.Pixels.get((int)0).y - tg.Pixels.get((int)2).y, tg.Pixels.get((int)0).x - tg.Pixels.get((int)2).x);
                    pt0 = new POINT2(tg.Pixels.get(0));
                    pt0.x -= 30.0 * Math.cos(dAngle0);
                    pt0.y -= 30.0 * Math.sin(dAngle0) + (double)stringHeight;
                    pt1 = new POINT2(tg.Pixels.get(0));
                    pt1.x -= 30.0 * Math.cos(dAngle1);
                    pt1.y -= 30.0 * Math.sin(dAngle1) + (double)stringHeight;
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt0, pt0, (Boolean)true);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt1, pt1, (Boolean)true);
                    break;
                }
                case 25330301: 
                case 25330302: 
                case 25330303: 
                case 25330401: 
                case 25330402: 
                case 25330403: 
                case 25330501: 
                case 25330502: {
                    boolean isAlt;
                    stringWidth = (int)(1.5 * (double)metrics.stringWidth(label + TSpace + tg.get_Name()));
                    double arrowOffset = 10.0 * DPIScaleFactor;
                    if (linetype == 25330302 || linetype == 25330402) {
                        arrowOffset = 25.0 * DPIScaleFactor;
                    }
                    boolean bl = isAlt = linetype == 25330303 || linetype == 25330403 || linetype == 25330502;
                    if (isAlt && (stringWidth2 = (int)(1.5 * (double)metrics.stringWidth("ALT"))) > stringWidth) {
                        stringWidth = stringWidth2;
                    }
                    foundSegment = false;
                    if (!RendererSettings.getInstance().getTwoLabelOnly()) {
                        int arrowSide;
                        for (j = 0; j < tg.Pixels.size() - 1; ++j) {
                            pt0 = tg.Pixels.get(j);
                            pt1 = tg.Pixels.get(j + 1);
                            dist = lineutility.CalcDistanceDouble(pt0, pt1);
                            arrowSide = arraysupport.SupplyRouteArrowSide(pt0, pt1);
                            if (dist < (double)stringWidth) continue;
                            if (arrowSide == 1 || arrowSide == 2) {
                                pt0 = lineutility.ExtendDirectedLine(pt1, pt0, pt0, arrowSide, arrowOffset);
                                pt1 = lineutility.ExtendDirectedLine(pt1, pt0, pt1, arrowSide, arrowOffset);
                                Modifier2.AddModifier(tg, label + TSpace + tg.get_Name(), 2, -1.7 * csFactor, pt0, pt1);
                                if (isAlt) {
                                    Modifier2.AddModifier(tg, "ALT", 2, 0.0, pt0, pt1);
                                }
                            } else {
                                Modifier2.AddModifier(tg, label + TSpace + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1);
                                if (isAlt) {
                                    pt0 = lineutility.ExtendDirectedLine(pt1, pt0, pt0, arrowSide, arrowOffset);
                                    pt1 = lineutility.ExtendDirectedLine(pt1, pt0, pt1, arrowSide, arrowOffset);
                                    Modifier2.AddModifier(tg, "ALT", 2, 0.0, pt0, pt1);
                                }
                            }
                            foundSegment = true;
                        }
                        if (foundSegment) break;
                        pt0 = tg.Pixels.get(middleSegment);
                        arrowSide = arraysupport.SupplyRouteArrowSide(pt0, pt1 = tg.Pixels.get(middleSegment + 1));
                        if (arrowSide == 1 || arrowSide == 2) {
                            pt0 = lineutility.ExtendDirectedLine(pt1, pt0, pt0, arrowSide, arrowOffset);
                            pt1 = lineutility.ExtendDirectedLine(pt1, pt0, pt1, arrowSide, arrowOffset);
                            Modifier2.AddModifier(tg, label + TSpace + tg.get_Name(), 2, -1.7 * csFactor, pt0, pt1);
                            if (!isAlt) break;
                            Modifier2.AddModifier(tg, "ALT", 2, 0.0, pt0, pt1);
                            break;
                        }
                        Modifier2.AddModifier(tg, label + TSpace + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1);
                        if (!isAlt) break;
                        pt0 = lineutility.ExtendDirectedLine(pt1, pt0, pt0, arrowSide, arrowOffset);
                        pt1 = lineutility.ExtendDirectedLine(pt1, pt0, pt1, arrowSide, arrowOffset);
                        Modifier2.AddModifier(tg, "ALT", 2, 0.0, pt0, pt1);
                        break;
                    }
                    northestPtIndex = 0;
                    northestPt = tg.Pixels.get(northestPtIndex);
                    southestPtIndex = 0;
                    southestPt = tg.Pixels.get(southestPtIndex);
                    for (j = 0; j < tg.Pixels.size() - 1; ++j) {
                        pt0 = tg.Pixels.get(j);
                        if (pt0.y >= northestPt.y) {
                            northestPt = pt0;
                            northestPtIndex = j;
                        }
                        if (!(pt0.y <= southestPt.y)) continue;
                        southestPt = pt0;
                        southestPtIndex = j;
                    }
                    Modifier2.AddIntegralModifier(tg, label + TSpace + tg.get_Name(), 2, -1.7 * csFactor, northestPtIndex, northestPtIndex + 1, false);
                    if (isAlt) {
                        Modifier2.AddIntegralModifier(tg, "ALT", 2, -0.7 * csFactor, northestPtIndex, northestPtIndex + 1, false);
                    }
                    if (northestPtIndex == southestPtIndex) break;
                    Modifier2.AddIntegralModifier(tg, label + TSpace + tg.get_Name(), 2, -1.7 * csFactor, southestPtIndex, southestPtIndex + 1, false);
                    if (!isAlt) break;
                    Modifier2.AddIntegralModifier(tg, "ALT", 2, -0.7 * csFactor, southestPtIndex, southestPtIndex + 1, false);
                    break;
                }
                case 25310000: {
                    Modifier2.AddIntegralAreaModifier(tg, "DETAINEE", 3, -1.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, "HOLDING", 3, -0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, "AREA", 3, 0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 1.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 25320000: {
                    Modifier2.AddIntegralAreaModifier(tg, "EPW", 3, -1.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, "HOLDING", 3, -0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, "AREA", 3, 0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 1.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 23180000: {
                    Modifier2.addModifierOnLine("UXO", tg, true);
                    break;
                }
                case 22131000: {
                    Modifier2.addNModifier(tg);
                    break;
                }
                case 25330000: 
                case 1325310000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 25310800: 
                case 25351000: 
                case 25352000: 
                case 25353000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 25340000: {
                    Modifier2.AddIntegralAreaModifier(tg, "REFUGEE", 3, -1.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, "HOLDING", 3, -0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, "AREA", 3, 0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 1.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 25221000: 
                case 25222000: 
                case 25330500: {
                    foundSegment = false;
                    if (!RendererSettings.getInstance().getTwoLabelOnly()) {
                        for (j = 0; j < tg.Pixels.size() - 1; ++j) {
                            pt0 = tg.Pixels.get(j);
                            pt1 = tg.Pixels.get(j + 1);
                            stringWidth = (int)(1.5 * (double)metrics.stringWidth(label + TSpace + tg.get_Name()));
                            dist = lineutility.CalcDistanceDouble(pt0, pt1);
                            if (dist < (double)stringWidth) continue;
                            Modifier2.AddIntegralModifier(tg, label + TSpace + tg.get_Name(), 2, -1.0 * csFactor, j, j + 1, false);
                            foundSegment = true;
                        }
                        if (foundSegment) break;
                        Modifier2.AddIntegralModifier(tg, label + TSpace + tg.get_Name(), 2, -1.0 * csFactor, middleSegment, middleSegment + 1, false);
                        break;
                    }
                    for (j = 0; j < tg.Pixels.size(); ++j) {
                        pt0 = tg.Pixels.get(j);
                        if (northestPt == null) {
                            northestPt = pt0;
                            northestPtIndex = j;
                        }
                        if (southestPt == null) {
                            southestPt = pt0;
                            southestPtIndex = j;
                        }
                        if (pt0.y >= northestPt.y) {
                            northestPt = pt0;
                            northestPtIndex = j;
                        }
                        if (!(pt0.y <= southestPt.y)) continue;
                        southestPt = pt0;
                        southestPtIndex = j;
                    }
                    middleSegment = northestPtIndex;
                    middleSegment2 = southestPtIndex;
                    if (middleSegment == tg.Pixels.size() - 1) {
                        --middleSegment;
                    }
                    if (middleSegment2 == tg.Pixels.size() - 1) {
                        --middleSegment2;
                    }
                    if (middleSegment == middleSegment2) {
                        --middleSegment2;
                    }
                    Modifier2.AddIntegralModifier(tg, label + TSpace + tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, label + TSpace + tg.get_Name(), 2, 0.0, middleSegment2, middleSegment2 + 1, false);
                    break;
                }
                case 231100000: {
                    foundSegment = false;
                    stringWidth = (int)(1.5 * (double)metrics.stringWidth(label));
                    for (j = 0; j < tg.Pixels.size() - 1; ++j) {
                        pt0 = tg.Pixels.get(j);
                        pt1 = tg.Pixels.get(j + 1);
                        midPt = lineutility.MidPointDouble(pt0, pt1, 0);
                        dist = lineutility.CalcDistanceDouble(pt0, pt1);
                        if (!(dist > (double)stringWidth)) continue;
                        Modifier2.AddModifier2(tg, label, 2, -0.7 * csFactor, midPt, midPt, false);
                        foundSegment = true;
                    }
                    if (foundSegment) break;
                    midPt = lineutility.MidPointDouble(tg.Pixels.get(middleSegment), tg.Pixels.get(middleSegment + 1), 0);
                    Modifier2.AddModifier2(tg, label, 2, -0.7 * csFactor, midPt, midPt, false);
                    break;
                }
                case 23163000: {
                    if (tg.Pixels.get((int)1).y > tg.Pixels.get((int)0).y) {
                        pt0 = tg.Pixels.get(1);
                        pt1 = tg.Pixels.get(3);
                        pt2 = tg.Pixels.get(0);
                        pt3 = tg.Pixels.get(2);
                    } else {
                        pt0 = tg.Pixels.get(0);
                        pt1 = tg.Pixels.get(2);
                        pt2 = tg.Pixels.get(1);
                        pt3 = tg.Pixels.get(3);
                    }
                    pt2 = lineutility.ExtendAlongLineDouble2(pt0, pt2, -20.0);
                    pt3 = lineutility.ExtendAlongLineDouble2(pt1, pt3, -20.0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 0.0, pt0, pt1, (Boolean)false);
                    Modifier2.addDTG(tg, 2, 0.0, csFactor, pt2, pt3, metrics);
                    break;
                }
                case 271900: 
                case 23440000: 
                case 23450000: 
                case 23460000: {
                    Modifier2.AddIntegralAreaModifier(tg, Modifier2.getImageModifier(tg), 9, 0.0, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 32231400: {
                    Modifier2.AddIntegralAreaModifier(tg, Modifier2.getImageModifier(tg), 2, -0.15 * csFactor, tg.Pixels.get(middleSegment), tg.Pixels.get(middleSegment + 1), (Boolean)false);
                    break;
                }
                case 32231500: {
                    y = pt0.y + pt1.y;
                    index = 0;
                    for (j = 1; j < size - 1; ++j) {
                        if (!(y < tg.Pixels.get((int)j).y + tg.Pixels.get((int)(j + 1)).y)) continue;
                        index = j;
                        y = tg.Pixels.get((int)index).y + tg.Pixels.get((int)(index + 1)).y;
                    }
                    Modifier2.AddIntegralAreaModifier(tg, Modifier2.getImageModifier(tg), 2, -0.25 * csFactor, tg.Pixels.get(index), tg.Pixels.get(index + 1), (Boolean)false);
                    break;
                }
                case 290101: {
                    Modifier2.AddIntegralAreaModifier(tg, Modifier2.getImageModifier(tg), 2, -0.2 * csFactor, tg.Pixels.get(middleSegment), tg.Pixels.get(middleSegment + 1), (Boolean)false);
                    if (!tg.isHostile()) break;
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 1, 0.0, pt0, pt1, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 1, 0.0, ptLast, ptNextToLast, (Boolean)false);
                    break;
                }
                case 23162000: {
                    Modifier2.GetMBR(tg, ul, ur, lr, ll);
                    Modifier2.addNModifier(tg);
                    Modifier2.AddIntegralAreaModifier(tg, Modifier2.getImageModifier(tg), 9, 0.0, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 24323100: 
                case 24324100: 
                case 24325100: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.0 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.addDTG(tg, 3, 1.0 * csFactor, 2.0 * csFactor, ptCenter, ptCenter, metrics);
                    break;
                }
                case 243100000: {
                    Modifier2.addModifierOnLine("PAA", tg);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.addDTG(tg, 3, 0.5 * csFactor, 1.5 * csFactor, ptCenter, ptCenter, metrics);
                    break;
                }
                case 24321100: {
                    Modifier2.AddIntegralAreaModifier(tg, label + TSpace + tg.get_Name(), 3, -0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.addDTG(tg, 3, 0.5 * csFactor, 1.5 * csFactor, ptCenter, ptCenter, metrics);
                    break;
                }
                case 24331100: 
                case 24332100: 
                case 24333100: 
                case 24334100: 
                case 24335100: 
                case 24336100: 
                case 24337100: 
                case 24338100: 
                case 24339100: 
                case 24351000: 
                case 24361000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.GetMBR(tg, ul, ur, lr, ll);
                    POINT2 ptLeft = ul;
                    POINT2 ptRight = ur;
                    if (tg.get_Client().equalsIgnoreCase("ge")) {
                        ptLeft.x -= (double)(font.getSize() / 2);
                        ptRight.x -= (double)(font.getSize() / 2);
                    }
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + WDash, 1, 0.5 * csFactor, ptLeft, ptRight, false, "W");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 1, 1.5 * csFactor, ptLeft, ptRight, false, "W1");
                    break;
                }
                case 22431000: 
                case 23350000: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.addModifierBottomSegment(tg, tg.get_EchelonSymbol());
                    break;
                }
                case 22431100: {
                    Modifier2.AddIntegralAreaModifier(tg, label + TSpace + tg.get_Name(), 3, 0.0, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.addModifierBottomSegment(tg, tg.get_EchelonSymbol());
                    Modifier2.addNModifier(tg);
                    break;
                }
                case 22235000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.5 * csFactor, ptCenter, ptCenter, (Boolean)true);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -0.5 * csFactor, ptCenter, ptCenter, (Boolean)true);
                    Modifier2.AddIntegralAreaModifier(tg, "TIME FROM: " + tg.get_DTG(), 3, 0.5 * csFactor, ptCenter, ptCenter, true, "W");
                    Modifier2.AddIntegralAreaModifier(tg, "TIME TO: " + tg.get_DTG1(), 3, 1.5 * csFactor, ptCenter, ptCenter, true, "W1");
                    break;
                }
                case 23114000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + WDash, 3, 0.5 * csFactor, ptCenter, ptCenter, false, "W");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 3, 1.5 * csFactor, ptCenter, ptCenter, false, "W1");
                    break;
                }
                case 23115000: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -1.0 * csFactor, ptCenter, ptCenter, (Boolean)true);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + WDash, 3, 0.0, ptCenter, ptCenter, true, "W");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 3, 1.0 * csFactor, ptCenter, ptCenter, true, "W1");
                    break;
                }
                case 22231000: 
                case 22232000: 
                case 22233000: 
                case 22234000: 
                case 22234100: 
                case 22234200: 
                case 25171100: 
                case 25171200: 
                case 25171300: 
                case 25171400: 
                case 25171500: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -2.5, ptCenter, ptCenter, false, "");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -1.5, ptCenter, ptCenter, false, "T");
                    Modifier2.AddIntegralAreaModifier(tg, "MIN ALT: " + tg.get_X(), 3, -0.5, ptCenter, ptCenter, false, "H");
                    Modifier2.AddIntegralAreaModifier(tg, "MAX ALT: " + tg.get_X1(), 3, 0.5, ptCenter, ptCenter, false, "H1");
                    Modifier2.AddIntegralAreaModifier(tg, "TIME FROM: " + tg.get_DTG(), 3, 1.5, ptCenter, ptCenter, false, "W");
                    Modifier2.AddIntegralAreaModifier(tg, "TIME TO: " + tg.get_DTG1(), 3, 2.5, ptCenter, ptCenter, false, "W1");
                    break;
                }
                case 22624000: {
                    if (!tg.isHostile()) break;
                    Modifier2.AddIntegralModifier(tg, tg.get_N(), 2, 0.0, 0, 1, true);
                    Modifier2.AddIntegralModifier(tg, tg.get_N(), 2, 0.0, middleSegment, middleSegment + 1, true);
                    break;
                }
                case 221310000: {
                    Modifier2.AddIntegralAreaModifier(tg, Modifier2.getImageModifier(tg), 9, 0.0, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.0 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    break;
                }
                case 22121000: {
                    if (clipRect != null) {
                        Modifier2.AddBoundaryModifiers(tg, g2d, clipRect);
                        break;
                    }
                    Modifier2.AddBoundaryModifiers(tg, g2d, clipArray);
                    break;
                }
                case 24220000: {
                    stringWidth = (int)((double)metrics.stringWidth(label + TSpace + tg.get_Name()));
                    stringWidth2 = (int)((double)metrics.stringWidth(tg.get_DTG() + WDash + tg.get_DTG1()));
                    if (stringWidth2 > stringWidth) {
                        stringWidth = stringWidth2;
                    }
                    pt0 = new POINT2(tg.Pixels.get(middleSegment));
                    pt1 = new POINT2(tg.Pixels.get(middleSegment + 1));
                    Modifier2.getPixelsMiddleSegment(tg, stringWidth, pt0, pt1);
                    Modifier2.AddModifier2(tg, label + TSpace + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                    Modifier2.addDTG(tg, 2, 0.7 * csFactor, 1.7 * csFactor, pt0, pt1, metrics);
                    break;
                }
                case 22122000: {
                    if (tg.get_H().equals("1")) {
                        label = "LC";
                    } else if (tg.get_H().equals("2")) {
                        label = "";
                    }
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, pt0, pt1, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, ptLast, ptNextToLast, (Boolean)false);
                    if (!tg.isHostile()) break;
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 1, -1.0 * csFactor, pt0, pt1, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 1, -1.0 * csFactor, ptLast, ptNextToLast, (Boolean)false);
                    break;
                }
                case 22123000: {
                    double shiftFactor = 1.0;
                    if (shiftLines) {
                        shiftFactor = 0.5;
                    }
                    if (tg.isHostile()) {
                        TLineFactor = pt0.x < pt1.x ? -shiftFactor : shiftFactor;
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 1, TLineFactor, pt0, pt1, (Boolean)false);
                        TLineFactor = ptNextToLast.x < ptLast.x ? -shiftFactor : shiftFactor;
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 1, TLineFactor, ptLast, ptNextToLast, (Boolean)false);
                    }
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, pt0, pt1, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, ptLast, ptNextToLast, (Boolean)false);
                    break;
                }
                case 21700000: {
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, 1, 0, false);
                    break;
                }
                case 21710000: {
                    stringWidth = (int)(1.5 * (double)metrics.stringWidth(label));
                    pt2 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                    Modifier2.AddModifier2(tg, label, 2, 0.0, pt1, pt2, false);
                    break;
                }
                case 22524000: {
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, 0.0, 1, 0, false);
                    break;
                }
                case 25344100: 
                case 25344200: 
                case 212000000: 
                case 212400000: 
                case 212410000: {
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, 0, 1, true);
                    break;
                }
                case 24226000: 
                case 24315000: 
                case 211800000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, ptCenter, ptCenter, (Boolean)true);
                    break;
                }
                case 23410000: {
                    Modifier2.AddIntegralAreaModifier(tg, "1", 3, 0.0, pt1, pt1, (Boolean)true);
                    Modifier2.AddIntegralAreaModifier(tg, "2", 3, 0.0, pt2, pt2, (Boolean)true);
                    Modifier2.AddIntegralAreaModifier(tg, "3", 3, 0.0, pt3, pt3, (Boolean)true);
                    break;
                }
                case 21800000: {
                    Modifier2.AddIntegralModifier(tg, tg.get_DTG(), 2, -1.0 * csFactor, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, 0, 1, true);
                    break;
                }
                case 25110400: {
                    pt0 = tg.Pixels.get(0);
                    pt1 = tg.Pixels.get(1);
                    pt2 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt3 = tg.Pixels.get(tg.Pixels.size() - 2);
                    dist = lineutility.CalcDistanceDouble(pt0, pt1);
                    dist2 = lineutility.CalcDistanceDouble(pt2, pt3);
                    stringWidth = (int)((double)metrics.stringWidth(tg.get_H() + " " + tg.get_Name()));
                    stringWidth2 = (int)((double)metrics.stringWidth(tg.get_DTG()));
                    if (stringWidth2 > stringWidth) {
                        stringWidth = stringWidth2;
                    }
                    if (tg.Pixels.size() == 2) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, tg.get_H() + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        if (!(dist > 3.5 * (double)stringWidth)) break;
                        pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                        pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, tg.get_H() + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        break;
                    }
                    double dist3 = lineutility.CalcDistanceDouble(pt0, pt2);
                    if (dist > (double)(stringWidth + 5) || dist >= dist2 || dist3 > (double)(stringWidth + 5)) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, tg.get_H() + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                    }
                    if (!(dist2 > (double)(stringWidth + 5)) && !(dist2 > dist) && !(dist3 > (double)(stringWidth + 5))) break;
                    pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                    pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                    Modifier2.AddModifier2(tg, tg.get_H() + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                    Modifier2.AddModifier2(tg, tg.get_DTG() + WDash, 2, 0.7 * csFactor, pt0, pt1, false);
                    Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                    break;
                }
            }
            Modifier2.scaleModifiers(tg);
            tg.Pixels = origPoints;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifiersGeo", new RendererException("Failed inside AddModifiersGeo", exc));
        }
    }

    private static int getRFALines(TGLight tg) {
        int lines = 1;
        try {
            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                ++lines;
            }
            if (tg.get_DTG() != null && !tg.get_DTG().isEmpty()) {
                ++lines;
            } else if (tg.get_DTG1() != null && !tg.get_DTG1().isEmpty()) {
                ++lines;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifiers", new RendererException("Failed inside AddModifiers", exc));
        }
        return lines;
    }

    private static void addSectorModifiers(TGLight tg, IPointConversion converter) {
        block26: {
            try {
                if (tg.get_LineType() == 243112000) {
                    int k;
                    ArrayList<Double> AM = new ArrayList<Double>();
                    ArrayList<Double> AN = new ArrayList<Double>();
                    String X = tg.get_X();
                    String[] altitudes = null;
                    String[] am = tg.get_AM().split(",");
                    String[] an = tg.get_AN().split(",");
                    int numSectors = an.length / 2;
                    if (numSectors < 1) {
                        return;
                    }
                    if (!X.isEmpty()) {
                        altitudes = X.split(",");
                    }
                    try {
                        for (String s : am) {
                            AM.add(Double.parseDouble(s));
                        }
                        for (String s : an) {
                            AN.add(Double.parseDouble(s));
                        }
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                    if (numSectors + 1 > AM.size() && Double.parseDouble(am[0]) != 0.0) {
                        AM.add(0, 0.0);
                    }
                    int n = tg.Pixels.size();
                    POINT2 pt0 = tg.Pixels.get(n - 5);
                    POINT2 pt1 = tg.Pixels.get(n - 4);
                    Point2D pt02d = new Point2D.Double(pt0.x, pt0.y);
                    Point2D pt12d = new Point2D.Double(pt1.x, pt1.y);
                    pt02d = converter.PixelsToGeo(pt02d);
                    pt12d = converter.PixelsToGeo(pt12d);
                    pt0.x = pt02d.getX();
                    pt0.y = pt02d.getY();
                    pt1.x = pt12d.getX();
                    pt1.y = pt12d.getY();
                    double az12 = mdlGeodesic.GetAzimuth(pt0, pt1);
                    POINT2 pt2 = null;
                    ArrayList<POINT2> locModifier = new ArrayList<POINT2>();
                    POINT2 ptLeft = null;
                    POINT2 ptRight = null;
                    ArrayList<POINT2> locAZModifier = new ArrayList<POINT2>();
                    Point2D pt22d = null;
                    double radius = 0.0;
                    for (k = 0; k < numSectors && AM.size() >= k + 2; ++k) {
                        radius = ((Double)AM.get(k) + (Double)AM.get(k + 1)) / 2.0;
                        pt2 = mdlGeodesic.geodesic_coordinate(pt0, radius, az12);
                        pt22d = new Point2D.Double(pt2.x, pt2.y);
                        pt22d = converter.GeoToPixels(pt22d);
                        pt2.x = pt22d.getX();
                        pt2.y = pt22d.getY();
                        locModifier.add(pt2);
                        if (tg.get_HideOptionalLabels()) continue;
                        ptLeft = mdlGeodesic.geodesic_coordinate(pt0, radius, (Double)AN.get(2 * k));
                        pt22d = new Point2D.Double(ptLeft.x, ptLeft.y);
                        pt22d = converter.GeoToPixels(pt22d);
                        ptLeft.x = pt22d.getX();
                        ptLeft.y = pt22d.getY();
                        ptRight = mdlGeodesic.geodesic_coordinate(pt0, radius, (Double)AN.get(2 * k + 1));
                        pt22d = new Point2D.Double(ptRight.x, ptRight.y);
                        pt22d = converter.GeoToPixels(pt22d);
                        ptRight.x = pt22d.getX();
                        ptRight.y = pt22d.getY();
                        locAZModifier.add(ptLeft);
                        locAZModifier.add(ptRight);
                    }
                    if (altitudes != null) {
                        for (k = 0; k < altitudes.length && k < locModifier.size(); ++k) {
                            pt0 = (POINT2)locModifier.get(k);
                            Modifier2.AddAreaModifier(tg, "ALT " + altitudes[k], 3, 0.0, pt0, pt0);
                        }
                    }
                    if (!tg.get_HideOptionalLabels()) {
                        for (k = 0; k < numSectors; ++k) {
                            pt0 = (POINT2)locModifier.get(k);
                            Modifier2.AddAreaModifier(tg, "RG " + AM.get(k + 1), 3, -1.0, pt0, pt0);
                            ptLeft = (POINT2)locAZModifier.get(2 * k);
                            ptRight = (POINT2)locAZModifier.get(2 * k + 1);
                            Modifier2.AddAreaModifier(tg, an[2 * k], 3, 0.0, ptLeft, ptLeft);
                            Modifier2.AddAreaModifier(tg, an[2 * k + 1], 3, 0.0, ptRight, ptRight);
                        }
                    }
                    break block26;
                }
                if (tg.get_LineType() == 25200700) {
                    String[] am;
                    double left;
                    String strLeftRightMinMax = tg.get_LRMM();
                    String[] sector = strLeftRightMinMax.split(",");
                    double right = Double.parseDouble(sector[1]);
                    for (left = Double.parseDouble(sector[0]); left > 360.0; left -= 360.0) {
                    }
                    while (right > 360.0) {
                        right -= 360.0;
                    }
                    while (left < 0.0) {
                        left += 360.0;
                    }
                    while (right < 0.0) {
                        right += 360.0;
                    }
                    double orientation = 0.0;
                    orientation = left > right ? (left - 360.0 + right) / 2.0 : (left + right) / 2.0;
                    double dist = Double.parseDouble(sector[3]);
                    double radius = dist * 1.1;
                    POINT2 pt0 = tg.LatLongs.get(0);
                    Point2D ptPixels = converter.GeoToPixels(new Point2D.Double(pt0.x, pt0.y));
                    POINT2 pt0F = new POINT2();
                    pt0F.x = ptPixels.getX();
                    pt0F.y = ptPixels.getY();
                    pt0F.style = pt0.style;
                    POINT2 pt1 = mdlGeodesic.geodesic_coordinate(pt0, radius, orientation);
                    ptPixels = converter.GeoToPixels(new Point2D.Double(pt1.x, pt1.y));
                    POINT2 pt1F = new POINT2();
                    pt1F.x = ptPixels.getX();
                    pt1F.y = ptPixels.getY();
                    pt1F.style = pt1.style;
                    dist = lineutility.CalcDistanceDouble(pt0F, pt1F);
                    double base = 10.0;
                    if (dist < 100.0) {
                        base = dist / 10.0;
                    }
                    if (base < 5.0) {
                        base = 5.0;
                    }
                    double basex2 = 2.0 * base;
                    POINT2 ptTipF = lineutility.ExtendAlongLineDouble(pt0F, pt1F, dist + basex2);
                    pt0 = pt0F;
                    pt1 = ptTipF;
                    ArrayList<Double> AM = new ArrayList<Double>();
                    for (String s : am = tg.get_AM().split(",")) {
                        AM.add(Double.parseDouble(s));
                    }
                    if (AM.size() < 2) {
                        if (Double.parseDouble(am[0]) != 0.0) {
                            AM.add(0, 0.0);
                        } else {
                            return;
                        }
                    }
                    Point2D pt02d = new Point2D.Double(pt0.x, pt0.y);
                    Point2D pt12d = new Point2D.Double(pt1.x, pt1.y);
                    pt02d = converter.PixelsToGeo(pt02d);
                    pt12d = converter.PixelsToGeo(pt12d);
                    pt0.x = pt02d.getX();
                    pt0.y = pt02d.getY();
                    pt1.x = pt12d.getX();
                    pt1.y = pt12d.getY();
                    double az12 = mdlGeodesic.GetAzimuth(pt0, pt1);
                    Point2D pt22d = null;
                    radius = ((Double)AM.get(0) + (Double)AM.get(1)) / 2.0;
                    POINT2 pt2 = mdlGeodesic.geodesic_coordinate(pt0, radius, az12);
                    pt22d = new Point2D.Double(pt2.x, pt2.y);
                    pt22d = converter.GeoToPixels(pt22d);
                    pt2.x = pt22d.getX();
                    pt2.y = pt22d.getY();
                    Modifier2.AddAreaModifier(tg, tg.get_Name(), 3, -1.0, pt2, pt2);
                }
            }
            catch (Exception exc) {
                ErrorLogger.LogException(_className, "addSectorModifiers", new RendererException("Failed inside addSectorModifiers", exc));
            }
        }
    }

    public static void AddModifiers2(TGLight tg, IPointConversion converter) {
        try {
            if (tg.Pixels == null || tg.Pixels.isEmpty()) {
                return;
            }
            switch (tg.get_LineType()) {
                case 240804: 
                case 21100000: 
                case 21200000: 
                case 21300000: 
                case 21400000: 
                case 21500000: 
                case 21600000: 
                case 23226000: 
                case 24311000: 
                case 24312000: 
                case 24321200: 
                case 24321300: 
                case 24322200: 
                case 24322300: 
                case 24323200: 
                case 24323300: 
                case 24324200: 
                case 24324300: 
                case 24325200: 
                case 24325300: 
                case 24326100: 
                case 24326200: 
                case 24331200: 
                case 24331300: 
                case 24332200: 
                case 24332300: 
                case 24333200: 
                case 24333300: 
                case 24334200: 
                case 24334300: 
                case 24335200: 
                case 24335300: 
                case 24336200: 
                case 24336300: 
                case 24337200: 
                case 24337300: 
                case 24338200: 
                case 24338300: 
                case 24339200: 
                case 24339300: 
                case 24352000: 
                case 24353000: 
                case 24362000: 
                case 24363000: 
                case 25170800: 
                case 25200202: 
                case 25200300: 
                case 25200401: 
                case 25200402: 
                case 25200600: 
                case 25200700: 
                case 25211000: 
                case 25212000: 
                case 211000000: 
                case 211100000: 
                case 211200000: 
                case 211210000: 
                case 211400000: 
                case 211600000: 
                case 211700000: 
                case 211900000: 
                case 212100000: 
                case 212300000: 
                case 212500000: 
                case 212600000: 
                case 243100000: 
                case 243111000: 
                case 243112000: {
                    break;
                }
                default: {
                    return;
                }
            }
            ArrayList<POINT2> origPoints = lineutility.getDeepCopy(tg.Pixels);
            int n = tg.Pixels.size();
            if (tg.modifiers == null) {
                tg.modifiers = new ArrayList();
            }
            Font font = tg.get_Font();
            POINT2 ptCenter = null;
            double csFactor = 1.0;
            int linetype = tg.get_LineType();
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            int j = 0;
            boolean k = false;
            double dist = 0.0;
            String label = Modifier2.GetCenterLabel(tg);
            String[] X = null;
            int lastIndex = tg.Pixels.size() - 1;
            int nextToLastIndex = 0;
            if (tg.Pixels.size() > 1) {
                nextToLastIndex = tg.Pixels.size() - 2;
            }
            POINT2 ptLast = new POINT2(tg.Pixels.get(lastIndex));
            POINT2 ptNextToLast = null;
            if (tg.Pixels.size() > 1) {
                ptNextToLast = new POINT2(tg.Pixels.get(nextToLastIndex));
            }
            String WDash = "";
            String TSpace = "";
            String TDash = "";
            if (tg.get_DTG() != null && tg.get_DTG1() != null && !tg.get_DTG().isEmpty() && !tg.get_DTG1().isEmpty()) {
                WDash = " - ";
            }
            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                TSpace = " ";
                TDash = " - ";
            }
            POINT2 ptLeft = null;
            POINT2 ptRight = null;
            BufferedImage bi = new BufferedImage(8, 8, 2);
            Graphics2D g2d = bi.createGraphics();
            g2d.setFont(tg.get_Font());
            FontMetrics metrics = g2d.getFontMetrics();
            int stringWidth = 0;
            int rfaLines = 0;
            pt0 = new POINT2(tg.Pixels.get(0));
            if (tg.Pixels.size() > 1) {
                pt1 = new POINT2(tg.Pixels.get(1));
            }
            Object pts = null;
            if (tg.get_Client().equals("cpof3d")) {
                csFactor = 0.9;
            }
            Modifier2.shiftModifierPath(tg, pt0, pt1, ptLast, ptNextToLast);
            block4 : switch (linetype) {
                case 25211000: 
                case 25212000: {
                    pt2 = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(3), 0);
                    pt3 = lineutility.MidPointDouble(tg.Pixels.get(1), tg.Pixels.get(2), 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_V(), 8, 0.0, pt2, pt3, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_H(), 7, 0.0, pt2, pt3, (Boolean)false);
                    Modifier2.addDTG(tg, 2, 1.2 * csFactor, 2.2 * csFactor, pt2, pt3, metrics);
                    break;
                }
                case 21200000: 
                case 21300000: 
                case 21400000: {
                    pt0 = tg.Pixels.get(1);
                    pt1 = tg.Pixels.get(2);
                    Modifier2.AddIntegralAreaModifier(tg, label, 6, -0.125 * csFactor, pt0, pt1, (Boolean)true);
                    break;
                }
                case 21500000: 
                case 211700000: {
                    pt0 = tg.Pixels.get(2);
                    pt1 = tg.Pixels.get(3);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, -0.125 * csFactor, pt0, pt1, (Boolean)true);
                    break;
                }
                case 211000000: {
                    pt0 = tg.Pixels.get(4);
                    pt1 = tg.Pixels.get(5);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, -0.125 * csFactor, pt0, pt1, (Boolean)true);
                    break;
                }
                case 211100000: {
                    pt0 = tg.Pixels.get(0);
                    pt1 = tg.Pixels.get(1);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, -0.125 * csFactor, pt0, pt1, (Boolean)true);
                    break;
                }
                case 211400000: 
                case 211600000: 
                case 211900000: 
                case 212100000: {
                    pt0 = tg.Pixels.get(13);
                    pt1 = tg.Pixels.get(14);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, -0.125 * csFactor, pt0, pt1, (Boolean)true);
                    break;
                }
                case 21600000: {
                    pt0 = tg.Pixels.get(13);
                    pt1 = tg.Pixels.get(14);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, -0.125 * csFactor, pt0, pt1, (Boolean)true);
                    for (j = 0; j < n; ++j) {
                        if (tg.Pixels.get((int)j).style != 14) continue;
                        pt0 = tg.Pixels.get(j);
                        pt1 = tg.Pixels.get(j + 1);
                        Modifier2.AddIntegralAreaModifier(tg, "ENY", 2, 0.0, pt0, pt1, (Boolean)true);
                        break block4;
                    }
                    break;
                }
                case 212300000: {
                    pt0 = tg.Pixels.get(26);
                    pt1 = tg.Pixels.get(27);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, -0.125 * csFactor, pt0, pt1, (Boolean)true);
                    break;
                }
                case 25200202: {
                    ptLeft = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
                    ptRight = lineutility.MidPointDouble(tg.Pixels.get(2), tg.Pixels.get(3), 0);
                    Modifier2.AddIntegralAreaModifier(tg, label + TDash + tg.get_Name(), 2, 0.0, ptLeft, ptRight, (Boolean)false);
                    break;
                }
                case 25200402: {
                    if (tg.Pixels.get((int)0).x > tg.Pixels.get((int)3).x) {
                        Modifier2.AddIntegralAreaModifier(tg, label, 2, csFactor, tg.Pixels.get(0), tg.Pixels.get(3), (Boolean)false);
                        break;
                    }
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, csFactor, tg.Pixels.get(1), tg.Pixels.get(2), (Boolean)false);
                    break;
                }
                case 25200300: {
                    ptCenter = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(tg.Pixels.size() / 2), 0);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.0, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.addDTG(tg, 3, csFactor, 2.0 * csFactor, ptCenter, ptCenter, metrics);
                    break;
                }
                case 25200401: {
                    POINT2 lr = new POINT2(tg.Pixels.get(0));
                    POINT2 ll = new POINT2(tg.Pixels.get(0));
                    POINT2 ul = new POINT2(tg.Pixels.get(0));
                    POINT2 ur = new POINT2(tg.Pixels.get(0));
                    Modifier2.GetMBR(tg, ul, ur, lr, ll);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, csFactor, ll, lr, (Boolean)false);
                    break;
                }
                case 23226000: {
                    pt0 = tg.Pixels.get(4);
                    pt1 = tg.Pixels.get(2);
                    if (tg.Pixels.get((int)0).y < tg.Pixels.get((int)1).y) {
                        Modifier2.addDTG(tg, 2, 0.5 * csFactor, 1.5 * csFactor, pt0, pt1, metrics);
                        break;
                    }
                    Modifier2.addDTG(tg, 2, -0.5 * csFactor, -1.5 * csFactor, pt0, pt1, metrics);
                    break;
                }
                case 212500000: 
                case 212600000: {
                    pt0 = tg.Pixels.get(13);
                    pt1 = tg.Pixels.get(0);
                    stringWidth = metrics.stringWidth(label);
                    if (pt0.x < pt1.x) {
                        stringWidth = -stringWidth;
                    }
                    pt1 = lineutility.ExtendAlongLineDouble2(pt0, pt1, 0.75 * (double)stringWidth);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, 0.0, pt0, pt1, (Boolean)true);
                    break;
                }
                case 211200000: {
                    pt0 = tg.Pixels.get(0);
                    pt1 = lineutility.MidPointDouble(tg.Pixels.get(5), tg.Pixels.get(6), 0);
                    pt1 = lineutility.ExtendAlongLineDouble(pt1, pt0, -10.0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 0.0, pt0, pt1, (Boolean)true);
                    break;
                }
                case 211210000: {
                    pt0 = tg.Pixels.get(3);
                    pt1 = tg.Pixels.get(6);
                    pt1 = lineutility.ExtendAlongLineDouble(pt1, pt0, -10.0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 0.0, pt0, pt1, (Boolean)true);
                    break;
                }
                case 24322200: {
                    ptLeft = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
                    ptRight = lineutility.MidPointDouble(tg.Pixels.get(2), tg.Pixels.get(3), 0);
                    Modifier2.AddModifier2(tg, label + TSpace + tg.get_Name(), 2, -3.0 * csFactor, ptLeft, ptRight, false);
                    Modifier2.AddModifier2(tg, tg.get_T1(), 2, -2.0 * csFactor, ptLeft, ptRight, false, "T1");
                    Modifier2.AddModifier2(tg, "MIN ALT: " + tg.get_X(), 2, -1.0 * csFactor, ptLeft, ptRight, false, "H");
                    Modifier2.AddModifier2(tg, "MAX ALT: " + tg.get_X1(), 2, 0.0, ptLeft, ptRight, false, "H1");
                    Modifier2.AddModifier2(tg, "Grids: " + tg.get_H(), 2, 1.0 * csFactor, ptLeft, ptRight, false, "H2");
                    Modifier2.AddModifier2(tg, "EFF: " + tg.get_DTG() + WDash, 2, 2.0 * csFactor, ptLeft, ptRight, false, "W");
                    Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 3.0 * csFactor, ptLeft, ptRight, false, "W1");
                    break;
                }
                case 24322300: {
                    ptCenter = lineutility.CalcCenterPointDouble2(tg.Pixels.toArray(), tg.Pixels.size());
                    Modifier2.AddIntegralAreaModifier(tg, label + TSpace + tg.get_Name(), 3, -3.0 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddModifier2(tg, tg.get_T1(), 3, -2.0 * csFactor, ptCenter, ptCenter, false, "T1");
                    Modifier2.AddIntegralAreaModifier(tg, "MIN ALT: " + tg.get_X(), 3, -1.0 * csFactor, ptCenter, ptCenter, false, "H");
                    Modifier2.AddIntegralAreaModifier(tg, "MAX ALT: " + tg.get_X1(), 3, 0.0, ptCenter, ptCenter, false, "H1");
                    Modifier2.AddIntegralAreaModifier(tg, "Grids: " + tg.get_H(), 3, 1.0 * csFactor, ptCenter, ptCenter, false, "H2");
                    Modifier2.AddIntegralAreaModifier(tg, "EFF: " + tg.get_DTG() + WDash, 3, 2.0 * csFactor, ptCenter, ptCenter, false, "W");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 3, 3.0 * csFactor, ptCenter, ptCenter, false, "W1");
                    break;
                }
                case 24321300: 
                case 24331300: 
                case 24332300: 
                case 24333300: 
                case 24334300: 
                case 24335300: 
                case 24336300: 
                case 24337300: 
                case 24338300: 
                case 24339300: 
                case 24353000: 
                case 24363000: {
                    ptCenter = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(tg.Pixels.size() / 2), 0);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.5 * csFactor, ptCenter, ptCenter, (Boolean)false);
                    Modifier2.AddOffsetModifier(tg, tg.get_DTG() + WDash, 1, -1.0 * csFactor, tg.Pixels.size() / 2, 0, 4.0, "left");
                    Modifier2.AddOffsetModifier(tg, tg.get_DTG1(), 1, 0.0, tg.Pixels.size() / 2, 0, 4.0, "left");
                    break;
                }
                case 24323300: 
                case 24324300: 
                case 24325300: {
                    rfaLines = Modifier2.getRFALines(tg);
                    ptCenter = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(51), 0);
                    switch (rfaLines) {
                        case 3: {
                            Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.0 * csFactor, ptCenter, ptCenter, (Boolean)true);
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, (Boolean)true);
                            Modifier2.addDTG(tg, 3, 1.0 * csFactor, 2.0 * csFactor, ptCenter, ptCenter, metrics);
                            break block4;
                        }
                        case 2: {
                            Modifier2.AddIntegralAreaModifier(tg, label, 3, -0.5 * csFactor, ptCenter, ptCenter, (Boolean)true);
                            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                                Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.5 * csFactor, ptCenter, ptCenter, (Boolean)true);
                                break block4;
                            }
                            Modifier2.addDTG(tg, 3, 0.5 * csFactor, 1.5 * csFactor, ptCenter, ptCenter, metrics);
                            break block4;
                        }
                    }
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, ptCenter, ptCenter, (Boolean)true);
                    break;
                }
                case 21100000: {
                    for (j = 0; j < n; ++j) {
                        if (tg.Pixels.get((int)j).style != 14) continue;
                        Modifier2.AddIntegralModifier(tg, label, 2, 0.0, j, j + 1);
                        break block4;
                    }
                    break;
                }
                case 24323200: 
                case 24324200: 
                case 24325200: {
                    rfaLines = Modifier2.getRFALines(tg);
                    pt0 = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
                    pt1 = lineutility.MidPointDouble(tg.Pixels.get(2), tg.Pixels.get(3), 0);
                    switch (rfaLines) {
                        case 3: {
                            Modifier2.AddModifier2(tg, label, 2, -1.0 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_Name(), 2, 0.0, pt0, pt1, false);
                            Modifier2.addDTG(tg, 2, 1.0 * csFactor, 2.0 * csFactor, pt0, pt1, metrics);
                            break block4;
                        }
                        case 2: {
                            Modifier2.AddModifier2(tg, label, 2, -0.5 * csFactor, pt0, pt1, false);
                            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                                Modifier2.AddModifier2(tg, tg.get_Name(), 2, 0.5 * csFactor, pt0, pt1, false);
                                break block4;
                            }
                            Modifier2.addDTG(tg, 2, 0.5 * csFactor, 1.5 * csFactor, pt0, pt1, metrics);
                            break block4;
                        }
                    }
                    Modifier2.AddModifier2(tg, label, 2, 0.0, pt0, pt1, false);
                    break;
                }
                case 24321200: 
                case 24331200: 
                case 24332200: 
                case 24333200: 
                case 24334200: 
                case 24335200: 
                case 24336200: 
                case 24337200: 
                case 24338200: 
                case 24339200: 
                case 24352000: 
                case 24362000: {
                    ptLeft = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
                    ptRight = lineutility.MidPointDouble(tg.Pixels.get(2), tg.Pixels.get(3), 0);
                    Modifier2.AddModifier2(tg, label, 2, -0.5 * csFactor, ptLeft, ptRight, false);
                    Modifier2.AddModifier2(tg, tg.get_Name(), 2, 0.5 * csFactor, ptLeft, ptRight, false);
                    pt0 = tg.Pixels.get(0);
                    pt1 = tg.Pixels.get(1);
                    pt2 = tg.Pixels.get(2);
                    pt3 = tg.Pixels.get(3);
                    if (tg.get_Client().equalsIgnoreCase("ge")) {
                        pt0.x -= (double)(font.getSize() / 2);
                        pt2.x -= (double)(font.getSize() / 2);
                    }
                    if (!tg.get_Client().equalsIgnoreCase("ge")) {
                        clsUtility.shiftModifiersLeft(pt0, pt3, 12.5);
                        clsUtility.shiftModifiersLeft(pt1, pt2, 12.5);
                    }
                    if (ptLeft.x == ptRight.x) {
                        ptRight.x += 1.0;
                    }
                    if (ptLeft.x < ptRight.x) {
                        Modifier2.AddModifier(tg, tg.get_DTG() + WDash, 1, 0.0, pt0, pt3);
                        Modifier2.AddModifier(tg, tg.get_DTG1(), 1, 1.0 * csFactor, pt0, pt3);
                        break;
                    }
                    Modifier2.AddModifier(tg, tg.get_DTG() + WDash, 1, 0.0, pt2, pt1);
                    Modifier2.AddModifier(tg, tg.get_DTG1(), 1, 1.0 * csFactor, pt2, pt1);
                    break;
                }
                case 24326100: {
                    Modifier2.AddIntegralModifier(tg, label, 6, 0.0, 0, 1, true);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, 1, 2, true);
                    Modifier2.AddIntegralModifier(tg, label, 6, 0.0, 2, 3, true);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, 3, 0, true);
                    rfaLines = Modifier2.getRFALines(tg);
                    pt0 = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
                    pt1 = lineutility.MidPointDouble(tg.Pixels.get(2), tg.Pixels.get(3), 0);
                    switch (rfaLines) {
                        case 3: {
                            Modifier2.AddModifier2(tg, tg.get_Name(), 2, -0.5, pt0, pt1, false);
                            Modifier2.addDTG(tg, 2, 0.5 * csFactor, 1.5 * csFactor, pt0, pt1, metrics);
                            break block4;
                        }
                        case 2: {
                            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                                Modifier2.AddModifier2(tg, tg.get_Name(), 2, 0.0, pt0, pt1, false);
                                break block4;
                            }
                            Modifier2.addDTG(tg, 2, 0.0, csFactor, pt0, pt1, metrics);
                            break block4;
                        }
                    }
                    break;
                }
                case 24326200: {
                    for (int i = 0; i < 4; ++i) {
                        Modifier2.AddIntegralModifier(tg, label, 3, -0.5 * csFactor, n / 4 * i, n / 4 * i, false);
                    }
                    rfaLines = Modifier2.getRFALines(tg);
                    ptCenter = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get((int)((double)n / 2.0 + 0.5)), 0);
                    switch (rfaLines) {
                        case 3: {
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -0.5, ptCenter, ptCenter, (Boolean)false);
                            Modifier2.addDTG(tg, 3, 0.5 * csFactor, 1.5 * csFactor, ptCenter, ptCenter, metrics);
                            break block4;
                        }
                        case 2: {
                            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                                Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, (Boolean)false);
                                break block4;
                            }
                            Modifier2.addDTG(tg, 3, 0.0, csFactor, ptCenter, ptCenter, metrics);
                            break block4;
                        }
                    }
                    break;
                }
                case 243111000: {
                    if (tg.get_X() != null) {
                        X = tg.get_X().split(",");
                        for (j = 0; j < X.length; ++j) {
                            if (tg.Pixels.size() <= j * 102 + 25) continue;
                            pt0 = tg.Pixels.get(j * 102 + 25);
                            Modifier2.AddAreaModifier(tg, "ALT " + X[j], 3, 0.0, pt0, pt0);
                        }
                    }
                    if (tg.get_HideOptionalLabels()) break;
                    String[] am = tg.get_AM().split(",");
                    for (j = 0; j < am.length; ++j) {
                        if (tg.Pixels.size() <= j * 102 + 25) continue;
                        pt0 = tg.Pixels.get(j * 102 + 25);
                        if (j == 0) {
                            Modifier2.AddAreaModifier(tg, "MIN RG " + am[j], 3, -1.0, pt0, pt0);
                            continue;
                        }
                        Modifier2.AddAreaModifier(tg, "MAX RG (" + Integer.toString(j) + ") " + am[j], 3, -1.0, pt0, pt0);
                    }
                    break;
                }
                case 25200700: 
                case 243112000: {
                    Modifier2.addSectorModifiers(tg, converter);
                    break;
                }
            }
            Modifier2.scaleModifiers(tg);
            tg.Pixels = origPoints;
            g2d.dispose();
            g2d = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifiers2", new RendererException("Failed inside AddModifiers2", exc));
        }
    }

    public static void DisplayModifiers(TGLight tg, Graphics2D g2d) {
        try {
            Font font = g2d.getFont();
            int j = 0;
            Modifier2 modifier = null;
            g2d.setBackground(Color.white);
            POINT2 pt = null;
            double theta = 0.0;
            int stringWidth = 0;
            int stringHeight = 0;
            FontMetrics metrics = g2d.getFontMetrics();
            String s = "";
            int x = 0;
            int y = 0;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            int quadrant = -1;
            int n = tg.Pixels.size();
            block14: for (j = 0; j < n; ++j) {
                modifier = tg.modifiers.get(j);
                double lineFactor = modifier.lineFactor;
                s = modifier.text;
                double x1 = 0.0;
                double y1 = 0.0;
                double x2 = 0.0;
                double y2 = 0.0;
                pt = modifier.textPath[0];
                x1 = pt.x;
                y1 = pt.y;
                pt = modifier.textPath[1];
                x2 = pt.x;
                y2 = pt.y;
                theta = Math.atan2(y2 - y1, x2 - x1);
                if (x1 > x2) {
                    theta -= Math.PI;
                }
                switch (modifier.type) {
                    case 1: {
                        g2d.rotate(theta, x1, y1);
                        stringWidth = metrics.stringWidth(s);
                        stringHeight = font.getSize();
                        if (x1 < x2 || x1 == x2 && y1 > y2) {
                            x = (int)x1 - stringWidth;
                            y = (int)y1 - stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                            g2d.setColor(tg.get_FontBackColor());
                            g2d.clearRect(x, y, stringWidth, stringHeight);
                            y = (int)y1 + stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                            g2d.setColor(tg.get_TextColor());
                            g2d.drawString(s, x, y);
                            continue block14;
                        }
                        x = (int)x1;
                        y = (int)y1 - stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_FontBackColor());
                        g2d.clearRect(x, y, stringWidth, stringHeight);
                        y = (int)y1 + stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_TextColor());
                        g2d.drawString(s, x, y);
                        continue block14;
                    }
                    case 2: {
                        POINT2 midPt = new POINT2((x1 + x2) / 2.0, (y1 + y2) / 2.0);
                        g2d.rotate(theta, midPt.x, midPt.y);
                        stringWidth = metrics.stringWidth(s);
                        stringHeight = font.getSize();
                        x = (int)midPt.x - stringWidth / 2;
                        y = (int)midPt.y - stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_FontBackColor());
                        g2d.clearRect(x, y, stringWidth, stringHeight);
                        y = (int)midPt.y + stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_TextColor());
                        g2d.drawString(s, x, y);
                        continue block14;
                    }
                    case 3: {
                        g2d.rotate(0.0, x1, y1);
                        stringWidth = metrics.stringWidth(s);
                        stringHeight = font.getSize();
                        x = (int)x1 - stringWidth / 2;
                        y = (int)y1 - stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_FontBackColor());
                        g2d.clearRect(x, y, stringWidth, stringHeight);
                        y = (int)y1 + stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_TextColor());
                        g2d.drawString(s, x, y);
                        continue block14;
                    }
                    case 4: {
                        if (tg.Pixels.size() >= 14) {
                            pt1 = tg.Pixels.get(3);
                            pt2 = tg.Pixels.get(10);
                            quadrant = lineutility.GetQuadrantDouble(pt1, pt2);
                            theta = Math.atan2(pt2.y - pt1.y, pt2.x - pt1.x);
                            switch (quadrant) {
                                case 1: {
                                    theta += 1.5707963267948966;
                                    break;
                                }
                                case 2: {
                                    theta -= 1.5707963267948966;
                                    break;
                                }
                                case 3: {
                                    theta -= 1.5707963267948966;
                                    break;
                                }
                                case 4: {
                                    theta += 1.5707963267948966;
                                    break;
                                }
                            }
                            g2d.rotate(theta, x1, y1);
                            stringWidth = metrics.stringWidth(s);
                            stringHeight = font.getSize();
                            x = (int)x1 - stringWidth / 2;
                            y = (int)y1 - stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                            g2d.setColor(tg.get_FontBackColor());
                            g2d.clearRect(x, y, stringWidth, stringHeight);
                            y = (int)y1 + stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                            g2d.setColor(tg.get_TextColor());
                            g2d.drawString(s, x, y);
                            continue block14;
                        }
                        stringWidth = metrics.stringWidth(s);
                        stringHeight = font.getSize();
                        x = (int)tg.Pixels.get((int)0).x;
                        y = (int)tg.Pixels.get((int)0).y;
                        g2d.setColor(tg.get_FontBackColor());
                        g2d.clearRect(x, y, stringWidth, stringHeight);
                        y = y + stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_TextColor());
                        g2d.drawString(s, x, y);
                        continue block14;
                    }
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DisplayModifiers", new RendererException("Failed inside DisplayModifiers", exc));
        }
    }

    public static Shape2 BuildModifierShape(TGLight tg, POINT2 pt0, POINT2 pt1, int stringWidth, int stringHeight, double lineFactor, boolean isTextFlipped) {
        Shape2 modifierFill = null;
        try {
            POINT2 ptTemp0 = new POINT2(pt0);
            POINT2 ptTemp1 = new POINT2(pt1);
            if (isTextFlipped) {
                lineFactor += 1.0;
            }
            if (lineFactor < 0.0) {
                ptTemp0 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 2, -lineFactor * (double)stringHeight);
                ptTemp1 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 2, -lineFactor * (double)stringHeight);
            }
            if (lineFactor > 0.0) {
                ptTemp0 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 3, lineFactor * (double)stringHeight);
                ptTemp1 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 3, lineFactor * (double)stringHeight);
            }
            if (ptTemp0.y == ptTemp1.y) {
                ptTemp0.y += 1.0;
            }
            POINT2 pt3 = null;
            POINT2 pt4 = null;
            POINT2 pt5 = null;
            POINT2 pt6 = null;
            POINT2 pt7 = null;
            pt3 = lineutility.ExtendAlongLineDouble(ptTemp0, ptTemp1, -stringWidth);
            pt4 = lineutility.ExtendDirectedLine(ptTemp1, ptTemp0, pt3, 0, stringHeight / 2);
            pt5 = lineutility.ExtendDirectedLine(ptTemp1, ptTemp0, pt3, 1, stringHeight / 2);
            pt6 = lineutility.ExtendDirectedLine(ptTemp1, ptTemp0, ptTemp0, 1, stringHeight / 2);
            pt7 = lineutility.ExtendDirectedLine(ptTemp1, ptTemp0, ptTemp0, 0, stringHeight / 2);
            modifierFill = new Shape2(Shape2.SHAPE_TYPE_MODIFIER_FILL);
            modifierFill.moveTo(pt4);
            modifierFill.lineTo(pt5);
            modifierFill.lineTo(pt6);
            modifierFill.lineTo(pt7);
            modifierFill.lineTo(pt4);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "BuildModifierShape", new RendererException("Failed inside BuildModifierShape", exc));
        }
        return modifierFill;
    }

    public static void GetIntegralTextShapes(TGLight tg, Graphics2D g2d, ArrayList<Shape2> shapes) {
        try {
            if (tg.Pixels == null || shapes == null) {
                return;
            }
            HashMap<Integer, Color> hmap = clsUtility.getMSRSegmentColors(tg);
            Color color = null;
            Shape2 shape = null;
            Shape2 segShape = null;
            g2d.setFont(tg.get_Font());
            int j = 0;
            Object affiliation = null;
            FontMetrics metrics = g2d.getFontMetrics();
            String echelonSymbol = null;
            int stringWidthEchelonSymbol = 0;
            POINT2 ptEchelonStart = null;
            POINT2 ptEchelonEnd = null;
            Object ptENY0Start = null;
            Object ptENY0End = null;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            double dist = 0.0;
            BasicStroke stroke = null;
            switch (tg.get_LineType()) {
                case 22121000: {
                    echelonSymbol = tg.get_EchelonSymbol();
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.setLineColor(tg.get_LineColor());
                    shape.set_Style(tg.get_LineStyle());
                    stroke = clsUtility.getLineStroke(tg.get_LineThickness(), shape.get_Style(), tg.get_lineCap(), 1);
                    shape.setStroke(stroke);
                    if (echelonSymbol != null && !echelonSymbol.isEmpty()) {
                        stringWidthEchelonSymbol = metrics.stringWidth(echelonSymbol);
                    }
                    if (hmap == null || hmap.isEmpty()) {
                        shape.moveTo(tg.Pixels.get(0));
                        for (j = 1; j < tg.Pixels.size(); ++j) {
                            shape.lineTo(tg.Pixels.get(j));
                        }
                        shapes.add(shape);
                        break;
                    }
                    int n = tg.Pixels.size();
                    for (j = 0; j < n - 1; ++j) {
                        segShape = null;
                        if (hmap != null && hmap.containsKey(j)) {
                            color = hmap.get(j);
                            segShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                            segShape.setLineColor(color);
                            segShape.set_Style(tg.get_LineStyle());
                            segShape.setStroke(stroke);
                        }
                        pt0 = tg.Pixels.get(j);
                        pt1 = tg.Pixels.get(j + 1);
                        if (segShape != null) {
                            segShape.moveTo(pt0);
                        } else {
                            shape.moveTo(pt0);
                        }
                        if (tg.get_Client().equals("ge") || Modifier2.GetBoundarySegmentTooShort(tg, g2d, j)) {
                            if (segShape != null) {
                                segShape.lineTo(pt1);
                                shapes.add(segShape);
                                continue;
                            }
                            shape.lineTo(pt1);
                            continue;
                        }
                        POINT2 midpt = lineutility.MidPointDouble(pt0, pt1, 0);
                        if (segShape != null) {
                            segShape.moveTo(pt0);
                        } else {
                            shape.moveTo(pt0);
                        }
                        if (stringWidthEchelonSymbol > 0) {
                            midpt = lineutility.MidPointDouble(pt0, pt1, 0);
                            dist = lineutility.CalcDistanceDouble(pt0, midpt) - (double)stringWidthEchelonSymbol / 1.5;
                            ptEchelonStart = lineutility.ExtendAlongLineDouble(pt0, pt1, dist);
                            dist = lineutility.CalcDistanceDouble(pt0, midpt) + (double)stringWidthEchelonSymbol / 1.5;
                            ptEchelonEnd = lineutility.ExtendAlongLineDouble(pt0, pt1, dist);
                            if (segShape != null) {
                                segShape.lineTo(ptEchelonStart);
                                segShape.moveTo(ptEchelonEnd);
                            } else {
                                shape.lineTo(ptEchelonStart);
                                shape.moveTo(ptEchelonEnd);
                            }
                        }
                        if (segShape != null) {
                            segShape.lineTo(pt1);
                        } else {
                            shape.lineTo(pt1);
                        }
                        if (segShape == null) continue;
                        shapes.add(segShape);
                    }
                    shapes.add(shape);
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetIntegralTextShapes", new RendererException("Failed inside GetIntegralTextShapes", exc));
        }
    }

    private static int switchDirection(int direction) {
        int result = -1;
        switch (direction) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return result;
    }

    public static void DisplayModifiers2(TGLight tg, Graphics2D g2d, ArrayList<Shape2> shapes, boolean isTextFlipped, IPointConversion converter) {
        try {
            if (shapes == null) {
                return;
            }
            if (tg.modifiers == null || tg.modifiers.isEmpty()) {
                return;
            }
            Font font = null;
            int j = 0;
            Modifier2 modifier = null;
            Color fontBackColor = tg.get_FontBackColor();
            double theta = 0.0;
            double stringWidth = 0.0;
            double stringHeight = 0.0;
            String s = "";
            BufferedImage image = null;
            int x = 0;
            int y = 0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            int quadrant = -1;
            Shape2 shape2 = null;
            long lineType = tg.get_LineType();
            font = tg.get_Font();
            if (font == null) {
                font = g2d.getFont();
            }
            if (font.getSize() == 0) {
                return;
            }
            g2d.setFont(font);
            FontMetrics metrics = g2d.getFontMetrics();
            if (fontBackColor != null) {
                g2d.setBackground(fontBackColor);
            } else {
                g2d.setBackground(Color.white);
            }
            int direction = -1;
            Point glyphPosition = null;
            for (j = 0; j < tg.modifiers.size(); ++j) {
                modifier = tg.modifiers.get(j);
                double lineFactor = modifier.lineFactor;
                if (isTextFlipped) {
                    lineFactor = -lineFactor;
                }
                if (((s = modifier.text) == null || s.equals("")) && (image = modifier.image) == null) continue;
                stringWidth = s != null ? (double)metrics.stringWidth(s) + 1.0 : (double)(image.getWidth() + 1);
                stringHeight = s != null ? (double)font.getSize() : (double)image.getHeight();
                double x1 = 0.0;
                double y1 = 0.0;
                double x2 = 0.0;
                double y2 = 0.0;
                double dist = 0.0;
                pt0 = modifier.textPath[0];
                x1 = Math.round(pt0.x);
                y1 = Math.round(pt0.y);
                pt1 = modifier.textPath[1];
                x2 = Math.round(pt1.x);
                y2 = Math.round(pt1.y);
                theta = Math.atan2(y2 - y1, x2 - x1);
                if (x1 > x2) {
                    theta -= Math.PI;
                }
                pt0 = new POINT2(x1, y1);
                pt1 = new POINT2(x2, y2);
                POINT2 midPt = new POINT2((x1 + x2) / 2.0, (y1 + y2) / 2.0);
                Point2D.Double modifierPosition = null;
                int justify = ShapeInfo.justify_left;
                switch (modifier.type) {
                    case 1: 
                    case 5: {
                        if (x1 == x2) {
                            x2 += 1.0;
                        }
                        direction = lineFactor >= 0.0 ? 2 : 3;
                        if (lineType == 22123000L || tg.get_Client().equalsIgnoreCase("ge")) {
                            direction = Modifier2.switchDirection(direction);
                        }
                        justify = modifier.type == 1 && x1 < x2 || modifier.type == 5 && x2 < x1 ? ShapeInfo.justify_right : ShapeInfo.justify_left;
                        pt3 = lineutility.ExtendDirectedLine(pt1, pt0, pt0, direction, lineFactor * stringHeight);
                        glyphPosition = new Point((int)pt3.x, (int)pt3.y);
                        modifierPosition = new Point2D.Double(pt3.x, pt3.y);
                        break;
                    }
                    case 7: {
                        pt3 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        glyphPosition = new Point((int)pt3.x, (int)pt3.y);
                        modifierPosition = new Point2D.Double((int)pt3.x, pt3.y);
                        break;
                    }
                    case 8: {
                        pt3 = lineutility.ExtendAlongLineDouble(pt1, pt0, stringWidth);
                        glyphPosition = new Point((int)pt3.x, (int)pt3.y);
                        modifierPosition = new Point2D.Double((int)pt3.x, pt3.y);
                        break;
                    }
                    case 2: 
                    case 6: {
                        pt2 = midPt;
                        if (tg.get_Client().equals("2D")) {
                            lineFactor += 0.5;
                        }
                        if (lineFactor >= 0.0) {
                            pt3 = lineutility.ExtendDirectedLine(pt0, pt2, pt2, 3, Math.abs(lineFactor * stringHeight));
                            midPt = lineutility.ExtendDirectedLine(pt0, midPt, midPt, 3, Math.abs(lineFactor * stringHeight));
                        } else {
                            pt3 = lineutility.ExtendDirectedLine(pt0, pt2, pt2, 2, Math.abs(lineFactor * stringHeight));
                            midPt = lineutility.ExtendDirectedLine(pt0, midPt, midPt, 2, Math.abs(lineFactor * stringHeight));
                        }
                        if (x1 == x2 && y1 > y2) {
                            pt3 = lineutility.ExtendDirectedLine(pt0, pt2, pt2, 1, Math.abs(lineFactor * stringHeight));
                            midPt = lineutility.ExtendDirectedLine(pt0, midPt, midPt, 1, Math.abs(lineFactor * stringHeight));
                        }
                        if (x1 == x2 && y1 < y2) {
                            pt3 = lineutility.ExtendDirectedLine(pt0, pt2, pt2, 0, Math.abs(lineFactor * stringHeight));
                            midPt = lineutility.ExtendDirectedLine(pt0, midPt, midPt, 0, Math.abs(lineFactor * stringHeight));
                        }
                        glyphPosition = new Point((int)pt3.x, (int)pt3.y);
                        justify = ShapeInfo.justify_center;
                        modifierPosition = new Point2D.Double(midPt.x, midPt.y);
                        if (modifier.type != 6) break;
                        if (x1 > x2) {
                            theta += Math.PI;
                        }
                        if (y1 > y2) {
                            theta += Math.PI;
                        }
                        theta -= 1.5707963267948966;
                        break;
                    }
                    case 3: {
                        theta = 0.0;
                        y = (int)y1 + (int)(stringHeight / 2.0) + (int)(lineFactor * stringHeight);
                        x = image != null ? (int)(x1 - stringWidth / 3.0) : (int)x1;
                        glyphPosition = new Point(x, y);
                        justify = ShapeInfo.justify_center;
                        modifierPosition = new Point2D.Double(x, y);
                        break;
                    }
                    case 9: {
                        glyphPosition = new Point((int)x1, (int)y1);
                        justify = ShapeInfo.justify_center;
                        modifierPosition = new Point2D.Double((int)x1, (int)y1);
                        break;
                    }
                    case 4: {
                        if (tg.Pixels.size() >= 14) {
                            pt1 = tg.Pixels.get(3);
                            pt2 = tg.Pixels.get(10);
                            quadrant = lineutility.GetQuadrantDouble(pt1, pt2);
                            theta = Math.atan2(pt2.y - pt1.y, pt2.x - pt1.x);
                            if (Math.abs(theta) < 0.39269908169872414) {
                                theta = theta < 0.0 ? (theta -= 1.5707963267948966) : (theta += 1.5707963267948966);
                            }
                            switch (quadrant) {
                                case 1: {
                                    theta += 1.5707963267948966;
                                    break;
                                }
                                case 2: {
                                    theta -= 1.5707963267948966;
                                    break;
                                }
                                case 3: {
                                    theta -= 1.5707963267948966;
                                    break;
                                }
                                case 4: {
                                    theta += 1.5707963267948966;
                                    break;
                                }
                            }
                            x = (int)x1 - (int)stringWidth / 2;
                            y = (int)y1 - (int)stringHeight / 2 + (int)(lineFactor * stringHeight);
                            y = (int)y1 + (int)(stringHeight / 2.0) + (int)(lineFactor * stringHeight);
                        } else {
                            theta = 0.0;
                            x = (int)tg.Pixels.get((int)0).x;
                            y = (int)tg.Pixels.get((int)0).y;
                            x -= (int)stringWidth / 2;
                            y = y - (int)stringHeight / 2 + (int)(lineFactor * stringHeight);
                            y = y + (int)(stringHeight / 2.0) + (int)(lineFactor * stringHeight);
                        }
                        glyphPosition = new Point(x, y);
                        break;
                    }
                }
                shape2 = new Shape2(Shape2.SHAPE_TYPE_MODIFIER_FILL);
                shape2.setStroke(new BasicStroke(0.0f, 1, 1, 3.0f));
                if (tg.get_TextColor() != null) {
                    shape2.setFillColor(tg.get_TextColor());
                } else if (tg.get_LineColor() != null) {
                    shape2.setFillColor(tg.get_LineColor());
                }
                if (tg.get_LineColor() != null) {
                    shape2.setLineColor(tg.get_LineColor());
                }
                if (converter != null) {
                    shape2.setGlyphPosition(glyphPosition);
                } else {
                    shape2.setGlyphPosition(new Point2D.Double(0.0, 0.0));
                }
                if (s != null && !s.equals("")) {
                    shape2.setModifierString(s);
                    TextLayout tl = new TextLayout(s, font, g2d.getFontMetrics().getFontRenderContext());
                    shape2.setTextLayout(tl);
                    shape2.setTextJustify(justify);
                } else if (image != null) {
                    shape2.setModifierImage(image);
                }
                shape2.setModifierAngle(theta * 180.0 / Math.PI);
                shape2.setModifierPosition(modifierPosition);
                if (shape2 == null) continue;
                shapes.add(shape2);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DisplayModifiers2", exc);
        }
    }

    public static Shape getTextShape(Graphics2D g2d, String str, Font font, AffineTransform tx) {
        TextLayout tl = null;
        FontRenderContext frc = null;
        try {
            frc = g2d.getFontRenderContext();
            tl = new TextLayout(str, font, frc);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getTextShape", new RendererException("Failed inside getTextShape", exc));
        }
        return tl.getOutline(tx);
    }

    public static Shape2 createTextOutline(Shape2 originalText) {
        Shape2 siOutline = null;
        try {
            Shape outline = originalText.getShape();
            siOutline = new Shape2(Shape2.SHAPE_TYPE_MODIFIER_FILL);
            siOutline.setShape(outline);
            if (originalText.getFillColor().getRed() == 255 && originalText.getFillColor().getGreen() == 255 && originalText.getFillColor().getBlue() == 255) {
                siOutline.setLineColor(Color.BLACK);
            } else {
                siOutline.setLineColor(Color.WHITE);
            }
            int width = RendererSettings.getInstance().getTextOutlineWidth();
            siOutline.setStroke(new BasicStroke(width, 1, 1, 3.0f));
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "createTextOutline", new RendererException("Failed inside createTextOutline", exc));
        }
        return siOutline;
    }

    private static ArrayList<POINT2> getShapePoints(Shape shape) {
        try {
            int type;
            ArrayList<Point2D.Double> ptsPoly = new ArrayList<Point2D.Double>();
            Point2D.Double ptPoly = null;
            double[] coords = new double[6];
            int zeros = 0;
            PathIterator i = shape.getPathIterator(null);
            while (!(i.isDone() || (type = i.currentSegment(coords)) == 0 && zeros == 2)) {
                switch (type) {
                    case 0: {
                        ptPoly = new Point2D.Double(coords[0], coords[1]);
                        ptsPoly.add(ptPoly);
                        ++zeros;
                        break;
                    }
                    case 1: {
                        ptPoly = new Point2D.Double(coords[0], coords[1]);
                        ptsPoly.add(ptPoly);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                i.next();
            }
            if (ptsPoly.size() > 0) {
                ArrayList<POINT2> pts = null;
                pts = new ArrayList<POINT2>();
                for (int j = 0; j < ptsPoly.size(); ++j) {
                    Point2D pt2d = (Point2D)ptsPoly.get(j);
                    POINT2 pt = new POINT2(pt2d.getX(), pt2d.getY());
                    pts.add(pt);
                }
                return pts;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getshapePoints", new RendererException("Failed inside getShapePoints", exc));
        }
        return null;
    }

    private static BufferedImage getImageModifier(TGLight tg) {
        String symbolID = tg.get_SymbolId();
        ImageInfo symbol = null;
        HashMap<String, String> mods = new HashMap<String, String>();
        HashMap<String, String> sa = new HashMap<String, String>();
        sa.put("PIXELSIZE", String.valueOf(tg.getIconSize()));
        int contaminationCode = EntityCode.getSymbolForContaminationArea(SymbolID.getEntityCode(symbolID));
        int modifier1Code = SymbolID.getModifier1(symbolID);
        int lineType = clsUtility.GetLinetypeFromString(symbolID);
        if (contaminationCode > 0) {
            sa.put("OUTLINESYMBOL", "true");
            sa.put("FILLCOLOR", RendererUtilities.colorToHexString(tg.get_FillColor(), true));
            sa.put("LINECOLOR", RendererUtilities.colorToHexString(tg.get_LineColor(), true));
            String contaminationSP = SymbolID.setEntityCode(symbolID, contaminationCode);
            contaminationSP = SymbolID.setHQTFD(contaminationSP, 0);
            symbol = SinglePointRenderer.getInstance().RenderSP2(contaminationSP, mods, sa);
        } else if (lineType == 23162000 || lineType == 23164000 || lineType == 270801 || lineType == 290101) {
            if (modifier1Code < 13 || modifier1Code > 50) {
                modifier1Code = 13;
                symbolID = SymbolID.setModifier1(symbolID, modifier1Code);
            }
            if (tg.get_KeepUnitRation()) {
                sa.put("PIXELSIZE", String.valueOf((int)((double)tg.getIconSize() * 1.5)));
            }
            sa.put("OUTLINESYMBOL", "true");
            symbol = SinglePointRenderer.getInstance().RenderModifier2(symbolID, sa);
        } else if (lineType == 221310000 && modifier1Code > 0) {
            sa.put("OUTLINESYMBOL", "true");
            sa.put("FILLCOLOR", RendererUtilities.colorToHexString(tg.get_FillColor(), true));
            sa.put("LINECOLOR", RendererUtilities.colorToHexString(tg.get_LineColor(), true));
            if (tg.get_KeepUnitRation()) {
                sa.put("PIXELSIZE", String.valueOf((int)((double)tg.getIconSize() * 1.5)));
            }
            symbol = SinglePointRenderer.getInstance().RenderModifier2(symbolID, sa);
        } else if (lineType == 32231400 || lineType == 32231500) {
            sa.put("OUTLINESYMBOL", "false");
            String anchorPoint = SymbolID.setEntityCode(symbolID, 120304);
            symbol = SinglePointRenderer.getInstance().RenderSP2(anchorPoint, mods, sa);
        }
        if (symbol != null) {
            return symbol.getImage();
        }
        return null;
    }
}

