/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.JavaTacticalRenderer;

import armyc2.c5isr.JavaLineArray.CELineArray;
import armyc2.c5isr.JavaLineArray.Channels;
import armyc2.c5isr.JavaLineArray.POINT2;
import armyc2.c5isr.JavaLineArray.Shape2;
import armyc2.c5isr.JavaLineArray.arraysupport;
import armyc2.c5isr.JavaLineArray.lineutility;
import armyc2.c5isr.JavaLineArray.ref;
import armyc2.c5isr.JavaTacticalRenderer.P1;
import armyc2.c5isr.JavaTacticalRenderer.TGLight;
import armyc2.c5isr.JavaTacticalRenderer.clsUtility;
import armyc2.c5isr.RenderMultipoints.clsRenderer2;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.renderer.utilities.RendererException;
import armyc2.c5isr.renderer.utilities.SymbolID;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public final class clsChannelUtility {
    private static final String _className = "clsChannelUtility";

    private static int GetPartitions(boolean[] segments, ArrayList<P1> partitions) {
        try {
            int j = 0;
            boolean nextSegment = false;
            P1 p1 = new P1();
            if (!segments[0]) {
                return 0;
            }
            if (partitions == null) {
                return 0;
            }
            partitions.clear();
            p1.start = 0;
            int n = segments.length;
            for (j = 0; j < n - 1; ++j) {
                nextSegment = segments[j + 1];
                if (nextSegment) continue;
                p1.end_Renamed = j;
                partitions.add(p1);
                p1 = new P1();
                p1.start = j + 1;
            }
            p1.end_Renamed = j;
            partitions.add(p1);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetPartitions", new RendererException("Failed inside GetPartitions", exc));
        }
        return partitions.size();
    }

    private static int DrawGoodChannel2(TGLight tg, int fromSegment, int toSegment, double[] pixels, int channelWidth, boolean bolLastSegment, ArrayList<Shape2> shapes, ArrayList<POINT2> channelPoints, double distanceToChannelPoint) {
        int returnValue = 0;
        try {
            int j;
            int lineType2;
            int lineType = tg.get_LineType();
            double[] channelPixels = null;
            switch (lineType) {
                case 22123000: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: {
                    lineType2 = lineType;
                    break;
                }
                case 22521420: {
                    if (fromSegment == 0) {
                        lineType2 = 231113002;
                        break;
                    }
                    lineType2 = 231113001;
                    break;
                }
                case 22521410: {
                    if (fromSegment == 0) {
                        lineType2 = 231113002;
                        break;
                    }
                    lineType2 = 231113001;
                    break;
                }
                case 21700000: {
                    lineType2 = 231113003;
                    break;
                }
                case 21710000: {
                    lineType2 = 231113003;
                    break;
                }
                default: {
                    lineType2 = 231113001;
                }
            }
            if (bolLastSegment) {
                if (fromSegment != 0) {
                    switch (lineType) {
                        case 22521420: {
                            lineType2 = 22521421;
                            break;
                        }
                        case 22521410: {
                            lineType2 = 22521411;
                            break;
                        }
                        default: {
                            lineType2 = lineType;
                            break;
                        }
                    }
                } else {
                    lineType2 = lineType;
                }
            }
            if (fromSegment < 0) {
                return returnValue;
            }
            if (toSegment < 0) {
                return returnValue;
            }
            if (toSegment < fromSegment) {
                return returnValue;
            }
            int numPoints = toSegment - fromSegment + 2;
            double[] goodUpperPixels = new double[2 * numPoints];
            double[] goodLowerPixels = new double[2 * numPoints];
            int counter = 0;
            for (j = fromSegment; j < toSegment + 2; ++j) {
                goodUpperPixels[counter] = pixels[2 * j];
                goodUpperPixels[counter + 1] = pixels[2 * j + 1];
                goodLowerPixels[counter] = pixels[2 * j];
                goodLowerPixels[counter + 1] = pixels[2 * j + 1];
                counter += 2;
            }
            tg.set_LineType(lineType2);
            int lineCount = CELineArray.CGetLineCountDouble(tg, goodUpperPixels, numPoints, channelWidth);
            channelPixels = new double[3 * lineCount];
            POINT2 pt = null;
            lineCount = Channels.GetChannel1Double(tg, goodUpperPixels, goodLowerPixels, channelPixels, numPoints, numPoints, channelWidth / 2, (int)distanceToChannelPoint, shapes);
            tg.set_LineType(lineType);
            if (shapes == null && channelPixels != null) {
                int n = channelPixels.length;
                for (j = 0; j < n / 3; ++j) {
                    pt = new POINT2(channelPixels[3 * j], channelPixels[3 * j + 1], (int)channelPixels[3 * j + 2]);
                    if (j == channelPixels.length / 3 - 1) {
                        pt.style = 5;
                    }
                    channelPoints.add(pt);
                }
            }
            returnValue = lineCount > 0 ? channelPixels.length : 0;
            if (lineCount > 0) {
                channelPixels[lineCount - 1] = 5.0;
            }
            goodUpperPixels = null;
            goodLowerPixels = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DrawGoodChannel2", new RendererException("Failed inside DrawGoodChannel2", exc));
        }
        return returnValue;
    }

    private static void DrawSegments(TGLight tg, double[] pixels, ArrayList<P1> partitions, int channelWidth, ArrayList<Shape2> shapes, ArrayList<POINT2> channelPoints, double distanceToChannelPoint) {
        try {
            int j = 0;
            int n = 0;
            int t = partitions.size();
            for (j = 0; j < t - 1; ++j) {
                n = clsChannelUtility.DrawGoodChannel2(tg, partitions.get((int)j).start, partitions.get((int)j).end_Renamed, pixels, channelWidth, false, shapes, channelPoints, distanceToChannelPoint);
            }
            n = clsChannelUtility.DrawGoodChannel2(tg, partitions.get((int)j).start, partitions.get((int)j).end_Renamed, pixels, channelWidth, true, shapes, channelPoints, distanceToChannelPoint);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DrawSegments", new RendererException("Failed inside DrawSegments", exc));
        }
    }

    private static void DrawLCSingleLineSegments(TGLight tg, double[] pixels2, ArrayList<P1> singleLinePartitions, ArrayList<Shape2> shapes, Rectangle2D clipBounds, IPointConversion converter) {
        try {
            for (P1 flotPartition : singleLinePartitions) {
                int vblSaveCounter = flotPartition.end_Renamed - flotPartition.start + 1;
                ArrayList<POINT2> flotPixels = new ArrayList<POINT2>();
                for (int i = 0; i < vblSaveCounter; ++i) {
                    flotPixels.add(new POINT2(pixels2[2 * (i + flotPartition.start)], pixels2[2 * (i + flotPartition.start) + 1]));
                }
                String flotID = tg.get_SymbolId();
                flotID = SymbolID.setAffiliation(flotID, 6);
                flotID = SymbolID.setEntityCode(flotID, 140100);
                TGLight flotTG = new TGLight();
                flotTG.set_LineType(22122000);
                flotTG.set_Pixels(flotPixels);
                flotTG.set_SymbolId(flotID);
                flotTG.set_LineThickness(tg.get_LineThickness());
                ArrayList<Shape2> flotShapes = clsRenderer2.GetLineArray(flotTG, converter, false, clipBounds);
                if (flotShapes == null) continue;
                for (Shape2 shape : flotShapes) {
                    shape.setLineColor(Color.RED);
                }
                shapes.addAll(flotShapes);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DrawLCFlotSegments", new RendererException("Failed inside DrawLCFlotSegments", exc));
        }
    }

    private static ArrayList<POINT2> getLCPixels(TGLight tg, ArrayList<POINT2> pixels) {
        ArrayList<POINT2> pixels2 = null;
        try {
            if (tg.get_LineType() != 22123000) {
                return pixels;
            }
            POINT2[] pts = tg.Pixels.toArray(new POINT2[pixels.size()]);
            POINT2 ul = new POINT2();
            POINT2 lr = new POINT2();
            lineutility.CalcMBRPoints(pts, pts.length, ul, lr);
            double flotDiameter = arraysupport.getScaledSize(21.0, tg.get_LineThickness(), tg.get_patternScale());
            if (lr.x - ul.x >= flotDiameter) {
                return pixels;
            }
            if (lr.y - ul.y >= flotDiameter) {
                return pixels;
            }
            double x0 = pts[0].x;
            double y0 = pts[0].y;
            double x1 = pts[1].x;
            double y1 = pts[1].y;
            x1 = x0 <= x1 ? x0 + flotDiameter : x0 - flotDiameter;
            y1 = y0;
            POINT2 pt0 = new POINT2(x0, y0);
            POINT2 pt1 = new POINT2(x1, y1);
            pixels2 = new ArrayList<POINT2>();
            pixels2.add(pt0);
            pixels2.add(pt1);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getLCPixels", new RendererException("Failed inside getLCPixels", exc));
        }
        return pixels2;
    }

    public static void DrawChannel(ArrayList<POINT2> pixels, int linetype, TGLight tg, ArrayList<Shape2> shapes, ArrayList<POINT2> channelPoints, Rectangle2D clipBounds, IPointConversion converter) {
        try {
            pixels = clsChannelUtility.getLCPixels(tg, pixels);
            lineutility.adjustCATKBYFIREControlPoint(linetype, pixels, 45.0);
            int j = 0;
            double[] pixels2 = new double[pixels.size() * 2];
            int n = pixels.size();
            for (j = 0; j < n; ++j) {
                pixels2[2 * j] = pixels.get((int)j).x;
                pixels2[2 * j + 1] = pixels.get((int)j).y;
            }
            clsChannelUtility.DrawChannel2(pixels2, linetype, tg, shapes, channelPoints, clipBounds, converter);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DrawChannel", new RendererException("Failed inside DrawChannel", exc));
        }
    }

    public static ArrayList<P1> GetPartitions2(TGLight tg) {
        ArrayList<P1> partitions = null;
        try {
            double[] pixels = new double[tg.Pixels.size() * 2];
            int n = tg.Pixels.size();
            for (int j = 0; j < n; ++j) {
                pixels[2 * j] = tg.Pixels.get((int)j).x;
                pixels[2 * j + 1] = tg.Pixels.get((int)j).y;
            }
            boolean[] segments = new boolean[pixels.length / 2 - 1];
            if (segments.length == 0) {
                return null;
            }
            double factor = arraysupport.getScaledSize(3.0, tg.get_LineThickness(), tg.get_patternScale());
            clsUtility.GetSegments(pixels, segments, factor);
            partitions = new ArrayList<P1>();
            clsChannelUtility.GetPartitions(segments, partitions);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetPartitions2", new RendererException("Failed inside GetPartitions2", exc));
        }
        return partitions;
    }

    private static void DrawChannel2(double[] pixels, int linetype, TGLight tg, ArrayList<Shape2> shapes, ArrayList<POINT2> channelPoints, Rectangle2D clipBounds, IPointConversion converter) {
        try {
            ref<double[]> distanceToChannelPoint = new ref<double[]>();
            int j = 0;
            double[] pixels2 = null;
            int channelWidth = 0;
            ArrayList<P1> partitions = null;
            int n = pixels.length;
            int numPoints = 0;
            distanceToChannelPoint.value = new double[1];
            ((double[])distanceToChannelPoint.value)[0] = arraysupport.getScaledSize(20.0, tg.get_LineThickness(), tg.get_patternScale());
            switch (linetype) {
                case 21700000: 
                case 21710000: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: {
                    clsUtility.ReorderPixels(pixels);
                    numPoints = pixels.length / 2;
                    if (numPoints < 3) {
                        return;
                    }
                    channelWidth = clsUtility.ChannelWidth(pixels, distanceToChannelPoint) / 2;
                    numPoints = pixels.length / 2;
                    pixels2 = new double[pixels.length - 2];
                    for (j = 0; j < numPoints; ++j) {
                        if (j >= numPoints - 1) continue;
                        pixels2[2 * j] = pixels[2 * j];
                        pixels2[2 * j + 1] = pixels[2 * j + 1];
                    }
                    break;
                }
                case 22123000: {
                    channelWidth = (int)arraysupport.getScaledSize(40.0, tg.get_LineThickness(), tg.get_patternScale());
                    pixels2 = new double[pixels.length];
                    for (double pixels2[j] : pixels) {
                    }
                    break;
                }
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: {
                    tg.set_lineCap(0);
                    channelWidth = (int)arraysupport.getScaledSize(30.0, tg.get_LineThickness(), tg.get_patternScale());
                    if (Channels.getShiftLines()) {
                        channelWidth = (int)arraysupport.getScaledSize(60.0, tg.get_LineThickness(), tg.get_patternScale());
                    }
                    pixels2 = new double[pixels.length];
                    for (double pixels2[j] : pixels) {
                    }
                    break;
                }
            }
            boolean[] segments = new boolean[pixels2.length / 2 - 1];
            if (segments.length == 0) {
                return;
            }
            if (linetype == 22123000) {
                partitions = new ArrayList<P1>();
                ArrayList<P1> singleLinePartitions = new ArrayList<P1>();
                clsUtility.GetLCPartitions(pixels2, arraysupport.getScaledSize(40.0, tg.get_LineThickness(), tg.get_patternScale()), partitions, singleLinePartitions);
                clsChannelUtility.DrawSegments(tg, pixels2, partitions, channelWidth, shapes, channelPoints, ((double[])distanceToChannelPoint.value)[0]);
                if (singleLinePartitions.size() > 0) {
                    clsChannelUtility.DrawLCSingleLineSegments(tg, pixels2, singleLinePartitions, shapes, clipBounds, converter);
                }
            } else {
                double factor = 3.0;
                clsUtility.GetSegments(pixels2, segments, factor);
                partitions = new ArrayList();
                clsChannelUtility.GetPartitions(segments, partitions);
                clsChannelUtility.DrawSegments(tg, pixels2, partitions, channelWidth, shapes, channelPoints, ((double[])distanceToChannelPoint.value)[0]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DrawChannel2", new RendererException("Failed inside DrawChannel2", exc));
        }
    }
}

