/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.JavaTacticalRenderer;

import armyc2.c5isr.JavaLineArray.POINT2;
import armyc2.c5isr.JavaLineArray.Shape2;
import armyc2.c5isr.JavaLineArray.arraysupport;
import armyc2.c5isr.JavaLineArray.lineutility;
import armyc2.c5isr.JavaLineArray.ref;
import armyc2.c5isr.JavaTacticalRenderer.P1;
import armyc2.c5isr.JavaTacticalRenderer.TGLight;
import armyc2.c5isr.JavaTacticalRenderer.clsMETOC;
import armyc2.c5isr.JavaTacticalRenderer.mdlGeodesic;
import armyc2.c5isr.RenderMultipoints.clsRenderer;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.renderer.utilities.MSInfo;
import armyc2.c5isr.renderer.utilities.MSLookup;
import armyc2.c5isr.renderer.utilities.RendererException;
import armyc2.c5isr.renderer.utilities.RendererUtilities;
import armyc2.c5isr.renderer.utilities.SymbolID;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.TexturePaint;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;

public final class clsUtility {
    private static final String _className = "clsUtility";

    protected static Point2D POINT2ToPoint2D(POINT2 pt2) {
        if (pt2 == null) {
            return null;
        }
        double x = pt2.x;
        double y = pt2.y;
        Point2D.Double pt = new Point2D.Double(x, y);
        return pt;
    }

    public static boolean linesOutsideClipBounds(TGLight tg, Rectangle2D clipBounds) {
        try {
            boolean isAutoshape = clsUtility.isAutoshape(tg);
            if (isAutoshape) {
                return false;
            }
            double xmin = clipBounds.getMinX();
            double xmax = clipBounds.getMaxX();
            double ymin = clipBounds.getMinY();
            double ymax = clipBounds.getMaxY();
            int j = 0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            Line2D.Double boundsEdge = null;
            Line2D.Double ptsLine = null;
            int n = tg.Pixels.size();
            for (j = 0; j < n - 1; ++j) {
                pt0 = tg.Pixels.get(j);
                pt1 = tg.Pixels.get(j + 1);
                if (clipBounds.contains(pt0.x, pt0.y)) {
                    return false;
                }
                if (clipBounds.contains(pt1.x, pt1.y)) {
                    return false;
                }
                ptsLine = new Line2D.Double(pt0.x, pt0.y, pt1.x, pt1.y);
                boundsEdge = new Line2D.Double(xmin, ymin, xmax, ymin);
                if (ptsLine.intersectsLine(boundsEdge)) {
                    return false;
                }
                boundsEdge = new Line2D.Double(xmax, ymin, xmax, ymax);
                if (ptsLine.intersectsLine(boundsEdge)) {
                    return false;
                }
                boundsEdge = new Line2D.Double(xmax, ymax, xmin, ymax);
                if (ptsLine.intersectsLine(boundsEdge)) {
                    return false;
                }
                boundsEdge = new Line2D.Double(xmin, ymax, xmin, ymin);
                if (!ptsLine.intersectsLine(boundsEdge)) continue;
                return false;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "linesOutsideClipBounds", new RendererException("Failed inside linesOutsideClipBounds", exc));
        }
        return true;
    }

    public static int GetMinPoints(int lineType) {
        int result = -1;
        switch (lineType) {
            case 24311000: 
            case 24312000: 
            case 24321300: 
            case 24322300: 
            case 24323300: 
            case 24324300: 
            case 24325300: 
            case 24326200: 
            case 24331300: 
            case 24332300: 
            case 24333300: 
            case 24334300: 
            case 24335300: 
            case 24336300: 
            case 24337300: 
            case 24338300: 
            case 24339300: 
            case 24353000: 
            case 24363000: 
            case 25170800: 
            case 25200101: 
            case 25200201: 
            case 25200300: 
            case 25200401: 
            case 25200600: 
            case 25200700: 
            case 243111000: 
            case 243112000: {
                result = 1;
                break;
            }
            case 24321200: 
            case 24322200: 
            case 24323200: 
            case 24324200: 
            case 24325200: 
            case 24326100: 
            case 24331200: 
            case 24332200: 
            case 24333200: 
            case 24334200: 
            case 24335200: 
            case 24336200: 
            case 24337200: 
            case 24338200: 
            case 24339200: 
            case 24352000: 
            case 24362000: 
            case 25200202: 
            case 25200402: {
                result = 2;
                break;
            }
            case 22534000: 
            case 23163000: 
            case 23221000: 
            case 23410000: 
            case 211800000: {
                result = 4;
                break;
            }
            case 2514190: 
            case 21100000: 
            case 21200000: 
            case 21300000: 
            case 21400000: 
            case 21500000: 
            case 21600000: 
            case 21800000: 
            case 22139000: 
            case 22422000: 
            case 22524000: 
            case 22533000: 
            case 22611000: 
            case 22613000: 
            case 23171000: 
            case 23173000: 
            case 23174000: 
            case 23191000: 
            case 23192000: 
            case 23193000: 
            case 23194000: 
            case 23211000: 
            case 23212000: 
            case 23213000: 
            case 23224000: 
            case 23225000: 
            case 25141800: 
            case 25344100: 
            case 25344200: 
            case 31710000: 
            case 31720000: 
            case 31730000: 
            case 31740000: 
            case 31750000: 
            case 31751000: 
            case 31760000: 
            case 31770000: 
            case 31780000: 
            case 31790000: 
            case 32214000: 
            case 32222000: 
            case 32223000: 
            case 32224000: 
            case 32225200: 
            case 32231500: 
            case 32232400: 
            case 32233100: 
            case 32233500: 
            case 32244200: 
            case 32253000: 
            case 32254200: 
            case 32255200: 
            case 32311000: 
            case 32312000: 
            case 32313000: 
            case 32314000: 
            case 32315000: 
            case 32316000: 
            case 32317000: 
            case 32318000: 
            case 32319000: 
            case 32321000: 
            case 32322000: 
            case 32323000: 
            case 32324000: 
            case 32411100: 
            case 32411200: 
            case 32411300: 
            case 32411400: 
            case 32411500: 
            case 32411600: 
            case 32411700: 
            case 32411800: 
            case 32411900: 
            case 32412100: 
            case 32412200: 
            case 32412300: 
            case 32413100: 
            case 32413200: 
            case 32413300: 
            case 32414100: 
            case 32414200: 
            case 32414300: 
            case 32414400: 
            case 32414500: 
            case 32415100: 
            case 32415200: 
            case 32415300: 
            case 32416100: 
            case 32416200: 
            case 32416300: 
            case 32416400: 
            case 32416500: 
            case 32416600: 
            case 32416700: 
            case 32416800: 
            case 32416900: 
            case 32520000: 
            case 32540000: 
            case 32550000: 
            case 32560000: 
            case 32620000: 
            case 32670000: 
            case 211000000: 
            case 211700000: 
            case 212000000: 
            case 212210000: 
            case 212220000: 
            case 212230000: 
            case 212300000: 
            case 212400000: 
            case 212410000: 
            case 317100000: 
            case 322512000: 
            case 324111000: 
            case 324111100: 
            case 324111200: 
            case 324111300: 
            case 324111400: 
            case 324111500: 
            case 324111600: 
            case 324111700: {
                result = 3;
                break;
            }
            case 22222000: 
            case 22224000: 
            case 22225000: 
            case 22522100: 
            case 23120000: 
            case 23157000: 
            case 23172000: 
            case 23223000: 
            case 23226000: 
            case 23227000: 
            case 23340000: 
            case 24211000: 
            case 24250000: 
            case 24260000: 
            case 25170400: 
            case 25170600: 
            case 25211000: 
            case 25212000: {
                result = 2;
                break;
            }
            default: {
                result = 2;
            }
        }
        if (clsUtility.isClosedPolygon(lineType)) {
            result = 3;
        }
        return result;
    }

    public static boolean isClosedPolygon(int linetype) {
        boolean result = false;
        switch (linetype) {
            case 150501: 
            case 150502: 
            case 150503: 
            case 270801: 
            case 271900: 
            case 11120500: 
            case 11120600: 
            case 13120500: 
            case 13120600: 
            case 22131000: 
            case 22132000: 
            case 22133000: 
            case 22134000: 
            case 22135000: 
            case 22136000: 
            case 22137000: 
            case 22138000: 
            case 22231000: 
            case 22232000: 
            case 22233000: 
            case 22234000: 
            case 22234100: 
            case 22234200: 
            case 22235000: 
            case 22431000: 
            case 22431100: 
            case 22531000: 
            case 22532000: 
            case 22535000: 
            case 22536000: 
            case 22621000: 
            case 22622000: 
            case 22624000: 
            case 22625000: 
            case 22626000: 
            case 23113000: 
            case 23114000: 
            case 23115000: 
            case 23162000: 
            case 23164000: 
            case 23180000: 
            case 23350000: 
            case 23440000: 
            case 23450000: 
            case 23460000: 
            case 23490000: 
            case 24226000: 
            case 24313000: 
            case 24314000: 
            case 24315000: 
            case 24321100: 
            case 24322100: 
            case 24323100: 
            case 24324100: 
            case 24325100: 
            case 24330000: 
            case 24331100: 
            case 24332100: 
            case 24333100: 
            case 24334100: 
            case 24335100: 
            case 24336100: 
            case 24337100: 
            case 24338100: 
            case 24339100: 
            case 24351000: 
            case 24361000: 
            case 25120700: 
            case 25171100: 
            case 25171200: 
            case 25171300: 
            case 25171400: 
            case 25171500: 
            case 25310000: 
            case 25310800: 
            case 25320000: 
            case 25330000: 
            case 25340000: 
            case 25351000: 
            case 25352000: 
            case 25353000: 
            case 31710000: 
            case 31720000: 
            case 31730000: 
            case 31740000: 
            case 31750000: 
            case 31751000: 
            case 31760000: 
            case 31770000: 
            case 31780000: 
            case 31790000: 
            case 32214000: 
            case 32222000: 
            case 32223000: 
            case 32224000: 
            case 32225200: 
            case 32231500: 
            case 32232400: 
            case 32233100: 
            case 32233500: 
            case 32244200: 
            case 32253000: 
            case 32254200: 
            case 32255200: 
            case 32311000: 
            case 32312000: 
            case 32313000: 
            case 32314000: 
            case 32315000: 
            case 32316000: 
            case 32317000: 
            case 32318000: 
            case 32319000: 
            case 32321000: 
            case 32322000: 
            case 32323000: 
            case 32324000: 
            case 32411100: 
            case 32411200: 
            case 32411300: 
            case 32411400: 
            case 32411500: 
            case 32411600: 
            case 32411700: 
            case 32411800: 
            case 32411900: 
            case 32412100: 
            case 32412200: 
            case 32412300: 
            case 32413100: 
            case 32413200: 
            case 32413300: 
            case 32414100: 
            case 32414200: 
            case 32414300: 
            case 32414400: 
            case 32414500: 
            case 32415100: 
            case 32415200: 
            case 32415300: 
            case 32416100: 
            case 32416200: 
            case 32416300: 
            case 32416400: 
            case 32416500: 
            case 32416600: 
            case 32416700: 
            case 32416800: 
            case 32416900: 
            case 32520000: 
            case 32540000: 
            case 32550000: 
            case 32560000: 
            case 32620000: 
            case 32670000: 
            case 221310000: 
            case 221311000: 
            case 243100000: 
            case 317100000: 
            case 322512000: 
            case 324111000: 
            case 324111100: 
            case 324111200: 
            case 324111300: 
            case 324111400: 
            case 324111500: 
            case 324111600: 
            case 324111700: 
            case 1322134000: 
            case 1325310000: {
                result = true;
                break;
            }
        }
        return result;
    }

    public static void ClosePolygon(ArrayList<POINT2> Pixels) {
        try {
            POINT2 pt0 = Pixels.get(0);
            POINT2 pt1 = Pixels.get(Pixels.size() - 1);
            if (pt0.x != pt1.x || pt0.y != pt1.y) {
                Pixels.add(new POINT2(pt0.x, pt0.y));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ClosePolygon", new RendererException("Failed inside ClosePolygon", exc));
        }
    }

    protected static void shiftModifiersLeft(POINT2 p1, POINT2 p2, double shift) {
        try {
            POINT2 pt1 = new POINT2(p1);
            POINT2 pt2 = new POINT2(p2);
            double dist = lineutility.CalcDistanceDouble(pt1, pt2);
            if (pt1.x < pt2.x || pt1.x == pt2.x && pt1.y < pt2.y) {
                pt1 = lineutility.ExtendAlongLineDouble(pt2, pt1, dist + shift);
                pt2 = lineutility.ExtendAlongLineDouble(pt1, pt2, dist - shift);
            } else {
                pt1 = lineutility.ExtendAlongLineDouble(pt2, pt1, dist - shift);
                pt2 = lineutility.ExtendAlongLineDouble(pt1, pt2, dist + shift);
            }
            p1.x = pt1.x;
            p1.y = pt1.y;
            p2.x = pt2.x;
            p2.y = pt2.y;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "shiftModifiersLeft", new RendererException("Failed inside shiftModifiersLeft", exc));
        }
    }

    protected static void ResolveModifierShape(TGLight tg, Shape2 shape) {
        try {
            int shapeStyle = shape.get_Style();
            int lineStyle = tg.get_LineStyle();
            int lineType = tg.get_LineType();
            boolean hasFill = clsUtility.LinesWithFill(lineType);
            int bolMETOC = clsMETOC.IsWeather(tg.get_SymbolId());
            if (bolMETOC > 0) {
                return;
            }
            int fillStyle = 0;
            block1 : switch (tg.get_LineType()) {
                case 271900: 
                case 22235000: 
                case 23440000: 
                case 23450000: 
                case 23460000: 
                case 24324100: 
                case 24324200: 
                case 24324300: {
                    fillStyle = 3;
                    if (tg.get_UseHatchFill()) {
                        fillStyle = 0;
                    }
                    if (shape.getShapeType() == Shape2.SHAPE_TYPE_POLYLINE) {
                        shape.set_Style(tg.get_LineStyle());
                        shape.setLineColor(tg.get_LineColor());
                        shape.set_Fillstyle(fillStyle);
                        shape.setFillColor(tg.get_FillColor());
                    }
                    break;
                }
                case 23115000: {
                    if (shape.getShapeType() == Shape2.SHAPE_TYPE_POLYLINE) {
                        shape.set_Style(tg.get_LineStyle());
                        shape.setLineColor(tg.get_LineColor());
                        shape.set_Fillstyle(0);
                        shape.setFillColor(tg.get_FillColor());
                    }
                    break;
                }
                case 221310000: {
                    fillStyle = 2;
                    if (tg.get_UseHatchFill()) {
                        fillStyle = 0;
                    }
                    if (shape.getShapeType() == Shape2.SHAPE_TYPE_POLYLINE) {
                        shape.set_Style(tg.get_LineStyle());
                        shape.setLineColor(tg.get_LineColor());
                        shape.set_Fillstyle(fillStyle);
                        shape.setFillColor(tg.get_FillColor());
                    }
                    break;
                }
                case 22139000: 
                case 22522100: 
                case 23131200: 
                case 23132000: 
                case 23172000: 
                case 23173000: 
                case 23174000: 
                case 23211000: 
                case 23212000: 
                case 23213000: 
                case 23223000: 
                case 211210000: {
                    tg.set_lineCap(0);
                    if (shape.getShapeType() == Shape2.SHAPE_TYPE_FILL) {
                        shape.set_Fillstyle(1);
                        shape.setFillColor(tg.get_LineColor());
                    }
                    if (shape.getShapeType() == Shape2.SHAPE_TYPE_POLYLINE) {
                        shape.set_Style(tg.get_LineStyle());
                        shape.setLineColor(tg.get_LineColor());
                    }
                    break;
                }
                case 220104: 
                case 21700000: 
                case 21710000: 
                case 22528000: 
                case 23157000: 
                case 23191000: 
                case 23224000: 
                case 24220000: {
                    if (shape.getShapeType() == Shape2.SHAPE_TYPE_POLYLINE) {
                        shape.set_Style(1);
                        shape.setLineColor(tg.get_LineColor());
                    }
                    break;
                }
                case 22431100: {
                    if (shape.getShapeType() == Shape2.SHAPE_TYPE_POLYLINE) {
                        shape.set_Style(1);
                        shape.setLineColor(tg.get_LineColor());
                        shape.setFillColor(tg.get_FillColor());
                        shape.set_Fillstyle(tg.get_FillStyle());
                    }
                    break;
                }
                case 23192000: 
                case 23225000: 
                case 211200000: {
                    if (shape.getShapeType() == Shape2.SHAPE_TYPE_POLYLINE) {
                        shape.setLineColor(tg.get_LineColor());
                        if (shapeStyle != lineStyle && shapeStyle != 1) {
                            shape.set_Style(lineStyle);
                        }
                    }
                    break;
                }
                default: {
                    if (shape.getShapeType() == Shape2.SHAPE_TYPE_FILL) {
                        shape.set_Fillstyle(tg.get_FillStyle());
                        shape.setFillColor(tg.get_FillColor());
                    }
                    if (shape.getShapeType() == Shape2.SHAPE_TYPE_POLYLINE) {
                        if (lineType != 22123000) {
                            shape.setLineColor(tg.get_LineColor());
                        } else {
                            clsUtility.SetLCColor(tg, shape);
                        }
                        shape.set_Style(lineStyle);
                        if (hasFill || clsUtility.isClosedPolygon(lineType) || clsUtility.IsChange1Area(lineType)) {
                            switch (lineType) {
                                case 25200700: 
                                case 243111000: 
                                case 243112000: {
                                    shape.setFillColor(null);
                                    break block1;
                                }
                            }
                            shape.set_Fillstyle(tg.get_FillStyle());
                            shape.setFillColor(tg.get_FillColor());
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ResolveModifierShape", new RendererException("Failed inside ResolveModifierShape", exc));
        }
    }

    public static Color GetOpaqueColor(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return new Color(r, g, b);
    }

    public static boolean LinesWithFill(int linetype) {
        boolean result = false;
        try {
            switch (linetype) {
                case 110300: 
                case 240804: 
                case 2514190: 
                case 22121000: 
                case 22122000: 
                case 22123000: 
                case 22124000: 
                case 22125000: 
                case 22522100: 
                case 22522210: 
                case 22522220: 
                case 22523000: 
                case 22525000: 
                case 22526000: 
                case 22527000: 
                case 22528000: 
                case 22612000: 
                case 22612001: 
                case 22613000: 
                case 22623000: 
                case 22623001: 
                case 23112000: 
                case 23120000: 
                case 23131100: 
                case 23134000: 
                case 23330000: 
                case 24210000: 
                case 24211000: 
                case 24220000: 
                case 24225000: 
                case 24230000: 
                case 24240000: 
                case 24250000: 
                case 24326100: 
                case 25110400: 
                case 25140400: 
                case 25141800: 
                case 25190100: 
                case 25190200: 
                case 25211000: 
                case 25212000: 
                case 25221000: 
                case 25222000: 
                case 25260400: 
                case 25300100: 
                case 25330301: 
                case 25330302: 
                case 25330303: 
                case 25330401: 
                case 25330402: 
                case 25330403: 
                case 25330500: 
                case 25330501: 
                case 25330502: 
                case 211400000: 
                case 211600000: 
                case 211900000: 
                case 212100000: 
                case 212500000: 
                case 212600000: 
                case 231100000: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: 
                case 1325260400: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "LinesWithFill", new RendererException("Failed inside LinesWithFill", exc));
        }
        return result;
    }

    public static void tweakFillColor(TGLight tg) {
        try {
            if (!clsUtility.isSameColor(tg.get_LineColor(), tg.get_FillColor()).booleanValue()) {
                return;
            }
            Color fillColor = tg.get_FillColor();
            int r = fillColor.getRed();
            int g = fillColor.getGreen();
            int b = fillColor.getBlue();
            int alpha = fillColor.getAlpha();
            r = (int)((double)r * 0.9);
            g = (int)((double)g * 0.9);
            b = (int)((double)b * 0.9);
            alpha = (int)((double)alpha * 0.8);
            fillColor = new Color(r, g, b, alpha);
            tg.set_FillColor(fillColor);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "tweakFillColor", new RendererException("Failed inside tweakFillColor", exc));
        }
    }

    public static Boolean isSameColor(Color c1, Color c2) {
        try {
            if (c1 == null || c2 == null) {
                return true;
            }
            int r1 = c1.getRed();
            int r2 = c2.getRed();
            int g1 = c1.getGreen();
            int g2 = c2.getGreen();
            int b1 = c1.getBlue();
            int b2 = c2.getBlue();
            if (Math.abs(r1 - r2) < 5 && Math.abs(g1 - g2) < 5 && Math.abs(b1 - b2) < 5) {
                return true;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "isSameColor", new RendererException("Failed inside isSameColor", exc));
        }
        return false;
    }

    public static BasicStroke getLineStroke(int width, int style, int cap, int join) {
        BasicStroke stroke = null;
        try {
            float dashLength = 2 * width;
            float dotLength = 1.0f;
            float dotSpace = 2 * width;
            switch (style) {
                case 0: {
                    stroke = new BasicStroke(width, cap, join);
                    break;
                }
                case 1: {
                    float[] dash = new float[]{dashLength, dashLength};
                    stroke = new BasicStroke(width, cap, join, 4.0f, dash, 0.0f);
                    break;
                }
                case 2: {
                    float[] dot = new float[]{1.0f, dotSpace};
                    stroke = new BasicStroke(width, cap, join, 4.0f, dot, 0.0f);
                    break;
                }
                case 3: {
                    float[] dashdot = new float[]{2.0f * dashLength, dotSpace, 1.0f, dotSpace};
                    stroke = new BasicStroke(width, cap, join, 4.0f, dashdot, 0.0f);
                    break;
                }
                case 4: {
                    float[] dashdotdot = new float[]{dashLength, dotSpace, 1.0f, dotSpace, 1.0f, dotSpace};
                    stroke = new BasicStroke(width, cap, join, 4.0f, dashdotdot, 0.0f);
                    break;
                }
                default: {
                    stroke = new BasicStroke(width, cap, join);
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getLineStroke", new RendererException("Failed inside getLineStroke", exc));
        }
        return stroke;
    }

    public static void SetShapeProperties(TGLight tg, ArrayList<Shape2> shapes, BufferedImage bi) {
        try {
            if (shapes == null) {
                return;
            }
            int j = 0;
            Shape2 shape = null;
            BasicStroke stroke = null;
            Object dash = null;
            int lineThickness = tg.get_LineThickness();
            int shapeType = -1;
            int lineType = tg.get_LineType();
            boolean hasFill = clsUtility.LinesWithFill(lineType);
            boolean isChange1Area = clsUtility.IsChange1Area(lineType);
            boolean isClosedPolygon = clsUtility.isClosedPolygon(lineType);
            if (tg.get_FillColor() == null) {
                switch (tg.get_LineType()) {
                    case 22221000: 
                    case 22222000: 
                    case 22223000: 
                    case 22224000: 
                    case 22225000: 
                    case 25170400: 
                    case 25170600: {
                        shape = shapes.get(shapes.size() - 1);
                        shapes.clear();
                        shapes.add(shape);
                        break;
                    }
                    case 21700000: 
                    case 21710000: 
                    case 22521200: 
                    case 22521300: 
                    case 22521410: 
                    case 22521420: {
                        ArrayList<Shape2> tempShapes = new ArrayList<Shape2>();
                        for (j = 0; j < shapes.size(); ++j) {
                            shape = shapes.get(j);
                            if (shape.getShapeType() == Shape2.SHAPE_TYPE_FILL) continue;
                            tempShapes.add(shape);
                        }
                        shapes = tempShapes;
                        break;
                    }
                }
            }
            for (j = 0; j < shapes.size(); ++j) {
                shape = shapes.get(j);
                if (shape == null || shape.getShape() == null) continue;
                if (shape.getShapeType() == Shape2.SHAPE_TYPE_FILL) {
                    switch (tg.get_LineType()) {
                        case 32214000: {
                            break;
                        }
                        default: {
                            shape.setFillColor(tg.get_FillColor());
                        }
                    }
                }
                clsUtility.ResolveModifierShape(tg, shape);
                if (lineType == 221311000 && j == 1) {
                    shape.setFillColor(null);
                }
                shapeType = shape.getShapeType();
                Object rect = null;
                Object grid = null;
                TexturePaint tp = tg.get_TexturePaint();
                if (lineThickness == 0) {
                    lineThickness = 1;
                }
                stroke = clsUtility.getLineStroke(lineThickness, shape.get_Style(), tg.get_lineCap(), 1);
                if (shape.getShapeType() == Shape2.SHAPE_TYPE_FILL) {
                    stroke = new BasicStroke(lineThickness, 1, 0);
                }
                shape.setStroke(stroke);
            }
            if (tg.get_LineType() == 22522100) {
                for (int i = 2; i < shapes.size(); ++i) {
                    Shape2 arrowHeadShape = shapes.get(i);
                    arrowHeadShape.set_Style(0);
                    stroke = clsUtility.getLineStroke(lineThickness, 0, tg.get_lineCap(), 1);
                    arrowHeadShape.setStroke(stroke);
                }
            } else if (tg.get_LineType() == 22522210 || tg.get_LineType() == 22522220) {
                Shape2 arrowHeadShape = shapes.get(1);
                arrowHeadShape.set_Style(0);
                stroke = clsUtility.getLineStroke(lineThickness, 0, tg.get_lineCap(), 1);
                arrowHeadShape.setStroke(stroke);
            } else if (tg.get_LineType() == 22422000) {
                Shape2 rectShape = shapes.get(1);
                rectShape.set_Style(0);
                stroke = clsUtility.getLineStroke(lineThickness, 0, tg.get_lineCap(), 1);
                rectShape.setStroke(stroke);
                rectShape.setFillColor(rectShape.getLineColor());
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "SetShapeProperties", new RendererException("Failed inside SetShapeProperties", exc));
        }
    }

    public static boolean IsChange1Area(int lineType) {
        try {
            switch (lineType) {
                case 240804: 
                case 24311000: 
                case 24312000: 
                case 24321200: 
                case 24321300: 
                case 24322200: 
                case 24322300: 
                case 24323200: 
                case 24323300: 
                case 24324200: 
                case 24324300: 
                case 24325200: 
                case 24325300: 
                case 24326100: 
                case 24326200: 
                case 24331200: 
                case 24331300: 
                case 24332200: 
                case 24332300: 
                case 24333200: 
                case 24333300: 
                case 24334200: 
                case 24334300: 
                case 24335200: 
                case 24335300: 
                case 24336200: 
                case 24336300: 
                case 24337200: 
                case 24337300: 
                case 24338200: 
                case 24338300: 
                case 24339200: 
                case 24339300: 
                case 24352000: 
                case 24353000: 
                case 24362000: 
                case 24363000: 
                case 25170800: 
                case 25200101: 
                case 25200201: 
                case 25200202: 
                case 25200300: 
                case 25200401: 
                case 25200402: 
                case 25200600: 
                case 25200700: 
                case 243111000: 
                case 243111001: 
                case 243112000: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "IsChange1Area", new RendererException("Failed inside IsChange1Area", exc));
            return false;
        }
    }

    public static void WriteFile(String str) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("Test.txt"));
            bufferedWriter.write(str);
            bufferedWriter.close();
            bufferedWriter = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "WriteFile", new RendererException("Failed inside WriteFile", exc));
        }
    }

    protected static void CalcIntersectPt(POINT2 pt1, double m1, POINT2 pt2, double m2, POINT2 ptIntersect) {
        try {
            if (m1 == m2) {
                return;
            }
            double x1 = pt1.x;
            double y1 = pt1.y;
            double x2 = pt2.x;
            double y2 = pt2.y;
            double dx2 = (y1 - y2 + m1 * x2 - m1 * x1) / (m2 - m1);
            double x3 = x2 + dx2;
            double y3 = y2 + m2 * dx2;
            ptIntersect.x = x3;
            ptIntersect.y = y3;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcIntersectPt", new RendererException("Failed inside CalcIntersectPt", exc));
        }
    }

    protected static int ChannelWidth(double[] pixels, ref<double[]> distanceToChannelPOINT2) {
        int width = 0;
        try {
            int numPOINT2s = pixels.length / 2;
            if (numPOINT2s < 3) {
                return 0;
            }
            POINT2 channelWidthPOINT2 = new POINT2(0.0, 0.0);
            POINT2 lastSegmentPt1 = new POINT2(0.0, 0.0);
            POINT2 lastSegmentPt2 = new POINT2(0.0, 0.0);
            lastSegmentPt1.x = pixels[2 * numPOINT2s - 6];
            lastSegmentPt1.y = pixels[2 * numPOINT2s - 5];
            lastSegmentPt2.x = pixels[2 * numPOINT2s - 4];
            lastSegmentPt2.y = pixels[2 * numPOINT2s - 3];
            channelWidthPOINT2.x = pixels[2 * numPOINT2s - 2];
            channelWidthPOINT2.y = pixels[2 * numPOINT2s - 1];
            ref<double[]> m = new ref<double[]>();
            double m1 = 0.0;
            double distance = 0.0;
            POINT2 ptIntersect = new POINT2(0.0, 0.0);
            boolean bolVertical = lineutility.CalcTrueSlopeDouble2(lastSegmentPt1, lastSegmentPt2, m);
            if (bolVertical && ((double[])m.value)[0] != 0.0) {
                m1 = -1.0 / ((double[])m.value)[0];
                clsUtility.CalcIntersectPt(channelWidthPOINT2, m1, lastSegmentPt2, ((double[])m.value)[0], ptIntersect);
                distance = lineutility.CalcDistanceDouble(channelWidthPOINT2, ptIntersect);
            }
            if (bolVertical && ((double[])m.value)[0] == 0.0) {
                distance = Math.abs(channelWidthPOINT2.y - lastSegmentPt1.y);
            }
            if (!bolVertical) {
                distance = Math.abs(channelWidthPOINT2.x - lastSegmentPt1.x);
                distanceToChannelPOINT2.value = new double[1];
                ((double[])distanceToChannelPOINT2.value)[0] = distance;
                return (int)distance * 4;
            }
            width = (int)distance * 8;
            if (width < 2) {
                width = 2;
            }
            double hypotenuse = lineutility.CalcDistanceDouble(lastSegmentPt2, channelWidthPOINT2);
            distanceToChannelPOINT2.value = new double[1];
            ((double[])distanceToChannelPOINT2.value)[0] = Math.sqrt(hypotenuse * hypotenuse - distance * distance);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ChannelWidth", new RendererException("Failed inside ChannelWidth", exc));
        }
        return width;
    }

    private static boolean InYOrder(POINT2 pt0, POINT2 pt1, POINT2 pt2) {
        try {
            if (pt0.y <= pt1.y && pt1.y <= pt2.y) {
                return true;
            }
            if (pt2.y <= pt1.y && pt1.y <= pt0.y) {
                return true;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "InYOrder", new RendererException("Failed inside InYOrder", exc));
        }
        return false;
    }

    private static boolean InXOrder(POINT2 pt0, POINT2 pt1, POINT2 pt2) {
        try {
            if (pt0.x <= pt1.x && pt1.x <= pt2.x) {
                return true;
            }
            if (pt2.x <= pt1.x && pt1.x <= pt0.x) {
                return true;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "InXOrder", new RendererException("Failed inside InXOrder", exc));
        }
        return false;
    }

    public static void GetSectorRadiiFromPoints(TGLight tg) {
        try {
            if (tg.get_LineType() == 243111001) {
                return;
            }
            POINT2 ptCenter = tg.LatLongs.get(0);
            POINT2 ptLeftMin = new POINT2();
            POINT2 ptRightMax = new POINT2();
            int k = 0;
            String strLeft = "";
            String strRight = "";
            String strMin = "";
            String strMax = "";
            Object temp = "";
            double nLeft = 0.0;
            double nRight = 0.0;
            double nMin = 0.0;
            double nMax = 0.0;
            double dist = 0.0;
            ref<double[]> a12 = new ref<double[]>();
            ref<double[]> a21 = new ref<double[]>();
            int numSectors = 0;
            if (tg.LatLongs.size() > 2) {
                numSectors = (tg.LatLongs.size() - 2) / 2;
                for (k = 0; k < numSectors; ++k) {
                    ptLeftMin = tg.LatLongs.get(2 * k + 2);
                    ptRightMax = tg.LatLongs.get(2 * k + 3);
                    dist = mdlGeodesic.geodesic_distance(ptCenter, ptLeftMin, a12, a21);
                    nLeft = ((double[])a12.value)[0];
                    strLeft = Double.toString(nLeft);
                    nMin = dist;
                    strMin = Double.toString(nMin);
                    dist = mdlGeodesic.geodesic_distance(ptCenter, ptRightMax, a12, a21);
                    nRight = ((double[])a12.value)[0];
                    strRight = Double.toString(nRight);
                    nMax = dist;
                    strMax = Double.toString(nMax);
                    temp = k == 0 ? strLeft + "," + strRight + "," + strMin + "," + strMax : (String)temp + "," + strLeft + "," + strRight + "," + strMin + "," + strMax;
                }
                if (!((String)temp).equals("")) {
                    tg.set_LRMM((String)temp);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSectorRadiiFromPoints", new RendererException("Failed inside GetSectorRadiiFromPoints", exc));
        }
    }

    protected static void ReorderPixels(double[] pixels) {
        try {
            int j;
            int counter = 0;
            int numPoints = pixels.length / 2;
            double[] tempPixels = new double[pixels.length];
            for (j = 0; j < numPoints - 1; ++j) {
                double x = pixels[pixels.length - 2 * j - 4];
                double y = pixels[pixels.length - 2 * j - 3];
                tempPixels[counter] = x;
                tempPixels[counter + 1] = y;
                counter += 2;
            }
            int intPixelSize = pixels.length;
            tempPixels[counter] = pixels[intPixelSize - 2];
            tempPixels[counter + 1] = pixels[intPixelSize - 1];
            int n = pixels.length;
            for (j = 0; j < n; ++j) {
                pixels[j] = tempPixels[j];
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ReorderPixels", new RendererException("Failed inside ReorderPixels", exc));
        }
    }

    public static void FilterVerticalSegments(TGLight tg) {
        try {
            switch (tg.get_LineType()) {
                case 21700000: 
                case 21710000: 
                case 22123000: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: 
                case 23134000: 
                case 25330301: 
                case 25330302: 
                case 25330303: 
                case 25330401: 
                case 25330402: 
                case 25330403: 
                case 25330501: 
                case 25330502: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: {
                    break;
                }
                default: {
                    return;
                }
            }
            POINT2 ptCurrent = null;
            POINT2 ptLast = null;
            int n = tg.Pixels.size();
            for (int j = 1; j < n; ++j) {
                ptLast = new POINT2(tg.Pixels.get(j - 1));
                ptCurrent = new POINT2(tg.Pixels.get(j));
                if (!(Math.abs(ptCurrent.x - ptLast.x) < 1.0)) continue;
                ptCurrent.x = ptCurrent.x >= ptLast.x ? (ptCurrent.x += 1.0) : (ptCurrent.x -= 1.0);
                tg.Pixels.set(j, ptCurrent);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "FilterVerticalSegments", new RendererException("Failed inside FilterVerticalSegments", exc));
        }
    }

    public static POINT2 ComputeLastPoint(ArrayList<POINT2> arrLocation) {
        POINT2 locD = new POINT2(0.0, 0.0);
        try {
            POINT2 locA = arrLocation.get(1);
            POINT2 locB = arrLocation.get(0);
            double dblDx = locB.x - locA.x;
            double dblDy = locB.y - locA.y;
            double dblTheta = Math.atan2(-dblDy, dblDx);
            POINT2 locC = new POINT2(0.0, 0.0);
            locC.x = (int)(locA.x + 0.85 * dblDx);
            locC.y = (int)(locA.y + 0.85 * dblDy);
            double dblAngle = dblTheta + 1.5707963267948966;
            if (dblAngle > Math.PI) {
                dblAngle -= Math.PI * 2;
            }
            if (dblAngle < -Math.PI) {
                dblAngle += Math.PI * 2;
            }
            double dblWidth = 30.0;
            locD.x = locC.x + dblWidth * Math.cos(dblAngle);
            locD.y = locC.y - dblWidth * Math.sin(dblAngle);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ComputeLastPoint", new RendererException("Failed inside ComputeLastPoint", exc));
        }
        return locD;
    }

    protected static void GetSegments(double[] pixels, boolean[] segments, double factor) {
        try {
            int j = 0;
            ref<double[]> m1 = new ref<double[]>();
            ref<double[]> m2 = new ref<double[]>();
            long numPoints = 0L;
            boolean bolVertical1 = false;
            boolean bolVertical2 = false;
            POINT2 pt0F = new POINT2(0.0, 0.0);
            POINT2 pt1F = new POINT2(0.0, 0.0);
            POINT2 pt2F = new POINT2(0.0, 0.0);
            segments[0] = true;
            numPoints = pixels.length / 2;
            j = 0;
            while ((long)j < numPoints - 2L) {
                pt0F.x = pixels[2 * j];
                pt0F.y = pixels[2 * j + 1];
                pt1F.x = pixels[2 * j + 2];
                pt1F.y = pixels[2 * j + 3];
                pt2F.x = pixels[2 * j + 4];
                pt2F.y = pixels[2 * j + 5];
                bolVertical1 = lineutility.CalcTrueSlopeDoubleForRoutes(pt0F, pt1F, m1);
                bolVertical2 = lineutility.CalcTrueSlopeDoubleForRoutes(pt1F, pt2F, m2);
                segments[j + 1] = true;
                if (bolVertical1 && bolVertical2 && Math.abs(Math.atan(((double[])m1.value)[0]) - Math.atan(((double[])m2.value)[0])) < 1.0 / factor && !clsUtility.InXOrder(pt0F, pt1F, pt2F)) {
                    segments[j + 1] = false;
                }
                if (!(bolVertical1 && !(Math.abs(((double[])m1.value)[0]) > factor) || bolVertical2 && !(Math.abs(((double[])m2.value)[0]) > factor) || clsUtility.InYOrder(pt0F, pt1F, pt2F))) {
                    segments[j + 1] = false;
                }
                ++j;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSegments", new RendererException("Failed inside GetSegments", exc));
        }
    }

    protected static void GetLCPartitions(double[] pixels, double LCChannelWith, ArrayList<P1> partitions, ArrayList<P1> singleLinePartitions) {
        try {
            int numPoints = pixels.length / 2;
            POINT2 pt0F = new POINT2(0.0, 0.0);
            POINT2 pt1F = new POINT2(0.0, 0.0);
            POINT2 pt2F = new POINT2(0.0, 0.0);
            P1 nextP = new P1();
            nextP.start = 0;
            double[] angles = new double[numPoints - 1];
            for (int i = 0; i < numPoints - 2; ++i) {
                pt0F.x = pixels[2 * i];
                pt0F.y = pixels[2 * i + 1];
                pt1F.x = pixels[2 * i + 2];
                pt1F.y = pixels[2 * i + 3];
                pt2F.x = pixels[2 * i + 4];
                pt2F.y = pixels[2 * i + 5];
                double angle1 = Math.atan2(pt1F.y - pt0F.y, pt1F.x - pt0F.x);
                double angle2 = Math.atan2(pt1F.y - pt2F.y, pt1F.x - pt2F.x);
                double angle = angle1 - angle2;
                double degrees = angle * 180.0 / Math.PI;
                if (angle < 0.0) {
                    degrees = 360.0 + degrees;
                }
                if (degrees > 270.0) {
                    POINT2 newPt;
                    boolean angleTooSmall = false;
                    if (lineutility.CalcDistanceDouble(pt0F, pt1F) < lineutility.CalcDistanceDouble(pt1F, pt2F)) {
                        newPt = lineutility.ExtendAlongLineDouble2(pt1F, pt2F, lineutility.CalcDistanceDouble(pt1F, pt0F));
                        if (lineutility.CalcDistanceDouble(pt0F, newPt) < LCChannelWith) {
                            angleTooSmall = true;
                        }
                    } else {
                        newPt = lineutility.ExtendAlongLineDouble2(pt1F, pt0F, lineutility.CalcDistanceDouble(pt1F, pt2F));
                        if (lineutility.CalcDistanceDouble(pt2F, newPt) < LCChannelWith) {
                            angleTooSmall = true;
                        }
                    }
                    if (angleTooSmall) {
                        nextP.end_Renamed = i - 1;
                        partitions.add(nextP);
                        nextP = new P1();
                        nextP.start = i;
                        nextP.end_Renamed = i + 2;
                        singleLinePartitions.add(nextP);
                        nextP = new P1();
                        nextP.start = ++i + 1;
                    }
                } else if (degrees < 90.0) {
                    nextP.end_Renamed = i;
                    partitions.add(nextP);
                    nextP = new P1();
                    nextP.start = i + 1;
                }
                angles[i] = degrees;
            }
            nextP.end_Renamed = numPoints - 2;
            partitions.add(nextP);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetLCPartitions", new RendererException("Failed inside GetLCPartitions", exc));
        }
    }

    protected static void SetLCColor(TGLight tg, Shape2 shape) {
        try {
            if (tg.isHostile()) {
                if (shape.getLineColor() == Color.RED) {
                    shape.setLineColor(tg.get_LineColor());
                } else {
                    shape.setLineColor(Color.RED);
                }
            } else if (shape.getLineColor() != Color.RED) {
                shape.setLineColor(tg.get_LineColor());
            } else {
                shape.setLineColor(Color.RED);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "SetLCColor", new RendererException("Failed inside SetLCColor", exc));
        }
    }

    public static void ReverseUSASLCPointsByQuadrant(TGLight tg) {
        try {
            if (tg.Pixels.size() < 2) {
                return;
            }
            int quadrant = lineutility.GetQuadrantDouble(tg.Pixels.get(0), tg.Pixels.get(1));
            block1 : switch (tg.get_LineType()) {
                case 22123000: {
                    if (tg.isHostile()) {
                        switch (quadrant) {
                            case 2: 
                            case 3: {
                                break block1;
                            }
                            case 1: 
                            case 4: {
                                int n = tg.Pixels.size();
                                ArrayList pts2 = (ArrayList)tg.Pixels.clone();
                                for (int j = 0; j < n; ++j) {
                                    tg.Pixels.set(j, (POINT2)pts2.get(n - j - 1));
                                }
                                break;
                            }
                        }
                        break;
                    }
                    switch (quadrant) {
                        case 1: 
                        case 4: {
                            break block1;
                        }
                        case 2: 
                        case 3: {
                            int n = tg.Pixels.size();
                            ArrayList pts2 = (ArrayList)tg.Pixels.clone();
                            for (int j = 0; j < n; ++j) {
                                tg.Pixels.set(j, (POINT2)pts2.get(n - j - 1));
                            }
                            break;
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ReverseUSASLCPointsByQuadrant", new RendererException("Failed inside ReverseUSASLCPointsByQuadrant", exc));
        }
    }

    public static int GetLinetypeFromString(String symbolId) {
        try {
            if (symbolId.length() < 16) {
                return -1;
            }
            int symbolSet = SymbolID.getSymbolSet(symbolId);
            int entityCode = SymbolID.getEntityCode(symbolId);
            int version = SymbolID.getVersion(symbolId);
            if (symbolSet == 25) {
                return clsRenderer.getCMLineType(version, entityCode);
            }
            if (symbolSet == 45 || symbolSet == 46) {
                return clsMETOC.getWeatherLinetype(version, entityCode);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetLinetypeFromString", new RendererException("Failed inside GetLinetypeFromString", exc));
        }
        return -1;
    }

    public static boolean isAutoshape(TGLight tg) {
        try {
            MSInfo msInfo = MSLookup.getInstance().getMSLInfo(tg.get_SymbolId());
            if (msInfo == null || clsUtility.IsChange1Area(tg.get_LineType())) {
                return false;
            }
            switch (tg.get_LineType()) {
                case 22522100: 
                case 22522210: 
                case 22522220: {
                    return false;
                }
            }
            switch (msInfo.getDrawRule()) {
                case 126: 
                case 326: 
                case 327: 
                case 401: {
                    return true;
                }
            }
            return msInfo.getMaxPointCount() == msInfo.getMinPointCount();
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "isAutoshape", new RendererException("Failed inside isAutoshape", exc));
            return false;
        }
    }

    public static HashMap<Integer, Color> getMSRSegmentColors(TGLight tg) {
        HashMap<Integer, Color> hMap = null;
        try {
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 22121000: 
                case 25221000: 
                case 25222000: 
                case 25330500: {
                    if (tg.get_H() == null || tg.get_H().isEmpty()) {
                        return null;
                    }
                    hMap = new HashMap<Integer, Color>();
                    break;
                }
                default: {
                    return null;
                }
            }
            String[] colorStrs = tg.get_H().split(",");
            int j = 0;
            int numSegs = colorStrs.length;
            String segPlusColor = "";
            String[] seg = null;
            Color color = null;
            int index = -1;
            for (j = 0; j < numSegs; ++j) {
                segPlusColor = colorStrs[j];
                if (!segPlusColor.contains(":")) continue;
                seg = segPlusColor.split(":");
                color = RendererUtilities.getColorFromHexString(seg[1]);
                index = Integer.parseInt(seg[0]);
                hMap.put(index, color);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getMSRSegmentColors", new RendererException("Failed inside getMSRSegmentColors", exc));
        }
        return hMap;
    }

    public static HashMap<Integer, String> getMSRSegmentColorStrings(TGLight tg) {
        HashMap<Integer, String> hMap = null;
        try {
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 22121000: 
                case 25221000: 
                case 25222000: 
                case 25330500: {
                    if (tg.get_H() == null || tg.get_H().isEmpty()) {
                        return null;
                    }
                    hMap = new HashMap<Integer, String>();
                    break;
                }
                default: {
                    return null;
                }
            }
            String[] colorStrs = tg.get_H().split(",");
            int j = 0;
            int numSegs = colorStrs.length;
            String segPlusColor = "";
            String[] seg = null;
            int index = -1;
            for (j = 0; j < numSegs; ++j) {
                segPlusColor = colorStrs[j];
                if (!segPlusColor.contains(":")) continue;
                seg = segPlusColor.split(":");
                index = Integer.parseInt(seg[0]);
                hMap.put(new Integer(index), seg[1]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getMSRSegmentColorStrings", new RendererException("Failed inside getMSRSegmentColorStrings", exc));
        }
        return hMap;
    }

    public static void reviseHModifier(ArrayList<POINT2> originalPixels, TGLight tg) {
        try {
            if (tg.get_H() == null || tg.get_H().isEmpty()) {
                return;
            }
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 22121000: 
                case 25221000: 
                case 25222000: 
                case 25330500: {
                    break;
                }
                default: {
                    return;
                }
            }
            int j = 0;
            int k = 0;
            int n = -1;
            boolean foundPt = false;
            int t = originalPixels.size();
            int u = tg.Pixels.size();
            for (j = 0; j < t; ++j) {
                for (k = 0; k < u; ++k) {
                    if (originalPixels.get((int)j).x != tg.Pixels.get((int)k).x || originalPixels.get((int)j).y != tg.Pixels.get((int)k).y) continue;
                    n = j;
                    foundPt = true;
                    break;
                }
                if (foundPt) break;
            }
            HashMap<Integer, Color> hmap = clsUtility.getMSRSegmentColors(tg);
            HashMap<Integer, Color> hmap2 = new HashMap<Integer, Color>();
            POINT2 segPt0 = null;
            POINT2 segPt1 = null;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            Color color = null;
            if (n < 1) {
                n = 1;
            }
            block7: for (Integer key : hmap.keySet()) {
                if (key < n - 1) continue;
                if (key + 1 > originalPixels.size() - 1) break;
                color = hmap.get(key);
                segPt0 = originalPixels.get(key);
                segPt1 = originalPixels.get(key + 1);
                u = tg.Pixels.size();
                for (j = 0; j < u - 1; ++j) {
                    pt0 = tg.Pixels.get(j);
                    pt1 = tg.Pixels.get(j + 1);
                    if (segPt0.x == pt0.x && segPt0.y == pt0.y) {
                        hmap2.put(j, color);
                        continue block7;
                    }
                    if (segPt1.x == pt1.x && segPt1.y == pt1.y) {
                        hmap2.put(j, color);
                        continue block7;
                    }
                    if (pt0.x == segPt1.x && pt0.y == segPt1.y || pt1.x == segPt0.x && pt1.y == segPt0.y) continue;
                    double dist0 = lineutility.CalcDistanceToLineDouble(segPt0, segPt1, pt0);
                    double dist1 = lineutility.CalcDistanceToLineDouble(segPt0, segPt1, pt1);
                    Line2D.Double lineOrigPts = new Line2D.Double(segPt0.x, segPt0.y, segPt1.x, segPt1.y);
                    Rectangle2D rectOrigPts = lineOrigPts.getBounds2D();
                    Line2D.Double lineClipPts = new Line2D.Double(pt0.x, pt0.y, pt1.x, pt1.y);
                    Rectangle2D rectClipPts = lineClipPts.getBounds2D();
                    if (!(dist0 < 1.0) || !(dist1 < 1.0) || !rectOrigPts.contains(rectClipPts)) continue;
                    hmap2.put(j, color);
                }
            }
            if (hmap2.isEmpty()) {
                tg.set_H("");
                return;
            }
            Object h = "";
            String temp = "";
            for (Integer key : hmap2.keySet()) {
                color = (Color)hmap2.get(key);
                temp = Integer.toHexString(color.getRGB());
                h = (String)h + key.toString() + ":" + temp + ",";
            }
            h = ((String)h).substring(0, ((String)h).length() - 1);
            tg.set_H((String)h);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "reviseHModifer", new RendererException("Failed inside reviseHModifier", exc));
        }
    }

    public static void SegmentLCPoints(TGLight tg, IPointConversion converter) {
        try {
            if (tg.get_LineType() != 22123000) {
                return;
            }
            ArrayList<POINT2> points = tg.get_Pixels();
            double LCChannelWith = arraysupport.getScaledSize(40.0, tg.get_LineThickness(), tg.get_patternScale());
            for (int i = 0; i < points.size() - 2; ++i) {
                POINT2 newPt;
                POINT2 ptA = new POINT2(points.get((int)i).x, points.get((int)i).y);
                POINT2 ptB = new POINT2(points.get((int)(i + 1)).x, points.get((int)(i + 1)).y);
                POINT2 ptC = new POINT2(points.get((int)(i + 2)).x, points.get((int)(i + 2)).y);
                double angle1 = Math.atan2(ptB.y - ptA.y, ptB.x - ptA.x);
                double angle2 = Math.atan2(ptB.y - ptC.y, ptB.x - ptC.x);
                double angle = angle1 - angle2;
                double degrees = angle * 180.0 / Math.PI;
                if (angle < 0.0) {
                    degrees = 360.0 + degrees;
                }
                if (!(degrees > 270.0)) continue;
                if (lineutility.CalcDistanceDouble(ptB, ptA) < lineutility.CalcDistanceDouble(ptB, ptC)) {
                    newPt = lineutility.ExtendAlongLineDouble2(ptB, ptC, lineutility.CalcDistanceDouble(ptB, ptA));
                    if (!(lineutility.CalcDistanceDouble(ptA, newPt) < LCChannelWith)) continue;
                    points.add(i + 2, new POINT2(newPt.x, newPt.y));
                    ++i;
                    continue;
                }
                newPt = lineutility.ExtendAlongLineDouble2(ptB, ptA, lineutility.CalcDistanceDouble(ptB, ptC));
                if (!(lineutility.CalcDistanceDouble(ptC, newPt) < LCChannelWith)) continue;
                points.add(i + 1, new POINT2(newPt.x, newPt.y));
                ++i;
            }
            tg.Pixels = points;
            tg.LatLongs = armyc2.c5isr.RenderMultipoints.clsUtility.PixelsToLatLong(points, converter);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "segmentLCPoints", new RendererException("Failed inside segmentLCPoints", exc));
        }
    }

    public static void InterpolatePixels(TGLight tg) {
        try {
            if (!tg.get_UseLineInterpolation()) {
                return;
            }
            int linetype = tg.get_LineType();
            double glyphSize = 10.0;
            switch (linetype) {
                case 23131100: 
                case 23131200: {
                    glyphSize = 25.0;
                    break;
                }
                case 23132000: {
                    glyphSize = 50.0;
                    break;
                }
                case 22122000: 
                case 22123000: 
                case 22134000: 
                case 22624000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23330000: 
                case 23350000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: 
                case 1322134000: {
                    glyphSize = arraysupport.getScaledSize(30.0, tg.get_LineThickness(), tg.get_patternScale());
                    break;
                }
                case 23112000: 
                case 23134000: 
                case 231111000: 
                case 231112000: {
                    glyphSize = arraysupport.getScaledSize(40.0, tg.get_LineThickness(), tg.get_patternScale());
                    break;
                }
                case 231113000: {
                    glyphSize = arraysupport.getScaledSize(50.0, tg.get_LineThickness(), tg.get_patternScale());
                    break;
                }
                default: {
                    return;
                }
            }
            HashMap<Integer, POINT2> hmapPixels = new HashMap<Integer, POINT2>();
            HashMap<Integer, POINT2> hmapGeo = new HashMap<Integer, POINT2>();
            int j = 0;
            int currentIndex = 0;
            double dist = 0.0;
            double dist2 = 0.0;
            double direction1 = 0.0;
            double direction2 = 0.0;
            double delta = 0.0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            int n = tg.Pixels.size();
            for (j = 0; j < n; ++j) {
                if (j == 0) {
                    hmapPixels.put(j, tg.Pixels.get(j));
                    hmapGeo.put(j, tg.LatLongs.get(j));
                    currentIndex = 0;
                    continue;
                }
                if (j == tg.Pixels.size() - 1) {
                    hmapPixels.put(j, tg.Pixels.get(j));
                    hmapGeo.put(j, tg.LatLongs.get(j));
                    continue;
                }
                dist = lineutility.CalcDistanceDouble(tg.Pixels.get(currentIndex), tg.Pixels.get(j));
                dist2 = lineutility.CalcDistanceDouble(tg.Pixels.get(j), tg.Pixels.get(j + 1));
                pt0 = tg.Pixels.get(currentIndex);
                pt1 = tg.Pixels.get(j);
                pt2 = tg.Pixels.get(j + 1);
                direction1 = 57.29577951308232 * Math.atan((pt0.y - pt1.y) / (pt0.x - pt1.x));
                direction2 = 57.29577951308232 * Math.atan((pt1.y - pt2.y) / (pt1.x - pt2.x));
                delta = Math.abs(direction1 - direction2);
                if (!(dist > glyphSize) && !(dist2 > glyphSize) && !(delta > 20.0)) continue;
                hmapPixels.put(j, tg.Pixels.get(j));
                hmapGeo.put(j, tg.LatLongs.get(j));
                currentIndex = j;
            }
            ArrayList<POINT2> pixels = new ArrayList<POINT2>();
            ArrayList<POINT2> geo = new ArrayList<POINT2>();
            n = tg.Pixels.size();
            for (j = 0; j < n; ++j) {
                if (hmapPixels.containsKey(j)) {
                    pixels.add((POINT2)hmapPixels.get(j));
                }
                if (!hmapGeo.containsKey(j)) continue;
                geo.add((POINT2)hmapGeo.get(j));
            }
            block8 : switch (linetype) {
                case 22134000: 
                case 22624000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23350000: 
                case 1322134000: {
                    if (pixels.size() != 2) break;
                    n = tg.Pixels.size();
                    for (j = 0; j < n; ++j) {
                        if (hmapPixels.containsKey(j) || hmapGeo.containsKey(j)) continue;
                        pixels.add(j, tg.Pixels.get(j));
                        geo.add(j, tg.LatLongs.get(j));
                        break block8;
                    }
                    break;
                }
            }
            tg.Pixels = pixels;
            tg.LatLongs = geo;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "InterpolatePixels", new RendererException("Failed inside InterpolatePixels", exc));
        }
    }

    protected static Line2D getExtendedLine(TGLight tg, int index, double dist) {
        Line2D.Double line = null;
        try {
            Polygon polygon = new Polygon();
            int j = 0;
            int n = tg.Pixels.size();
            for (j = 0; j < n; ++j) {
                polygon.addPoint((int)tg.Pixels.get((int)j).x, (int)tg.Pixels.get((int)j).y);
            }
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            if (tg.Pixels.size() > 3) {
                pt0 = tg.Pixels.get(index);
                pt1 = tg.Pixels.get(index + 1);
            } else {
                pt0 = tg.Pixels.get(1);
                pt1 = tg.Pixels.get(2);
            }
            POINT2 ptExtend = null;
            int extend = -1;
            POINT2 midPt = lineutility.MidPointDouble(pt0, pt1, 0);
            double slope = Math.abs(pt1.y - pt0.y) / (pt1.x - pt0.x);
            if (slope <= 1.0) {
                ptExtend = lineutility.ExtendDirectedLine(pt0, pt1, midPt, 2, 2.0);
                extend = polygon.contains(ptExtend.x, ptExtend.y) ? 3 : 2;
            } else {
                ptExtend = lineutility.ExtendDirectedLine(pt0, pt1, midPt, 0, 2.0);
                extend = polygon.contains(ptExtend.x, ptExtend.y) ? 1 : 0;
            }
            POINT2 pt3 = null;
            POINT2 pt4 = null;
            pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, extend, dist);
            pt4 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, extend, dist);
            line = new Line2D.Double(pt3.x, pt3.y, pt4.x, pt4.y);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getExtendedLine", new RendererException("Failed inside getExtendedLine", exc));
        }
        return line;
    }
}

