/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.SymbolID;
import java.util.ArrayList;

public class MSInfo {
    private int _Version = 0;
    private String _ID = null;
    private String _Name = null;
    private String _Path = null;
    private String _SymbolSet = null;
    private int _SymbolSetInt = 0;
    private String _Entity = null;
    private String _EntityType = null;
    private String _EntitySubType = null;
    private String _EntityCode = null;
    private String _Geometry = "point";
    private ArrayList<String> _Modifiers = null;
    private int _MinPointCount = 0;
    private int _MaxPointCount = 0;
    private int _DrawRule = 0;

    public MSInfo(int version, String symbolSet, String entity, String entityType, String entitySubType, String entityCode, ArrayList<String> modifiers) {
        this._Version = version;
        this._ID = symbolSet + entityCode;
        this._SymbolSetInt = Integer.parseInt(symbolSet);
        this._SymbolSet = MSInfo.parseSymbolSetName(symbolSet, this._Version);
        if (entitySubType != null && !entitySubType.equals("")) {
            this._Name = entitySubType;
            this._EntitySubType = entitySubType;
            this._Path = this._SymbolSet + " / " + entity + " / " + entityType + " / ";
        }
        if (entityType != null && !entityType.equals("")) {
            this._EntityType = entityType;
            if (this._Name == null) {
                this._Name = entityType;
            }
            if (this._Path == null) {
                this._Path = this._SymbolSet + " / " + entity + " / ";
            }
        }
        if (entity != null && !entity.equals("")) {
            this._Entity = entity;
            if (this._Name == null) {
                this._Name = entity;
            }
            if (this._Path == null) {
                this._Path = this._SymbolSet + " / ";
            }
        }
        if (entityCode != null & entityCode.length() == 6) {
            this._EntityCode = entityCode;
        }
        this._Geometry = "point";
        if (!entityCode.equals("000000") && this._SymbolSetInt != 25 && this._SymbolSetInt != 45 && this._SymbolSetInt != 46 && this._SymbolSetInt != 47) {
            this._DrawRule = 202;
            this._MinPointCount = 1;
            this._MaxPointCount = 1;
        }
        this._Modifiers = modifiers;
    }

    public MSInfo(int version, String symbolSet, String entity, String entityType, String entitySubType, String entityCode, String geometry, String drawRule, ArrayList<String> modifiers) {
        this._Version = version;
        this._ID = symbolSet + entityCode;
        this._SymbolSetInt = Integer.parseInt(symbolSet);
        this._SymbolSet = MSInfo.parseSymbolSetName(symbolSet, this._Version);
        if (entitySubType != null && !entitySubType.equals("")) {
            this._Name = entitySubType;
            this._EntitySubType = entitySubType;
            this._Path = this._SymbolSet + " / " + entity + " / " + entityType + " / ";
        }
        if (entityType != null && !entityType.equals("")) {
            this._EntityType = entityType;
            if (this._Name == null) {
                this._Name = entityType;
            }
            if (this._Path == null) {
                this._Path = this._SymbolSet + " / " + entity + " / ";
            }
        }
        if (entity != null && !entity.equals("")) {
            this._Entity = entity;
            if (this._Name == null) {
                this._Name = entity;
            }
            if (this._Path == null) {
                this._Path = this._SymbolSet + " / ";
            }
        }
        if (entityCode != null & entityCode.length() == 6) {
            this._EntityCode = entityCode;
        }
        this._Geometry = geometry;
        this._DrawRule = this.parseDrawRule(drawRule);
        int[] pointCounts = null;
        if (symbolSet.equals("25")) {
            pointCounts = MSInfo.getMinMaxPointsFromDrawRule(this._DrawRule, version);
        } else if (symbolSet.equals("45") || symbolSet.equals("46")) {
            pointCounts = MSInfo.getMinMaxPointsFromMODrawRule(this._DrawRule);
        }
        this._MinPointCount = pointCounts[0];
        this._MaxPointCount = pointCounts[1];
        this._Modifiers = modifiers;
    }

    private int parseDrawRule(String drawRule) {
        String dr = drawRule.toLowerCase();
        int idr = 0;
        switch (dr) {
            case "area1": {
                idr = 101;
                break;
            }
            case "area2": {
                idr = 102;
                break;
            }
            case "area3": {
                idr = 103;
                break;
            }
            case "area4": {
                idr = 104;
                break;
            }
            case "area5": {
                idr = 105;
                break;
            }
            case "area6": {
                idr = 106;
                break;
            }
            case "area7": {
                idr = 107;
                break;
            }
            case "area8": {
                idr = 108;
                break;
            }
            case "area9": {
                idr = 109;
                break;
            }
            case "area10": {
                idr = 110;
                break;
            }
            case "area11": {
                idr = 111;
                break;
            }
            case "area12": {
                idr = 112;
                break;
            }
            case "area13": {
                idr = 113;
                break;
            }
            case "area14": {
                idr = 114;
                break;
            }
            case "area15": {
                idr = 115;
                break;
            }
            case "area16": {
                idr = 116;
                break;
            }
            case "area17": {
                idr = 117;
                break;
            }
            case "area18": {
                idr = 118;
                break;
            }
            case "area19": {
                idr = 119;
                break;
            }
            case "area20": {
                idr = 120;
                break;
            }
            case "area21": {
                idr = 121;
                break;
            }
            case "area22": {
                idr = 122;
                break;
            }
            case "area23": {
                idr = 123;
                break;
            }
            case "area24": {
                idr = 124;
                break;
            }
            case "area25": {
                idr = 125;
                break;
            }
            case "area26": {
                idr = 126;
                break;
            }
            case "point1": {
                idr = 201;
                break;
            }
            case "point2": {
                idr = 202;
                break;
            }
            case "point3": {
                idr = 203;
                break;
            }
            case "point4": {
                idr = 204;
                break;
            }
            case "point5": {
                idr = 205;
                break;
            }
            case "point6": {
                idr = 206;
                break;
            }
            case "point7": {
                idr = 207;
                break;
            }
            case "point8": {
                idr = 208;
                break;
            }
            case "point9": {
                idr = 209;
                break;
            }
            case "point10": {
                idr = 210;
                break;
            }
            case "point11": {
                idr = 211;
                break;
            }
            case "point12": {
                idr = 212;
                break;
            }
            case "point13": {
                idr = 213;
                break;
            }
            case "point14": {
                idr = 214;
                break;
            }
            case "point15": {
                idr = 215;
                break;
            }
            case "point16": {
                idr = 216;
                break;
            }
            case "point17": {
                idr = 217;
                break;
            }
            case "point18": {
                idr = 218;
                break;
            }
            case "line1": {
                idr = 301;
                break;
            }
            case "line2": {
                idr = 302;
                break;
            }
            case "line3": {
                idr = 303;
                break;
            }
            case "line4": {
                idr = 304;
                break;
            }
            case "line5": {
                idr = 305;
                break;
            }
            case "line6": {
                idr = 306;
                break;
            }
            case "line7": {
                idr = 307;
                break;
            }
            case "line8": {
                idr = 308;
                break;
            }
            case "line9": {
                idr = 309;
                break;
            }
            case "line10": {
                idr = 310;
                break;
            }
            case "line11": {
                idr = 311;
                break;
            }
            case "line12": {
                idr = 312;
                break;
            }
            case "line13": {
                idr = 313;
                break;
            }
            case "line14": {
                idr = 314;
                break;
            }
            case "line16": {
                idr = 316;
                break;
            }
            case "line17": {
                idr = 317;
                break;
            }
            case "line18": {
                idr = 318;
                break;
            }
            case "line19": {
                idr = 319;
                break;
            }
            case "line20": {
                idr = 320;
                break;
            }
            case "line21": {
                idr = 321;
                break;
            }
            case "line22": {
                idr = 322;
                break;
            }
            case "line23": {
                idr = 323;
                break;
            }
            case "line24": {
                idr = 324;
                break;
            }
            case "line25": {
                idr = 325;
                break;
            }
            case "line26": {
                idr = 326;
                break;
            }
            case "line27": {
                idr = 327;
                break;
            }
            case "line28": {
                idr = 328;
                break;
            }
            case "line29": {
                idr = 329;
                break;
            }
            case "corridor1": {
                idr = 401;
                break;
            }
            case "axis1": {
                idr = 501;
                break;
            }
            case "axis2": {
                idr = 502;
                break;
            }
            case "polyline1": {
                idr = 601;
                break;
            }
            case "ellipse1": {
                idr = 701;
                break;
            }
            case "rectangular1": {
                idr = 801;
                break;
            }
            case "rectangular2": {
                idr = 802;
                break;
            }
            case "rectangular3": {
                idr = 803;
                break;
            }
            case "circular1": {
                idr = 901;
                break;
            }
            case "circular2": {
                idr = 902;
                break;
            }
            case "arc1": {
                idr = 1001;
                break;
            }
            default: {
                idr = 0;
            }
        }
        return idr;
    }

    public static String parseSymbolSetName(String symbolID) {
        return MSInfo.parseSymbolSetName(symbolID.substring(4, 6), SymbolID.getVersion(symbolID));
    }

    public static String parseSymbolSetName(String ss, int version) {
        String name = null;
        switch (ss) {
            case "01": {
                name = "Air";
                break;
            }
            case "02": {
                name = "Air Missile";
                break;
            }
            case "05": {
                name = "Space";
                break;
            }
            case "06": {
                name = "Space Missile";
                break;
            }
            case "10": {
                name = "Land Unit";
                break;
            }
            case "11": {
                name = "Land Civilian Unit-Org";
                break;
            }
            case "15": {
                name = "Land Equipment";
                break;
            }
            case "20": {
                name = "Land Installations";
                break;
            }
            case "25": {
                name = "Control Measure";
                break;
            }
            case "27": {
                name = "Dismounted Individuals";
                break;
            }
            case "30": {
                name = "Sea Surface";
                break;
            }
            case "35": {
                name = "Sea Subsurface";
                break;
            }
            case "36": {
                name = "Mine Warfare";
                break;
            }
            case "40": {
                name = "Activities";
                break;
            }
            case "45": {
                name = "Atmospheric";
                break;
            }
            case "46": {
                name = "Oceanographic";
                break;
            }
            case "47": {
                name = "Meteorological Space";
                break;
            }
            case "50": {
                if (version < 13) {
                    name = "Space SIGINT";
                    break;
                }
                name = "SIGINT";
                break;
            }
            case "51": {
                name = "Air SIGINT";
                break;
            }
            case "52": {
                name = "Land SIGINT";
                break;
            }
            case "53": {
                name = "Sea Surface SIGINT";
                break;
            }
            case "54": {
                name = "Sea Subsurface SIGINT";
                break;
            }
            case "60": {
                name = "Cyberspace";
                break;
            }
            default: {
                name = "UNKNOWN";
            }
        }
        return name;
    }

    private static int[] getMinMaxPointsFromDrawRule(int drawRule, int version) {
        int[] points = new int[]{1, 1};
        switch (drawRule) {
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 109: 
            case 120: 
            case 123: {
                points[0] = 3;
                points[1] = Integer.MAX_VALUE;
                break;
            }
            case 105: 
            case 107: 
            case 111: 
            case 112: 
            case 117: 
            case 121: 
            case 124: 
            case 125: 
            case 212: 
            case 303: 
            case 306: 
            case 310: 
            case 312: 
            case 317: 
            case 322: 
            case 323: 
            case 324: 
            case 329: 
            case 601: {
                points[0] = 3;
                points[1] = 3;
                break;
            }
            case 106: 
            case 113: 
            case 115: 
            case 116: 
            case 119: 
            case 304: 
            case 305: 
            case 309: 
            case 314: 
            case 318: 
            case 319: 
            case 320: 
            case 325: 
            case 328: 
            case 801: 
            case 803: {
                points[0] = 2;
                points[1] = 2;
                break;
            }
            case 108: 
            case 118: 
            case 311: 
            case 316: {
                points[0] = 4;
                points[1] = 4;
                break;
            }
            case 110: {
                points[0] = 3;
                points[1] = 6;
                break;
            }
            case 114: {
                points[0] = 3;
                if (version == 10) {
                    points[1] = 4;
                    break;
                }
                points[1] = 3;
                break;
            }
            case 301: 
            case 302: 
            case 307: 
            case 313: 
            case 321: 
            case 401: {
                points[0] = 2;
                points[1] = Integer.MAX_VALUE;
                break;
            }
            case 126: {
                points[0] = 6;
                points[1] = Integer.MAX_VALUE;
                break;
            }
            case 308: {
                points[0] = 2;
                points[1] = 300;
                break;
            }
            case 326: 
            case 327: {
                points[0] = version >= 13 ? 4 : 3;
                points[1] = 4;
                break;
            }
            case 501: 
            case 502: {
                points[0] = 3;
                points[1] = 50;
                break;
            }
            case 0: {
                points[0] = 0;
                points[1] = 0;
                break;
            }
        }
        return points;
    }

    private static int[] getMinMaxPointsFromMODrawRule(int drawRule) {
        int[] points = new int[]{1, 1};
        switch (drawRule) {
            case 101: 
            case 102: 
            case 305: {
                points[0] = 3;
                points[1] = Integer.MAX_VALUE;
                break;
            }
            case 205: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 306: 
            case 307: 
            case 308: {
                points[0] = 2;
                points[1] = Integer.MAX_VALUE;
                break;
            }
            case 0: {
                points[0] = 0;
                points[1] = 0;
                break;
            }
        }
        return points;
    }

    public int getVersion() {
        return this._Version;
    }

    public String getName() {
        return this._Name;
    }

    public String getPath() {
        return this._Path;
    }

    public String getGeometry() {
        return this._Geometry;
    }

    public int getDrawRule() {
        return this._DrawRule;
    }

    public int getSymbolSet() {
        return this._SymbolSetInt;
    }

    public int getEntityCode() {
        return Integer.valueOf(this._EntityCode);
    }

    public String getBasicSymbolID() {
        if (this._SymbolSetInt < 10) {
            return "0" + this._SymbolSetInt + this._EntityCode;
        }
        return this._SymbolSetInt + this._EntityCode;
    }

    public int getMinPointCount() {
        return this._MinPointCount;
    }

    public int getMaxPointCount() {
        return this._MaxPointCount;
    }

    public ArrayList<String> getModifiers() {
        return this._Modifiers;
    }
}

