/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.SVGInfo;
import armyc2.c5isr.renderer.utilities.SymbolID;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class SVGLookup {
    private static SVGLookup _instance = null;
    private static Boolean _initCalled = false;
    private static Map<String, SVGInfo> _SVGLookupD = null;
    private static Map<String, SVGInfo> _SVGLookupE = null;
    private String TAG = "SVGLookup";

    private SVGLookup() {
        this.init();
    }

    public static synchronized SVGLookup getInstance() {
        if (_instance == null) {
            _instance = new SVGLookup();
        }
        return _instance;
    }

    private synchronized void init() {
        if (!_initCalled.booleanValue()) {
            _SVGLookupD = new HashMap<String, SVGInfo>();
            _SVGLookupE = new HashMap<String, SVGInfo>();
            try {
                InputStream isD = this.getClass().getClassLoader().getResourceAsStream("data/svgd.txt");
                this.loadData(isD, 11);
                isD.close();
                InputStream isE = this.getClass().getClassLoader().getResourceAsStream("data/svge.txt");
                this.loadData(isE, 13);
                isE.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        _initCalled = true;
    }

    private void loadData(InputStream is, int version) {
        String[] temp = null;
        String id = null;
        Rectangle2D.Float bbox = null;
        String svg = null;
        String delimiter = "~";
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = br.readLine();
            Map<String, SVGInfo> lookup = version == 13 ? _SVGLookupE : _SVGLookupD;
            while (line != null) {
                temp = line.split(delimiter);
                id = temp[0];
                float left = Float.parseFloat(temp[1]);
                float top = Float.parseFloat(temp[2]);
                float width = Float.parseFloat(temp[3]);
                float height = Float.parseFloat(temp[4]);
                bbox = new Rectangle2D.Float(left, top, width, height);
                svg = br.readLine();
                lookup.put(id, new SVGInfo(id, bbox, svg));
                line = br.readLine();
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public SVGInfo getSVGLInfo(String id, int version) {
        if (version >= 13) {
            if (_SVGLookupE.containsKey(id)) {
                return _SVGLookupE.get(id);
            }
        } else if (_SVGLookupD.containsKey(id)) {
            return _SVGLookupD.get(id);
        }
        return null;
    }

    public SVGInfo getSVGOctagon() {
        if (_SVGLookupD.containsKey("octagon")) {
            return _SVGLookupD.get("octagon");
        }
        return null;
    }

    public static String getFrameID(String symbolID) {
        String frameID = null;
        int affiliation = SymbolID.getAffiliation(symbolID);
        int status = SymbolID.getStatus(symbolID);
        if (affiliation == 0 || affiliation == 2 || affiliation == 5) {
            status = 0;
        }
        if (status > 1) {
            status = 0;
        }
        int context = SymbolID.getContext(symbolID);
        if (SymbolID.getVersion(symbolID) < 13) {
            String ss;
            switch (SymbolID.getSymbolSet(symbolID)) {
                case 1: 
                case 2: 
                case 51: {
                    ss = "01";
                    break;
                }
                case 5: 
                case 6: 
                case 50: {
                    ss = "05";
                    break;
                }
                case 10: 
                case 11: {
                    ss = "10";
                    break;
                }
                case 15: 
                case 52: 
                case 53: {
                    ss = "30";
                    break;
                }
                case 30: {
                    ss = "30";
                    if (SymbolID.getEntityCode(symbolID) != 150000) break;
                    return "octagon";
                }
                case 20: {
                    ss = "20";
                    break;
                }
                case 27: {
                    ss = "27";
                    break;
                }
                case 35: 
                case 36: 
                case 54: {
                    ss = "35";
                    break;
                }
                case 40: {
                    ss = "40";
                    break;
                }
                case 60: {
                    ss = "60";
                    break;
                }
                default: {
                    ss = "00";
                    if (context != 1 || affiliation <= 1) break;
                    affiliation = 1;
                }
            }
            frameID = context + "_" + affiliation + ss + "_" + status;
        } else {
            char frameShape = SymbolID.getFrameShape(symbolID);
            if (frameShape == '0') {
                frameShape = SymbolID.getDefaultFrameShape(symbolID);
                if (context == 1 && SymbolID.getSymbolSet(symbolID) == 0 && affiliation > 1) {
                    affiliation = 1;
                }
            }
            if (SymbolID.getSymbolSet(symbolID) == 30 && SymbolID.getEntityCode(symbolID) == 150000 && (frameShape == '4' || frameShape == '0')) {
                return "octagon";
            }
            frameID = context + "_" + affiliation + frameShape + "_" + status;
        }
        return frameID;
    }

    public static String getMainIconID(String symbolID) {
        Object mainIconID = symbolID.substring(4, 6) + symbolID.substring(10, 16);
        int ss = SymbolID.getSymbolSet(symbolID);
        if (ss == 36) {
            if (RendererSettings.getInstance().getSeaMineRenderMethod() == 2 || ((String)mainIconID).equals("36110600") || ((String)mainIconID).equals("36110700")) {
                mainIconID = (String)mainIconID + "_a";
            }
        } else if (ss == 10) {
            switch (SymbolID.getEntityCode(symbolID)) {
                case 111000: 
                case 111001: 
                case 111002: 
                case 111003: 
                case 111004: 
                case 111005: 
                case 111500: 
                case 120100: 
                case 120400: 
                case 120401: 
                case 120402: 
                case 120501: 
                case 120502: 
                case 120601: 
                case 120801: 
                case 121100: 
                case 121101: 
                case 121102: 
                case 121103: 
                case 121104: 
                case 121105: 
                case 121106: 
                case 121300: 
                case 121301: 
                case 121302: 
                case 121303: 
                case 121802: 
                case 130100: 
                case 130101: 
                case 130102: 
                case 130103: 
                case 130200: 
                case 130302: 
                case 140102: 
                case 140103: 
                case 140104: 
                case 140105: 
                case 140702: 
                case 140703: 
                case 141702: 
                case 150504: 
                case 150800: 
                case 160200: 
                case 161200: 
                case 161300: 
                case 161400: 
                case 161700: 
                case 161800: 
                case 161900: 
                case 162000: 
                case 162100: 
                case 162200: 
                case 163400: 
                case 163700: 
                case 163800: 
                case 163900: 
                case 164000: 
                case 164100: 
                case 164200: 
                case 164300: 
                case 164400: 
                case 164500: 
                case 164600: 
                case 165000: {
                    mainIconID = (String)mainIconID + SVGLookup.getPostFixForIcon(symbolID);
                    break;
                }
            }
        } else if (ss == 15) {
            switch (SymbolID.getEntityCode(symbolID)) {
                case 120111: {
                    mainIconID = (String)mainIconID + SVGLookup.getPostFixForIcon(symbolID);
                    break;
                }
            }
        } else if (ss == 20) {
            switch (SymbolID.getEntityCode(symbolID)) {
                case 110300: 
                case 111200: 
                case 120103: 
                case 120105: 
                case 120106: 
                case 120107: 
                case 120701: 
                case 120702: {
                    mainIconID = (String)mainIconID + SVGLookup.getPostFixForIcon(symbolID);
                    break;
                }
            }
        } else if (ss == 40) {
            switch (SymbolID.getEntityCode(symbolID)) {
                case 110303: 
                case 130201: 
                case 131202: 
                case 131208: {
                    mainIconID = (String)mainIconID + SVGLookup.getPostFixForIcon(symbolID);
                    break;
                }
            }
        } else if (ss == 0) {
            mainIconID = "00000000";
        } else if (ss != 1 && ss != 2 && ss != 5 && ss != 6 && ss != 11 && ss != 27 && ss != 25 && ss != 30 && ss != 35 && ss != 45 && ss != 46 && ss != 47 && ss != 50 && ss != 51 && ss != 52 && ss != 53 && ss != 54 && ss != 60) {
            mainIconID = "98100000";
        }
        return mainIconID;
    }

    private static String getPostFixForIcon(String symbolID) {
        int aff = SymbolID.getAffiliation(symbolID);
        Object pf = "";
        if (aff == 3 || aff == 2) {
            pf = (String)pf + "_1";
        } else if (aff == 4) {
            pf = (String)pf + "_2";
        } else if (aff == 6 || aff == 5) {
            pf = (String)pf + "_3";
        } else if (aff == 1 || aff == 0) {
            pf = (String)pf + "_0";
        }
        return pf;
    }

    public static String getMod1ID(String symbolID) {
        String mod1ID = null;
        if (SymbolID.getVersion(symbolID) >= 13 && symbolID.charAt(20) != '0') {
            mod1ID = symbolID.substring(20, 21) + symbolID.substring(16, 18) + "_1";
        } else {
            mod1ID = SymbolID.getEntity(symbolID) >= 11 ? symbolID.substring(4, 6) + symbolID.substring(16, 18) + "1" : symbolID.substring(4, 6) + "001";
            if (SymbolID.getSymbolSet(symbolID) == 10) {
                switch (SymbolID.getModifier1(symbolID)) {
                    case 98: {
                        mod1ID = mod1ID + SVGLookup.getPostFixForIcon(symbolID);
                        break;
                    }
                }
            }
        }
        return mod1ID;
    }

    public static String getMod2ID(String symbolID) {
        String mod2ID = null;
        if (SymbolID.getVersion(symbolID) >= 13 && symbolID.charAt(21) != '0') {
            mod2ID = symbolID.substring(21, 22) + symbolID.substring(18, 20) + "_2";
        } else {
            mod2ID = SymbolID.getEntity(symbolID) >= 11 ? symbolID.substring(4, 6) + symbolID.substring(18, 20) + "2" : symbolID.substring(4, 6) + "002";
            if (SymbolID.getSymbolSet(symbolID) == 10) {
                switch (SymbolID.getModifier2(symbolID)) {
                    case 60: 
                    case 62: 
                    case 84: 
                    case 89: {
                        mod2ID = mod2ID + SVGLookup.getPostFixForIcon(symbolID);
                        break;
                    }
                }
            }
        }
        return mod2ID;
    }

    public static String getEchelonAmplifier(String symbolID) {
        String amp = null;
        int ver = SymbolID.getVersion(symbolID);
        amp = ver < 13 ? symbolID.charAt(3) + symbolID.substring(8, 10) : symbolID.charAt(3) + symbolID.substring(8, 10);
        return amp;
    }

    public static String getHQTFFD(String symbolID) {
        String hqtffd = null;
        int ver = SymbolID.getVersion(symbolID);
        hqtffd = ver < 13 ? symbolID.substring(3, 6) + symbolID.charAt(7) : symbolID.substring(3, 6) + symbolID.charAt(7);
        return hqtffd;
    }

    public static String getOCA(String symbolID, boolean useSlash) {
        if (useSlash) {
            int status = SymbolID.getStatus(symbolID);
            if (status == 3 || status == 4) {
                return String.valueOf(status);
            }
            return null;
        }
        String oca = null;
        int ver = SymbolID.getVersion(symbolID);
        oca = ver < 13 ? symbolID.substring(2, 7) + "2" : symbolID.substring(2, 7) + "2";
        return oca;
    }

    public static String compileSVG(String svgTopFolder, String symbolID, String basicID) {
        String frameID = null;
        String iconID = null;
        String iconID2 = null;
        String mod1ID = null;
        String mod2ID = null;
        String hqtffdID = null;
        String ocaID = null;
        String ampID = null;
        SVGInfo siFrame = null;
        Object siIcon = null;
        Object siMod1 = null;
        Object siMod2 = null;
        boolean top = false;
        boolean left = false;
        boolean width = false;
        boolean height = false;
        String svgStart = null;
        Object strSVG = null;
        Object strSVGFrame = null;
        Object symbolBounds = null;
        Object fullBounds = null;
        StringBuilder sb = new StringBuilder();
        try {
            String symbolID2;
            String string = symbolID2 = basicID != null && basicID.length() == 8 ? SymbolID.setEntityCode(symbolID, Integer.parseInt(basicID.substring(2))) : null;
            if (symbolID2 != null) {
                symbolID2 = SymbolID.setSymbolSet(symbolID2, Integer.parseInt(basicID.substring(0, 2)));
            }
            int version = SymbolID.getVersion(symbolID);
            frameID = SVGLookup.getFrameID(symbolID);
            iconID = SVGLookup.getMainIconID(symbolID);
            iconID2 = SVGLookup.getMainIconID(symbolID2);
            mod1ID = SVGLookup.getMod1ID(symbolID);
            mod2ID = SVGLookup.getMod2ID(symbolID);
            hqtffdID = SVGLookup.getHQTFFD(symbolID);
            ocaID = SVGLookup.getOCA(symbolID, RendererSettings.getInstance().getOperationalConditionModifierType() == RendererSettings.OperationalConditionModifierType_SLASH);
            ampID = SVGLookup.getEchelonAmplifier(symbolID);
            String mainIcon1Path = null;
            String mainIcon2Path = null;
            siFrame = SVGLookup.getInstance().getSVGLInfo(frameID, version);
            svgStart = siFrame.getBbox().getMaxY() > 400.0 ? "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 612 792\">" : "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 400 400\">";
            sb.append(svgStart);
            String temp = null;
            File fileSVGTopFolder = new File((String)svgTopFolder);
            if (fileSVGTopFolder.exists() && fileSVGTopFolder.isDirectory()) {
                File tempSVG = null;
                String subFolder = "";
                int indexGroupStart = -1;
                int indexGroupEnd = -1;
                if (frameID.startsWith("1")) {
                    subFolder = "Exercise/";
                }
                if (frameID.startsWith("2")) {
                    subFolder = "Sim/";
                }
                if ((tempSVG = new File((String)svgTopFolder + "/Frames/" + subFolder + frameID + ".svg")).exists() && tempSVG.isFile()) {
                    temp = SVGLookup.readSVGFile(tempSVG);
                    if (temp != null) {
                        indexGroupStart = temp.indexOf("<g id=\"frame\"");
                        indexGroupEnd = temp.indexOf("</svg>");
                        temp = temp.substring(indexGroupStart, indexGroupEnd);
                    }
                    sb.append(temp);
                }
                Object symbolSet = null;
                int ss = SymbolID.getSymbolSet(symbolID);
                mainIcon1Path = (String)svgTopFolder + "/Appendices/" + SVGLookup.getMainIconFolder(ss);
                tempSVG = new File(mainIcon1Path + iconID + ".svg");
                if (tempSVG.exists() && tempSVG.isFile()) {
                    temp = SVGLookup.readSVGFile(tempSVG);
                    if (temp != null) {
                        indexGroupStart = temp.indexOf("<g id=\"main\"");
                        indexGroupEnd = temp.indexOf("</svg>");
                        temp = temp.substring(indexGroupStart, indexGroupEnd);
                    }
                    sb.append(temp);
                }
                if (symbolID2 != null && (tempSVG = new File((mainIcon2Path = (String)svgTopFolder + "/Appendices/" + SVGLookup.getMainIconFolder(ss = SymbolID.getSymbolSet(symbolID2))) + iconID2 + ".svg")).exists() && tempSVG.isFile()) {
                    temp = SVGLookup.readSVGFile(tempSVG);
                    if (temp != null) {
                        indexGroupStart = temp.indexOf("<g id=\"main\"");
                        indexGroupEnd = temp.indexOf("</svg>");
                        temp = temp.substring(indexGroupStart, indexGroupEnd);
                    }
                    sb.append(temp);
                }
                if ((tempSVG = new File(mainIcon1Path + "/mod1/" + mod1ID + ".svg")).exists() && tempSVG.isFile()) {
                    temp = SVGLookup.readSVGFile(tempSVG);
                    if (temp != null) {
                        indexGroupStart = temp.indexOf("<g id=\"mod1\"");
                        indexGroupEnd = temp.indexOf("</svg>");
                        temp = temp.substring(indexGroupStart, indexGroupEnd);
                    }
                    sb.append(temp);
                }
                if ((tempSVG = new File(mainIcon1Path + "/mod2/" + mod2ID + ".svg")).exists() && tempSVG.isFile()) {
                    temp = SVGLookup.readSVGFile(tempSVG);
                    if (temp != null) {
                        indexGroupStart = temp.indexOf("<g id=\"mod2\"");
                        indexGroupEnd = temp.indexOf("</svg>");
                        temp = temp.substring(indexGroupStart, indexGroupEnd);
                    }
                    sb.append(temp);
                }
                String ampPath = svgTopFolder;
                svgTopFolder = SymbolID.getAmplifierDescriptor(symbolID) < 30 ? (String)svgTopFolder + "/Echelon/" : (String)svgTopFolder + "/Amplifier/";
                tempSVG = new File(ampPath + ampID + ".svg");
                if (tempSVG.exists() && tempSVG.isFile()) {
                    temp = SVGLookup.readSVGFile(tempSVG);
                    if (temp != null) {
                        indexGroupStart = SymbolID.getAmplifierDescriptor(symbolID) < 30 ? temp.indexOf("<g id=\"echelon\"") : temp.indexOf("<g id=\"Amplifier\"");
                        indexGroupEnd = temp.indexOf("</svg>");
                        temp = temp.substring(indexGroupStart, indexGroupEnd);
                    }
                    sb.append(temp);
                }
                if ((tempSVG = new File((String)svgTopFolder + "HQTFFD/" + hqtffdID + ".svg")).exists() && tempSVG.isFile()) {
                    temp = SVGLookup.readSVGFile(tempSVG);
                    if (temp != null) {
                        indexGroupStart = temp.indexOf("<g id=\"HQTFFD\"");
                        indexGroupEnd = temp.indexOf("</svg>");
                        temp = temp.substring(indexGroupStart, indexGroupEnd);
                    }
                    sb.append(temp);
                }
                if ((tempSVG = new File((String)svgTopFolder + "OCA/" + ocaID + ".svg")).exists() && tempSVG.isFile()) {
                    temp = SVGLookup.readSVGFile(tempSVG);
                    if (temp != null) {
                        indexGroupStart = temp.indexOf("<g id=\"oca\"");
                        indexGroupEnd = temp.indexOf("</svg>");
                        temp = temp.substring(indexGroupStart, indexGroupEnd);
                    }
                    sb.append(temp);
                }
                sb.append("</svg>");
            }
            return sb.toString();
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            return sb.toString();
        }
    }

    private static String readSVGFile(File svg) {
        StringBuilder sb = new StringBuilder();
        try {
            Scanner myReader = new Scanner(svg);
            while (myReader.hasNextLine()) {
                String data = myReader.nextLine();
                sb.append(data);
            }
            myReader.close();
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static String getMainIconFolder(int ss) {
        switch (ss) {
            case 1: 
            case 2: {
                return "Air/";
            }
            case 5: 
            case 6: {
                return "Space/";
            }
            case 10: 
            case 11: 
            case 15: 
            case 20: {
                return "Land/";
            }
            case 25: {
                return "ControlMeasures/";
            }
            case 27: {
                return "Dismounted/";
            }
            case 30: {
                return "SeaSurface/";
            }
            case 35: 
            case 36: {
                return "SeaSubsurface/";
            }
            case 40: {
                return "Activities/";
            }
            case 45: {
                return "METOC/Atmospheric/";
            }
            case 46: {
                return "METOC/Oceanographic/";
            }
            case 47: {
                return "METOC/Space/";
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return "SigInt/";
            }
        }
        return "";
    }

    public static List<String> getAllKeys() {
        ArrayList<String> kl = new ArrayList<String>();
        Set<String> keys = _SVGLookupD.keySet();
        for (String key : keys) {
            kl.add(key);
        }
        return kl;
    }

    public boolean addCustomSymbol(SVGInfo svgInfo, int version) {
        boolean success = false;
        try {
            String basicID = svgInfo.getID();
            if (version < 13) {
                if (!_SVGLookupD.containsKey(svgInfo.getID())) {
                    _SVGLookupD.put(svgInfo.getID(), svgInfo);
                }
            } else if (version == 13 && !_SVGLookupE.containsKey(svgInfo.getID())) {
                _SVGLookupE.put(svgInfo.getID(), svgInfo);
            }
        }
        catch (Exception e) {
            ErrorLogger.LogException("SVGLookup", "addCUstomSymbol", e);
        }
        return success;
    }
}

