/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.TextInfo;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Base64;

public class Shape2SVG {
    public static String Convert(Shape shape, String stroke, String fill, String strokeWidth, String strokeOpacity, String fillOpacity, String dashArray, String lineCap) {
        if (shape instanceof Path2D) {
            return Shape2SVG.convertPath((Path2D)shape, stroke, fill, strokeWidth, strokeOpacity, fillOpacity, dashArray, lineCap);
        }
        if (shape instanceof Rectangle2D) {
            return Shape2SVG.convertRect((Rectangle2D)shape, stroke, fill, strokeWidth, strokeOpacity, fillOpacity, dashArray, lineCap);
        }
        return null;
    }

    public static String Convert(String text, int x, int y, Font font, FontRenderContext frc, String stroke, String fill, String strokeWidth, String strokeOpacity, String fillOpacity, String dashArray) {
        TextInfo textInfo = new TextInfo(text, x, y, font, frc);
        return Shape2SVG.Convert(textInfo, stroke, fill, strokeWidth, strokeOpacity, fillOpacity, dashArray);
    }

    public static String Convert(TextInfo textInfo, String stroke, String fill, String strokeWidth, String strokeOpacity, String fillOpacity, String dashArray) {
        Object svg = null;
        StringBuilder sb = new StringBuilder();
        if (textInfo != null) {
            Object style = null;
            String name = RendererSettings.getInstance().getLabelFont().getFontName() + ", sans-serif";
            String size = String.valueOf(RendererSettings.getInstance().getLabelFont().getSize());
            String weight = null;
            String anchor = null;
            String text = textInfo.getText();
            text = text.replaceAll("&", "&amp;");
            text = text.replaceAll("<", "&lt;");
            text = text.replaceAll(">", "&gt;");
            Point2D.Double location = new Point2D.Double(textInfo.getLocation().getX(), textInfo.getLocation().getY());
            if (textInfo.getLocation().getX() < 0.0) {
                if (textInfo.getLocation().getX() + textInfo.getTextBounds().getWidth() > 0.0) {
                    anchor = "middle";
                    ((Point2D)location).setLocation(textInfo.getTextBounds().getCenterX(), ((Point2D)location).getY());
                } else {
                    anchor = "end";
                    ((Point2D)location).setLocation(textInfo.getTextBounds().getMaxX(), ((Point2D)location).getY());
                }
            }
            if (RendererSettings.getInstance().getLabelFont().isBold()) {
                weight = "bold";
            }
            sb.append("<text x=\"" + ((Point2D)location).getX() + "\" y=\"" + ((Point2D)location).getY() + "\"");
            if (anchor != null) {
                sb.append(" text-anchor=\"" + anchor + "\"");
            }
            sb.append(" font-family=\"" + name + "\"");
            sb.append(" font-size=\"" + size + "px\"");
            if (weight != null) {
                sb.append(" font-weight=\"" + weight + "\"");
            }
            sb.append(" alignment-baseline=\"alphabetic\"");
            sb.append(" stroke-miterlimit=\"3\"");
            Object seStroke = "";
            Object seFill = "";
            if (stroke != null) {
                seStroke = sb.toString();
                seStroke = (String)seStroke + " stroke=\"" + stroke + "\"";
                if (strokeWidth != null) {
                    seStroke = (String)seStroke + " stroke-width=\"" + strokeWidth + "\"";
                }
                seStroke = (String)seStroke + " fill=\"none\"";
                seStroke = (String)seStroke + ">";
                seStroke = (String)seStroke + text;
                seStroke = (String)seStroke + "</text>";
            }
            if (fill != null) {
                seFill = sb.toString();
                seFill = (String)seFill + " fill=\"" + fill + "\"";
                seFill = (String)seFill + ">";
                seFill = (String)seFill + text;
                seFill = (String)seFill + "</text>";
            }
            sb = new StringBuilder();
            if (stroke != null && fill != null) {
                sb.append((String)seStroke + "\n" + (String)seFill).append("\n");
            } else if (fill != null) {
                sb.append((String)seFill);
            } else {
                return null;
            }
            return sb.toString();
        }
        return null;
    }

    public static String ConvertForGroup(TextInfo textInfo, String stroke, String fill, String strokeWidth, String strokeOpacity, String fillOpacity, String dashArray) {
        Object svg = null;
        StringBuilder sb = new StringBuilder();
        if (textInfo != null) {
            String anchor = null;
            String text = textInfo.getText();
            text = text.replaceAll("&", "&amp;");
            text = text.replaceAll("<", "&lt;");
            text = text.replaceAll(">", "&gt;");
            Point2D.Double location = new Point2D.Double(textInfo.getLocation().getX(), textInfo.getLocation().getY());
            if (textInfo.getLocation().getX() < 0.0) {
                if (textInfo.getLocation().getX() + textInfo.getTextBounds().getWidth() > 0.0) {
                    anchor = "middle";
                    ((Point2D)location).setLocation(textInfo.getTextBounds().getCenterX(), ((Point2D)location).getY());
                } else {
                    anchor = "end";
                    ((Point2D)location).setLocation(textInfo.getTextBounds().getMaxX(), ((Point2D)location).getY());
                }
            }
            sb.append("<text x=\"" + ((Point2D)location).getX() + "\" y=\"" + ((Point2D)location).getY() + "\"");
            if (anchor != null) {
                sb.append(" text-anchor=\"" + anchor + "\"");
            }
            Object seStroke = "";
            Object seFill = "";
            if (stroke != null) {
                seStroke = sb.toString();
                seStroke = (String)seStroke + " stroke=\"" + stroke + "\"";
                if (strokeWidth != null) {
                    seStroke = (String)seStroke + " stroke-width=\"" + strokeWidth + "\"";
                }
                seStroke = (String)seStroke + " fill=\"none\"";
                seStroke = (String)seStroke + ">";
                seStroke = (String)seStroke + text;
                seStroke = (String)seStroke + "</text>";
            }
            if (fill != null) {
                seFill = sb.toString();
                seFill = (String)seFill + " fill=\"" + fill + "\"";
                seFill = (String)seFill + ">";
                seFill = (String)seFill + text;
                seFill = (String)seFill + "</text>";
            }
            sb = new StringBuilder();
            if (stroke != null && fill != null) {
                sb.append((String)seStroke + "\n" + (String)seFill).append("\n");
            } else if (fill != null) {
                sb.append((String)seFill);
            } else {
                return null;
            }
            return sb.toString();
        }
        return null;
    }

    public static String makeBase64Safe(String svg) {
        if (svg != null) {
            return new String(Base64.getUrlEncoder().encodeToString(svg.getBytes()));
        }
        return null;
    }

    private static String convertArc(Arc2D arc) {
        return null;
    }

    private static String convertPath(Path2D path2D, String stroke, String fill, String strokeWidth, String strokeOpacity, String fillOpacity, String dashArray, String lineCap) {
        double[] coords = new double[6];
        StringBuilder sbPath = new StringBuilder();
        StringBuilder sbLine = new StringBuilder();
        String path = "";
        Object moveTo = null;
        int windingRule = 0;
        int format = 1;
        PathIterator pitr = path2D.getPathIterator(null);
        windingRule = pitr.getWindingRule();
        do {
            int type;
            if ((type = pitr.currentSegment(coords)) == 1) {
                sbPath.append("L" + coords[0] + " " + coords[1]);
            } else if (type == 0) {
                sbPath.append("M" + coords[0] + " " + coords[1]);
            } else if (type == 2) {
                sbPath.append("Q" + coords[0] + " " + coords[1] + " " + coords[2] + " " + coords[3]);
            } else if (type == 3) {
                sbPath.append("C" + coords[0] + " " + coords[1] + " " + coords[2] + " " + coords[3] + " " + coords[4] + " " + coords[5]);
            } else if (type == 4) {
                sbPath.append("Z");
            }
            pitr.next();
        } while (!pitr.isDone());
        sbLine.append("<path d=\"").append((CharSequence)sbPath).append("\"");
        if (stroke != null) {
            if (format == 2) {
                sbLine.append(" stroke=\"").append(stroke.replace("#", "%23")).append("\"");
            } else {
                sbLine.append(" stroke=\"").append(stroke).append("\"");
            }
            if (strokeWidth != null) {
                sbLine.append(" stroke-width=\"").append(strokeWidth).append("\"");
            } else {
                sbLine.append(" stroke-width=\"2\"");
            }
            if (strokeOpacity != null && strokeOpacity != "1.0") {
                sbLine.append(" stroke-opacity=\"").append(strokeOpacity).append("\"");
            }
            if (lineCap != null && (lineCap.equalsIgnoreCase("butt") || lineCap.equalsIgnoreCase("round") || lineCap.equalsIgnoreCase("square"))) {
                sbLine.append(" stroke-linecap=\"").append(lineCap).append("\"");
            } else {
                sbLine.append(" stroke-linecap=\"round\"");
            }
            if (dashArray != null) {
                sbLine.append(" stroke-dasharray=\"").append(dashArray).append("\"");
            }
        }
        if (fill != null) {
            if (format == 2) {
                sbLine.append(" fill=\"").append(fill.replace("#", "%23")).append("\"");
            } else {
                sbLine.append(" fill=\"").append(fill).append("\"");
            }
            if (fillOpacity != null && fillOpacity != "1.0") {
                sbLine.append(" fill-opacity=\"").append(fillOpacity).append("\"");
            }
        } else {
            sbLine.append(" fill=\"none\"");
        }
        sbLine.append(" />");
        return sbLine.toString();
    }

    private static String convertRect(Rectangle2D rect, String stroke, String fill, String strokeWidth, String strokeOpacity, String fillOpacity, String dashArray, String lineCap) {
        StringBuilder sb = new StringBuilder();
        if (rect != null && !rect.isEmpty()) {
            sb.append("<rect x=\"" + rect.getX() + "\" y=\"" + rect.getY());
            sb.append("\" width=\"" + rect.getWidth() + "\" height=\"" + rect.getHeight() + "\"");
            if (stroke != null) {
                sb.append(" stroke=\"" + stroke + "\"");
                if (strokeWidth != null) {
                    sb.append(" stroke-width=\"" + strokeWidth + "\"");
                } else {
                    sb.append(" stroke-width=\"2\"");
                }
                if (lineCap != null && (lineCap.equalsIgnoreCase("butt") || lineCap.equalsIgnoreCase("round") || lineCap.equalsIgnoreCase("square"))) {
                    sb.append(" stroke-linecap=\"").append(lineCap).append("\"");
                }
            }
            if (fill != null) {
                sb.append(" fill=\"" + fill + "\"");
            } else {
                sb.append(" fill=\"none\"");
            }
            sb.append("/>");
            return sb.toString();
        }
        return null;
    }
}

