/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.web.render;

import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.RendererUtilities;
import armyc2.c5isr.renderer.utilities.ShapeInfo;
import armyc2.c5isr.web.render.MultiPointHandler;
import armyc2.c5isr.web.render.utilities.Path;
import armyc2.c5isr.web.render.utilities.SVGTextInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class MultiPointHandlerSVG {
    public static String GeoSVGize(String id, String name, String description, String symbolID, ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, boolean normalize, String textColor, String textBackgroundColor, boolean wasClipped) {
        return MultiPointHandlerSVG.GeoSVGize(id, name, description, symbolID, shapes, modifiers, ipc, normalize, textColor, textBackgroundColor, wasClipped, null);
    }

    public static String GeoSVGize(String id, String name, String description, String symbolID, ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, boolean normalize, String textColor, String textBackgroundColor, boolean wasClipped, Rectangle bbox) {
        int i;
        int height = 10;
        Rectangle tempBounds = null;
        ArrayList<Object> paths = new ArrayList<Object>();
        RectangularShape pathBounds = null;
        ArrayList<SVGTextInfo> labels = new ArrayList<SVGTextInfo>();
        Rectangle labelBounds = null;
        Rectangle unionBounds = null;
        String fillTexture = null;
        Point2D geoCoordTL = null;
        Point2D geoCoordTR = null;
        Point2D geoCoordBL = null;
        Point2D geoCoordBR = null;
        Point2D west = null;
        Point2D north = null;
        Point2D south = null;
        Point2D east = null;
        int len = shapes.size();
        try {
            Font fontInfo = RendererSettings.getInstance().getMPLabelFont();
            height = fontInfo.getSize();
            for (i = 0; i < len; ++i) {
                tempBounds = new Rectangle();
                String svg = MultiPointHandlerSVG.ShapesToGeoSVG(symbolID, shapes.get(i), tempBounds, ipc, normalize);
                if (svg == null) continue;
                float lineWidth = shapes.get(i).getStroke().getLineWidth();
                tempBounds.grow(Math.round(lineWidth / 2.0f), Math.round(lineWidth / 2.0f));
                pathBounds = pathBounds == null ? (Rectangle)tempBounds.clone() : ((Rectangle)pathBounds).union(tempBounds);
                paths.add(svg);
                if (shapes.get(i).getPatternFillImage() == null || fillTexture != null) continue;
                fillTexture = MultiPointHandlerSVG.getFillPattern(shapes.get(i));
            }
            int len2 = modifiers.size();
            SVGTextInfo tiTemp = null;
            for (int j = 0; j < len2; ++j) {
                ShapeInfo tempModifier = modifiers.get(j);
                if (tempModifier.getModifierString() != null && !tempModifier.getModifierString().isEmpty()) {
                    Point2D tempLocation = tempModifier.getModifierPosition();
                    int justify = tempModifier.getTextJustify();
                    String strJustify = "start";
                    if (justify == ShapeInfo.justify_left) {
                        strJustify = "start";
                    } else if (justify == ShapeInfo.justify_center) {
                        strJustify = "middle";
                    } else if (justify == ShapeInfo.justify_right) {
                        strJustify = "end";
                    }
                    double degrees = tempModifier.getModifierAngle();
                    tiTemp = new SVGTextInfo(tempModifier.getModifierString(), tempLocation, fontInfo, strJustify, degrees);
                    Rectangle bounds = tiTemp.getTextBounds().getBounds();
                    if (tiTemp == null || (bbox == null || !bbox.intersects(bounds)) && bbox != null) continue;
                    labels.add(tiTemp);
                    if (bounds == null) continue;
                    if (labelBounds != null) {
                        labelBounds = labelBounds.union(bounds);
                        continue;
                    }
                    labelBounds = bounds;
                    continue;
                }
                if (tempModifier.getModifierImage() == null) continue;
                BufferedImage imgModifier = tempModifier.getModifierImage();
                Rectangle bounds = new Rectangle(0, 0, imgModifier.getWidth(), imgModifier.getHeight());
                Point2D tempLocation = tempModifier.getModifierPosition();
                tempLocation.setLocation(tempLocation.getX() - bounds.getWidth() / 2.0, tempLocation.getY() - bounds.getHeight() / 2.0);
                int x = (int)tempLocation.getX();
                int y = (int)tempLocation.getY();
                bounds.setLocation(x, y);
                double angle = tempModifier.getModifierAngle();
                paths.add("<image transform=\"translate(" + x + "," + y + ") rotate(" + angle + ")\" href=\"" + RendererUtilities.imgToBase64String(tempModifier.getModifierImage()) + "\" />");
                if (angle != 0.0) {
                    Rectangle2D bounds2D = SVGTextInfo.getRotatedRectangleBounds(bounds, tempLocation, -angle, "middle");
                    bounds = bounds2D.getBounds();
                }
                if (bounds == null || (bbox == null || !bbox.intersects(bounds)) && bbox != null) continue;
                pathBounds = pathBounds != null ? ((Rectangle)pathBounds).union(bounds) : bounds;
            }
            if (pathBounds != null) {
                unionBounds = (Rectangle)pathBounds.clone();
            }
            if (labelBounds != null) {
                unionBounds = unionBounds != null ? unionBounds.union(labelBounds) : labelBounds;
            }
            if (unionBounds != null) {
                Point2D.Double coordTL = new Point2D.Double();
                ((Point2D)coordTL).setLocation(unionBounds.getX(), unionBounds.getY());
                Point2D.Double coordBR = new Point2D.Double();
                ((Point2D)coordBR).setLocation(unionBounds.getX() + unionBounds.getWidth(), unionBounds.getY() + unionBounds.getHeight());
                Point2D.Double coordTR = new Point2D.Double();
                ((Point2D)coordTR).setLocation(unionBounds.getX() + unionBounds.getWidth(), unionBounds.getY());
                Point2D.Double coordBL = new Point2D.Double();
                ((Point2D)coordBL).setLocation(unionBounds.getX(), unionBounds.getY() + unionBounds.getHeight());
                south = new Point2D.Double(unionBounds.getX() + unionBounds.getWidth() / 2.0, unionBounds.getY() + unionBounds.getHeight());
                north = new Point2D.Double(unionBounds.getX() + unionBounds.getWidth() / 2.0, unionBounds.getY());
                east = new Point2D.Double(unionBounds.getX() + unionBounds.getWidth(), unionBounds.getY() + unionBounds.getHeight() / 2.0);
                west = new Point2D.Double(unionBounds.getX(), unionBounds.getY() + unionBounds.getHeight() / 2.0);
                geoCoordTL = ipc.PixelsToGeo(coordTL);
                geoCoordBR = ipc.PixelsToGeo(coordBR);
                geoCoordTR = ipc.PixelsToGeo(coordTR);
                geoCoordBL = ipc.PixelsToGeo(coordBL);
                north = ipc.PixelsToGeo(north);
                south = ipc.PixelsToGeo(south);
                east = ipc.PixelsToGeo(east);
                west = ipc.PixelsToGeo(west);
                if (normalize) {
                    geoCoordTL = MultiPointHandler.NormalizeCoordToGECoord(geoCoordTL);
                    geoCoordBR = MultiPointHandler.NormalizeCoordToGECoord(geoCoordBR);
                    geoCoordTR = MultiPointHandler.NormalizeCoordToGECoord(geoCoordTR);
                    geoCoordBL = MultiPointHandler.NormalizeCoordToGECoord(geoCoordBL);
                    north = MultiPointHandler.NormalizeCoordToGECoord(north);
                    south = MultiPointHandler.NormalizeCoordToGECoord(south);
                    east = MultiPointHandler.NormalizeCoordToGECoord(east);
                    west = MultiPointHandler.NormalizeCoordToGECoord(west);
                }
            } else {
                geoCoordTL = new Point2D.Double(0.0, 0.0);
                geoCoordBR = new Point2D.Double(0.0, 0.0);
                geoCoordTR = new Point2D.Double(0.0, 0.0);
                geoCoordBL = new Point2D.Double(0.0, 0.0);
                north = new Point2D.Double(0.0, 0.0);
                south = new Point2D.Double(0.0, 0.0);
                east = new Point2D.Double(0.0, 0.0);
                west = new Point2D.Double(0.0, 0.0);
            }
        }
        catch (Exception err) {
            ErrorLogger.LogException("MultiPointHandler", "GeoSVGize", err);
        }
        if (paths != null && len > 0 && unionBounds != null) {
            String group = "<g transform=\"translate(" + unionBounds.getX() * -1.0 + "," + unionBounds.getY() * -1.0 + ")\">";
            for (i = 0; i < paths.size(); ++i) {
                group = group + (String)paths.get(i);
            }
            ArrayList<String> labelStrs = MultiPointHandlerSVG.renderTextElement(labels, textColor, textBackgroundColor);
            for (int j = 0; j < labelStrs.size(); ++j) {
                group = group + labelStrs.get(j);
            }
            group = group + "</g>";
            String geoSVG = "<svg width=\"" + Math.ceil(unionBounds.getWidth()) + "px\" height=\"" + Math.ceil(unionBounds.getHeight()) + "px\" preserveAspectRatio=\"none\" xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\">";
            geoSVG = geoSVG + "<metadata>\n";
            geoSVG = geoSVG + "<id>" + id + "</id>\n";
            geoSVG = geoSVG + "<name>" + name + "</name>\n";
            geoSVG = geoSVG + "<description>" + description + "</description>\n";
            geoSVG = geoSVG + "<symbolID>" + symbolID + "</symbolID>\n";
            geoSVG = geoSVG + "<geoTL>" + ((Point2D)geoCoordTL).getX() + " " + ((Point2D)geoCoordTL).getY() + "</geoTL>\n";
            geoSVG = geoSVG + "<geoBR>" + ((Point2D)geoCoordBR).getX() + " " + ((Point2D)geoCoordBR).getY() + "</geoBR>\n";
            geoSVG = geoSVG + "<geoTR>" + ((Point2D)geoCoordTR).getX() + " " + ((Point2D)geoCoordTR).getY() + "</geoTR>\n";
            geoSVG = geoSVG + "<geoBL>" + ((Point2D)geoCoordBL).getX() + " " + ((Point2D)geoCoordBL).getY() + "</geoBL>\n";
            geoSVG = geoSVG + "<north>" + ((Point2D)north).getY() + "</north>\n";
            geoSVG = geoSVG + "<south>" + ((Point2D)south).getY() + "</south>\n";
            geoSVG = geoSVG + "<east>" + ((Point2D)east).getX() + "</east>\n";
            geoSVG = geoSVG + "<west>" + ((Point2D)west).getX() + "</west>\n";
            geoSVG = geoSVG + "<wasClipped>" + wasClipped + "</wasClipped>\n";
            geoSVG = geoSVG + "<width>" + unionBounds.getWidth() + "</width>\n";
            geoSVG = geoSVG + "<height>" + unionBounds.getHeight() + "</height>\n";
            geoSVG = geoSVG + "</metadata>\n";
            if (fillTexture != null) {
                geoSVG = geoSVG + fillTexture;
            }
            geoSVG = geoSVG + group;
            geoSVG = geoSVG + "</svg>";
            return geoSVG;
        }
        return "<svg width=\"2px\" height=\"2px\" xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\"></svg>";
    }

    static ArrayList<String> renderTextElement(ArrayList<SVGTextInfo> tiArray, String color, String outlineColor) {
        ArrayList<String> svgElements = new ArrayList<String>();
        int size = tiArray.size();
        SVGTextInfo tempShape = null;
        String textColor = "#000000";
        int tbm = RendererSettings.getInstance().getTextBackgroundMethod();
        int outlineWidth = RendererSettings.getInstance().getTextOutlineWidth();
        if (color != null) {
            textColor = color;
        }
        if (outlineColor == null || outlineColor.isEmpty()) {
            outlineColor = RendererUtilities.colorToHexString(RendererUtilities.getIdealOutlineColor(RendererUtilities.getColorFromHexString(textColor)), false);
        }
        if (tbm == 2 || tbm == 3 || tbm == 1) {
            for (int i = 0; i < size; ++i) {
                tempShape = tiArray.get(i);
                svgElements.add(tempShape.toSVGElement(textColor, outlineColor, outlineWidth));
            }
        } else {
            for (int j = 0; j < size; ++j) {
                tempShape = tiArray.get(j);
                svgElements.add(tempShape.toSVGElement(textColor, null, 0.0));
            }
        }
        return svgElements;
    }

    static String getFillPattern(ShapeInfo shapeInfo) {
        if (shapeInfo.getPatternFillImage() != null) {
            int width = shapeInfo.getPatternFillImage().getWidth();
            int height = shapeInfo.getPatternFillImage().getHeight();
            return "<defs><pattern id=\"fillPattern\" patternUnits=\"userSpaceOnUse\" width=\"" + width + "\" height=\"" + height + "\"><image href=\"" + RendererUtilities.imgToBase64String(shapeInfo.getPatternFillImage()) + "\" /></pattern></defs>";
        }
        return null;
    }

    static String ShapesToGeoSVG(String symbolID, ShapeInfo shapeInfo, Rectangle pathBounds, IPointConversion ipc, boolean normalize) {
        BasicStroke stroke;
        Path path = null;
        String fillColor = null;
        String lineColor = null;
        int lineWidth = 0;
        double lineAlpha = 1.0;
        double fillAlpha = 1.0;
        float[] dashArray = null;
        Object fillPattern = null;
        if (shapeInfo.getLineColor() != null) {
            Color lineColorTemp = shapeInfo.getLineColor();
            lineAlpha = (double)lineColorTemp.getAlpha() / 255.0;
            lineColor = RendererUtilities.colorToHexString(lineColorTemp, false);
        }
        if (shapeInfo.getFillColor() != null) {
            Color fillColorTemp = shapeInfo.getFillColor();
            fillAlpha = (double)fillColorTemp.getAlpha() / 255.0;
            fillColor = RendererUtilities.colorToHexString(fillColorTemp, false);
        }
        if ((stroke = shapeInfo.getStroke()) != null) {
            lineWidth = Math.round(stroke.getLineWidth());
            dashArray = stroke.getDashArray();
        }
        ArrayList<ArrayList<Point2D>> shapesArray = shapeInfo.getPolylines();
        path = new Path();
        if (dashArray != null && dashArray.length > 0) {
            path.setLineDash(dashArray);
        }
        for (int i = 0; i < shapesArray.size(); ++i) {
            ArrayList<Point2D> shape = shapesArray.get(i);
            for (int j = 0; j < shape.size(); ++j) {
                Point2D coord = shape.get(j);
                if (j == 0) {
                    path.moveTo(coord.getX(), coord.getY());
                    continue;
                }
                if (dashArray != null) {
                    path.dashedLineTo(coord.getX(), coord.getY());
                    continue;
                }
                path.lineTo(coord.getX(), coord.getY());
            }
        }
        if (shapeInfo.getPatternFillImage() != null) {
            fillColor = "url(#fillPattern)";
        }
        String svgElement = path.toSVGElement(lineColor, lineWidth, fillColor, lineAlpha, fillAlpha);
        pathBounds.setBounds(path.getBounds().getBounds());
        return svgElement;
    }
}

