/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.web.render.utilities;

import java.awt.geom.Point2D;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class JavaRendererUtilities {
    public static final String HOSTILE_FILL_COLOR = "FFFF8080";
    public static final String FRIENDLY_FILL_COLOR = "FF80E0FF";
    public static final String NEUTRAL_FILL_COLOR = "FFAAFFAA";
    public static final String UNKNOWN_FILL_COLOR = "FFFFFF80";

    public static String ARGBtoABGR(String rgbString) {
        if (rgbString.length() == 6) {
            String s = "FF";
            rgbString = s.concat(rgbString);
        }
        Object bgrString = rgbString.toUpperCase(Locale.US);
        if (rgbString.length() == 8) {
            char[] c = rgbString.toCharArray();
            char temp1 = c[2];
            char temp2 = c[3];
            c[2] = c[6];
            c[3] = c[7];
            c[6] = temp1;
            c[7] = temp2;
            bgrString = new String(c);
        } else if (rgbString.length() == 6) {
            char[] c = rgbString.toCharArray();
            char temp1 = c[0];
            char temp2 = c[1];
            c[0] = c[4];
            c[1] = c[5];
            c[4] = temp1;
            c[5] = temp2;
            bgrString = "FF" + new String(c);
        } else {
            System.err.println("JavaRendererUtilties.ARGBtoABGR(): \"" + String.valueOf(rgbString) + "\" is not a 6 or 8 character String in the format of RRGGBB or AARRGGBB");
        }
        return bgrString;
    }

    public static String normalizeSymbolCode(String symbolCode) {
        Object newSymbolCode = symbolCode;
        if (symbolCode.startsWith("G") || symbolCode.startsWith("S")) {
            newSymbolCode = ((String)newSymbolCode).substring(0, 1) + "*" + ((String)newSymbolCode).substring(2);
            newSymbolCode = ((String)newSymbolCode).substring(0, 3) + "*" + ((String)newSymbolCode).substring(4);
            newSymbolCode = ((String)newSymbolCode).substring(0, 10) + "****" + ((String)newSymbolCode).substring(14);
        }
        if (symbolCode.startsWith("S")) {
            newSymbolCode = ((String)newSymbolCode).substring(0, 14) + "*";
        }
        return newSymbolCode;
    }

    public static void addAltModeToModifiersString(Map<String, String> attributes, String altMode) {
        if (altMode.equals("relativeToGround")) {
            attributes.put("ALTITUDEMODE", "AGL");
        } else if (altMode.equals("absolute")) {
            attributes.put("ALTITUDEMODE", "AMSL");
        }
    }

    public static Map<String, String> createParameterMapFromURL(String SymbolInfo2) {
        HashMap<String, String> modifiers = new HashMap<String, String>();
        String symbolID = null;
        String parameters = null;
        String key = null;
        String value = null;
        String[] arrParameters = null;
        String[] arrKeyValue = null;
        String temp = null;
        int questionIndex = SymbolInfo2.lastIndexOf(63);
        try {
            symbolID = questionIndex == -1 ? URLDecoder.decode(SymbolInfo2, "UTF-8") : URLDecoder.decode(SymbolInfo2.substring(0, questionIndex), "UTF-8");
        }
        catch (Exception exc) {
            System.err.println("Error parsing SymbolID");
            System.err.println(exc.getMessage());
        }
        try {
            if (questionIndex > 0 && questionIndex + 1 < SymbolInfo2.length()) {
                parameters = SymbolInfo2.substring(questionIndex + 1, SymbolInfo2.length());
                arrParameters = parameters.split("&");
                int n = arrParameters.length;
                for (int i = 0; i < n; ++i) {
                    arrKeyValue = arrParameters[i].split("=");
                    if (arrKeyValue.length != 2 || arrKeyValue[1] == null || arrKeyValue[1].equals("")) continue;
                    key = arrKeyValue[0];
                    value = arrKeyValue[1];
                    temp = URLDecoder.decode(value, "UTF-8");
                    modifiers.put(key.toUpperCase(), temp);
                }
            }
        }
        catch (Exception exc) {
            System.err.println("Error parsing \"" + key.toUpperCase() + "\" parameter from URL");
            System.err.println(exc.getMessage());
        }
        return modifiers;
    }

    public static boolean is3dSymbol(String symbolCode, Map<String, String> modifiers) {
        boolean returnValue;
        block5: {
            returnValue = false;
            try {
                String symbolId = symbolCode.substring(4, 10);
                if (!symbolId.equals("ACAI--") && !symbolId.equals("ACAR--") && !symbolId.equals("ACAC--") && !symbolId.equals("AKPC--") && !symbolId.equals("AKPR--") && !symbolId.equals("AKPI--") && !symbolId.equals("ALC---") && !symbolId.equals("ALM---") && !symbolId.equals("ALS---") && !symbolId.equals("ALU---") && !symbolId.equals("ALL---") && !symbolId.equals("AAR---") && !symbolId.equals("AAF---") && !symbolId.equals("AAH---") && !symbolId.equals("AAM---") && !symbolId.equals("AAML--") && !symbolId.equals("AAMH--")) break block5;
                try {
                    if (modifiers == null || !modifiers.containsKey("X_ALTITUDE_DEPTH")) break block5;
                    String[] altitudes = modifiers.get("X_ALTITUDE_DEPTH").split(",");
                    if (altitudes.length < 2) {
                        returnValue = false;
                        break block5;
                    }
                    returnValue = true;
                }
                catch (Exception exc) {
                    System.err.println(exc.getMessage());
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        return returnValue;
    }

    public static boolean isNumber(String text) {
        return text != null && text.matches("((-|\\+)?[0-9]+(\\.[0-9]+)?)+");
    }

    public static String getStackTrace(Throwable thrown) {
        try {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            thrown.printStackTrace(printWriter);
            return ((Object)writer).toString();
        }
        catch (Exception exc) {
            return "";
        }
    }

    public static Point2D getEndPointWithAngle(Point2D ptStart, double angle, double distance) {
        double newX = 0.0;
        double newY = 0.0;
        Point2D.Double pt = new Point2D.Double();
        try {
            double psi = 0.0;
            double alpha1 = Math.PI * angle / 180.0;
            double theta = psi + alpha1;
            double dx = distance * Math.cos(theta);
            double dy = distance * Math.sin(theta);
            newX = ptStart.getX() + dx;
            newY = ptStart.getY() + dy;
            ((Point2D)pt).setLocation(newX, newY);
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        return pt;
    }

    public static double measureDistance(double latitude1, double longitude1, double latitude2, double longitude2, String unitOfMeasure) {
        double rad;
        double distance = -1.0;
        String uom = unitOfMeasure.toLowerCase();
        if (uom.equals("meters")) {
            rad = 6378137.0;
        } else if (uom.equals("kilometers")) {
            rad = 6378.137;
        } else if (uom.equals("miles")) {
            rad = 3963.1;
        } else if (uom.equals("feet")) {
            rad = 2.09255249E7;
        } else if (uom.equals("yards")) {
            rad = 6975174.98;
        } else if (uom.equals("nautical")) {
            rad = 3443.9;
        } else if (uom.equals("nautical miles")) {
            rad = 3443.9;
        } else {
            return -1.0;
        }
        distance = Math.acos(Math.cos(latitude1 *= Math.PI / 180) * Math.cos(longitude1 *= Math.PI / 180) * Math.cos(latitude2 *= Math.PI / 180) * Math.cos(longitude2 *= Math.PI / 180) + Math.cos(latitude1) * Math.sin(longitude1) * Math.cos(latitude2) * Math.sin(longitude2) + Math.sin(latitude1) * Math.sin(latitude2)) * rad;
        return distance;
    }
}

