/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer;

import armyc2.c5isr.renderer.ModifierRenderer;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.MSInfo;
import armyc2.c5isr.renderer.utilities.MSLookup;
import armyc2.c5isr.renderer.utilities.RectUtilities;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.RendererUtilities;
import armyc2.c5isr.renderer.utilities.SVGInfo;
import armyc2.c5isr.renderer.utilities.SVGLookup;
import armyc2.c5isr.renderer.utilities.SVGSymbolInfo;
import armyc2.c5isr.renderer.utilities.ShapeUtilities;
import armyc2.c5isr.renderer.utilities.SymbolDimensionInfo;
import armyc2.c5isr.renderer.utilities.SymbolID;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class SinglePointSVGRenderer {
    private final String TAG = "SinglePointSVGRenderer";
    private static SinglePointSVGRenderer _instance = null;
    public static final String RENDERER_ID = "2525D";
    private BufferedImage _buffer = null;
    private FontRenderContext _fontRenderContext = null;

    private void init() {
        try {
            SVGLookup.getInstance();
            ModifierRenderer.getInstance();
            if (this._buffer == null) {
                this._buffer = new BufferedImage(8, 8, 2);
                Graphics2D g2d = this._buffer.createGraphics();
                this._fontRenderContext = g2d.getFontRenderContext();
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SinglePointRenderer", "init", exc);
        }
    }

    public static synchronized SinglePointSVGRenderer getInstance() {
        if (_instance == null) {
            _instance = new SinglePointSVGRenderer();
            _instance.init();
        }
        return _instance;
    }

    public SVGSymbolInfo render(String symbolID, Map<String, String> modifiers, Map<String, String> attributes) {
        SVGSymbolInfo si = null;
        if (modifiers == null) {
            modifiers = new HashMap<String, String>();
        }
        si = SymbolID.getSymbolSet(symbolID) == 25 || SymbolID.getSymbolSet(symbolID) == 45 || SymbolID.getSymbolSet(symbolID) == 46 || SymbolID.getSymbolSet(symbolID) == 47 ? this.RenderSP(symbolID, modifiers, attributes) : this.RenderUnit(symbolID, modifiers, attributes);
        return si;
    }

    public SVGSymbolInfo RenderUnit(String symbolID, Map<String, String> modifiers, Map<String, String> attributes) {
        Object ii = null;
        SVGSymbolInfo si = null;
        SymbolDimensionInfo newSDI = null;
        try {
            String lineColor = null;
            String fillColor = null;
            if (SymbolID.getSymbolSet(symbolID) == 36 && RendererSettings.getInstance().getSeaMineRenderMethod() == 1) {
                lineColor = RendererUtilities.colorToHexString(SymbolUtilities.getLineColorOfAffiliation(symbolID), false);
                fillColor = RendererUtilities.colorToHexString(SymbolUtilities.getFillColorOfAffiliation(symbolID), true);
            }
            String iconColor = null;
            float alpha = -1.0f;
            String frameID = null;
            String iconID = null;
            String mod1ID = null;
            String mod2ID = null;
            SVGInfo siFrame = null;
            SVGInfo siIcon = null;
            SVGInfo siMod1 = null;
            SVGInfo siMod2 = null;
            int top = 0;
            int left = 0;
            int width = 0;
            int height = 0;
            String svgStart = null;
            Object strSVG = null;
            String strSVGFrame = null;
            Rectangle2D symbolBounds = null;
            Object fullBounds = null;
            Object fullBMP = null;
            boolean hasDisplayModifiers = false;
            boolean hasTextModifiers = false;
            int pixelSize = 50;
            boolean keepUnitRatio = true;
            double scale = 1.0;
            boolean icon = false;
            boolean asIcon = false;
            boolean noFrame = false;
            int ver = SymbolID.getVersion(symbolID);
            if (modifiers != null) {
                if (attributes.containsKey("PIXELSIZE")) {
                    pixelSize = Integer.valueOf(attributes.get("PIXELSIZE"));
                }
                if (attributes.containsKey("LINECOLOR")) {
                    lineColor = attributes.get("LINECOLOR");
                }
                if (attributes.containsKey("FILLCOLOR")) {
                    fillColor = attributes.get("FILLCOLOR");
                }
                if (attributes.containsKey("ICONCOLOR")) {
                    iconColor = attributes.get("ICONCOLOR");
                }
                if (attributes.containsKey("DRAWASICON")) {
                    asIcon = Boolean.parseBoolean(attributes.get("DRAWASICON"));
                }
                if (attributes.containsKey("KEEPUNITRATIO")) {
                    keepUnitRatio = Boolean.valueOf(attributes.get("KEEPUNITRATIO"));
                }
            }
            try {
                pixelSize = attributes.containsKey("PIXELSIZE") ? Integer.parseInt(attributes.get("PIXELSIZE")) : RendererSettings.getInstance().getDefaultPixelSize();
                if (attributes.containsKey("KEEPUNITRATIO")) {
                    keepUnitRatio = Boolean.parseBoolean(attributes.get("KEEPUNITRATIO"));
                }
                if (attributes.containsKey("DRAWASICON")) {
                    icon = Boolean.parseBoolean(attributes.get("DRAWASICON"));
                }
                if (icon) {
                    keepUnitRatio = false;
                    hasDisplayModifiers = false;
                    hasTextModifiers = false;
                } else {
                    hasDisplayModifiers = ModifierRenderer.hasDisplayModifiers(symbolID, modifiers);
                    hasTextModifiers = ModifierRenderer.hasTextModifiers(symbolID, modifiers);
                }
                if (attributes.containsKey("LINECOLOR")) {
                    lineColor = attributes.get("LINECOLOR");
                }
                if (attributes.containsKey("FILLCOLOR")) {
                    fillColor = attributes.get("FILLCOLOR");
                }
                if (attributes.containsKey("ALPHA")) {
                    alpha = Float.parseFloat(attributes.get("ALPHA"));
                }
            }
            catch (Exception excModifiers) {
                ErrorLogger.LogException("MilStdIconRenderer", "RenderUnit", excModifiers);
            }
            String key = SinglePointSVGRenderer.makeCacheKey(symbolID, lineColor, fillColor, pixelSize, keepUnitRatio, false);
            if (ii == null) {
                int version = SymbolID.getVersion(symbolID);
                frameID = SVGLookup.getFrameID(symbolID);
                iconID = SVGLookup.getMainIconID(symbolID);
                mod1ID = SVGLookup.getMod1ID(symbolID);
                mod2ID = SVGLookup.getMod2ID(symbolID);
                siFrame = SVGLookup.getInstance().getSVGLInfo(frameID, version);
                siIcon = SVGLookup.getInstance().getSVGLInfo(iconID, version);
                if (siFrame == null) {
                    frameID = SVGLookup.getFrameID(SymbolUtilities.reconcileSymbolID(symbolID));
                    siFrame = SVGLookup.getInstance().getSVGLInfo(frameID, version);
                    if (siFrame == null) {
                        frameID = SVGLookup.getFrameID(SymbolID.setSymbolSet(symbolID, 0));
                        siFrame = SVGLookup.getInstance().getSVGLInfo(frameID, version);
                    }
                }
                if (siIcon == null) {
                    if (!iconID.substring(2, 8).equals("000000") && MSLookup.getInstance().getMSLInfo(symbolID) == null) {
                        siIcon = SVGLookup.getInstance().getSVGLInfo("98100000", version);
                    } else if (SymbolID.getSymbolSet(symbolID) == 0) {
                        siIcon = SVGLookup.getInstance().getSVGLInfo("00000000", version);
                    }
                }
                if (RendererSettings.getInstance().getScaleMainIcon()) {
                    siIcon = RendererUtilities.scaleIcon(symbolID, siIcon);
                }
                siMod1 = SVGLookup.getInstance().getSVGLInfo(mod1ID, version);
                siMod2 = SVGLookup.getInstance().getSVGLInfo(mod2ID, version);
                top = (int)Math.round(siFrame.getBbox().getY());
                left = (int)Math.round(siFrame.getBbox().getX());
                width = (int)Math.round(siFrame.getBbox().getWidth());
                height = (int)Math.round(siFrame.getBbox().getHeight());
                strSVGFrame = lineColor != null || fillColor != null ? RendererUtilities.setSVGFrameColors(symbolID, siFrame.getSVG(), RendererUtilities.getColorFromHexString(lineColor), RendererUtilities.getColorFromHexString(fillColor)) : siFrame.getSVG();
                if (frameID.equals("octagon")) {
                    noFrame = true;
                    strSVGFrame = strSVGFrame.replaceFirst("<g id=\"octagon\">", "<g id=\"octagon\" display=\"none\">");
                }
                symbolBounds = RectUtilities.toRectangle(left, top, width, height);
                Rectangle2D rect = RectUtilities.copyRect(symbolBounds);
                float ratio = -1.0f;
                if (pixelSize > 0 && keepUnitRatio) {
                    float heightRatio = SymbolUtilities.getUnitRatioHeight(symbolID);
                    float widthRatio = SymbolUtilities.getUnitRatioWidth(symbolID);
                    if (noFrame) {
                        heightRatio = 1.0f;
                        widthRatio = 1.0f;
                    }
                    pixelSize = heightRatio > widthRatio ? (int)((float)pixelSize / 1.5f * heightRatio) : (int)((float)pixelSize / 1.5f * widthRatio);
                }
                if (pixelSize > 0) {
                    float p = pixelSize;
                    float h = (float)rect.getHeight();
                    float w = (float)rect.getWidth();
                    ratio = Math.min(p / h, p / w);
                    symbolBounds = RectUtilities.makeRectangle2DFromRect(0.0f, 0.0f, w * ratio, h * ratio);
                }
                String sbGroupUnit = "";
                if (siFrame != null) {
                    sbGroupUnit = sbGroupUnit + "<g transform=\"translate(" + siFrame.getBbox().getX() * (double)(-ratio) + ',' + siFrame.getBbox().getY() * (double)(-ratio) + ") scale(" + ratio + "," + ratio + ")\">";
                    if (siFrame != null) {
                        sbGroupUnit = sbGroupUnit + strSVGFrame;
                    }
                    String color = "";
                    if (iconColor != null) {
                        if ((iconColor = RendererUtilities.colorToHexString(RendererUtilities.getColorFromHexString(iconColor), false)) != null && iconColor != "#000000" && iconColor != "") {
                            color = " fill=\"" + iconColor + "\" ";
                        } else {
                            iconColor = null;
                        }
                    }
                    String unit = "<g" + color + ">";
                    if (siIcon != null) {
                        unit = unit + siIcon.getSVG();
                    }
                    if (siMod1 != null) {
                        unit = unit + siMod1.getSVG();
                    }
                    if (siMod2 != null) {
                        unit = unit + siMod2.getSVG();
                    }
                    if (iconColor != null) {
                        unit = unit.replaceAll("#000000", iconColor);
                    }
                    unit = unit + "</g>";
                    sbGroupUnit = sbGroupUnit + unit + "</g>";
                }
                Point centerOctagon = new Point(306, 396);
                centerOctagon.translate(-left, -top);
                Point centerPoint = centerOctagon = new Point((int)((float)centerOctagon.x * ratio), (int)((float)centerOctagon.y * ratio));
                Point centerCache = new Point(centerOctagon.x, centerOctagon.y);
                RectUtilities.shift(symbolBounds, 0, (int)(-symbolBounds.getY()));
                Point2D.Double anchor = new Point2D.Double(symbolBounds.getCenterX(), symbolBounds.getCenterY());
                si = new SVGSymbolInfo(sbGroupUnit.toString(), anchor, symbolBounds, symbolBounds);
                hasDisplayModifiers = ModifierRenderer.hasDisplayModifiers(symbolID, modifiers);
                hasTextModifiers = ModifierRenderer.hasTextModifiers(symbolID, modifiers);
                if (hasDisplayModifiers && (newSDI = ModifierRenderer.processUnitDisplayModifiers(si, symbolID, modifiers, attributes, this._fontRenderContext)) != null) {
                    si = (SVGSymbolInfo)newSDI;
                    newSDI = null;
                }
            }
            if (hasTextModifiers) {
                int ss = SymbolID.getSymbolSet(symbolID);
                switch (ss) {
                    case 10: 
                    case 11: {
                        if (ver >= 13) {
                            newSDI = ModifierRenderer.processLandUnitTextModifiersE(si, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        newSDI = ModifierRenderer.processLandUnitTextModifiers(si, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 15: 
                    case 52: {
                        if (ver >= 13) {
                            newSDI = ModifierRenderer.processLandEquipmentTextModifiersE(si, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        newSDI = ModifierRenderer.processLandEquipmentTextModifiers(si, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 20: {
                        if (ver >= 13) {
                            newSDI = ModifierRenderer.processLandInstallationTextModifiersE(si, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        newSDI = ModifierRenderer.processLandInstallationTextModifiers(si, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 27: {
                        newSDI = ModifierRenderer.processDismountedIndividualsTextModifiers(si, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 51: {
                        if (ver >= 13) {
                            newSDI = ModifierRenderer.processAirSpaceUnitTextModifiersE(si, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        newSDI = ModifierRenderer.processAirSpaceUnitTextModifiers(si, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 50: {
                        if (ver < 13) {
                            newSDI = ModifierRenderer.processAirSpaceUnitTextModifiers(si, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        char frameShape = SymbolID.getFrameShape(symbolID);
                        if (frameShape == '1' || frameShape == '2') {
                            newSDI = ModifierRenderer.processAirSpaceUnitTextModifiersE(si, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        if (frameShape == '4') {
                            newSDI = ModifierRenderer.processLandEquipmentTextModifiersE(si, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        if (frameShape == '7') {
                            newSDI = ModifierRenderer.processSeaSubSurfaceTextModifiersE(si, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        newSDI = ModifierRenderer.processLandEquipmentTextModifiersE(si, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 30: 
                    case 53: {
                        if (ver >= 13) {
                            newSDI = ModifierRenderer.processSeaSurfaceTextModifiersE(si, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        newSDI = ModifierRenderer.processSeaSurfaceTextModifiers(si, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 35: 
                    case 54: {
                        if (ver >= 13) {
                            newSDI = ModifierRenderer.processSeaSubSurfaceTextModifiersE(si, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        newSDI = ModifierRenderer.processSeaSubSurfaceTextModifiers(si, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 40: {
                        if (ver >= 13) {
                            newSDI = ModifierRenderer.processActivitiesTextModifiersE(si, symbolID, modifiers, attributes, this._fontRenderContext);
                            break;
                        }
                        newSDI = ModifierRenderer.processActivitiesTextModifiers(si, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 60: {
                        newSDI = ModifierRenderer.processCyberSpaceTextModifiers(si, symbolID, modifiers, attributes, this._fontRenderContext);
                        break;
                    }
                    case 36: {
                        break;
                    }
                    default: {
                        newSDI = ModifierRenderer.processUnknownTextModifiers(si, symbolID, modifiers, attributes, this._fontRenderContext);
                    }
                }
            }
            if (newSDI != null) {
                si = (SVGSymbolInfo)newSDI;
            }
            newSDI = null;
            int widthOffset = 0;
            if (hasTextModifiers) {
                widthOffset = 2;
            }
            int svgWidth = (int)Math.ceil(si.getImageBounds().getWidth() + (double)widthOffset);
            int svgHeight = (int)Math.ceil(si.getImageBounds().getHeight());
            String svgAlpha = "";
            if (alpha >= 0.0f && alpha <= 255.0f) {
                svgAlpha = " opacity=\"" + alpha / 255.0f + "\"";
            }
            svgStart = "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"" + svgWidth + "\" height=\"" + svgHeight + "\" viewBox=\"" + 0 + " " + 0 + " " + svgWidth + " " + svgHeight + "\"" + svgAlpha + ">\n";
            String svgTranslateGroup = null;
            double transX = si.getImageBounds().getX() * -1.0;
            double transY = si.getImageBounds().getY() * -1.0;
            Point anchor = si.getSymbolCenterPoint();
            Rectangle2D imageBounds = si.getImageBounds();
            if (transX > 0.0 || transY > 0.0) {
                ShapeUtilities.offset((Point2D)anchor, transX, transY);
                ShapeUtilities.offset(symbolBounds, transX, transY);
                ShapeUtilities.offset(imageBounds, transX, transY);
                svgTranslateGroup = "<g transform=\"translate(" + transX + "," + transY + ")\">\n";
            }
            imageBounds.setRect(imageBounds.getX(), imageBounds.getY(), svgWidth, svgHeight);
            si = new SVGSymbolInfo(si.getSVG(), anchor, symbolBounds, imageBounds);
            StringBuilder sbSVG = new StringBuilder();
            sbSVG.append(svgStart);
            sbSVG.append(this.makeDescTag(si));
            sbSVG.append(this.makeMetadataTag(symbolID, si));
            if (svgTranslateGroup != null) {
                sbSVG.append(svgTranslateGroup);
            }
            sbSVG.append(si.getSVG());
            if (svgTranslateGroup != null) {
                sbSVG.append("\n</g>");
            }
            sbSVG.append("\n</svg>");
            si = new SVGSymbolInfo(sbSVG.toString(), anchor, symbolBounds, imageBounds);
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SinglePointRenderer", "renderUnit", exc);
        }
        return si;
    }

    public SVGSymbolInfo RenderSP(String symbolID, Map<String, String> modifiers, Map<String, String> attributes) {
        SVGSymbolInfo si = null;
        int pixelSize = 50;
        double scale = 1.0;
        String lineColor = null;
        String fillColor = null;
        float alpha = -1.0f;
        boolean keepUnitRatio = true;
        boolean asIcon = false;
        boolean hasDisplayModifiers = false;
        boolean hasTextModifiers = false;
        boolean outlineSymbol = false;
        MSInfo msi = null;
        String iconID = null;
        SVGInfo siIcon = null;
        String mod1ID = null;
        SVGInfo siMod1 = null;
        int top = 0;
        int left = 0;
        int width = 0;
        int height = 0;
        String svgStart = null;
        Object strSVG = null;
        double ratio = 0.0;
        Rectangle symbolBounds = null;
        Object fullBounds = null;
        Object fullBMP = null;
        Object ii = null;
        try {
            msi = MSLookup.getInstance().getMSLInfo(symbolID);
            int ss = SymbolID.getSymbolSet(symbolID);
            int ec = SymbolID.getEntityCode(symbolID);
            int mod1 = 0;
            int drawRule = 0;
            boolean hasAPFill = false;
            if (msi != null) {
                drawRule = msi.getDrawRule();
            }
            if (RendererSettings.getInstance().getActionPointDefaultFill() && (SymbolUtilities.isActionPoint(symbolID) || drawRule == 210 || ec == 180100 || ec == 180200 || ec == 180400) && SymbolID.getSymbolSet(symbolID) == 25) {
                lineColor = "#000000";
                hasAPFill = true;
            }
            if (lineColor == null) {
                lineColor = RendererUtilities.colorToHexString(SymbolUtilities.getDefaultLineColor(symbolID), false);
            }
            if (attributes != null) {
                if (attributes.containsKey("PIXELSIZE")) {
                    pixelSize = Integer.valueOf(attributes.get("PIXELSIZE"));
                }
                if (attributes.containsKey("LINECOLOR")) {
                    lineColor = attributes.get("LINECOLOR");
                }
                if (attributes.containsKey("FILLCOLOR")) {
                    fillColor = attributes.get("FILLCOLOR");
                }
                if (attributes.containsKey("ALPHA")) {
                    alpha = Integer.parseInt(attributes.get("ALPHA"));
                }
                if (attributes.containsKey("DRAWASICON")) {
                    asIcon = Boolean.parseBoolean(attributes.get("DRAWASICON"));
                }
                if (attributes.containsKey("KEEPUNITRATIO")) {
                    keepUnitRatio = Boolean.parseBoolean(attributes.get("KEEPUNITRATIO"));
                }
                if (!asIcon && !hasAPFill) {
                    outlineSymbol = attributes.containsKey("OUTLINESYMBOL") ? Boolean.parseBoolean(attributes.get("OUTLINESYMBOL")) : RendererSettings.getInstance().getOutlineSPControlMeasures();
                }
                if (SymbolUtilities.isMultiPoint(symbolID)) {
                    outlineSymbol = false;
                }
            }
            if (keepUnitRatio) {
                pixelSize = msi.getDrawRule() == 201 ? (int)Math.ceil((float)pixelSize / 1.5f * 2.0f) : (int)Math.ceil((float)pixelSize / 1.5f * 1.2f);
            }
            if (ss == 25 && ec == 270701 && ((mod1 = SymbolID.getModifier1(symbolID)) < 13 || mod1 > 50)) {
                symbolID = SymbolID.setModifier1(symbolID, 13);
            }
            if (si == null) {
                int version = SymbolID.getVersion(symbolID);
                Rectangle2D rect = null;
                iconID = SVGLookup.getMainIconID(symbolID);
                siIcon = SVGLookup.getInstance().getSVGLInfo(iconID, version);
                mod1ID = SVGLookup.getMod1ID(symbolID);
                siMod1 = SVGLookup.getInstance().getSVGLInfo(mod1ID, version);
                float borderPadding = 0.0f;
                if (outlineSymbol) {
                    borderPadding = RendererUtilities.findWidestStrokeWidth(siIcon.getSVG());
                }
                top = (int)Math.round(siIcon.getBbox().getY());
                left = (int)Math.round(siIcon.getBbox().getX());
                width = (int)Math.round(siIcon.getBbox().getWidth());
                height = (int)Math.round(siIcon.getBbox().getHeight());
                String strSVGIcon = null;
                if (hasAPFill) {
                    String apFill = fillColor != null ? fillColor : RendererUtilities.colorToHexString(SymbolUtilities.getFillColorOfAffiliation(symbolID), false);
                    siIcon = new SVGInfo(siIcon.getID(), siIcon.getBbox(), siIcon.getSVG().replaceAll("fill=\"none\"", "fill=\"" + apFill + "\""));
                }
                if (msi.getSymbolSet() == 25 && (lineColor != null || fillColor != null)) {
                    strSVGIcon = outlineSymbol ? RendererUtilities.setSVGSPCMColors(symbolID, siIcon.getSVG(), RendererUtilities.getIdealOutlineColor(RendererUtilities.getColorFromHexString(lineColor)), RendererUtilities.getColorFromHexString(fillColor), true) : "";
                    strSVGIcon = strSVGIcon + RendererUtilities.setSVGSPCMColors(symbolID, siIcon.getSVG(), RendererUtilities.getColorFromHexString(lineColor), RendererUtilities.getColorFromHexString(fillColor), false);
                } else {
                    strSVGIcon = siIcon.getSVG();
                }
                if (SymbolID.getEntityCode(symbolID) == 270701 && siMod1 != null) {
                    if (outlineSymbol) {
                        strSVGIcon = strSVGIcon + RendererUtilities.setSVGSPCMColors(mod1ID, siMod1.getSVG(), RendererUtilities.getIdealOutlineColor(RendererUtilities.getColorFromHexString("#00A651")), RendererUtilities.getColorFromHexString("#00A651"), true);
                    }
                    strSVGIcon = strSVGIcon + RendererUtilities.setSVGSPCMColors(mod1ID, siMod1.getSVG(), RendererUtilities.getColorFromHexString(lineColor), RendererUtilities.getColorFromHexString(fillColor), false);
                }
                if (pixelSize > 0) {
                    symbolBounds = RectUtilities.toRectangle(left, top, width, height);
                    rect = RectUtilities.copyRect(symbolBounds);
                    float p = pixelSize;
                    double h = rect.getHeight();
                    double w = rect.getWidth();
                    ratio = Math.min((double)p / h, (double)p / w);
                    symbolBounds = RectUtilities.toRectangle(0.0, 0.0, w * ratio, h * ratio);
                    w = ((RectangularShape)symbolBounds).getWidth();
                    h = ((RectangularShape)symbolBounds).getHeight();
                    if ((double)borderPadding > h * 0.1) {
                        borderPadding = (float)(h * 0.1);
                    } else if ((double)borderPadding > w * 0.1) {
                        borderPadding = (float)(w * 0.1);
                    }
                }
                Rectangle borderPaddingBounds = null;
                int offset = 0;
                if (msi.getSymbolSet() == 25 && outlineSymbol && borderPadding != 0.0f) {
                    symbolBounds = borderPaddingBounds = RectUtilities.toRectangle(0.0, 0.0, (rect.getWidth() + (double)borderPadding) * ratio, (rect.getHeight() + (double)borderPadding) * ratio);
                    offset = (int)borderPadding / 2;
                    RectUtilities.grow(rect, offset);
                }
                String strLineJoin = "";
                if (msi.getSymbolSet() == 25 && msi.getDrawRule() == 201) {
                    strLineJoin = " stroke-linejoin=\"round\" ";
                }
                StringBuilder sbGroupUnit = new StringBuilder();
                if (siIcon != null) {
                    sbGroupUnit.append("<g transform=\"translate(" + rect.getX() * -ratio + ',' + rect.getY() * -ratio + ") scale(" + ratio + "," + ratio + ")\"" + strLineJoin + ">");
                    sbGroupUnit.append(strSVGIcon);
                    sbGroupUnit.append("</g>");
                }
                Point centerPoint = SymbolUtilities.getCMSymbolAnchorPoint(symbolID, RectUtilities.makeRectangle2DFromRect(0.0, 0.0, ((RectangularShape)symbolBounds).getWidth(), ((RectangularShape)symbolBounds).getHeight()));
                if (borderPaddingBounds != null) {
                    RectUtilities.grow(symbolBounds, 4);
                }
                si = new SVGSymbolInfo(sbGroupUnit.toString(), centerPoint, symbolBounds, symbolBounds);
            }
            SVGSymbolInfo siNew = null;
            hasDisplayModifiers = ModifierRenderer.hasDisplayModifiers(symbolID, modifiers);
            hasTextModifiers = ModifierRenderer.hasTextModifiers(symbolID, modifiers);
            if (SymbolUtilities.isMultiPoint(symbolID)) {
                hasTextModifiers = false;
                hasDisplayModifiers = false;
            }
            if (!asIcon && (hasTextModifiers || hasDisplayModifiers)) {
                SymbolDimensionInfo sdiTemp = null;
                Color cLineColor = RendererUtilities.getColorFromHexString(lineColor);
                sdiTemp = SymbolUtilities.isSPWithSpecialModifierLayout(symbolID) ? ModifierRenderer.ProcessTGSPWithSpecialModifierLayout(si, symbolID, modifiers, attributes, cLineColor, this._fontRenderContext) : ModifierRenderer.ProcessTGSPModifiers(si, symbolID, modifiers, attributes, cLineColor, this._fontRenderContext);
                SVGSymbolInfo sVGSymbolInfo = siNew = sdiTemp instanceof SVGSymbolInfo ? (SVGSymbolInfo)sdiTemp : null;
            }
            if (siNew != null) {
                si = siNew;
            }
            siNew = null;
            String svgAlpha = "";
            if (alpha >= 0.0f && alpha <= 255.0f) {
                svgAlpha = " opacity=\"" + alpha / 255.0f + "\"";
            }
            svgStart = "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"" + (int)si.getImageBounds().getWidth() + "\" height=\"" + (int)si.getImageBounds().getHeight() + "\" viewBox=\"" + 0 + " " + 0 + " " + (int)si.getImageBounds().getWidth() + " " + (int)si.getImageBounds().getHeight() + "\"" + svgAlpha + ">\n";
            String svgTranslateGroup = null;
            double transX = si.getImageBounds().getX() * -1.0;
            double transY = si.getImageBounds().getY() * -1.0;
            Point anchor = si.getSymbolCenterPoint();
            Rectangle2D imageBounds = si.getImageBounds();
            if (transX > 0.0 || transY > 0.0) {
                ShapeUtilities.offset((Point2D)anchor, transX, transY);
                ShapeUtilities.offset((Rectangle2D)symbolBounds, transX, transY);
                ShapeUtilities.offset(imageBounds, transX, transY);
                svgTranslateGroup = "<g transform=\"translate(" + transX + "," + transY + ")\">\n";
            }
            si = new SVGSymbolInfo(si.getSVG(), anchor, symbolBounds, imageBounds);
            StringBuilder sbSVG = new StringBuilder();
            sbSVG.append(svgStart);
            sbSVG.append(this.makeDescTag(si));
            sbSVG.append(this.makeMetadataTag(symbolID, si));
            if (svgTranslateGroup != null) {
                sbSVG.append(svgTranslateGroup);
            }
            sbSVG.append(si.getSVG());
            if (svgTranslateGroup != null) {
                sbSVG.append("\n</g>");
            }
            sbSVG.append("\n</svg>");
            si = new SVGSymbolInfo(sbSVG.toString(), anchor, symbolBounds, imageBounds);
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdIconRenderer", "RenderSP", exc);
            return null;
        }
        return si;
    }

    private String makeDynamicSVG() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Object svgStart = null;
        pw.println("<svg width=\"35\" height=\"35\" style=\"fill:none;stroke-width:16\">");
        pw.println("</svg>");
        pw.close();
        return sw.toString();
    }

    private String makeDescTag(SVGSymbolInfo si) {
        StringBuilder sbDesc = new StringBuilder();
        if (si != null) {
            Rectangle2D bounds = si.getSymbolBounds();
            Rectangle2D iBounds = si.getImageBounds();
            sbDesc.append("<desc>").append(si.getSymbolCenterX()).append(" ").append(si.getSymbolCenterY()).append(" ");
            sbDesc.append(bounds.getX()).append(" ").append(bounds.getY()).append(" ").append(bounds.getWidth()).append(" ").append(bounds.getHeight()).append(" ");
            sbDesc.append(iBounds.getX()).append(" ").append(iBounds.getY()).append(" ").append(iBounds.getWidth()).append(" ").append(iBounds.getHeight());
            sbDesc.append("</desc>\n");
        }
        return sbDesc.toString();
    }

    private String makeMetadataTag(String symbolID, SVGSymbolInfo si) {
        StringBuilder sbDesc = new StringBuilder();
        if (si != null) {
            Rectangle2D bounds = si.getSymbolBounds();
            Rectangle2D iBounds = si.getImageBounds();
            sbDesc.append("<metadata>\n");
            sbDesc.append("<symbolID>").append(symbolID).append("</symbolID>\n");
            sbDesc.append("<anchor>").append(si.getSymbolCenterX()).append(" ").append(si.getSymbolCenterY()).append("</anchor>\n");
            sbDesc.append("<symbolBounds>").append(bounds.getX()).append(" ").append(bounds.getY()).append(" ").append(bounds.getWidth()).append(" ").append(bounds.getHeight()).append("</symbolBounds>\n");
            sbDesc.append("<imageBounds>").append(iBounds.getX()).append(" ").append(iBounds.getY()).append(" ").append(iBounds.getWidth()).append(" ").append(iBounds.getHeight()).append("</imageBounds>\n");
            sbDesc.append("</metadata>\n");
        }
        return sbDesc.toString();
    }

    private String getSVGString(String symbolID, boolean isOutline) {
        int version = SymbolID.getVersion(symbolID);
        SVGInfo svgi = SVGLookup.getInstance().getSVGLInfo(SymbolUtilities.getBasicSymbolID(symbolID), version);
        String strSVG = svgi.getSVG();
        if (isOutline) {
            strSVG = strSVG.replaceFirst("<g id=\"" + SymbolUtilities.getBasicSymbolID(symbolID) + "\">", "<g id=\"" + SymbolUtilities.getBasicSymbolID(symbolID) + "_outline\">");
        }
        String svgStart = null;
        svgStart = svgi.getBbox().getMaxY() > 400.0 ? "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 612 792\">" : "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 400 400\">";
        strSVG = svgStart + strSVG + "</svg>";
        return strSVG;
    }

    private static String makeCacheKey(String symbolID, String lineColor, String fillColor, int size, boolean keepUnitRatio, boolean drawOutline) {
        String key = symbolID.substring(0, 7) + symbolID.substring(10, 20) + SymbolID.getFrameShape(symbolID) + lineColor + fillColor + size + keepUnitRatio + drawOutline;
        return key;
    }
}

