/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.MSInfo;
import armyc2.c5isr.renderer.utilities.Modifiers;
import armyc2.c5isr.renderer.utilities.SymbolID;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class MSLookup {
    private static MSLookup _instance = null;
    private static Boolean _initCalled = false;
    private static Map<String, MSInfo> _MSLookupD = null;
    private static Map<String, MSInfo> _MSLookupE = null;
    private String TAG = "MSLookup";
    private List<String> _IDListD = null;
    private List<String> _IDListE = null;

    private MSLookup() {
        this.init();
    }

    public static synchronized MSLookup getInstance() {
        if (_instance == null) {
            _instance = new MSLookup();
        }
        return _instance;
    }

    private synchronized void init() {
        if (!_initCalled.booleanValue()) {
            _MSLookupD = new HashMap<String, MSInfo>();
            _MSLookupE = new HashMap<String, MSInfo>();
            this._IDListD = new ArrayList<String>();
            this._IDListE = new ArrayList<String>();
            try {
                InputStream isD = this.getClass().getClassLoader().getResourceAsStream("data/msd.txt");
                InputStream isE = this.getClass().getClassLoader().getResourceAsStream("data/mse.txt");
                BufferedReader brD = new BufferedReader(new InputStreamReader(isD, "UTF8"));
                this.populateLookup(brD, 11);
                brD.close();
                BufferedReader brE = new BufferedReader(new InputStreamReader(isE, "UTF8"));
                this.populateLookup(brE, 13);
                brE.close();
                _initCalled = true;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void populateLookup(BufferedReader br, int version) {
        String[] temp = null;
        String delimiter = "\t";
        try {
            List<String> list;
            Map<String, MSInfo> lookup;
            if (version >= 13) {
                lookup = _MSLookupE;
                list = this._IDListE;
            } else {
                lookup = _MSLookupD;
                list = this._IDListD;
            }
            String id = null;
            String ss = null;
            String e = null;
            String et = null;
            String est = null;
            String ec = null;
            String g = null;
            String dr = null;
            String m = null;
            String[] modifiers = null;
            String line = br.readLine();
            while (line != null) {
                temp = line.split(delimiter);
                ec = temp.length < 5 ? "000000" : temp[4];
                if (ec.equals("0")) {
                    ec = "000000";
                }
                est = temp.length < 4 ? "" : temp[3];
                if (temp.length < 3) {
                    et = "";
                } else if (est.equals("")) {
                    et = temp[2];
                }
                if (temp.length < 2) {
                    e = "";
                } else if (et.equals("")) {
                    e = temp[1];
                }
                if (!temp[0].equals("")) {
                    ss = temp[0];
                }
                id = ss + ec;
                if (!ec.equals("000000")) {
                    if (temp.length >= 7) {
                        if (temp.length >= 8) {
                            m = temp[7];
                            modifiers = m != null && !m.equals("") ? m.split(",") : null;
                        }
                        g = temp[5];
                        dr = temp[6];
                        lookup.put(id, new MSInfo(version, ss, e, et, est, ec, g, dr, this.populateModifierList(modifiers)));
                    } else {
                        lookup.put(id, new MSInfo(version, ss, e, et, est, ec, this.populateModifierList(ss, ec, version)));
                    }
                    list.add(id);
                }
                modifiers = null;
                line = br.readLine();
            }
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
        }
    }

    private ArrayList<String> populateModifierList(String[] modifiers) {
        ArrayList<String> mods = new ArrayList<String>();
        if (modifiers != null && modifiers.length > 0) {
            for (String mod : modifiers) {
                mods.add(Modifiers.getModifierKey(mod));
            }
        }
        return mods;
    }

    private ArrayList<String> populateModifierList(String symbolSet, String ec, int version) {
        ArrayList<String> modifiers;
        int ss;
        block34: {
            block33: {
                ss = Integer.valueOf(symbolSet);
                modifiers = new ArrayList<String>();
                if (version < 13) break block33;
                switch (ss) {
                    case 10: 
                    case 11: {
                        modifiers.add("A_SYMBOL_ICON");
                        modifiers.add("B_ECHELON");
                        modifiers.add("D_TASK_FORCE_INDICATOR");
                        modifiers.add("F_REINFORCED_REDUCED");
                        modifiers.add("G_STAFF_COMMENTS");
                        modifiers.add("H_ADDITIONAL_INFO_1");
                        modifiers.add("J_EVALUATION_RATING");
                        modifiers.add("K_COMBAT_EFFECTIVENESS");
                        modifiers.add("L_SIGNATURE_EQUIP");
                        modifiers.add("M_HIGHER_FORMATION");
                        modifiers.add("P_IFF_SIF_AIS");
                        modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                        modifiers.add("S_HQ_STAFF_INDICATOR");
                        modifiers.add("T_UNIQUE_DESIGNATION_1");
                        modifiers.add("W_DTG_1");
                        modifiers.add("X_ALTITUDE_DEPTH");
                        modifiers.add("Y_LOCATION");
                        modifiers.add("Z_SPEED");
                        if (ss == 10 && ec.equals("110000")) {
                            modifiers.add("AA_SPECIAL_C2_HQ");
                        }
                        modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                        modifiers.add("AD_PLATFORM_TYPE");
                        modifiers.add("AE_EQUIPMENT_TEARDOWN_TIME");
                        modifiers.add("AF_COMMON_IDENTIFIER");
                        modifiers.add("AH_AREA_OF_UNCERTAINTY");
                        modifiers.add("AI_DEAD_RECKONING_TRAILER");
                        modifiers.add("AJ_SPEED_LEADER");
                        modifiers.add("AK_PAIRING_LINE");
                        modifiers.add("AL_OPERATIONAL_CONDITION");
                        modifiers.add("AO_ENGAGEMENT_BAR");
                        modifiers.add("AQ_GUARDED_UNIT");
                        modifiers.add("AS_COUNTRY");
                        break;
                    }
                    case 15: 
                    case 50: {
                        modifiers.add("A_SYMBOL_ICON");
                        modifiers.add("C_QUANTITY");
                        modifiers.add("G_STAFF_COMMENTS");
                        modifiers.add("H_ADDITIONAL_INFO_1");
                        modifiers.add("J_EVALUATION_RATING");
                        modifiers.add("K_COMBAT_EFFECTIVENESS");
                        modifiers.add("L_SIGNATURE_EQUIP");
                        modifiers.add("M_HIGHER_FORMATION");
                        modifiers.add("N_HOSTILE");
                        modifiers.add("P_IFF_SIF_AIS");
                        modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                        modifiers.add("R_MOBILITY_INDICATOR");
                        modifiers.add("T_UNIQUE_DESIGNATION_1");
                        modifiers.add("V_EQUIP_TYPE");
                        modifiers.add("W_DTG_1");
                        modifiers.add("X_ALTITUDE_DEPTH");
                        modifiers.add("Y_LOCATION");
                        modifiers.add("Z_SPEED");
                        modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                        modifiers.add("AD_PLATFORM_TYPE");
                        modifiers.add("AE_EQUIPMENT_TEARDOWN_TIME");
                        modifiers.add("AF_COMMON_IDENTIFIER");
                        modifiers.add("AG_AUX_EQUIP_INDICATOR");
                        modifiers.add("AH_AREA_OF_UNCERTAINTY");
                        modifiers.add("AI_DEAD_RECKONING_TRAILER");
                        modifiers.add("AJ_SPEED_LEADER");
                        modifiers.add("AK_PAIRING_LINE");
                        modifiers.add("AL_OPERATIONAL_CONDITION");
                        modifiers.add("AO_ENGAGEMENT_BAR");
                        modifiers.add("AQ_GUARDED_UNIT");
                        modifiers.add("AS_COUNTRY");
                        modifiers.add("AR_SPECIAL_DESIGNATOR");
                        break;
                    }
                    case 20: {
                        modifiers.add("A_SYMBOL_ICON");
                        modifiers.add("G_STAFF_COMMENTS");
                        modifiers.add("H_ADDITIONAL_INFO_1");
                        modifiers.add("J_EVALUATION_RATING");
                        modifiers.add("K_COMBAT_EFFECTIVENESS");
                        modifiers.add("P_IFF_SIF_AIS");
                        modifiers.add("S_HQ_STAFF_INDICATOR");
                        modifiers.add("T_UNIQUE_DESIGNATION_1");
                        modifiers.add("W_DTG_1");
                        modifiers.add("X_ALTITUDE_DEPTH");
                        modifiers.add("Y_LOCATION");
                        modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                        modifiers.add("AE_EQUIPMENT_TEARDOWN_TIME");
                        modifiers.add("AH_AREA_OF_UNCERTAINTY");
                        modifiers.add("AI_DEAD_RECKONING_TRAILER");
                        modifiers.add("AJ_SPEED_LEADER");
                        modifiers.add("AK_PAIRING_LINE");
                        modifiers.add("AL_OPERATIONAL_CONDITION");
                        modifiers.add("AQ_GUARDED_UNIT");
                        modifiers.add("AS_COUNTRY");
                        break;
                    }
                    case 27: {
                        modifiers.add("A_SYMBOL_ICON");
                        modifiers.add("G_STAFF_COMMENTS");
                        modifiers.add("H_ADDITIONAL_INFO_1");
                        modifiers.add("J_EVALUATION_RATING");
                        modifiers.add("K_COMBAT_EFFECTIVENESS");
                        modifiers.add("M_HIGHER_FORMATION");
                        modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                        modifiers.add("P_IFF_SIF_AIS");
                        modifiers.add("T_UNIQUE_DESIGNATION_1");
                        modifiers.add("V_EQUIP_TYPE");
                        modifiers.add("W_DTG_1");
                        modifiers.add("X_ALTITUDE_DEPTH");
                        modifiers.add("Y_LOCATION");
                        modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                        modifiers.add("AF_COMMON_IDENTIFIER");
                        modifiers.add("AS_COUNTRY");
                        modifiers.add("AV_LEADERSHIP");
                        break;
                    }
                    case 5: 
                    case 6: {
                        modifiers.add("A_SYMBOL_ICON");
                        modifiers.add("G_STAFF_COMMENTS");
                        modifiers.add("H_ADDITIONAL_INFO_1");
                        modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                        modifiers.add("T_UNIQUE_DESIGNATION_1");
                        modifiers.add("V_EQUIP_TYPE");
                        modifiers.add("X_ALTITUDE_DEPTH");
                        modifiers.add("Z_SPEED");
                        modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                        modifiers.add("AL_OPERATIONAL_CONDITION");
                        modifiers.add("AO_ENGAGEMENT_BAR");
                        modifiers.add("AS_COUNTRY");
                        break;
                    }
                    case 1: 
                    case 2: {
                        modifiers.add("A_SYMBOL_ICON");
                        modifiers.add("G_STAFF_COMMENTS");
                        modifiers.add("H_ADDITIONAL_INFO_1");
                        modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                        modifiers.add("T_UNIQUE_DESIGNATION_1");
                        modifiers.add("V_EQUIP_TYPE");
                        modifiers.add("X_ALTITUDE_DEPTH");
                        modifiers.add("Z_SPEED");
                        modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                        modifiers.add("AF_COMMON_IDENTIFIER");
                        modifiers.add("AL_OPERATIONAL_CONDITION");
                        modifiers.add("AO_ENGAGEMENT_BAR");
                        modifiers.add("AS_COUNTRY");
                        break;
                    }
                    case 30: {
                        modifiers.add("A_SYMBOL_ICON");
                        modifiers.add("G_STAFF_COMMENTS");
                        modifiers.add("H_ADDITIONAL_INFO_1");
                        modifiers.add("P_IFF_SIF_AIS");
                        modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                        modifiers.add("T_UNIQUE_DESIGNATION_1");
                        modifiers.add("V_EQUIP_TYPE");
                        modifiers.add("Y_LOCATION");
                        modifiers.add("Z_SPEED");
                        modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                        modifiers.add("AQ_GUARDED_UNIT");
                        modifiers.add("AL_OPERATIONAL_CONDITION");
                        modifiers.add("AO_ENGAGEMENT_BAR");
                        modifiers.add("AQ_GUARDED_UNIT");
                        modifiers.add("AR_SPECIAL_DESIGNATOR");
                        modifiers.add("AS_COUNTRY");
                        break;
                    }
                    case 35: {
                        modifiers.add("A_SYMBOL_ICON");
                        modifiers.add("G_STAFF_COMMENTS");
                        modifiers.add("H_ADDITIONAL_INFO_1");
                        modifiers.add("P_IFF_SIF_AIS");
                        modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                        modifiers.add("T_UNIQUE_DESIGNATION_1");
                        modifiers.add("V_EQUIP_TYPE");
                        modifiers.add("X_ALTITUDE_DEPTH");
                        modifiers.add("Y_LOCATION");
                        modifiers.add("Z_SPEED");
                        modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                        modifiers.add("AL_OPERATIONAL_CONDITION");
                        modifiers.add("AO_ENGAGEMENT_BAR");
                        modifiers.add("AQ_GUARDED_UNIT");
                        modifiers.add("AR_SPECIAL_DESIGNATOR");
                        modifiers.add("AS_COUNTRY");
                        break;
                    }
                    case 40: {
                        modifiers.add("A_SYMBOL_ICON");
                        modifiers.add("G_STAFF_COMMENTS");
                        modifiers.add("H_ADDITIONAL_INFO_1");
                        modifiers.add("J_EVALUATION_RATING");
                        modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                        modifiers.add("T_UNIQUE_DESIGNATION_1");
                        modifiers.add("W_DTG_1");
                        modifiers.add("Y_LOCATION");
                        modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                        modifiers.add("AS_COUNTRY");
                        break;
                    }
                    case 60: {
                        modifiers.add("A_SYMBOL_ICON");
                        modifiers.add("B_ECHELON");
                        modifiers.add("D_TASK_FORCE_INDICATOR");
                        modifiers.add("F_REINFORCED_REDUCED");
                        modifiers.add("G_STAFF_COMMENTS");
                        modifiers.add("H_ADDITIONAL_INFO_1");
                        modifiers.add("K_COMBAT_EFFECTIVENESS");
                        modifiers.add("L_SIGNATURE_EQUIP");
                        modifiers.add("M_HIGHER_FORMATION");
                        modifiers.add("S_HQ_STAFF_INDICATOR");
                        modifiers.add("T_UNIQUE_DESIGNATION_1");
                        modifiers.add("V_EQUIP_TYPE");
                        modifiers.add("W_DTG_1");
                        modifiers.add("Y_LOCATION");
                        modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                        modifiers.add("AO_ENGAGEMENT_BAR");
                        modifiers.add("AS_COUNTRY");
                        break;
                    }
                    case 25: {
                        break;
                    }
                    case 45: {
                        if (ec.equals("110102") || ec.equals("110202") || ec.equals("162200")) {
                            modifiers.add("X_ALTITUDE_DEPTH");
                            break;
                        }
                        if (ec.equals("140200")) {
                            modifiers.add("AN_AZIMUTH");
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block34;
            }
            switch (ss) {
                case 10: 
                case 11: {
                    modifiers.add("A_SYMBOL_ICON");
                    modifiers.add("B_ECHELON");
                    modifiers.add("D_TASK_FORCE_INDICATOR");
                    modifiers.add("F_REINFORCED_REDUCED");
                    modifiers.add("G_STAFF_COMMENTS");
                    modifiers.add("H_ADDITIONAL_INFO_1");
                    modifiers.add("J_EVALUATION_RATING");
                    modifiers.add("K_COMBAT_EFFECTIVENESS");
                    modifiers.add("M_HIGHER_FORMATION");
                    modifiers.add("P_IFF_SIF_AIS");
                    modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                    modifiers.add("S_HQ_STAFF_INDICATOR");
                    modifiers.add("T_UNIQUE_DESIGNATION_1");
                    modifiers.add("W_DTG_1");
                    modifiers.add("X_ALTITUDE_DEPTH");
                    modifiers.add("Y_LOCATION");
                    modifiers.add("Z_SPEED");
                    if (ss == 10 && ec.equals("110000")) {
                        modifiers.add("AA_SPECIAL_C2_HQ");
                    }
                    modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                    modifiers.add("AH_AREA_OF_UNCERTAINTY");
                    modifiers.add("AI_DEAD_RECKONING_TRAILER");
                    modifiers.add("AJ_SPEED_LEADER");
                    modifiers.add("AK_PAIRING_LINE");
                    modifiers.add("AL_OPERATIONAL_CONDITION");
                    modifiers.add("AO_ENGAGEMENT_BAR");
                    modifiers.add("AS_COUNTRY");
                    break;
                }
                case 15: 
                case 52: {
                    modifiers.add("A_SYMBOL_ICON");
                    modifiers.add("C_QUANTITY");
                    modifiers.add("G_STAFF_COMMENTS");
                    modifiers.add("H_ADDITIONAL_INFO_1");
                    modifiers.add("J_EVALUATION_RATING");
                    modifiers.add("L_SIGNATURE_EQUIP");
                    modifiers.add("N_HOSTILE");
                    modifiers.add("P_IFF_SIF_AIS");
                    modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                    modifiers.add("R_MOBILITY_INDICATOR");
                    modifiers.add("T_UNIQUE_DESIGNATION_1");
                    modifiers.add("V_EQUIP_TYPE");
                    modifiers.add("W_DTG_1");
                    modifiers.add("X_ALTITUDE_DEPTH");
                    modifiers.add("Y_LOCATION");
                    modifiers.add("Z_SPEED");
                    modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                    modifiers.add("AD_PLATFORM_TYPE");
                    modifiers.add("AE_EQUIPMENT_TEARDOWN_TIME");
                    modifiers.add("AF_COMMON_IDENTIFIER");
                    modifiers.add("AG_AUX_EQUIP_INDICATOR");
                    modifiers.add("AH_AREA_OF_UNCERTAINTY");
                    modifiers.add("AI_DEAD_RECKONING_TRAILER");
                    modifiers.add("AJ_SPEED_LEADER");
                    modifiers.add("AK_PAIRING_LINE");
                    modifiers.add("AL_OPERATIONAL_CONDITION");
                    modifiers.add("AO_ENGAGEMENT_BAR");
                    modifiers.add("AQ_GUARDED_UNIT");
                    modifiers.add("AR_SPECIAL_DESIGNATOR");
                    modifiers.add("AS_COUNTRY");
                    break;
                }
                case 20: {
                    modifiers.add("A_SYMBOL_ICON");
                    modifiers.add("G_STAFF_COMMENTS");
                    modifiers.add("H_ADDITIONAL_INFO_1");
                    modifiers.add("J_EVALUATION_RATING");
                    modifiers.add("K_COMBAT_EFFECTIVENESS");
                    modifiers.add("P_IFF_SIF_AIS");
                    modifiers.add("S_HQ_STAFF_INDICATOR");
                    modifiers.add("T_UNIQUE_DESIGNATION_1");
                    modifiers.add("W_DTG_1");
                    modifiers.add("X_ALTITUDE_DEPTH");
                    modifiers.add("Y_LOCATION");
                    modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                    modifiers.add("AH_AREA_OF_UNCERTAINTY");
                    modifiers.add("AI_DEAD_RECKONING_TRAILER");
                    modifiers.add("AJ_SPEED_LEADER");
                    modifiers.add("AK_PAIRING_LINE");
                    modifiers.add("AL_OPERATIONAL_CONDITION");
                    modifiers.add("AO_ENGAGEMENT_BAR");
                    modifiers.add("AS_COUNTRY");
                    break;
                }
                case 5: 
                case 6: 
                case 50: {
                    modifiers.add("A_SYMBOL_ICON");
                    modifiers.add("G_STAFF_COMMENTS");
                    modifiers.add("H_ADDITIONAL_INFO_1");
                    modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                    modifiers.add("T_UNIQUE_DESIGNATION_1");
                    modifiers.add("V_EQUIP_TYPE");
                    modifiers.add("X_ALTITUDE_DEPTH");
                    modifiers.add("Z_SPEED");
                    modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                    modifiers.add("AL_OPERATIONAL_CONDITION");
                    modifiers.add("AO_ENGAGEMENT_BAR");
                    modifiers.add("AS_COUNTRY");
                    break;
                }
                case 1: 
                case 2: 
                case 51: {
                    modifiers.add("A_SYMBOL_ICON");
                    modifiers.add("G_STAFF_COMMENTS");
                    modifiers.add("H_ADDITIONAL_INFO_1");
                    modifiers.add("P_IFF_SIF_AIS");
                    modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                    modifiers.add("T_UNIQUE_DESIGNATION_1");
                    modifiers.add("V_EQUIP_TYPE");
                    modifiers.add("X_ALTITUDE_DEPTH");
                    modifiers.add("Z_SPEED");
                    modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                    modifiers.add("AL_OPERATIONAL_CONDITION");
                    modifiers.add("AO_ENGAGEMENT_BAR");
                    modifiers.add("AS_COUNTRY");
                    break;
                }
                case 30: 
                case 53: {
                    modifiers.add("A_SYMBOL_ICON");
                    modifiers.add("G_STAFF_COMMENTS");
                    modifiers.add("H_ADDITIONAL_INFO_1");
                    modifiers.add("P_IFF_SIF_AIS");
                    modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                    modifiers.add("T_UNIQUE_DESIGNATION_1");
                    modifiers.add("V_EQUIP_TYPE");
                    modifiers.add("Y_LOCATION");
                    modifiers.add("Z_SPEED");
                    modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                    modifiers.add("AL_OPERATIONAL_CONDITION");
                    modifiers.add("AO_ENGAGEMENT_BAR");
                    modifiers.add("AQ_GUARDED_UNIT");
                    modifiers.add("AR_SPECIAL_DESIGNATOR");
                    modifiers.add("AS_COUNTRY");
                    break;
                }
                case 35: 
                case 54: {
                    modifiers.add("A_SYMBOL_ICON");
                    modifiers.add("AG_AUX_EQUIP_INDICATOR");
                    modifiers.add("AL_OPERATIONAL_CONDITION");
                    modifiers.add("AO_ENGAGEMENT_BAR");
                    modifiers.add("AR_SPECIAL_DESIGNATOR");
                    modifiers.add("G_STAFF_COMMENTS");
                    modifiers.add("H_ADDITIONAL_INFO_1");
                    modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                    modifiers.add("T_UNIQUE_DESIGNATION_1");
                    modifiers.add("V_EQUIP_TYPE");
                    modifiers.add("X_ALTITUDE_DEPTH");
                    modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                    modifiers.add("AS_COUNTRY");
                    break;
                }
                case 40: {
                    modifiers.add("A_SYMBOL_ICON");
                    modifiers.add("G_STAFF_COMMENTS");
                    modifiers.add("H_ADDITIONAL_INFO_1");
                    modifiers.add("J_EVALUATION_RATING");
                    modifiers.add("Q_DIRECTION_OF_MOVEMENT");
                    modifiers.add("W_DTG_1");
                    modifiers.add("Y_LOCATION");
                    modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                    modifiers.add("AS_COUNTRY");
                    break;
                }
                case 60: {
                    modifiers.add("A_SYMBOL_ICON");
                    modifiers.add("B_ECHELON");
                    modifiers.add("D_TASK_FORCE_INDICATOR");
                    modifiers.add("F_REINFORCED_REDUCED");
                    modifiers.add("G_STAFF_COMMENTS");
                    modifiers.add("H_ADDITIONAL_INFO_1");
                    modifiers.add("K_COMBAT_EFFECTIVENESS");
                    modifiers.add("L_SIGNATURE_EQUIP");
                    modifiers.add("M_HIGHER_FORMATION");
                    modifiers.add("S_HQ_STAFF_INDICATOR");
                    modifiers.add("T_UNIQUE_DESIGNATION_1");
                    modifiers.add("V_EQUIP_TYPE");
                    modifiers.add("W_DTG_1");
                    modifiers.add("Y_LOCATION");
                    modifiers.add("AB_FEINT_DUMMY_INDICATOR");
                    modifiers.add("AO_ENGAGEMENT_BAR");
                    modifiers.add("AS_COUNTRY");
                    break;
                }
                case 25: {
                    break;
                }
                case 45: {
                    if (ec.equals("110102") || ec.equals("110202") || ec.equals("162200")) {
                        modifiers.add("X_ALTITUDE_DEPTH");
                        break;
                    }
                    if (!ec.equals("140200")) break;
                    modifiers.add("AN_AZIMUTH");
                    break;
                }
            }
        }
        if (ss == 51 || ss == 52 || ss == 53 || ss == 54 || ss == 50) {
            modifiers.add("R2_SIGNIT_MOBILITY_INDICATOR");
        }
        return modifiers;
    }

    public MSInfo getMSLInfo(String symbolID) {
        int length = symbolID.length();
        if (length >= 20 && length <= 30) {
            int version = SymbolID.getVersion(symbolID);
            return this.getMSLInfo(SymbolUtilities.getBasicSymbolID(symbolID), version);
        }
        return null;
    }

    public MSInfo getMSLInfo(String basicID, int version) {
        int length = basicID.length();
        if (length == 8) {
            if (version >= 13) {
                return _MSLookupE.getOrDefault(basicID, null);
            }
            if (version == 10 && basicID.equals("25272100")) {
                return new MSInfo(10, "25", "Protection Areas", "Minimum Safe Distance Zone", "", "272100", "Area", "Area14", new ArrayList<String>());
            }
            return _MSLookupD.getOrDefault(basicID, null);
        }
        if (length >= 20 && length <= 30) {
            return this.getMSLInfo(SymbolUtilities.getBasicSymbolID(basicID), version);
        }
        return null;
    }

    public List<String> getIDList(int version) {
        if (version < 13) {
            return this._IDListD;
        }
        if (version >= 13) {
            return this._IDListE;
        }
        return this._IDListD;
    }

    public boolean addCustomSymbol(MSInfo msInfo) {
        boolean success = false;
        try {
            int version = msInfo.getVersion();
            if (version < 13) {
                if (this._IDListD.indexOf(msInfo.getBasicSymbolID()) == -1) {
                    this._IDListD.add(msInfo.getBasicSymbolID());
                    _MSLookupD.put(msInfo.getBasicSymbolID(), msInfo);
                    success = true;
                } else {
                    ErrorLogger.LogMessage("Symbol Set and Entity Code combination already exist: " + msInfo.getBasicSymbolID(), Level.INFO, false);
                }
            } else if (version >= 13) {
                if (this._IDListE.indexOf(msInfo.getBasicSymbolID()) == -1) {
                    this._IDListE.add(msInfo.getBasicSymbolID());
                    _MSLookupE.put(msInfo.getBasicSymbolID(), msInfo);
                    success = true;
                } else {
                    ErrorLogger.LogMessage("Symbol Set and Entity Code combination already exist: " + msInfo.getBasicSymbolID(), Level.INFO, false);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.LogException("MSLookup", "addCustomSymbol", e);
        }
        return success;
    }
}

