/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.ShapeUtilities;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class TextInfo {
    String _text = "";
    Point2D _location = null;
    Rectangle2D _bounds = null;
    double _descent = 0.0;
    double _aboveBaseHeight = 0.0;

    public TextInfo(String text, int x, int y, Font font, FontRenderContext frc) {
        if (text != null) {
            this._text = text;
        }
        this._location = new Point2D.Double(x, y);
        this._bounds = font.getStringBounds(text, frc);
        this._descent = this._bounds.getHeight() + this._bounds.getY();
        this._aboveBaseHeight = this._bounds.getY() * -1.0;
    }

    public void setLocation(int x, int y) {
        this._bounds.setRect(x, (double)y - this._aboveBaseHeight, this._bounds.getWidth(), this._bounds.getHeight());
        this._location.setLocation(x, y);
    }

    public Point2D getLocation() {
        return this._location;
    }

    public void shift(int x, int y) {
        ShapeUtilities.offset(this._bounds, x, y);
        ShapeUtilities.offset(this._location, x, y);
    }

    public String getText() {
        return this._text;
    }

    public Rectangle2D getTextBounds() {
        return this._bounds;
    }

    public Rectangle2D getTextOutlineBounds() {
        RendererSettings RS = RendererSettings.getInstance();
        int outlineOffset = RS.getTextOutlineWidth();
        Rectangle2D bounds = (Rectangle2D)this._bounds.clone();
        if (outlineOffset > 0) {
            if (RS.getTextBackgroundMethod() == 2) {
                ShapeUtilities.grow(bounds, outlineOffset / 2);
            } else {
                ShapeUtilities.grow(bounds, outlineOffset);
            }
        }
        return bounds;
    }

    public double getDescent() {
        return this._descent;
    }
}

