/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package armyc2.c5isr.JavaTacticalRenderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

import armyc2.c5isr.JavaLineArray.*;
import armyc2.c5isr.RenderMultipoints.clsRenderer2;
import armyc2.c5isr.renderer.utilities.EntityCode;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.renderer.utilities.RendererException;
import armyc2.c5isr.renderer.utilities.SymbolID;

/**
 * A class to process channel types.
 *
 * 
 */
public final class clsChannelUtility {

    private static final String _className = "clsChannelUtility";

    /**
     * Gets partitions from the client points based on the segments generated by
     * GetSegments. Partitions are used handle double-backed segments. Each
     * partition is a continuous sequence of points for a channel.
     *
     * @param segments
     * @param partitions OUT the partitions
     * @return
     */
    private static int GetPartitions(boolean[] segments,
            ArrayList<P1> partitions) {
        try {
            int j = 0;
            boolean nextSegment = false;
            //worst case is every segment is a separate partition
            //caller must deallocate partitions
            P1 p1 = new P1();
            //first segment will always be true,
            //there are no bad one-segment channels
            if (segments[0] == false) {
                return 0;
            }

            if (partitions != null) {
                partitions.clear();
            } else {
                return 0;
            }

            p1.start = 0;
            //only add the partitions after p1.end has been set
            int n = segments.length;
            //for (j = 0; j < segments.length - 1; j++) 
            for (j = 0; j < n - 1; j++) {
                nextSegment = segments[j + 1];
                if (nextSegment == false) {
                    //the end of the current partition is the last good segment
                    p1.end_Renamed = j;
                    partitions.add(p1);
                    //beginning of the next partition
                    p1 = new P1();
                    p1.start = j + 1;
                }
            }
            p1.end_Renamed = j;
            partitions.add(p1);
        } catch (Exception exc) {
            //System.out.println(e.getMessage());
            //clsUtility.WriteFile("error in clsChanneUtility.GetPartitions");
            ErrorLogger.LogException(_className, "GetPartitions",
                    new RendererException("Failed inside GetPartitions", exc));
        }
        return partitions.size();
    }

    /**
     * Draws a partition to the shapes array and stores the calculated channel
     * points
     *
     * @param fromSegment
     * @param toSegment
     * @param pixels
     * @param channelWidth
     * @param bolLastSegment
     * @param shapes
     * @param channelPoints
     * @param distanceToChannelPoint
     * @return
     */
    private static int DrawGoodChannel2(TGLight tg,
            int fromSegment,
            int toSegment,
            double[] pixels,
            int channelWidth,
            boolean bolLastSegment,
            ArrayList<Shape2> shapes,
            ArrayList<POINT2> channelPoints,
            double distanceToChannelPoint) {
        int returnValue = 0;	// Had to initialize to something
        try {
            int lineType = tg.get_LineType();
            int lineType2;
            double[] channelPixels = null;
            switch (lineType) {
                case TacticalLines.LC:
                case TacticalLines.UNSP:
                case TacticalLines.DFENCE:
                case TacticalLines.SFENCE:
                case TacticalLines.DOUBLEA:
                case TacticalLines.LWFENCE:
                case TacticalLines.HWFENCE:
                case TacticalLines.BBS_LINE:
                case TacticalLines.SINGLEC:
                case TacticalLines.DOUBLEC:
                case TacticalLines.TRIPLE:
                    lineType2 = lineType;
                    break;
                case TacticalLines.SPT:
                case TacticalLines.FRONTAL_ATTACK:
                case TacticalLines.TURNING_MOVEMENT:
                case TacticalLines.MOVEMENT_TO_CONTACT:
                    if (fromSegment == 0) {
                        lineType2 = TacticalLines.CHANNEL_FLARED;
                    } else {
                        lineType2 = TacticalLines.CHANNEL;
                    }
                    break;
                case TacticalLines.MAIN:
                    if (fromSegment == 0) {
                        lineType2 = TacticalLines.CHANNEL_FLARED;
                    } else {
                        lineType2 = TacticalLines.CHANNEL;
                    }
                    break;
                case TacticalLines.CATK:
                    lineType2 = TacticalLines.CHANNEL_DASHED;
                    break;
                case TacticalLines.CATKBYFIRE:
                    lineType2 = TacticalLines.CHANNEL_DASHED;
                    break;
                default:
                    lineType2 = TacticalLines.CHANNEL;
                    break;
            }
            if (bolLastSegment == true) {
                if (fromSegment != 0) {
                    switch (lineType) {
                        case TacticalLines.SPT:
                        case TacticalLines.FRONTAL_ATTACK:
                        case TacticalLines.TURNING_MOVEMENT:
                        case TacticalLines.MOVEMENT_TO_CONTACT:
                            lineType2 = TacticalLines.SPT_STRAIGHT;
                            break;
                        case TacticalLines.MAIN:
                            lineType2 = TacticalLines.MAIN_STRAIGHT;
                            break;
                        default:
                            lineType2 = (int) lineType;
                            break;
                    }
                } else {
                    lineType2 = (int) lineType;
                }
            }

            if (fromSegment < 0) {
                return returnValue;
            }
            if (toSegment < 0) {
                return returnValue;
            }
            if (toSegment < fromSegment) {
                return returnValue;
            }
            int j;
            int lineCount;
            int numPoints;
            int counter;
            double[] goodUpperPixels;
            double[] goodLowerPixels;
            numPoints = toSegment - fromSegment + 2;
            goodUpperPixels = new double[2 * numPoints];
            goodLowerPixels = new double[2 * numPoints];

            counter = 0;
            for (j = fromSegment; j < toSegment + 2; j++) {
                goodUpperPixels[counter] = pixels[2 * j];
                goodUpperPixels[counter + 1] = pixels[2 * j + 1];
                goodLowerPixels[counter] = pixels[2 * j];
                goodLowerPixels[counter + 1] = pixels[2 * j + 1];
                counter = counter + 2;
            }

            tg.set_LineType(lineType2);
            lineCount = CELineArray.CGetLineCountDouble(tg, goodUpperPixels, numPoints, channelWidth);
            channelPixels = new double[3 * lineCount];
            POINT2 pt = null;
            lineCount = Channels.GetChannel1Double(tg, goodUpperPixels, goodLowerPixels, channelPixels, numPoints, numPoints, channelWidth / 2, (int) distanceToChannelPoint, shapes);
            tg.set_LineType(lineType);

            //if shapes is null then it is not a CPOF client
            if (shapes == null && channelPixels != null) {
                //do not clear channelPoints first because the function gets successive calls
                int n = channelPixels.length;
                //for (j = 0; j < channelPixels.length / 3; j++) 
                for (j = 0; j < n / 3; j++) {
                    pt = new POINT2(channelPixels[3 * j], channelPixels[3 * j + 1], (int) channelPixels[3 * j + 2]);
                    if (j == channelPixels.length / 3 - 1) {
                        pt.style = 5;
                    }
                    channelPoints.add(pt);
                }
            }

            if (lineCount > 0) {
                //DrawChannelPixels2(lineCount, channelPixels, (int)lineType);
                returnValue = channelPixels.length;
            } else {
                returnValue = 0;
            }
            //channelPixels[channelPixels.length - 1] = 5;
            if (lineCount > 0) {
                channelPixels[lineCount - 1] = 5;
            }
            //clean up
            goodUpperPixels = null;
            goodLowerPixels = null;
        } catch (Exception exc) {
            //clsUtility.WriteFile("error in clsChanneUtility.DrawGoodChannel2");
            ErrorLogger.LogException(_className, "DrawGoodChannel2",
                    new RendererException("Failed inside DrawGoodChannel2", exc));
        }
        return returnValue;
    }

    /**
     * Draws the channel partitions to the shapes array
     *
     * @param pixels
     * @param partitions
     * @param channelWidth channel width in pixels
     * @param shapes
     * @param channelPoints
     * @param distanceToChannelPoint distance in pixels from the tip to the back
     * of the arrow
     */
    private static void DrawSegments(TGLight tg,
            double[] pixels,
            ArrayList<P1> partitions,
            int channelWidth,
            ArrayList<Shape2> shapes,
            ArrayList<POINT2> channelPoints,
            double distanceToChannelPoint) {
        try {
            int j = 0;
            int n = 0;
            int t = partitions.size();
            //for (j = 0; j < partitions.size() - 1; j++) 
            for (j = 0; j < t - 1; j++) {
                n = DrawGoodChannel2(tg, partitions.get(j).start, partitions.get(j).end_Renamed, pixels, channelWidth, false, shapes, channelPoints, distanceToChannelPoint);

            }
            //draw the last partition using linetype
            n = DrawGoodChannel2(tg, partitions.get(j).start, partitions.get(j).end_Renamed, pixels, channelWidth, true, shapes, channelPoints, distanceToChannelPoint);
        } catch (Exception exc) {
            //clsUtility.WriteFile("error in clsChanneUtility.DrawSegments");
            ErrorLogger.LogException(_className, "DrawSegments",
                    new RendererException("Failed inside DrawSegments", exc));
        }
    }

    private static void DrawLCSingleLineSegments(TGLight tg,
                                                 double[] pixels2,
                                                 ArrayList<P1> singleLinePartitions,
                                                 ArrayList<Shape2> shapes,
                                                 Rectangle2D clipBounds,
                                                 IPointConversion converter) {
        try {
            for (P1 flotPartition : singleLinePartitions) {
                int vblSaveCounter = flotPartition.end_Renamed - flotPartition.start + 1;
                ArrayList<POINT2> flotPixels = new ArrayList<>();
                for (int i = 0; i < vblSaveCounter; i++)
                    flotPixels.add(new POINT2(pixels2[2 * (i + flotPartition.start)], pixels2[2 * (i + flotPartition.start) + 1]));

                String flotID = tg.get_SymbolId();
                flotID = SymbolID.setAffiliation(flotID, SymbolID.StandardIdentity_Affiliation_Hostile_Faker);
                flotID = SymbolID.setEntityCode(flotID, EntityCode.EntityCode_FLOT);
                TGLight flotTG = new TGLight();
                flotTG.set_LineType(TacticalLines.FLOT);
                flotTG.set_Pixels(flotPixels);
                flotTG.set_SymbolId(flotID);
                flotTG.set_LineThickness(tg.get_LineThickness());

                ArrayList<Shape2> flotShapes = clsRenderer2.GetLineArray(flotTG, converter, false, clipBounds);

                if (flotShapes != null) {
                    for (Shape2 shape : flotShapes)
                        shape.setLineColor(Color.RED);
                    shapes.addAll(flotShapes);
                }
            }
        } catch (Exception exc) {
            ErrorLogger.LogException(_className, "DrawLCFlotSegments",
                    new RendererException("Failed inside DrawLCFlotSegments", exc));
        }
    }

    /**
     * Handle symbol too small for line of contact
     * @param tg
     * @param pixels
     * @return 
     */
    private static ArrayList<POINT2> getLCPixels(TGLight tg,ArrayList<POINT2>pixels)
    {
        ArrayList<POINT2>pixels2=null;
        try
        {
            if(tg.get_LineType()!=TacticalLines.LC)
                return pixels;
            POINT2[] pts=tg.Pixels.toArray(new POINT2[pixels.size()]);
            POINT2 ul=new POINT2(),lr=new POINT2();
            lineutility.CalcMBRPoints((POINT2[])pts, pts.length, ul, lr);
            double flotDiameter = arraysupport.getScaledSize(21, tg.get_LineThickness(), tg.get_patternScale());
            if(lr.x-ul.x>=flotDiameter)
                return pixels;
            else if (lr.y-ul.y>=flotDiameter)
                return pixels;
            //at this point the mbr is too small for a meaningful LC symbol
            double x0=pts[0].x,y0=pts[0].y,x1=pts[1].x,y1=pts[1].y;
            if (x0<=x1)            
                x1=x0+flotDiameter;
            else
                x1=x0-flotDiameter;
            y1=y0;
            POINT2 pt0=new POINT2(x0,y0),pt1=new POINT2(x1,y1);
            pixels2=new ArrayList();
            pixels2.add(pt0);
            pixels2.add(pt1);
        }
        catch (Exception exc) {
            //clsUtility.WriteFile("error in clsChanneUtility.DrawSegments");
               ErrorLogger.LogException(_className ,"getLCPixels",
                    new RendererException("Failed inside getLCPixels", exc));
        }    
        return pixels2;
    }

    /**
     * The main interface to clsChannelUtility calls DrawChannel2 after stuffing
     * the points into an array of 2-tuples x,y
     *
     * @param pixels the client points
     * @param linetype the line type
     * @param tg the tactical graphic
     * @param shapes
     * @param channelPoints
     */
    public static void DrawChannel(ArrayList<POINT2> pixels,
            int linetype,
            TGLight tg,
            ArrayList<Shape2> shapes,
            ArrayList<POINT2> channelPoints,
            Rectangle2D clipBounds,
            IPointConversion converter) {
        try {
            pixels=getLCPixels(tg,pixels);
            //we must do this because the rotary arrow tip now has to match the
            //anchor point, i.e. the rotary feature can no longer stick out past the anchor point
            //45 pixels shift here matches the 45 pixels shift for catkbyfire found in Channels.GetAXADDouble
            lineutility.adjustCATKBYFIREControlPoint(linetype, pixels, 45);
            
            int j = 0;
            double[] pixels2 = new double[pixels.size() * 2];
            int n = pixels.size();
            //for (j = 0; j < pixels.size(); j++) 
            for (j = 0; j < n; j++) {
                pixels2[2 * j] = pixels.get(j).x;
                pixels2[2 * j + 1] = pixels.get(j).y;
            }
            DrawChannel2(pixels2, linetype, tg, shapes, channelPoints, clipBounds, converter);
        } catch (Exception exc) {
            //clsUtility.WriteFile("error in clsChanneUtility.DrawSegments");
            ErrorLogger.LogException(_className, "DrawChannel",
                    new RendererException("Failed inside DrawChannel", exc));
        }
    }

    /**
     * utility for clsMETOC to handle double-backed segments
     *
     * @param tg the tactical graphic object
     */
    public static ArrayList<P1> GetPartitions2(TGLight tg) {
        ArrayList partitions = null;
        try {
            double[] pixels = new double[tg.Pixels.size() * 2];
            int n = tg.Pixels.size();
            //for(int j=0;j<tg.Pixels.size();j++)
            for (int j = 0; j < n; j++) {
                pixels[2 * j] = tg.Pixels.get(j).x;
                pixels[2 * j + 1] = tg.Pixels.get(j).y;
            }

            boolean[] segments = new boolean[pixels.length / 2 - 1];
            if (segments.length == 0) {
                return null;
            }

            double factor = arraysupport.getScaledSize(3, tg.get_LineThickness(), tg.get_patternScale());

            clsUtility.GetSegments(pixels, segments, factor);
            partitions = new ArrayList<P1>();
            GetPartitions(segments, partitions);
        } catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetPartitions2",
                    new RendererException("Failed inside GetPartitions2", exc));
        }
        return partitions;
    }

    /**
     * The main function for processing channel types. Gets segments, then gets
     * partitions from the segments and then draws the partitions.
     *
     * @param pixels the client points as an array of 2-tuples x,y
     * @param linetype the line type
     * @param tg the tactical graphic object
     * @param shapes
     * @param channelPoints
     */
    private static void DrawChannel2(double[] pixels,
            int linetype,
            TGLight tg,
            ArrayList<Shape2> shapes,
            ArrayList<POINT2> channelPoints,
            Rectangle2D clipBounds,
            IPointConversion converter) {
        try {
            ref<double[]> distanceToChannelPoint = new ref();
            int j = 0;
            double[] pixels2 = null;
            int channelWidth = 0;
            ArrayList<P1> partitions = null;
            int n = pixels.length;
            int numPoints = 0;
            //LC and others do not call clsUtility.ChannelWidth, but the
            //value array still needs to be allocated or there is a
            //null pointer exception in DrawGoodChannel2
            distanceToChannelPoint.value = new double[1];
            distanceToChannelPoint.value[0] = arraysupport.getScaledSize(20, tg.get_LineThickness(), tg.get_patternScale());

            switch (linetype) {
                case TacticalLines.MAIN:
                case TacticalLines.CATK:
                case TacticalLines.CATKBYFIRE:
                case TacticalLines.AIRAOA:
                case TacticalLines.AAAAA:
                case TacticalLines.SPT:
                case TacticalLines.FRONTAL_ATTACK:
                case TacticalLines.TURNING_MOVEMENT:
                case TacticalLines.MOVEMENT_TO_CONTACT:
                    clsUtility.ReorderPixels(pixels);
                    numPoints = pixels.length / 2;

                    if (numPoints < 3) {
                        return;
                    }
                    //moved this to be prior to stuffing pixels2
                    channelWidth = clsUtility.ChannelWidth(pixels, distanceToChannelPoint) / 2;
                    //ValidateChannelPixels2(ref pixels, ref channelWidth, ref distanceToChannelPoint);

                    numPoints = pixels.length / 2;
                    pixels2 = new double[pixels.length - 2];

                    for (j = 0; j < numPoints; j++) {
                        if (j < numPoints - 1) {
                            pixels2[2 * j] = pixels[2 * j];
                            pixels2[2 * j + 1] = pixels[2 * j + 1];
                        }
                    }
                    break;
                case TacticalLines.LC:
                    channelWidth = (int) arraysupport.getScaledSize(40, tg.get_LineThickness(), tg.get_patternScale());// was 20;
                    pixels2 = new double[pixels.length];
                    n = pixels.length;
                    //for (j = 0; j < pixels.length; j++) 
                    for (j = 0; j < n; j++) {
                        pixels2[j] = pixels[j];
                    }
                    break;
                case TacticalLines.UNSP:
                case TacticalLines.DFENCE:
                case TacticalLines.SFENCE:
                case TacticalLines.DOUBLEA:
                case TacticalLines.LWFENCE:
                case TacticalLines.HWFENCE:
                case TacticalLines.SINGLEC:
                case TacticalLines.DOUBLEC:
                case TacticalLines.TRIPLE:
                    tg.set_lineCap(BasicStroke.CAP_BUTT);
                    channelWidth = (int) arraysupport.getScaledSize(30, tg.get_LineThickness(), tg.get_patternScale());
                    if (Channels.getShiftLines()) {
                        channelWidth = (int) arraysupport.getScaledSize(60, tg.get_LineThickness(), tg.get_patternScale());
                    }
                    pixels2 = new double[pixels.length];
                    n = pixels.length;
                    //for (j = 0; j < pixels.length; j++) 
                    for (j = 0; j < n; j++) {
                        pixels2[j] = pixels[j];
                    }
                    break;
                case TacticalLines.BBS_LINE:
                    channelWidth = 8 * tg.Pixels.get(0).style;  //was 20 1-10-13
                    pixels2 = new double[pixels.length];
                    n = pixels.length;
                    //for (j = 0; j < pixels.length; j++)
                    for (j = 0; j < n; j++) {
                        pixels2[j] = pixels[j];
                    }
                    break;
                default:

                    break;
            }

            //we require new partitions because pixels are dirty
            boolean[] segments = new boolean[pixels2.length / 2 - 1];
            if (segments.length == 0) {
                return;
            }

            // Line of contact looks bad with small channel corners extending out
            if (linetype == TacticalLines.LC) {
                partitions = new ArrayList<>();
                ArrayList<P1> singleLinePartitions = new ArrayList<>();
                clsUtility.GetLCPartitions(pixels2, arraysupport.getScaledSize(40, tg.get_LineThickness(), tg.get_patternScale()), partitions, singleLinePartitions);
                DrawSegments(tg, pixels2, partitions, channelWidth, shapes, channelPoints, distanceToChannelPoint.value[0]);

                if (singleLinePartitions.size() > 0) {
                    // Render any small angles that only have side (not channel) as FLOT
                    DrawLCSingleLineSegments(tg, pixels2, singleLinePartitions, shapes, clipBounds, converter);
                }
            } else {
                double factor = 3;

                clsUtility.GetSegments(pixels2, segments, factor);
                partitions = new ArrayList<>();
                GetPartitions(segments, partitions);

                DrawSegments(tg, pixels2, partitions, channelWidth, shapes, channelPoints, distanceToChannelPoint.value[0]);
            }
        } catch (Exception exc) {
            ErrorLogger.LogException(_className, "DrawChannel2",
                    new RendererException("Failed inside DrawChannel2", exc));
        }
    }
}
