/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.SymbolDimensionInfo;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Base64;

public class SVGSymbolInfo
implements SymbolDimensionInfo {
    private String _svg = null;
    private String _svgDataURI = null;
    private int _anchorX = 0;
    private int _anchorY = 0;
    private Rectangle2D _symbolBounds = null;
    private Rectangle2D _bounds = null;

    public SVGSymbolInfo(String svg, Point2D anchorPoint, Rectangle2D symbolBounds, Rectangle2D svgBounds) {
        this._svg = svg;
        this._anchorX = (int)anchorPoint.getX();
        this._anchorY = (int)anchorPoint.getY();
        this._symbolBounds = symbolBounds;
        this._bounds = svgBounds;
    }

    public String getSVGDataURI() {
        if (this._svgDataURI == null) {
            this._svgDataURI = new String(Base64.getEncoder().encode(this._svg.getBytes()));
        }
        return this._svgDataURI;
    }

    public String getSVG() {
        return this._svg;
    }

    @Override
    public int getSymbolCenterX() {
        return this._anchorX;
    }

    @Override
    public int getSymbolCenterY() {
        return this._anchorY;
    }

    @Override
    public Point getSymbolCenterPoint() {
        return new Point(this._anchorX, this._anchorY);
    }

    @Override
    public Rectangle2D getSymbolBounds() {
        return new Rectangle2D.Double(this._symbolBounds.getX(), this._symbolBounds.getY(), this._symbolBounds.getWidth(), this._symbolBounds.getHeight());
    }

    @Override
    public Rectangle2D getImageBounds() {
        return new Rectangle2D.Double(this._bounds.getX(), this._bounds.getY(), this._bounds.getWidth(), this._bounds.getHeight());
    }
}

