/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer;

import armyc2.c5isr.renderer.SinglePointRenderer;
import armyc2.c5isr.renderer.SinglePointSVGRenderer;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.GENCLookup;
import armyc2.c5isr.renderer.utilities.ImageInfo;
import armyc2.c5isr.renderer.utilities.MSInfo;
import armyc2.c5isr.renderer.utilities.MSLookup;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.RendererUtilities;
import armyc2.c5isr.renderer.utilities.SVGInfo;
import armyc2.c5isr.renderer.utilities.SVGLookup;
import armyc2.c5isr.renderer.utilities.SVGSymbolInfo;
import armyc2.c5isr.renderer.utilities.SymbolID;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class MilStdIconRenderer {
    private String TAG = "MilStdIconRenderer";
    private static MilStdIconRenderer _instance = null;
    private AtomicBoolean _initSuccess = new AtomicBoolean(false);
    private SinglePointRenderer _SPR = null;
    private SinglePointSVGRenderer _SPSVGR = null;

    private MilStdIconRenderer() {
        this.init();
    }

    public static synchronized MilStdIconRenderer getInstance() {
        if (_instance == null) {
            _instance = new MilStdIconRenderer();
        }
        return _instance;
    }

    private synchronized void init() {
        try {
            if (!this._initSuccess.get()) {
                SVGLookup.getInstance();
                MSLookup.getInstance();
                this._SPR = SinglePointRenderer.getInstance();
                this._SPSVGR = SinglePointSVGRenderer.getInstance();
                GENCLookup.getInstance();
                this._initSuccess.set(true);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(this.TAG, "init", exc);
        }
    }

    public synchronized boolean isReady() {
        return this._initSuccess.get();
    }

    public Boolean CanRender(String symbolID, HashMap<String, String> attributes) {
        String message = "";
        try {
            String lookupID = SymbolUtilities.getBasicSymbolID(symbolID);
            String lookupSVGID = SVGLookup.getMainIconID(symbolID);
            MSInfo msi = MSLookup.getInstance().getMSLInfo(symbolID);
            if (msi == null) {
                message = String.format("Cannot find %s in MSLookup", lookupID);
            } else if (msi.getDrawRule() == 0) {
                message = String.format("%s (%s) is DoNotDraw", lookupID, msi.getName());
            } else {
                int version = SymbolID.getVersion(symbolID);
                SVGInfo si = SVGLookup.getInstance().getSVGLInfo(lookupSVGID, version);
                if (si != null) {
                    return true;
                }
                message = String.format("Cannot find %s (%s) in SVGLookup", lookupID, msi.getName());
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdIconRenderer", "CanRender", exc);
        }
        ErrorLogger.LogMessage("MilStdIconRenderer", "CanRender", message);
        return false;
    }

    public ImageInfo RenderIcon(String symbolID, Map<String, String> modifiers, Map<String, String> attributes) {
        int ss = SymbolID.getSymbolSet(symbolID);
        ImageInfo temp = null;
        MSInfo msi = MSLookup.getInstance().getMSLInfo(symbolID);
        if (msi == null) {
            // empty if block
        }
        if (msi != null && msi.getDrawRule() == 0) {
            return null;
        }
        if (ss == 25) {
            if (msi != null) {
                temp = !SymbolUtilities.isMultiPoint(symbolID) ? this._SPR.RenderSP2(symbolID, modifiers, attributes) : this._SPR.RenderSP2(symbolID, null, attributes);
            }
        } else {
            temp = ss == 45 || ss == 46 || ss == 47 ? this._SPR.RenderSP2(symbolID, modifiers, attributes) : this._SPR.RenderUnit2(symbolID, modifiers, attributes);
        }
        return temp;
    }

    public SVGSymbolInfo RenderSVG(String symbolID, Map<String, String> modifiers, Map<String, String> attributes) {
        int ss = SymbolID.getSymbolSet(symbolID);
        Object temp = null;
        SVGSymbolInfo svgTemp = null;
        MSInfo msi = MSLookup.getInstance().getMSLInfo(symbolID);
        if (msi == null) {
            // empty if block
        }
        if (msi != null && msi.getDrawRule() == 0) {
            return null;
        }
        if (ss == 25) {
            if (msi != null) {
                svgTemp = !SymbolUtilities.isMultiPoint(symbolID) ? this._SPSVGR.RenderSP(symbolID, modifiers, attributes) : this._SPSVGR.RenderSP(symbolID, null, attributes);
            }
        } else {
            svgTemp = ss == 45 || ss == 46 || ss == 47 ? this._SPSVGR.RenderSP(symbolID, modifiers, attributes) : this._SPSVGR.RenderUnit(symbolID, modifiers, attributes);
        }
        return svgTemp;
    }

    public String getRendererID() {
        return "milstd2525";
    }

    private Map<String, String> getDefaultAttributes(String symbolID) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (symbolID == null || symbolID.length() != 15) {
                if (symbolID == null) {
                    symbolID = "null";
                }
                ErrorLogger.LogMessage("MilStdIconRenderer", "getDefaultAttributes", "getDefaultAttributes passed bad symbolID: " + symbolID);
                return null;
            }
            map.put("ALPHA", "255");
            if (SymbolUtilities.hasDefaultFill(symbolID)) {
                map.put("FILLCOLOR", RendererUtilities.colorToHexString(SymbolUtilities.getFillColorOfAffiliation(symbolID), false));
            }
            map.put("LINECOLOR", RendererUtilities.colorToHexString(SymbolUtilities.getLineColorOfAffiliation(symbolID), false));
            map.put("OUTLINESYMBOL", "false");
            map.put("DRAWASICON", "false");
            RendererSettings rs = RendererSettings.getInstance();
            map.put("KEEPUNITRATIO", "true");
            return map;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdIconRenderer", "getDefaultAttributes", exc);
            return map;
        }
    }

    public boolean AddCustomSymbol(MSInfo msInfo, SVGInfo svgInfo) {
        boolean success = false;
        if (msInfo.getBasicSymbolID().equals(svgInfo.getID())) {
            if (MSLookup.getInstance().getMSLInfo(msInfo.getBasicSymbolID(), msInfo.getVersion()) == null && SVGLookup.getInstance().getSVGLInfo(svgInfo.getID(), msInfo.getVersion()) == null && MSLookup.getInstance().addCustomSymbol(msInfo)) {
                success = SVGLookup.getInstance().addCustomSymbol(svgInfo, msInfo.getVersion());
            }
        } else {
            ErrorLogger.LogMessage("Symbol Set and Entity Codes do not match", Level.INFO, false);
        }
        return success;
    }
}

