/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.tester;

import armyc2.c5isr.RenderMultipoints.clsRenderer;
import armyc2.c5isr.renderer.MilStdIconRenderer;
import armyc2.c5isr.renderer.SinglePointRenderer;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.renderer.utilities.ImageInfo;
import armyc2.c5isr.renderer.utilities.MSInfo;
import armyc2.c5isr.renderer.utilities.MSLookup;
import armyc2.c5isr.renderer.utilities.MilStdSymbol;
import armyc2.c5isr.renderer.utilities.Modifier;
import armyc2.c5isr.renderer.utilities.PointConversion;
import armyc2.c5isr.renderer.utilities.RendererException;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.SVGInfo;
import armyc2.c5isr.renderer.utilities.SVGLookup;
import armyc2.c5isr.renderer.utilities.SVGSymbolInfo;
import armyc2.c5isr.renderer.utilities.SymbolDraw;
import armyc2.c5isr.renderer.utilities.SymbolID;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import armyc2.c5isr.web.render.WebRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class Tester
extends JFrame {
    int drawMode = 0;
    int drawModeSPDraw = 1;
    int drawModeMPDraw = 2;
    int maxPointCount = 1;
    ArrayList<Point2D> points = new ArrayList();
    String currentBasicID = "";
    private JButton btnDraw;
    private JButton btnDrawMP;
    private JButton btnSpeedTest;
    private JComboBox<String> cbAffiliation;
    private JComboBox<String> cbAmplifier;
    private JCheckBox cbCache;
    private JComboBox<String> cbContext;
    private JComboBox<String> cbFrameShape;
    private JComboBox<String> cbHQTFD;
    private JCheckBox cbModifiers;
    private JComboBox<String> cbOutlineStyle;
    private JComboBox<String> cbPixelSize;
    private JComboBox<String> cbS1I;
    private JComboBox<String> cbS2I;
    private JComboBox<String> cbStatus;
    private JComboBox<String> cbVersion;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel lblAffiliation;
    private JLabel lblAmplifier;
    private JLabel lblContext;
    private JLabel lblFrameShape;
    private JLabel lblHQTFD;
    private JLabel lblLineWidth;
    private JLabel lblPixelSize;
    private JLabel lblS1I;
    private JLabel lblS2I;
    private JLabel lblSector1Mod;
    private JLabel lblSector2Mod;
    private JLabel lblStatus;
    private JLabel lblVersion;
    private JTree msTree;
    private JTextField tfLineWidth;
    private JTextField tfSector1Mod;
    private JTextField tfSector2Mod;
    private JTextField tfSymbolID;

    public Tester() {
        this.initComponents();
        this.init();
    }

    private void init() {
        try {
            this.loadTree(11);
            this.setCBItems();
            this.cbPixelSize.setSelectedIndex(1);
            SinglePointRenderer.getInstance();
            SVGLookup.getInstance();
            RendererSettings.getInstance().setCacheEnabled(false);
            RendererSettings.getInstance().setActionPointDefaultFill(true);
            RendererSettings.getInstance().setScaleMainIcon(true);
            MSInfo miBase = MSLookup.getInstance().getMSLInfo("10110000", 13);
            MSInfo mi = new MSInfo(13, "10", "Sustainment", "TEST", "", "165700", miBase.getModifiers());
            SVGInfo si = new SVGInfo("10165700", new Rectangle2D.Double(198.0, 365.0, 215.0, 64.0), "<g id=\"10165700\"><text font-family=\"sans-serif\" fill=\"red\" font-size=\"89\" x=\"192\" y=\"428\">MWR</text></g>");
            MilStdIconRenderer.getInstance().AddCustomSymbol(mi, si);
        }
        catch (Exception exc) {
            ErrorLogger.LogException("Tester", "init", exc, Level.WARNING);
        }
    }

    private void updatedSymbolIDField() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.msTree.getLastSelectedPathComponent();
        if (node == null) {
            this.tfSymbolID.setText("");
            return;
        }
        if (node.isLeaf()) {
            MSNodeInfo nodeInfo;
            MSNodeInfo msni = nodeInfo = (MSNodeInfo)node.getUserObject();
            String symbolID = this.buildSymbolID(msni.msID);
            this.tfSymbolID.setText(symbolID);
        }
    }

    private String buildSymbolID(String basicID) {
        String id = this.cbVersion.getSelectedItem().toString().split("-")[0];
        id = id + this.cbContext.getSelectedItem().toString().split("-")[0];
        id = id + this.cbAffiliation.getSelectedItem().toString().split("-")[0];
        id = id + basicID.substring(0, 2);
        id = id + this.cbStatus.getSelectedItem().toString().split("-")[0];
        id = id + this.cbHQTFD.getSelectedItem().toString().split("-")[0];
        id = id + this.cbAmplifier.getSelectedItem().toString().split("-")[0];
        id = id + basicID.substring(2);
        String s1m = this.tfSector1Mod.getText();
        id = s1m.length() == 2 ? id + s1m : id + "00";
        String s2m = this.tfSector2Mod.getText();
        id = s2m.length() == 2 ? id + s2m : id + "00";
        id = id + this.cbS1I.getSelectedItem().toString();
        id = id + this.cbS2I.getSelectedItem().toString();
        String fs = this.cbFrameShape.getSelectedItem().toString().split("-")[0];
        id = Integer.parseInt(id.substring(0, 2)) >= 13 ? id + fs + "0000" : id + "00000";
        id = this.cbModifiers.isSelected() ? id + "840" : id + "000";
        return id;
    }

    private void copyToClipboard(String value) {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection strse1 = new StringSelection(value);
        clip.setContents(strse1, strse1);
    }

    private void loadTree(int version) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.msTree.getModel().getRoot();
        if (version < 13) {
            root.setUserObject("2525D");
        } else if (version >= 13) {
            root.setUserObject("2525E");
        }
        DefaultMutableTreeNode msn00 = new DefaultMutableTreeNode(new MSNodeInfo("00", "Unknown"));
        DefaultMutableTreeNode msn01 = new DefaultMutableTreeNode(new MSNodeInfo("01", "Air"));
        DefaultMutableTreeNode msn02 = new DefaultMutableTreeNode(new MSNodeInfo("02", "Air Missile"));
        DefaultMutableTreeNode msn51 = new DefaultMutableTreeNode(new MSNodeInfo("51", "Air SIGINT"));
        DefaultMutableTreeNode msn05 = new DefaultMutableTreeNode(new MSNodeInfo("05", "Space"));
        DefaultMutableTreeNode msn06 = new DefaultMutableTreeNode(new MSNodeInfo("06", "Space Missile"));
        DefaultMutableTreeNode msn50 = new DefaultMutableTreeNode(new MSNodeInfo("50", "Space SIGINT"));
        if (version >= 13) {
            msn50 = new DefaultMutableTreeNode(new MSNodeInfo("50", "SIGINT"));
        }
        DefaultMutableTreeNode msn10 = new DefaultMutableTreeNode(new MSNodeInfo("10", "Land Unit"));
        DefaultMutableTreeNode msn11 = new DefaultMutableTreeNode(new MSNodeInfo("11", "Land Civ"));
        DefaultMutableTreeNode msn15 = new DefaultMutableTreeNode(new MSNodeInfo("15", "Land Equipment"));
        DefaultMutableTreeNode msn52 = new DefaultMutableTreeNode(new MSNodeInfo("52", "Land SIGINT"));
        DefaultMutableTreeNode msn20 = new DefaultMutableTreeNode(new MSNodeInfo("20", "Land Installation"));
        DefaultMutableTreeNode msn27 = new DefaultMutableTreeNode(new MSNodeInfo("20", "Dismounted Individual"));
        DefaultMutableTreeNode msn30 = new DefaultMutableTreeNode(new MSNodeInfo("30", "Sea Surface"));
        DefaultMutableTreeNode msn53 = new DefaultMutableTreeNode(new MSNodeInfo("53", "Sea Surface SIGINT"));
        DefaultMutableTreeNode msn35 = new DefaultMutableTreeNode(new MSNodeInfo("35", "Sea Subsurface"));
        DefaultMutableTreeNode msn36 = new DefaultMutableTreeNode(new MSNodeInfo("36", "Mine Warfare"));
        DefaultMutableTreeNode msn54 = new DefaultMutableTreeNode(new MSNodeInfo("54", "Sea Subsurface SIGINT"));
        DefaultMutableTreeNode msn40 = new DefaultMutableTreeNode(new MSNodeInfo("40", "Activities"));
        DefaultMutableTreeNode msn25 = new DefaultMutableTreeNode(new MSNodeInfo("25", "Control Measure"));
        DefaultMutableTreeNode msn45 = new DefaultMutableTreeNode(new MSNodeInfo("45", "Atmospheric"));
        DefaultMutableTreeNode msn46 = new DefaultMutableTreeNode(new MSNodeInfo("46", "Oceanographic"));
        DefaultMutableTreeNode msn47 = new DefaultMutableTreeNode(new MSNodeInfo("47", "Meteorological Space"));
        DefaultMutableTreeNode msn60 = new DefaultMutableTreeNode(new MSNodeInfo("60", "Cyberspace"));
        DefaultMutableTreeNode MSNI = null;
        List<String> IDs = MSLookup.getInstance().getIDList(version);
        try {
            String name = null;
            MSInfo msi = null;
            for (String id : IDs) {
                msi = id.length() == 8 ? MSLookup.getInstance().getMSLInfo(id, version) : null;
                if (msi == null || msi.getDrawRule() == 0) continue;
                name = msi.getName();
                MSNI = new DefaultMutableTreeNode(new MSNodeInfo(id, name));
                if (id.startsWith("00")) {
                    msn00.add(MSNI);
                    continue;
                }
                if (id.startsWith("01")) {
                    msn01.add(MSNI);
                    continue;
                }
                if (id.startsWith("02")) {
                    msn02.add(MSNI);
                    continue;
                }
                if (id.startsWith("51")) {
                    msn51.add(MSNI);
                    continue;
                }
                if (id.startsWith("05")) {
                    msn05.add(MSNI);
                    continue;
                }
                if (id.startsWith("06")) {
                    msn06.add(MSNI);
                    continue;
                }
                if (id.startsWith("50")) {
                    msn50.add(MSNI);
                    continue;
                }
                if (id.startsWith("10")) {
                    msn10.add(MSNI);
                    continue;
                }
                if (id.startsWith("11")) {
                    msn11.add(MSNI);
                    continue;
                }
                if (id.startsWith("15")) {
                    msn15.add(MSNI);
                    continue;
                }
                if (id.startsWith("52")) {
                    msn52.add(MSNI);
                    continue;
                }
                if (id.startsWith("20")) {
                    msn20.add(MSNI);
                    continue;
                }
                if (id.startsWith("27")) {
                    msn27.add(MSNI);
                    continue;
                }
                if (id.startsWith("30")) {
                    msn30.add(MSNI);
                    continue;
                }
                if (id.startsWith("53")) {
                    msn53.add(MSNI);
                    continue;
                }
                if (id.startsWith("35")) {
                    msn35.add(MSNI);
                    continue;
                }
                if (id.startsWith("36")) {
                    msn36.add(MSNI);
                    continue;
                }
                if (id.startsWith("54")) {
                    msn54.add(MSNI);
                    continue;
                }
                if (id.startsWith("40")) {
                    msn40.add(MSNI);
                    continue;
                }
                if (id.startsWith("25")) {
                    msn25.add(MSNI);
                    continue;
                }
                if (id.startsWith("45")) {
                    msn45.add(MSNI);
                    continue;
                }
                if (id.startsWith("46")) {
                    msn46.add(MSNI);
                    continue;
                }
                if (id.startsWith("47")) {
                    msn47.add(MSNI);
                    continue;
                }
                if (!id.startsWith("60")) continue;
                msn60.add(MSNI);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("Tester", "loadTree", exc);
        }
        root.add(msn00);
        root.add(msn01);
        root.add(msn02);
        if (version < 13) {
            root.add(msn51);
        }
        root.add(msn05);
        root.add(msn06);
        root.add(msn50);
        root.add(msn10);
        root.add(msn11);
        root.add(msn15);
        if (version < 13) {
            root.add(msn52);
        }
        root.add(msn20);
        if (version >= 13) {
            root.add(msn27);
        }
        root.add(msn30);
        if (version < 13) {
            root.add(msn53);
        }
        root.add(msn35);
        root.add(msn36);
        if (version < 13) {
            root.add(msn54);
        }
        root.add(msn40);
        root.add(msn25);
        root.add(msn45);
        root.add(msn46);
        root.add(msn47);
        root.add(msn60);
        this.msTree.getSelectionModel().setSelectionMode(1);
    }

    private void setCBItems() {
        this.cbVersion.addItem("11-2525D");
        this.cbVersion.addItem("13-2525E");
        this.cbVersion.setSelectedIndex(0);
        this.cbContext.addItem("0-Reality");
        this.cbContext.addItem("1-Exercise");
        this.cbContext.addItem("2-Simulation");
        this.cbContext.addItem("3-Restricted");
        this.cbContext.addItem("4-No-Strike");
        this.cbContext.setSelectedIndex(0);
        this.cbAffiliation.addItem("0-Pending");
        this.cbAffiliation.addItem("1-Unknown");
        this.cbAffiliation.addItem("2-Assumed Friend");
        this.cbAffiliation.addItem("3-Friend");
        this.cbAffiliation.addItem("4-Neutral");
        this.cbAffiliation.addItem("5-Suspect/Joker");
        this.cbAffiliation.addItem("6-Hostile/Faker");
        this.cbAffiliation.setSelectedIndex(3);
        this.cbStatus.addItem("0-Present");
        this.cbStatus.addItem("1-Planned/Anticipated/Suspect");
        this.cbStatus.addItem("2-Fully capabable");
        this.cbStatus.addItem("3-Damaged");
        this.cbStatus.addItem("4-Destroyed");
        this.cbStatus.addItem("5-Full to capacity");
        this.cbStatus.setSelectedIndex(0);
        this.cbHQTFD.addItem("0-Unknown");
        this.cbHQTFD.addItem("1-Dummy");
        this.cbHQTFD.addItem("2-HQ");
        this.cbHQTFD.addItem("3-D/HQ");
        this.cbHQTFD.addItem("4-TF");
        this.cbHQTFD.addItem("5-D/TF");
        this.cbHQTFD.addItem("6-TF/HQ");
        this.cbHQTFD.addItem("7-D/TF/HQ");
        this.cbHQTFD.setSelectedIndex(0);
        this.cbAmplifier.addItem("00-Unknown");
        this.cbAmplifier.addItem("11-Team/Crew");
        this.cbAmplifier.addItem("12-Squad");
        this.cbAmplifier.addItem("13-Section");
        this.cbAmplifier.addItem("14-Platoon/detachment");
        this.cbAmplifier.addItem("15-Company/battery/troop");
        this.cbAmplifier.addItem("16-Battalion/squadron");
        this.cbAmplifier.addItem("17-Regiment/group");
        this.cbAmplifier.addItem("18-Brigade");
        this.cbAmplifier.addItem("21-Division");
        this.cbAmplifier.addItem("22-Corps/MEF");
        this.cbAmplifier.addItem("23-Army");
        this.cbAmplifier.addItem("24-Army Group/front");
        this.cbAmplifier.addItem("25-Region/Theater");
        this.cbAmplifier.addItem("26-Command");
        this.cbAmplifier.addItem("31-Wheeled limited Cross country");
        this.cbAmplifier.addItem("32-Wheeled cross country");
        this.cbAmplifier.addItem("33-Tracked");
        this.cbAmplifier.addItem("34-Wheeled & Tracked");
        this.cbAmplifier.addItem("35-Towed");
        this.cbAmplifier.addItem("36-Rail");
        this.cbAmplifier.addItem("37-Pack Animals");
        this.cbAmplifier.addItem("41-Over Snow");
        this.cbAmplifier.addItem("42-Sled");
        this.cbAmplifier.addItem("51-Barge");
        this.cbAmplifier.addItem("52-Amphibious");
        this.cbAmplifier.addItem("61-Short towed Array");
        this.cbAmplifier.addItem("62-Long towed Array");
        this.cbAmplifier.addItem("71-Leadership Indicator");
        this.cbAmplifier.setSelectedIndex(0);
    }

    private Map<String, String> populateModifiers(String symbolID) {
        HashMap<String, String> modifier = new HashMap<String, String>();
        try {
            MSInfo msInfo = MSLookup.getInstance().getMSLInfo(symbolID);
            modifier.put("H_ADDITIONAL_INFO_1", "H");
            modifier.put("H1_ADDITIONAL_INFO_2", "H1");
            modifier.put("AP_TARGET_NUMBER", "AP");
            modifier.put("AP1_TARGET_NUMBER_EXTENSION", "AP1");
            modifier.put("X_ALTITUDE_DEPTH", "0,10");
            modifier.put("K_COMBAT_EFFECTIVENESS", "100");
            modifier.put("Q_DIRECTION_OF_MOVEMENT", "90");
            modifier.put("W_DTG_1", SymbolUtilities.getDateLabel(new Date()));
            modifier.put("W1_DTG_2", SymbolUtilities.getDateLabel(new Date()));
            modifier.put("J_EVALUATION_RATING", "J");
            modifier.put("M_HIGHER_FORMATION", "M");
            modifier.put("N_HOSTILE", "ENY");
            modifier.put("P_IFF_SIF_AIS", "Pj");
            modifier.put("Y_LOCATION", "Y");
            modifier.put("C_QUANTITY", "C");
            modifier.put("F_REINFORCED_REDUCED", "RD");
            modifier.put("L_SIGNATURE_EQUIP", "!");
            if (SymbolID.getSymbolSet(symbolID) == 10 && SymbolID.getEntityCode(symbolID) == 110000) {
                modifier.put("AA_SPECIAL_C2_HQ", "AA");
            }
            modifier.put("G_STAFF_COMMENTS", "Gj");
            modifier.put("V_EQUIP_TYPE", "Vj");
            modifier.put("T_UNIQUE_DESIGNATION_1", "Tj");
            modifier.put("T1_UNIQUE_DESIGNATION_2", "T1");
            modifier.put("Z_SPEED", "999");
            modifier.put("R2_SIGNIT_MOBILITY_INDICATOR", "2");
            modifier.put("AD_PLATFORM_TYPE", "AD");
            modifier.put("AE_EQUIPMENT_TEARDOWN_TIME", "AE");
            modifier.put("AF_COMMON_IDENTIFIER", "AF");
            modifier.put("AJ_SPEED_LEADER", "600 KPH 045");
            modifier.put("AO_ENGAGEMENT_BAR", "AO:AOA-AO");
            modifier.put("AR_SPECIAL_DESIGNATOR", "AR");
            modifier.put("AQ_GUARDED_UNIT", "AQ");
            if (msInfo != null && msInfo.getSymbolSet() == 25) {
                int drawRule = msInfo.getDrawRule();
                if (drawRule == 217) {
                    modifier.put("AM_DISTANCE", "1500,1000");
                    modifier.put("AN_AZIMUTH", "45");
                } else if (drawRule == 218) {
                    modifier.put("AM_DISTANCE", "1000,1500");
                    modifier.put("AN_AZIMUTH", "45,90");
                } else if (drawRule == 401) {
                    modifier.put("AM_DISTANCE", "1000");
                    modifier.put("X_ALTITUDE_DEPTH", "0,10");
                } else if (drawRule == 701) {
                    modifier.put("AM_DISTANCE", "1000,1500");
                    modifier.put("AN_AZIMUTH", "45");
                }
                if (drawRule == 801) {
                    modifier.put("AM_DISTANCE", "1000");
                } else if (drawRule == 802) {
                    modifier.put("AM_DISTANCE", "1000,6000");
                    modifier.put("AN_AZIMUTH", "45");
                } else if (drawRule == 803) {
                    modifier.put("AM_DISTANCE", "1000");
                } else if (drawRule == 901) {
                    modifier.put("AM_DISTANCE", "1000");
                } else if (drawRule == 902) {
                    modifier.put("AM_DISTANCE", "750,1000,1500");
                    modifier.put("X_ALTITUDE_DEPTH", "0,10,100");
                } else if (drawRule == 1001) {
                    modifier.put("AM_DISTANCE", "1000,1500,2200,3200,3500");
                    modifier.put("AN_AZIMUTH", "290,30,290,30,315,30,315,35");
                    modifier.put("X_ALTITUDE_DEPTH", "0,10,100,200");
                }
            }
            if (msInfo == null) {
                ErrorLogger.LogMessage("PopulateModifier: No MSInfo for " + symbolID);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("Tester", "populateModifiers", exc);
        }
        return modifier;
    }

    private void setModifiers_AM_AN_X(MilStdSymbol msd) {
        for (String mod : msd.getModifierMap().keySet()) {
            String[] arrValues;
            if (mod != "X_ALTITUDE_DEPTH" && mod != "AM_DISTANCE" && mod != "AN_AZIMUTH") continue;
            ArrayList<Double> values = new ArrayList<Double>();
            for (String v : arrValues = String.valueOf(msd.getModifierMap().get(mod)).split(",")) {
                if (v.isEmpty()) continue;
                values.add(Double.parseDouble(v));
            }
            msd.setModifiers_AM_AN_X(mod, values);
        }
    }

    private Map<String, String> populateDefaultAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("PIXELSIZE", "50");
        attributes.put("MODIFIERPLACEMENT", String.valueOf(RendererSettings.ModifierPlacement_FLEXIBLE));
        return attributes;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.msTree = new JTree();
        this.lblVersion = new JLabel();
        this.cbVersion = new JComboBox();
        this.lblContext = new JLabel();
        this.cbContext = new JComboBox();
        this.lblAffiliation = new JLabel();
        this.cbAffiliation = new JComboBox();
        this.lblStatus = new JLabel();
        this.cbStatus = new JComboBox();
        this.lblHQTFD = new JLabel();
        this.cbHQTFD = new JComboBox();
        this.lblAmplifier = new JLabel();
        this.cbAmplifier = new JComboBox();
        this.lblSector1Mod = new JLabel();
        this.lblSector2Mod = new JLabel();
        this.tfSector1Mod = new JTextField();
        this.tfSector2Mod = new JTextField();
        this.btnDraw = new JButton();
        this.btnDrawMP = new JButton();
        this.tfSymbolID = new JTextField();
        this.cbPixelSize = new JComboBox();
        this.lblPixelSize = new JLabel();
        this.cbModifiers = new JCheckBox();
        this.btnSpeedTest = new JButton();
        this.cbOutlineStyle = new JComboBox();
        this.cbCache = new JCheckBox();
        this.lblS1I = new JLabel();
        this.cbS1I = new JComboBox();
        this.lblS2I = new JLabel();
        this.cbS2I = new JComboBox();
        this.lblLineWidth = new JLabel();
        this.tfLineWidth = new JTextField();
        this.lblFrameShape = new JLabel();
        this.cbFrameShape = new JComboBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("Tester");
        this.setMinimumSize(new Dimension(1200, 900));
        this.setPreferredSize(new Dimension(1200, 900));
        this.setSize(new Dimension(1200, 900));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Tester.this.formMouseClicked(evt);
            }
        });
        this.jPanel1.setBackground(new Color(0, 153, 153));
        this.jPanel1.setPreferredSize(new Dimension(1100, 819));
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("2525D");
        this.msTree.setModel(new DefaultTreeModel(treeNode1));
        this.msTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                Tester.this.msTreeValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.msTree);
        this.lblVersion.setText("Version:");
        this.cbVersion.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Tester.this.cbVersionItemStateChanged(evt);
            }
        });
        this.lblContext.setText("Context:");
        this.cbContext.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Tester.this.cbContextItemStateChanged(evt);
            }
        });
        this.lblAffiliation.setText("Affiliation");
        this.cbAffiliation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Tester.this.cbAffiliationItemStateChanged(evt);
            }
        });
        this.lblStatus.setText("Status:");
        this.cbStatus.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Tester.this.cbModifiersItemStateChanged(evt);
            }
        });
        this.lblHQTFD.setText("HQTFD:");
        this.cbHQTFD.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Tester.this.cbHQTFDItemStateChanged(evt);
            }
        });
        this.lblAmplifier.setText("Amplifier:");
        this.cbAmplifier.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Tester.this.cbAmplifierItemStateChanged(evt);
            }
        });
        this.lblSector1Mod.setText("Sector1 Mod:");
        this.lblSector2Mod.setText("Sector2 Mod:");
        this.tfSector1Mod.setText("00");
        this.tfSector1Mod.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Tester.this.tfSector1ModKeyReleased(evt);
            }
        });
        this.tfSector2Mod.setText("00");
        this.tfSector2Mod.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Tester.this.tfSector2ModKeyReleased(evt);
            }
        });
        this.btnDraw.setText("Draw Icon");
        this.btnDraw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Tester.this.btnDrawActionPerformed(evt);
            }
        });
        this.btnDrawMP.setText("Draw Symbol");
        this.btnDrawMP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Tester.this.btnDrawMPActionPerformed(evt);
            }
        });
        this.tfSymbolID.setEditable(false);
        this.tfSymbolID.setText("Symbol ID");
        this.cbPixelSize.setModel(new DefaultComboBoxModel<String>(new String[]{"25", "50", "75", "100", "200"}));
        this.lblPixelSize.setText("Pixel Size");
        this.cbModifiers.setText("Modifiers");
        this.cbModifiers.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Tester.this.cbAffiliationItemStateChanged(evt);
            }
        });
        this.btnSpeedTest.setText("Speed Test");
        this.btnSpeedTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Tester.this.btnSpeedTestActionPerformed(evt);
            }
        });
        this.cbOutlineStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"OutlineQ", "Outline", "ColorFill", "None"}));
        this.cbOutlineStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Tester.this.cbOutlineStyleActionPerformed(evt);
            }
        });
        this.cbCache.setText("Cache");
        this.cbCache.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Tester.this.cbCacheItemStateChanged(evt);
            }
        });
        this.lblS1I.setText("S1 Ind:");
        this.cbS1I.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}));
        this.cbS1I.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Tester.this.cbS1IItemStateChanged(evt);
            }
        });
        this.lblS2I.setText("S2 Ind:");
        this.cbS2I.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}));
        this.cbS2I.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Tester.this.cbS2IItemStateChanged(evt);
            }
        });
        this.lblLineWidth.setText("Line Width");
        this.tfLineWidth.setText("5");
        this.lblFrameShape.setText("Frame Shape:");
        this.cbFrameShape.setModel(new DefaultComboBoxModel<String>(new String[]{"0-Unknown", "1-Space", "2-Air", "3-Land U", "4-Land Equip", "5-Land Inst", "6-Dis. Ind.", "7-Sea Sub.", "8-Activity", "9-Cyber", "A-SeaSurface"}));
        this.cbFrameShape.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Tester.this.cbFrameShapePropertyChange(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 217, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSymbolID)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.lblVersion).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbVersion, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblContext).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbContext, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAffiliation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAffiliation, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbStatus, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblS1I, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbS1I, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblS2I, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbS2I, -2, 44, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.lblHQTFD).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbHQTFD, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAmplifier).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAmplifier, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSector1Mod).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSector1Mod, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSector2Mod).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSector2Mod, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblFrameShape, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbFrameShape, -2, 200, -2))).addGap(0, 42, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel1Layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.cbCache, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnDraw)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnSpeedTest).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnDrawMP)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblPixelSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPixelSize, -2, -1, -2))).addGap(16, 16, 16)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblLineWidth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbModifiers).addComponent(this.tfLineWidth, -2, 71, -2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.cbOutlineStyle, -2, -1, -2).addGap(2, 2, 2))).addGap(14, 14, 14)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 493, -2).addComponent(this.tfSymbolID, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 142, Short.MAX_VALUE).addComponent(this.cbModifiers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbOutlineStyle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfLineWidth, -2, -1, -2).addComponent(this.lblLineWidth)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbPixelSize, -2, -1, -2).addComponent(this.lblPixelSize)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblVersion).addComponent(this.cbVersion, -2, -1, -2).addComponent(this.lblContext).addComponent(this.cbContext, -2, -1, -2).addComponent(this.lblAffiliation).addComponent(this.cbAffiliation, -2, -1, -2).addComponent(this.lblStatus).addComponent(this.cbStatus, -2, -1, -2).addComponent(this.btnDraw).addComponent(this.cbCache).addComponent(this.lblS1I).addComponent(this.cbS1I, -2, -1, -2).addComponent(this.lblS2I).addComponent(this.cbS2I, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblHQTFD).addComponent(this.cbHQTFD, -2, -1, -2).addComponent(this.lblAmplifier).addComponent(this.cbAmplifier, -2, -1, -2).addComponent(this.lblSector1Mod).addComponent(this.lblSector2Mod).addComponent(this.tfSector1Mod, -2, -1, -2).addComponent(this.tfSector2Mod, -2, -1, -2).addComponent(this.lblFrameShape).addComponent(this.cbFrameShape, -2, -1, -2).addComponent(this.btnSpeedTest).addComponent(this.btnDrawMP)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void btnDrawActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.msTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        MSNodeInfo nodeInfo = (MSNodeInfo)node.getUserObject();
        if (node.isLeaf()) {
            MSNodeInfo msni = nodeInfo;
            String symbolID = this.buildSymbolID(msni.msID);
            this.drawMode = this.drawModeSPDraw;
            this.points.clear();
            this.btnDrawMP.setText("Draw Symbol");
            this.btnDraw.setBackground(Color.GREEN);
            this.btnDrawMP.setBackground(Color.LIGHT_GRAY);
        }
    }

    private void formMouseClicked(MouseEvent evt) {
        String symbolID = null;
        ImageInfo icon = null;
        Map<String, String> modifiers = null;
        Map<String, String> attributes = null;
        if (this.drawMode == this.drawModeSPDraw) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.msTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            MSNodeInfo nodeInfo = (MSNodeInfo)node.getUserObject();
            if (node.isLeaf()) {
                MSNodeInfo msni = nodeInfo;
                symbolID = this.buildSymbolID(msni.msID);
                this.drawMode = 0;
                this.btnDraw.setBackground(Color.LIGHT_GRAY);
                this.btnDrawMP.setBackground(Color.LIGHT_GRAY);
            }
            if (symbolID != null) {
                modifiers = new HashMap<String, String>();
                if (this.cbModifiers.isSelected()) {
                    modifiers = this.populateModifiers(symbolID);
                }
                attributes = this.populateDefaultAttributes();
                String pixelSize = String.valueOf(this.cbPixelSize.getSelectedItem());
                attributes.put("PIXELSIZE", pixelSize);
                try {
                    icon = MilStdIconRenderer.getInstance().RenderIcon(symbolID, modifiers, attributes);
                    MSInfo msi = MSLookup.getInstance().getMSLInfo(symbolID);
                    Graphics2D g2d = (Graphics2D)this.getGraphics();
                    Graphics2D graphics = (Graphics2D)this.jPanel1.getGraphics();
                    Point2D.Double mouseClickLocation = new Point2D.Double(evt.getPoint().getX(), evt.getPoint().getY());
                    if (icon != null) {
                        SymbolDraw.Draw(icon, g2d, (int)(((Point2D)mouseClickLocation).getX() - (double)icon.getSymbolCenterX()), (int)(((Point2D)mouseClickLocation).getY() - (double)icon.getSymbolCenterY()));
                    } else {
                        String message = "RenderIcon - " + symbolID + " returned null.";
                        ErrorLogger.LogMessage("Tester", "formMouseClicked", message);
                    }
                }
                catch (RendererException rexc) {
                    ErrorLogger.LogException("Tester", "formMouseClicked", rexc);
                }
                catch (Exception exc) {
                    ErrorLogger.LogException("Tester", "formMouseClicked", exc);
                }
                this.drawMode = 0;
                this.btnDraw.setBackground(Color.LIGHT_GRAY);
                this.btnDrawMP.setBackground(Color.LIGHT_GRAY);
            }
            String svg = MilStdIconRenderer.getInstance().RenderSVG(symbolID, modifiers, attributes).getSVG();
            this.copyToClipboard(svg);
            System.out.println(svg);
        } else if (this.drawMode == this.drawModeMPDraw) {
            MSNodeInfo nodeInfo;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.msTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            MSNodeInfo msni = nodeInfo = (MSNodeInfo)node.getUserObject();
            symbolID = this.buildSymbolID(msni.msID);
            MSInfo msi = MSLookup.getInstance().getMSLInfo(symbolID);
            if (msi.getDrawRule() != 0) {
                Point2D.Double mouseClickLocation = new Point2D.Double(evt.getPoint().getX(), evt.getPoint().getY());
                this.points.add(mouseClickLocation);
                this.btnDrawMP.setText("Points: " + this.points.size() + "         ");
                if (this.points.size() == this.maxPointCount) {
                    this.RenderMultiPoint();
                }
            }
        }
    }

    private void RenderMultiPoint() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.msTree.getLastSelectedPathComponent();
        MSNodeInfo msni = (MSNodeInfo)node.getUserObject();
        String symbolID = this.buildSymbolID(msni.msID);
        MSInfo msi = MSLookup.getInstance().getMSLInfo(symbolID);
        int height = this.getHeight();
        int width = this.getWidth();
        ErrorLogger.LogMessage("panel w,h" + String.valueOf(width) + "," + String.valueOf(height));
        Map<String, String> modifiers = this.populateModifiers(symbolID);
        double geoLeft = 49.9;
        double geoRight = 50.0;
        double geoTop = 20.0;
        double geoBottom = geoTop - (geoRight - geoLeft) * (double)height / (double)width;
        PointConversion pConverter = new PointConversion(width, height, geoTop, geoLeft, geoBottom, geoRight);
        ArrayList<Point2D> coords = new ArrayList<Point2D>();
        for (Point2D pt : this.points) {
            coords.add(pConverter.PixelsToGeo(pt));
        }
        MilStdSymbol ms = new MilStdSymbol(symbolID, "id", coords, modifiers);
        this.setModifiers_AM_AN_X(ms);
        ms.setUseFillPattern(true);
        ms.setUnitSize(Integer.valueOf(this.cbPixelSize.getSelectedItem().toString()));
        ms.setLineWidth(Integer.valueOf(this.tfLineWidth.getText()));
        RendererSettings.getInstance().setDeviceDPI(Toolkit.getDefaultToolkit().getScreenResolution());
        ms = this.render(ms, pConverter, null);
        Graphics2D graphics = (Graphics2D)this.getGraphics();
        try {
            SymbolDraw.Draw(ms, graphics, 0, 0);
        }
        catch (RendererException rexc) {
            ErrorLogger.LogException("Tester", "formMouseClicked", rexc);
        }
        catch (Exception exc) {
            ErrorLogger.LogException("Tester", "formMouseClicked", exc);
        }
        this.drawMode = 0;
        this.btnDraw.setBackground(Color.LIGHT_GRAY);
        this.btnDrawMP.setBackground(Color.LIGHT_GRAY);
        this.btnDrawMP.setText("Draw Symbol");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("LINEWIDTH", String.valueOf(ms.getLineWidth()));
        int format = 2;
        this.renderWebFormat(msi, symbolID, ms, pConverter, modifiers, attributes, format);
        this.points.clear();
    }

    private void renderWebFormat(MSInfo msi, String symbolID, MilStdSymbol ms, PointConversion pc, Map<String, String> modifiers, Map<String, String> attributes, int format) {
        String points = "";
        String bbox = String.valueOf(pc.getLeftLon()) + "," + String.valueOf(pc.getLowerLat()) + "," + String.valueOf(pc.getRightLon()) + "," + String.valueOf(pc.getUpperLat());
        String svg = null;
        String kml = null;
        String result = null;
        String result3D = null;
        ArrayList<Point2D> coords = ms.getCoordinates();
        for (Point2D point : coords) {
            points = points + String.valueOf(point.getX()) + "," + String.valueOf(point.getY()) + " ";
        }
        try {
            result = WebRenderer.RenderSymbol2D("id", msi.getName(), msi.getPath(), symbolID, points, pc.getPixelWidth(), pc.getPixelHeight(), bbox, modifiers, attributes, format);
            kml = WebRenderer.RenderSymbol2D("id", msi.getName(), msi.getPath(), symbolID, points, pc.getPixelWidth(), pc.getPixelHeight(), bbox, modifiers, attributes, 0);
            svg = WebRenderer.RenderSymbol2D("id", msi.getName(), msi.getPath(), symbolID, points, pc.getPixelWidth(), pc.getPixelHeight(), bbox, modifiers, attributes, 3);
            String altMode = "clampToGround";
            double scale = 50000.0;
            result3D = WebRenderer.RenderSymbol("id", msi.getName(), msi.getPath(), ms.getSymbolID(), points, altMode, scale, bbox, modifiers, attributes, format);
        }
        catch (Exception exc) {
            ErrorLogger.LogException("Tester", "renderWebFormat", exc);
        }
        ErrorLogger.LogMessage("Tester", "renderWebFormat - 2D", result);
        ErrorLogger.LogMessage("Tester", "renderWebFormat - 2D kml", kml);
        ErrorLogger.LogMessage("Tester", "renderWebFormat - 3D", result3D);
        ErrorLogger.LogMessage("Tester", "renderWebFormat - 2D GeoSVG", svg);
        this.copyToClipboard(svg);
    }

    private void btnDrawMPActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.msTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        MSNodeInfo nodeInfo = (MSNodeInfo)node.getUserObject();
        if (node.isLeaf()) {
            MSNodeInfo msni = nodeInfo;
            String symbolID = this.buildSymbolID(msni.msID);
            MSInfo msi = MSLookup.getInstance().getMSLInfo(symbolID);
            this.drawMode = this.drawModeMPDraw;
            this.btnDraw.setBackground(Color.LIGHT_GRAY);
            this.btnDrawMP.setBackground(Color.GREEN);
            this.maxPointCount = msi.getMaxPointCount();
            if (this.maxPointCount > 6) {
                this.maxPointCount = 6;
            }
            if (this.points.size() >= msi.getMinPointCount()) {
                this.RenderMultiPoint();
            }
        }
    }

    private void msTreeValueChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.msTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.points.clear();
        this.btnDrawMP.setText("Draw Symbol");
        MSNodeInfo nodeInfo = (MSNodeInfo)node.getUserObject();
        if (node.isLeaf()) {
            MSNodeInfo msni = nodeInfo;
            String symbolID = this.buildSymbolID(msni.msID);
            this.currentBasicID = msni.msID;
            this.tfSymbolID.setText(symbolID);
            this.btnDrawMP.setEnabled(SymbolUtilities.isMultiPoint(symbolID));
        }
    }

    public void modifierTest() {
        ArrayList<Modifier> mods = new ArrayList<Modifier>();
        mods.add(new Modifier("B_ECHELON", "BBBB", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("C_QUANTITY", "C", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("G_STAFF_COMMENTS", "G", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("H_ADDITIONAL_INFO_1", "H", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("J_EVALUATION_RATING", "J", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("K_COMBAT_EFFECTIVENESS", "K", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("L_SIGNATURE_EQUIP", "L", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("M_HIGHER_FORMATION", "M", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("N_HOSTILE", "N", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("P_IFF_SIF_AIS", "P", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("T_UNIQUE_DESIGNATION_1", "T", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("V_EQUIP_TYPE", "V", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("W1_DTG_2", "W", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("X_ALTITUDE_DEPTH", "X", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("Y_LOCATION", "Y", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("Z_SPEED", "Z", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("AD_PLATFORM_TYPE", "AD", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("AE_EQUIPMENT_TEARDOWN_TIME", "AE", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("AF_COMMON_IDENTIFIER", "AF", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("AR_SPECIAL_DESIGNATOR", "AR", 0, 0, false, 0.0, 0.0));
        mods.add(new Modifier("AS_COUNTRY", "AS", 0, 0, false, 0.0, 0.0));
        ArrayList modsFull = new ArrayList();
        mods.addAll(mods);
        Map<String, String> modifiers = null;
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("MODIFIERPLACEMENT", "1");
        attributes.put("PIXELSIZE", "100");
        ArrayList<String> symbolIDs = new ArrayList<String>();
        int[] versions = new int[]{11, 13};
        int[] ss = new int[]{0, 1, 2, 5, 6, 10, 11, 15, 20, 27, 30, 35, 36, 40};
        int[] affiliations = new int[]{0, 1, 2, 3, 4, 5, 6};
        char[] frames = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A'};
        String testCode = "110301000011000000000000000840";
        for (int version : versions) {
            testCode = SymbolID.setVersion(testCode, version);
            for (int s : ss) {
                testCode = SymbolID.setSymbolSet(testCode, s);
                for (int a : affiliations) {
                    if ((testCode = SymbolID.setAffiliation(testCode, a)).startsWith("11")) {
                        symbolIDs.add(testCode);
                        continue;
                    }
                    for (char f : frames) {
                        testCode = SymbolID.setFrameShape(testCode, f);
                        symbolIDs.add(testCode);
                    }
                }
            }
        }
        Object object = symbolIDs.iterator();
        while (object.hasNext()) {
            int i;
            String id = (String)object.next();
            modifiers = this.populateModifiers(id);
            attributes.put("MODIFIERPLACEMENT", "0");
            ImageInfo ii = MilStdIconRenderer.getInstance().RenderIcon(id, modifiers, attributes);
            if (ii != null) {
                ii.SaveImageToFile("C:\\Temp\\ModifierTest\\" + id + "-0.png", "png");
            } else {
                ErrorLogger.LogMessage("ModifierTest: ii null for " + id);
            }
            attributes.put("MODIFIERPLACEMENT", "1");
            ii = MilStdIconRenderer.getInstance().RenderIcon(id, modifiers, attributes);
            if (ii != null) {
                ii.SaveImageToFile("C:\\Temp\\ModifierTest\\" + id + "-1.png", "png");
            } else {
                ErrorLogger.LogMessage("ModifierTest: ii null for " + id);
            }
            for (i = 0; i < 3; ++i) {
                int mod = this.getRandomNumber(0, modifiers.size());
                modifiers.remove(((Modifier)mods.get(i)).getID());
            }
            ii = MilStdIconRenderer.getInstance().RenderIcon(id, modifiers, attributes);
            if (ii != null) {
                ii.SaveImageToFile("C:\\Temp\\ModifierTest\\" + id + "-3.png", "png");
            } else {
                ErrorLogger.LogMessage("ModifierTest: ii null for " + id);
            }
            for (i = 0; i < 3; ++i) {
                int mod = this.getRandomNumber(0, modifiers.size());
                modifiers.remove(((Modifier)mods.get(i)).getID());
            }
            modifiers.remove("V_EQUIP_TYPE");
            modifiers.remove("H_ADDITIONAL_INFO_1");
            modifiers.remove("AF_COMMON_IDENTIFIER");
            modifiers.remove("C_QUANTITY");
            ii = MilStdIconRenderer.getInstance().RenderIcon(id, modifiers, attributes);
            if (ii != null) {
                ii.SaveImageToFile("C:\\Temp\\ModifierTest\\" + id + "-6.png", "png");
            } else {
                ErrorLogger.LogMessage("ModifierTest: ii null for " + id);
            }
            modifiers.remove("M_HIGHER_FORMATION");
            modifiers.remove("T_UNIQUE_DESIGNATION_1");
            modifiers.remove("G_STAFF_COMMENTS");
            modifiers.remove("AQ_GUARDED_UNIT");
            ii = MilStdIconRenderer.getInstance().RenderIcon(id, modifiers, attributes);
            if (ii != null) {
                ii.SaveImageToFile("C:\\Temp\\ModifierTest\\" + id + "-9.png", "png");
                continue;
            }
            ErrorLogger.LogMessage("ModifierTest: ii null for " + id);
        }
    }

    public int getRandomNumber(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    private void btnSpeedTestActionPerformed(ActionEvent evt) {
        block9: {
            String symbolID = null;
            ImageInfo icon = null;
            MSInfo msInfo = null;
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.msTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                MSNodeInfo nodeInfo = (MSNodeInfo)node.getUserObject();
                if (node.isLeaf()) {
                    MSNodeInfo msni = nodeInfo;
                    symbolID = this.buildSymbolID(msni.msID);
                    msInfo = MSLookup.getInstance().getMSLInfo(symbolID);
                }
                if (symbolID == null) break block9;
                HashMap<String, String> modifiers = new HashMap();
                if (this.cbModifiers.isSelected()) {
                    modifiers = this.populateModifiers(symbolID);
                }
                Map<String, String> attributes = this.populateDefaultAttributes();
                String pixelSize = String.valueOf(this.cbPixelSize.getSelectedItem());
                attributes.put("PIXELSIZE", pixelSize);
                ErrorLogger.setLevel(Level.WARNING, true);
                int limit = 3000;
                try {
                    long startTime = System.currentTimeMillis();
                    for (int i = 0; i < limit; ++i) {
                        icon = MilStdIconRenderer.getInstance().RenderIcon(symbolID, modifiers, attributes);
                    }
                    long endTime = System.currentTimeMillis();
                    String message = String.valueOf(limit) + " " + msInfo.getName() + " drawn in " + String.valueOf((float)(endTime - startTime) / 1000.0f) + " seconds.";
                    JOptionPane.showMessageDialog(null, message, "Speed Test Image", 1);
                    Graphics2D g2d = (Graphics2D)this.getGraphics();
                    Graphics2D graphics = (Graphics2D)this.jPanel1.getGraphics();
                    Point2D.Double mouseClickLocation = new Point2D.Double(this.getWidth() / 2, this.getHeight() / 4);
                    SymbolDraw.Draw(icon, g2d, (int)(((Point2D)mouseClickLocation).getX() - (double)icon.getSymbolCenterX()), (int)(((Point2D)mouseClickLocation).getY() - (double)icon.getSymbolCenterY()));
                    SVGSymbolInfo svg = null;
                    startTime = System.currentTimeMillis();
                    for (int i = 0; i < limit; ++i) {
                        svg = MilStdIconRenderer.getInstance().RenderSVG(symbolID, modifiers, attributes);
                    }
                    endTime = System.currentTimeMillis();
                    message = String.valueOf(limit) + " " + msInfo.getName() + " drawn in " + String.valueOf((float)(endTime - startTime) / 1000.0f) + " seconds.";
                    JOptionPane.showMessageDialog(null, message, "Speed Test SVG", 1);
                }
                catch (Exception exc) {
                    ErrorLogger.LogException("Tester", "formMouseClicked", exc);
                }
                ErrorLogger.setLevel(Level.INFO, true);
            }
            catch (Exception exc) {
                ErrorLogger.LogException("Tester", "btnSpeedTestActionPerformed", exc);
            }
        }
    }

    private void cbOutlineStyleActionPerformed(ActionEvent evt) {
        int index = this.cbOutlineStyle.getSelectedIndex();
        if (index == 0) {
            RendererSettings.getInstance().setTextBackgroundMethod(3);
        } else if (index == 1) {
            RendererSettings.getInstance().setTextBackgroundMethod(2);
        } else if (index == 2) {
            RendererSettings.getInstance().setTextBackgroundMethod(1);
        } else if (index == 3) {
            RendererSettings.getInstance().setTextBackgroundMethod(0);
        }
    }

    private void cbCacheItemStateChanged(ItemEvent evt) {
        RendererSettings.getInstance().setCacheEnabled(this.cbCache.isSelected());
    }

    private void cbVersionItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            String version = (String)this.cbVersion.getSelectedItem();
            int ver = Integer.parseInt(version.substring(0, 2));
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.msTree.getModel().getRoot();
            if (root != null) {
                root.removeAllChildren();
            }
            this.loadTree(ver);
            this.msTree.updateUI();
            this.updatedSymbolIDField();
        }
    }

    private void cbAffiliationItemStateChanged(ItemEvent evt) {
        this.updatedSymbolIDField();
    }

    private void cbModifiersItemStateChanged(ItemEvent evt) {
        this.updatedSymbolIDField();
    }

    private void cbContextItemStateChanged(ItemEvent evt) {
        this.updatedSymbolIDField();
    }

    private void cbStatusItemStateChanged(ItemEvent evt) {
        this.updatedSymbolIDField();
    }

    private void cbS1IItemStateChanged(ItemEvent evt) {
        this.updatedSymbolIDField();
    }

    private void cbS2IItemStateChanged(ItemEvent evt) {
        this.updatedSymbolIDField();
    }

    private void cbHQTFDItemStateChanged(ItemEvent evt) {
        this.updatedSymbolIDField();
    }

    private void cbAmplifierItemStateChanged(ItemEvent evt) {
        this.updatedSymbolIDField();
    }

    private void cbFrameShapePropertyChange(PropertyChangeEvent evt) {
        this.updatedSymbolIDField();
    }

    private void tfSector2ModKeyReleased(KeyEvent evt) {
        this.updatedSymbolIDField();
    }

    private void tfSector1ModKeyReleased(KeyEvent evt) {
        this.updatedSymbolIDField();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Tester.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Tester.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Tester.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Tester.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Tester().setVisible(true);
            }
        });
    }

    public MilStdSymbol render(MilStdSymbol symbol, IPointConversion converter, Object clipBounds) {
        try {
            clsRenderer.renderWithPolylines(symbol, converter, clipBounds);
        }
        catch (Exception exc) {
            String message = "Failed to build multipoint TG";
            if (symbol != null) {
                message = message + ": " + symbol.getSymbolID();
            }
            System.err.println(exc.getMessage());
        }
        catch (Throwable t) {
            String message2 = "Failed to build multipoint TG";
            if (symbol != null) {
                message2 = message2 + ": " + symbol.getSymbolID();
            }
            System.err.println(t.getMessage());
        }
        return symbol;
    }

    private class CBItemInfo {
        public String cbiText;
        public String cbiID;

        public CBItemInfo(String text, String id) {
            this.cbiText = text;
            this.cbiID = id;
        }

        public String toString() {
            return this.cbiText;
        }
    }

    private class MSNodeInfo {
        public String msName;
        public String msID;

        public MSNodeInfo(String id, String name) {
            this.msName = name;
            this.msID = id;
        }

        public String toString() {
            return this.msName;
        }
    }
}

