package armyc2.c5isr.renderer.utilities;

/**
 * Draw Rules for Control Measures
 *
 */
public class DrawRules {

    /**
     * Usually an entry in the MilStd that is just a category containing other symbols
     * and not something that gets drawn itself.
     */
    public static final int DONOTDRAW = 0;

    /**
     * Anchor Points: This symbol requires at least three anchor points to
     * define the boundary of the area. Add as many points as necessary to
     * accurately reflect the area’s size and shape.
     *
     * Size/Shape: Determined by the anchor points. The information fields
     * should be moveable and scalable as a block within the area.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA1 = 101;

    /**
     * Anchor Points: This symbol requires at least three anchor points to
     * define the boundary of the area. Add as many points as necessary to
     * accurately reflect the area’s size and shape. The LAA point symbol
     * requires one anchor point and is connected to the area symbol with a
     * straight line.
     *
     * Size/Shape: Determined by the anchor points. The information fields
     * should be moveable and scalable as a block within the area.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int AREA2 = 102;

    /**
     * Anchor Points: This symbol requires at least three anchor points to
     * define the boundary of the area. Add as many points as necessary to
     * accurately reflect the area’s size and shape.
     *
     * Size/Shape: Determined by the anchor points.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int AREA3 = 103;

    /**
     * Anchor Points: This symbol requires at least three anchor points to
     * define the boundary of the area. Add as many points as necessary to
     * accurately reflect the area’s size and shape.
     *
     * Size/Shape: Determined by the anchor points. The information fields
     * should be moveable and scalable as a block within the area. The default
     * tic length should be the same as the text height of the echelon
     * field (B). Spacing between the tics should also be the height of B.
     * Users should be provided a facility to allow them to manually alter the
     * height of B, which in turn should affect the tic length and spacing
     * accordingly.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int AREA4 = 104;

    /**
     * Anchor Points: This symbol requires three anchor points. Points 1 and 2
     * define the endpoints of the semicircle's opening. Point 3 defines the end
     * of the arrow.
     *
     * Size/Shape: Points 1 and 2 determine the diameter of the semicircle and
     * point 3 determines the length of the arrow. The tip of the arrowhead will
     * be at the center point of the semicircle's diameter and will project
     * perpendicularly from the line between points 1 and 2. The default tic
     * length should be the same as the text height of the echelon field (B).
     * Spacing between the tics should also be the height of B. Users should be
     * provided a facility to allow them to manually alter the height of B,
     * which in turn should affect the tic length and spacing accordingly.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA5 = 105;

    /**
     * Anchor Points: This symbol requires two anchor points. Point 1 defines
     * the center point of the symbol and point 2 defines the symbol’s start
     * point and radius.
     *
     * Size/Shape: Points 1 and 2 will determine a radius that is long enough
     * for the graphic to encompass the feature(s) being retained. The opening
     * will be a 30-degree arc of the circle. The default tic length should be
     * the same as the text height of the echelon field (R). Spacing between
     * the tics should also be the height of R. Users should be provided a
     * facility to allow them to manually alter the height of R, which in turn
     * should affect the tic length and spacing accordingly.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA6 = 106;

    /**
     * Anchor Points: This symbol requires three anchor points. Point 1 is the
     * tip of the arrowhead. Points 2 and 3 define the endpoints of the straight
     * line on the back side of the symbol.
     *
     * Size/Shape: Points 2 and 3 determine the length of the straight line on
     * the back side of the symbol. The rear of the arrowhead line shall connect
     * to the midpoint of the line between points 2 and 3. The arrowhead line shall be perpendicular to the line formed by points 2 and 3.
     *
     * Orientation: Orientation is determined by the anchor points. The back
     * side of the symbol encompasses the firing position, while the arrowhead
     * typically points at the target.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA7 = 107;

    /**
     * Anchor Points: This symbol requires four anchor points. Points 1 and 2
     * define the endpoints of the straight line on the back side of the symbol.
     * Points 3 and 4 define the tips of the arrowheads.
     *
     * Size/Shape: Points 1 and 2 determine the length of the straight line on
     * the back side of the symbol. The rear of the arrows should connect to
     * points 1 and 2.
     *
     * Orientation: Orientation is determined by the anchor points. The back
     * side of the symbol encompasses the firing position, while the arrowheads
     * typically indicate the left and right limits of coverage that the firing
     * position is meant to support.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA8 = 108;

    /**
     * Anchor Points: This symbol requires at least three anchor points to
     * define the boundary of the area. Add as many points as necessary to
     * accurately reflect the area’s size and shape.
     *
     * Size/Shape: Determined by the anchor points.
     *
     * Orientation: Not applicable. The area will encompass two or more fire
     * support symbols (point/single target, nuclear target, circular target,
     * rectangular target, or area target).
     * The naming convention determines whether the area describes a series or
     * group of targets.
     *
     * Used by: 2525D,Dch1,E
     *
     */
    public static final int AREA9 = 109;

    /**
     * Anchor Points: This symbol requires a minimum of three (3) and a maximum
     * of six (6) anchor points to define the boundary of the area. The anchor
     * points shall be sequentially numbered, in increments of one (1),
     * beginning with point one (1).
     *
     * Size/Shape: Determined by the anchor points. The information fields
     * should be moveable and scalable within the area.
     *
     * Orientation: Not applicable.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA10 = 110;

    /**
     * Anchor Points: This symbol requires three anchor points. Points 1 and 2
     * define the endpoints of the symbol’s vertical line. Point 3 defines the
     * endpoint of the symbol’s horizontal line.
     *
     * Size/Shape: Points 1 and 2 determine the length of the vertical line.
     * The length of the horizontal line is determined by plotting point 3 on a
     * plane extending perpendicularly from the midpoint of the vertical line.
     *
     * Orientation: The head of the "T" typically faces enemy forces.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA11 = 111;

    /**
     * Anchor Points: This symbol requires three anchor points. Points 1 and 2
     * define the end points of the symbol’s vertical line. Point 3 defines the
     * tip of the longest arrow.
     *
     * Size/Shape: Points 1 and 2 determine the height of the symbol and point
     * 3 determines its length. The spacing between the symbol’s arrows will
     * stay proportional to the symbol’s vertical line. The length of the short
     * arrows will remain in proportion to the length of the longest arrow.
     *
     * Orientation: The arrows point away from enemy forces.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA12 = 112;

    /**
     * Anchor Points: This symbol requires at least two anchor points. Points
     * 1 and 2 define the corners of the symbol.
     *
     * Size/Shape: Points 1 and 2 determine the length of the straight line.
     * The radius of the semicircle is ½ the length of the straight line.
     *
     * Orientation: Not applicable.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA13 = 113;

    /**
     * Anchor Points: This symbol requires three anchor points. The center point
     * defines the center of the symbol. Points 1 and 2 define the radii of
     * circles 1 and 2.
     *
     * Size/Shape: As defined by the operator.
     *
     * Orientation: The center point is typically centered over Ground Zero (GZ)
     * or Designated Ground Zero (DGZ).
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA14 = 114;

    /**
     * Anchor Points: This symbol requires two anchor points. Point 1 defines
     * the center point of the symbol and point 2 defines the symbol’s start
     * point and radius.
     *
     * Size/Shape: The radius will be long enough for the symbol to encompass
     * the UEI(s) or feature(s) being isolated. The opening will be a 30 degree
     * arc of the circle.
     *
     * Orientation: The opening will be on the friendly side of the symbol.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA15 = 115;

    /**
     * Anchor Points: This symbol requires two anchor points. Point 1 defines
     * the center point of the symbol and point 2 defines the symbol’s start
     * point and radius.
     *
     * Size/Shape: Points 1 and 2 will determine a radius that is long enough
     * for the symbol to encompass the feature(s) being occupied. The opening
     * will be a 30-degree arc of the circle.
     *
     * Orientation: The opening will be on the friendly side of the
     * control measure.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA16 = 116;

    /**
     * Anchor Points: This symbol requires three anchor points. Points 1 and 2
     * define the endpoints of the symbol’s vertical line. Point 3 defines the
     * rear of the symbol.
     *
     * Size/Shape: Points 1 and 2 determine the height of the symbol and
     * point 3 determines its length. The arrow will project perpendicularly
     * from the midpoint of the vertical line.
     *
     * Orientation: The arrow points toward enemy forces.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA17 = 117;

    /**
     * Anchor Points: This symbol requires four anchor points. Point 1 defines
     * the tip of the first arrowhead. Point 2 defines the end of the straight
     * line portion of the first arrow. Point 3 defines the tip of the second
     * arrowhead. Point 4 defines the end of the second arrow.
     *
     * Size/Shape: Points 1 and 2 and points 3 and 4 determine the length of
     * each arrow. Points 2 and 3 shall be connected by a smooth, curved line.
     *
     * Orientation: Determined by the anchor points. The unit being relieved is
     * typically located at the base of the curve and the unit performing the
     * relief is typically located at the end of the symbol. The arrowhead
     * typically points to the location the relieved unit should move to.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA18 = 118;

    /**
     * Anchor Points: This symbol requires two anchor points. Point 1 defines
     * the center point of the symbol and point 2 defines the symbol’s start
     * point and radius.
     *
     * Size/Shape: Points 1 and 2 will determine a radius that is long enough
     * for the symbol to encompass the feature(s) being secured. The opening
     * will be a 30-degree arc of the circle.
     *
     * Orientation: The opening will be on the friendly side of the symbol.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA19 = 119;

    /**
     * Anchor Points: This symbol requires at least three anchor points to
     * define the boundary of the area. Add as many points as necessary to
     * accurately reflect the area’s size and shape.
     *
     * Size/Shape: Determined by the anchor points.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int AREA20 = 120;

    /**
     * Anchor Points: This symbol requires three anchor points. Point 1 defines
     * the vertex of the symbol. Points 2 and 3 define the tips of the
     * arrowheads.
     *
     * Size/Shape: Points 1 and 2 and points 1 and 3 determine the length of the
     * arrows. The length and orientation of the arrows can vary independently.
     *
     * Orientation: Orientation is determined by the anchor points.
     * The arrowheads may touch other symbols that define the limits of the
     * task. The tactical symbol indicator is centered over point 1.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA21 = 121;

    /**
     * Anchor Points: This symbol requires one anchor point. The center point
     * defines the center of the symbol.
     *
     * Size/Shape: Static.
     *
     * Orientation: The symbol is typically centered over the desired location.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA22 = 122;

    /**
     * Anchor Points: This symbol requires at least three anchor points to
     * define the boundary of the area.
     *
     * Size/Shape: Determined by the anchor points
     *
     * Orientation: Not applicable.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int AREA23 = 123;

    /**
     * Anchor Points: This symbol requires three anchor points. Points 1 and 2
     * define the endpoints of the symbol’s vertical line. Point 3 defines the
     * endpoint of the symbol’s horizontal line.
     *
     * Size/Shape: Points 1 and 2 determine the length of the vertical line.
     * Points 2 and 3 determine the length of the horizontal line, which will
     * project perpendicularly from the midpoint of the vertical line.
     *
     * Orientation: The head of the "T" typically faces enemy forces.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int AREA24 = 124;

    /**
     * Anchor Points: This symbol requires three anchor points. Points 1 and 2
     * define the end points of the symbol’s vertical line. Point 3 defines the
     * tip of the longest arrow.
     *
     * Size/Shape: Points 1 and 2 determine the height of the symbol and
     * point 3 determines its length. The spacing between the symbol’s arrows
     * will stay proportional to the symbol’s vertical line. The length of the
     * short arrows will remain in proportion to the length of the longest
     * arrow. The arrows are perpendicular to the baseline (vertical line) and
     * parallel to each other.
     *
     * Orientation: The arrows typically point toward enemy forces.
     *
     * Used by: 2525D,Dch1
     */
    public static final int AREA25 = 125;

    /**
     * Anchor Points: This symbol requires a minimum of 6 anchor points. Add as
     * many pairs of points as needed to accurately define the areas. The number
     * of points shall always be an even number, with an equal number of points
     * for both polygons. Points 1 through N/2 define the inner safe zone
     * (zone 1). Points N/2 +1 though point N defines the outer zone (zone 2).
     *
     * Size/Shape: Determined by the anchor points.
     *
     * Orientation: The symbol will typically be oriented upright.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AREA26 = 126;

    /**
     * Anchor Points: This symbol requires three anchor points. Point 1 defines
     * the tip of the arrowhead. Point 2 defines the end of the straight-line
     * portion of the symbol. Point 3 defines the diameter and orientation of
     * the 180 degree circular arc.
     *
     * Size/Shape: Points 1 and 2 determine the length of the straight-line
     * portion of the symbol. Point 3 defines which side of the line the arc
     * is on and the diameter of the arc
     *
     * Orientation: Determined by the anchor points.
     *
     * Used by: Ech1
     */
    public static final int AREA27 = 127;

    /**
     * Anchor Points: This symbol requires one anchor point. The anchor point
     * defines/is the tip of the inverted cone.
     *
     * Size/Shape: Static.
     *
     * Orientation: The symbol will typically be oriented upright.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int POINT1 = 201;

    /**
     * Anchor Points: This symbol requires one anchor point. The center point
     * defines/is the center of the symbol.
     *
     * Size/Shape: Static.
     *
     * Orientation: The symbol is typically centered over the desired location.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int POINT2 = 202;

    /**
     * Anchor Points: This symbol requires one anchor point.
     * The center point defines the center of the symbol.
     *
     * Size/Shape: Static. Maneuver area symbol shall be drawn with a black
     * border. Maneuver areas may be either unfilled or filled with
     * performance-contoured color options
     *
     * Orientation: The symbol is typically centered over the desired location.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int POINT3 = 203;

    /**
     * Anchor Points: This symbol requires one anchor point. The point defines
     * the bottom of the central vertical line in the symbol where the curved
     * and vertical lines meet.
     *
     * Size/Shape: Static.
     *
     * Orientation: The symbol will typically be oriented upright (as shown in the template and example).
     * +
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int POINT4 = 204;

    /**
     * Anchor Points: This symbol requires one anchor point. The point defines
     * the point where all the lines meet.
     *
     * Size/Shape: Static.
     *
     * Orientation: The symbol will typically be oriented upright (as shown in
     * the example).
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int POINT5 = 205;

    /**
     * Anchor Points: This symbol requires one anchor point. The anchor point
     * defines/is the center of the bottom of the control measure symbol as
     * shown in the template and example.
     *
     * Size/Shape: Static.
     *
     * Orientation: The symbol will typically be oriented upright.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int POINT6 = 206;

    /**
     * Anchor Points: This symbol requires one anchor point. The anchor point
     * defines the midpoint of the symbol's base.
     *
     * Size/Shape: Static.
     *
     * Orientation: The symbol will typically be oriented upright (as shown in
     * the template and example).
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int POINT7 = 207;

    /**
     * Anchor Points: This symbol requires one anchor point. The center point
     * defines the center of the symbol.
     *
     * Size/Shape: Static. The symbol's corners form a 70- degree angle.
     *
     * Orientation: The symbol is typically centered over the desired location.
     * A user can use this symbol to define a new type of point if the selection
     * that follows is not sufficient.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int POINT8 = 208;

    /**
     * Anchor Points: This symbol requires one anchor (center) point. The point
     * defines the center of the symbol.
     *
     * Size/Shape: Static. The symbol's height should be 2x the symbol's width.
     *
     * Orientation: The symbol's center point is typically centered over the
     * desired location. The symbol shall be oriented upright, as shown in the
     * examples.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int POINT9 = 209;

    /**
     * Anchor Points: This symbol requires one anchor point. The point defines
     * the center of the circle. (Sonobuoy)
     *
     * Size/Shape: Static. The diameter of the circle should be 1/2 the height
     * of the symbol.
     *
     * Orientation: The symbol's center point is typically centered over the
     * desired location. The symbol will be oriented upright, as shown in the
     * example.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int POINT10 = 210;

    /**
     * Anchor Points: This symbol requires one center point. The point defines
     * the center of the symbol.
     *
     * Size/Shape: Static. Length is 2x the size of height.
     *
     * Orientation: The symbol is centered over the desired location. The symbol
     * shall be oriented upright, as shown in the example.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int POINT11 = 211;

    /**
     * Anchor Points: This symbol requires three anchor points. Points 1 and 2
     * define the tips of the arrowheads and point 3 defines the rear of the
     * symbol.
     *
     * Size/Shape: Points 1 and 2 determine the symbol's height and point 3
     * determines its length. The vertical line at the rear of the symbol shall
     * be the same length as the opening, and shall be perpendicular to the
     * parallel lines formed with the rear of symbol vertical line and the lines
     * ending with points 1 and 2.
     *
     * Orientation: The opening typically faces the applicable obstacle.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int POINT12 = 212;

    /**
     * Anchor Points: This symbol requires one anchor point. The center point
     * defines the center of the circle.
     *
     * Size/Shape: Static.
     *
     * Orientation: The symbol is typically centered over the desired location.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int POINT13 = 213;

    /**
     * Anchor Points: This symbol requires one anchor point. The center point
     * defines the center of the symbol.
     *
     * Size/Shape: There should be 45 degrees of angular separation between the
     * two arrows.
     *
     * Orientation: The symbol is typically centered over the desired location.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int POINT14 = 214;

    /**
     * Anchor Points: This symbol requires one anchor point. The anchor point
     * defines "nose" of the symbol.
     *
     * Size/Shape: Static.
     *
     * Orientation: The symbol is typically centered over the desired location.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int POINT15 = 215;

    /**
     * Anchor Points: This symbol requires one anchor point; the point defines
     * the circle at the base of the tower.
     *
     * Size/Shape: The symbol is a high-angle cone.
     *
     * Orientation: The symbol will remain upright.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int POINT16 = 216;

    /**
     * Anchor Points: This symbol requires one anchor point. This anchor point
     * represents the center of the rectangle and, therefore, the geographic
     * location of that rectangle.
     *
     * Size/Shape: The size and shape of this symbol is determined by three
     * additional numeric values; A length (AM1), a width (AM2), and a
     * rotation angle. The length and width should be expressed in the
     * appropriate map distance units. The length is aligned with the axis of
     * rotation. The width is aligned perpendicular to the axis of rotation.
     *
     * Orientation: The orientation of this symbol is determined by the
     * rotation angle provided, where 0 degrees is North and a positive
     * rotation angle rotates the rectangle in a clockwise direction.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int POINT17 = 217;

    /**
     * Anchor Points: This symbol requires one anchor point that defines the
     * axis of angular rotation.
     *
     * Size/Shape: The size and shape of this symbol is determined by additional
     * numeric values; A search axis azimuth, a start range, a stop range and a
     * stop relative bearing. The stop relative bearing is an equal angle either
     * side of the search axis. The start and stop range should be expressed in
     * the appropriate map distance units. Field T should be positioned in the
     * center of the search area aligned with the search axis.
     *
     * Orientation: The orientation of this symbol is determined by the search
     * axis azimuth provided.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int POINT18 = 218;

    /**
     * Anchor Points: This symbol requires at least two anchor points, points 1
     * and 2, to define the line. Additional points can be defined to extend the
     * line.
     *
     * Size/Shape: The first and last anchor points determine the length of the
     * line.
     *
     * Orientation: Orientation is determined by the order in which the anchor points are entered.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE1 = 301;

    /**
     * Anchor Points: This symbol requires at least two anchor points, points
     * 1 and 2, to define the line. Additional points can be defined to extend
     * the line.
     *
     * Size/Shape: The first and last anchor points determine the length of the line.
     * The end-of line information will typically be posted at the ends of the line
     * as it is displayed on the screen.
     *
     * Orientation: Orientation is determined by the order in which the anchor points
     * are entered.
     *
     * Used by: 2525D,Dch1
     */
    public static final int LINE2 = 302;

    /**
     * Anchor Points: This symbol requires three anchor points. Point 1 defines
     * the vertex of the symbol. Points 2 and 3 define the tips of the arrowheads.
     *
     * Size/Shape: The length and orientation of the arrows can vary
     * independently.
     *
     * Orientation: Orientation is determined by the anchor points. The
     * arrowheads may touch other symbols that define the limits of the task.
     * The top of the tactical symbol indicator may touch point 1
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE3 = 303;

    /**
     * Anchor Points: This symbol requires two anchor points. Points 1 and 2
     * define the corner points of the symbol.
     *
     * Size/Shape: The symbol varies only in length.
     *
     * Orientation: Orientation is determined by the anchor points.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE4 = 304;

    /**
     * Anchor Points: This symbol requires two anchor points. Points 1 and 2
     * define the endpoints of the symbol.
     *
     * Size/Shape: The symbol varies only in length.
     *
     * Orientation: One point defines the origin from which the bearing is being
     * taken and the other point defines the location or direction from which a
     * contact is made.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int LINE5 = 305;

    /**
     * Anchor Points: This symbol requires 3 anchor points. Point 1 defines the
     * vertex of the symbol and points 2 and 3 define its endpoints.
     *
     * Size/Shape: Points 1, 2 and 3 determine the length of the lines
     * connecting them. The line defined by points 1 and 2 is typically the same
     * length as the line between points 2 and 3.
     *
     * Orientation: Orientation is determined by the anchor points
     *
     * Used by: 2525D,Dch1
     */
    public static final int LINE6 = 306;

    /**
     * Anchor Points: This symbol requires at least two anchor points, points
     * 1 and 2, to define the line. Additional points can be defined to extend
     * the line.
     *
     * Size/Shape: The first and last anchor points determine the length of the
     * line. The line information will be posted once at the center of the line
     * as it is displayed on the screen.
     *
     * Orientation: Orientation is determined by the order in which the anchor
     * points are entered.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int LINE7 = 307;

    /**
     * Anchor Points: This symbol requires a minimum of two (2) anchor points.
     * Up to 298 additional points can be added to extend the line. The first
     * point (point 1) defines the start point. The last point defines the
     * endpoint. The points are numbered sequentially beginning with point one (1), in increments of one.
     *
     * Size/Shape: The anchor points define the size and shape.
     *
     * Orientation: The orientation is determined by the anchor points.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE8 = 308;

    /**
     * Anchor Points: This symbol requires 2 anchor points. Point 1 defines the
     * tip of the arrowhead and point 2 defines the rear of the symbol.
     *
     * Size/Shape: Points 1 and 2 determine the length of the symbol, which
     * varies only in length.
     *
     * Orientation: The orientation is determined by the anchor points.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE9 = 309;

    /**
     * Anchor Points: This symbol requires two anchor points. Point 1 defines
     * the tip of the arrowhead and point 2 defines the rear of the symbol.
     * Point 3 defines the 90 degree arc.
     *
     * Size/Shape: Points 1 and 2 are connected by a 90 degree arc. Point 3
     * indicates on which side of the line the arc is placed.
     *
     * Orientation: The rear of the symbol identifies the enemy’s location and
     * the arrow points in the direction the obstacle should force the enemy to
     * turn.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE10 = 310;

    /**
     * Anchor Points: This symbol requires four points. Points 1 and 2 define
     * one side of the gap and points 3 and 4 define the opposite side of the
     * gap.
     *
     * Size/Shape. Determined by the anchor points.
     *
     * Orientation: Not applicable.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE11 = 311;

    /**
     * Anchor Points: This symbol requires three anchor points. Points 1 and 2
     * define the endpoints of the symbol and point 3 defines the location of
     * one side of the symbol.
     *
     * Size/Shape: Points 1 and 2 determine the centerline of the symbol and
     * point 3 determines its width.
     *
     * Orientation: Orientation is determined by the anchor points.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE12 = 312;

    /**
     * Anchor Points: This symbol requires at least two anchor points, points 1
     * and 2, to define the line. Additional points can be defined to extend the
     * line.
     *
     * Size/Shape: The first and last anchor points determine the length of the
     * line. The size of the tooth does not change.
     *
     * Orientation: Orientation is determined by the anchor points.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int LINE13 = 313;

    /**
     * Anchor Points: This symbol requires two anchor points. Points 1 and 2
     * define the tips of the arrowheads.
     *
     * Size/Shape: Points 1 and 2 determine the length of the symbol, which
     * varies only in length. The lines of the arrowhead will form an acute
     * angle.
     *
     * Orientation: Orientation is determined by the anchor points.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE14 = 314;

    /**
     * Anchor Points: This symbol requires four points. Points 1 and 2 define
     * one side of the assault crossing site and points 3 and 4 define the
     * opposite side of the assault crossing site.
     *
     * Size/Shape: Determined by the anchor points.
     *
     * Orientation: Not applicable.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE16 = 316;

    /**
     * Anchor Points. This symbol requires three anchor points. Points 1 and 2
     * define the endpoints of the first line. Point 3 defines the location of
     * the parallel line.
     *
     * Size/Shape: Points 1 and 2 determine the length of the symbol. Point 3
     * determines its width.
     *
     * Orientation: Orientation is determined by the anchor points.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE17 = 317;

    /**
     * Anchor Points: This symbol requires two anchor points. Points 1 and two
     * define the tips of the arrowheads.
     *
     * Size/Shape: Points 1 and 2 determine the length of the symbol, which
     * varies only in length. The arrowheads will be filled-in versions of a
     * common arrowhead.
     *
     * Orientation: Orientation is determined by the anchor points.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int LINE18 = 318;

    /**
     * Anchor Points: This symbol requires two anchor points. Points 1 and two
     * define the corners on the front of the symbol.
     *
     * Size/Shape: Points 1 and 2 determine the length of the symbol, which
     * varies only in length.
     *
     * Orientation: Orientation is determined by the anchor points
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE19 = 319;

    /**
     * Anchor Points: This graphic requires two anchor points. Point 1 defines
     * the tip of the arrowhead, and point 2 defines the rear of the graphic.
     *
     * Size/Shape: Points 1 and 2 determine the length of the graphic, which
     * varies only in length.
     *
     * Orientation: The arrow points to the location where the convoy has halted.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int LINE20 = 320;

    /**
     * Anchor Points: This symbol requires at least two anchor points to define
     * the line. Additional points can be defined to extend and shape the line.
     *
     * Size/Shape: The first and last anchor points determine the length of the
     * line. The line segment between each pair of anchor points will repeat all
     * information associated with the line segment.
     *
     * Orientation: Orientation is determined by the anchor points.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int LINE21 = 321;

    /**
     * Anchor Points: This symbol requires three anchor points. Points 1 and 2
     * define the endpoints of the symbol’s opening and point 3 defines the rear
     * of the symbol.
     *
     * Size/Shape: Points 1 and 2 determine the symbol’s height and point 3
     * determines its length. The vertical line at the rear of the symbol will
     * be the same height as the opening and parallel to it.
     *
     * Orientation: The opening defines the span of the breach and typically
     * faces enemy forces.
     *
     * Used by: 2525D,Dch1
     */
    public static final int LINE22 = 322;

    /**
     * Anchor Points: This symbol requires three anchor points. Points 1 and 2
     * define the endpoints of the symbol’s vertical line and point 3 defines
     * the rear of the symbol.
     *
     * Size/Shape: Points 1 and 2 determine the symbol’s height and point 3
     * determines its length. The spacing between the symbol’s arrows will stay
     * proportional to the symbol’s height. The tip of the middle arrowhead will
     * be at the midpoint of the vertical line. The arrows will stay
     * perpendicular to the vertical line, regardless of the rotational
     * orientation of the symbol as a whole.
     *
     * Orientation: The arrows typically point toward enemy forces.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE23 = 323;

    /**
     * Anchor Points: This symbol requires three anchor points. Point 1 defines
     * the tip of the arrowhead. Point 2 defines the end of the straight line
     * portion of the symbol. Point 3 defines the diameter and orientation of
     * the 180 degree circular arc.
     *
     * Size/Shape: Points 1 and 2 determine the length of the straight line
     * portion of the symbol.
     * Point 3 defines which side of the line the arc is on and the diameter of
     * the arc.
     *
     * Orientation: The arrow points in the direction of the action. The tip of
     * the arrowhead may indicate the location where the action is to conclude.
     * The unit’s current location is typically represented at the base of the
     * arc. The 180 degree circular arc is always perpendicular to the line.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE24 = 324;

    /**
     * Anchor Points: This symbol requires exactly two anchor points. Point 1
     * defines the tip of the arrowhead and point 2 defines the rear of the
     * symbol.
     *
     * Size/Shape: Points 1 and 2 determine the length of the symbol, which
     * varies only in length.
     *
     * Orientation: The arrow typically points in the direction of the action.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE25 = 325;

    /**
     * Anchor Points: Where four points are available Point 1 and Point 2 define
     * the ends of one arrow and Point 3 and Point 4 define the ends of the
     * other arrow. Point 1 and Point 4 define the ends of their respective
     * arrowheads. Where three points are available Point 1 defines the vertex
     * of the symbol. Points 2 and 3 define the tips of the arrowheads.
     *
     * Size/Shape: Where four points are available, Points 1 and 2 and Points
     * 3 and 4 determine the length of the arrows. Where three points are
     * available Points 1 and 2 and points 1 and 3 determine the length of the
     * arrows. The length and orientation of the arrows can vary independently.
     *
     * Orientation: Orientation is determined by the anchor points.
     * The arrowheads may touch other symbols that define the limits of the
     * task. The tactical symbol indicator is centered between point 2 and
     * point 3 when four points are in use or centered on Point 1 when three
     * points are in use.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE26 = 326;

    /**
     * Anchor Points: Where four points are available Point 1 defines the center
     * of the circle. Point 2 defines the radius of the circle. Point 3 defines
     * the curvature of the arc. Point 4 defines the end of the arrow. Where
     * three points are available Point 1 defines the center point of the
     * circle. Point 2 defines the tip of the arrowhead. Point 3 defines the
     * 90 degree arc.
     *
     * Size/Shape: Where four points are available, Points 1 and 2 define the
     * size of the circle, which should be adjusted as needed to contain the
     * unit assigned the task. Point 3 controls the curvature of the arc.
     * Point 4 defines the end of the arrow. Where three points are available
     * Points 1 and 2 are connected by a 90 degree arc. The circle will at least
     * be large enough to accommodate a tactical symbol. Point 3 indicates on
     * which side of the line the arc is placed.
     *
     * Orientation: The arrowhead identifies the location/object to be seized
     * and the circle identifies the unit(s) assigned the task. See 5.3.11 for
     * options to accommodate multiple units.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE27 = 327;

    /**
     * Anchor Points: This symbol requires 2 anchor points. Point 1 defines the
     * tip of the arrowhead, and point 2 defines the rear of the symbol.
     *
     * Size/Shape: Points 1 and 2 determine the length of the symbol, which
     * varies only in length.
     *
     * Orientation: The arrow typically points toward enemy forces with the tip
     * of the arrowhead indicating the location of the action.
     *
     * Duplicate of Line9 so removed in 2525E
     *
     * Used by: 2525D,Dch1
     */
    public static final int LINE28 = 328;

    /**
     * Anchor Points: This symbol requires three anchor points. Point 1 is the
     * tip of the arrowhead. Points 2 and 3 define the endpoints of the curved
     * line on the back side of the symbol.
     *
     * Size/Shape: Points 2 and 3 determine the length of the curved line on the
     * back side of the symbol. The rear of the arrowhead line shall connect to
     * the midpoint of the line between points 2 and 3. The arrowhead line shall
     * be perpendicular to the line formed by points 2 and 3.
     *
     * Orientation: Orientation is determined by the anchor points. The back
     * side of the symbol encompasses the ambush position, while the arrowhead
     * typically points at the target.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int LINE29 = 329;

    /**
     * Anchor Points: Point 1 defines the tip of the arrowhead. Point 2 defines
     * the end of the symbol. Point 3’s distance from Point 2 defines the length
     * of the four angled lines making up the arrowhead and dashed "tail". Angles
     * a are always drawn at 45 degrees. Angle b is always drawn at 90 degrees.
     *
     * Size/Shape: The symbol varies only in length.
     *
     * Used by: Ech1
     */
    public static final int LINE30 = 330;

    /**
     * Anchor Points: This graphic requires four anchor points. Point 1 defines the
     * beginning of the straight line. Point 2 defines the end of the straight-line
     * portion of the graphic. Point 3 defines the diameter. Point 4 defines the
     * orientation of the 180 degree circular arc.
     *
     * Size/Shape: Points 1 and 2 determine the length of the straight-line portion
     * of the symbol. Point 3 defines the diameter of the arc. Point 4 defines which
     * side of the line the arc is on.
     *
     * Used by: Ech1
     */
    public static final int LINE31 = 331;

    /**
     * Anchor Points: This graphic requires three anchor points. Point 1 defines the
     * end of the straight-line portion of the graphic. Point 2 defines the center of
     * the two 90 degree circular arcs. Point 3 defines the tip of the arrowhead.
     *
     * Size/Shape: Points 1 and 3 determine the length of the symbol.
     *
     * Used by: Ech1
     */
    public static final int LINE32 = 332;

    /**
     * Anchor Points: This graphic requires three anchor points.
     * Point 1 defines the beginning of the straight line. Point 2
     * defines the end of the straight line portion of the graphic.
     * Point 3 defines the diameter and orientation of the 180 degree
     * circular arc and the tip of the arrowhead.
     *
     * Size/Shape: Points 1 and 2 determine the length of the straight
     * line portion of the symbol. Point 3 defines which side of the
     * line the arc is on and the diameter of the arc.
     *
     * Used by: Ech1
     */
    public static final int LINE33 = 333;

    /**
     * Anchor Points: This symbol may contain multiple segments. Each segment
     * requires 2 anchor points. Point numbers that define the trace of the
     * segment are sequential beginning with point 1, in increments of 1, up to
     * a max of 99 points. Each anchor point defines the endpoint of a segment’s
     * center line. The anchor points are Air Control Points (ACP),
     * Communications Checkpoints (CCP) or both.
     *
     * Size/Shape: Points 1 and 2 determine the length of a segment. The
     * information field inside each segment should be moveable and scalable
     * within each segment. The information box outside the symbol should be
     * placed between points 1 and 2 in such a way it does not obscure the
     * symbol.
     *
     * Orientation: The anchor points determine orientation.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int CORRIDOR1 = 401;


    /**
     * Anchor Points: The symbol requires N anchor points, where N is between
     * 3 and 50. Point 1 defines the tip of the arrowhead. Point N-1 defines
     * the rear of the symbol. Point N defines the back of the arrowhead.
     * Anchor points are numbered sequentially beginning with point number
     * one (1), in increments of one (1).
     *
     * Size/Shape: Points 1 through N-1 and 2 determine the symbol’s center line
     * and Point N determines the width. The crossover point on the symbol shall
     * occur between Points 1 and 2.
     *
     * Orientation: The arrowhead typically points toward enemy forces.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int AXIS1 = 501;

    /**
     * Anchor Points: The symbol requires N anchor points, where N is between 3
     * and 50. Point 1 defines the tip of the arrowhead. Point N-1 defines the
     * rear of the symbol. Point N defines the back of the arrowhead. Anchor
     * points are numbered sequentially beginning with point number one (1), in
     * increments of one (1).
     *
     * Size/Shape: Points 1 through N-1 and 2 determine the symbol’s center line
     * and Point N determines the width.
     *
     * Orientation: The arrowhead typically points toward enemy forces.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int AXIS2 = 502;

    /**
     * Anchor Points: This symbol requires three anchor points. Points 1 and 2
     * define the endpoints of the infiltration lane and point 3 defines the
     * width on one side of the lane.
     *
     * Size/Shape: Points 1 and 2 determine the center line of the symbol and
     * point 3 determines the width of the infiltration lane. The rest of the
     * symbol stays proportional to the length of the center line.
     *
     * Orientation: Orientation is determined by points 1 and 2.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int POLYLINE1 = 601;

    /**
     * Anchor Points: This symbol requires one anchor point. This anchor point
     * represents the center of an ellipse and, therefore, the geographic
     * location of that ellipse.
     *
     * Size/Shape: The size and shape of this symbol is determined by three
     * additional numeric values; A major axis radius, a minor axis radius, and
     * a rotation angle. The radii should be expressed in the appropriate map
     * distance units.
     *
     * Orientation: The orientation of this symbol is determined by the rotation
     * angle provided, where 0 degrees is east/west and a positive rotation
     * angle rotates the ellipse in a counter-clockwise direction.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int ELLIPSE1 = 701;

    /**
     * Anchor Points: This symbol requires two anchor points and a width,
     * defined in meters, to define the boundary of the area. Points 1 and 2
     * will be located in the center of two opposing sides of the rectangle.
     *
     * Size/Shape: Size: As determined by the anchor points. The anchor points
     * determine the length of the rectangle. The width, defined in meters,
     * will determine the width of the rectangle. Shape: Rectangle. The
     * information fields should be moveable and scalable.
     *
     * Orientation: As determined by the anchor points.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int RECTANGULAR1 = 801;

    /**
     * Anchor Points: This symbol requires one (1) anchor point to define the
     * center of the area.
     *
     * Size/Shape: Size is determined by the anchor point, the target length (in meters)
     * and target width (in meters). A rectangular target is wider and longer than 200 meters.
     * The information fields should be moveable and saleable within the area. Shape: Rectangle.
     *
     * Orientation: As determined by the Target Attitude (in mils).
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int RECTANGULAR2 = 802;

    /**
     * Anchor Points: This symbol requires one anchor (center) point to define
     * the center of the symbol. The target tactical symbol shall be centered
     * upon the center of the area. The size and the orientation of the target
     * symbol are fixed within the area.
     *
     * Size/Shape: As determined by the anchor points. The anchor points
     * determine the area’s length.
     * Width, determined in meters, will define the width of the rectangle.
     *
     * Orientation: As determined by the anchor points. The center point of the
     * area shall always have the target symbol with the same
     * upright orientation.
     *
     * Used by: 2525D,Dch1,E
     */
    public static final int RECTANGULAR3 = 803;


    /**
     * Anchor Points: This symbol requires one (1) anchor point and a radius.
     * Point 1 defines the center point of the symbol.
     *
     * Size/Shape: Size: The radius defines the size. Shape: Circle. The
     * information fields should be scalable within the circle.
     *
     * Orientation: Not applicable
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int CIRCULAR1 = 901;

    /**
     * Anchor Points: This symbol requires one anchor point that defines an
     * object at a dynamic grid location. This coordinate, which pinpoints the
     * current physical location of a specific unit, weapon or acquisition
     * system, may change with the movement of the object. The symbol for that
     * object is located at the anchor point.
     *
     * Size/Shape: The size is determined by the distance in meters from the
     * object at the center of the range fan. The shapes are concentric circles.
     * A minimum of one (1) and a maximum of three (3) concentric circles can be
     * used.
     *
     * Orientation: The center point is typically centered over the known
     * location of a weapon or sensor system.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int CIRCULAR2 = 902;

    /**
     * Anchor Points: This graphic requires one anchor point that defines an
     * object at a dynamic grid location. This coordinate, which pinpoints the
     * current physical location of a specific unit, weapon or sensor system,
     * may change with the movement of the object. The symbol for that object
     * is located at the anchor point.
     *
     * Size/Shape: Determined by the anchor point, azimuths measured from true
     * north, and the distance (range) in meters. The Left Sector Azimuth is the
     * angle measured from true north to the left sector limit/edge of the
     * Sector Range Fan. The Right Sector Azimuth is the angle measured from
     * true north to the right sector limit/edge of the Sector Range Fan.
     * Multiple distances (ranges) and/or left and right sector limits/edges
     * of the sector, as well as altitude, may be added as required to define
     * the sector. All azimuths are in degrees. All distances (ranges) are in
     * meters. All altitudes are in feet.
     *
     * Orientation: The center point is typically centered over the known
     * location of a weapon or sensor system. The orientation may change as
     * the object moves or changes.
     *
     * Used by: 2525D,Dch1,E,Ech1
     */
    public static final int ARC1 = 1001;


}
