package armyc2.c5isr.renderer.utilities;

/**
 * Utility class for helping to parse out parts of the symbol ID.
 *
 * <br></br><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAmAAAAJhCAYAAADmNwx1AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAKAJSURBVHhe7f1vdBTXgSf8r973G73UC4451pCfkhPWYVidWRieRMwzsCTMQuwZwtjJKIDjEZ7EATtjMSSAPTGM1+4sHvHYkYek10RjEo1Jj4jlPwqLTCyzyJgmEQGZNLZlS0DLIAPWNowASf393VtVt7qquqq79aerqqXv55x7bFqlVvWt6rrfunXr1n8CEREREfmKAYyIiIjIZ7YA9p/+039iYWFhYWFhYWEpQbFiAGNhYWFhYWFh8aFYuQYwIiIiIpoeDGBEREREPmMAIyIiIvIZAxgRERGRzxjAiIiIiHzGAEZERETkMwYwIiIiIp8xgBERERH5jAGMiIiIyGcMYEREREQ+YwAjIiIi8hkDGBEREZHPGMCIiIiIfMYARkQW4xhJncIb8RiaolFEZWmKIf7GKaRGxo1llAxGBt5GezyOeJ7S1tWHEW3xy+h5tc11Ga9i/u5EjfShq22K70FEVEIMYESky3yKZNvjWFUdQUVFRU6J1H4PL/ffNBaW0khE61yXtZUlzegdE4un4qh3+3m+Uh1FYlT/a8Ubx3DnVlSp96jais5hZ3gkIgoWAxgRCRnc6NmDZREZWu7C2l0HcCzZj1SqD71vH8Ivnt6A2kgdoom0sbyUDWBV9VEccPReqZK/B2wvGuuqxHtUoa5xr+Nnk+y9ygyiY/MCPXxpZT42tl8Qn5CIKDwYwIhIGEJn40IRViqxaNcxDOeklTGk+3rQO2TtjsoGsOpoAhPuqNIMIF5fLd6jGvXxAeO1qclcasfGShG8Fj+FX+5bj4hYv8qN7bjEBEZEIcIARkQiX51G85LKCQahMAaw27gYfxCVIkgubvodbva34l7Zq1f5IOIXbxvLEBEFjwGMiIDMe2hZPUcEoSosaz4tYkwxQhjAMn1ovVe+30o09aQt/67Gva19vAxJRKHBAEZEwqciTK3QwlTFvAcQ6/mkiEAVvgA2/kEL7pY9XsueR+9tGbdGcal9EyrFOkbubsEHHItPRCHBAEZEmsyl1/FwjXEHZGQx1kXjSKRu5Ok1ClsAG0Eytka8VxWWx85CZS1zTFjFGsSSnJCCiMKBAYyIDGNIJ9uwY1WNHsK0IFaLNdv24a2B6y5BLBvAPIuagsLTNAaw26fRvEzeUekIWpkLaN84X7yujwu7ZbxMRBQkBjAissmMXEAiHsW6WhlmjCAVWYKNLaeQtqWwbACLLFyJb9TXo95R1m1tR3/ey37TFcAyuNWzB4vlui6PIWn7m2O40vGoPi/Y4j3oucWRYEQUPAYwInKVGUnhVMdzaDCD2AKsbz1nGaAfpkuQagyb/fKjabgTjVXyM6xANPGp8SIRUXAYwIgor0z6FGLrjIlNK7+HjivqmmKIAtiNY9g5X45fq0VD0y9yJnTNTvgawfydx3DD+DUioqAwgBFRQZm+FqzWesGss+GHJYCNY7jrcdRo61dEqXkcXXw0EREFjAGMiAq72Y2dc2WACWMAU7P4V2HpzoM4kUgg4VaOxtCgXYZciMbOIeN3iYiCwQBGRMDoDaRHvHqFMrjd+zyWyd6jyAa09qv7CMMRwDJXOrBZC1aFpplQQY2PJiKi4DGAERFGE1HMq92AaPwd9KetUWocIwNHEF0zTwSXCOY9+DJSZnAJQwDLTrSae/ejUwY3uv8J8+WylZvQfmlya0xENB0YwIgIY8kYVsgZ5GU4iSzEyvpN2P7UdmxaW4dq+ZookaVP4HDqpvEbUjaA5SuRFSIYec4FNsUAlulHfL2ct8zj7kcnc7B+DdbH+/NMMktEVFoMYEQk3MTlnoPY07gWC1UQU6V6OTZGX8aZq84nRN5EX+sDZkDzLAua0OMZwD5Gx6a7xHKTDGCX29Eg1zfyDbR8YA2HXrKPXIo0tOOy8SoRkd8YwIjIJjNyDYOpPvSeSmIg9QnSo+wnIiKabgxgRERERD5jACMiIiLyGQMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARERER+YwBjIiIiMhnDGBEREREPmMAIyIiIvIZAxgRERGRzxjAiIiIiHzGAEZERETkMwYwIiIiIp8xgBERERH5jAGMiIiIyGcMYEREREQ+YwAjIiIi8hkDGBEREZHPGMCIiIiIfMYARkREROQzBjAiIiIinzGAEREREfmMAYyIiIjIZwxgRERERD5jACMiIiLyGQMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfBRPARq/ig+7X8GLzbkSjUa00xdrQlbyCUWORQGVuIJXocKxfO7o/uBqO9QvUOEZSv0XHi81m3USb9qG9+31cG80Yy4TA6DAGeo4gHttj2YYh2sf8Vnb79G1c7f01Yk3PoLn9LNLGq7NZZuQCEh370Wxsv2h0D2Ltb+ODa7eNJWiyWLdTV351GHxb5nMAG0O69yVsWVmDiooKl3IX1v7oLVwOsB3PpE+hZeMSRNzWL7IEG1tOIR2inOGrzKc40/IQaiMudVNRhdqNL+JMesxYOChiH0u2Yccqr31sAeqfT+DaLNqG5bZPZ9Lvo/PHD2b3s/o4UsbPZiexT595ERtrq3K3nyiR2ofQcuZTzNbD0tSwbqeuDOswJG2ZzwHsItobRMMYWYx1T/8cnT0fIJW6gL6eX+Onm5YZDcRibOm8FMzGylxEx8OLtI0QWboVvzh2FgOpFAaSJ/B603rM09ZvKXZ0XZ6FX8hRXOrYghpZB5EV2PKLo0gOpJAaSCLxehPq50VE3VSidsdvcDXQyjH2sYoarNz8z2g9fAyJxHF0tf8Ym+rmaNu2omIRHu64ODu2YVnt0zdxOdGCzeZ2MsosD2CZS6/j4Rr5/ZqDpVv241iyXxw3+5FMvIqm+gV6HdU+ga6rQZ/8lB/W7dSVXx2Gpy3zOYANo/eVl/F26kbuwf72aTQv0xN05aYOXDFe9k8GNxI/wiK5UWoeRfvFm8brhswVdO9arq1f5O4WfDBuvD5b3HgH0UWV4vMvwub2fsdlqzEMdz+l113kG2j5wFF3vhrGqX+L4eUzn+RcWsseKMQ2XCca9RmfwMppn76J/vh39EA47z7sevl3ONP6gLZuszuAfYpEdIWohwhqNrfjouPSSGb4GHZp38u5uLvlHGbbYWlqWLdTV4Z1GKK2zOcAlk9abMg6USlBHXCH0Nm4UPz9KixrPg23q9aZvhaslutXsQax5Ijx6mwwjuHOraiSn33Z8+i97ZJcMu+hZbXsuajC8tjZkB6sPkX3ziX6PlYdRWLGDwYrp336Onr2rMO6f34dSW3MyChS8QZ9W83mADbcicYquX3uQXPvdeNFq5voa/m6Xk/LY0gyJRSPdTt1ZVeH4WrLQhTAso1jID1gN08gepfsHVmBph63HUkYO43mJTI534VNHR8bL84GwyIcLxOfO4IFTT3iHMHNDfQ2rw5u+xXFEvJnQwAr632aAUy0BLiZiOIuWQcLmtDjcQVnrLcZS+Qyld9DxxVeKisO63bqyrEOw9WWhSaAZbsqa7A+3i82rc9ScdTLnaSiAfGUV8s8gHh9tVimEkuaT3tsvJlIfe5q1McHjNecLA3mkmb0hrJyrqBruz4eqmJtKwZ838l8Vtb7NANY0XVgbufVaO69YbxI+bFup64c6zBcbVkIAthtXEseMgbrRTBv3YtIjvjfMo71NGGBrPA5j6Hrutffz/agVEcTYjPNEmM9aFoge1IWYXuX9/nAqDgbqpZ1GNbepRvHsHO+/ByzY0xHee/TDGDaZdkmOb6mAnO2d4l/eRhNIFot6qmiDtEEJ+woDut26sqwDkPWlgUQwMYx3P0s1tfXo77+PqxcaNy6Wn0Ptr94DAMjwTSLxVX4LA1gRX6Bwh3AbuD9lvWolOtXsw2ds+ByQnnv0wxgRW8bhoRJYN1OXRnWYcjasgAC2Biudn7fuP3dXiIL78W22DGkApjQkwEsj7IPYBmM9sexUbu9eCE2xvtmxbZjACt3DAmlw7qdOgawqQoggDmNIp06g86fPow6bVI099tZS40BLI8yD2CZdA+eXzsvsH0rKAxg5Y4hoXRYt1PHADZVIQhgyk1cbH9UnxytYgm2d31ivO4Pc7xM5CG0X/a6PKUGcee7g2IGMq+b16Ch/aLxolMG17sewxxZh3nuiPHd6AA6tugHicq1P8HpwGfq909579MMYNYxNpGGdlw2Xs1xvQvb58jjZp67XcmBdTt1ZViHIWvLQhTAhJvd2DlXbqgAGgPzTo2vo6XPY/K1zIdoXTu3wMabidSdI3OwuuU9jztUb2Ogdb1YpsCX0U+j53F4x5e1JyxElj6Bw6kgJ4gNQFnv0wxgtjpY3YI+j47bzEAr1spl8gZtsmPdTl051mG42rJwBTBzTqIALoeYyXghGjuHjBcdzEnnZtstydkznarGTgwbr9qpST9DMp1BZhBvPjaLw5dU1vs0A5hk9mJWbUXnsNsNSpaJJUM7/Us4sW6nrvzqMFxtWagCWOZiHOsrxYaqmId1vs8FpipdbJjNHbiS88fHcKXjUX1HWrwHPbf8XbtgWb5EVY+6TqaXudKBzVpDvhJNPQFf55cPWo09oN3oMWvDl6ac92kGMI0ZkBdgc8dg7jFRnGh0bJZT+FRicdPvcMt4mYrAup26sqvDcLVlvgawsd69+Mt1UcRP9CNtGwidwejVk4itMx7cGcg0AZbn5kW+jB2Hz1t64MYx0v8KttQGOFFs0MznZ83B0h2HbHeqZkb68IoaZ7U+jouBVk4ayZYG45mCDyAWtqfw+6qc92kGMJ161p7LyUTmOvpf+T5qZR1VPoj4RbeHTZE31u3UlWEdhqgt8zWAZfpbca92p6PYWAvvxkPbn0Q0+jR2NtajrlpeKhE/Ew3FY2+6JGk/ZIZwbNdK7bKV7IVb2rANT8v1e3QtFmrrnbvBZo8xXD32NJYad6pWL30A25+OIrrzEawx5nILRW+TOHvZpPWiFioR1Gx/06MLegYpm31a7F9dz2CdNj+gLN/Amjp556pYx+o6rDFf34hoVyhGGPomc/Ut7Foqn00n62I5GrTj5hN4dE2tvl1zwjUVi3U7deVXh+Fpy3wNYMjcQCrRhj2N6uBvKZFarNkWwxt9w8GeiY9+jMSLO8wNoYqco2z7iydweVaGL+UmLif2Y7v6Yqkit932/UhcDjh8ScNvYnuNEebzllkSwKSy2KfHcLn9Ift+5Vpm23NYpQxGL5/Ai9vvdRw3q7BwzQ68mPiYAWHSWLdTV451GI62zN8AZpEZuYbBVD+Sp3rRl7qEawHNgO9pNI2hVB96TyUxkPrEccl0thtFeugi+npPIzmQwlCah6iywH26zImGLv0JUn29OJXsR2oozXAwbVi3U1eOdRhsWxZYACMiIiKarRjAiIiIiHzGAEZERETkMwYwIiIiIp8xgBERERH5jAGMiIiIyGcMYEREREQ+YwAjIiIi8tmUA5j6eRiKU3ZG3uBLGLmtZ1AlH7flgypBclufoEo+bssHVcLIbT2DKjON22cMqpQrt88SVCmW2+8GUSbKLbswgJWghJHbegZV8nFbPqgSJLf1Cark47Z8UCWM3NYzqDLTuH3GoEq5cvssQZViuf1uEGWi3LILA1gJShi5rWdQJR+35YMqQXJbn6BKPm7LB1XCyG09gyozjdtnDKqUK7fPElQpltvvBlEmyi27MICVoISR23oGVfJxWz6oEiS39Qmq5OO2fFAljNzWM6gy07h9xqBKuXL7LEGVYrn9bhBlotyyy4QCGBERERFNDAMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARERER+YwBjIiIiMhnDGBEREREPgtBABtFeuA9vDc0gozxShhkRi7jXE8CicQpJFNpsZaUlcFoOoWkVj+/Re/AcPjrZzSNoVQKqaFZui3V53eUwWvh+t5ljWNk6H30JOQ+1osPr4Z1Pf0g6uLapZxtZ5bBaxiZvZUzjURblDrHfW4qRocx0PtbUX8J9Jy7HNL9spjMYT/+DKRL02oEGsAyI/3oan4QtZEKVCxoQs+Y8YMgjX6MxItbsbI6Ypnhtgardh1GapRfR4xeRHdsS5nVzzB6mu5GRK5r5CG0Xw7DjuanESRja/XP7yxLmtEbsurIpE/j37asRrV1PSOrED1x1VhithlAvL7avt1spQHxFE8Rp8J9n1uCjS2nkOZhvwhjSPe2YnPdHMt+WYXajS/iTDo8B5iiMkfmU5xpeUhfRn2W6r/Ers7z037yHlAAu4nLiRZ9Y82tRrX8oNVRJMJwDEnFUR9ZjPonfoJ451voav8xNmk71Tzc1/qByMWznFY/S7Gx6Zd480QCJ958CbvW3iXqpwbr4/0hPGPM4HYyhtXml2k2NlZpJKJ14rMvR2PsAOLxuFnauvpEPAuR2+fQun6BaPyWYdNPX0O3dgZ6DIdbX8QrybSx0GxzHX1dL9u2m1Z++c9oqBEnQpXfQ8eV2XZSMZ0+Fd+PFeL78UVsbvkNzvR9iGTiVTTVi/2wog47u68Zy5GXTOplPDgvgkjd9/Czzre17+zrTesxr6IStTt+g6uBNwzFZo4R9Mc3ifWeg6Vb9htt3H5sWSp+L3I3mnqGjeWmR0ABTJ7RLcLKLS/i7f4jeLo6RAFs9BP0fXjVknQzuN71GObIxrs+jpTx6qw1egXnB29YglYGN7t3Ya6on6rGTkzv7jkNRt9H67oaRFb9E368bcksD2Bh/+yjuNS+CZUizK9rfX/azzZnlgxu9ezB4ooI5u88hhvGqzQJYz1oWiCCrK0NUse1KiyPneWJd16yh32NOL4swOaOwWzbkOlD673V4gRhE9ovBf1tLjJz3HgH0UWVqFj0IyRuqE+ivmvT38YFFMDGMfLpsH59eDSBaJgCmIvRRFTvmmYAc6EOVBEsaOpBuM7DRYPesQU1Fcuxq/sjnCiLEFIKZRLAMv2Ir5uHijmPoet64KfM4Za5hM4ti8U2vQfNvdeNF2lSxs8itrwKFVWPWnoSb+Ni/EFxMrAQjZ1DxmvkTh1f1qN14LbxmqSCWR2iiaB7r4vLHGO9zVgi2vq5O7tx03hNc7MbO+eK35nmoVIBBTCL0AcwdVZeicVNv8Mt41WSxE6dOobn18lLRmvRfCZcl4gyw8ewa1EVarYcxpVMufQClYLzEuRBdHT9DudCduOLeZCr/wWSA6fxVsdBsa5taO9MoO+a9cBOmYtxrK+sQOX6OC4yq07RKC6/uQtLIxHMWxvF638YQF/Xs6ifV4l561vxwW1WcH7q+LJanAxY+2JHkYo3iNerUR8fMF4LAc/MMY7hzq2oclvfzIdoXTtXhPSt6Byevv5QBrBCbvcitlpUfOQ+xJLs6JfGkjGssA5QrPgiHm7/UJwzhkkaZ5rXIlLZgNZ+OcppNgew6+hpkmNcrNtMlMgybG49HZ5BxnJ8oXMdjRJZ+gQOp2znpLNYWmzPlaJelmB71yfGazQ1N5F68xmsnaduLhJhrGE/kiEaQB5e2U6K2sZf4oycNWDkKs4n30LL5i+KuiyXAJYvMKobYaa3/WAAyyfzKU4//w2xY83D2tiZcA1WDlDmcjdeiEYRjT6NnY+uxUJtQGNp7hKZnAxuv/8i7q2ci9WxXiMYzuYAJmpk5BoGzakL+nDmjRf0AaklGFg6aSqA1T6ClmNncf7aiDbdyZn4P6BWvF65qQNXjEVns8yVw9giB98v3oOeW+ydmQ6Z9Fm07bgH1RU1WNmwQb/LO7IEDc1Hefd7MUbP4/COL7vfac0A5okBzJM4Izr8BJZGRKrf8jq/hJ7GkP7Dz1BfKbZhzePomsbu2UnLDKD9wYViff4B7e9fNELH++jYLsfMfAOxnvMhnv/KL+qsNURj91QAc461dB0kPVupsUnVuLe1b5bvw9NktA/xjeJ4Me9beP7Ex+KbkcHo1dP45ZYVIlBYT+Ior8wNpE4dQbt2l+4reKOnD8nWB8QxNwxjwCw8M8cYLrc/JLZ5nkuQ0zw+lQHMlQpfEcxbty9U85iEkzo7CMkXTe1TOWdilsIbKkQ16TeXVEcT4ei5VGPAVregz3qMU4OkGcCAW79D0+JKcXKxDZ2cemJajPU0YYHbGN/rXdg+R+yPYZmjsuwMobNRBNuwTZOSJ3Po+4LLMVEdm5bHkJzGPgYGsBxjSPc8h1UMX64yI9dx3dkbePs0mpeJBjKyAa39IbhNIZPGwCk5f5S1dKFlkzgYVNyDaMfbSCSHwhE6AnMdvc33iPqYj43tF8LRk6LugnTctq4GnEfWidA8q7t8xnClcxtqRFhYFH2HU09ME/1ExGW6iRLd+TY7qGEgEeMmKOPlMMiXOYY70VglfrbsefSaN19kcCPxIywqwY14AQWwm0glXtcnEzwQRb38wFX1iB4Q/277TYADH8VO80Er1suBmJEVaPzpS/o6muXX6Bmazc22vEa+EdUrH0ZT6yF9kszu1/DTTcsQqRBftIdfx6XQNpCzeAzY5VewaZVlm514E+3Nm1EXEaFm2TM4MRyW1uU2Uu0Pa5M3Lmz4MTq6T4j96xV9QszISuw6NhSOoBgUNa9S5Bto+YA3JEwXc0zdvPVoev1t9MqJWHu68HJ0nTYh57Kmkwy7BYwPvIG9sTg65Xc2cRxdLzehoVaclM/bhLh2E1TQis0c6qkp1Vi1oxVvnjiB7sP70CgnYp33MNpT03sxOqAAdhHtDTXZy0G2EuS8K2O42vl98aVzWy9ZQnYt23cZjKY6EV1b6xhsWSN21raQ3zE0iwNY+rf46brFjm1WhdqGf8GxsN1ZmLmEE3vkDNqWda3+S+x85dysfySMPkdRBPM2v47Ls7wuptcY0mdexEYZGKz7XWQx1jX9huN/i5B7Z7w4vqyLoj35aUhOmorPHPKxVK2bZadCdplI7UNoOTP9nyWgACYf5vyJMTjaWT5BOsgdPjOCa4Nu6yVLwOsWGuX40Fpjn5u1Dy62brOwP2De8iDcnnNIlehBuGVHe6D6JVwb4bzsJSHqN5U8ZQxZ4MO4J0YeX1NI9si6+y16P7wSsuPsRDOHfGB3r74v9H6EqyX6zgUUwIiIiIhmLwYwIiIiIp8xgBERERH5jAGMiIiIyGcMYEREREQ+YwAjIiIi8hkDGBEREZHPGMCIiIiIfMYARkREROQzBjAiIiIinzGAEREREfmMAYyIiIjIZwxgREQ0C6SRiNahoj6OlPGKKRVHfUU16uMDxgvSMJKdMTTWVaGiokIvdY2IdSbFOxFNHQMYERHNAhMJYNfEsitRUVWP6CEVuEQgO7Qb9VVVqNt6CKlx7UWiSWMAIyKiWaDYADaOdGI36ipWIpq4pv/cpH62EI2dQ8Zrs8kQOhsXoiLn8w8gXl+t9RJWNXaKqGo1juHOrajSehEbEE+NiteMbaF6Fs0iwm1jCxKpWx69korx97Rt6fVesqjfL3Z5UeQyowlEq11+JkpV/bM4LtfPRtbLYiyPnRWftngMYERENAsUG8CM5ZbHkHRtTfXGPDdozHzjyRiWi/BVV+f8/NkAVlG1FZ3D1opToU0GGEcAc26L9GnE6uejakMcFy5MMIBVR5GQb+3KZXm3/UDRAlju3x5PHcVusX45+8ZwJxqr1iCWHDFeKA4DGBERzQJGw2vpzbAXe2+Jd8AqFNBmqhEkY2vE596L44e2osoWtIyAc98jaFy+2N47poWTahHaZAgrEMAwKrJwg77cidbQBbBsb576HDotmE5if2AAIyKiWSBPw2vrAWMAczV+FrHl1fplNi1UVVkuuamA04JOEdKsdaeFk7onEY9tKD6AyXB39qUyCWB6MJ1MjygDGBERzQLFBrBCAatQQJuJVPBQl9mMy4pmHWUDzgUZuMzeMRlO7hNB7TQuqJ6tPAFsPHUIW+uqJncJ0qVXszqaEJGu+OXNXlDPS5CW9VP7hhZMHb1+RSpJAFPXid1XSN9wVY3/jkOelSCKrKgJDYTLvWW4qj6KeCLlSOjWDX4LqUQcUXlNV723vM34YCJ7h4v2xRTvZa1wjaWr1NIVWZbSSXHW0og6VQcV81EfjesDIc3PqX7mUsw6LTBAs+rbiF9wDF50DrT02ub5bv/WzsbEMs6xB0XvP15fyOVojHUimbZt+DKU57sx/hHiG8T+77Zt1M/q/odx9ip+N2d8h6Dq39yOXvuMZYCtMp5CIh5Fvfb7apm9OGh+bxW3728ITfW7tKgOdW77ssaoA7ff04pe/6OJKKpdj0sudZh3fWca90ZfYzsOuQzCl43shq2ibTiO5HH5s/nYEP/IsY/OZM7A5Qxkln3LGki0/79PLJM29n1HALPtv2r/69CPuc62wca6LxvvNe09YM51U+tn/35oecf1+1pYSQJYNmS5nCFoB2vZQPcVWQm5GyB3INwtka6/jaqqeuw+rg7cotGJb7V8iZwHn2GcFY2K/J1oXAUuGchatIbKDFxGANMqXqT4bACYIQHMaGRtgSR9FvHG5aLh3Y2EM3zk+VIUM0Czqn4fzlrf0zWAOd9fbUu3g54xLmGxbLgcwa/o/cftCykOwsm4fV8oS4W/G+PiTHODaPTtn9P4PW2ZIWNfl98DZ7i23uGk6tr9u2GePap9Qw24tZ4oyUC2TwYC57Z2fn9DaMrfpTz7cg7v40/RAWyi61v2ig1gkqV90KahsJ/ElPcxYRLMk6zcon+frftW9pLcNdkmaMdZ5/5aRAjK09a4BqpSXoIcv4DOreJ7YTuOSvrxr9ot6xShRAHMOCjnnFUbBxhtg0yiEkzqoK82psfBWUvf6oBvXyZfL53eIBkNgLYTqJ3NelvyDAlgHju5Z/14finUts0zQFOrwyrURY+Lr4DB+X6e29x4f+eZhraN5biEIzjkDP1F7z/e+2L+3txyUMx3Q4WtbOjRvwNqW6l9fQ0aG1fa61idbNXVYbG5Hb2+G0Y9a99/j+2pUaHRevzw+BxhMtXvUr59Occ0BLCJrm/Zy9PmuNaFDF2t9iskYhl9MLmlp2bG8/quqrnS5Osf5rav4vsbfXKNMU6szAOYpEKYLQfI49/Ep59QShTABPNgYlkx22uTrASNswFVO4h10jwn6wYwlvfcYEZ3q1xW7QSx/YjKsx/zzHCGBDDVENfvxqFkERne60th3baeAzSbEZdfWOsO7Hw/z20u/oTWMNSJ381uYf012Q1+w9gnLLcCT0MAU/WTHUtQbor5bgjWS5EDSePSY+6+fqCz2d7drtXP3YjGmy3b0f27ofWALd+gn0EWqldtH7JuO0d4CKMpfpfy7ss5piGATXR9ySB7x48gbh2qMpNp+4kIntYTZ0M2rCdc9y150qbvwzMggEnp4/YcoB2n8n1P8ytdAFNnseZlHuO6unnwNirBPLOwFuODe1SC60A41XWu3kOOGYofRKd5YLFuAEvAMn5qZwloA2on+Ej8iX36LMi2XgG3A105yV5q0+tOH4MTjx9xP7tz/VKoQKN2RKN+zW1vqXvjspO5A08ggOX+bcffcQa/oveffF9IR6NVjgp+N3TqUqS+nEdv7wWx/SwDTrUDsKx/24BZtbx6L2tZjq2dF4yQ7rGdpZyAVg7bYSrfpQL7co5pCGATXV+albInBi4hQ524Lf8uHr3Xum8ZbajZBkw2gFmPHarI78ybln15kgHM9b1lEes40O158q6PDxTfla0dSB4W7Z75GSeuhAFM0A4iqitbHmAWW1J0ERtAa0DdKijPQFE5huRgHHFzYKlxwLdtgMkEMLkh3MbFuB3oytN4KoGD8QOIqca67nF0OuvYNYA5A5czkNkP/LbLW1MJYDmNlGM9it5/ZngAUzy/G4o6uDjHX1kPnmntu6FfHpPfE3mHk6h/27bxCAcqfMuTsIFDMzCAZU34u1RoX84xHQEsq6j1JaJpVdoAZlwj1g7W2gHGmqKLDWCWg7TnQDgPKp1rydh68HGmcyfLwc92Zi+o98yZ12RmUb0hOZeI3AKYtm1VuLEXvaF2HvgtQdZ26UrIE8D0MzF1CVKFPLe/a4T+ovefPPtiThCYIWzfDeM1Sdu+9su8zsZe2w4yRF3rFXUj73AS3+liApighwPx/sffEb/rGKJglRNIyjcIF/4ufVh4X84x+QCWf2xZnvUlomlV4gAmvszawVoOxrvbcefIJAKY5DYQLudgrRgHqZwAZqxXhdtddeoAZB2Eb18HdYDSD5DlHMCcPVVWen0VDmBGmLWOC9J4D9DUqACg1aHl/TwDmOPvGMEopzExrtFrrxe7/+TZF/X9pIwHJBf13TBekooIYHrdL8Yj0e3Z2Z8nFMDk/nbN2J4u01+U5SD8KXyXXnq18L5svJTlXcee+6z2fVD7wiTWl4imVckDmNmblHNAmGQAk5wD4VyfXK/GN6jBg84DuHGbsZzrad/xAtNQONdB9eCUewAT1EHeNhDXOYWHhbM+tMZ4ggM0Ddkga3k/122eOw2F/t4u62cNalfEZytq/3HbF7PjY8r7lvNivhsWxQQwVccVlmBXTACzPudNq3Y1HrAR+2bCNBST/C7d++h3C+/LtpMbyTuAZXvptyKu1kPU6/Hd9fZQO9H1JaJp5UMAM860ci73GY2e2dXuLOLAUtRAuEN6eJIHbtuEjqLIRsec48vtAF7sRKwu62D24JR5ABPk+I94VBycVR2IYp/E1sJRH3oQcjuLFlQd5QzQVFSQtdSvFsCy6+G+PkbD5HEJWQ92Ihw078WTRe0/Hvuibf8pYwW/GxZFBTCX7e4awCx/TysuYzdz1k0fCO45EWvOe4oSolA28e+SsVyhfdmrB9Pr+JMzwapcj9y7HSe0vkQ0rXwIYERERHlCtFYsJ0tqXKlb719RTxtwBtPsFQ/7jSfynE9eFlfv5SjWcF/EyYL3e4l13H3UccIje6KP4IAtADufvlGgoyLMPcJUEAMYERH5LF8PntHD7fZEAKNX3Xv2/lsu7+sdviTzxhBbr69DkU9tcL8BQqzT8We1KYyyPZkifGnTGsnwqCZ0VUMDrMMeihiqQ2WLAYyIiHyWJ4AZ40pdnwjgMSQkO9500PG++cOXVDiA5RuLZ79hxD2AScZYaBWkPMfOquERKniWOoB59bDlPgfXu3dPlmx9538mszTFnr8q513s1uFFXr8neyvVc2iL74nNvUQv17PdNozCu17cej3tGMCIiMhn3gEsO77Q5YkA6u5nz9n7re97wxhjKhpC23N87QoGMONvet4Vql0u1RvtYgOY/hkL9LppfApgtvd364lT9eT22RQVRr2fO6u991R6/saNm0ls445dApjz95w3AJm89kPrembHrY6njmOf7G213MziXi9uvZ65GMCIiMhnXg2fYwLanGlUso213sugj8PKzt6v3vc+RGOy4RfLmHc7u/PswVBTtFgClitLQBvxaow7Hy/iUqUbrx4dWfKsU9G8A162V1G/BFx4na1ByEKFZtmTOR09fznbo4gA5rm/ebxuXWfjJZO6DG6EOe96cfR6umAAIyIin3k0fDmByxHILNxn779hvK8MKPNR/+TjWi+Eebe8C70BzdMbNeEAZg1JRnHcdTzhAJanEZ+aPO9v+VxyLQuvs7pUa53yxm5aev6mEsByLiO774f511PNoaf/DgMYERGVEbeGTzVsLgHG0hPjRs0pWB3txoD2vuqyo5rqxjmvXFbBAGb02nheSrKExluOxth87qz1pgEhfwMvx1G1G89qDTCAOXq09Hpy2zaiqN8v8NzZKQdP82kmXpM0u/+e6/OjNfn2Q+/1tG4/98+U2+vphgGMiIh85tLweV32URPGNh7CgHNMmElvhLMBzNogqsmINyB2NnfcWMEAZvbsWBt9pfAgfNX42y6F5rnEpTfuquEOWwDzDiU28g5Rl+fOOgOqN2O9VJCzlNxB/S4BLOf3rGPOrKYrgDn/nihecy1aMIAREZHPchs+vVEr8ESAC8cKzN4/5NKgCjlPv8gqHMCEIp/a4B5S1PimKsvYJ/Wax2D0+n04q70WYACb8CVID2pC7uoojvdOtucv26OUe2dh4R4wb24BTKyyti+6BX1JBTT958568er1dMMARg5uZz3OdC8HvsbMbmWNxwz2epHX6/uMHd2tS9b6N43/d30fWYxr/+bt6G8WXv5At34AcDuDVQeHAgN1Z6f8t5S77xuqGAck62zvrmUSB3SaAZwNnxGyingiwGje2fvdG1TZaNqffmG8LOj7cYEAJhU9EavbPm30wtmmw5CBqzM7hk0rE5yIdcrfH+/AooeQCQzCzxm/pxjbRN7UcGsqPX8qhFmDrDT9Aczsocy5ZCkUMQjftdfTBQMYObgFMMfOqa7zWwON13M7TWpHFweNnEsB9r+Z5XUwFVznA/JeXo0RsX+h1PgQPvcuV+FbygsekHN4bWciCoZbYLH0xFmOl4W/78U8d1YF4cn2/Kkgaz1mlyCAyXXSpqGQIVvNHyZeLXoaCvU5nWHRjgGMHIoIYJJzDMNEApgstjOD0gewbNjK9sCps+p8X5DZy2ObWLb7FQYwojJnBBazR80oLuOX9LbAsZxZjGNxTi+hKDnvJQNXkT1/bscK83KyvOtVhqBSBDBd8ROxuv2+W6+nHQMYORQZwNQlAzVXTtEBbANi8ScdZwZ+BDBBXW6UZy8DSV56zKvwLeXe+4YXBjAiIoUBjByKDWCOsJN3DJhcZsSy/BXj8SCqG9mnACaoS5H6evHSY15F3VKu6tJRXEMWAxgRkcIARg5TCWDF9IAZy9sGv4v/9ymAad3fxhiE3JsByNWUbylXGMCIiBQGMHIoNoBN9hJk9r2yY7D2I+ZbABO03y3irifKZbmlvLubAYyIaLIYwMihyAA26UH41vdSA+O9LlsxgAWmiFvKGcCIiCaPAYwcighgU5qGwvFeqkeFASxkCt9Sfo2XIClIXuNO5VjFTuuNI3nujLMdR9TxQ7xHzjMDBe2kRP6NiS5/B+r+3/+f/Xip2IZicEDEbMMARg5uAUweRKxFzuESt92K63kwVKW+FSc8wpE5MJ4BLFwK3FLuvm+o4hbGGcBoGrme9Km56qxjPCcRwHKePWl9TuXEl/+bn/wL5yGkHAxgRERUfjx73S2PLtJ6pSYawNagsXGlY7b2IXQ2LkRVXR0WT2r5DzgPIeVgACMiovKTZ9iD9WHJEw9gDTjQ2Yzl1suK2pjXuxGNN09+ec5DSA4MYEREVH7yBDB7sJp4AItfOC0C1GLzsqIW6ORzKi9MZXnxuhpuoV2a5KXH2Y4BjIiIyk8pA1gqrV3G1C8rykua9+l3BE9peYnzEFIWAxgREZWfabsEqQbQWwPVqP4e8rLitV7Elt+HWHIkT2ArZnmD9hpvAiIGMCIiKkdFD8J3/jtLv5N3jR6WHIFKH8e1GI9Et+uXE+Wv5glghZc3MICRgQGMiIjKj2sAc5uGQo29qkJdYxxJY9D7eOoodtfPt0wN4QhUKrhVWCYkzhfACi5vYAAjAwMYERGVHy2AqQHt2VJVH0U8kXKMr5KTCHciZn24vAhp9dEOM5DlBirxW9qlTNVDJuQNYIWWNzCAkYEBjIiIiMhnDGBEREREPmMAIyIiIvIZAxgRERGRzxjAiIiIiHzGAEZERETkMwYwIiIiIp8xgBERERH5jAGMiIiIyGcMYEREREQ+YwAjIiIi8hkDGBEREZHPGMCIiIiIfMYARkREROQzBjAiIiIinzGAEREREfmMAYyIiIjIZwxgRERERD5jACMiIiLyGQMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARERER+YwBjIiIiMhnBQNYRUUFCwsLCwsLCwvLNBYGMBYWFhYWFhYWn0vBAOa2ABERERFNHgMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARERER+YwBjIiIiMhnDGBEREREPmMAIyIiIvIZAxgRERGRzxjAiIiIiHzGAEZERETkMwYwIiIiIp8xgBERERH5jAGMiIiIyGcMYEREREQ+YwAjIiIi8hkDGBEREZHPGMCIiIiIfMYARkREROQzBjAiIiIinzGAEREREfmMAYyILMYxkjqFN+IxNEWjiMrSFEP8jVNIjYwbyygZjAy8jfZ4HPE8pa2rDyPa4pfR82qb6zJexfzdQkb60d3u8t7tnejueR9DOetORBQsBjAi0mU+RbLtcayqjqCioiKnRGq/h5f7bxoLS2kkonWuy9rKkmb0jonFU3HUu/08X6mOIjGq/7V8RhNRVLv9virV92BH21mkM8YvEBEFjAGMiIQMbvTswbKIDCx3Ye2uAziW7Ecq1Yfetw/hF09vQG2kDtFE2lheygawqvooDjh7n4ySvwdsLxrrqsR7VKGuca/jZ8X3gJkBbM4mtLydQCKRwImuDrS17sUT9YsR0YLYIjzccVF8UiKi4DGAEZEwhM7GhSKkVGLRrmMYzkkpY0j39aB3yNodlQ1g1dEEiuiocjGAeH21eI9q1McHjNcmzgxgbj1mo/1o37xIW8/Iva3oZwIjohBgACMika9Oo3lJ5QSDUJkEMGRwvesxzPH8ORGR/xjAiEhklPfQsnqOCEJVWNZ8GreNl/MrlwBW+OdERH5jACMi4VMRplZoYapi3gOI9XxSRKAqlwB2Hb3N92jrWbmxHZd4CZKIQoABjIg0mUuv4+Ea4w7IyGKsi8aRSN3IM2i9DALY6BUk//ePsKZSBssGtCStNxEQEQWHAYyIDGNIJ9uwY1WNHsK0IFaLNdv24a2B6y5BLBvAPIuagsLTNAcwr1J9H37UfYl3QBJRaDCAEZFNZuQCEvEo1tXK6SGMABNZgo0tpxzzaGUDWGThSnyjvh71jrJuazv6886B6lMAk8X1MxARBYMBjIhcZUZSONXxHBrMILYA61vPWQbol8MYsHGMDCXR9bPvoU6b42whHmwfYE8YEQWOAYyI8sqkTyG2boEewiq/h44r6ppiuQzClyw3GRS8LEpEVHoMYERUUKavBatleKmwzoZfTgHMepmyAfHU5NaWiGi6MIARUWE3u7FzLgMYEdF0YQAjIpFObiA94jVaPoPbvc9jmQwvkQ1o7b9lvF5OAewGkrH79GdC8hIkEYUAAxgRaQFmXu0GROPvoD9tTTDjGBk4guiaeSIkRTDvwZeRMkewl0cAy4x8jJ5ffh9LtUH483BvS7LImf6JiEqHAYyIMJaMYYUWUESJLMTK+k3Y/tR2bFpbZ1y2q0Bk6RM4nLpp/IaUDWD5SmRFDEnPHqdpDmB5Sw1W7TqM1CjvgSSi4DGAEZFwE5d7DmJP41osVEFMlerl2Bh9GWeuOvuNbqKv9YHCwWdBE3o8A9jH6Nh0l1huagFsvO8XuK/amMXfViKorrsXm3bG8EriAkaYvYgoJBjAiMgmM3INg6k+9J5KYiD1CdLsMSIimnYMYEREREQ+YwAjIiIi8hkDGBEREZHPGMCIiIiIfMYARkREROQzBjAiIiIinzGAEREREfmMAYyIiIjIZwxgRERERD5jACMiIiLyGQMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARERER+YwBjIiIiMhnDGBEREREPmMAIyIiIvIZAxgRERGRzxjAiIiIiHzGAEZERETkMwYwIiIiIp8xgBERERH5jAGMiIiIyGcMYEREREQ+YwAjIiIi8hkDGBEREZHPGMCIiIiIfMYARkREROSzmRfARj9Bb8fP0BTdi/bksPFiSJXTupbMOEZSv0XHi82IRqN6adqH9u73cW00YywTnEw6iTfa4ojHiyiv9mAo+FX2X+YGUokOvNi829yGTbF2dH9wFaPGIuEQ7n2tPMg6/B0O/Xwv/nn3bjwjy7P/itfe/gCfhqoOy2U9Q0h+n08ewi/27tHrbfczeG7fqzjeF57vc2bkIn57qBV7nzG27e7n8LNXj6Pv2m1jifIwgwLYGNJ9nfhxwxJEKipQUVGN+viA8bOwKad1LaHMpzjT8hBqI7IOnKUKtRtfxJn0mLFwMEYTUVTnrJtHqY4iEa7EUXKZ9Cm0bFT7saNElmBjyymkw9DelcG+FnqiDnv3P4Kld85F9R3O8jksfejn6A1DHZbLeoZQJn0a+x9ajs/k1Jsody7Hpv2nA/4+i7az9+fY9KXP5a6fKJ/50iPY3/spyiViz4wANvoxEi3fQ53t4BrSUFNO61pSo7jUsQU18vNHVmDLL44iOZBCaiCJxOtNqJ8XEfVSidodv8HVAL9NmWu9+LVbb5dZ/g3Nm76ob8clzeidTcf1zEV0PLxI++yRpVvxi2NnMZBKYSB5Aq83rcc8bd9eih1dlwM+IJbHvhZuo7h8aBv+RDZ0d34V2//tGM6dT2Hw/Dmc/PWzeOCPq0UDOA9Lf9gVcB2Wy3qGUCaFQ41/pgeZr+zAS2//AecHUzh/LoFfP9uAWi3kfAVPHA3u+5y5/Gts+S9yG34ef7GtFW8nBzA4OIBzJ1/Hc/cv0da9+ktP4ujV8jgQl38AG/8Q8Q0LxAE0gnlrn8TLZ06itb5a/DuEoaac1rXUbryD6KJK8dkXYXN7v6NrewzD3U9hkdZgfgMtH9w0Xg+hTD/i62vE55iLu1vOYdx4eebL4EbiR/o2qnkU7Rcd2yhzBd27lot6EeHs7hZ8EGTFzJR9LUj/kcAzfzZPNHB/hsZXc+vw/779I/y5Fnrux/6+AOuwXNYzdDL4j5P/rNfNf/k+Xkvlfp+PP7VKCzifWbsffYF8n4dxcvdXxTpU408efRUpx6XkzP/txtPatr8L9+5/ryyOxeUfwMZ6sGflA/jn188a4zgGEA9rqCmndS2pcQx3bkWVbPSWPY/e2y7nU5n30LJ6jqibKiyPnQ3plymDWz17sFh+jspNaL80m64/DqGzcaG2fZY1n4bbyItMXwtWy7qpWINYcsR41W8zZV8LkqjDIzswXzbO//0neNe1Dt/H/q99XjR+n8NXX/hDQHVYLusZRkM48oMvavWyau8Zj+/zfvy1rNs7vo595wL4Pg8fwbbPyr9/L/a+e8N40eomPty/XvxcLLPqBZwrg41b/gEsRzmFmtkawIaRiC4TnzuCBU094rzUzQ30Nq8Wy1SgclMHrhivhkrmEjq3LNY+x/ydx8QazyI3TyB6l7x0twJNPdeNFx3GTqN5iex5ugubOj42XvTbDNnXAvV/cXL3fxcNWzW++Owpjzr8D7y792ta41fz94dw1XjVX+WyniF0M4FnFstLe1/Fc6c8jmRjvdi7TPYwLcajhy4ZL/olg5snn8ESGa7+9Fn83uMK49i7e/Hf5DJ/9A84VAaXIRnAAjVbA1gxn3sUqXiD1iiGdWxV5mIc6yvF+kXuQyw5q+IXxMZBvda71YB4yqvnT23nSixpPu3RIJbazNjXgnUeB+9fIBreBXig7bzxmtMoBtse0oJN9bK9eDeQOiyX9QyhwTY8IOvkjodwcNDr+6zqdx7+295en7/Plu12fxsGjVdzmJ/ja9j77n8YL4YXA1igZmkAG+tB0wLZe7II27u8+xvMOxBDeXdhGj1NK7VGu3J9HBddrnbMZGM9TVggt82cx9B13evDp5GI1ml1VB1NiENoAGbEvhawsVN47k9l78if4YdHvfuMRk/uxkLZ+H1hN04GUYflsp4hNHbqWXxR1snnn8DRG97f55O7v6yFoIW7T/r8fb6B3z8rx3/NxV3/eNT7asPoSTzzBRnAvoxnTqaNF8OLASxQszSAjSYQrZa9J3WIJry/JGFuFDNXDmNLjWzYl4iG/RPj1dmjuG0TggA2A/a1wBXZqAUebMplPUOouDoJMoAV+bcZwILGABZ6Zd8o3sbF+IOolOu2eA96bs2y7i+BAWwWYQCb8RjAgsEAFigGsLJsFG/9Dk2L5eDyatzb2ofZF7+K3TYMYDMCA9iMxwAWDAawQM3SAGaOy6lBQ/tF40WnDK53PYY5slFc0ISe0AyWHcOVzm36pJ4129B5ZXaO4jXHgEUeQvtlrzq4gq7tcqLWSJ47EEusrPe1kDDHVtXiu6+mjBedMrhx9AncJRvxPHeplVS5rGcImWPA7nwEr3l+n6/i6D/KiVrz3WVaKtkxYJ/5zqu4bLya48ZR/PDzMoDluZszRBjAAjVLA5j5uedgdct7Hj1ItzHQul4sU4FIQ7v3F85vmT603ivXvRKLou/MrqknrMy7IL+OFq8JLTMfonXtXLFMvvBTamW8r4WGuvvt8/jr/e971uH5lxoKN5AlVS7rGULm3YPrvSeozXyEA/V3iWXyBdxSsdwF+bX9+NDjskPm/Ev4plwmb5AMDwawQM3WAHYdPU0rtAavqrET7o8hVxN9BjmFgZNl9vfZPmu62bO0EI2dQ8aLDsOdaKySIW01mnuDiqrluq+FSbb3Yf4PjnjWoT6RZxBTFCjlsp4hZPYefhHbjnh9n9VEqMFM8WD20n12B44Mu82yapmIt0ymGGEAC9RsDWCW2cmrHkWHy2W8zJUObNYa75Vo6gnJtXxz4tUKVG5sxyWPs7DZQYUWEWw2d+BKTl2M4UrHo/o2DvRGhTLd10LF0rB99vs45FqHh9CoNc734LlTQdVhuaxnGKlgKsLro4fcv8+Hvq/X7Z8/h98H8X02A+ASNB76OLeHM/MxDj0qnwc5D8uf7cEt4+UwYwAL1GwNYIL5fL45WLrjkO25XpmRPryyRR+8HaY5tjL9rbhXe4j6CkQTnxqvzlbW3sAvY8fh85aBseMY6X8FW2rl9q3B+ni/x+Ugn5ThvhY65jMWP4+/+OHhnDp8bZs+QLqmoQ2pIOuwXNYzdCzPgrzzbjzxxgX793ngNWz/kqzXWmxsC+r7rJ4FKR8W/iSOWJ9XmbmBgdcew1K5/n+0CQdTbg9TCp8ZEMAuoyu6EfX19Ub5S9RVy0sjEVTX/WX29XXPoCvwRxOU07qW2hiuHnsaS7VAIz7/0gew/ekoojsfwZqFVVqDGFn6BA47HwobmE+RiOqXsiKrY0i6PWdutskM4diulYjIEFYxD0sbtuHp6NPY+ehaLNS2a27gCUa57WthJOrw7f+Jv7hT9kBUY+FX/g4//J+78cz/2IK/+X8+594oBqJc1jOExPf57afuwWdkiLljIf7iO/+I3bv/J576fj2+pNVnbqj1W+bq/8HTX5HP8hTr84VV+O4/RvHM7ifxg69/SV/vnPAYbjMggF1Ee0ONdhDNWyq/53r5wV/ltK5+uInLif3YvqbWaMSNEqnFmu37kbgcooPkjWPYOV8f8/Rg+0CwPTphMvoxEi/uMIOMKpGF92L7iydwOfDwpZTRvhZaog5PtuKHqrFT5c4v4W/+sRUnQ1OH5bKeITR6CSd//oQZVlX5zP/zTfzw54kQfJ8zGL2cwC/+8ZtGKFTlc/jS15/AL05eKpvwJc2AAEblbxTpoYvo6z2N5EAKQ+ly+gqRZjSNoVQfek8lMZD6BOnQBC8n7mtTJ+swhQ/f7cW584MhrsNyWc8QMr7P7/7+HM4PhvH7LIJY+hOk+t7F788NYHAoXVbBS2EAIyIiIvIZAxgRERGRzxjAiIiIiHzGAEZERETkMwYwIiIiIp8xgBERERH5jAGMiIiIyGcMYEREREQ+YwAjIiIi8lkoA5j1kSZBlkLcfieoEgZu6xVUycdt+aBK2LitYxClELffCaqUK+ujZoIshbj9TlCl3Lh9hiCKF7dlgypBYADLUwpx+52gShi4rVdQJR+35YMqYeO2jkGUQtx+J6hSrtwaoSBKIW6/E1QpN26fIYjixW3ZoEoQGMDylELcfieoEgZu6xVUycdt+aBK2LitYxClELffCaqUK7dGKIhSiNvvBFXKjdtnCKJ4cVs2qBIEBrA8pRC33wmqhIHbegVV8nFbPqgSNm7rGEQpxO13girlyq0RCqIU4vY7QZVy4/YZgihe3JYNqgQhlAGMiIiIaCZjACMiIiLyGQMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARERER+YwBjIiIiMhnMyOAjQ5jINmHoZFx4wUvo0gPvIf3hkaQMV7xVRHrmRm5jHM9CSQSp5BMpcUaz1RFbIvRNFLJU6IuRH30nkd6NIitNpF9Riw7NIhU6pOA1tVvBepGbL+hVErUh70MXvP7+1fsNhzHyND76JH7W6IXH171ez3DTNTh+ffxvlsdZkbw6ceDGBx0Lx/7ur3zrKdJLDP4Hn5/8iROnnwXH3E760T7dP5cgXZULvPu70S9/Ra/f+8yRvyqOLGPDb33e/3vnhvMe3yVbeh7p34rlv0d3j0/LLZ2eJV5ABMHzIE30dywBJGKCBY09WDM+IlTZqQfXc0PojZSgYoFTejxWrAkiljP0Y+ReHErVlZHLLNs12DVrsNIzbDGvPC2uIlU9z40rqyx1EUE1aueQmfqprFM6U1sn8ngRs8eLJPLiu3W0H7ReH1mKlw3I0jG1or9XW0/S1nSjF6fvn/FbsNM+jT+bctqVFvXM7IK0RNXjSVmL1mHR/duwtI756L6T5/F7511ONiGB1xmFjfL/W0YNBYtpYLrKWTSvfjltq9hoXX97lyOTftPIz1rU5hon86/hb3fWY7P3FGNLz57yqUdHUP63ZfQuOLzlm37OSx96OfoTZfyy3wTl0/+AtvvqbX83WosXPMjHMlpC8Q69v4cm770OcuytfjaU2+Etg0t3wAmA0vL91AXiWBu9VztQF8dTbikXbEBEy3YXDcHFXOrUS0PxNVRJPyKxcWuZyqO+shi1D/xE8Q730JX+4+xSa5zxTzc1/qB+IrMBMVuiwHE6+9C3cZ/RvzN40icOIJf7roP80TdVa6P42LJv0uT2Gdu9yK2eq7ReFejPj5g/GCmKbZu0khE60RdLEdj7ADi8bhZ2rr6RDwrtQlsw9vn0Lp+gQhcy7Dpp6+hW+sBO4bDrS/ilWTaWGg2EnV4cr/e6P7nBVgog80XduOksw5H+nD0V2042GYv//7sQ/gT0QjW/P0hlDbGFrmeGMbJ3V8VjfJ/Q+P+LvT2fYRzJ1/Hc/cvEa99GU+9fc1YbhYZvYST+/8BX7mzGgu+cJcIYHOxcPfJnPYpk3oFm/+4Gp9Z8Q/Yf+QdnDzZjV8/24DaO+Zh6Q+7cLVkx+TzOHj/f8XS+/8JL7S9gbePtmPv3/93bT1r1r2EAbNhzGB0oA2b5Dp+ZQdeekusY+I3eGnbV8Wyn8eqZ3+L/zCWDJPyDWAysFSvxpYX30b/m09qZ67uAUw25ouwcsuLeLv/CJ6uLqIxnU7FrufoJ+j78Krl9Qyudz2GObJBr48jZbxa3ordFjfxyflL9u7tm93YOVcsX7UVncOljqMT3WdG0N/agMrIWjT9+FGxjWdyACu2blQAa0A85VlxJVTseo7iUvsmVFbUYF3r+y7Hj9lMNn5/hr/a9nMcH3gTu7/gFWzcpPH7Z+/xKdgUuZ5jp/Dcn4owbvtZBjfffgoL7vgcvvrCH2bIie4EyN7LL3wN239+HANvRbWewdwANoJzL3xdbMslaDz0cfZybaYPB765ANV/9Pd47XKpvjk3MdQ3gE+tPVg3juKHn5e9Ww/h4KD6uypcfxXPnBw2XhNu9eC5P5+H6s/uwJGStxsTV74BTI47+FS/dj+aiOYJYOMY+XRYb8xHE4j6HcCKXs9cavmZE8CmsC1UAPPl8vHE1jNz6XU8XFOFRbuO4coJuc1mcgArtm6CDmBFrmemH/F181Ax5zF0XZcLU5a1Dk/imQkEsMzVN7D9v4iw899/gndvl7pei1zP8T9g36rPicb4+zh0RR1EbiPVtgk1d3wR244MGa/NItb26eRujwCWFuHmyyLcNODA+dvGa5IKZl8WocfHnmK1ja0BbKwXe5eJoPWfn8Lxm9b9bRjH/8dyLZg9d+qG8Vp4lG8Asyg62AQRwCwmFsDUmXklFjf9DreMV2eMCWyLzMgFdD//LcyrmItVzad8uHxlUWg9M1fQvWs5Kmq2oVMc1PVtPJMDmEVRAUxdgjyIjq7f4VxRNzNMs3zrqYJ9/S+QHDiNtzoOinVtQ3tnAn3XrI3NLDehAKZCTS02tvX7u73zrucoLr/1FP7izmrU1j+DXyfP48OjzXjgj+ehtuEl9JU8KIZb4QD2Nex913ohbxSDbQ+J1xfggbbzxmull7n8Kjb9kdjGf/4cfn/L2GbDR7Dts+K1nPGGt3H+pQaxjuEM2AxgPppQAFNjiiL3IZYMX3KfskLbYuwsYivmiAZcLKOVStQ+/DL6/T5I5l3PDEbO/AtWRbKXrxjAlOvoaVph2X5GiSzD5lafBzznW085RMC5jkaJLH0Ch3286SPUJhLA1GWf/7ITR/+vz5d9Cq7nTaTe2oNv/nG1aJTFcneIMPadVpwr6UDy8uAdwERwffXvRaCeh6U/aEPvYBqjI1dxIfl/sP/R/+ZzALuBcy+sw2fuuAt//cK7Il4Z1I0gOQEsmJBYLAYwHxW9nplPcfr5b6CyYh7Wxs742+Pjl0LbIvMxul94BtFoFNGdj2DNwirRKAZwV2i+9bydRMu98xBZHUPSCIYMYFmZkWsYNKef6MOZN17QB8VH7kZTj2WcRqkVE8BqH0HLsbM4f20Eo+kUzsT/AbXi9cpNHbhiLDqrFR3AxnD1yD/iT0RjvfzZHv977gusZyb9B/zqh/eKoFGLv/rORvzVF0QQu3M5vrv3GAZn2N3mE+UdwITRCzjyw7u1we/ZOwxV8SvcjCF95n/hm380FzX1LUhq15wNDGDBmVkBTJyhHX4CSyOVqN3y+oybgsI0wW0hpwmI1ctpKZZge9cnxqs+8FzP20i1P4x5FYvR2H7WnOPqfMd2zK2YizWxBFKD1/RxKTPVhL9P6rJ6JO+UMdOumADmHGc51oOmBZHAjhWhU2wAy/TjYEOtCDUbcWAggIET+dZztA8HH/oiqv/4QfwkcUnsjRmMXj2DNu1OOUePyiyUN4BJmRsY/P2beE27y/U1/OZUH8699Hci3PgxBkxsq9RhPPGVz6P6S/+IQ86e6cuv4rvy7lfPS5B/hh8eDd+UMgxgPiq8nip8RTBv3T6cmcnd4pNovFPxBu3SUMHtPJ0811ONcRI/8yxBDUD3ySS+T0V/V6dTvvVUY8BWt6DPGpbHzyK2vCqwY0XoFBXAMrh16jksv6Maf7LtjRJOTZBHnvUcO/UsvujWM6fuqvOYO2y2KBjAcgzhyA9EoP2jf8Chq6WsOEv4+uO/w896PxWvOLje4SqpQfhfx75z4buWxADmo/zrOYZ0z3NYNRvCl5RvW2RuIn3d+eJ19DbfI0JNNe5t7cv9ApaK53qK7TVwWp+l31LebtmEORVzsDL6qvj3OQzN5MsaE/4+qW04HxvbL4RgGwrqLsjKTWi/lP1h5mIc6ysrEFkXR2oGb8KiFRPAMpdwZNufi8bOMRWAn/Kspx4wXKabuPk2nvrPDGATC2AZ3P7g51j3R6UP25n0b/HjNXd5hy+NEQbvuBd737WMmf6PBJ75s3n2AfshUr4BbDSFxCtt2sSOB6L1qBLBpqo+igNyosc3kpZBvjeRSryuTwJ5IIr6KnEgrqpH9ID4d9tvkCx10ClqPeXO3Ir18yKoiKxA409f0tfXLL9Gz1Dhr0T4FbkttLnTVmFzUysOd58QQeYYOn76MOrkZJo1W9BhaShLY/L7jB6yZ/IYsCLr5vIr2LTqYTS1HtInNj3xJtqbN2vbMLLsGZwYLnVLV+w2VJeSK7Gw4cfokPtb9ytoqpcTs67ErmND/gXF0LmJwZO/1idWje/GA/Ius89+C8/Exb9/1ZUzcD0z8BLW3TkXn1m7H32+jr0vbj3NqTH+uAHP/fo43pUTsZ46ilee+VvUhniyzpIS7dPJ136lT5y7+1uYLwLY/Pt349/Fv3/1m3NmOzp+/jf4Xy+04cjbCZw8+Q6OvvIsvitnnP/jv8fBgRL2LN1+Dwca5ES5n8df/OCnaNMuf6ryK7x+6rLx/czgP079GKvE/lezZif+XU7E+vZh7P+BvLz8RWx+9Xwov8flG8Aut6NBNsgi0OQU22SdF9HeYH2kjbUsRGNniW9NLWo9x3C18/vaTO+uy1XUIZqYCTNyF7ktRs+jM/oNLLTVm3wU0eNoS3qdAU2nye8zMz+AFVk34qz1p+sWOx5FVIXahn/BMV/uLJzANsxcwok96+3fv+q/xM5Xsg3Q7JTCa9+xPgLGWpy39f8H3t37NfH6l9B4KOVzY1fsero9qkaUO/8cDc92zdzxtvmosVPW+lDFMnnpWPIF3G1b7nNY+rfP4LXkcGm3tQjN28w7VnOLrbcu8ynefen7+Ip1PUP+mKnyDWCi2vUHH2cf8muWIetDrDMYTX/ivpwvD00ucj0zI7g26LKMVmbKw50nsi3ksikktQeT/xa9H17xcUD7FPYZ7QHUl3Ct4IPhy9VE6kbs+6lzxsOt/X64/ES34Xj2Qdw955BK+7em4aXXodsDtgcH3b6vYtmPg7jxZCLrKYjv6OA5+WBnPoxbb58+dqk3UXLa0UGcUw+5/siv47H4Xl675L5+gx9jKOd7KtfzAt4tk21bxgGMiIiIqDwxgBERERH5jAGMiIiIyGcMYEREREQ+YwAjIiIi8hkDGBEREZHPGMCIiIiIfMYARkREROQzBjAiIiIinzGAEREREfmMAYyIiIjIZwxgRERERD5jACMiIiLyGQMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARERER+YwBjIiIiMhnDGBEREREPmMAIyIiIvIZAxgRERGRzxjAiIiIiHzGAEZERETksxkdwEYTUVRXVKDCtTQgnupDvL4aFVXfRvzCLeO3DKk46iuqUR8fMP7f7T1Uke81IhZr0P//RGvB5Q/89iVsqKpA1YY4Lowbf9MwfiEuflaFuuhxpI3XZrKC28moz9y6Gs3WeWq0BNvpAfzkpw+iqmI+NsQ/gn0z3cKF+LfFz1YimrhmvEa6NBLROpf6NEp9HCljW3GblpNxpM8dwb4frEL1HXP18tlv4Zm2kxjUKjKNk7u/nP2Zs9zfhkHzfd7Ev+/+FuabP1+FbS8cwbm02iLncfD+Bfbft5UFeKDtvL7o+CBOtu3GA59VP/scvvKDGNpPDprbd/TkbizMeQ9Z/iseaDpmrH8e4xdxZMcqLNx9UuyhM80wzh15AdtWfM6sl/n378ZBVX+jJ/HMF5z1poplO2jv8xKeuf+/Zn++4gfYd+Rcth0bbMMDtt93lodwcFCv4fHBkziYs4+8ipODqq3Os7+J/XLPO9ntb3cLgyf3Wz6v3F/aLPuef2ZBADMO5K4G9AAmDsxV9ftw1roBrAHMxvgd2YgYr+gcDYfJa3l1sHc0BOMfIb5hPirqdiMRwA4RhILbyWyE56M+dtoSSr3qXJqm7aS2hyOkz7aQPDFGAMupewtu07IzfrEND37WGlhkkGoTDdkCfGX3O6LOjAbRDFpuxO/84V9FWBLvs/uQ0eip9/kc5m9sw8Wcw96oaLcfEg1ltnE2pc9gn2jwbYFBBrKWH+ArIlw92NavvaYHMOfvi4b4nWaxLp/DV1/4g/67bozwJRvrhTMugN3CxbbNmG8LLCJIte0Q9XcPnjkpTkS0AGYNWm6G8YcXNmrv88xhFbjU+2S3g50RsnP2F+s+0mYGrvHBd/CvMvx/djMOXpSveexvYvufaJLB7evYd27EeDHL3I9fOKOt5/jgYTzmue+VFgOYPEBrDYHjwFvyACbkNASz8wy8+AAmi7VufGisBb1htvTWzMKQPDETCWDcpuXBKwSN4NwLXxeN4g4cGR4uHMDG/4B9q1RgsxKN7sk9orH+IrYdGTJeU4r5285tpoKF3li7BzBpCEd+8EXPddYb578WQeSUFhYWzrgA5hGCtO0kQskPjmC4iAA2fu4FfFUFNptrYp+4x2MbFfG3jZdM4/04uFEEbi0s5Qn8w0ew7bNu62zsS7b1yRPwS4wBTDtANyMeXWlvCPwIYIK1IRgYmJ1n4MUFMLEtYvsRrauyNJL+NNb23sokBniZqoBiAxi3aTnRG1lrz5VT4R4w/T2+LBrqiRzhPBpIo6Fe6BWKLI3w5APYSbym9azpYcHzb5UtFWKtPVcOBQOY8R5f2I2TE6oc9wCWfx8ZF5t1B+Zr21KGu4kGMDf5gnxpzYIAps6yHUU7KFsO0OnTiNVbzoB9CmDZhsBYr1l4Bl5wO5nb4iOkz+5DvRlS/WqsBdVDoq0XL1Pll28MmPGd4jYtQ+qSkhprI8fkxHHQHOOTZ0yOMVbIOwjl4xHACjWyloA24nUJ8sjOPJfIrGZqABPSf8BB67g+OW6r7WUcOWf0P+UdA1YgCOXlFsCsAcu9prMBbdD976pLxualygLS7+AZ8zK6v2ZBAHM7kCv2A7RtDIhvAUy6Jhqsle43A8wCRfeAadvCepl2yKPOpRJsp/Rxrbcmd+A42U2gB4zbtAzJQcyv42BbzBjI/Dl8ZcdhDOa7JGQINoC5BAjbTQT5zOAApsixcy+34eALcvycrJ9VeOzIRYwX7AErvN3dTVMAc25TUWxjAvNRlzTv/1f8IYCODwYw2wHa0hDEm30MYMbvVkeRmLHfbm8TC2CCOV7nScRjG/xrrI1lqqOJmXsQnhYTDWACt2mZMsZa5euRsMh/eUneRfdqtufFlO8S5ALvAfRaQNMH2N9yBD9z4PX9zThh3lWXzywIYFZGMNEuK45M8RJk+hyOtL3pctnaLYCpfcR9AL34qRHQ5M+HHPtbtkdzIne2Vq/Yg5MBXXViAHMeoG2XJRjA/DDhACaosXP6dmJjHS6TCGACt2mYGWOlVr2Ac862SptaoLgAlm+Atd7wul0O9BokrcbuuF1qKjwIX4Ww4hrgGRrALCHVtc6LCmBq27ndQJFvG7kHMHMfcbsrseAgfBXCPpfnkqK86/aQNl1G8QG8NBjAXA7Q2YaAAcwPkwlg2d5KNtbhM7kAxm0aZuouRccgfDV+SAsxRdwF6fo+skE0pqFwvRTkFcAEYxoKOW7pX9Ulp6KnoVDrkq+xVmZqD5i6S9E6CF9tD2NcVFHTULi9T3YaCjXlg51HAJN/X5uGQs7PtX/i01CodXG9K1O8jzYNhbxMGcxlR6tZEMDUGbWzyIP/mx4HaNUQMID5oeB2evoJl8ZaMHsr2ViHS75B+LKIutcmTOU2LS9y7FebfaJNLUipuZryDcKXRQUg2cA7JnTVBvRbJ2K1yhPApKInYnX7fdVYG+OdjFdzzdQAJuTUnyjWsXF5B+GLYgYgeQnZPqFrzkSsNl4BTFf0RKxuv68NrJe9mztxxNbDZfTkmu9pLV6XxktnRgcwIiIiojBiACMiIiLyGQMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARERER+YwBjIiIiMhnDGBEREREPmMAo5BSs5u7zaRulHsfx9Ny1vSqbyN+wTrbsWA+3Hk3ujufdJ9pv64R+xIpOS93/pnb886kPtsNI9kZQ2NdlVlfVfVRxLV6FUYTiFa7PVHCOXu9MWu9td61shyN+44jNe71c1Wqce+TT2iPEKvaEMcFx5Tm+uPFqlAXPYRO120tftbYgkRK7EfaOjt/rorbZ5nhtGc9ypnC3Z71Z5lZ3DEjedEzmZs/ty7nmBVfWwf1OJx8M+6rZayzrBeYoV8uk2e296CfF1ga6ukC4jN+dgeODDu+MNozIuXndz6CyOVpCHK2+5eNWfMlr7rMmRXf8YSDvDPuG8tY94O8y+vL6E9AcPt5kQ/sLjEGMCoPrs8OVA2rs9FVj5JaiWjimsezJodxNrYBVVp4u1L42YXkwqjnqnrsPm4ELhnI4ltRZ9T9hAOYbRvcQqrzcfFeC9HYaW34vR49pLb7fGyIf5R9rIwljCfSw+7bOn0asfr5+n50y2udZykzgIkw4nyIttlQi2IGMPUsP+tjimQgK+ZZfuo5hI6HMbsFMPmgaOvmt3EJYLa/46A15s6wIdf5GPbIsOH2EPKyZglgOcF6XGzWHUZwttbJMP7wwkbMtz6mSAtk++3by7Uus8+FzD5s3T2ALcz3uKecAJa7zazcH0El1vmdZu1Zk7kPIfcXAxiVB48A5tboZns7jmtnW54P+zbfs5cBbFLcQpMwfhax5VWoauzE8JQCmKD9fhWWx85aDpReAUxQYcvsFbWHcdl4u29ry3sOdDOAWRmN3vof/D2+austMRrqz/45vvLnn8sGnPE/YN8q0SA7w5o03o+DG/+r0Vh7B6Pxcy/gq9ZgEFAAMz+j63Mky5kKP1/Hth/c49hWeq/m/BVfxnJLAMvZJhb6A66NcOVZlyM498LXLT1uQQUwyei5zbdP+IABjMqDZwATrI3uQNLS26E3FPkDmOxd6WMAm5QRJGNrRL3XI3ooqYXdHNPQA7a8/lkcl5cGTXkCmGDtFR0YsIfxggGsais6rxxnALNSjV78dRGs/tzSAMsGdR2+srsV+ywPVdYbaq8HG1sDjXwQtkcwMkLcQtUYM4BNs2z4+fcje+3BWqv7v8YzbXstdW6EJ886twSaPMHIvm8wgDGAUXnIF8AE1ejq43RUb4fONYCNX0Dn1uVGT4lxCTJnvI8sbIjzSp9FvFHUo6qvukbE4gfRmTTOpycawGx1r97zcXROIIBle73U72fDuFcAG08dwta6KsslSMvftxWvvzmDmY3eOa0RNntLtIZ6HfadO2cJO4UDS7YRHswTjKwBSnALYMZlUWvJNt7FjgHL35iPDx7GY87LoTOCJfxcPGML1tr2kZdcL1rrvFBgsQS0kTzByLYd3QNY7jayhPmcAOa2vCz6e3pegjyy03E5NBgMYFQeCgQwcdhAOrEbdRWO8T+CHsByG9Oq+t04pAUFr14RKtp4ComDccRjjWIbyPpdjq2dFzA+pR4wsU3P7kO97M2SlzONV3N/1801sU1XWi5FKl43XMxHfbQDSRnUPNd5lrI0elrjbPSWmA31uDXs+BjApr0HzK0ht49jmzms4SdtCdZ6r6Y2NspW5/4FsGyIdpETwDz+jsFzEL5tHFtwGMCoPBQMYIK2TB2iCfulD89LkCYGsGmlLglXR5EYKRDA5CU/7dKHxxgwtW3ke5mbr5gAZixj+z2piG3NAGZnbfS0Xi/ZW3I+21A7wpIesL6OfedG9N+3UQFN/nzIOxgFfQly/CKO7JA3DHwLe96RsXKmsYcfM1hfe9fo1RTbzlbnRsDyvBnBCGjy57e8g1E2fAdzCdLs0QzJna0MYFQeGMDCZ7gTjVXOAfKSJfzcsgzIN36qM+p8eQxJ7ZcLBDBzOYkBzFcuDfH8LVFEVUPt7K0ywpPrZbtyGoSvQtgd94jAkB3SMDM4wo8RrP9h9w+NXk2xiK3O1TZxv2xXToPwVQirXrEHJ61TnQSAAYzKAwNYCKnLfNZB+ONIJ+NorKs2Br6r8VjL0Rg/ayxzC6njz6K+ynq5ON8lSOdlZQYwX7k2xHMtvSGOACa3mzYNxefwlR/sL+tpKJB+B8+EpLGeXo7wo8LRHZapGRzb3ZyGQs7T1vJOGU9DIfaxk3vEuoj9c/c7xjEpGAxgVB78CGA544JUyfe7s5wc+xWPauO0zPqSgSyeQMpsr3Ina829c9IIYOrn1uVs7yX5EcAc62Etsy2oOxtirbdkgWUOJWcA0016Ila38TnTEcCcf8csooE+/7ZHY25prHccDnzM0PRxBjDxSbVgbbl0nBPApMlPxDr//t04eNJ6OXc6Alju3zGL2PbnXQOYJO/AvUcstwqPHbloWSd/MYARERER+YwBjIiIiMhnDGBEREREPmMAIyIiIvIZAxgRERGRzxjAiIiIiHzGAEZERETkMwYwIiIiIp8xgBERERH5jAGMiIiIyGcMYEREREQ+YwAjIiIi8hkDGBEREZHPGMCIiIiIfMYARkREROQzBjAiIiIinzGAEREREfmMAYyIiIjIZwxgRERERD5jACMiIiLyGQMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARERER+axgAKuoqGBhYWFhYWFhYZnGwgDGwsLCwsLCwuJzYQBjYWFhYWFhYfG5FAxgbgsQERER0eQxgBERERH5jAGMiIiIyGcMYEREREQ+YwAjIiIi8hkDGBEREZHPGMCIiIiIfMYARkREROQzBjAiIiIinzGAEREREfmMAYyIiIjIZwxgRERERD5jACMiIiLyGQMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARUWGZG0idOoJ4bA+i0ahWmmJxvHEqhZGMsYwy0o/u9jbE43Hv0vYW+oxfzAz14FW3ZTzLy+jqu6797oSMDmOg5whebmk2PsNuNL/4Kt46cx7pUeeHICIqLQYwIsorkz6Lth33oLqiAhU5pQq13z6I/nFjYWE0EfVY1lpWo7n3hlwaqXiDy8/zl+poQvxmscaQTrZhx6oa1/eqqIigetXjaEt+CsYwIvILAxgR5TGMnqa7EZFBZd592PXLY0gOpJDqO4O3D/8cT69bjEh1FAlLGjIDWFU9ogfcerBEKdQDFmtEnRaOlqMxdsD+swn1gI3h6rGnsTSih61I7QY83fIquk4kkEgcQ2e8GdvW1Oqfb3UL+pjAiMgnDGBE5G24E41VehDa1X0lt4coM4y+42cxZPmBGcAcwWxCUnHUawGsAfHUZN9ErN6l1/FwTUTr5Zq3bh/OpMeMn1jIz9C5B+s2/Bv6GcCIyCcMYETkaay3GUsmGITCE8A+RSK6QryHeJ9FT6F72CV8EREFhAGMiDxl+lqwWgtC96C5t7jLfqEJYGbvXQ3Wx/s5vouIQoUBjIi83XgH0UWVIsTIS3gx9Fy9bfzAWzgCWAbXux7DHPkekY1TuoxJRFQKDGBElMcoLnVsQY0WhvRB7NF4AqkRy22PDuEIYDfR1/J1bZ0rFjShh1cfiShkGMCIKL/Mp0i2PY5V1XIwuxHEFt6LbbG3MOASxMwA5lnUFBR5TDmApZGI1ul/rz6OlPEqEVFYMIARURHGMZJKIB7dgFpjSgdZIrUPoeWMff4sM4BFFmLlN+pRX+8o636I9v6bxtIeGMCIaIZjACOiCZBB7BQ6fvxgNojNexCtH2R7tMJxCZIBjIjCjQGMiCZhDOkz+7Bunn5ZsnJTB64YPwndGLC5u9B9k/dAElG4MIAR0SRZQo4lbIUjgFnugqxYg1hyxHidiCgcGMCIaJIyuNm9C3NDGcAEcx6wSiyKvoMCw/6JiHzFAEZEHjIYvX4dxiMbXVxHb/M9Wg9Y5N5W8zE+oQlg1pnwK7+B50/nedj26Cfofeu07ZFKRESlxABGRB7kQPblqF0XRfxEP9KjlnSSuY6BN5/BmkoZkhbiwfYBM9yEJ4CJ1bz6FnYtnaOHsHlfR/T1MxiyTp0xOoz+E3FEXR4qTkRUSgxgRORhBMnYWkS0ICTn/lqJ+k3b8dT2h7C2bp4eairmYOmOQ0hZwpkZwPKVyNr847KmKYDJXryRD36FLSqEaX9bTY/xl6gz5zYTn2PXW7jKHjAi8gkDGBF5G72EnrY9aFxTawYxvURQvfRBRF8+javWnjFhvO8XuM8yaat7WYGmnjzPlrzSgU1a79pUA5guk34fb8R2oN4MjkaJ1GJN4x60JS7kudRKRDT9GMCIqAjjGLl2Cam+XpxK9iM1lEZ5Xq0bRXpoEKlUSpRLuJbnkUpERKXEAEZERETkMwYwIiIiIp8xgBERERH5jAGMiIiIyGcMYEREREQ+YwAjIiIi8hkDGBEREZHPGMCIiIiIfMYARkREROQzBjAiIiIinzGAEREREfmMAYyIiIjIZwxgRERERD5jACMiIiLyGQMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARERER+YwBjIiIiMhnDGBEREREPmMAIyIiIvIZAxgREVHQMjeQOnUE8dgeRKNRvTTFEO86i6GRcWOhoGUwevkUft0WRzweR9uhXlzNGD8K1DhGUr9Fx4vNlrrbh/bu93FtNBQr6IoBjIiIKECZ9Gm0bl6GSEUFKnJKBNWrnkJn6qaxdIAyl9C5ZXF23aqjSIwaPwtK5lOcaXkItRFrnalShdqNL+JMesxYOFxmSAC7javv/m/87Nk92PvqH5A2XqVpMnoF7x76Vzz3TAyvJYeNF6m0yvOMruTEwTb5xq+0s+/C5dfoGQqodZC9GYkOvNi829x+TbF2dH9wFUG3VzZhX89yqcepyFxG146lWmCILN2BeM8HSF27gZFrKXxw4hfYsnSO9rPK9XFcDPSrP4bh7qewSATCmpVfxhIZcAIPYKO41LEFNXJdIiuw5RdHkRxIITWQROL1JtTPi4i6q0Ttjt+EpKfOruwDWCb9AY78yyYsvXMuqu8Q5f42DBo/o6kaQ7rvCPZ+Zzk+I+v2jgV4oO288TMqmTI+oyu50QSi1W714lbqEE34fzqWSZ9Cy8Yl7r0ZkSXY2HIK6RA0BmFfz3Kpxym70oFNlfJz3YPm3uvGi0oGt3ufxzLtczcgngow7YycQvOquaiobEDrsRbUy3UKOoDdeAfRRZWibhZhc3u/I5SrwCj3l2+g5YMQ9CA6lHEAu4nLJ/ejccXn9eClCgPY9Bi9hJP7/wFfUcGWAcwn5X1GV3KZK+j9dZtLb1e2/LJ5E2q1Bmu1aNBuGL/ok8xFdDy8SPxt2ZuxFb84dhYDqRQGkifwetN6zNPWayl2dF0WTWuAwr6e5VKP02CspwkL5OfxCjPmSUcA+7PpBt5vWY/KirlYHevF7VQ8BAFsHMOdW1El12PZ8+i97bInZN5Dy2rZg1iF5bGz4jfCpUwD2E0MtD2MWhkK/ngdnn6lB70v/R0D2HQZ/wgHxZln9R3VqK2P4pXe3+LA/QsYwPxQ5md0wbuNi/EHRUMhGu67W/CBr0fcDG4kfqRvn5pH0X7RsX1EeOzetVwPFb6vm1XY17Nc6nF6ZAZasVZ+1sgGtPbfMl7NyvS1YLX8edVWdA4H82EzqZfxoDz5W/QjJG6IoBOKADaMRHSZ2A8iWNDUI46Obm6gt3m1tq9UburAFePVsCjTAHYDv3/ub9Hw//0a567dFv8exWDbQwxg02XsFH58z9/h2V//AZ9q443O4yADmA/K/4wucLd+h6bFMsDOx8b2Cz73jgyhs3Ghtm2WNZ8WUTCX2ZhWrEEsOWK86rewr2e51OM0yfQjvr5GfJYI5q3bZxtekBlJ4t82yrqYi1XNpxDIJzXHqC3Gls5L+ncqFAFsAPH6arFe1aiPDxivOY2KVW0Qy4h1XdKM3pCN3CjTAObEAFZaDGD+KP8zumCN4UrnNv3y7fx/Qrc8U/fTzROI3iUvEa9AU49zLI9h7DSal8iAeBc2dXxsvOizsK9nudTjtMlgNHUIO4zB9pG6hxF7qw+XPziMpvoF4rU5WLrjEFKB3HyTwY2ePVgWEeHwwZeRUqsQhgA21oOmBXI/WYTtXd5HwtFEFNVBr6sHBjAqAgOYP8r/jC5QZk+CMU7FeNk3qlHKO1habeNKLGk+7RGySyzs61ku9Tit5PxaJ/DiltV6WFCl8m7s+NVpXA3qzufbvYitlgPv16Plfcv4szAEMHNsXP6bbRjASo4BrLQYwHwxA87ogpPBLXGmvlhrtB5E/KLv8Ss7mHrOY+i67tVgppGI1mmNa3U0IY5c/gv7epZLPU63TPp9vPHTh1Fnu/u5CrXr/hmvJ68E8BlH0N/aoA28z7n8yQA2LRjAqAgMYL6YAQeUwJgTREZQs/1NBDFbXXHbJfjgEPb1LJd6nD5jSPe2YnOdvARZg1U7/g2Ji0O4mIgjum6xPg1H5MvYcfi8r58zc+l1PFwjTggXPYXuYUcfIwPYtGAAoyIwgPmCAWzSMhfjWK/NpbQSTT3edVdKDGDTY7YFMDPoiO/9llf6MGLt9Bv9BD2xB/RpNyJ3i33br1OLT0X9rhDrtAgPd1zUB95bhSGAmVcMatDQftF40SmD612PYY5c1wVN6AnZtWoGMCoCA5gvGMAmKY2eppVaYxy5txX9XletSowBbHrMrgCm9t0IarYcxhW3fTcziI7NcjB+BaoaO/3p3TWPRcWWRWjsvGT8sl/UOMA5WN3yXm5I1NzGQOt6bR0jDe24bLwaFgxgVAQGMF/MgDO6IGSuHMYWrQfBcpt8AMyxS5GH0H7Za8NcQdd2OcFoJM+drqUV9vUsl3qcHipEFHnjTX0cKePVkho7i9gKeUlU/M2iShB3o14X4VX20uULpmpKk3DerMEARkVgAPNH+Z/R+e8W+ls36ONk1CSRQTHv3vs6Wvo8JsnNfIjWtXPFMvlCdomFfT3LpR6nRTHf+Zvoa/m6WCZE3/kwXIK0zptY9Sg6ruTGq8yVDmyukvtScEMT8mEAoyIwgPmj/M/ofGc+OWAu7m45F+zEtGYP5kI0dg4ZLzoMd6JRaxACfKxM2NezXOpxWmQvn1fUfh+v9F93hLBxjPS/gi21ch+vwfp4f2A9vDahCGCC+f3PnSstM9KHV7bol6mDf5C5OwYwKgIDmD/K/4zOX5aJVys3of1S0COBVDgWAXpzh8t4HrG+HY/q23fxHvTcCqpFCPt6lks9To/M1bewy5iEtSKyGPXbomhuOYBftjQjuq3eeCh/BPPWt+IDt6djBCEsAUzsC1ePPY2lRh1VL30A25+OIrrzEaxZWKXVaWTpEzic8uhJDRgDGBWBAcw3ZX5G56tMH1rv1SfjXBR9B8H3g1ieYZgzbUCYejLCvp7lUo/TJYPRq6fRvudhrKyWPX8yTKgiQ8WDiMZ/h8tBTcbq5nI7GmToCTyASTdxObEf29fU6kMRVInUYs32/UhcDmf4kso0gInUe3QPGu7/Fh7Qyv34mxUL9QD2hS/jb8zXv4tnjnKUzMRdxtHd3zXqUJb78JUvVIv6rcbCFfdlX//bPTh6ddZfBJtm5X1G5x9rI30fYsmQXIbKDOHYrpVGQzAPSxu24eno09j56Fos1LZpkI+VsQj7epZLPU63zAiuDaYwkDyN3r4LSA2lLeGT8htFeugi+npPIzmQwlA6/DVXtgHs8quP4DMycOUti/HoIb9vjZ0JUnjtO7Uu9ekof/QPOMQAVgLle0bnn2vo3il7Ax3PqAuD0Y+ReHGHGZhViSy8F9tfPBGenoywr2e51CPRJJVpACOaDcrvjI4sRtMYSvWh91QSA6lPkA5rYAj7epZLPRJNEAMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARERER+YwBjIiIiMhnDGBERETTyDpvWdDFyu3nQRUvbssGVUqNAYyIiGgauTXmQRUrt58HVby4LRtUKbXQBDDXmdYDKjOR2+cMosxGbl/soEpYua1rEMXJbZmgSj5uywdVvLgtG0Txg9vfDapYuf08qOLFbdmgSqkxgLmUmcjtcwZRZiO3L3ZQJazc1jWI4uS2TFAlH7flgype3JYNovjB7e8GVazcfh5U8eK2bFCl1BjAXMpM5PY5gyizkdsXO6gSVm7rGkRxclsmqJKP2/JBFS9uywZRiMKCAcylzERunzOIMhu5NQJBlbByW9cgipPbMkGVfNyWD6p4cVs2iEIUFqEJYERERESzBQMYERERkc8YwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARERER+YwBjIiIyC+ZEQydO4VEIoGeZArp0YzxA6cMRtMpJHsSYtnfovfDKxjxWnQ6TWj9zqNXLJdInMK5oRHxSik56mNgGKPGT3KNY2ToffRo69aLgbT3kkFiACMiIiq5m7ic2I8tK2ss85JFUL3qKXSmbhrLGDKfovffvo+V1RHLslWo3fgizqTHjIWm2wTXr/VR1EXUcqJElmBjyymkS5HCRi+iO7bFUR81WLXrMFLOgCjW7UzLQ6i1rlv1X2JX5/k8gS0YZRjAZLL9AL8/eRInT72HwYLJdhTp8+/j/ZKn85mg+LrNjFzGe6d+i5Mnf49zg+nQ7djlSNbpOe3s7hSSqTx1OppGKqmfoSZ6z+c5Q51pLGe1PeeQKuqsVnz/hwaRSn1S4noqZt3kGfwnYl1SjnIJ10bGjWVKbYJ1aOkNSfR+hKulXs8iel8yI9cwmFOHqvhZlxM1gHj9fNTW/xA/jR/Gsa5foXnTMkREQKi8rxX95mpncCPxIyyqqETt5p+h68wH6E+ewOtN6zFPBKL5O4/hhrHk9Cp2/W4j1f6wWJc5qNv8AjpPiH2j+xU01S8QYWcpdnRdnv62NhVHfWQpNjb9Em+Kv3fizZewa+1dWghbH++3/L0R9Mc3aeu2dMt+Y1kRKpfOEQHxbjT1DBvLhUMZBTBx8LqcwC+2fQ0LrbOrf+E+PH3kgmtjlRnpx9G9m7D0TrHcnz6L35fqxKHsTaBuRy/h5M934K++UJ1d7o5afO2pN3LPRKg4ox8j8eLWIs7ubiLVvQ+NxZyhzihy/zyBF7esRrX5uUUpeFYrGrKePVimnQnXoKH9ovH6dJrAuo2dRWyFaAisy2mlEkuaT6O0h6eJ1uEY0r0vOXpDKhBZuhsn0qUIOMX2voyKtrjBsoyzVKM+PmAsGzY3MdTXj2vW7/T1LmyfI9e7AfGU2grX0dO0QrxWh2gibbwm3OzGzrli2eUxJEuSMYtcv3GxHy+vQkXVo+i4kt1rM/2tuFd81yo3tuPSdDcFo1dwfvCG2IuVjKiOXZgrtnlVYyfMWHXjHUQXVaJi0Y+QuKGWzuCWOA4sdi4bAmUUwEYx2PYQPvOlv8X/eKENR97uwmt7H8VXZLj6owdxoN/6JRVf5pP70bji86j+zwuwUC7zhd046X2knuUmULeDbXjgzj/HA0/+Lxw88n9w9NV/waOynu9YiPUv9Ynza5ow7exuMeqf+AninW+hq/3H2FQnG+p5uK/1A0udyjPUu1C38Z8Rf/M4EieO4Je77hNne+Kgtz6Oi9N90AsNvdGN1K7DEz+No/PYb9DevFm//FH5LbTavvsWt3sRWz1X1GMpG+YJrNtoAtFq8XpdI2LxOOJmeRldfdeNhUplInWYwe0PWrF+XgSRuofx045jeg9Y9yG0xl5HsiQDkYrvHRrpewtttvqT5RdoaqgV2/kubOr42Fi2DKh9whbARpCMrRGvLcDmjkEzdGQuxrG+0ucQ4bZ+6rW1rRiw7goqmFVHkSh5W6sCWAQLmnrMk5ex3mYsEfvM3J3dIgVYqPC6oAk9IeqIKaMAJs7ghvrx0bXbxr+lqzj6j38mGv8FeKDtvPGadB4H7/8z/NW2n+P4wJvY/QUGsPwmULejn+DDj66Kw7mSwY2jT+Au2RN2fxsGjVdpAkSd9n1or9PrXY9hjgwO9XGkjFflicUn5y/ZB+KqA0vVVnQOz9T4K/fPj/Chbf+8gq7ti/IEqxH0tzagMrIWTT9+FNUlC2ATWDfVcNm2qV8msJ6ZC2jfOF8EswYRzEaMF0ut2N4hD7d+h6bFlaiY/0/oNns+wi9zqR0bRaiqWLwHPbey6525fASPyctm876O6Ou9SPUdwR55iW/eg2j9oDQXIN24rp/aj5c0o9cWZmSIri5ue03JOEZSx/D8OlEf4vvdfEb1Eo5juHMrqty+65kP0bpWnIyF7DhZRgHMTRond3/ZJYCJDfTpsN5QjZ7EMwxgk+BVt7lGT+7WL10ygE2b0URUv1RUqLEO6Zld6aWRiNZ5BrDMpdfxcE0VFu06hisnZF2WKoC58Vi3QAOYG/f1zKTiWBepwJztXSh1v1xebr0vrsZwpXMbaiqqsKz5NKwRM9xuIBm7D5GKuVgd63WstwjMqSOIauOcZB2IMu/beDE5LH7iF4/1UwG9og6N8VNIpW9i5NoFJI/9DJtrRQguUQAbS8awQvbYqvqo+CIebv/QUm/q8rTbd92vcDgx5R3AMhfx2kP/VYSEe/DcKcu1cisGsMkppm41o7j86t+j5o55WP5sD24Zr9JUjOJS+yZUVlRicdPvPOs0M3IB3c9/C/PEAXJV8yn41VcRCmYjsBJNPY79M3MF3buWo6JmGzqvjBlh1scA5rVuKlCoS5BtHejqeR9DQQ0ad11PdWlH1FfraQycOYqONnmJ7xV0JvrsPVQl5tU7lCPTj/j6GlRUPoj4xXKJX2NIn/4J1orPV7n2BfzBeVk38ymSbY9jVXUlqlduQIM2Nq4KtQ3/gmO+jPfMt34yHB7CDtlDZ4YhaylNyMlc7sYL0Sii0aex89G1WCjDmG0MIwOYjzK4ndyHv75zLj7ztX04d9vjC8oANglF1q10+13s+9pdqL5zHfYl/esan9HU2KXIfYg56zRnIHclah9+Gf35ttGMI/fPGFaLA3BkdQxJ22fPYOTMv2BVpAbrWt/XDsz+BrA86zbWg6YF1hst9BKpexStvZ+K3/ST13qqRsy+jnqZg6U7Dvl0s02+3iErNcA6gprtb4ZqgLU3S4Cp3YaOnECl7uRbgHXPv43Lsr5HP8GZX34fS133+elWaP10mZEUTr3xij4Gr/0IegZOo1WGHF/GgImA+IefoV4G9JrH0aVdVhzD5faHxD7j8l1XlyDnPIau6/5+0/Ip2wCWSZ/CT+oXovqPviUa/jw9NAxgE1Z03cq5YH5yP2ruWIhvvtA7u3pgSkXU6ennv4HKinlYGzuTW6eZj9H9wjPiLFCcCe58BGsWVomG0WM+nBkqk+7B82vnoaKyHrE/OPbP20m03DvP1kj5GcDyrpscGnHtUnbKhL5TeONn39MGwkeW7UGPj2OXvNdTBTB9CoRjyQu4NnIT6dQpxBvl5Uo/BrkX6B2yylxC55bFYr1cekJDyRJu5j2A2BmX4K2Cek7Pnxqzt0J81lJdHC5i/bwMd6KxSmyzTR1iTf2gerWyd4uO9TRhgThZqI4mjF4xQ8nvIJ2c8gxgoxdw5Id34zN3fBnbDxWYXI0BbGKKrtubSL3xJP7iznlYuu3XnIJiWog6PfyEOMsVjd+W14uq00z6NGL18vLEEmzv+sR4dQYbPY/DO74sznLrsKVjwLF/qvmJFqOx/awZdM53bMfcirlYE0sgNXitdLOJ5103D+ZlwFI2qg5519P7Mo5n4zatiut9UdSdgZF7W9FfBoegTDqBPavm5g836lJ1Tlj4FN07l5R0Xylq/VzdwPst68WJ42Js6bw0gd8rTmbkOq47j4e3T6N5mTgBjWxAa78xUMMIgRXLnkev2UuYnVct35COIJRfADMDwhI07Pt94Vl3GcCKV3TdqvBVjdq//Vf0lmxm5tlEha8I5q3bN4HZrrOXjErbMIaAGRwWYF3MbcZtNahcXi7zKiUaA1Jw3byodXbM+VQqBddTjQGbg9Ut79ka0vFkDMtFHZZuP5to70saPU0rRd2VptGfdrfPoXW9nKx0DpY2/gt+aZtGow2v9hgTmJq9egtQ3/QK3u6VE7H+Dl0v/wj1cmqQUvWWFrt+4lg10PkzxOKH0S2nJznxJl5u2ohaeezaGEf/tJ+My2PcRlSvfBhNrYf0v9n9Gn6qTVMSQc3Dr1vmHRsW+8Td4vVqrNrRijdPnED34X1o1Paph9GeCtcYwfIKYJlrOPXc14sPXxIDWHGKrtsxpE89j68xfE0jUac9z2FVofCVuYn0dedOfB29zfeIg2Y17m3tC38jNFli/+zZs6ZAwBH1OHBan7PKUt5u2YQ5olFZGX1V/Pschqa7gShq3Tyos/jKTWi/VOIDVJHrqe6CtE+oeRsX4w9ql8bX2WYenz4T7X3JXDmMLTURx6SbIXb1MBpFgHI/MbAHWzkMpGXjErGtrMtUoXbdHrxZqkH4Ra+fnKdsrX3dIouxLvoKkiVpD2Qw70R0ba2jPmpEyGrL+ZvyqkDrZn0OObVspPYhtEyoR88fZRTA/gN9L21C7R1z8Zmv/AAvtLXhoLW8fgpDZu3exODJX+uvx3fjgc+KAPbZb+EZkeIP/qoL5xgaHIqt2wxu972EjX9cjeo7v4ptL/zSvlzb/8bvh5hyJ0bUqTHpZUVkBRp/+pLlrFOWX6NH1amcsLV6FTY3teJw9wkRJo6h46cP65Np1mxBR6kb8MDcwAetD2oTzkaWNuKnv7TWjyiv9li++7lKOwas2HWTA4S3YNXmf0brYX1i0xPmZKNzsCz6NoZL2jpMoA4zA2h/cKFouBajoflVdCdOoPv1Jr33ZenTOHa1BMfPontflFvob90g6m4u7m45Z5msOMwcYwBtZRBDOY+FGkU6dc54oLQfD+OeyPpZ160XH17141F/E/mbYtmBXu175ssjtCapjALYZRz5gZwYVIQpt2Lr4Urhte/Uui93xxex7ciQsRzpiq3bMVw98pgW1FyXu+PLeOZkOQyEDRNRp53f1xrG7JmdtVguTY2eR2f0G/rt1+bP5eNaHkdbMnxnd9PnEjob5eBj6+e2lAJ3XZU2gBW7buNI98SwrlbeNGH5eWSJCDlHfRhDObE6zAy9rU/8aS4j97NdeOWDEs1DNYHeIc3YaTQvqUTFvEZ0XM6z8YlCrIwCmDgojFzDx4ODGHQrQ9aHF2e0h966LjdY6ofylqei6zYzgk8/dllGK6zbSRF1em3Q7axTFmedyn07haT20G4/zorDIe8DmG3ffRejaQyV8CHNE1o364PUi36g+PSYcB0W8WDs6TOJ3qEhccy55kfPC1FplFUAIyIiIpoJGMCIiIiIfMYARkREROQzBjAiIiIinzGAEREREfmMAYyIiIjIZwxgREREivEsxqoNcVywzlwiJ0LOeZTVLVyIfxtVFWsQS8pH52cfDeZWqqOd6JaPnqqPI6W/AZBO4lC0XryHsVxVPaKHktBm/5vIuox/hPiG+S7PkDQed2X9mxb6PHnyvfqMh1vb19lactZD+5sLURc9rq+vfEk+sqpqKzqHxYLjKSTiUdTL5zNq77EcjfuOI2V9j3yfX3vg9sLcOfwsn19f//nYEP/IMiGvsR3kZ9aWVX/fUcz579SDvR0/F+uy+3gK40bdTvjzF8AARjQN9IOA48urinbgy/OcQvUlN94rawidjXJG8oVo7LROHpw9WFQ1dmLYeFU3juHOrcbBLHuAzrt+OY0K0SymHobtbNRdQ89ZxJYvRl3dfCyPnXV8h/XvvH0SWUcYSh9HtK4adY0tSKTkY6JvIZVoQaN8TTbqE1gXreFfXIe6KhUGlWIDmOVzaX/X/nzS8QtxbKiyrocRPm1hQw8++nHpmvi7K1FRtxXxpH6UGk8dwlb12eQLhT5/0QFM1FHVtxG/oB61bQlgxiuStqzrxM1uf2cYZ2MbzM838c9fWIkD2LgIt0dwwJpuZQKOdSKZNnclXU5SrhIbZS8OJlTDZDmzcEuX6ino5ozXE10+azyVQDxnnduNHUQyGkDbBjdoO0apZt02iDOGzgPOuoqh09jJs+TOHEe0XpwVqc9S14jYwUT2DMQ8O3A28pIKAOLn5o488cZfU/T2dZ7JSMbf9DiAhIF+EMj3QGWPg6Col+O75b7mPGiKH2kPPxZnV+JgZK/r7DbI3bct28yyDVwPskSUSwsfVVhct1g0rpZjvFfoWb4Xxw+J455Hz5N3AJPPVFzj0mOlvvvimNDbVeS6yPe6T4TAIzjUuNgRBqcngGUDh74euYFEkscf/e+Pqs9gO66JTJBoRuPuo6INKuLzJ5MuwUjICWDGcdLsoZqOACZof0fVw8Q+v+MjuSphABMVfXafaHDnoz7aYQQuGcjiIt1W2bvy0qcREyGhqj6KuGqQZYO9rxF1ZoNsCVQ5YcHa8LsEsKKW11/PrnPcDFzjqePY17jcErgsIaR+H85aw6S2wUoYwMy62o1DKnClzyJuWz9Jpfd6ROMqcKmzC0v9a+sr68ElUJkhVRRzR5544z/h7Vu1AbGz1jWZwQFM0urZuc+og5NxcLfVtVEf9z2CRnH2bdu3jfeqq5PbIbsNGMCIiqSFD/F9PHDEftnJM/SIxlb73jnbmUIBTH6P3XrOBK1nTbRDra3FrYu2/H0isNzQ2zbb8WK6ApigLrk92YKY2yU5rR5kcErrx3OXcJVVxOePvymWKSaANeDA8VZLIJqOAGbvAdMU/fntJ9NeShfAtAq0dDWaZALeLRpetbMaDU1OYy5ZE+cNvUJFKm5sXOkIC3rDX1VXh8U5AazY5QVtnUU4yenZEWzXgI0GUAsaVfbPWNIAZtRV3W4knD2IWldudt1V74n9gKCzJXdjfe9r3OS4bm2E1KrFqFtcZdmRJ9r4T3T7yjoVxfYZjb/pcQAJg2kPYMb3J3twr7IcqFR9tKBT1K11f9W2e92TiIsDBwMY0SSoACa+j7nHSst3yNbYGm2Kre0oJoC5hAuN8TMVwPKui3GsVmFHWy/rsX8aA5igr4c8Ubae8Ou099LWwz0A2RXx+ScQwOKpG7ntiePva8t6BjDVpltKXSP2mVdpdMV9fuOFAkoWwPQAkK9BMhihJ+dhq4rZOPUZDbRIup3N9rCgvcfdiMabLeFHBbBily+0zqrXTG5oY7BifTPi8hp3xUrxO9f0xUoZwArVlckIPa47mmT0VMmdU63vgVfFe1sDlX52Vxfdj5gt/Bg7arGN/4S37wbE4k+KgG4Ntupv5vsyB0s/CDi+vLKY28DjIDh+AZ1bnb2Xal+zH9yzZ5PZ+rgg69zct/Vttjx2WhyI9H1fHVQ910+WENcrke8sAcx2knh8v9noZ7+jju+S7USzmABWZA9Y3nUxjg+Odckem6c3gKnjT+4xXW939L9r1I9nGyQV8fk9ApjeVuvrbFt/s6OkFccPTDSAqb+jrtSJf4tjaW4NFPP5i1OyAOa6Ud2YDbBHYDEb8G4MqEblwmlbWNA2hmycRDJ1C2DFLW8NWO7rnA1ovdoG0DaucXnN7LEpZQCzHRjysQQs4xU7S0AbUOubtO88Wr3LLm15Dd4tgBXZ+E9m+6au6F2/ZrDN/s2wBgV9f893wmEcBB0HSe1Aab00q3EGLmcgs9SHVn/Gvm1uM6P737IvF/19JJrtnMdZNVC8XpyQmt8h+R1daTlhFbRjnboEJhUKYMZx2KXHRG9rxPddGwNWYF3k3622Bj/jeGGe1PkUwKzHIvlPraco93Kc+dmS1wp//uSAdiy0/y31+fTPbF9/dYWtDvX1uZ9ZW7ZgAJPU+1i3p1Lc5y9GeQawVNoSFlTDL1K0LfxYAlhRy08ygMnXtR3N6LEp2wA2oH8+Y6fW/l/7YjjDzwQb/0ltX/F7xpmMHmzF/9vWIXz0/b2IAGZ+hltIdT6ufcHrtQGp2os6rc5yg5oW1rR92LpN9G0pX79mbjPrvq/vy0V/H4lmu5zjrGqM5XdQ/w5Zj5VZzkBVKIDJfzrvAlS9L8bwnYLrYm3bLLTjqjGEwa8Aph23rO/jvAvS8dnkIoU+v/i3HrYs44LVmGLjM+euv/F3ZR05PrO2bFEBTFLr7xzyU+znL6xkASwbVtw24DCSne36XXu2HcWF9qHk+Bd7z4r5BbjWazT8ImV7BrBillfrnJvYddZeCGevkNE1LHtsHJc1p5UZVhwbXiN33COId8r5U5wHAidLD4u1F1B7fxmoBsTvGyHV1thLE2z8J7l9pWywdV4GDZ+JBzBJhTDr5VZj2+Uc3I2Dgfb6h7Ztou/b30b0yTVGPTOA0XSQx5Se3DvWZzrXE13VqMvvkAw96vhoZ29DighgUsF5wPKsi3Z1x2jPbKxtgPE31fubRT8eTE8AM9pHZ5tj3myl/uZE5wGTRF44tNtyB704aTVv7PM4thljop1txsQCmKAConl8libw+QsoWQBTYSEnmQv6Tqq69lSDkzugzXbN2xykbVS0ERYeiW43Gn6xeJ4AVnh5Qa2z884GyW0QvnXjqh4bbQdxfmGmi1fjLDjW3V7HdnqwsQ7mVOtrBKpHnsST5pfa+Vnt/y7c+E9y+1p/rr6Yji9TmEwugEnqYGpcbtW2o/MLr9O3qRxcm7BvE2PbyxtO9G02swKYPneQ/Hz6+uufRR2MrcWlN7GsGPtITgMhgpB2d7b+Od2OqcUr/r3Kc59R+744qdl6qIz3BZoNShfA5BfduIbqOg2FdfoGcxyV5Y4Dz2kK1AHBaNjFF808E8kXwAouL6mDk/jyml2iclU8pqFwNKbm3RElC2CCkezdp6GwTt9g3EJrO+PwmoYiu756Iy8+g5nk8wewYhr/yW1fgzXY5oSX8Jh8ABPU2Vrd4zh0+P+znEE7qLpY/l08eq91mxj7trnNcuvSO7TIUsL9dcqMerOcWboHA7FvH39W++669UyUB68A5vX6ZBT/XuUZwHT6cczje0QUEiUMYJIMXJ2IyXBgHuynOhFr9oCQ8yXLG8AKLZ9V9ESsOY2p6rEpcYMmJ2KNyfBiraupTMRqWV+jBybbiBUIYEU0/ppJbF/FDLZu4YVmuNzg6h0Mcsc+jqeOYre5/1tOBp2XRhyXPbx+TwVtbYCv/Nny7Yg+4px+QF8P9ZrnOmjHR/2EVPtZ3bfRKJezhSPj82u/K4sM+Rfsl2TMdTeWrbsP9dp7OsOo872MYv172qUnx8/l3+zu1F63XnZRdbEz2uioE+NYIOpYn2RYfx/bSaPJJRAa6yD/1i118uv6Hip0G+tp3YbacS3fCRFR8EocwIiIpmIKAUyN31CXotTg3Q0voVdObmveZat6i42TM8/fi+Oj4/JviyCg9SAP4/1kCle1QcKWYQHauEZjHqY873Xhqj7+Uf+ZGg8ogkRO75Q1pKiTvOXY2nlBhCv1e7In+TSOawHL6FVOf4SkedKoWN8rf/gZsdaz5fXsotYAZq2TS2K91ADmx9GprYOa1NI5FCHfOrSjQ25PNQha9aRrAU9dYVH1oK5eWIdWMIBRuDGAEVGI2XuTJPcAZg0i8pK2unvKPl5S/92VePTRr1mGFFjl+701aI5tF/91THCsNfbqNXWzjly/W0Wsg/VnRoDMF8BuGWM9XXrcKpZHEXtSLOf4e3alCmCOOrGGUEV7D49eOdd1aEVrvfXxMla5+4X5XjKgXXP5+6HlcqVI9uapJ5ho+5fxuq04AmbBh1pXO37fPtRGl2fAu7ZdvK7uGHWvnfy4/S1V1P5i/f46r9S4rZdgDsHIDkfQWf+2G/0qjX1fCQcGMCIKLX0A/kIjVOn0ht95YBfF2mipg7LbcqIReDJ+wBjYL/4tL8vHXzUO+Pl/T11uszV86gYY7QCvwpBsJPK9l1FsjYlxGT5fABtxCzHq9xoR3WksZ/t9K8t7TWsAs9eJ5zYSxfoe9vUxXjL/1lEMqF5BY8hCXA2fMJZxe3/tvW7JxnphWQzE14dYuI3VNYaCaAHMecLhoHpazeCSfQ/9hh4Zihx3+akby8xgonots2N1zfHPshfymvgbRQUwC207ue0b6vNkezIb42fFu8iXjMmpHdM/aEOIJvGwcT181oUyjDOAEVE4qUbWcWC1H8BlI6HfJVlV/yyOm2fNLg17DtlIvYq4+WB7eUlyIO/vqdBhv7RljIOUPU8Dh4xpVWRAyrcOxs9mdABz1pOb/OugvSTH6x2M44Dq3THDgDPMORg9R3mXCZwM7Itd7nqWvWLGtEIFA5hzHG5Wdtyz20Ot7fub540Lalxw8148Od0BLGfMsUEEyt2NzZbvs/yMcuqPiT9sXO+NdflcIVCCAFagO1VVlvqZs5iVqO+A5pdOK84B/Pm6OmWxDi4vNAhc7RjW31dlfpG3txuXQfIeACcpZ+C97BrOPjDce91lsXx55fuYDY4ssh6sA/iNL2XOe1iKuY2cXceiOAf5q0bU+vtGsTeYTuoMzuil0NYzbtn2NBt494DZGyRzqgrzrFldCizywGs2+sdxJc/veQULvfGaj/vq77b8br51ML5npbgEmff4Yw081v83fqw1VnpoyR/A1Gfz6BU05/dzNKw58q+D82Nk67/P0tNo/NBK690pgx4w7bMWCKoFA5hsByfxSB81HlHbl4z90bU+jYC3ph710x3AtM9WxHdU+xxyaqSJPmzc2E+99pOATXsAU3NMZQOLDFLWmW3zVZYifscYUOk6hYXrmAAVHFx2VLWjWR/5Yt4FpcaMOHYMkwgCRd3eboQvGRbyHgAnQXUVWwOLmnrCaHDc193BrAe3KSzcxsMI2hfE7UunBtVaw3U2NJnbSPsC5v6+eWeYxxfD3I+MZ3GZvRyu255mrtyxPu77ujg+aJcyRFBXvQnaZRnZM2ZMeaPuyhP7evTJ1WKfV9O2qOONMWbI8/e2ouPQk0YAcDSYxmVI7WTBuk/nea9Oo7fMHISv7ujLOX5YQ0oRg/DzHn+s76VClPFeat3EZ8gGMNU4GiHPGFSfvbPTI4Cpy1lmHavP5xyXlWcdntyLZhk2zSmL1DFHNr6j2WmOzGOEvk7avqIdt8pgDJi2nta6c3QqyO2kPa3E+Le1mNvZ5fKiSf1MBjC3MWDqpNZoP13bZeNnJQtgBdottY+o75UWWq3bNl+mkD9bXsSJQDCmOYB5hSBLF/3wcJ7KMhjdkq7dstqXzu2LVczfdm4C60Sgt/KEGOPg47XO2jXrlWJ9jyIp1yHvAXASPEKQftat10XhAGbUg+O6ukY1ErazakMRf9tJhSct2HoEMLkt9QOv2zob29K2zby2b5jIJzzELL12spfPEvo96yLPZzN6A3L2X+29rAdTVbJjSfR9wm0ZWcJcj1a5B1fvfV1Namu5My7ZYeuhNU8+nAOWLfUm902v39P/tksAU98v0ajZD/Z51sH5M9dpKCRraJL/dgyUNgdbO5dz41jGEnj0nv59iN5nzPKt7jo0vv+26TTE39x9IIr7PAOYkHdQuIXnOhzHNUfd2eYSdNaD/F11wp4TbEIqTw+Ytq/J7aQFsHzf10n2gNkYxyC/e8CK6QFU7a/aB4ySba88/rakff6JPZ/RT9McwMTnNbrisz1XTnkqy6C/x0S/PB6NmHFm6tadrdF2AH2n8j6wFwpgKSTaZS+QsQ55D4CTYHwG+xw4dt7rbihUD15cA5jxhfT8nJb6mlQAc5MvSIeBCvOiYTpuaSDiW8UJgzHdwYQDmPGZtYGnjrDr+l6iQbfcin+r0D5RFgofL4hylEsA046VbmPAjGN6UQHMOE64hCe9LZW9mG5jwOyyyzouB2ptR6nGgOmXinPCo/qb8nXZRk/yYePaZwptm1GCAJZtdFRSleO2DhjPKJSMyrIk2WzRN27BMOHKoxGzBCxXlmBiG/NgsnbxZ8ehuCtRAJMNq3XCRq3reC/i8SNmyNXrzFmfRskbhApwDWAFAqk1oGmDhnP/7oQvKWq9dG69omFhXDpw1okKz/JsbaIBzDwIyYGnjlvuPd8rux4Dk/oehY1340LkZXIn8cEwh1uYnRZyKIcxtlbu9+LnBS/TqeOj50Ot812mVHLvgrQNdfHrLkjb8Job2vc/5+qMNaB5/W3xEy2oebZTwStBAFPkTvSqCAl7jeCgxjp4p1Ul2ADmEmBs45zyKVUAy5Kz9B+MH8je5GCMyShYZ4EGMEd9akUecLI3EeRljoGzPL4qdIzP7HWZRZpgAMuekRoDT61npwUCmDxgXZkRAUzu88YA+xnwWajU1HdJtTfGyyGX8/QVa5ujHYOtx05VHN//gvOAFQpgUp7LutoxR71uKVo7MNkAJsms4LzhygiSWvs82YeNfxOPf9t5x2S4lDCAWamBo3JDDBYMYPnPXsQO0tnu8tidQr0IHhtBC2j6uA3nJRuzlybv3XpWpQ9gVvqZk8sdS24sQTN3CXm2ZNzybLxiyncJ0rNXwgho8ue3HEFBzfFiu1SXh8ecMKGkztzUAUCbX+pgdl/1OoCZxbr9LHUoP7ZlP9VqwTWA2Xtr9f3Z7e+Ikuf7R0REpTfNAczRaFiZ1+QLBzAVFnK6HQU9nLldDvQIYGbPhNtdfoUH4efe3p5PKQKYGivlcm3e6O0oKoCZ9eByPVzVt9vlQNcAlm87iJ8VGoSvQpX5KBg3MhTqA3CLD8AhIccEHowjbk4bYgwKdw1Nksu+6wxczu+WV5iznPVOrieZiIj8MM0BTF3PdQzCt13TLeIuSNf3kQ2yMQ2F66UorwAmqLt5rNe2ZSNZ1DQUal2qihh/VKIeMPNWdusgfPsA76IaW7f3MaehULeLO3gEMPn3tVvCbXePZbuSC01DodbFK9iq3r1wX3YsgnH5NHs5tpgApkK3S8BSd556hrksBjAiovCa5gAmWQYQmo2GdbyP1/VaVbKNUM6ErtqAfutErFZ5ApgkA1dRE7G6/b7z9nYvJQpgQs4YAVGsUxzo6579mb1YGuqcCV1lPVgnYnXwDGCSy7Z2nYjV7fctwTZnrIbR22Ouo7V4XZoOWE6PlWLZJ4oNYF49wCpAy9cZwIhCRg6P8ZqGRn3HncczUWzthWz3vKYtUSbzd0QbnDOZuBoa5HJ1RTvuO9/DerLtcnzJaWPty9sYPfg5V120v+s4ZqmT2Jwra9ks4Rxao1+hEeug6tb188gSbHtSggBGNBupiSetA19Vr61xJ5JnaLIHMP3g4XZ51nIZ+Uq+O5J0DGBEfjHCjOtVFhlw0vp3vKgrP5bgYr6HOh5M5u+I97VONKxoJ3qLUVfnMoeYSxDSr0pk38N+fFF3UG5F3AiL+vAdjzvXjQAmg6FtGIvb35XHw3zPgJRByhbOjOOkfN0WwMJ3LGQAI5ouOWeAoljvZioqgKXz3uCgHwSrCszJoyu6V5SIpkbrAXc7aVI3jV1xCUYOWiByu2HMctPT1cn+nex4YRVBtGCzfC+OH9qa+6ge18Bifw9rANNPGp0BSQbKZjS6PcZPOxZWYXHdYst8XkLO35WfvcAzIJ3hTKvH+SJYLmQAIyIimrmMMZu2S4lOxklWvgCmhQRniNHpAWcD/iX2yCT+jlsPmAo2ItBo4dHRO5YTWHLfIxvARvS/6XHS6EqdjB44ok8xpC5FOv+uFqYKPQOyCTFLONPqquoRxPZuYAAjIiKauYzQYw1GWoOf7XGujnZjQC5jeS37M6NXKl9I0H72TTz99Dcn+Xcc47G00KXCnj7m1jbm1PG+5nuoyVKFnACWL1w6Wa4G2O6at9WBEWxVsMsJiiqAHcBZczm9t7CqsQNnrdvE9fOIkjfMlh4DGBER0aTl6wHTQ4IZjErWA+bxd4y73O13k3vcZW3tXbIFIXfZAHYrz+f3YBuOYZkO6vh+y991vxkrGxRVABOfVQXKs7/VxrU1dqb0UGgLYPk/TxCmP4CZSdPRpamxVKhjR8y9y0+k7Vi7ZaZ0o7LNn1uXc9wZqa2D2rhevyeLWka/tq2vU77lRZHLaDuPy89EKc2cVcb6yffPmRvN+mVy7GA5Y5K87vzMrn92OeedkdY68vo9o2jL2AeW511eW0YO4vSo92InbSUiCoLnGDCPYORmSmPA8vwddfe0ecehbIdX2ttnbf0tA+InFMBGjV6s3PDoPjZMsAUwQVvHatTV34c69XflOhX9DEj5mRbrv68FyVt6+zN7A5hLWNA2stGomjuIurZsnapCZofj2KfNT+VW2Yr4XTU3mPV2VrcAljeduwQw299xcO48hvHUUeyWtw9P5Fp4UbIBLHciVetZgmUHM+Y+s05VoQWyYuY+M+cGswyOdA1g+W7hdQtg+b4AHvUu1vn4bhnM3c8MiYiCp3pxLHdBmyfAcnqa0+LnBQKYbM+cd0HKwfXWB/pP6u+o99XfQx8j5WxHLCFPvjzBAJZ7F6Rqm/PdBWltQ9U6qnZMvxkpJ0PYQqq1zch2ROi/47gsPLsCWDXua9zk2MgqvYqUurgqu4NoFeoy55GkngGohSvvYKSnbEuPW0ABzPyM076hjfW77xE0at2rzjMXsZPLOz7Mv2t8mXK+ZJKlu9dj9n9NznYJKIBJxmfMrW8iorDInRexqHnAbMdFGVwKzQNWxN/JOY6qgPSPiEXXuPSyqXbUONGdcAATzBN89bkc486sXNtQYx3le144LdqfIp8BqT6r1k6oHOAWwNR6WUuw7UrJAlj9gVdFBVrDgqy4+0Qa3o+YpSHXN7pXQ24NNMYlKrcG2ggL9sGMqmJnUACrb0Gn46xAq7+6JxGPbRA7k/F3nfXhZAk03sHI2NHNemMAIyIimi6lC2DxpL0LUQsFMtEmLQ154cCSDWj5niFpDweuAcwl/WYDiksAc1neTMuelyCNh3c7Z/edsuz6XZD1YfZs6aHW7HZW9VgosFgCmvczJO0Byj2AudSRGdjcApjL8rJY611tQ8V8eLf1cigREVF5K2EAG9DDkxEWtP/Xug2tDbmPAWzae8BcgkSFfRzb9LGsnxaejJ5FM9Qasx/7HsBK0AOWU6fW7nUiIqKZoaQBTG/oZVgYMHpq5HVne0OuByyvAdYqoMmfD3kHI0ug0Jp3XwKYJeCYvTSlulvPun76pUHZs3jNDLWOsKTVh9vdNAYtoOnPLbzlGYyCvgR5C6nOx6E9kN1tJmUiotkgncQh6wwB1gH46rhsOWFVy7i3RR7Li6LaT/1Y7XhEkDqey+Oz1r7m/r5WRHvR3a2O9X2ef0t/BuMV23jkLPW4pd1IuD73eeYobQBTYeGRJ/GkOaDO3pCr8OR62a6cBuGrEOb6DL+psteZ3rP4bUSfVIMpnb1VRnhyvWxXToPwVQircr+ThohoJlPTMzS2GFdW5AD8FsvdhfK4vNDeFokj9tnYBnGMd7sJy215O/1YLUKSrf2wBDDjFUlb1tG2uh7rtTbTpb2wtfHGS45nTs5kJQ5gRliQG9OcmsHekIsljGko5NxTaicTr5bhNBRqvpWKaU/ujjozwlGF2XPoDGCCMQ1FhetDW8toGgrzzphSBFsiorAyTqTNtjMre+VIjql2CVRaG+h2fC42gC1EnQh52Xa1RAFMsM2E7xLIZrKSB7Dcy2HOAKab9ESssjtWPexYmY4A5vw7ZhE71kC3ewCTgVCby0SEya2HpvGymbPOnF9MlwAmmfPDqHUvdiJWt7Fs0xHAnH9HFVmXvR4BTDCD7ePotK0TEdFMJY+5892HkmjtqjhOx98Uy5SiB6wBB463ZoNRCQNY9pLjThyINbhckpy5pj+AERER0RTlC0vqZzKAiRNj50mt9cqHjXEi7VzecjKdDVA3LMNVbpQwgAlGz5c8+bePPZvZGMCIiIhCZ6I9YGpIjvh37DTco07xPWBagDIvCbbi+IESBjDVw5b3StXMwwBGREQUOpMZA6aGwXj1JE0wgJnvV4f6+twhIgxgU8MARkREFEY5d0GqXq58d0Gqxw653Qw20QAmqRuhKhjAphkDGBERUVgVnAfMJVCp4JYzfY9c3m0MmChGuHINUOpGKAawaTXFAGZUmlHZesU7N6y88y6GTuvDRLWN4VxOFXlHXJ/xvm7dqMYOpO0IeXYmrRh3KrrdFZlvedvfKHBXpFwmz+epqn8Wxyd65551fb3eu64RsU71JdS5178qYhudaBXvK9Yp5xZf+3bU/77be6gilxux/U7ev63VYzH7iipyGePZn24/L9mEt0RERP4oQQDT/9/kNqeUFipU2HGj3lc2thsQO2t9Erw1HFk5QoTVdExLkfP3LDw+z3jqKHbLubhcruHnlRPAnO89jGR8a851ftf6tzKD1XzHIM08dVdkfet/u4gzHNvyedbVq97HUzi+W54Nej09gYiIKPxKH8Ak56zqEwlgstiuZZdPAJPX6ws969JVwQAmqdnus3O9FB/AZLFObJqn7sIWwKRCz7okIiIKOX8CmAoLKvQUHcA2IBZ/Up/Y1LyWzQCm6HfCZENPcQFMvFdsv2PG/jx1xwBGREQ07XwKYI4GXgsVqifGWeQy1vFFV/RZfc0em2kKYC5/23yYt1sAc1neHDPmEZLGU4ew1fmYpGIUGcDsn0suKuvfbT1FkZ/FXP6j7OOftGCbp+4mFMBc/q4ZdItcXhZrvTv/rvng89kzWzIREc08AQYwj1ChcSyvZsnVemzE/09HAJv2HjCXIFHh9kifIkwpgLnVv8G2vPH4By3YDnnXXdA9YDl1Km9siCLuOsszERFRefApgE32EmT2vfQHdsoem/2IhTKAWT6P2Uszybv1igxgk74Eaa6nCrZPIh7b4F53QQcw8+/eQqrzce3Gg/rdR6fxOZtERET+8yeATXoQvvW9VI+N0RMS5gAmqRBmG+xepKIC2GQH4dvfSw+2qnfJ7XfDEsAkFcKsYwKJiIjKT+kD2JSmoXC8l/nAzjIIYJKavM51RuI8CgawqUxD4Xwva7B1+90wBTBJzco8iWBLREQUEiUIYKo3RRWXcVBaqHAuZyn1rTjhEabMHhu/A5jbempF/L2Bbo9AqZ6jVYW6rYeKv2yWE8By/67bOCj3+ldFvN/TT7gEMMEMtm6BqJQBzG09ZZHr2OsdfM1g+zg6Jzq+joiIKASmGMCIiIiIaKIYwIiIiIh8xgBGRERE5DMGMCIiIiKfMYARERER+YwBjIiIiMhnDGBEREREPmMAIyIiIvIZAxgRERGRzxjAiIiIiHzGAEZERETkMwYwIiIiIp8xgBERERH5jAGMiIiIyGcMYEREREQ+YwAjIiIi8hkDGBEREZHPsvlqAPH6av3f+o90DGBERERE08sWwBqfRSI9zgBGREREVErZfDWM95OXMC5f035iYAAjIiIiml5u+YoBjIiIiKiEig5gLCwsLCwsLCws01usGMBYWFhYWFhYWHwoVvZ/EREREVFJjSaiDGBEREREfmMAIyIiIvIZAxgRERGRr4D/P6NmLvUzxSsFAAAAAElFTkSuQmCC' ></img>
 */
public class SymbolID {
/*
    //Version, 1-2

    //Standard Identity, First Digit (3)
    public static final char StandardIdentity_Context_Reality = '0';
    public static final char StandardIdentity_Context_Exercise = '1';
    public static final char StandardIdentity_Context_Simulation = '2';

    //Standard Identity, Second Digit (4)
    public static final char StandardIdentity_Affiliation_Pending = '0';
    public static final char StandardIdentity_Affiliation_Unknown = '1';
    public static final char StandardIdentity_Affiliation_AssumedFriend = '2';
    public static final char StandardIdentity_Affiliation_Friend = '3';
    public static final char StandardIdentity_Affiliation_Neutral = '4';
    public static final char StandardIdentity_Affiliation_Suspect_Joker = '5';
    public static final char StandardIdentity_Affiliation_Hostile_Faker = '6';

    //Symbol Set, 2 Digits (5-6)
    public static final String SymbolSet_Unknown = "00";
    public static final String SymbolSet_Air = "01";
    public static final String SymbolSet_AirMissile = "02";
    public static final String SymbolSet_Space = "05";
    public static final String SymbolSet_SpaceMissile = "06";
    public static final String SymbolSet_LandUnit = "10";
    public static final String SymbolSet_LandCivilianUnit_Organization = "11";
    public static final String SymbolSet_LandEquipment = "15";
    public static final String SymbolSet_LandInstallation = "20";
    public static final String SymbolSet_ControlMeasure = "25";
    public static final String SymbolSet_SeaSurface = "30";
    public static final String SymbolSet_SeaSubsurface = "35";
    public static final String SymbolSet_MineWarfare = "36";
    public static final String SymbolSet_Activities = "40";
    public static final String SymbolSet_Atmospheric = "45";
    public static final String SymbolSet_Oceanographic = "46";
    public static final String SymbolSet_MeteorologicalSpace = "47";
    public static final String SymbolSet_SignalsIntelligence_Space = "50";
    public static final String SymbolSet_SignalsIntelligence_Air = "51";
    public static final String SymbolSet_SignalsIntelligence_Land = "52";
    public static final String SymbolSet_SignalsIntelligence_Surface = "53";
    public static final String SymbolSet_SignalsIntelligence_Subsurface = "54";
    public static final String SymbolSet_CyberSpace = "60";
    public static final String SymbolSet_VersionExtensionFlag = "99";

    //Status, 1 Digit
    public static final char Status_Present = '0';
    public static final char Status_Planned_Anticipated_Suspect = '1';
    public static final char Status_Present_FullyCapable = '2';
    public static final char Status_Present_Damaged = '3';
    public static final char Status_Present_Destroyed = '4';
    public static final char Status_Present_FullToCapacity = '5';
    public static final char Status_Present_VersionExtensionFlag = '9';

    //Headquarters/Task Force/Dummy
    public static final char HQTFD_Unknown = '0';
    public static final char HQTFD_FeintDummy = '1';
    public static final char HQTFD_Headquarters = '2';
    public static final char HQTFD_FeintDummy_Headquarters = '3';
    public static final char HQTFD_TaskForce = '4';
    public static final char HQTFD_FeintDummy_TaskForce = '5';
    public static final char HQTFD_TaskForce_Headquarters = '6';
    public static final char HQTFD_FeintDummy_TaskForce_Headquarters = '7';
    public static final char HQTFD_VersionExtensionFlag = '9';

    //Echelon/Mobility/Towed Array Amplifier
    public static final String Echelon_Unknown = "00";
    public static final String Echelon_Team_Crew = "11";
    public static final String Echelon_Squad = "12";
    public static final String Echelon_Section = "13";
    public static final String Echelon_Platoon_Detachment = "14";
    public static final String Echelon_Company_Battery_Troop = "15";
    public static final String Echelon_Battalion_Squadron = "16";
    public static final String Echelon_Regiment_Group = "17";
    public static final String Echelon_Brigade = "18";
    public static final String Echelon_VersionExtensionFlag = "19";
    public static final String Echelon_Division = "21";
    public static final String Echelon_Corps_MEF = "22";
    public static final String Echelon_Army = "23";
    public static final String Echelon_ArmyGroup_Front = "24";
    public static final String Echelon_Region_Theater = "25";
    public static final String Echelon_Region_Command = "26";
    public static final String Echelon_VersionExtensionFlag2 = "29";

    public static final String Mobility_Unknown = "00";
    //equipment mobility on land
    public static final String Mobility_WheeledLimitedCrossCountry = "31";
    public static final String Mobility_WheeledCrossCountry = "32";
    public static final String Mobility_Tracked = "33";
    public static final String Mobility_Wheeled_Tracked = "34";
    public static final String Mobility_Towed = "35";
    public static final String Mobility_Rail = "36";
    public static final String Mobility_PackAnimals = "37";
    //equipment mobility on snow
    public static final String Mobility_OverSnow = "41";
    public static final String Mobility_Sled = "42";
    //equipment mobility on water
    public static final String Mobility_Barge = "51";
    public static final String Mobility_Amphibious = "52";
    //naval towed array
    public static final String Mobility_ShortTowedArray = "61";
    public static final String Mobility_LongTowedArray = "62";//*/


    //Version, 1-2 (Can't start with zero, will be 10 at a minimum)
    public static final int Version_2525D = 10;
    public static final int Version_2525Dch1 = 11;
    /**
     * @deprecated withdrawn from standard
     */
    public static final int Version_APP6Dch2 = 12;
    public static final int Version_2525E = 13;
    public static final int Version_APP6Ech1 = 14;
    public static final int Version_2525Ech1 = 15;
    public static final int Version_APP6Ech2 = 16;

    //Standard Identity, First Digit (3)
    public static final int StandardIdentity_Context_Reality = 0;
    public static final int StandardIdentity_Context_Exercise = 1;
    public static final int StandardIdentity_Context_Simulation = 2;
    public static final int StandardIdentity_Context_Restricted_Target_Reality = 3;
    public static final int StandardIdentity_Context_No_Strike_Entity_Reality = 4;

    //Standard Identity, Second Digit (4)
    public static final int StandardIdentity_Affiliation_Pending = 0;
    public static final int StandardIdentity_Affiliation_Unknown = 1;
    public static final int StandardIdentity_Affiliation_AssumedFriend = 2;
    public static final int StandardIdentity_Affiliation_Friend = 3;
    public static final int StandardIdentity_Affiliation_Neutral = 4;
    public static final int StandardIdentity_Affiliation_Suspect_Joker = 5;
    public static final int StandardIdentity_Affiliation_Hostile_Faker = 6;

    //Symbol Set, 2 Digits (5-6)
    public static final int SymbolSet_Unknown = 00;
    public static final int SymbolSet_Air = 01;
    public static final int SymbolSet_AirMissile = 02;
    public static final int SymbolSet_Space = 05;
    public static final int SymbolSet_SpaceMissile = 06;
    public static final int SymbolSet_LandUnit = 10;
    public static final int SymbolSet_LandCivilianUnit_Organization = 11;
    public static final int SymbolSet_LandEquipment = 15;
    public static final int SymbolSet_LandInstallation = 20;
    public static final int SymbolSet_ControlMeasure = 25;
    public static final int SymbolSet_DismountedIndividuals = 27;
    public static final int SymbolSet_SeaSurface = 30;
    public static final int SymbolSet_SeaSubsurface = 35;
    public static final int SymbolSet_MineWarfare = 36;
    public static final int SymbolSet_Activities = 40;
    public static final int SymbolSet_Atmospheric = 45;
    public static final int SymbolSet_Oceanographic = 46;
    public static final int SymbolSet_MeteorologicalSpace = 47;

    /**
     * in 2525E+, there is only SymbolSet_SignalsIntelligence and the frame shape position is required to be populated.
     * Valid frames are space, air, land, land equipment, sea surface, sea subsurface and cyberspace.
     */
    public static final int SymbolSet_SignalsIntelligence = 50;
    /**
     * 2525D/Dch1 only
     */
    public static final int SymbolSet_SignalsIntelligence_Space = 50;
    /**
     * 2525D/Dch1 only
     */
    public static final int SymbolSet_SignalsIntelligence_Air = 51;
    /**
     * 2525D/Dch1 only
     */
    public static final int SymbolSet_SignalsIntelligence_Land = 52;
    /**
     * 2525D/Dch1 only
     */
    public static final int SymbolSet_SignalsIntelligence_SeaSurface = 53;
    /**
     * 2525D/Dch1 only
     */
    public static final int SymbolSet_SignalsIntelligence_SeaSubsurface = 54;

    public static final int SymbolSet_CyberSpace = 60;

    public static final int SymbolSet_InvalidSymbol = 98;
    public static final int SymbolSet_VersionExtensionFlag = 99;

    //Status, 1 Digit
    public static final int Status_Present = 0;
    public static final int Status_Planned_Anticipated_Suspect = 1;
    public static final int Status_Present_FullyCapable = 2;
    public static final int Status_Present_Damaged = 3;
    public static final int Status_Present_Destroyed = 4;
    public static final int Status_Present_FullToCapacity = 5;
    public static final int Status_Present_VersionExtensionFlag = 9;

    //Headquarters/Task Force/Dummy
    public static final int HQTFD_Unknown = 0;
    public static final int HQTFD_FeintDummy = 1;
    public static final int HQTFD_Headquarters = 2;
    public static final int HQTFD_FeintDummy_Headquarters = 3;
    public static final int HQTFD_TaskForce = 4;
    public static final int HQTFD_FeintDummy_TaskForce = 5;
    public static final int HQTFD_TaskForce_Headquarters = 6;
    public static final int HQTFD_FeintDummy_TaskForce_Headquarters = 7;
    public static final int HQTFD_VersionExtensionFlag = 9;

    //Echelon/Mobility/Towed Array Amplifier
    public static final int Echelon_Unknown = 00;
    public static final int Echelon_Team_Crew = 11;
    public static final int Echelon_Squad = 12;
    public static final int Echelon_Section = 13;
    public static final int Echelon_Platoon_Detachment = 14;
    public static final int Echelon_Company_Battery_Troop = 15;
    public static final int Echelon_Battalion_Squadron = 16;
    public static final int Echelon_Regiment_Group = 17;
    public static final int Echelon_Brigade = 18;
    public static final int Echelon_VersionExtensionFlag = 19;
    public static final int Echelon_Division = 21;
    public static final int Echelon_Corps_MEF = 22;
    public static final int Echelon_Army = 23;
    public static final int Echelon_ArmyGroup_Front = 24;
    public static final int Echelon_Region_Theater = 25;
    public static final int Echelon_Region_Command = 26;
    public static final int Echelon_VersionExtensionFlag2 = 29;

    public static final int Mobility_Unknown = 00;
    //equipment mobility on land
    public static final int Mobility_WheeledLimitedCrossCountry = 31;
    public static final int Mobility_WheeledCrossCountry = 32;
    public static final int Mobility_Tracked = 33;
    public static final int Mobility_Wheeled_Tracked = 34;
    public static final int Mobility_Towed = 35;
    public static final int Mobility_Rail = 36;
    public static final int Mobility_PackAnimals = 37;
    //equipment mobility on snow
    public static final int Mobility_OverSnow = 41;
    public static final int Mobility_Sled = 42;
    //equipment mobility on water
    public static final int Mobility_Barge = 51;
    public static final int Mobility_Amphibious = 52;
    //naval towed array
    public static final int Mobility_ShortTowedArray = 61;
    public static final int Mobility_LongTowedArray = 62;

    public static final int Leadership_Individual = 71;

    //Frame Shape, 1 digit, position 23
    public static final char FrameShape_Unknown = '0';
    public static final char FrameShape_Space = '1';
    public static final char FrameShape_Air = '2';
    public static final char FrameShape_LandUnit = '3';
    public static final char FrameShape_LandEquipment = '4';
    public static final char FrameShape_LandInstallation = '5';
    public static final char FrameShape_DismountedIndividuals = '6';
    public static final char FrameShape_SeaSubsurface = '7';
    public static final char FrameShape_Activity_Event = '8';
    public static final char FrameShape_Cyberspace = '9';
    public static final char FrameShape_SeaSurface = 'A';


    /**
     * Attempts to resolve a bad symbol ID into a value that can be found in {@link MSLookup}.
     * If it fails, it will return the symbol code for a invalid symbol which is displayed as
     * an inverted question mark (110098000010000000000000000000)
     * @param symbolID 30 character {@link String}
     * @return 30 character {@link String} representing the resolved symbol ID.
     * @deprecated See {@link SymbolUtilities#reconcileSymbolID(String)}
     */
    public static String reconcileSymbolID(String symbolID)
    {
        return SymbolUtilities.reconcileSymbolID(symbolID);
    }

    /**
     * Gets the version number from the Symbol ID at positions 1-2
     * @param symbolID 30 character {@link String}
     * @return {@link Integer} like {@link SymbolID#Version_2525Dch1} (11)
     * <br></br><img src='data:image/png;base64,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' ></img>
     */
    public static int getVersion(String symbolID)
    {
        int v = 11;
        if(symbolID != null && symbolID.length() >= 20)
        {
            v =  Integer.parseInt(symbolID.substring(0, 2));

        }
        return v;
    }

    /**
     * Sets the version number of the Symbol ID at positions 1-2
     * @param symbolID 30 character {@link String}
     * @param ver {@link Integer} like {@link SymbolID#Version_2525Dch1} (11)
     * @return updated 30 character {@link String} symbol ID
     */
    public static String setVersion(String symbolID, int ver)
    {
        String strVer = String.valueOf(ver);

        if(symbolID != null && symbolID.length() >= 20)
        {
            if(strVer.length() != 2)
                strVer = "11";//default to 2525Dch1

            return strVer + symbolID.substring(2);
        }
        else
        {
            return symbolID;
        }
    }


    /**
     * Gets the version number from the Symbol ID at positions 3-4.
     * Restricted and No-Strike values are NATO only.
     * @param symbolID 30 character {@link String}
     * @return {@link Integer}, number will not be padded if it starts with a '0'
     * <br></br><img src='data:image/png;base64,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' ></img>
     */
    public static int getStandardIdentity(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return Integer.parseInt(symbolID.substring(2, 4));
        }
        else
        {
            return 00;
        }
    }

    /**
     * Sets the version number of the Symbol ID at positions 3-4
     * @param symbolID 30 character {@link String}
     * @param si {@link Integer} If number is a single digit, will pad with a '0' before inserting into symbol ID
     * @return updated 30 character {@link String} symbol ID
     */
    public static String setStandardIdentity(String symbolID, int si)
    {
        String strSI = String.valueOf(si);

        if(symbolID != null && symbolID.length() >= 20)
        {
            if(si < 10 && strSI.length() == 1)
                strSI = "0" + strSI;
            else
                strSI = String.valueOf(si);

            return symbolID.substring(0,2) + strSI + symbolID.substring(4);
        }
        else
        {
            return symbolID;
        }
    }


    /**
     * Get Context (Reality (0), Exercise (1), Simulation (2)) at position 3
     * Higher values are NATO only
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer}
     * <br></br><img src='data:image/png;base64,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' ></img>
     */
    public static int getContext(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return Integer.parseInt(symbolID.substring(2,3));
        }
        else
        {
            return 0;
        }
    }

    /**
     * Set Context (Reality (0), Exercise (1), Simulation (2)) at position 3
     * @param symbolID 30 Character {@link String}
     * @param context {@link Integer}
     * @return {@link String} updated Symbol ID.
     */
    public static String setContext(String symbolID, int context)
    {
        if(symbolID != null && symbolID.length() >= 20 && context < 4)
        {
            return symbolID.substring(0,2) + String.valueOf(context) + symbolID.substring(3);
        }
        else
        {
            return symbolID;
        }
    }

    /**
     * Get Affiliation from position 4
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer} like {@link SymbolID#StandardIdentity_Affiliation_Friend}
     * <br></br><img src='data:image/png;base64,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' ></img>
     */
    public static int getAffiliation(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return Integer.parseInt(symbolID.substring(3,4));
        }
        else
        {
            return 0;
        }
    }

    /**
     * Set Affiliation at position 4
     * @param symbolID 30 Character {@link String}
     * @param affiliation like {@link SymbolID#StandardIdentity_Affiliation_Friend}
     * @return {@link String} updated Symbol ID.
     */
    public static String setAffiliation(String symbolID, int affiliation)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.substring(0,3) + String.valueOf(affiliation) + symbolID.substring(4);
//            return Integer.parseInt(symbolID.substring(2,4));
        }
        else
        {
            return symbolID;
        }
    }

    /**
     * Get Symbol Set from positions 5-6
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer} like {@link SymbolID#SymbolSet_LandCivilianUnit_Organization}
     * <br></br><img src='data:image/png;base64,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' ></img>
     */
    public static int getSymbolSet(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return Integer.parseInt(symbolID.substring(4, 6));
        }
        else
        {
            return 00;
        }
    }

    /**
     * Set Symbol Set at positions 5-6
     * @param symbolID 30 Character {@link String}
     * @param ss like {@link SymbolID#SymbolSet_LandCivilianUnit_Organization}
     * @return {@link String} updated Symbol ID.
     */
    public static String setSymbolSet(String symbolID, int ss)
    {
        String strSS = String.valueOf(ss);
        if(ss < 10 && strSS.length()==1)
            strSS = "0" + strSS;
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.substring(0,4) + strSS + symbolID.substring(6);
        }
        else
        {
            return symbolID;
        }
    }

    /**
     * Get Symbol Set from position 7
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer} like {@link SymbolID#Status_Present}
     * <br></br><img src='data:image/png;base64,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' ></img>
     */
    public static int getStatus(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return Integer.parseInt(symbolID.substring(6,7));
        }
        else
        {
            return 0;
        }
    }

    /**
     * Set Symbol Set at position 7
     * @param symbolID 30 Character {@link String}
     * @param status like {@link SymbolID#Status_Present}
     * @return {@link String} updated Symbol ID.
     */
    public static String setStatus(String symbolID, int status)
    {
        String strStatus = String.valueOf(status);

        if(symbolID != null && symbolID.length() >= 20 && strStatus.length() == 1)
        {
            return symbolID.substring(0,6) + strStatus + symbolID.substring(7);
        }
        else
        {
            return symbolID;
        }
    }

    /**
     * Get Symbol Set from position 8
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer} like {@link SymbolID#HQTFD_Headquarters}
     * <br></br><img src='data:image/png;base64,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' ></img>
     */
    public static int getHQTFD(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return Integer.parseInt(symbolID.substring(7,8));
        }
        else
        {
            return 0;
        }
    }

    /**
     * Set Symbol Set at position 8
     * @param symbolID 30 Character {@link String}
     * @param HQTFD like {@link SymbolID#HQTFD_Headquarters}
     * @return {@link String} updated Symbol ID.
     */
    public static String setHQTFD(String symbolID, int HQTFD)
    {
        String strHQTFD = String.valueOf(HQTFD);

        if(symbolID != null && symbolID.length() >= 20 && strHQTFD.length() == 1)
        {
            return symbolID.substring(0,7) + strHQTFD + symbolID.substring(8);
        }
        else
        {
            return symbolID;
        }
    }

    /**
     * Get Amplifier Descriptor which can describe things like
     * Echelon / Mobility / Towed Array / Leadership Indicator from positions 9-10
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer}
     * <br></br><img src='data:image/png;base64,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' ></img>
     */
    public static int getAmplifierDescriptor(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return Integer.parseInt(symbolID.substring(8, 10));
        }
        else
        {
            return 00;
        }
    }

    /**
     * Set Amplifier Descriptor which can describe things like
     * Echelon / Mobility / Towed Array / Leadership Indicator at positions 9-10
     * @param symbolID 30 Character {@link String}
     * @param ad
     * @return {@link String}
     */
    public static String setAmplifierDescriptor(String symbolID, int ad)
    {
        String strAD = String.valueOf(ad);
        if(ad < 10 && strAD.length() == 1)
            strAD = "0" + strAD;

        if(symbolID != null && symbolID.length() >= 20 && strAD.length() == 2)
        {
            return symbolID.substring(0,8) + strAD + symbolID.substring(10);
        }
        else
        {
            return symbolID;
        }
    }

    /**
     * Get Entity Code from positions 11-16.
     * These six digits identify a unique symbol within a symbol set.
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer}
     * <br></br><img src='data:image/png;base64,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' ></img>
     */
    public static int getEntityCode(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return Integer.parseInt(symbolID.substring(10, 16));
        }
        else
        {
            return 000000;
        }
    }

    /**
     * Set Entity Code at positions 11-16.
     * These six digits identify a unique symbol within a symbol set.
     * @param symbolID 30 Character {@link String}
     * @param entityCode {@link Integer}
     * @return {@link String}
     */
    public static String setEntityCode(String symbolID, int entityCode)
    {
        String strSS = String.valueOf(entityCode);
        while (strSS.length() < 6)
            strSS = "0" + strSS;
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.substring(0,10) + strSS + symbolID.substring(16);
        }
        else
        {
            return symbolID;
        }
    }

    /**
     * Get Entity from positions 11-12.
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer}
     */
    public static int getEntity(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return Integer.parseInt(symbolID.substring(10, 12));
        }
        else
        {
            return 00;
        }
    }

    /**
     * Get Entity Type from positions 13-14.
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer}
     */
    public static int getEntityType(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return Integer.parseInt(symbolID.substring(12, 14));
        }
        else
        {
            return 00;
        }
    }

    /**
     * Get Entity Subtype from positions 15-16.
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer}
     */
    public static int getEntitySubtype(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return Integer.parseInt(symbolID.substring(14, 16));
        }
        else
        {
            return 00;
        }
    }

    /**
     * Get Sector 1 Modifier from positions 17-18.
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer}
     * <br></br><img src='data:image/png;base64,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' ></img>
     */
    public static int getModifier1(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            String mod = symbolID.substring(16, 18);
            if(SymbolUtilities.isNumber(symbolID))
            {
                return Integer.parseInt(mod);
            }
            else
            {
                return Integer.parseInt(mod,16);
            }
        }
        else
        {
            return 00;
        }
    }

    /**
     * Set Sector 1 Modifier at positions 17-18.
     * @param symbolID 30 Character {@link String}
     * @param mod1 {@link Integer} 0-255
     * @return {@link String}
     */
    public static String setModifier1(String symbolID, int mod1)
    {
        String temp = null;
        if(mod1 < 100)
        {
            temp = String.valueOf(mod1);
            return setModifier1(symbolID,temp);
        }
        else if(mod1 >= 161 && mod1 <= 255)
        {
            String mod = Integer.toHexString(mod1).toUpperCase();
            return setModifier1(symbolID,mod);
        }
        else
            return symbolID;
    }

    /**
     *
     * @param symbolID 30 Character {@link String}
     * @param mod1 {@link String} hex string from "00" to "FF"
     * @return {@link String}
     */
    public static String setModifier1(String symbolID, String mod1)
    {
        String newID = symbolID;
        String mod = mod1;
        if(mod == null || mod1.isEmpty() || mod.length() > 2)
            mod = "00";
        else if(mod.length()==1)
            mod = "0" + mod;
        if(symbolID != null && symbolID.length() >= 20)
        {
            newID = newID.substring(0,16) + mod + newID.substring(18);
        }
        return newID;
    }

    /**
     * Get Common Sector 1 Modifier from position 21.
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer}
     */
    public static int getCommonModifier1(String symbolID)
    {
        String m1 = "";
        if(symbolID != null && symbolID.length() == 30)
        {
            m1 += symbolID.substring(20, 21);
            return Integer.parseInt(m1);
        }
        else
        {
            return 0;
        }
    }

    /**
     * Set Common Sector 1 Modifier at position 21.
     * @param symbolID 30 Character {@link String}
     * @param mod1I {@link Integer}
     * @return {@link String}
     */
    public static String setCommonModifier1(String symbolID, int mod1I)
    {
        String newID = new String(symbolID);
        String mod = String.valueOf(mod1I);
        if(symbolID != null && symbolID.length() == 30)
        {
            newID = newID.substring(0,20) + mod + newID.substring(21);
        }
        return newID;
    }

    /**
     * Get Sector 2 Modifier from positions 17-18.
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer}
     * <br></br><img src='data:image/png;base64,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' ></img>
     */
    public static int getModifier2(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            String mod = symbolID.substring(18, 20);
            if(SymbolUtilities.isNumber(symbolID))
            {
                return Integer.parseInt(mod);
            }
            else
            {
                return Integer.parseInt(mod,16);
            }
        }
        else
        {
            return 00;
        }
    }

    /**
     * Set Sector 2 Modifier at positions 17-18.
     * MilStd doesn't treat these as proper hex values.
     * They go from 0-99 then just to A1 which is 161 as an integer.
     * @param symbolID 30 Character {@link String}
     * @param mod2 {@link Integer} 0-255
     * @return {@link String}
     */
    public static String setModifier2(String symbolID, int mod2)
    {
        String temp = null;
        if(mod2 < 100)
        {
            temp = String.valueOf(mod2);
            return setModifier2(symbolID,temp);
        }
        else if(mod2 >= 161 && mod2 <= 255)
        {
            String mod = Integer.toHexString(mod2).toUpperCase();
            return setModifier2(symbolID,mod);
        }
        else
            return symbolID;
    }

    /**
     *
     * @param symbolID 30 Character {@link String}
     * @param mod2 {@link String} hex string from "00" to "FF"
     * @return {@link String}
     */
    public static String setModifier2(String symbolID, String mod2)
    {
        String newID = symbolID;
        String mod = mod2;
        if(mod == null || mod2.isEmpty() || mod.length() > 2)
            mod = "00";
        else if(mod.length()==1)
            mod = "0" + mod;
        if(symbolID != null && symbolID.length() >= 20)
        {
            newID = newID.substring(0,18) + mod + newID.substring(20);
        }
        return newID;
    }

    /**
     * Get Common Sector 2 Modifier from position 22.
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer}
     */
    public static int getCommonModifier2(String symbolID)
    {
        String m1 = "";
        if(symbolID != null && symbolID.length() == 30)
        {
            m1 += symbolID.substring(21, 22);
            return Integer.parseInt(m1);
        }
        else
        {
            return 0;
        }
    }

    /**
     * Set Common Sector 2 Modifier at position 22.
     * @param symbolID 30 Character {@link String}
     * @param mod1I {@link Integer}
     * @return {@link String}
     */
    public static String setCommonModifier2(String symbolID, int mod1I)
    {
        String newID = new String(symbolID);
        String mod = String.valueOf(mod1I);
        if(symbolID != null && symbolID.length() == 30)
        {
            newID = newID.substring(0,21) + mod + newID.substring(22);
        }
        return newID;
    }

    /*
    public static String getStandardIdentity(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.substring(2, 4);
        }
        else
        {
            return "00";
        }
    }

    public static char getContext(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.charAt(3);
        }
        else
        {
            return '0';
        }
    }

    public static char getAffiliation(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.charAt(4);
        }
        else
        {
            return '0';
        }
    }

    public static String getSymbolSet(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.substring(4, 6);
        }
        else
        {
            return "00";
        }
    }

    public static char getStatus(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.charAt(6);
        }
        else
        {
            return '0';
        }
    }

    public static char getHQTFD(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.charAt(7);
        }
        else
        {
            return '0';
        }
    }


    //  get Echelon / Mobility / Towed Array
    //  @param symbolID
    //  @return

    public static String getAmplifierDescriptor(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.substring(8, 10);
        }
        else
        {
            return "00";
        }
    }

    public static String getEntityCode(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.substring(10, 16);
        }
        else
        {
            return "000000";
        }
    }

    public static String getEntity(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.substring(10, 12);
        }
        else
        {
            return "00";
        }
    }

    public static String getEntityType(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.substring(12, 14);
        }
        else
        {
            return "00";
        }
    }

    public static String getEntitySubtype(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.substring(14, 16);
        }
        else
        {
            return "00";
        }
    }

    public static String getModifier1(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.substring(16, 18);
        }
        else
        {
            return "00";
        }
    }

    public static String getModifier2(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 20)
        {
            return symbolID.substring(18, 20);
        }
        else
        {
            return "00";
        }
    }//*/

    /**
     * Returns true is symbol is of the Meteorological variety.
     * @param symbolID 30 Character {@link String}
     * @return {@link Boolean}
     * @deprecated See {@link SymbolUtilities#isWeather(String)}
     */
    public static Boolean isMETOC(String symbolID) {
        return SymbolUtilities.isWeather(symbolID);
    }

    /**
     * Build string to grab appropriate SVG file
     * @param symbolID 30 Character {@link String}
     * @return {@link String}
     * @deprecated See {@link SVGLookup#getFrameID(String)}
     */
    public static String getFrameID(String symbolID) {
        //SIDC positions 3_456_7
        return SVGLookup.getFrameID(symbolID);
    }

    /**
     * Build string to grab appropriate SVG file
     * @param symbolID 30 Character {@link String}
     * @return {@link String}
     * @deprecated See {@link SVGLookup#getMainIconID(String)}
     */
    public static String getMainIconID(String symbolID) {
        //SIDC positions 5-6 + 11-16
        return SVGLookup.getMainIconID(symbolID);
    }

    /**
     * Build string to grab appropriate SVG file
     * @param symbolID 30 Character {@link String}
     * @return {@link String}
     * @deprecated See {@link SVGLookup#getMod2ID(String)} (String)}
     */
    public static String getMod2ID(String symbolID) {
        //SIDC positions 5-6 + 19-20 + "2"
        return SVGLookup.getMod2ID(symbolID);
    }

    /**
     * Build string to grab appropriate SVG file
     * @param symbolID 30 Character {@link String}
     * @return {@link String}
     * @deprecated See {@link SVGLookup#getMod1ID(String)} (String)}
     */
    public static String getMod1ID(String symbolID) {
        //SIDC positions 5-6 + 17-18 + "1"
        return SVGLookup.getMod1ID(symbolID);
    }

    /**
     * Gets the 3 digit county code from positions 28-30
     * @param symbolID 30 Character {@link String}
     * @return {@link Integer}
     */
    public static int getCountryCode(String symbolID)
    {
        String scc = "0";
        if(symbolID.length() == 30)
            scc = symbolID.substring(27,30);
        return Integer.parseInt(scc);
    }

    /**
     * In 2525E, position 23 of the symbol code has the Frame Shape modifier.
     * This lets a user force a different frame shape than what a symbol would normally have.
     * Like you could have Air Fixed Wing with a ground unit rectangle frame for when it's on the ground.
     * This function returns the frame shape value for what the default frame would be for a specific symbol set.
     * @param symbolID 30 Character {@link String}
     * @return {@link Character}
     * <br></br><img src='data:image/png;base64,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' ></img>
     */
    public static char getDefaultFrameShape(String symbolID)
    {
        int ss = SymbolID.getSymbolSet(symbolID);

        switch(ss)
        {
            case SymbolSet_Air:
            case SymbolSet_AirMissile:
            case SymbolSet_SignalsIntelligence_Air:
                return SymbolID.FrameShape_Air;
            case SymbolSet_Space:
            case SymbolSet_SpaceMissile:
            case SymbolSet_SignalsIntelligence_Space:
                if(ss==SymbolSet_SignalsIntelligence && SymbolID.getVersion(symbolID) >= SymbolID.Version_2525E)
                    return SymbolID.FrameShape_LandEquipment;//should be specified in 2525E+
                else
                    return SymbolID.FrameShape_Space;
            case SymbolSet_LandUnit:
            case SymbolSet_LandCivilianUnit_Organization:
            case SymbolSet_SignalsIntelligence_Land:
                return SymbolID.FrameShape_LandUnit;
            case SymbolSet_LandEquipment:
                return SymbolID.FrameShape_LandEquipment;
            case SymbolSet_LandInstallation:
                return SymbolID.FrameShape_LandInstallation;
            case SymbolSet_SeaSurface:
            case SymbolSet_SignalsIntelligence_SeaSurface:
                return SymbolID.FrameShape_SeaSurface;
            case SymbolSet_SeaSubsurface:
            case SymbolSet_SignalsIntelligence_SeaSubsurface:
            case SymbolSet_MineWarfare:
                return SymbolID.FrameShape_SeaSubsurface;
            case SymbolSet_DismountedIndividuals:
                return SymbolID.FrameShape_DismountedIndividuals;
            case SymbolSet_Activities:
                return SymbolID.FrameShape_Activity_Event;
            case SymbolSet_CyberSpace:
                return SymbolID.FrameShape_Cyberspace;
            default:
                return SymbolID.FrameShape_Unknown;
        }
    }

    /**
     *
     * @param symbolID
     * @param frameShape like SymbolID.FrameShape_LandEquipment
     * @return
     */
    public static String setFrameShape(String symbolID, char frameShape)
    {
        if(symbolID != null && symbolID.length() >= 23)
        {
            return symbolID.substring(0,22) + frameShape + symbolID.substring(23);
        }
        else
            return symbolID;
    }

    /**
     * Gets the Frame Shape override from position 23.
     * @param symbolID 30 Character {@link String}
     * @return {@link Character}
     * <br></br><img src='data:image/png;base64,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' ></img>
     */
    public static char getFrameShape(String symbolID)
    {
        if(symbolID != null && symbolID.length() >= 23)
            return symbolID.charAt(22);
        else
            return '0';
    }
}


