/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.SVGInfo;
import armyc2.c5isr.renderer.utilities.SVGLookup;
import armyc2.c5isr.renderer.utilities.SymbolID;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class RendererUtilities {
    private static final float OUTLINE_SCALING_FACTOR = 2.5f;
    private static HashMap<Integer, Color> pastIdealOutlineColors = new HashMap();

    public static String imgToBase64String(BufferedImage img) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", os);
            return "data:image/png;base64," + Base64.getEncoder().encodeToString(os.toByteArray());
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static Color getIdealOutlineColor(Color color) {
        Color idealColor = Color.white;
        if (color != null && pastIdealOutlineColors.containsKey(color.getRGB())) {
            return pastIdealOutlineColors.get(color.getRGB());
        }
        if (color != null) {
            int b;
            int g;
            int threshold = RendererSettings.getInstance().getTextBackgroundAutoColorThreshold();
            int r = color.getRed();
            float delta = (float)r * 0.299f + (float)(g = color.getGreen()) * 0.587f + (float)(b = color.getBlue()) * 0.114f;
            idealColor = 255.0f - delta < (float)threshold ? Color.black : Color.white;
        }
        if (color != null) {
            pastIdealOutlineColors.put(color.getRGB(), idealColor);
        }
        return idealColor;
    }

    public static Color setColorAlpha(Color color, float alpha) {
        if (color != null) {
            if (alpha >= 0.0f && alpha <= 1.0f) {
                return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(alpha * 255.0f));
            }
            return color;
        }
        return null;
    }

    private static String ColorToHex(Color color) {
        String hex = String.format("%02x%02x%02x%02x", color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
        return hex;
    }

    public static String colorToHexString(Color color, Boolean withAlpha) {
        if (color != null) {
            String r = Integer.toHexString(color.getRed());
            String g = Integer.toHexString(color.getGreen());
            String b = Integer.toHexString(color.getBlue());
            String a = Integer.toHexString(color.getAlpha());
            if (r.length() == 1) {
                r = "0" + r;
            }
            if (g.length() == 1) {
                g = "0" + g;
            }
            if (b.length() == 1) {
                b = "0" + b;
            }
            if (a.length() == 1) {
                a = "0" + a;
            }
            if (withAlpha.booleanValue()) {
                return "#" + a + r + g + b;
            }
            return "#" + r + g + b;
        }
        return "";
    }

    public static Color getColorFromHexString(String hexValue) {
        try {
            if (hexValue == null || hexValue.isEmpty()) {
                return null;
            }
            String hexOriginal = hexValue;
            String hexAlphabet = "0123456789ABCDEF";
            if (hexValue.charAt(0) == '#') {
                hexValue = hexValue.substring(1);
            }
            if (hexValue.substring(0, 2).equals("0x") || hexValue.substring(0, 2).equals("0X")) {
                hexValue = hexValue.substring(2);
            }
            hexValue = hexValue.toUpperCase();
            int count = hexValue.length();
            int[] value = null;
            int k = 0;
            int int1 = 0;
            int int2 = 0;
            if (count == 8 || count == 6) {
                value = new int[count / 2];
                for (int i = 0; i < count; i += 2) {
                    int1 = hexAlphabet.indexOf(hexValue.charAt(i));
                    int2 = hexAlphabet.indexOf(hexValue.charAt(i + 1));
                    if (int1 == -1 || int2 == -1) {
                        ErrorLogger.LogMessage("RendererUtilities", "getColorFromHexString", "Bad hex value: " + hexOriginal, Level.WARNING);
                        return null;
                    }
                    value[k] = int1 * 16 + int2;
                    ++k;
                }
                if (count == 8) {
                    return new Color(value[1], value[2], value[3], value[0]);
                }
                return new Color(value[0], value[1], value[2]);
            }
            ErrorLogger.LogMessage("RendererUtilities", "getColorFromHexString", "Bad hex value: " + hexOriginal, Level.WARNING);
            return null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("RendererUtilities", "getColorFromHexString", exc);
            return null;
        }
    }

    public static int getRecommendedTextOutlineWidth() {
        return RendererUtilities.getRecommendedTextOutlineWidth(RendererSettings.getInstance().getDeviceDPI(), RendererSettings.getInstance().getTextBackgroundMethod());
    }

    public static int getRecommendedTextOutlineWidth(int textBackgroundMethod) {
        return RendererUtilities.getRecommendedTextOutlineWidth(RendererSettings.getInstance().getDeviceDPI(), textBackgroundMethod);
    }

    public static int getRecommendedTextOutlineWidth(int dpi, int textBackgroundMethod) {
        int outlineWidth = 0;
        if (textBackgroundMethod == 2) {
            outlineWidth = (int)Math.floor(Math.max((double)dpi / 24.0, 4.0));
        } else if (textBackgroundMethod == 3) {
            outlineWidth = (int)Math.floor(Math.max((double)dpi / 48.0 - 1.0, 1.0));
        } else if (textBackgroundMethod == -1) {
            outlineWidth = (int)Math.floor(Math.max((double)dpi / 48.0, 2.0));
        }
        return outlineWidth;
    }

    public static String setSVGFrameColors(String symbolID, String svg, Color strokeColor, Color fillColor) {
        String returnSVG = null;
        String hexStrokeColor = null;
        String hexFillColor = null;
        float strokeAlpha = 1.0f;
        float fillAlpha = 1.0f;
        String strokeOpacity = "";
        String fillOpacity = "";
        int ss = SymbolID.getSymbolSet(symbolID);
        int ver = SymbolID.getVersion(symbolID);
        int affiliation = SymbolID.getAffiliation(symbolID);
        String defaultFillColor = null;
        returnSVG = svg;
        if (strokeColor != null) {
            if (strokeColor.getAlpha() != 255) {
                strokeAlpha = (float)strokeColor.getAlpha() / 255.0f;
                strokeOpacity = " stroke-opacity=\"" + String.valueOf(strokeAlpha) + "\"";
                fillOpacity = " fill-opacity=\"" + String.valueOf(strokeAlpha) + "\"";
            }
            hexStrokeColor = RendererUtilities.colorToHexString(strokeColor, false);
            returnSVG = returnSVG.replaceAll("stroke=\"#000000\"", "stroke=\"" + hexStrokeColor + "\"" + strokeOpacity);
            returnSVG = returnSVG.replaceAll("fill=\"#000000\"", "fill=\"" + hexStrokeColor + "\"" + fillOpacity);
            if (ss == 20 || ss == 5 || ss == 60 || ss == 40) {
                String svgStart = "<g id=\"" + SVGLookup.getFrameID(symbolID) + "\">";
                String svgStartReplace = svgStart.substring(0, svgStart.length() - 1) + " fill=\"" + hexStrokeColor + "\"" + fillOpacity + ">";
                returnSVG = returnSVG.replace(svgStart, svgStartReplace);
            }
            if (SymbolID.getSymbolSet(symbolID) == 20 && SymbolID.getFrameShape(symbolID) == '0' || SymbolID.getFrameShape(symbolID) == '5') {
                int i1 = RendererUtilities.findInstIndIndex(returnSVG) + 5;
                returnSVG = returnSVG.substring(0, i1) + " fill=\"" + hexStrokeColor + "\"" + returnSVG.substring(i1);
            }
        } else if (SymbolID.getSymbolSet(symbolID) == 20 && SymbolID.getFrameShape(symbolID) == '0' || SymbolID.getFrameShape(symbolID) == '5') {
            int i1 = RendererUtilities.findInstIndIndex(returnSVG) + 5;
            returnSVG = returnSVG.substring(0, i1) + " fill=\"#000000\"" + returnSVG.substring(i1);
        }
        if (fillColor != null) {
            if (fillColor.getAlpha() != 255) {
                fillAlpha = (float)fillColor.getAlpha() / 255.0f;
                fillOpacity = " fill-opacity=\"" + String.valueOf(fillAlpha) + "\"";
            }
            hexFillColor = RendererUtilities.colorToHexString(fillColor, false);
            switch (affiliation) {
                case 2: 
                case 3: {
                    defaultFillColor = "fill=\"#80E0FF\"";
                    break;
                }
                case 6: {
                    defaultFillColor = "fill=\"#FF8080\"";
                    break;
                }
                case 5: {
                    if (SymbolID.getVersion(symbolID) >= 13) {
                        defaultFillColor = "fill=\"#FFE599\"";
                        break;
                    }
                    defaultFillColor = "fill=\"#FF8080\"";
                    break;
                }
                case 0: 
                case 1: {
                    defaultFillColor = "fill=\"#FFFF80\"";
                    break;
                }
                case 4: {
                    defaultFillColor = "fill=\"#AAFFAA\"";
                    break;
                }
                default: {
                    defaultFillColor = "fill=\"#80E0FF\"";
                }
            }
            int fillIndex = returnSVG.lastIndexOf(defaultFillColor);
            if (fillIndex != -1) {
                returnSVG = returnSVG.substring(0, fillIndex) + "fill=\"" + hexFillColor + "\"" + fillOpacity + returnSVG.substring(fillIndex + defaultFillColor.length());
            }
        }
        if (returnSVG != null) {
            return returnSVG;
        }
        return svg;
    }

    public static String setSVGSPCMColors(String symbolID, String svg, Color strokeColor, Color fillColor, boolean isOutline) {
        String returnSVG = svg;
        String hexStrokeColor = null;
        String hexFillColor = null;
        float strokeAlpha = 1.0f;
        float fillAlpha = 1.0f;
        String strokeOpacity = "";
        String fillOpacity = "";
        String strokeCapSquare = " stroke-linecap=\"square\"";
        String strokeCapButt = " stroke-linecap=\"butt\"";
        String strokeCapRound = " stroke-linecap=\"round\"";
        int affiliation = SymbolID.getAffiliation(symbolID);
        String defaultFillColor = null;
        if (strokeColor != null) {
            int mod;
            if (strokeColor.getAlpha() != 255) {
                strokeAlpha = (float)strokeColor.getAlpha() / 255.0f;
                strokeOpacity = " stroke-opacity=\"" + strokeAlpha + "\"";
                fillOpacity = " fill-opacity=\"" + strokeAlpha + "\"";
            }
            hexStrokeColor = RendererUtilities.colorToHexString(strokeColor, false);
            String defaultStrokeColor = "#000000";
            if (symbolID.length() == 5 && (mod = Integer.valueOf(symbolID.substring(2, 4)).intValue()) >= 13) {
                defaultStrokeColor = "#00A651";
            }
            if (symbolID.length() >= 20 && SymbolUtilities.getBasicSymbolID(symbolID).equals("25132100") && SymbolID.getVersion(symbolID) >= 13) {
                defaultStrokeColor = "#800080";
            }
            returnSVG = returnSVG.replaceAll("stroke=\"" + defaultStrokeColor + "\"", "stroke=\"" + hexStrokeColor + "\"" + strokeOpacity);
            returnSVG = returnSVG.replaceAll("fill=\"" + defaultStrokeColor + "\"", "fill=\"" + hexStrokeColor + "\"" + fillOpacity);
        } else {
            strokeColor = Color.BLACK;
        }
        if (isOutline) {
            Pattern pattern = Pattern.compile("(stroke-width=\")(\\d+\\.?\\d*)\"");
            Matcher m = pattern.matcher(svg);
            TreeSet<String> strokeWidthStrings = new TreeSet<String>();
            while (m.find()) {
                strokeWidthStrings.add(m.group(0));
            }
            for (String target : strokeWidthStrings.descendingSet()) {
                Pattern numPattern = Pattern.compile("\\d+\\.?\\d*");
                Matcher numMatcher = numPattern.matcher(target);
                numMatcher.find();
                float f = Float.parseFloat(numMatcher.group(0));
                String replacement = "stroke-width=\"" + f * 2.5f + "\"";
                returnSVG = returnSVG.replace(target, replacement);
            }
            pattern = Pattern.compile("(<g)");
            m = pattern.matcher(svg);
            TreeSet<String> groupStrings = new TreeSet<String>();
            while (m.find()) {
                groupStrings.add(m.group(0));
            }
            for (String target : groupStrings) {
                String replacement = target + strokeCapSquare + " stroke-width=\"" + 6.25f + "\" stroke=\"#" + RendererUtilities.ColorToHex(strokeColor).substring(2) + "\" ";
                returnSVG = returnSVG.replace(target, replacement);
            }
        } else {
            String replacement = " fill=\"#" + RendererUtilities.ColorToHex(strokeColor).substring(2) + "\" ";
            returnSVG = returnSVG.replace("fill=\"#000000\"", replacement);
            String topGroupTag = "<g id=\"" + SymbolUtilities.getBasicSymbolID(symbolID) + "\">";
            String newGroupTag = "<g id=\"" + SymbolUtilities.getBasicSymbolID(symbolID) + "\" stroke=\"" + hexStrokeColor + "\"" + strokeOpacity + " " + replacement + ">";
            returnSVG = returnSVG.replace(topGroupTag, newGroupTag);
        }
        if (fillColor != null) {
            if (fillColor.getAlpha() != 255) {
                fillAlpha = (float)fillColor.getAlpha() / 255.0f;
                fillOpacity = " fill-opacity=\"" + fillAlpha + "\"";
            }
            hexFillColor = RendererUtilities.colorToHexString(fillColor, false);
            defaultFillColor = "fill=\"#000000\"";
            returnSVG = returnSVG.replaceAll(defaultFillColor, "fill=\"" + hexFillColor + "\"" + fillOpacity);
        }
        return returnSVG;
    }

    public static float findWidestStrokeWidth(String svg) {
        Pattern pattern = Pattern.compile("(stroke-width=\")(\\d+\\.?\\d*)\"");
        Matcher m = pattern.matcher(svg);
        TreeSet<Float> strokeWidths = new TreeSet<Float>();
        while (m.find()) {
            strokeWidths.add(Float.valueOf(m.group(2)));
        }
        float largest = 4.0f;
        if (!strokeWidths.isEmpty()) {
            largest = ((Float)strokeWidths.descendingSet().first()).floatValue();
        }
        return largest * 2.5f;
    }

    public static int findInstIndIndex(String svg) {
        int start = -1;
        int stop = -1;
        start = svg.indexOf("<rect");
        String rect = svg.substring(start, (stop = svg.indexOf(">", start)) + 1);
        if (!rect.contains("fill")) {
            return start;
        }
        start = svg.indexOf("<rect", stop);
        return start;
    }

    public static int getDistanceBetweenPoints(Point2D pt1, Point2D pt2) {
        int distance = (int)Math.sqrt(Math.pow(pt2.getX() - pt1.getX(), 2.0) + Math.pow(pt2.getY() - pt1.getY(), 2.0));
        return distance;
    }

    public static double calculateMapScale(int mapPixelWidth, double eastLon, double westLon) {
        return RendererUtilities.calculateMapScale(mapPixelWidth, eastLon, westLon, RendererSettings.getInstance().getDeviceDPI());
    }

    public static double calculateMapScale(int mapPixelWidth, double eastLon, double westLon, int dpi) {
        double INCHES_PER_METER = 39.3700787;
        double METERS_PER_DEG = 111319.49166666667;
        try {
            double sizeSquare = Math.abs(eastLon - westLon);
            if (sizeSquare > 180.0) {
                sizeSquare = 360.0 - sizeSquare;
            }
            double screenLength = (double)(mapPixelWidth / dpi) / INCHES_PER_METER;
            double metersOnScreen = sizeSquare * METERS_PER_DEG;
            double scale = metersOnScreen / screenLength;
            return scale;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("RendererUtilities", "calculateMapScale", exc, Level.WARNING);
            return 0.0;
        }
    }

    public static String setSVGSPCMColors(String symbolID, String svg, Color strokeColor, Color fillColor) {
        return RendererUtilities.setSVGSPCMColors(symbolID, svg, strokeColor, fillColor, false);
    }

    public static SVGInfo scaleIcon(String symbolID, SVGInfo icon) {
        SVGInfo retVal = icon;
        double maxSize = 170.0;
        Rectangle2D bbox = null;
        if (icon != null) {
            bbox = icon.getBbox();
        }
        double length = 0.0;
        if (bbox != null) {
            length = Math.max(bbox.getWidth(), bbox.getHeight());
        }
        if (length < 100.0 && length > 0.0 && SymbolID.getCommonModifier1(symbolID) == 0 && SymbolID.getCommonModifier2(symbolID) == 0 && SymbolID.getModifier1(symbolID) == 0 && SymbolID.getModifier2(symbolID) == 0) {
            double ratio = maxSize / length;
            double transx = (bbox.getX() + bbox.getWidth() / 2.0) * ratio - (bbox.getX() + bbox.getWidth() / 2.0);
            double transy = (bbox.getY() + bbox.getHeight() / 2.0) * ratio - (bbox.getY() + bbox.getHeight() / 2.0);
            String transform = " transform=\"translate(-" + transx + ",-" + transy + ") scale(" + ratio + " " + ratio + ")\">";
            String svg = icon.getSVG();
            svg = svg.replaceFirst(">", transform);
            Rectangle2D.Double newBbox = new Rectangle2D.Double(bbox.getX() - transx, bbox.getY() - transy, bbox.getWidth() * ratio, bbox.getHeight() * ratio);
            retVal = new SVGInfo(icon.getID(), newBbox, svg);
        }
        return retVal;
    }
}

