/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.web.render;

import armyc2.c5isr.JavaLineArray.POINT2;
import armyc2.c5isr.JavaTacticalRenderer.TGLight;
import armyc2.c5isr.JavaTacticalRenderer.mdlGeodesic;
import armyc2.c5isr.RenderMultipoints.clsRenderer;
import armyc2.c5isr.renderer.utilities.DistanceUnit;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.GENCLookup;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.renderer.utilities.MSInfo;
import armyc2.c5isr.renderer.utilities.MSLookup;
import armyc2.c5isr.renderer.utilities.MilStdSymbol;
import armyc2.c5isr.renderer.utilities.PointConversion;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.RendererUtilities;
import armyc2.c5isr.renderer.utilities.ShapeInfo;
import armyc2.c5isr.renderer.utilities.SymbolDraw;
import armyc2.c5isr.renderer.utilities.SymbolID;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import armyc2.c5isr.web.render.MultiPointHandlerSVG;
import armyc2.c5isr.web.render.PointConverter;
import armyc2.c5isr.web.render.utilities.JavaRendererUtilities;
import armyc2.c5isr.web.render.utilities.LineInfo;
import armyc2.c5isr.web.render.utilities.SymbolInfo;
import armyc2.c5isr.web.render.utilities.TextInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class MultiPointHandler {
    private static final int _maxPixelWidth = 1920;
    private static final int _minPixelWidth = 720;

    public static void NormalizeGECoordsToGEExtents(double leftLongitude, double rightLongitude, ArrayList<Point2D> pts2d) {
        try {
            int j = 0;
            double x = 0.0;
            double y = 0.0;
            Point2D pt2d = null;
            int n = pts2d.size();
            for (j = 0; j < n; ++j) {
                pt2d = pts2d.get(j);
                y = pt2d.getY();
                for (x = pt2d.getX(); x < leftLongitude; x += 360.0) {
                }
                while (x > rightLongitude) {
                    x -= 360.0;
                }
                pt2d = new Point2D.Double(x, y);
                pts2d.set(j, pt2d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static Point2D NormalizeCoordToGECoord(Point2D pt2d) {
        Point2D.Double ptGeo = null;
        try {
            double x;
            double y = pt2d.getY();
            for (x = pt2d.getX(); x < -180.0; x += 360.0) {
            }
            while (x > 180.0) {
                x -= 360.0;
            }
            ptGeo = new Point2D.Double(x, y);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ptGeo;
    }

    private static String getBoundingRectangle(String controlPoints, String bbox) {
        String bbox2 = "";
        try {
            Double left = 0.0;
            Double right = 0.0;
            Double top = 0.0;
            Double bottom = 0.0;
            String[] coordinates = controlPoints.split(" ");
            int len = coordinates.length;
            int i = 0;
            left = Double.MAX_VALUE;
            right = -1.7976931348623157E308;
            top = -1.7976931348623157E308;
            bottom = Double.MAX_VALUE;
            for (i = 0; i < len; ++i) {
                String[] coordPair = coordinates[i].split(",");
                Double latitude = Double.valueOf(coordPair[1].trim());
                Double longitude = Double.valueOf(coordPair[0].trim());
                if (longitude < left) {
                    left = longitude;
                }
                if (longitude > right) {
                    right = longitude;
                }
                if (latitude > top) {
                    top = latitude;
                }
                if (!(latitude < bottom)) continue;
                bottom = latitude;
            }
            bbox2 = left.toString() + "," + bottom.toString() + "," + right.toString() + "," + top.toString();
        }
        catch (Exception ex) {
            System.out.println("Failed to create bounding rectangle in MultiPointHandler.getBoundingRect");
        }
        return bbox2;
    }

    private static Point2D getControlPoint(ArrayList<Point2D> geoCoords) {
        Point2D.Double pt2d = null;
        try {
            double left = Double.MAX_VALUE;
            double right = -1.7976931348623157E308;
            double top = -1.7976931348623157E308;
            double bottom = Double.MAX_VALUE;
            Point2D ptTemp = null;
            int n = geoCoords.size();
            for (int j = 0; j < n; ++j) {
                ptTemp = geoCoords.get(j);
                if (ptTemp.getX() < left) {
                    left = ptTemp.getX();
                }
                if (ptTemp.getX() > right) {
                    right = ptTemp.getX();
                }
                if (ptTemp.getY() > top) {
                    top = ptTemp.getY();
                }
                if (!(ptTemp.getY() < bottom)) continue;
                bottom = ptTemp.getY();
            }
            pt2d = new Point2D.Double(left, top);
        }
        catch (Exception ex) {
            System.out.println("Failed to create control point in MultiPointHandler.getControlPoint");
        }
        return pt2d;
    }

    static Point2D getGeoUL(ArrayList<Point2D> geoCoords) {
        Point2D.Double ptGeo = null;
        try {
            int j = 0;
            Point2D pt = null;
            double left = geoCoords.get(0).getX();
            double top = geoCoords.get(0).getY();
            double right = geoCoords.get(0).getX();
            double bottom = geoCoords.get(0).getY();
            int n = geoCoords.size();
            for (j = 1; j < n; ++j) {
                pt = geoCoords.get(j);
                if (pt.getX() < left) {
                    left = pt.getX();
                }
                if (pt.getX() > right) {
                    right = pt.getX();
                }
                if (pt.getY() > top) {
                    top = pt.getY();
                }
                if (!(pt.getY() < bottom)) continue;
                bottom = pt.getY();
            }
            if (right - left > 180.0) {
                left = 180.0;
                n = geoCoords.size();
                for (j = 0; j < n; ++j) {
                    pt = geoCoords.get(j);
                    if (!(pt.getX() > 0.0) || !(pt.getX() < left)) continue;
                    left = pt.getX();
                }
            }
            ptGeo = new Point2D.Double(left, top);
        }
        catch (Exception ex) {
            System.out.println("Failed to create control point in MultiPointHandler.getControlPoint");
        }
        return ptGeo;
    }

    static String getBboxFromCoords(ArrayList<Point2D> geoCoords) {
        String bbox = null;
        try {
            int j = 0;
            Point2D pt = null;
            double left = geoCoords.get(0).getX();
            double top = geoCoords.get(0).getY();
            double right = geoCoords.get(0).getX();
            double bottom = geoCoords.get(0).getY();
            for (j = 1; j < geoCoords.size(); ++j) {
                pt = geoCoords.get(j);
                if (pt.getX() < left) {
                    left = pt.getX();
                }
                if (pt.getX() > right) {
                    right = pt.getX();
                }
                if (pt.getY() > top) {
                    top = pt.getY();
                }
                if (!(pt.getY() < bottom)) continue;
                bottom = pt.getY();
            }
            if (right - left > 180.0) {
                left = 180.0;
                right = -180.0;
                for (j = 0; j < geoCoords.size(); ++j) {
                    pt = geoCoords.get(j);
                    if (pt.getX() > 0.0 && pt.getX() < left) {
                        left = pt.getX();
                    }
                    if (!(pt.getX() < 0.0) || !(pt.getX() > right)) continue;
                    right = pt.getX();
                }
            }
            bbox = Double.toString(left) + "," + Double.toString(bottom) + "," + Double.toString(right) + "," + Double.toString(top);
        }
        catch (Exception ex) {
            System.out.println("Failed to create control point in MultiPointHandler.getBboxFromCoords");
        }
        return bbox;
    }

    static boolean crossesIDL(ArrayList<Point2D> geoCoords) {
        boolean result = false;
        Point2D pt2d = MultiPointHandler.getControlPoint(geoCoords);
        double left = pt2d.getX();
        Point2D ptTemp = null;
        int n = geoCoords.size();
        for (int j = 0; j < n; ++j) {
            ptTemp = geoCoords.get(j);
            if (!(Math.abs(ptTemp.getX() - left) > 180.0)) continue;
            return true;
        }
        return result;
    }

    public static Boolean ShouldClipSymbol(String symbolID) {
        int status = SymbolID.getStatus(symbolID);
        if (SymbolUtilities.isTacticalGraphic(symbolID) && status == 1) {
            return true;
        }
        if (SymbolUtilities.isWeather(symbolID)) {
            return true;
        }
        int id = Integer.valueOf(SymbolUtilities.getBasicSymbolID(symbolID));
        if (id == 25341100 || id == 25260200 || id == 25110100 || id == 25110200 || id == 25110300 || id == 25140100 || id == 25140200 || id == 25151000 || id == 25151100 || id == 25172000 || id == 25151202 || id == 25151203 || id == 25141200 || id == 25270800 || id == 25270801 || id == 25170100 || id == 0x1801118 || id == 25170300 || id == 25170400 || id == 25170500 || id == 25170600 || id == 25170700 || id == 25270100 || id == 25270200 || id == 25270300 || id == 25270400 || id == 25290100 || id == 25290201 || id == 25290202 || id == 25290203 || id == 25290204 || id == 25290301 || id == 25290302 || id == 25290303 || id == 25290304 || id == 25290305 || id == 25290306 || id == 25290307 || id == 25290308 || id == 25290309 || id == 25341100 || id == 25290400 || id == 25282003 || id == 25270602 || id == 25271500 || id == 25271600 || id == 25290900 || id == 25271700 || id == 25271800 || id == 25271900 || id == 25272000 || id == 25240301 || id == 25240302 || id == 25240303 || id == 25240701 || id == 25240702 || id == 25240703 || id == 25151800 || id == 25330300 || id == 25330301 || id == 25330302 || id == 25330303 || id == 25330400 || id == 25330401 || id == 25330402 || id == 25330403 || id == 25151205 || id == 25341500 || id == 25340600 || id == 25340700 || id == 25271200 || id == 25271202 || id == 25341200) {
            return true;
        }
        return false;
    }

    static double getReasonableScale(String bbox, double origScale) {
        try {
            String[] bounds = bbox.split(",");
            double left = Double.valueOf(bounds[0]);
            double right = Double.valueOf(bounds[2]);
            double top = Double.valueOf(bounds[3]);
            double bottom = Double.valueOf(bounds[1]);
            POINT2 ul = new POINT2(left, top);
            POINT2 ur = new POINT2(right, top);
            double widthInMeters = left == -180.0 && right == 180.0 || left == 180.0 && right == -180.0 ? 2.00375085E7 : mdlGeodesic.geodesic_distance(ul, ur, null, null);
            double minScale = widthInMeters / (1920.0 / (double)RendererSettings.getInstance().getDeviceDPI() / 39.3700787);
            if (origScale < minScale) {
                return minScale;
            }
            double maxScale = widthInMeters / (720.0 / (double)RendererSettings.getInstance().getDeviceDPI() / 39.3700787);
            if (origScale > maxScale) {
                return maxScale;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return origScale;
    }

    public static String RenderSymbol(String id, String name, String description, String symbolCode, String controlPoints, Double scale, String bbox, Map<String, String> symbolModifiers, Map<String, String> symbolAttributes, int format) {
        boolean normalize = true;
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Rectangle rect = null;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList<ShapeInfo> shapes = new ArrayList();
        ArrayList<ShapeInfo> modifiers = new ArrayList();
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        int len = coordinates.length;
        Object coordsUL = null;
        String symbolIsValid = MultiPointHandler.canRenderMultiPoint(symbolCode, symbolModifiers, len);
        if (!symbolIsValid.equals("true")) {
            String ErrorOutput = "";
            ErrorOutput = ErrorOutput + "{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + " - ID: " + id + " - ";
            ErrorOutput = ErrorOutput + symbolIsValid;
            ErrorOutput = ErrorOutput + "\"}";
            ErrorLogger.LogMessage("MultiPointHandler", "RenderSymbol", symbolIsValid, Level.WARNING);
            return ErrorOutput;
        }
        if (MSLookup.getInstance().getMSLInfo(symbolCode).getDrawRule() != 110) {
            len = Math.min(len, MSLookup.getInstance().getMSLInfo(symbolCode).getMaxPointCount());
        }
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            Double latitude = (double)Double.valueOf(coordPair[1].trim());
            Double longitude = (double)Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        Object tgPoints = null;
        PointConverter ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        Point2D temp = null;
        Point2D ptGeoUL = null;
        int width = 0;
        int height = 0;
        int leftX = 0;
        int topY = 0;
        int bottomY = 0;
        int rightX = 0;
        int j = 0;
        ArrayList<Point2D> bboxCoords = null;
        if (bbox != null && !bbox.equals("")) {
            String[] bounds = null;
            if (bbox.contains(" ")) {
                String[] coords;
                bboxCoords = new ArrayList<Point2D>();
                double x = 0.0;
                double y = 0.0;
                for (String coord : coords = bbox.split(" ")) {
                    String[] arrCoord = coord.split(",");
                    x = Double.valueOf(arrCoord[0]);
                    y = Double.valueOf(arrCoord[1]);
                    bboxCoords.add(new Point2D.Double(x, y));
                }
                ptGeoUL = MultiPointHandler.getGeoUL(bboxCoords);
                left = ptGeoUL.getX();
                top = ptGeoUL.getY();
                String bbox2 = MultiPointHandler.getBboxFromCoords(bboxCoords);
                scale = MultiPointHandler.getReasonableScale(bbox2, scale);
                ipc = new PointConverter(left, top, scale);
                Point2D ptPixels = null;
                Point2D ptGeo = null;
                int n = bboxCoords.size();
                for (j = 0; j < n; ++j) {
                    ptGeo = bboxCoords.get(j);
                    ptPixels = ipc.GeoToPixels(ptGeo);
                    x = ptPixels.getX();
                    y = ptPixels.getY();
                    if (x < 20.0) {
                        x = 20.0;
                    }
                    if (y < 20.0) {
                        y = 20.0;
                    }
                    ptPixels.setLocation(x, y);
                    bboxCoords.set(j, ptPixels);
                }
            } else {
                bounds = bbox.split(",");
                left = Double.valueOf(bounds[0]);
                right = Double.valueOf(bounds[2]);
                top = Double.valueOf(bounds[3]);
                bottom = Double.valueOf(bounds[1]);
                scale = MultiPointHandler.getReasonableScale(bbox, scale);
                ipc = new PointConverter(left, top, scale);
            }
            Point2D.Double pt2d = null;
            if (bboxCoords == null) {
                pt2d = new Point2D.Double(left, top);
                temp = ipc.GeoToPixels((Point2D)pt2d);
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                pt2d = new Point2D.Double(right, bottom);
                temp = ipc.GeoToPixels((Point2D)pt2d);
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = new Rectangle(leftX, topY, width, height);
            }
        } else {
            rect = null;
        }
        if (ipc == null) {
            Point2D ptCoordsUL = MultiPointHandler.getGeoUL(geoCoords);
            ipc = new PointConverter(ptCoordsUL.getX(), ptCoordsUL.getY(), scale);
        }
        ArrayList<Point2D.Double> geoCoords2 = new ArrayList<Point2D.Double>();
        geoCoords2.add(new Point2D.Double(left, top));
        geoCoords2.add(new Point2D.Double(right, bottom));
        if (!MultiPointHandler.ShouldClipSymbol(symbolCode).booleanValue() && !MultiPointHandler.crossesIDL(geoCoords)) {
            rect = null;
            bboxCoords = null;
        }
        tgl.set_SymbolId(symbolCode);
        tgl.set_Pixels(null);
        try {
            Object textColor;
            MilStdSymbol mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            if (format == 3) {
                symbolAttributes.put("USEDASHARRAY", "true");
                symbolAttributes.put("USEPATTERNFILL", "true");
            }
            if (symbolModifiers != null || symbolAttributes != null) {
                MultiPointHandler.populateModifiers(symbolModifiers, symbolAttributes, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            if (bboxCoords == null) {
                Rectangle clipBounds = MultiPointHandler.getOverscanClipBounds(rect, ipc);
                clsRenderer.renderWithPolylines(mSymbol, ipc, clipBounds);
            } else {
                clsRenderer.renderWithPolylines(mSymbol, ipc, bboxCoords);
            }
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            if (format == 1) {
                jsonOutput.append("{\"type\":\"symbol\",");
                jsonContent = MultiPointHandler.JSONize(shapes, modifiers, ipc, true, normalize);
                jsonOutput.append(jsonContent);
                jsonOutput.append("}");
            } else if (format == 0) {
                textColor = mSymbol.getTextColor();
                if (textColor == null) {
                    textColor = mSymbol.getLineColor();
                }
                jsonContent = MultiPointHandler.KMLize(id, name, description, symbolCode, shapes, modifiers, ipc, normalize, (Color)textColor, mSymbol.getWasClipped(), mSymbol.isTextScaleSensitive(), mSymbol.isSymbolScaleSensitive());
                jsonOutput.append(jsonContent);
            } else if (format == 2) {
                jsonOutput.append("{\"type\":\"FeatureCollection\",\"features\":");
                jsonContent = MultiPointHandler.GeoJSONize(shapes, modifiers, ipc, normalize, mSymbol.getTextColor(), mSymbol.getTextBackgroundColor());
                jsonOutput.append(jsonContent);
                jsonOutput.replace(jsonOutput.toString().length() - 1, jsonOutput.toString().length(), "");
                if (jsonContent.length() > 2) {
                    jsonOutput.append(",");
                }
                jsonOutput.append("{\"type\": \"Feature\",\"geometry\": { \"type\": \"Polygon\",\"coordinates\": [ ]}");
                jsonOutput.append(",\"properties\":{\"id\":\"");
                jsonOutput.append(id);
                jsonOutput.append("\",\"name\":\"");
                jsonOutput.append(name);
                jsonOutput.append("\",\"description\":\"");
                jsonOutput.append(description);
                jsonOutput.append("\",\"symbolID\":\"");
                jsonOutput.append(symbolCode);
                jsonOutput.append("\",\"wasClipped\":\"");
                jsonOutput.append(String.valueOf(mSymbol.getWasClipped()));
                jsonOutput.append("\",\"textScaleSensitive\":\"");
                jsonOutput.append(String.valueOf(mSymbol.isTextScaleSensitive()));
                jsonOutput.append("\",\"symbolScaleSensitive\":\"");
                jsonOutput.append(String.valueOf(mSymbol.isSymbolScaleSensitive()));
                jsonOutput.append("\"}}]}");
            } else if (format == 3) {
                textColor = mSymbol.getTextColor() != null ? RendererUtilities.colorToHexString(mSymbol.getTextColor(), false) : "";
                String backgroundColor = mSymbol.getTextBackgroundColor() != null ? RendererUtilities.colorToHexString(mSymbol.getTextBackgroundColor(), false) : "";
                jsonContent = MultiPointHandlerSVG.GeoSVGize(id, name, description, symbolCode, shapes, modifiers, ipc, normalize, (String)textColor, backgroundColor, mSymbol.get_WasClipped());
                jsonOutput.append(jsonContent);
            }
        }
        catch (Exception exc) {
            String st = JavaRendererUtilities.getStackTrace(exc);
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ");
            jsonOutput.append(exc.getMessage() + " - ");
            jsonOutput.append(st);
            jsonOutput.append("\"}");
            ErrorLogger.LogException("MultiPointHandler", "RenderSymbol", exc);
        }
        boolean debug = false;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("Scale: " + scale);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (tgl != null && tgl.get_Pixels() != null) {
                System.out.println("Pixel: " + tgl.get_Pixels().toString());
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        ErrorLogger.LogMessage("MultiPointHandler", "RenderSymbol()", "exit RenderSymbol", Level.FINER);
        return jsonOutput.toString();
    }

    public static MilStdSymbol RenderSymbolAsMilStdSymbol(String id, String name, String description, String symbolCode, String controlPoints, Double scale, String bbox, Map<String, String> symbolModifiers, Map<String, String> symbolAttributes) {
        MilStdSymbol mSymbol = null;
        boolean normalize = true;
        Double controlLat = 0.0;
        Double controlLong = 0.0;
        Rectangle rect = null;
        Object tgPoints = null;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList<ShapeInfo> shapes = null;
        ArrayList<ShapeInfo> modifiers = null;
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        int len = coordinates.length;
        PointConverter ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        Point2D temp = null;
        Point2D ptGeoUL = null;
        int width = 0;
        int height = 0;
        int leftX = 0;
        int topY = 0;
        int bottomY = 0;
        int rightX = 0;
        int j = 0;
        ArrayList<Point2D> bboxCoords = null;
        if (bbox != null && !bbox.equals("")) {
            String[] bounds = null;
            if (bbox.contains(" ")) {
                String[] coords;
                bboxCoords = new ArrayList<Point2D>();
                double x = 0.0;
                double y = 0.0;
                for (String coord : coords = bbox.split(" ")) {
                    String[] arrCoord = coord.split(",");
                    x = Double.valueOf(arrCoord[0]);
                    y = Double.valueOf(arrCoord[1]);
                    bboxCoords.add(new Point2D.Double(x, y));
                }
                ptGeoUL = MultiPointHandler.getGeoUL(bboxCoords);
                left = ptGeoUL.getX();
                top = ptGeoUL.getY();
                ipc = new PointConverter(left, top, scale);
                Point2D ptPixels = null;
                Point2D ptGeo = null;
                int n = bboxCoords.size();
                for (j = 0; j < n; ++j) {
                    ptGeo = bboxCoords.get(j);
                    ptPixels = ipc.GeoToPixels(ptGeo);
                    x = ptPixels.getX();
                    y = ptPixels.getY();
                    if (x < 20.0) {
                        x = 20.0;
                    }
                    if (y < 20.0) {
                        y = 20.0;
                    }
                    ptPixels.setLocation(x, y);
                    bboxCoords.set(j, ptPixels);
                }
            } else {
                bounds = bbox.split(",");
                left = Double.valueOf(bounds[0]);
                right = Double.valueOf(bounds[2]);
                top = Double.valueOf(bounds[3]);
                bottom = Double.valueOf(bounds[1]);
                scale = MultiPointHandler.getReasonableScale(bbox, scale);
                ipc = new PointConverter(left, top, scale);
            }
            Point2D.Double pt2d = null;
            if (bboxCoords == null) {
                pt2d = new Point2D.Double(left, top);
                temp = ipc.GeoToPixels((Point2D)pt2d);
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                pt2d = new Point2D.Double(right, bottom);
                temp = ipc.GeoToPixels((Point2D)pt2d);
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = width == 0 || height == 0 ? null : new Rectangle(leftX, topY, width, height);
            }
        } else {
            rect = null;
        }
        String symbolIsValid = MultiPointHandler.canRenderMultiPoint(symbolCode, symbolModifiers, len);
        if (!symbolIsValid.equals("true")) {
            ErrorLogger.LogMessage("MultiPointHandler", "RenderSymbolAsMilStdSymbol", symbolIsValid, Level.WARNING);
            return mSymbol;
        }
        if (MSLookup.getInstance().getMSLInfo(symbolCode).getDrawRule() != 110) {
            len = Math.min(len, MSLookup.getInstance().getMSLInfo(symbolCode).getMaxPointCount());
        }
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            Double latitude = Double.valueOf(coordPair[1].trim());
            Double longitude = Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        if (ipc == null) {
            Point2D ptCoordsUL = MultiPointHandler.getGeoUL(geoCoords);
            ipc = new PointConverter(ptCoordsUL.getX(), ptCoordsUL.getY(), scale);
        }
        ArrayList<Point2D.Double> geoCoords2 = new ArrayList<Point2D.Double>();
        geoCoords2.add(new Point2D.Double(left, top));
        geoCoords2.add(new Point2D.Double(right, bottom));
        if (!MultiPointHandler.ShouldClipSymbol(symbolCode).booleanValue() && !MultiPointHandler.crossesIDL(geoCoords)) {
            rect = null;
            bboxCoords = null;
        }
        tgl.set_SymbolId(symbolCode);
        tgl.set_Pixels(null);
        try {
            String fillColor = null;
            mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            if (symbolModifiers != null || symbolAttributes != null) {
                MultiPointHandler.populateModifiers(symbolModifiers, symbolAttributes, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            if (mSymbol.getFillColor() != null) {
                Color fc = mSymbol.getFillColor();
                fillColor = Integer.toHexString(fc.getRGB());
            }
            if (bboxCoords == null) {
                Rectangle clipBounds = MultiPointHandler.getOverscanClipBounds(rect, ipc);
                clsRenderer.renderWithPolylines(mSymbol, ipc, clipBounds);
            } else {
                clsRenderer.renderWithPolylines(mSymbol, ipc, bboxCoords);
            }
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            ArrayList<ArrayList<Point2D>> polylines = null;
            ArrayList<ArrayList<Point2D>> newPolylines = null;
            Object newLine = null;
            for (ShapeInfo shape : shapes) {
                polylines = shape.getPolylines();
                newPolylines = MultiPointHandler.ConvertPolylinePixelsToCoords(polylines, ipc, normalize);
                shape.setPolylines(newPolylines);
            }
            for (ShapeInfo label : modifiers) {
                Point2D pixelCoord = label.getModifierPosition();
                if (pixelCoord == null) {
                    pixelCoord = label.getGlyphPosition();
                }
                Point2D geoCoord = ipc.PixelsToGeo(pixelCoord);
                if (normalize) {
                    geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                }
                double latitude = geoCoord.getY();
                double longitude = geoCoord.getX();
                label.setModifierPosition(new Point2D.Double(longitude, latitude));
            }
            mSymbol.setModifierShapes(modifiers);
            mSymbol.setSymbolShapes(shapes);
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            System.out.println("Symbol Code: " + symbolCode);
            exc.printStackTrace();
        }
        boolean debug = false;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("Scale: " + scale);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (tgl != null && tgl.get_Pixels() != null) {
                System.out.println("Pixel: " + tgl.get_Pixels().toString());
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
        }
        return mSymbol;
    }

    private static ArrayList<ArrayList<Point2D>> ConvertPolylinePixelsToCoords(ArrayList<ArrayList<Point2D>> polylines, IPointConversion ipc, Boolean normalize) {
        ArrayList<ArrayList<Point2D>> newPolylines = new ArrayList<ArrayList<Point2D>>();
        double latitude = 0.0;
        double longitude = 0.0;
        ArrayList<Point2D.Double> newLine = null;
        try {
            for (ArrayList<Point2D> line : polylines) {
                newLine = new ArrayList<Point2D.Double>();
                for (Point2D pt : line) {
                    Point2D geoCoord = ipc.PixelsToGeo(pt);
                    if (normalize.booleanValue()) {
                        geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                    }
                    latitude = geoCoord.getY();
                    longitude = geoCoord.getX();
                    newLine.add(new Point2D.Double(longitude, latitude));
                }
                newPolylines.add(newLine);
            }
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        return newPolylines;
    }

    public static String RenderSymbol2D(String id, String name, String description, String symbolCode, String controlPoints, int pixelWidth, int pixelHeight, String bbox, Map<String, String> symbolModifiers, Map<String, String> symbolAttributes, int format) {
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Rectangle rect = null;
        Object tgPoints = null;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList<ShapeInfo> shapes = new ArrayList();
        ArrayList<ShapeInfo> modifiers = new ArrayList();
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        int len = coordinates.length;
        PointConversion ipc = null;
        String symbolIsValid = MultiPointHandler.canRenderMultiPoint(symbolCode, symbolModifiers, len);
        if (!symbolIsValid.equals("true")) {
            String ErrorOutput = "";
            ErrorOutput = ErrorOutput + "{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + " - ID: " + id + " - ";
            ErrorOutput = ErrorOutput + symbolIsValid;
            ErrorOutput = ErrorOutput + "\"}";
            ErrorLogger.LogMessage("MultiPointHandler", "RenderSymbol2D", symbolIsValid, Level.WARNING);
            return ErrorOutput;
        }
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        if (bbox == null || bbox.equals("")) {
            System.out.println("Bad bbox value: " + bbox);
            System.out.println("bbox is viewable area of the map.  Passed in the format of a string \"lowerLeftX,lowerLeftY,upperRightX,upperRightY.\" example: \"-50.4,23.6,-42.2,24.2\"");
            return "ERROR - Bad bbox value: " + bbox;
        }
        String[] bounds = bbox.split(",");
        left = (double)Double.valueOf(bounds[0]);
        right = (double)Double.valueOf(bounds[2]);
        top = (double)Double.valueOf(bounds[3]);
        bottom = (double)Double.valueOf(bounds[1]);
        ipc = new PointConversion(pixelWidth, pixelHeight, top, left, bottom, right);
        if (MSLookup.getInstance().getMSLInfo(symbolCode).getDrawRule() != 110) {
            len = Math.min(len, MSLookup.getInstance().getMSLInfo(symbolCode).getMaxPointCount());
        }
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            Double latitude = (double)Double.valueOf(coordPair[1].trim());
            Double longitude = (double)Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        try {
            Object textColor;
            MilStdSymbol mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            if (format == 3) {
                symbolAttributes.put("USEDASHARRAY", "true");
                symbolAttributes.put("USEPATTERNFILL", "true");
            }
            if (symbolModifiers != null && !symbolModifiers.equals("")) {
                MultiPointHandler.populateModifiers(symbolModifiers, symbolAttributes, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            Point2D temp = null;
            boolean normalize = false;
            if (MultiPointHandler.ShouldClipSymbol(symbolCode).booleanValue() || MultiPointHandler.crossesIDL(geoCoords)) {
                Point2D.Double lt = new Point2D.Double(left, top);
                temp = ipc.GeoToPixels((Point2D)lt);
                int leftX = (int)temp.getX();
                int topY = (int)temp.getY();
                Point2D.Double rb = new Point2D.Double(right, bottom);
                temp = ipc.GeoToPixels((Point2D)rb);
                int bottomY = (int)temp.getY();
                int rightX = (int)temp.getX();
                int width = Math.abs(rightX - leftX);
                int height = Math.abs(bottomY - topY);
                rect = new Rectangle(leftX, topY, width, height);
            }
            Rectangle clipBounds = MultiPointHandler.getOverscanClipBounds(rect, ipc);
            clsRenderer.renderWithPolylines(mSymbol, ipc, clipBounds);
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            if (format == 1) {
                jsonOutput.append("{\"type\":\"symbol\",");
                jsonOutput.append(jsonContent);
                jsonOutput.append("}");
            } else if (format == 0) {
                textColor = mSymbol.getTextColor();
                if (textColor == null) {
                    textColor = mSymbol.getLineColor();
                }
                jsonContent = MultiPointHandler.KMLize(id, name, description, symbolCode, shapes, modifiers, ipc, normalize, (Color)textColor, mSymbol.getWasClipped(), mSymbol.isTextScaleSensitive(), mSymbol.isSymbolScaleSensitive());
                jsonOutput.append(jsonContent);
            } else if (format == 2) {
                jsonOutput.append("{\"type\":\"FeatureCollection\",\"features\":");
                jsonContent = MultiPointHandler.GeoJSONize(shapes, modifiers, ipc, normalize, mSymbol.getTextColor(), mSymbol.getTextBackgroundColor());
                jsonOutput.append(jsonContent);
                jsonOutput.replace(jsonOutput.toString().length() - 1, jsonOutput.toString().length(), "");
                if (jsonContent.length() > 2) {
                    jsonOutput.append(",");
                }
                jsonOutput.append("{\"type\": \"Feature\",\"geometry\": { \"type\": \"Polygon\",\"coordinates\": [ ]}");
                jsonOutput.append(",\"properties\":{\"id\":\"");
                jsonOutput.append(id);
                jsonOutput.append("\",\"name\":\"");
                jsonOutput.append(name);
                jsonOutput.append("\",\"description\":\"");
                jsonOutput.append(description);
                jsonOutput.append("\",\"symbolID\":\"");
                jsonOutput.append(symbolCode);
                jsonOutput.append("\",\"wasClipped\":\"");
                jsonOutput.append(String.valueOf(mSymbol.getWasClipped()));
                jsonOutput.append("\",\"textScaleSensitive\":\"");
                jsonOutput.append(String.valueOf(mSymbol.isTextScaleSensitive()));
                jsonOutput.append("\",\"symbolScaleSensitive\":\"");
                jsonOutput.append(String.valueOf(mSymbol.isSymbolScaleSensitive()));
                jsonOutput.append("\"}}]}");
            } else if (format == 3) {
                textColor = mSymbol.getTextColor() != null ? RendererUtilities.colorToHexString(mSymbol.getTextColor(), false) : "";
                String backgroundColor = mSymbol.getTextBackgroundColor() != null ? RendererUtilities.colorToHexString(mSymbol.getTextBackgroundColor(), false) : "";
                jsonContent = MultiPointHandlerSVG.GeoSVGize(id, name, description, symbolCode, shapes, modifiers, ipc, normalize, (String)textColor, backgroundColor, mSymbol.get_WasClipped());
                jsonOutput.append(jsonContent);
            }
        }
        catch (Exception exc) {
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ");
            jsonOutput.append(exc.getMessage() + " - ");
            jsonOutput.append(ErrorLogger.getStackTrace(exc));
            jsonOutput.append("\"}");
        }
        boolean debug = false;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (tgl != null && tgl.get_Pixels() != null) {
                System.out.println("Pixel: " + tgl.get_Pixels().toString());
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        return jsonOutput.toString();
    }

    static Rectangle getOverscanClipBounds(Rectangle rect, IPointConversion ipc) {
        if (rect == null) {
            return null;
        }
        double maxWidth = Math.abs(ipc.GeoToPixels(new Point2D.Double(180.0, 0.0)).getX() - ipc.GeoToPixels(new Point2D.Double(0.0, 0.0)).getX());
        double maxHeight = Math.abs(ipc.GeoToPixels(new Point2D.Double(0.0, 90.0)).getY() - ipc.GeoToPixels(new Point2D.Double(0.0, -90.0)).getY());
        double overScanScale = RendererSettings.getInstance().getOverscanScale();
        if ((double)rect.width * overScanScale > maxWidth) {
            overScanScale = maxWidth / (double)rect.width;
        }
        if ((double)rect.height * overScanScale > maxHeight) {
            overScanScale = maxHeight / (double)rect.height;
        }
        return new Rectangle((int)((double)rect.x - (double)rect.width * (overScanScale - 1.0) / 2.0), (int)((double)rect.y - (double)rect.height * (overScanScale - 1.0) / 2.0), (int)((double)rect.width * overScanScale), (int)((double)rect.height * overScanScale));
    }

    public static String RenderSymbol2DX(String id, String name, String description, String symbolCode, String controlPoints, int pixelWidth, int pixelHeight, String bbox, HashMap<String, String> symbolModifiers, HashMap<String, String> symbolAttributes, ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, int format) {
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Rectangle rect = null;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        PointConversion ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        if (bbox == null || bbox.equals("")) {
            System.out.println("Bad bbox value: " + bbox);
            System.out.println("bbox is viewable area of the map.  Passed in the format of a string \"lowerLeftX,lowerLeftY,upperRightX,upperRightY.\" example: \"-50.4,23.6,-42.2,24.2\"");
            return "ERROR - Bad bbox value: " + bbox;
        }
        String[] bounds = bbox.split(",");
        left = (double)Double.valueOf(bounds[0]);
        right = (double)Double.valueOf(bounds[2]);
        top = (double)Double.valueOf(bounds[3]);
        bottom = (double)Double.valueOf(bounds[1]);
        ipc = new PointConversion(pixelWidth, pixelHeight, top, left, bottom, right);
        int len = coordinates.length;
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            Double latitude = (double)Double.valueOf(coordPair[1].trim());
            Double longitude = (double)Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        try {
            MilStdSymbol mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            if (symbolModifiers != null && !symbolModifiers.equals("")) {
                MultiPointHandler.populateModifiers(symbolModifiers, symbolAttributes, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            clsRenderer.renderWithPolylines(mSymbol, ipc, rect);
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            boolean normalize = false;
            if (format == 1) {
                jsonOutput.append("{\"type\":\"symbol\",");
                jsonContent = MultiPointHandler.JSONize(shapes, modifiers, ipc, false, normalize);
                jsonOutput.append(jsonContent);
                jsonOutput.append("}");
            }
        }
        catch (Exception exc) {
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ");
            jsonOutput.append(exc.getMessage() + " - ");
            jsonOutput.append("\"}");
        }
        boolean debug = true;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (tgl != null && tgl.get_Pixels() != null) {
                System.out.println("Pixel: " + tgl.get_Pixels().toString());
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        return jsonOutput.toString();
    }

    private static SymbolInfo MilStdSymbolToSymbolInfo(MilStdSymbol symbol) {
        SymbolInfo si = null;
        ArrayList<TextInfo> tiList = new ArrayList<TextInfo>();
        ArrayList<LineInfo> liList = new ArrayList<LineInfo>();
        TextInfo tiTemp = null;
        LineInfo liTemp = null;
        ShapeInfo siTemp = null;
        ArrayList<ShapeInfo> lines = symbol.getSymbolShapes();
        ArrayList<ShapeInfo> modifiers = symbol.getModifierShapes();
        int lineCount = lines.size();
        int modifierCount = modifiers.size();
        for (int i = 0; i < lineCount; ++i) {
            siTemp = lines.get(i);
            if (siTemp.getPolylines() == null) continue;
            liTemp = new LineInfo();
            liTemp.setFillColor(siTemp.getFillColor());
            liTemp.setLineColor(siTemp.getLineColor());
            liTemp.setPolylines(siTemp.getPolylines());
            liTemp.setStroke(siTemp.getStroke());
            liList.add(liTemp);
        }
        for (int j = 0; j < modifierCount; ++j) {
            tiTemp = new TextInfo();
            siTemp = modifiers.get(j);
            if (siTemp.getModifierString() == null) continue;
            tiTemp.setModifierString(siTemp.getModifierString());
            tiTemp.setModifierStringPosition(siTemp.getModifierPosition());
            tiTemp.setModifierStringAngle(siTemp.getModifierAngle());
            tiList.add(tiTemp);
        }
        si = new SymbolInfo(tiList, liList);
        return si;
    }

    static boolean populateModifiers(Map<String, String> saModifiers, Map<String, String> saAttributes, MilStdSymbol symbol) {
        HashMap<String, String> modifiers = new HashMap<String, String>();
        Map<String, String> attributes = saAttributes;
        ArrayList<Double> altitudes = null;
        ArrayList<Double> azimuths = null;
        ArrayList<Double> distances = null;
        String fillColor = null;
        String lineColor = null;
        String textColor = null;
        String textBackgroundColor = null;
        int lineWidth = 0;
        String altMode = null;
        boolean useDashArray = symbol.getUseDashArray();
        boolean usePatternFill = symbol.getUseFillPattern();
        int patternFillType = 0;
        boolean hideOptionalLabels = false;
        DistanceUnit distanceUnit = null;
        DistanceUnit altitudeUnit = null;
        int pixelSize = 50;
        boolean keepUnitRatio = true;
        double patternScale = RendererSettings.getInstance().getPatternScale();
        try {
            if (saModifiers != null) {
                if (saModifiers.containsKey("C_QUANTITY")) {
                    modifiers.put("C_QUANTITY", String.valueOf(saModifiers.get("C_QUANTITY")));
                }
                if (saModifiers.containsKey("H_ADDITIONAL_INFO_1")) {
                    modifiers.put("H_ADDITIONAL_INFO_1", String.valueOf(saModifiers.get("H_ADDITIONAL_INFO_1")));
                }
                if (saModifiers.containsKey("H1_ADDITIONAL_INFO_2")) {
                    modifiers.put("H1_ADDITIONAL_INFO_2", String.valueOf(saModifiers.get("H1_ADDITIONAL_INFO_2")));
                }
                if (saModifiers.containsKey("H2_ADDITIONAL_INFO_3")) {
                    modifiers.put("H2_ADDITIONAL_INFO_3", String.valueOf(saModifiers.get("H2_ADDITIONAL_INFO_3")));
                }
                if (saModifiers.containsKey("N_HOSTILE")) {
                    if (saModifiers.get("N_HOSTILE") == null) {
                        modifiers.put("N_HOSTILE", "");
                    } else {
                        modifiers.put("N_HOSTILE", String.valueOf(saModifiers.get("N_HOSTILE")));
                    }
                }
                if (saModifiers.containsKey("Q_DIRECTION_OF_MOVEMENT")) {
                    modifiers.put("Q_DIRECTION_OF_MOVEMENT", String.valueOf(saModifiers.get("Q_DIRECTION_OF_MOVEMENT")));
                }
                if (saModifiers.containsKey("T_UNIQUE_DESIGNATION_1")) {
                    modifiers.put("T_UNIQUE_DESIGNATION_1", String.valueOf(saModifiers.get("T_UNIQUE_DESIGNATION_1")));
                }
                if (saModifiers.containsKey("T1_UNIQUE_DESIGNATION_2")) {
                    modifiers.put("T1_UNIQUE_DESIGNATION_2", String.valueOf(saModifiers.get("T1_UNIQUE_DESIGNATION_2")));
                }
                if (saModifiers.containsKey("V_EQUIP_TYPE")) {
                    modifiers.put("V_EQUIP_TYPE", String.valueOf(saModifiers.get("V_EQUIP_TYPE")));
                }
                if (saModifiers.containsKey("AS_COUNTRY")) {
                    modifiers.put("AS_COUNTRY", String.valueOf(saModifiers.get("AS_COUNTRY")));
                } else if (SymbolID.getCountryCode(symbol.getSymbolID()) > 0 && !GENCLookup.getInstance().get3CharCode(SymbolID.getCountryCode(symbol.getSymbolID())).equals("")) {
                    modifiers.put("AS_COUNTRY", GENCLookup.getInstance().get3CharCode(SymbolID.getCountryCode(symbol.getSymbolID())));
                }
                if (saModifiers.containsKey("AP_TARGET_NUMBER")) {
                    modifiers.put("AP_TARGET_NUMBER", String.valueOf(saModifiers.get("AP_TARGET_NUMBER")));
                }
                if (saModifiers.containsKey("W_DTG_1")) {
                    modifiers.put("W_DTG_1", String.valueOf(saModifiers.get("W_DTG_1")));
                }
                if (saModifiers.containsKey("W1_DTG_2")) {
                    modifiers.put("W1_DTG_2", String.valueOf(saModifiers.get("W1_DTG_2")));
                }
                if (saModifiers.containsKey("Y_LOCATION")) {
                    modifiers.put("Y_LOCATION", String.valueOf(saModifiers.get("Y_LOCATION")));
                }
                if (saModifiers.containsKey("X_ALTITUDE_DEPTH")) {
                    String[] arrAltitudes;
                    altitudes = new ArrayList<Double>();
                    for (String x : arrAltitudes = String.valueOf(saModifiers.get("X_ALTITUDE_DEPTH")).split(",")) {
                        if (x.equals("")) continue;
                        altitudes.add(Double.parseDouble(x));
                    }
                }
                if (saModifiers.containsKey("AM_DISTANCE")) {
                    String[] arrDistances;
                    distances = new ArrayList<Double>();
                    for (String am : arrDistances = String.valueOf(saModifiers.get("AM_DISTANCE")).split(",")) {
                        if (am.equals("")) continue;
                        distances.add(Double.parseDouble(am));
                    }
                }
                if (saModifiers.containsKey("AN_AZIMUTH")) {
                    String[] arrAzimuths;
                    azimuths = new ArrayList<Double>();
                    for (String an : arrAzimuths = String.valueOf(saModifiers.get("AN_AZIMUTH")).split(",")) {
                        if (an.equals("")) continue;
                        azimuths.add(Double.parseDouble(an));
                    }
                }
            }
            if (saAttributes != null) {
                if (saAttributes.containsKey("FILLCOLOR")) {
                    fillColor = saAttributes.get("FILLCOLOR");
                }
                if (saAttributes.containsKey("LINECOLOR")) {
                    lineColor = saAttributes.get("LINECOLOR");
                }
                if (saAttributes.containsKey("LINEWIDTH")) {
                    lineWidth = Integer.parseInt(saAttributes.get("LINEWIDTH"));
                }
                if (saAttributes.containsKey("TEXTCOLOR")) {
                    textColor = saAttributes.get("TEXTCOLOR");
                }
                if (saAttributes.containsKey("TEXTBACKGROUNDCOLOR")) {
                    textBackgroundColor = saAttributes.get("TEXTBACKGROUNDCOLOR");
                }
                if (saAttributes.containsKey("ALTITUDEMODE")) {
                    altMode = saAttributes.get("ALTITUDEMODE");
                }
                if (saAttributes.containsKey("USEDASHARRAY")) {
                    useDashArray = Boolean.parseBoolean(saAttributes.get("USEDASHARRAY"));
                }
                if (saAttributes.containsKey("USEPATTERNFILL")) {
                    usePatternFill = Boolean.parseBoolean(saAttributes.get("USEPATTERNFILL"));
                }
                if (saAttributes.containsKey("PATTERNFILLTYPE")) {
                    patternFillType = Integer.parseInt(saAttributes.get("PATTERNFILLTYPE"));
                }
                if (saAttributes.containsKey("HIDEOPTIONALLABELS")) {
                    hideOptionalLabels = Boolean.parseBoolean(saAttributes.get("HIDEOPTIONALLABELS"));
                }
                if (saAttributes.containsKey("ALTITUDEUNITS")) {
                    altitudeUnit = DistanceUnit.parse(saAttributes.get("ALTITUDEUNITS"));
                }
                if (saAttributes.containsKey("DISTANCEUNITS")) {
                    distanceUnit = DistanceUnit.parse(saAttributes.get("DISTANCEUNITS"));
                }
                if (saAttributes.containsKey("PIXELSIZE")) {
                    pixelSize = Integer.parseInt(saAttributes.get("PIXELSIZE"));
                    symbol.setUnitSize(pixelSize);
                }
                if (saAttributes.containsKey("KEEPUNITRATIO")) {
                    keepUnitRatio = Boolean.parseBoolean(saAttributes.get("KEEPUNITRATIO"));
                    symbol.setKeepUnitRatio(keepUnitRatio);
                }
                if (saAttributes.containsKey("PATTERNSCALE")) {
                    patternScale = Double.parseDouble(saAttributes.get("PATTERNSCALE"));
                }
            }
            symbol.setModifierMap(modifiers);
            if (fillColor != null && !fillColor.equals("")) {
                symbol.setFillColor(RendererUtilities.getColorFromHexString(fillColor));
            }
            if (lineColor != null && !lineColor.equals("")) {
                symbol.setLineColor(RendererUtilities.getColorFromHexString(lineColor));
                symbol.setTextColor(RendererUtilities.getColorFromHexString(lineColor));
            } else if (symbol.getLineColor() == null) {
                symbol.setLineColor(Color.black);
            }
            if (lineWidth > 0) {
                symbol.setLineWidth(lineWidth);
            }
            if (textColor != null && !textColor.equals("")) {
                symbol.setTextColor(RendererUtilities.getColorFromHexString(textColor));
            } else if (symbol.getTextColor() == null) {
                symbol.setTextColor(Color.black);
            }
            if (textBackgroundColor != null && !textBackgroundColor.equals("")) {
                symbol.setTextBackgroundColor(RendererUtilities.getColorFromHexString(textBackgroundColor));
            }
            if (altMode != null) {
                symbol.setAltitudeMode(altMode);
            }
            symbol.setUseDashArray(useDashArray);
            symbol.setUseFillPattern(usePatternFill);
            symbol.setHideOptionalLabels(hideOptionalLabels);
            symbol.setAltitudeUnit(altitudeUnit);
            symbol.setDistanceUnit(distanceUnit);
            symbol.setPatternScale(patternScale);
            if (altitudes != null) {
                symbol.setModifiers_AM_AN_X("X_ALTITUDE_DEPTH", altitudes);
            }
            if (distances != null) {
                symbol.setModifiers_AM_AN_X("AM_DISTANCE", distances);
            }
            if (azimuths != null) {
                symbol.setModifiers_AM_AN_X("AN_AZIMUTH", azimuths);
            }
            if (SymbolUtilities.getBasicSymbolID(symbol.getSymbolID()).equals("25242200") && symbol.getModifiers_AM_AN_X("AN_AZIMUTH") != null && symbol.getModifiers_AM_AN_X("AM_DISTANCE") != null) {
                int anCount = symbol.getModifiers_AM_AN_X("AN_AZIMUTH").size();
                int amCount = symbol.getModifiers_AM_AN_X("AM_DISTANCE").size();
                ArrayList<Double> am = null;
                if (amCount < anCount / 2 + 1 && (am = symbol.getModifiers_AM_AN_X("AM_DISTANCE")).get(0) != 0.0) {
                    am.add(0, 0.0);
                }
            }
        }
        catch (Exception exc2) {
            ErrorLogger.LogException("MultiPointHandler", "PopulateModifiers", exc2);
        }
        return true;
    }

    private static String KMLize(String id, String name, String description, String symbolCode, ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, boolean normalize, Color textColor, boolean wasClipped, int textScaleSensitive, int symbolScaleSensitive) {
        StringBuilder kml = new StringBuilder();
        ShapeInfo tempModifier = null;
        String cdataStart = "<![CDATA[";
        String cdataEnd = "]]>";
        int len = shapes.size();
        kml.append("<Folder id=\"").append(id).append("\">");
        kml.append("<name>").append(cdataStart).append(name).append(cdataEnd).append("</name>");
        kml.append("<visibility>1</visibility>");
        kml.append("<description>").append(cdataStart).append(description).append(cdataEnd).append("</description>");
        kml.append("<ExtendedData>");
        kml.append("<Data name=\"symbolID\"><value>").append(symbolCode).append("</value></Data>");
        kml.append("<Data name=\"wasClipped\"><value>").append(wasClipped).append("</value></Data>");
        kml.append("<Data name=\"textScaleSensitive\"><value>").append(textScaleSensitive).append("</value></Data>");
        kml.append("<Data name=\"symbolScaleSensitive\"><value>").append(symbolScaleSensitive).append("</value></Data>");
        kml.append("</ExtendedData>");
        for (int i = 0; i < len; ++i) {
            String shapesToAdd = MultiPointHandler.ShapeToKMLString(shapes.get(i), ipc, normalize);
            kml.append(shapesToAdd);
        }
        int len2 = modifiers.size();
        for (int j = 0; j < len2; ++j) {
            tempModifier = modifiers.get(j);
            String labelsToAdd = MultiPointHandler.LabelToKMLString(tempModifier, ipc, normalize, textColor);
            kml.append(labelsToAdd);
        }
        kml.append("</Folder>");
        return kml.toString();
    }

    private static String JSONize(ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, Boolean geMap, boolean normalize) {
        String polygons = "";
        String lines = "";
        String labels = "";
        String jstr = "";
        ShapeInfo tempModifier = null;
        int len = shapes.size();
        for (int i = 0; i < len; ++i) {
            String shapesToAdd;
            if (jstr.length() > 0) {
                jstr = jstr + ",";
            }
            if ((shapesToAdd = MultiPointHandler.ShapeToJSONString(shapes.get(i), ipc, geMap, normalize)).length() <= 0) continue;
            if (shapesToAdd.startsWith("line", 2)) {
                if (lines.length() > 0) {
                    lines = lines + ",";
                }
                lines = lines + shapesToAdd;
                continue;
            }
            if (!shapesToAdd.startsWith("polygon", 2)) continue;
            if (polygons.length() > 0) {
                polygons = polygons + ",";
            }
            polygons = polygons + shapesToAdd;
        }
        jstr = jstr + "\"polygons\": [" + polygons + "],\"lines\": [" + lines + "],";
        int len2 = modifiers.size();
        labels = "";
        for (int j = 0; j < len2; ++j) {
            String labelsToAdd;
            tempModifier = modifiers.get(j);
            if (geMap.booleanValue()) {
                MultiPointHandler.AdjustModifierPointToCenter(tempModifier);
            }
            if ((labelsToAdd = MultiPointHandler.LabelToJSONString(tempModifier, ipc, normalize)).length() <= 0) continue;
            if (labels.length() > 0) {
                labels = labels + ",";
            }
            labels = labels + labelsToAdd;
        }
        jstr = jstr + "\"labels\": [" + labels + "]";
        return jstr;
    }

    static Color getIdealTextBackgroundColor(Color fgColor) {
        try {
            float[] hsbvals = new float[3];
            if (fgColor != null) {
                int nThreshold = RendererSettings.getInstance().getTextBackgroundAutoColorThreshold();
                int bgDelta = (int)((double)fgColor.getRed() * 0.299 + (double)fgColor.getGreen() * 0.587 + (double)fgColor.getBlue() * 0.114);
                return 255 - bgDelta < nThreshold ? new Color(0, 0, 0, fgColor.getAlpha()) : new Color(255, 255, 255, fgColor.getAlpha());
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MultiPointHandler", "getIdealTextBackgroundColor", exc);
        }
        return Color.WHITE;
    }

    private static String LabelToGeoJSONString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize, Color textColor, Color textBackgroundColor) {
        StringBuilder JSONed = new StringBuilder();
        StringBuilder properties = new StringBuilder();
        StringBuilder geometry = new StringBuilder();
        Color outlineColor = SymbolDraw.getIdealTextBackgroundColor(textColor);
        if (textBackgroundColor != null) {
            outlineColor = textBackgroundColor;
        }
        Point2D.Double coord = new Point2D.Double(shapeInfo.getModifierPosition().getX(), shapeInfo.getModifierPosition().getY());
        Point2D geoCoord = ipc.PixelsToGeo(coord);
        if (normalize) {
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
        }
        double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
        double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
        double angle = shapeInfo.getModifierAngle();
        ((Point2D)coord).setLocation(longitude, latitude);
        shapeInfo.setGlyphPosition(coord);
        String text = shapeInfo.getModifierString();
        int justify = shapeInfo.getTextJustify();
        String strJustify = "left";
        if (justify == 0) {
            strJustify = "left";
        } else if (justify == 1) {
            strJustify = "center";
        } else if (justify == 2) {
            strJustify = "right";
        }
        RendererSettings RS = RendererSettings.getInstance();
        if (text != null && !text.equals("")) {
            JSONed.append("{\"type\":\"Feature\",\"properties\":{\"label\":\"");
            JSONed.append(text);
            JSONed.append("\",\"pointRadius\":0,\"fontColor\":\"");
            JSONed.append(RendererUtilities.colorToHexString(textColor, false));
            JSONed.append("\",\"fontSize\":\"");
            JSONed.append(String.valueOf(RS.getMPLabelFont().getSize()) + "pt\"");
            JSONed.append(",\"fontFamily\":\"");
            JSONed.append(RS.getMPLabelFont().getName());
            JSONed.append(", sans-serif");
            if (RS.getMPLabelFont().getStyle() == 1) {
                JSONed.append("\",\"fontWeight\":\"bold\"");
            } else {
                JSONed.append("\",\"fontWeight\":\"normal\"");
            }
        } else {
            return "";
        }
        JSONed.append(",\"labelAlign\":\"");
        JSONed.append(strJustify);
        JSONed.append("\",\"labelBaseline\":\"alphabetic");
        JSONed.append("\",\"labelXOffset\":0");
        JSONed.append(",\"labelYOffset\":0");
        JSONed.append(",\"labelOutlineColor\":\"");
        JSONed.append(RendererUtilities.colorToHexString(outlineColor, false));
        JSONed.append("\",\"labelOutlineWidth\":");
        JSONed.append("4");
        JSONed.append(",\"rotation\":");
        JSONed.append(angle);
        JSONed.append(",\"angle\":");
        JSONed.append(angle);
        JSONed.append("},");
        JSONed.append("\"geometry\":{\"type\":\"Point\",\"coordinates\":[");
        JSONed.append(longitude);
        JSONed.append(",");
        JSONed.append(latitude);
        JSONed.append("]");
        JSONed.append("}}");
        return JSONed.toString();
    }

    private static String ShapeToGeoJSONString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        int i;
        StringBuilder JSONed = new StringBuilder();
        StringBuilder properties = new StringBuilder();
        StringBuilder geometry = new StringBuilder();
        String geometryType = null;
        String sda = null;
        Color lineColor = shapeInfo.getLineColor();
        Color fillColor = shapeInfo.getFillColor();
        geometryType = shapeInfo.getShapeType() == ShapeInfo.SHAPE_TYPE_FILL || fillColor != null || shapeInfo.getPatternFillImage() != null ? "\"Polygon\"" : "\"MultiLineString\"";
        BasicStroke stroke = null;
        stroke = shapeInfo.getStroke();
        int lineWidth = 4;
        if (stroke != null) {
            lineWidth = (int)stroke.getLineWidth();
        }
        properties.append("\"properties\":{");
        properties.append("\"label\":\"\",");
        if (lineColor != null) {
            properties.append("\"strokeColor\":\"" + RendererUtilities.colorToHexString(lineColor, false) + "\",");
            properties.append("\"lineOpacity\":" + String.valueOf((float)lineColor.getAlpha() / 255.0f) + ",");
        }
        if (fillColor != null) {
            properties.append("\"fillColor\":\"" + RendererUtilities.colorToHexString(fillColor, false) + "\",");
            properties.append("\"fillOpacity\":" + String.valueOf((float)fillColor.getAlpha() / 255.0f) + ",");
        }
        if (shapeInfo.getPatternFillImage() != null) {
            properties.append("\"fillPattern\":\"" + MultiPointHandler.bitmapToString(shapeInfo.getPatternFillImage()) + "\",");
        }
        if (stroke.getDashArray() != null) {
            sda = "\"strokeDasharray\":" + Arrays.toString(stroke.getDashArray()) + ",";
            properties.append(sda);
        }
        int lineCap = stroke.getEndCap();
        properties.append("\"lineCap\":" + lineCap + ",");
        String strokeWidth = String.valueOf(lineWidth);
        properties.append("\"strokeWidth\":" + strokeWidth + ",");
        properties.append("\"strokeWeight\":" + strokeWidth + "");
        properties.append("},");
        properties.append("\"style\":{");
        if (lineColor != null) {
            properties.append("\"stroke\":\"" + RendererUtilities.colorToHexString(lineColor, false) + "\",");
            properties.append("\"line-opacity\":" + String.valueOf((float)lineColor.getAlpha() / 255.0f) + ",");
        }
        if (fillColor != null) {
            properties.append("\"fill\":\"" + RendererUtilities.colorToHexString(fillColor, false) + "\",");
            properties.append("\"fill-opacity\":" + String.valueOf((float)fillColor.getAlpha() / 255.0f) + ",");
        }
        if (stroke.getDashArray() != null) {
            float[] da = stroke.getDashArray();
            sda = String.valueOf(da[0]);
            if (da.length > 1) {
                for (i = 1; i < da.length; ++i) {
                    sda = sda + " " + String.valueOf(da[i]);
                }
            }
            sda = "\"stroke-dasharray\":\"" + sda + "\",";
            properties.append(sda);
            sda = null;
        }
        if (lineCap == 2) {
            properties.append("\"stroke-linecap\":\"square\",");
        } else if (lineCap == 1) {
            properties.append("\"stroke-linecap\":\"round\",");
        } else if (lineCap == 0) {
            properties.append("\"stroke-linecap\":\"butt\",");
        }
        strokeWidth = String.valueOf(lineWidth);
        properties.append("\"stroke-width\":" + strokeWidth);
        properties.append("}");
        geometry.append("\"geometry\":{\"type\":");
        geometry.append(geometryType);
        geometry.append(",\"coordinates\":[");
        ArrayList<ArrayList<Point2D>> shapesArray = shapeInfo.getPolylines();
        for (i = 0; i < shapesArray.size(); ++i) {
            ArrayList<Point2D> pointList = shapesArray.get(i);
            normalize = MultiPointHandler.normalizePoints(pointList, ipc);
            geometry.append("[");
            for (int j = 0; j < pointList.size(); ++j) {
                Point2D coord = pointList.get(j);
                Point2D geoCoord = ipc.PixelsToGeo(coord);
                if (normalize) {
                    geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                }
                double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
                double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
                if (normalize && fillColor != null && longitude > 0.0) {
                    longitude -= 360.0;
                }
                coord = new Point2D.Double(longitude, latitude);
                pointList.set(j, coord);
                geometry.append("[");
                geometry.append(longitude);
                geometry.append(",");
                geometry.append(latitude);
                geometry.append("]");
                if (j >= pointList.size() - 1) continue;
                geometry.append(",");
            }
            geometry.append("]");
            if (i >= shapesArray.size() - 1) continue;
            geometry.append(",");
        }
        geometry.append("]}");
        JSONed.append("{\"type\":\"Feature\",");
        JSONed.append(properties.toString());
        JSONed.append(",");
        JSONed.append(geometry.toString());
        JSONed.append("}");
        return JSONed.toString();
    }

    private static String ImageToGeoJSONString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        StringBuilder JSONed = new StringBuilder();
        StringBuilder properties = new StringBuilder();
        StringBuilder geometry = new StringBuilder();
        Point2D.Double coord = new Point2D.Double(shapeInfo.getModifierPosition().getX(), shapeInfo.getModifierPosition().getY());
        Point2D geoCoord = ipc.PixelsToGeo(coord);
        if (normalize) {
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
        }
        double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
        double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
        double angle = shapeInfo.getModifierAngle();
        ((Point2D)coord).setLocation(longitude, latitude);
        shapeInfo.setGlyphPosition(coord);
        BufferedImage image = shapeInfo.getModifierImage();
        RendererSettings RS = RendererSettings.getInstance();
        if (image == null) {
            return "";
        }
        JSONed.append("{\"type\":\"Feature\",\"properties\":{\"image\":\"");
        JSONed.append(MultiPointHandler.bitmapToString(image));
        JSONed.append("\",\"rotation\":");
        JSONed.append(angle);
        JSONed.append(",\"angle\":");
        JSONed.append(angle);
        JSONed.append("},");
        JSONed.append("\"geometry\":{\"type\":\"Point\",\"coordinates\":[");
        JSONed.append(longitude);
        JSONed.append(",");
        JSONed.append(latitude);
        JSONed.append("]");
        JSONed.append("}}");
        return JSONed.toString();
    }

    static String bitmapToString(BufferedImage bitmap) {
        return RendererUtilities.imgToBase64String(bitmap);
    }

    private static String GeoJSONize(ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, boolean normalize, Color textColor, Color textBackgroundColor) {
        String jstr = "";
        ShapeInfo tempModifier = null;
        StringBuilder fc = new StringBuilder();
        fc.append("[");
        int len = shapes.size();
        for (int i = 0; i < len; ++i) {
            String shapesToAdd = MultiPointHandler.ShapeToGeoJSONString(shapes.get(i), ipc, normalize);
            if (shapesToAdd.length() <= 0) continue;
            fc.append(shapesToAdd);
            if (i >= len - 1) continue;
            fc.append(",");
        }
        int len2 = modifiers.size();
        for (int j = 0; j < len2; ++j) {
            tempModifier = modifiers.get(j);
            String modifiersToAdd = null;
            modifiersToAdd = modifiers.get(j).getModifierImage() != null ? MultiPointHandler.ImageToGeoJSONString(tempModifier, ipc, normalize) : MultiPointHandler.LabelToGeoJSONString(tempModifier, ipc, normalize, textColor, textBackgroundColor);
            if (modifiersToAdd.length() <= 0) continue;
            if (fc.length() > 1) {
                fc.append(",");
            }
            fc.append(modifiersToAdd);
        }
        fc.append("]");
        String GeoJSON = fc.toString();
        return GeoJSON;
    }

    private static void MakeWWReady(ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, boolean normalize) {
        ShapeInfo temp = null;
        int len = shapes.size();
        for (int i = 0; i < len; ++i) {
            temp = MultiPointHandler.ShapeToWWReady(shapes.get(i), ipc, normalize);
            shapes.set(i, temp);
        }
        int len2 = modifiers.size();
        ShapeInfo tempModifier = null;
        for (int j = 0; j < len2; ++j) {
            tempModifier = modifiers.get(j);
            tempModifier = MultiPointHandler.LabelToWWReady(tempModifier, ipc, normalize);
            modifiers.set(j, tempModifier);
        }
    }

    private static Boolean normalizePoints(ArrayList<Point2D.Double> shape, IPointConversion ipc) {
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        int n = shape.size();
        for (int j = 0; j < n; ++j) {
            Point2D coord = shape.get(j);
            Point2D geoCoord = ipc.PixelsToGeo(coord);
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
            double latitude = geoCoord.getY();
            double longitude = geoCoord.getX();
            Point2D.Double pt2d = new Point2D.Double(longitude, latitude);
            geoCoords.add(pt2d);
        }
        Boolean normalize = MultiPointHandler.crossesIDL(geoCoords);
        return normalize;
    }

    private static Boolean IsOnePointSymbolCode(String symbolCode) {
        String basicCode = SymbolUtilities.getBasicSymbolID(symbolCode);
        if (symbolCode.equals("CAKE-----------")) {
            return true;
        }
        if (symbolCode.equals("CYLINDER-------")) {
            return true;
        }
        if (symbolCode.equals("RADARC---------")) {
            return true;
        }
        return false;
    }

    private static String ShapeToKMLString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        StringBuilder kml = new StringBuilder();
        Color lineColor = null;
        Color fillColor = null;
        String googleLineColor = null;
        String googleFillColor = null;
        BasicStroke stroke = null;
        int lineWidth = 4;
        kml.append("<Placemark>");
        kml.append("<Style>");
        lineColor = shapeInfo.getLineColor();
        if (lineColor != null) {
            googleLineColor = Integer.toHexString(shapeInfo.getLineColor().getRGB());
            stroke = shapeInfo.getStroke();
            if (stroke != null) {
                lineWidth = (int)stroke.getLineWidth();
            }
            googleLineColor = JavaRendererUtilities.ARGBtoABGR(googleLineColor);
            kml.append("<LineStyle>");
            kml.append("<color>" + googleLineColor + "</color>");
            kml.append("<colorMode>normal</colorMode>");
            kml.append("<width>" + String.valueOf(lineWidth) + "</width>");
            kml.append("</LineStyle>");
        }
        fillColor = shapeInfo.getFillColor();
        BufferedImage fillPattern = shapeInfo.getPatternFillImage();
        if (fillColor != null || fillPattern != null) {
            kml.append("<PolyStyle>");
            if (fillColor != null) {
                googleFillColor = Integer.toHexString(shapeInfo.getFillColor().getRGB());
                googleFillColor = JavaRendererUtilities.ARGBtoABGR(googleFillColor);
                kml.append("<color>" + googleFillColor + "</color>");
                kml.append("<colorMode>normal</colorMode>");
            }
            if (fillPattern != null) {
                kml.append("<shader>" + MultiPointHandler.bitmapToString(fillPattern) + "</shader>");
            }
            kml.append("<fill>1</fill>");
            if (lineColor != null) {
                kml.append("<outline>1</outline>");
            } else {
                kml.append("<outline>0</outline>");
            }
            kml.append("</PolyStyle>");
        }
        kml.append("</Style>");
        ArrayList<ArrayList<Point2D>> shapesArray = shapeInfo.getPolylines();
        int len = shapesArray.size();
        kml.append("<MultiGeometry>");
        for (int i = 0; i < len; ++i) {
            double longitude;
            double latitude;
            Point2D geoCoord;
            Point2D coord;
            int j;
            int n;
            ArrayList<Point2D> shape = shapesArray.get(i);
            normalize = MultiPointHandler.normalizePoints(shape, ipc);
            if (lineColor != null && fillColor == null) {
                kml.append("<LineString>");
                kml.append("<tessellate>1</tessellate>");
                kml.append("<altitudeMode>clampToGround</altitudeMode>");
                kml.append("<coordinates>");
                n = shape.size();
                for (j = 0; j < n; ++j) {
                    coord = shape.get(j);
                    geoCoord = ipc.PixelsToGeo(coord);
                    if (normalize) {
                        geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                    }
                    latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
                    longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
                    kml.append(longitude);
                    kml.append(",");
                    kml.append(latitude);
                    if (j >= shape.size() - 1) continue;
                    kml.append(" ");
                }
                kml.append("</coordinates>");
                kml.append("</LineString>");
            }
            if (fillColor == null) continue;
            if (i == 0) {
                kml.append("<Polygon>");
            }
            if (i == 1 && len > 1) {
                kml.append("<innerBoundaryIs>");
            } else {
                kml.append("<outerBoundaryIs>");
            }
            kml.append("<LinearRing>");
            kml.append("<altitudeMode>clampToGround</altitudeMode>");
            kml.append("<tessellate>1</tessellate>");
            kml.append("<coordinates>");
            n = shape.size();
            for (j = 0; j < n; ++j) {
                coord = shape.get(j);
                geoCoord = ipc.PixelsToGeo(coord);
                latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
                longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
                if (normalize && longitude > 0.0) {
                    longitude -= 360.0;
                }
                kml.append(longitude);
                kml.append(",");
                kml.append(latitude);
                if (j >= shape.size() - 1) continue;
                kml.append(" ");
            }
            kml.append("</coordinates>");
            kml.append("</LinearRing>");
            if (i == 1 && len > 1) {
                kml.append("</innerBoundaryIs>");
            } else {
                kml.append("</outerBoundaryIs>");
            }
            if (i != len - 1) continue;
            kml.append("</Polygon>");
        }
        kml.append("</MultiGeometry>");
        kml.append("</Placemark>");
        return kml.toString();
    }

    private static ShapeInfo ShapeToWWReady(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        ArrayList<ArrayList<Point2D>> shapesArray = shapeInfo.getPolylines();
        int len = shapesArray.size();
        for (int i = 0; i < len; ++i) {
            Point2D geoCoord;
            Point2D coord;
            int j;
            int n;
            ArrayList<Point2D> shape = shapesArray.get(i);
            if (shapeInfo.getLineColor() != null) {
                n = shape.size();
                for (j = 0; j < n; ++j) {
                    coord = shape.get(j);
                    geoCoord = ipc.PixelsToGeo(coord);
                    if (normalize) {
                        geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                    }
                    shape.set(j, geoCoord);
                }
            }
            if (shapeInfo.getFillColor() == null) continue;
            n = shape.size();
            for (j = 0; j < n; ++j) {
                coord = shape.get(j);
                geoCoord = ipc.PixelsToGeo(coord);
                shape.set(j, geoCoord);
            }
        }
        return shapeInfo;
    }

    private static ShapeInfo LabelToWWReady(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        try {
            Point2D.Double coord = new Point2D.Double(shapeInfo.getGlyphPosition().getX(), shapeInfo.getGlyphPosition().getY());
            Point2D geoCoord = ipc.PixelsToGeo(coord);
            if (normalize) {
                geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
            }
            double latitude = geoCoord.getY();
            double longitude = geoCoord.getX();
            long angle = Math.round(shapeInfo.getModifierAngle());
            String text = shapeInfo.getModifierString();
            if (text == null || text.equals("")) {
                return null;
            }
            shapeInfo.setModifierPosition(geoCoord);
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
        }
        return shapeInfo;
    }

    private static void AdjustModifierPointToCenter(ShapeInfo modifier) {
        Object at = null;
        try {
            Rectangle2D bounds2 = modifier.getTextLayout().getBounds();
            Rectangle2D.Double double_ = new Rectangle2D.Double(bounds2.getX(), bounds2.getY(), bounds2.getWidth(), bounds2.getHeight());
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
        }
    }

    private static String ShapeToJSONString(ShapeInfo shapeInfo, IPointConversion ipc, Boolean geMap, boolean normalize) {
        StringBuilder JSONed = new StringBuilder();
        String fillColor = null;
        String lineColor = null;
        if (shapeInfo.getLineColor() != null) {
            lineColor = Integer.toHexString(shapeInfo.getLineColor().getRGB());
            if (geMap.booleanValue()) {
                lineColor = JavaRendererUtilities.ARGBtoABGR(lineColor);
            }
        }
        if (shapeInfo.getFillColor() != null) {
            fillColor = Integer.toHexString(shapeInfo.getFillColor().getRGB());
            if (geMap.booleanValue()) {
                fillColor = JavaRendererUtilities.ARGBtoABGR(fillColor);
            }
        }
        BasicStroke stroke = null;
        stroke = shapeInfo.getStroke();
        int lineWidth = 4;
        if (stroke != null) {
            lineWidth = (int)stroke.getLineWidth();
        }
        ArrayList<ArrayList<Point2D>> shapesArray = shapeInfo.getPolylines();
        int n = shapesArray.size();
        for (int i = 0; i < n; ++i) {
            ArrayList<Point2D> shape = shapesArray.get(i);
            if (fillColor != null) {
                JSONed.append("{\"polygon\":[");
            } else {
                JSONed.append("{\"line\":[");
            }
            int t = shape.size();
            for (int j = 0; j < t; ++j) {
                Point2D coord = shape.get(j);
                Point2D geoCoord = ipc.PixelsToGeo(coord);
                if (normalize) {
                    geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                }
                double latitude = geoCoord.getY();
                double longitude = geoCoord.getX();
                coord = new Point2D.Double(longitude, latitude);
                shape.set(j, coord);
                JSONed.append("[");
                JSONed.append(longitude);
                JSONed.append(",");
                JSONed.append(latitude);
                JSONed.append("]");
                if (j >= shape.size() - 1) continue;
                JSONed.append(",");
            }
            JSONed.append("]");
            if (lineColor != null) {
                JSONed.append(",\"lineColor\":\"");
                JSONed.append(lineColor);
                JSONed.append("\"");
            }
            if (fillColor != null) {
                JSONed.append(",\"fillColor\":\"");
                JSONed.append(fillColor);
                JSONed.append("\"");
            }
            JSONed.append(",\"lineWidth\":\"");
            JSONed.append(String.valueOf(lineWidth));
            JSONed.append("\"");
            JSONed.append("}");
            if (i >= shapesArray.size() - 1) continue;
            JSONed.append(",");
        }
        return JSONed.toString();
    }

    private static String LabelToKMLString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize, Color textColor) {
        StringBuilder kml = new StringBuilder();
        Point2D.Double coord = new Point2D.Double(shapeInfo.getModifierPosition().getX(), shapeInfo.getModifierPosition().getY());
        Point2D geoCoord = ipc.PixelsToGeo(coord);
        if (normalize) {
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
        }
        double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
        double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
        long angle = Math.round(shapeInfo.getModifierAngle());
        String text = shapeInfo.getModifierString();
        String cdataStart = "<![CDATA[";
        String cdataEnd = "]]>";
        String color = Integer.toHexString(textColor.getRGB());
        color = JavaRendererUtilities.ARGBtoABGR(color);
        float kmlScale = RendererSettings.getInstance().getKMLLabelScale();
        if (!(kmlScale > 0.0f) || text == null || text.equals("")) {
            return "";
        }
        kml.append("<Placemark>");
        kml.append("<name>" + cdataStart + text + cdataEnd + "</name>");
        kml.append("<Style>");
        kml.append("<IconStyle>");
        kml.append("<scale>" + kmlScale + "</scale>");
        kml.append("<heading>" + angle + "</heading>");
        kml.append("<Icon>");
        kml.append("<href></href>");
        kml.append("</Icon>");
        kml.append("</IconStyle>");
        kml.append("<LabelStyle>");
        kml.append("<color>" + color + "</color>");
        kml.append("<scale>" + String.valueOf(kmlScale) + "</scale>");
        kml.append("</LabelStyle>");
        kml.append("</Style>");
        kml.append("<Point>");
        kml.append("<extrude>1</extrude>");
        kml.append("<altitudeMode>relativeToGround</altitudeMode>");
        kml.append("<coordinates>");
        kml.append(longitude);
        kml.append(",");
        kml.append(latitude);
        kml.append("</coordinates>");
        kml.append("</Point>");
        kml.append("</Placemark>");
        return kml.toString();
    }

    private static String LabelToJSONString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        StringBuilder JSONed = new StringBuilder();
        JSONed.append("{\"label\":");
        Point2D.Double coord = new Point2D.Double(shapeInfo.getGlyphPosition().getX(), shapeInfo.getGlyphPosition().getY());
        Point2D geoCoord = ipc.PixelsToGeo(coord);
        if (normalize) {
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
        }
        double latitude = geoCoord.getY();
        double longitude = geoCoord.getX();
        double angle = shapeInfo.getModifierAngle();
        ((Point2D)coord).setLocation(longitude, latitude);
        shapeInfo.setGlyphPosition(coord);
        String text = shapeInfo.getModifierString();
        if (text == null || text.equals("")) {
            return "";
        }
        JSONed.append("[");
        JSONed.append(longitude);
        JSONed.append(",");
        JSONed.append(latitude);
        JSONed.append("]");
        JSONed.append(",\"text\":\"");
        JSONed.append(text);
        JSONed.append("\"");
        JSONed.append(",\"angle\":\"");
        JSONed.append(angle);
        JSONed.append("\"}");
        return JSONed.toString();
    }

    public static String canRenderMultiPoint(String symbolID, Map<String, String> modifiers, int numPoints) {
        try {
            String basicID = SymbolUtilities.getBasicSymbolID(symbolID);
            MSInfo info = MSLookup.getInstance().getMSLInfo(symbolID);
            if (info == null) {
                if (SymbolID.getVersion(symbolID) >= 13) {
                    return "Basic ID: " + basicID + " not recognized in version E (15)";
                }
                return "Basic ID: " + basicID + " not recognized in version D (11)";
            }
            int drawRule = info.getDrawRule();
            if (drawRule == 0) {
                return "Basic ID: " + basicID + " has no draw rule";
            }
            if (!SymbolUtilities.isMultiPoint(symbolID)) {
                return "Basic ID: " + basicID + " is not a multipoint symbol";
            }
            if (numPoints < info.getMinPointCount()) {
                return "Basic ID: " + basicID + " requires a minimum of " + String.valueOf(info.getMinPointCount()) + " points. " + String.valueOf(numPoints) + " are present.";
            }
            ArrayList<Double> AM = new ArrayList<Double>();
            ArrayList<Double> AN = new ArrayList<Double>();
            if (modifiers.containsKey("AM_DISTANCE")) {
                String[] amArray;
                for (String str : amArray = modifiers.get("AM_DISTANCE").split(",")) {
                    if (str.equals("")) continue;
                    AM.add(Double.parseDouble(str));
                }
            }
            if (modifiers.containsKey("AN_AZIMUTH")) {
                String[] anArray;
                for (String str : anArray = modifiers.get("AN_AZIMUTH").split(",")) {
                    if (str.equals("")) continue;
                    AN.add(Double.parseDouble(str));
                }
            }
            return MultiPointHandler.hasRequiredModifiers(symbolID, drawRule, AM, AN);
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MultiPointHandler", "canRenderMultiPoint", exc);
            return "false: " + exc.getMessage();
        }
    }

    private static String hasRequiredModifiers(String symbolID, int drawRule, ArrayList<Double> AM, ArrayList<Double> AN) {
        String message = symbolID;
        try {
            if (drawRule > 700) {
                if (drawRule == 901) {
                    if (AM != null && AM.size() > 0) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 1 distance/AM value.";
                    return message;
                }
                if (drawRule == 802) {
                    if (AM != null && AM.size() >= 2 && AN != null && AN.size() >= 1) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 2 distance/AM values and 1 azimuth/AN value.";
                    return message;
                }
                if (drawRule == 1001) {
                    if (AM != null && AM.size() >= 1 && AN != null && AN.size() >= 2) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 2 distance/AM values and 2 azimuth/AN values per sector.  The first sector can have just one AM value although it is recommended to always use 2 values for each sector.";
                    return message;
                }
                if (drawRule == 902) {
                    if (AM != null && AM.size() > 0) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has at least 1 distance/AM value";
                    return message;
                }
                if (drawRule == 801) {
                    if (AM != null && AM.size() > 0) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 1 distance/AM value.";
                    return message;
                }
                if (drawRule == 701) {
                    if (AM != null && AM.size() >= 2 && AN != null && AN.size() >= 1) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 2 distance/AM values and 1 azimuth/AN value.";
                    return message;
                }
                if (drawRule == 803) {
                    if (AM != null && AM.size() >= 1) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 1 distance/AM value.";
                    return message;
                }
                return "true";
            }
            if (drawRule == 217) {
                if (AM != null && AM.size() >= 2 && AN != null && AN.size() >= 1) {
                    return "true";
                }
                message = message + " requires a modifiers object that has 2 distance/AM values and 1 azimuth/AN value.";
                return message;
            }
            if (drawRule == 218) {
                if (AM != null && AM.size() >= 2 && AN != null && AN.size() >= 2) {
                    return "true";
                }
                message = message + " requires a modifiers object that has 2 distance/AM values and 2 azimuth/AN values.";
                return message;
            }
            if (drawRule == 401) {
                if (AM != null && AM.size() > 0) {
                    return "true";
                }
                message = message + " requires a modifiers object that has 1 distance/AM value.";
                return message;
            }
            return "true";
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MultiPointHandler", "hasRequiredModifiers", exc);
            return "true";
        }
    }

    public static MilStdSymbol RenderBasicShapeAsMilStdSymbol(String id, String name, String description, int basicShapeType, String controlPoints, Double scale, String bbox, Map<String, String> symbolModifiers, Map<String, String> symbolAttributes) {
        MilStdSymbol mSymbol = null;
        boolean normalize = true;
        Double controlLat = 0.0;
        Double controlLong = 0.0;
        Cloneable rect = null;
        Object tgPoints = null;
        String[] coordinates = controlPoints.split(" ");
        ArrayList<ShapeInfo> shapes = null;
        ArrayList<ShapeInfo> modifiers = null;
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        int len = coordinates.length;
        PointConverter ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        Point2D temp = null;
        Point2D ptGeoUL = null;
        int width = 0;
        int height = 0;
        int leftX = 0;
        int topY = 0;
        int bottomY = 0;
        int rightX = 0;
        int j = 0;
        ArrayList<Point2D> bboxCoords = null;
        if (bbox != null && !bbox.equals("")) {
            String[] bounds = null;
            if (bbox.contains(" ")) {
                String[] coords;
                bboxCoords = new ArrayList<Point2D>();
                double x = 0.0;
                double y = 0.0;
                for (String coord : coords = bbox.split(" ")) {
                    String[] arrCoord = coord.split(",");
                    x = Double.valueOf(arrCoord[0]);
                    y = Double.valueOf(arrCoord[1]);
                    bboxCoords.add(new Point2D.Double(x, y));
                }
                ptGeoUL = MultiPointHandler.getGeoUL(bboxCoords);
                left = ptGeoUL.getX();
                top = ptGeoUL.getY();
                ipc = new PointConverter(left, top, scale);
                Point2D ptPixels = null;
                Point2D ptGeo = null;
                int n = bboxCoords.size();
                for (j = 0; j < n; ++j) {
                    ptGeo = bboxCoords.get(j);
                    ptPixels = ipc.GeoToPixels(ptGeo);
                    x = ptPixels.getX();
                    y = ptPixels.getY();
                    if (x < 20.0) {
                        x = 20.0;
                    }
                    if (y < 20.0) {
                        y = 20.0;
                    }
                    ptPixels.setLocation(x, y);
                    bboxCoords.set(j, ptPixels);
                }
            } else {
                bounds = bbox.split(",");
                left = Double.valueOf(bounds[0]);
                right = Double.valueOf(bounds[2]);
                top = Double.valueOf(bounds[3]);
                bottom = Double.valueOf(bounds[1]);
                scale = MultiPointHandler.getReasonableScale(bbox, scale);
                ipc = new PointConverter(left, top, scale);
            }
            Point2D.Double pt2d = null;
            if (bboxCoords == null) {
                pt2d = new Point2D.Double(left, top);
                temp = ipc.GeoToPixels((Point2D)pt2d);
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                pt2d = new Point2D.Double(right, bottom);
                temp = ipc.GeoToPixels((Point2D)pt2d);
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = width == 0 || height == 0 ? null : new Rectangle(leftX, topY, width, height);
            }
        } else {
            rect = null;
        }
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            Double latitude = Double.valueOf(coordPair[1].trim());
            Double longitude = Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        if (ipc == null) {
            Point2D ptCoordsUL = MultiPointHandler.getGeoUL(geoCoords);
            ipc = new PointConverter(ptCoordsUL.getX(), ptCoordsUL.getY(), scale);
        }
        ArrayList<Point2D.Double> geoCoords2 = new ArrayList<Point2D.Double>();
        geoCoords2.add(new Point2D.Double(left, top));
        geoCoords2.add(new Point2D.Double(right, bottom));
        if (!MultiPointHandler.crossesIDL(geoCoords)) {
            rect = null;
            bboxCoords = null;
        }
        String symbolCode = "";
        try {
            String fillColor = null;
            mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            if (symbolModifiers != null || symbolAttributes != null) {
                MultiPointHandler.populateModifiers(symbolModifiers, symbolAttributes, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            if (mSymbol.getFillColor() != null) {
                Color fc = mSymbol.getFillColor();
                fillColor = Integer.toHexString(fc.getRGB());
            }
            TGLight tg = clsRenderer.createTGLightFromMilStdSymbolBasicShape(mSymbol, ipc, basicShapeType);
            ArrayList<ShapeInfo> shapeInfos = new ArrayList<ShapeInfo>();
            ArrayList<ShapeInfo> modifierShapeInfos = new ArrayList<ShapeInfo>();
            Cloneable clipArea = bboxCoords == null ? rect : bboxCoords;
            if (clsRenderer.intersectsClipArea(tg, ipc, clipArea)) {
                clsRenderer.render_GE(tg, shapeInfos, modifierShapeInfos, ipc, clipArea);
            }
            mSymbol.setSymbolShapes(shapeInfos);
            mSymbol.setModifierShapes(modifierShapeInfos);
            mSymbol.setWasClipped(tg.get_WasClipped());
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            ArrayList<ArrayList<Point2D>> polylines = null;
            ArrayList<ArrayList<Point2D>> newPolylines = null;
            Object newLine = null;
            for (ShapeInfo shape : shapes) {
                polylines = shape.getPolylines();
                newPolylines = MultiPointHandler.ConvertPolylinePixelsToCoords(polylines, ipc, normalize);
                shape.setPolylines(newPolylines);
            }
            for (ShapeInfo label : modifiers) {
                Point2D pixelCoord = label.getModifierPosition();
                if (pixelCoord == null) {
                    pixelCoord = label.getGlyphPosition();
                }
                Point2D geoCoord = ipc.PixelsToGeo(pixelCoord);
                if (normalize) {
                    geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                }
                double latitude = geoCoord.getY();
                double longitude = geoCoord.getX();
                label.setModifierPosition(new Point2D.Double(longitude, latitude));
            }
            mSymbol.setModifierShapes(modifiers);
            mSymbol.setSymbolShapes(shapes);
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            System.out.println("Symbol Code: " + symbolCode);
            exc.printStackTrace();
        }
        boolean debug = false;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("Scale: " + scale);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + ((Rectangle)rect).toString());
            }
        }
        return mSymbol;
    }

    public static String RenderBasicShape(String id, String name, String description, int basicShapeType, String controlPoints, Double scale, String bbox, Map<String, String> symbolModifiers, Map<String, String> symbolAttributes, int format) {
        boolean normalize = true;
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Cloneable rect = null;
        String[] coordinates = controlPoints.split(" ");
        ArrayList<ShapeInfo> shapes = new ArrayList();
        ArrayList<ShapeInfo> modifiers = new ArrayList();
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        int len = coordinates.length;
        Object coordsUL = null;
        String symbolCode = "";
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            Double latitude = (double)Double.valueOf(coordPair[1].trim());
            Double longitude = (double)Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        Object tgPoints = null;
        PointConverter ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        Point2D temp = null;
        Point2D ptGeoUL = null;
        int width = 0;
        int height = 0;
        int leftX = 0;
        int topY = 0;
        int bottomY = 0;
        int rightX = 0;
        int j = 0;
        ArrayList<Point2D> bboxCoords = null;
        if (bbox != null && !bbox.equals("")) {
            String[] bounds = null;
            if (bbox.contains(" ")) {
                String[] coords;
                bboxCoords = new ArrayList<Point2D>();
                double x = 0.0;
                double y = 0.0;
                for (String coord : coords = bbox.split(" ")) {
                    String[] arrCoord = coord.split(",");
                    x = Double.valueOf(arrCoord[0]);
                    y = Double.valueOf(arrCoord[1]);
                    bboxCoords.add(new Point2D.Double(x, y));
                }
                ptGeoUL = MultiPointHandler.getGeoUL(bboxCoords);
                left = ptGeoUL.getX();
                top = ptGeoUL.getY();
                String bbox2 = MultiPointHandler.getBboxFromCoords(bboxCoords);
                scale = MultiPointHandler.getReasonableScale(bbox2, scale);
                ipc = new PointConverter(left, top, scale);
                Point2D ptPixels = null;
                Point2D ptGeo = null;
                int n = bboxCoords.size();
                for (j = 0; j < n; ++j) {
                    ptGeo = bboxCoords.get(j);
                    ptPixels = ipc.GeoToPixels(ptGeo);
                    x = ptPixels.getX();
                    y = ptPixels.getY();
                    if (x < 20.0) {
                        x = 20.0;
                    }
                    if (y < 20.0) {
                        y = 20.0;
                    }
                    ptPixels.setLocation(x, y);
                    bboxCoords.set(j, ptPixels);
                }
            } else {
                bounds = bbox.split(",");
                left = Double.valueOf(bounds[0]);
                right = Double.valueOf(bounds[2]);
                top = Double.valueOf(bounds[3]);
                bottom = Double.valueOf(bounds[1]);
                scale = MultiPointHandler.getReasonableScale(bbox, scale);
                ipc = new PointConverter(left, top, scale);
            }
            Point2D.Double pt2d = null;
            if (bboxCoords == null) {
                pt2d = new Point2D.Double(left, top);
                temp = ipc.GeoToPixels((Point2D)pt2d);
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                pt2d = new Point2D.Double(right, bottom);
                temp = ipc.GeoToPixels((Point2D)pt2d);
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = new Rectangle(leftX, topY, width, height);
            }
        } else {
            rect = null;
        }
        if (ipc == null) {
            Point2D ptCoordsUL = MultiPointHandler.getGeoUL(geoCoords);
            ipc = new PointConverter(ptCoordsUL.getX(), ptCoordsUL.getY(), scale);
        }
        ArrayList<Point2D.Double> geoCoords2 = new ArrayList<Point2D.Double>();
        geoCoords2.add(new Point2D.Double(left, top));
        geoCoords2.add(new Point2D.Double(right, bottom));
        try {
            Object textColor;
            MilStdSymbol mSymbol = new MilStdSymbol("", null, geoCoords, null);
            if (format == 3) {
                symbolAttributes.put("USEDASHARRAY", "true");
                symbolAttributes.put("USEPATTERNFILL", "true");
            }
            if (symbolModifiers != null || symbolAttributes != null) {
                MultiPointHandler.populateModifiers(symbolModifiers, symbolAttributes, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            TGLight tg = clsRenderer.createTGLightFromMilStdSymbolBasicShape(mSymbol, ipc, basicShapeType);
            ArrayList<ShapeInfo> shapeInfos = new ArrayList<ShapeInfo>();
            ArrayList<ShapeInfo> modifierShapeInfos = new ArrayList<ShapeInfo>();
            Cloneable clipArea = bboxCoords == null ? rect : bboxCoords;
            if (clsRenderer.intersectsClipArea(tg, ipc, clipArea)) {
                clsRenderer.render_GE(tg, shapeInfos, modifierShapeInfos, ipc, clipArea);
            }
            mSymbol.setSymbolShapes(shapeInfos);
            mSymbol.setModifierShapes(modifierShapeInfos);
            mSymbol.setWasClipped(tg.get_WasClipped());
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            if (format == 1) {
                jsonOutput.append("{\"type\":\"symbol\",");
                jsonContent = MultiPointHandler.JSONize(shapes, modifiers, ipc, true, normalize);
                jsonOutput.append(jsonContent);
                jsonOutput.append("}");
            } else if (format == 0) {
                textColor = mSymbol.getTextColor();
                if (textColor == null) {
                    textColor = mSymbol.getLineColor();
                }
                jsonContent = MultiPointHandler.KMLize(id, name, description, "", shapes, modifiers, ipc, normalize, (Color)textColor, mSymbol.getWasClipped(), mSymbol.isTextScaleSensitive(), mSymbol.isSymbolScaleSensitive());
                jsonOutput.append(jsonContent);
            } else if (format == 2) {
                jsonOutput.append("{\"type\":\"FeatureCollection\",\"features\":");
                jsonContent = MultiPointHandler.GeoJSONize(shapes, modifiers, ipc, normalize, mSymbol.getTextColor(), mSymbol.getTextBackgroundColor());
                jsonOutput.append(jsonContent);
                jsonOutput.replace(jsonOutput.toString().length() - 1, jsonOutput.toString().length(), "");
                if (jsonContent.length() > 2) {
                    jsonOutput.append(",");
                }
                jsonOutput.append("{\"type\": \"Feature\",\"geometry\": { \"type\": \"Polygon\",\"coordinates\": [ ]}");
                jsonOutput.append(",\"properties\":{\"id\":\"");
                jsonOutput.append(id);
                jsonOutput.append("\",\"name\":\"");
                jsonOutput.append(name);
                jsonOutput.append("\",\"description\":\"");
                jsonOutput.append(description);
                jsonOutput.append("\",\"symbolID\":\"");
                jsonOutput.append("");
                jsonOutput.append("\",\"wasClipped\":\"");
                jsonOutput.append(String.valueOf(mSymbol.getWasClipped()));
                jsonOutput.append("\",\"textScaleSensitive\":\"");
                jsonOutput.append(String.valueOf(mSymbol.isTextScaleSensitive()));
                jsonOutput.append("\",\"symbolScaleSensitive\":\"");
                jsonOutput.append(String.valueOf(mSymbol.isSymbolScaleSensitive()));
                jsonOutput.append("\"}}]}");
            } else if (format == 3) {
                textColor = mSymbol.getTextColor() != null ? RendererUtilities.colorToHexString(mSymbol.getTextColor(), false) : "";
                String backgroundColor = mSymbol.getTextBackgroundColor() != null ? RendererUtilities.colorToHexString(mSymbol.getTextBackgroundColor(), false) : "";
                jsonContent = MultiPointHandlerSVG.GeoSVGize(id, name, description, "", shapes, modifiers, ipc, normalize, (String)textColor, backgroundColor, mSymbol.getWasClipped());
                jsonOutput.append(jsonContent);
            }
        }
        catch (Exception exc) {
            String st = JavaRendererUtilities.getStackTrace(exc);
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol : - ");
            jsonOutput.append(exc.getMessage() + " - ");
            jsonOutput.append(st);
            jsonOutput.append("\"}");
            ErrorLogger.LogException("MultiPointHandler", "RenderBasicShape", exc);
        }
        boolean debug = false;
        if (debug) {
            System.out.println("Symbol Code: ");
            System.out.println("Scale: " + scale);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + ((Rectangle)rect).toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        ErrorLogger.LogMessage("MultiPointHandler", "RenderBasicShape()", "exit RenderBasicShape", Level.FINER);
        return jsonOutput.toString();
    }
}

