/*
 * Decompiled with CFR 0.152.
 */
package io.github.unknowncoder56.javaslc;

import com.google.gson.JsonObject;
import io.github.unknowncoder56.javaslc.Bot;
import io.github.unknowncoder56.javaslc.User;
import java.util.concurrent.CompletableFuture;

public class MessageContext {
    private final String text;
    private final User owner;
    private final String serverId;
    private final Bot bot;

    public MessageContext(JsonObject message, String serverId, Bot bot) {
        this.text = message.get("text").getAsString();
        this.owner = new User(message.get("owner").getAsJsonObject().get("id").getAsString(), bot.getErrorListener());
        this.serverId = serverId;
        this.bot = bot;
    }

    public CompletableFuture<Void> send(String text) {
        return this.bot.send(text, this.serverId);
    }

    public String getText() {
        return this.text;
    }

    public User getOwner() {
        return this.owner;
    }

    public String getServerId() {
        return this.serverId;
    }

    public Bot getBot() {
        return this.bot;
    }
}

