/*
 * Decompiled with CFR 0.152.
 */
package act.db.ebean.util;

import act.app.App;
import act.asm.AnnotationVisitor;
import act.asm.FieldVisitor;
import act.asm.Type;
import act.db.meta.EntityClassMetaInfo;
import act.db.meta.EntityFieldMetaInfo;
import act.db.meta.EntityMetaInfoRepo;
import act.util.AppByteCodeEnhancer;
import org.osgl.util.S;

public class TimestampAuditorEnhancer
extends AppByteCodeEnhancer<TimestampAuditorEnhancer> {
    private EntityMetaInfoRepo metaInfoRepo;
    private String className;
    private String createdAt;
    private String lastModifiedAt;

    public TimestampAuditorEnhancer() {
        super(S.F.startsWith((String)"act.").negate());
    }

    protected Class<TimestampAuditorEnhancer> subClass() {
        return TimestampAuditorEnhancer.class;
    }

    public AppByteCodeEnhancer app(App app) {
        this.metaInfoRepo = app.entityMetaInfoRepo();
        return super.app(app);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String classDesc = "L" + name + ";";
        this.className = Type.getType((String)classDesc).getClassName();
        EntityClassMetaInfo classMetaInfo = this.metaInfoRepo.classMetaInfo(this.className);
        if (null != classMetaInfo) {
            EntityFieldMetaInfo fieldMetaInfo = classMetaInfo.createdAtField();
            if (null != fieldMetaInfo) {
                this.createdAt = fieldMetaInfo.fieldName();
            }
            if (null != (fieldMetaInfo = classMetaInfo.lastModifiedAtField())) {
                this.lastModifiedAt = fieldMetaInfo.fieldName();
            }
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        boolean isLastModified;
        FieldVisitor fv = super.visitField(access, name, desc, signature, value);
        if (null == this.createdAt && null == this.lastModifiedAt) {
            return fv;
        }
        final boolean isCreatedAt = name.equals(this.createdAt);
        boolean bl = isLastModified = !isCreatedAt && name.equals(this.lastModifiedAt);
        if (!isCreatedAt && !isLastModified) {
            return fv;
        }
        return new FieldVisitor(327680, fv){

            public void visitEnd() {
                AnnotationVisitor av = isCreatedAt ? this.fv.visitAnnotation("Lcom/avaje/ebean/annotation/WhenCreated;", true) : this.fv.visitAnnotation("Lcom/avaje/ebean/annotation/WhenModified;", true);
                av.visitEnd();
                super.visitEnd();
            }
        };
    }
}

