/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.testutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.androidannotations.testutils.ClassFinder;
import org.junit.Assert;

public class ProcessorTestHelper {
    private static final String TEST_SOURCE_FOLDER = "src/test/java";
    private static final String MAIN_SOURCE_FOLDER = "src/main/java";
    protected static final String SOURCE_FILE_SUFFIX = ".java";
    protected static final String OUTPUT_DIRECTORY = "target/generated-test";
    private final List<String> compilerOptions = new ArrayList<String>();
    private final List<Class<? extends Processor>> processorsClasses = new ArrayList<Class<? extends Processor>>();

    public static void assertGeneratedClassMatches(File output, String value) {
        String[] outputContent;
        for (String line : outputContent = ProcessorTestHelper.getContents(output)) {
            if (!line.matches(value)) continue;
            return;
        }
        Assert.fail((String)("Expected value \"" + value + "\" couldn't be found in file " + output.getAbsolutePath()));
    }

    public static void assertGeneratedClassDoesntMatches(File output, String value) {
        String[] outputContent;
        for (String line : outputContent = ProcessorTestHelper.getContents(output)) {
            if (!line.matches(value)) continue;
            Assert.fail((String)("Value \"" + value + "\" shouldn't be in file " + output.getAbsolutePath()));
        }
    }

    public static void assertGeneratedClassContains(File output, String[] codeFragment) {
        Assert.assertTrue((String)("Code fragment \"" + ProcessorTestHelper.join(codeFragment) + "\" should be in file " + output.getAbsolutePath()), (Collections.indexOfSubList(Arrays.asList(ProcessorTestHelper.getContents(output)), Arrays.asList(codeFragment)) != -1 ? 1 : 0) != 0);
    }

    public static void assertGeneratedClassDoesNotContain(File output, String[] codeFragment) {
        Assert.assertTrue((String)("Code fragment \"" + ProcessorTestHelper.join(codeFragment) + "\" should not be in file " + output.getAbsolutePath()), (Collections.indexOfSubList(Arrays.asList(ProcessorTestHelper.getContents(output)), Arrays.asList(codeFragment)) == -1 ? 1 : 0) != 0);
    }

    public static void assertOutput(File expectedResult, File output) {
        String[] expectedContent = ProcessorTestHelper.getContents(expectedResult);
        String[] outputContent = ProcessorTestHelper.getContents(output);
        Assert.assertEquals((long)expectedContent.length, (long)outputContent.length);
        for (int i = 0; i < expectedContent.length; ++i) {
            Assert.assertEquals((Object)expectedContent[i].trim(), (Object)outputContent[i].trim());
        }
    }

    public static void assertClassSourcesGeneratedToOutput(Class<?> clazz) {
        String canonicalName = clazz.getCanonicalName();
        String filePath = canonicalName.replace(".", "/").concat(SOURCE_FILE_SUFFIX);
        File generatedSourcesDir = new File(OUTPUT_DIRECTORY);
        File generatedSourceFile = new File(generatedSourcesDir, filePath);
        File sourcesDir = new File(MAIN_SOURCE_FOLDER);
        File expectedResult = new File(sourcesDir, filePath);
        ProcessorTestHelper.assertOutput(expectedResult, generatedSourceFile);
    }

    public static void assertClassSourcesNotGeneratedToOutput(Class<?> clazz) {
        String canonicalName = clazz.getCanonicalName();
        String filePath = canonicalName.replace(".", "/").concat(SOURCE_FILE_SUFFIX);
        File generatedSourcesDir = new File(OUTPUT_DIRECTORY);
        File output = new File(generatedSourcesDir, filePath);
        Assert.assertFalse((boolean)output.exists());
    }

    public static void assertCompilationSuccessful(CompileResult result) {
        for (Diagnostic diagnostic : result.diagnostics) {
            Assert.assertFalse((String)("Expected no errors, found " + diagnostic), (boolean)diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR));
        }
    }

    public static void assertCompilationError(CompileResult result) {
        for (Diagnostic diagnostic : result.diagnostics) {
            if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
            return;
        }
        Assert.fail((String)("Expected a compilation error, diagnostics: " + result.diagnostics));
    }

    public static void assertCompilationErrorWithNoSource(CompileResult result) {
        for (Diagnostic diagnostic : result.diagnostics) {
            if (diagnostic.getKind() != Diagnostic.Kind.ERROR || diagnostic.getSource() != null) continue;
            return;
        }
        Assert.fail((String)("Expected a compilation error with no source, diagnostics: " + result.diagnostics));
    }

    public static void assertCompilationErrorCount(int expectedErrorCount, CompileResult result) {
        int errorCount = 0;
        for (Diagnostic diagnostic : result.diagnostics) {
            if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
            ++errorCount;
        }
        if (errorCount != expectedErrorCount) {
            Assert.fail((String)("Expected " + expectedErrorCount + " compilation error, found " + errorCount + " diagnostics: " + result.diagnostics));
        }
    }

    public static void assertCompilationErrorOn(File expectedErrorClassFile, String expectedContentInError, CompileResult result) throws IOException {
        ProcessorTestHelper.assertCompilationDiagnostingOn(Diagnostic.Kind.ERROR, expectedErrorClassFile, expectedContentInError, result);
    }

    public static void assertCompilationErrorOn(String expectedClassName, String expectedContentInError, CompileResult result) throws IOException {
        ProcessorTestHelper.assertCompilationDiagnostingOn(Diagnostic.Kind.ERROR, new File(expectedClassName + SOURCE_FILE_SUFFIX), expectedContentInError, result);
    }

    public static void assertCompilationWarningOn(File expectedErrorClassFile, String expectedContentInError, CompileResult result) throws IOException {
        ProcessorTestHelper.assertCompilationDiagnostingOn(Diagnostic.Kind.WARNING, expectedErrorClassFile, expectedContentInError, result);
    }

    private static void assertCompilationDiagnostingOn(Diagnostic.Kind expectedDiagnosticKind, File expectedErrorClassFile, String expectedContentInError, CompileResult result) throws IOException {
        boolean fileNameOnly = expectedErrorClassFile.getPath().split(Pattern.quote(File.separator)).length == 1;
        String expectedErrorPath = fileNameOnly ? expectedErrorClassFile.getPath() : expectedErrorClassFile.toURI().toString();
        for (Diagnostic diagnostic : result.diagnostics) {
            CharSequence contentInError;
            JavaFileObject source;
            if (diagnostic.getKind() != expectedDiagnosticKind || (source = (JavaFileObject)diagnostic.getSource()) == null || !expectedErrorPath.endsWith(source.toUri().toString()) && (!fileNameOnly || !source.toUri().toString().endsWith(expectedErrorPath))) continue;
            CharSequence sourceContent = source.getCharContent(true);
            if (diagnostic.getPosition() == -1L || !(contentInError = sourceContent.subSequence((int)diagnostic.getStartPosition(), (int)diagnostic.getEndPosition())).toString().contains(expectedContentInError)) continue;
            return;
        }
        Assert.fail((String)("Expected a compilation " + (Object)((Object)expectedDiagnosticKind) + " in " + expectedErrorClassFile.toString() + " on " + expectedContentInError + ", diagnostics: " + result.diagnostics));
    }

    private static String[] getContents(File file) {
        ArrayList<String> content = new ArrayList<String>();
        try (BufferedReader input = new BufferedReader(new FileReader(file));){
            String line = null;
            while ((line = input.readLine()) != null) {
                content.add(line);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return content.toArray(new String[0]);
    }

    public ProcessorTestHelper() {
        this.compilerOptions.add("-classpath");
        this.compilerOptions.add(this.getClassPath());
        this.compilerOptions.add("-s");
        String outputPath = this.ensureOutputDirectory().getAbsolutePath();
        this.compilerOptions.add(outputPath);
        this.compilerOptions.add("-d");
        this.compilerOptions.add(outputPath);
    }

    public File getOuputDirectory() {
        return this.ensureOutputDirectory();
    }

    public void addProcessor(Class<? extends Processor> processorClass) {
        this.processorsClasses.add(processorClass);
    }

    public void addProcessorParameter(String key, String value) {
        this.addCompilerOptions("-A" + key + "=" + value);
    }

    public final void addCompilerOptions(String ... compilerOptions) {
        for (String compilerOption : compilerOptions) {
            this.compilerOptions.add(compilerOption);
        }
    }

    public String toPath(Package packageName) {
        return this.toPath(packageName.getName());
    }

    public String toPath(String packageName) {
        return packageName.replace(".", "/");
    }

    public CompileResult compileFiles(Type ... compilationUnits) {
        assert (compilationUnits != null);
        ArrayList<File> files = new ArrayList<File>();
        this.addCollection((List<File>)files, (Type)compilationUnits);
        return this.compileFiles(files);
    }

    public CompileResult compileFiles(Object ... elements) {
        assert (elements != null);
        ArrayList<File> files = new ArrayList<File>();
        for (Object element : elements) {
            if (element instanceof Type) {
                this.addCollection((List<File>)files, (Type)((Type)element));
                continue;
            }
            if (!(element instanceof String)) continue;
            files.add(new File((String)element));
        }
        return this.compileFiles(files);
    }

    public CompileResult compileFiles(File ... compilationUnits) {
        return this.compileFiles(Arrays.asList(compilationUnits));
    }

    public CompileResult compileFiles(Collection<File> compilationUnits) {
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnosticCollector, null, null);){
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnosticCollector, this.compilerOptions, null, fileManager.getJavaFileObjectsFromFiles(compilationUnits));
            ArrayList<Processor> processors = new ArrayList<Processor>();
            for (Class<? extends Processor> processorClass : this.processorsClasses) {
                try {
                    processors.add(processorClass.newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            task.setProcessors(processors);
            task.call();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CompileResult(diagnosticCollector.getDiagnostics());
    }

    public void assertCompilationErrorOn(Class<?> expectedErrorClass, String expectedContentInError, CompileResult result) throws IOException {
        ProcessorTestHelper.assertCompilationErrorOn(this.toFile(expectedErrorClass), expectedContentInError, result);
    }

    public void assertCompilationWarningOn(Class<?> expectedErrorClass, String expectedContentInError, CompileResult result) throws IOException {
        ProcessorTestHelper.assertCompilationWarningOn(this.toFile(expectedErrorClass), expectedContentInError, result);
    }

    private File ensureOutputDirectory() {
        File outputDir = new File(OUTPUT_DIRECTORY);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        return outputDir;
    }

    public void ensureOutputDirectoryIsEmpty() {
        File outputDir = new File(OUTPUT_DIRECTORY);
        String[] childs = outputDir.list();
        if (childs != null && childs.length > 0) {
            this.deleteDirectoryRecursively(outputDir);
            outputDir.mkdirs();
        }
    }

    private void deleteDirectoryRecursively(File directory) {
        File[] childs = directory.listFiles();
        if (childs != null) {
            for (File file : childs) {
                if (file.isDirectory()) {
                    this.deleteDirectoryRecursively(file);
                    continue;
                }
                file.delete();
            }
        }
        directory.delete();
    }

    private <T extends AnnotatedElement> void addCollection(List<File> files, Collection<T> compilationUnits) {
        if (compilationUnits == null) {
            return;
        }
        this.addCollection(files, (T)compilationUnits.toArray(new Type[0]));
    }

    private <T extends Type> void addCollection(List<File> files, T ... compilationUnits) {
        if (compilationUnits == null) {
            return;
        }
        for (T element : compilationUnits) {
            this.addCollection(files, element);
        }
    }

    private <T extends Type> void addCollection(List<File> files, T element) {
        assert (element != null);
        if (element instanceof Class) {
            File file = this.toFile((Class)element);
            if (file != null) {
                files.add(file);
            }
        } else if (element instanceof Package) {
            ClassFinder classFinder = new ClassFinder();
            this.addCollection(files, (T)((Object)classFinder.findClassesInPackage(((Package)((Object)element)).getName())));
        }
    }

    private String convertClassNameToResourcePath(String name) {
        return name.replace(".", File.separator);
    }

    public File toFile(Class<?> clazz) {
        File file = new File(TEST_SOURCE_FOLDER + File.separator + this.convertClassNameToResourcePath(clazz.getCanonicalName()) + SOURCE_FILE_SUFFIX);
        if (!file.exists() && !(file = new File(MAIN_SOURCE_FOLDER + File.separator + this.convertClassNameToResourcePath(clazz.getCanonicalName()) + SOURCE_FILE_SUFFIX)).exists()) {
            return null;
        }
        return file;
    }

    protected String getClassPath() {
        String classPath = System.getProperty("maven.test.class.path");
        if (classPath == null || classPath.length() == 0) {
            return System.getProperty("java.class.path");
        }
        classPath = classPath.replaceAll(", ", this.isWindows() ? ";" : ":").trim();
        return "\"" + classPath.substring(1, classPath.length() - 2).trim() + ";" + new File("target\\classes").getAbsolutePath() + "\"";
    }

    private String getOsName() {
        return System.getProperty("os.name");
    }

    private boolean isWindows() {
        return this.getOsName().startsWith("Windows");
    }

    private static String join(String[] array) {
        return Arrays.toString(array).replaceAll(",", "\n");
    }

    public static class CompileResult {
        private final List<Diagnostic<? extends JavaFileObject>> diagnostics;

        public CompileResult(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
            this.diagnostics = diagnostics;
        }
    }
}

