/*
 * Decompiled with CFR 0.152.
 */
package org.codeartisans.java.toolbox.exceptions;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public final class NullArgumentException
extends IllegalArgumentException {
    private static final long serialVersionUID = 1L;
    private static final String WAS_NULL = " was null.";
    private static final String WAS_EMPTY = " was empty.";
    private static final String WAS_ZERO = " was zero.";

    private NullArgumentException(String message) {
        super(message);
    }

    public static void ensureNotNull(String name, Object value) {
        if (value != null) {
            return;
        }
        throw new NullArgumentException(name + WAS_NULL);
    }

    public static void ensureNotEmpty(String name, String value) {
        NullArgumentException.ensureNotNull(name, value);
        if (value.length() == 0) {
            throw new NullArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmpty(String name, CharSequence value) {
        NullArgumentException.ensureNotNull(name, value);
        if (value.length() == 0) {
            throw new NullArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmpty(String name, boolean trim, String value) {
        NullArgumentException.ensureNotNull(name, value);
        if (value.length() == 0 || trim && value.trim().length() == 0) {
            throw new NullArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmpty(String name, Object[] value) {
        NullArgumentException.ensureNotNull(name, value);
        if (value.length == 0) {
            throw new NullArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmpty(String name, Collection<?> value) {
        NullArgumentException.ensureNotNull(name, value);
        if (value.isEmpty()) {
            throw new NullArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmpty(String name, Properties value) {
        NullArgumentException.ensureNotNull(name, value);
        if (value.isEmpty()) {
            throw new NullArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmpty(String name, Map<?, ?> value) throws NullArgumentException {
        NullArgumentException.ensureNotNull(name, value);
        if (value.isEmpty()) {
            throw new NullArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmptyContent(String name, String[] value) {
        NullArgumentException.ensureNotEmptyContent(name, false, value);
    }

    public static void ensureNotEmptyContent(String name, boolean trim, String[] value) {
        NullArgumentException.ensureNotEmpty(name, value);
        for (int i = 0; i < value.length; ++i) {
            NullArgumentException.ensureNotEmpty(value[i] + "[" + i + "]", value[i]);
            if (!trim) continue;
            NullArgumentException.ensureNotEmpty(value[i] + "[" + i + "]", value[i].trim());
        }
    }

    public static void ensureNotZero(String name, Integer value) {
        NullArgumentException.ensureNotNull(name, value);
        if (value == 0) {
            throw new NullArgumentException(name + WAS_ZERO);
        }
    }
}

