/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.common.ColumnNameList;
import org.sql.generation.implementation.grammar.common.NonBooleanExpressionImpl;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnNameListImpl
extends NonBooleanExpressionImpl<ColumnNameList>
implements ColumnNameList {
    private final List<String> _columnNames;

    public ColumnNameListImpl(SQLProcessorAggregator processor, Collection<String> columnNames) {
        this(processor, ColumnNameList.class, columnNames);
    }

    protected ColumnNameListImpl(SQLProcessorAggregator processor, Class<? extends ColumnNameList> implClass, Collection<String> columnNames) {
        super(processor, implClass);
        NullArgumentException.validateNotNull((String)"column names", columnNames);
        if (columnNames.isEmpty()) {
            throw new IllegalArgumentException("Column name list must have at least one column.");
        }
        for (String columnName : columnNames) {
            NullArgumentException.validateNotNull((String)"column name", (Object)columnName);
        }
        this._columnNames = Collections.unmodifiableList(new ArrayList<String>(columnNames));
    }

    public ColumnNameListImpl(SQLProcessorAggregator processor, String ... columnNames) {
        this(processor, Arrays.asList(columnNames));
    }

    public List<String> getColumnNames() {
        return this._columnNames;
    }

    protected boolean doesEqual(ColumnNameList another) {
        return ((Object)this._columnNames).equals(another.getColumnNames());
    }
}

