/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.transformation;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import org.atp.api.Typeable;
import org.sql.generation.api.grammar.literals.DirectLiteral;
import org.sql.generation.api.grammar.literals.NumericLiteral;
import org.sql.generation.api.grammar.literals.SQLFunctionLiteral;
import org.sql.generation.api.grammar.literals.StringLiteral;
import org.sql.generation.api.grammar.literals.TimestampTimeLiteral;
import org.sql.generation.implementation.transformation.AbstractProcessor;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

public class LiteralExpressionProcessing {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NumericLiteralProcessor
    extends AbstractProcessor<NumericLiteral> {
        public NumericLiteralProcessor() {
            super(NumericLiteral.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, NumericLiteral object, StringBuilder builder) {
            Number numba = object.getNumber();
            builder.append(numba == null ? "NULL" : numba.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SQLFunctionLiteralProcessor
    extends AbstractProcessor<SQLFunctionLiteral> {
        public SQLFunctionLiteralProcessor() {
            super(SQLFunctionLiteral.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, SQLFunctionLiteral object, StringBuilder builder) {
            builder.append(object.getFunctionName()).append("(");
            Iterator iter = object.getParameters().iterator();
            while (iter.hasNext()) {
                processor.process((Typeable)iter.next(), builder);
                if (!iter.hasNext()) continue;
                builder.append(",").append(" ");
            }
            builder.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateTimeLiteralProcessor
    extends AbstractProcessor<TimestampTimeLiteral> {
        private final DateFormat _format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        public DateTimeLiteralProcessor() {
            super(TimestampTimeLiteral.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, TimestampTimeLiteral object, StringBuilder builder) {
            builder.append("'" + this._format.format(object.getTimestamp()) + "'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DirectLiteralProcessor
    extends AbstractProcessor<DirectLiteral> {
        public DirectLiteralProcessor() {
            super(DirectLiteral.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, DirectLiteral literal, StringBuilder builder) {
            String string = literal.getDirectLiteral();
            builder.append(string == null ? "NULL" : string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringLiteralExpressionProcessor
    extends AbstractProcessor<StringLiteral> {
        public StringLiteralExpressionProcessor() {
            super(StringLiteral.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, StringLiteral literal, StringBuilder builder) {
            String string = literal.getString();
            builder.append(string == null ? "NULL" : "'" + string + "'");
        }
    }
}

