/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.java_websocket.util.ThreadCheck;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Issue661Test {
    @Rule
    public ThreadCheck zombies = new ThreadCheck();
    private CountDownLatch countServerDownLatch = new CountDownLatch(1);
    private boolean wasError = false;
    private boolean wasBindException = false;

    @Test(timeout=2000L)
    public void testIssue() throws Exception {
        int port = SocketUtil.getAvailablePort();
        WebSocketServer server0 = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
                Assert.fail((String)"There should be no onOpen");
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
                Assert.fail((String)"There should be no onClose");
            }

            public void onMessage(WebSocket conn, String message) {
                Assert.fail((String)"There should be no onMessage");
            }

            public void onError(WebSocket conn, Exception ex) {
                Assert.fail((String)"There should be no onError!");
            }

            public void onStart() {
                Issue661Test.this.countServerDownLatch.countDown();
            }
        };
        server0.start();
        try {
            this.countServerDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        WebSocketServer server1 = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
                Assert.fail((String)"There should be no onOpen");
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
                Assert.fail((String)"There should be no onClose");
            }

            public void onMessage(WebSocket conn, String message) {
                Assert.fail((String)"There should be no onMessage");
            }

            public void onError(WebSocket conn, Exception ex) {
                if (ex instanceof BindException) {
                    Issue661Test.this.wasBindException = true;
                } else {
                    Issue661Test.this.wasError = true;
                }
            }

            public void onStart() {
                Assert.fail((String)"There should be no onStart!");
            }
        };
        server1.start();
        Thread.sleep(1000L);
        server1.stop();
        server0.stop();
        Thread.sleep(100L);
        Assert.assertFalse((String)"There was an unexpected exception!", (boolean)this.wasError);
        Assert.assertTrue((String)"There was no bind exception!", (boolean)this.wasBindException);
    }
}

