/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.junit.Assert;
import org.junit.Test;

public class Issue677Test {
    CountDownLatch countDownLatch0 = new CountDownLatch(1);
    CountDownLatch countServerDownLatch = new CountDownLatch(1);

    @Test
    public void testIssue() throws Exception {
        int port = SocketUtil.getAvailablePort();
        WebSocketClient webSocket0 = new WebSocketClient(new URI("ws://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
                Issue677Test.this.countDownLatch0.countDown();
            }

            public void onError(Exception ex) {
            }
        };
        WebSocketClient webSocket1 = new WebSocketClient(new URI("ws://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
            }

            public void onError(Exception ex) {
            }
        };
        WebSocketServer server = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            }

            public void onMessage(WebSocket conn, String message) {
            }

            public void onError(WebSocket conn, Exception ex) {
            }

            public void onStart() {
                Issue677Test.this.countServerDownLatch.countDown();
            }
        };
        server.start();
        this.countServerDownLatch.await();
        webSocket0.connectBlocking();
        Assert.assertTrue((String)"webSocket.isOpen()", (boolean)webSocket0.isOpen());
        webSocket0.close();
        Assert.assertTrue((String)"webSocket.isClosing()", (boolean)webSocket0.isClosing());
        this.countDownLatch0.await();
        Assert.assertTrue((String)"webSocket.isClosed()", (boolean)webSocket0.isClosed());
        webSocket1.connectBlocking();
        Assert.assertTrue((String)"webSocket.isOpen()", (boolean)webSocket1.isOpen());
        webSocket1.closeConnection(1006, "Abnormal close!");
        Assert.assertTrue((String)"webSocket.isClosed()", (boolean)webSocket1.isClosed());
        server.stop();
    }
}

