/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.protocols;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Scanner;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.protocols.Protocol;
import org.java_websocket.util.Base64;
import org.java_websocket.util.Charsetfunctions;
import org.java_websocket.util.SocketUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProtoclHandshakeRejectionTest {
    private static final String additionalHandshake = "HTTP/1.1 101 Websocket Connection Upgrade\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n";
    private static int counter = 0;
    private static Thread thread;
    private static ServerSocket serverSocket;
    private static boolean debugPrintouts;
    private static int port;

    @BeforeClass
    public static void startServer() throws Exception {
        port = SocketUtil.getAvailablePort();
        thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    serverSocket = new ServerSocket(port);
                    serverSocket.setReuseAddress(true);
                    int count = 1;
                    while (true) {
                        Socket client = null;
                        try {
                            client = serverSocket.accept();
                            Scanner in = new Scanner(client.getInputStream());
                            String input = in.nextLine();
                            String testCase = input.split(" ")[1];
                            String seckey = "";
                            String secproc = "";
                            while (in.hasNext()) {
                                input = in.nextLine();
                                if (input.startsWith("Sec-WebSocket-Key: ")) {
                                    seckey = input.split(" ")[1];
                                }
                                if (input.startsWith("Sec-WebSocket-Protocol: ")) {
                                    secproc = input.split(" ")[1];
                                }
                                if (!input.startsWith("Upgrade")) continue;
                            }
                            OutputStream os = client.getOutputStream();
                            ++count;
                            if ("/0".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "\r\n")));
                                os.flush();
                            }
                            if ("/1".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat\r\n\r\n")));
                                os.flush();
                            }
                            if ("/2".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat, chat2\r\n\r\n")));
                                os.flush();
                            }
                            if ("/3".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat,chat2,chat3\r\n\r\n")));
                                os.flush();
                            }
                            if ("/4".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat\r\nSec-WebSocket-Protocol: chat2,chat3\r\n\r\n")));
                                os.flush();
                            }
                            if ("/5".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "\r\n")));
                                os.flush();
                            }
                            if ("/6".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat\r\n\r\n")));
                                os.flush();
                            }
                            if ("/7".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat, chat2\r\n\r\n")));
                                os.flush();
                            }
                            if ("/8".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat,chat2,chat3\r\n\r\n")));
                                os.flush();
                            }
                            if ("/9".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat\r\nSec-WebSocket-Protocol: chat2,chat3\r\n\r\n")));
                                os.flush();
                            }
                            if ("/10".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat2,chat3\r\n\r\n")));
                                os.flush();
                            }
                            if ("/11".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat2, chat3\r\n\r\n")));
                                os.flush();
                            }
                            if ("/12".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat2\r\nSec-WebSocket-Protocol: chat3\r\n\r\n")));
                                os.flush();
                            }
                            if ("/13".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat2\r\nSec-WebSocket-Protocol: chat\r\n\r\n")));
                                os.flush();
                            }
                            if ("/14".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat2,chat\r\n\r\n")));
                                os.flush();
                            }
                            if ("/15".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "Sec-WebSocket-Protocol: chat3\r\n\r\n")));
                                os.flush();
                            }
                            if ("/16".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "\r\n")));
                                os.flush();
                            }
                            if ("/17".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)(ProtoclHandshakeRejectionTest.additionalHandshake + ProtoclHandshakeRejectionTest.getSecKey(seckey) + "\r\n")));
                                os.flush();
                            }
                            if ("/18".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)"HTTP/1.1 101 Websocket Connection Upgrade\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Accept: abc\r\n\r\n"));
                                os.flush();
                            }
                            if (!"/19".equals(testCase)) continue;
                            os.write(Charsetfunctions.asciiBytes((String)"HTTP/1.1 101 Websocket Connection Upgrade\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n\r\n"));
                            os.flush();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)"There should be no exception");
                    return;
                }
            }
        });
        thread.start();
    }

    private static String getSecKey(String seckey) {
        return "Sec-WebSocket-Accept: " + ProtoclHandshakeRejectionTest.generateFinalKey(seckey) + "\r\n";
    }

    @AfterClass
    public static void successTests() throws InterruptedException, IOException {
        serverSocket.close();
        thread.interrupt();
        if (debugPrintouts) {
            System.out.println(counter + " successful tests");
        }
    }

    @Test(timeout=5000L)
    public void testProtocolRejectionTestCase0() throws Exception {
        this.testProtocolRejection(0, new Draft_6455());
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase1() throws Exception {
        this.testProtocolRejection(1, new Draft_6455());
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase2() throws Exception {
        this.testProtocolRejection(2, new Draft_6455());
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase3() throws Exception {
        this.testProtocolRejection(3, new Draft_6455());
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase4() throws Exception {
        this.testProtocolRejection(4, new Draft_6455());
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase5() throws Exception {
        this.testProtocolRejection(5, new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat"))));
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase6() throws Exception {
        this.testProtocolRejection(6, new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat"))));
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase7() throws Exception {
        this.testProtocolRejection(7, new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat"))));
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase8() throws Exception {
        this.testProtocolRejection(8, new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat"))));
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase9() throws Exception {
        this.testProtocolRejection(9, new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat"))));
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase10() throws Exception {
        this.testProtocolRejection(10, new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat"))));
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase11() throws Exception {
        this.testProtocolRejection(11, new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat"))));
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase12() throws Exception {
        this.testProtocolRejection(12, new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat"))));
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase13() throws Exception {
        this.testProtocolRejection(13, new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat"))));
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase14() throws Exception {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(new Protocol("chat"));
        protocols.add(new Protocol("chat2"));
        this.testProtocolRejection(14, new Draft_6455(Collections.emptyList(), protocols));
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase15() throws Exception {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(new Protocol("chat"));
        protocols.add(new Protocol("chat2"));
        this.testProtocolRejection(15, new Draft_6455(Collections.emptyList(), protocols));
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase16() throws Exception {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(new Protocol("chat"));
        protocols.add(new Protocol("chat2"));
        this.testProtocolRejection(16, new Draft_6455(Collections.emptyList(), protocols));
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase17() throws Exception {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(new Protocol("chat"));
        protocols.add(new Protocol(""));
        this.testProtocolRejection(17, new Draft_6455(Collections.emptyList(), protocols));
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase18() throws Exception {
        this.testProtocolRejection(18, new Draft_6455());
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase19() throws Exception {
        this.testProtocolRejection(19, new Draft_6455());
    }

    private void testProtocolRejection(int i, Draft_6455 draft) throws Exception {
        final int finalI = i;
        final boolean[] threadReturned = new boolean[]{false};
        WebSocketClient webSocketClient = new WebSocketClient(new URI("ws://localhost:" + port + "/" + finalI), (Draft)draft){

            public void onOpen(ServerHandshake handshakedata) {
                switch (finalI) {
                    case 0: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 13: 
                    case 14: 
                    case 17: {
                        counter++;
                        threadReturned[0] = true;
                        this.closeConnection(1006, "Bye");
                        break;
                    }
                    default: {
                        Assert.fail((String)"There should not be a connection!");
                    }
                }
            }

            public void onMessage(String message) {
                Assert.fail((String)"There should not be a message!");
            }

            public void onClose(int code, String reason, boolean remote) {
                if (code == 1006) {
                    switch (finalI) {
                        case 0: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 13: 
                        case 14: 
                        case 17: {
                            return;
                        }
                    }
                }
                if (code != 1002) {
                    Assert.fail((String)("There should be a protocol error! " + finalI + " " + code));
                } else if (reason.endsWith("refuses handshake")) {
                    if (debugPrintouts) {
                        System.out.println("Protocol error for test case: " + finalI);
                    }
                    threadReturned[0] = true;
                    counter++;
                } else {
                    Assert.fail((String)"The reason should be included!");
                }
            }

            public void onError(Exception ex) {
                Assert.fail((String)"There should not be an exception");
            }
        };
        Thread finalThread = new Thread((Runnable)webSocketClient);
        finalThread.start();
        finalThread.join();
        if (!threadReturned[0]) {
            Assert.fail((String)"Error");
        }
    }

    private static String generateFinalKey(String in) {
        MessageDigest sh1;
        String seckey = in.trim();
        String acc = seckey + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        try {
            sh1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return Base64.encodeBytes((byte[])sh1.digest(acc.getBytes()));
    }

    static {
        debugPrintouts = false;
    }
}

