/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.enums.Opcode;
import org.java_websocket.extensions.IExtension;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.protocols.IProtocol;
import org.java_websocket.protocols.Protocol;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.junit.Test;

public class Issue598Test {
    private static List<IProtocol> protocolList = Collections.singletonList(new Protocol(""));
    private static List<IExtension> extensionList = Collections.emptyList();

    private static void runTestScenario(int testCase) throws Exception {
        final CountDownLatch countServerDownLatch = new CountDownLatch(1);
        final CountDownLatch countReceiveDownLatch = new CountDownLatch(1);
        final CountDownLatch countCloseDownLatch = new CountDownLatch(1);
        int port = SocketUtil.getAvailablePort();
        Draft_6455 draft = null;
        switch (testCase) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                draft = new Draft_6455(extensionList, protocolList, 10);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                draft = new Draft_6455(extensionList, protocolList, 9);
            }
        }
        WebSocketClient webSocket = new WebSocketClient(new URI("ws://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
            }

            public void onError(Exception ex) {
            }
        };
        WebSocketServer server = new WebSocketServer(new InetSocketAddress(port), Collections.singletonList(draft)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
                if (code == 1009) {
                    countCloseDownLatch.countDown();
                }
            }

            public void onMessage(WebSocket conn, String message) {
                countReceiveDownLatch.countDown();
            }

            public void onMessage(WebSocket conn, ByteBuffer message) {
                countReceiveDownLatch.countDown();
            }

            public void onError(WebSocket conn, Exception ex) {
            }

            public void onStart() {
                countServerDownLatch.countDown();
            }
        };
        server.start();
        countServerDownLatch.await();
        webSocket.connectBlocking();
        switch (testCase) {
            case 0: 
            case 4: {
                byte[] bArray = new byte[10];
                for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
                    bArray[i] = i;
                }
                webSocket.send(ByteBuffer.wrap(bArray));
                if (testCase == 0) {
                    countReceiveDownLatch.await();
                }
                if (testCase != 4) break;
                countCloseDownLatch.await();
                break;
            }
            case 2: 
            case 6: {
                byte[] bArray = "0123456789".getBytes();
                webSocket.send(ByteBuffer.wrap(bArray));
                if (testCase == 2) {
                    countReceiveDownLatch.await();
                }
                if (testCase != 6) break;
                countCloseDownLatch.await();
                break;
            }
            case 1: 
            case 5: {
                byte[] bArray = new byte[2];
                for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
                    bArray[i % 2] = i;
                    if (i % 2 != 1) continue;
                    webSocket.sendFragmentedFrame(Opcode.BINARY, ByteBuffer.wrap(bArray), i == 9);
                }
                if (testCase == 1) {
                    countReceiveDownLatch.await();
                }
                if (testCase != 5) break;
                countCloseDownLatch.await();
                break;
            }
            case 3: 
            case 7: {
                for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
                    webSocket.sendFragmentedFrame(Opcode.TEXT, ByteBuffer.wrap(Integer.toString(i).getBytes()), i == 9);
                }
                if (testCase == 3) {
                    countReceiveDownLatch.await();
                }
                if (testCase != 7) break;
                countCloseDownLatch.await();
            }
        }
        server.stop();
    }

    @Test(timeout=2000L)
    public void runBelowLimitBytebuffer() throws Exception {
        Issue598Test.runTestScenario(0);
    }

    @Test(timeout=2000L)
    public void runBelowSplitLimitBytebuffer() throws Exception {
        Issue598Test.runTestScenario(1);
    }

    @Test(timeout=2000L)
    public void runBelowLimitString() throws Exception {
        Issue598Test.runTestScenario(2);
    }

    @Test(timeout=2000L)
    public void runBelowSplitLimitString() throws Exception {
        Issue598Test.runTestScenario(3);
    }

    @Test
    public void runAboveLimitBytebuffer() throws Exception {
        Issue598Test.runTestScenario(4);
    }

    @Test(timeout=2000L)
    public void runAboveSplitLimitBytebuffer() throws Exception {
        Issue598Test.runTestScenario(5);
    }

    @Test(timeout=2000L)
    public void runAboveLimitString() throws Exception {
        Issue598Test.runTestScenario(6);
    }

    @Test(timeout=2000L)
    public void runAboveSplitLimitString() throws Exception {
        Issue598Test.runTestScenario(7);
    }
}

