/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.framing;

import org.java_websocket.enums.Opcode;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.framing.ControlFrame;
import org.java_websocket.framing.PingFrame;
import org.junit.Assert;
import org.junit.Test;

public class PingFrameTest {
    @Test
    public void testConstructor() {
        PingFrame frame = new PingFrame();
        Assert.assertEquals((String)"Opcode must be equal", (Object)Opcode.PING, (Object)frame.getOpcode());
        Assert.assertEquals((String)"Fin must be set", (Object)true, (Object)frame.isFin());
        Assert.assertEquals((String)"TransferedMask must not be set", (Object)false, (Object)frame.getTransfereMasked());
        Assert.assertEquals((String)"Payload must be empty", (long)0L, (long)frame.getPayloadData().capacity());
        Assert.assertEquals((String)"RSV1 must be false", (Object)false, (Object)frame.isRSV1());
        Assert.assertEquals((String)"RSV2 must be false", (Object)false, (Object)frame.isRSV2());
        Assert.assertEquals((String)"RSV3 must be false", (Object)false, (Object)frame.isRSV3());
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
    }

    @Test
    public void testExtends() {
        PingFrame frame = new PingFrame();
        Assert.assertEquals((String)"Frame must extend dataframe", (Object)true, (Object)(frame instanceof ControlFrame));
    }

    @Test
    public void testIsValid() {
        PingFrame frame = new PingFrame();
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame.setFin(false);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        frame.setFin(true);
        frame.setRSV1(true);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        frame.setRSV1(false);
        frame.setRSV2(true);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        frame.setRSV2(false);
        frame.setRSV3(true);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
    }
}

