/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.java_websocket.util.ThreadCheck;
import org.junit.Assert;
import org.junit.Test;

public class Issue666Test {
    private CountDownLatch countServerDownLatch = new CountDownLatch(1);

    @Test
    public void testServer() throws Exception {
        Map<Long, Thread> mapBefore = ThreadCheck.getThreadMap();
        int port = SocketUtil.getAvailablePort();
        WebSocketServer server = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            }

            public void onMessage(WebSocket conn, String message) {
            }

            public void onError(WebSocket conn, Exception ex) {
            }

            public void onStart() {
                Issue666Test.this.countServerDownLatch.countDown();
            }
        };
        server.start();
        this.countServerDownLatch.await();
        Map<Long, Thread> mapAfter = ThreadCheck.getThreadMap();
        Iterator<Object> iterator = mapBefore.keySet().iterator();
        while (iterator.hasNext()) {
            long key = iterator.next();
            mapAfter.remove(key);
        }
        for (Thread thread : mapAfter.values()) {
            String name = thread.getName();
            if (name.startsWith("WebSocketSelector-") || name.startsWith("WebSocketWorker-") || name.startsWith("connectionLostChecker-")) continue;
            Assert.fail((String)("Thread not correctly named! Is: " + name));
        }
        server.stop();
    }

    @Test
    public void testClient() throws Exception {
        int port = SocketUtil.getAvailablePort();
        WebSocketClient client = new WebSocketClient(new URI("ws://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
            }

            public void onError(Exception ex) {
            }
        };
        WebSocketServer server = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            }

            public void onMessage(WebSocket conn, String message) {
            }

            public void onError(WebSocket conn, Exception ex) {
            }

            public void onStart() {
                Issue666Test.this.countServerDownLatch.countDown();
            }
        };
        server.start();
        this.countServerDownLatch.await();
        Map<Long, Thread> mapBefore = ThreadCheck.getThreadMap();
        client.connectBlocking();
        Map<Long, Thread> mapAfter = ThreadCheck.getThreadMap();
        Iterator<Object> iterator = mapBefore.keySet().iterator();
        while (iterator.hasNext()) {
            long key = iterator.next();
            mapAfter.remove(key);
        }
        for (Thread thread : mapAfter.values()) {
            String name = thread.getName();
            if (name.startsWith("connectionLostChecker-") || name.startsWith("WebSocketWriteThread-") || name.startsWith("WebSocketConnectReadThread-")) continue;
            Assert.fail((String)("Thread not correctly named! Is: " + name));
        }
        client.close();
        server.stop();
    }
}

