/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.junit.Assert;
import org.junit.Test;

public class Issue962Test {
    @Test(timeout=2000L)
    public void testIssue() throws IOException, URISyntaxException, InterruptedException {
        int port = SocketUtil.getAvailablePort();
        WebSocketClient client = new WebSocketClient(new URI("ws://127.0.0.1:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
            }

            public void onError(Exception ex) {
                Assert.fail((String)(ex.toString() + " should not occur"));
            }
        };
        String bindingAddress = "127.0.0.1";
        client.setSocketFactory((SocketFactory)new TestSocketFactory(bindingAddress));
        WebSocketServer server = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            }

            public void onMessage(WebSocket conn, String message) {
            }

            public void onError(WebSocket conn, Exception ex) {
            }

            public void onStart() {
            }
        };
        server.start();
        client.connectBlocking();
        Assert.assertEquals((Object)bindingAddress, (Object)client.getSocket().getLocalAddress().getHostAddress());
        Assert.assertNotEquals((long)0L, (long)client.getSocket().getLocalPort());
        Assert.assertTrue((boolean)client.getSocket().isConnected());
    }

    private static class TestSocketFactory
    extends SocketFactory {
        private final SocketFactory socketFactory = SocketFactory.getDefault();
        private final String bindingAddress;

        public TestSocketFactory(String bindingAddress) {
            this.bindingAddress = bindingAddress;
        }

        @Override
        public Socket createSocket() throws IOException {
            Socket socket = this.socketFactory.createSocket();
            socket.bind(new InetSocketAddress(this.bindingAddress, 0));
            return socket;
        }

        @Override
        public Socket createSocket(String string, int i) throws IOException, UnknownHostException {
            Socket socket = this.socketFactory.createSocket(string, i);
            socket.bind(new InetSocketAddress(this.bindingAddress, 0));
            return socket;
        }

        @Override
        public Socket createSocket(String string, int i, InetAddress ia, int i1) throws IOException, UnknownHostException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(InetAddress ia, int i) throws IOException {
            Socket socket = this.socketFactory.createSocket(ia, i);
            socket.bind(new InetSocketAddress(this.bindingAddress, 0));
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress ia, int i, InetAddress ia1, int i1) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

