/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.rx;

import com.google.inject.Binder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javaslang.API;
import javaslang.Predicates;
import org.jooby.Deferred;
import org.jooby.Env;
import org.jooby.Route;
import org.jooby.exec.Exec;
import org.jooby.rx.ExecSchedulerHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Completable;
import rx.Observable;
import rx.Scheduler;
import rx.Single;
import rx.Subscriber;
import rx.plugins.RxJavaPlugins;
import rx.plugins.RxJavaSchedulersHook;
import rx.schedulers.Schedulers;

public class Rx
extends Exec {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Rx() {
        super("rx.schedulers");
        this.daemon(true);
    }

    public static Route.Mapper<Object> rx() {
        return Rx.rx(Optional.empty());
    }

    public static Route.Mapper<Object> rx(Supplier<Scheduler> subscribeOn) {
        return Rx.rx(Optional.of(subscribeOn));
    }

    private static Route.Mapper<Object> rx(Optional<Supplier<Scheduler>> subscribeOn) {
        return value -> API.Match((Object)value).of(new API.Match.Case[]{API.Case((Predicate)Predicates.instanceOf(Observable.class), it -> new Deferred(deferred -> subscribeOn.map(s -> it.subscribeOn((Scheduler)s.get())).orElse((Observable)it).subscribe((Subscriber)new DeferredSubscriber(deferred)))), API.Case((Predicate)Predicates.instanceOf(Single.class), it -> new Deferred(deferred -> subscribeOn.map(s -> it.subscribeOn((Scheduler)s.get())).orElse((Single)it).subscribe((Subscriber)new DeferredSubscriber(deferred)))), API.Case((Predicate)Predicates.instanceOf(Completable.class), it -> new Deferred(deferred -> subscribeOn.map(s -> it.subscribeOn((Scheduler)s.get())).orElse((Completable)it).subscribe((Subscriber)new DeferredSubscriber(deferred)))), API.Case((API.Match.Pattern0)API.$(), (Object)value)});
    }

    public void configure(Env env, Config conf, Binder binder) {
        conf.getConfig("rx").withoutPath("schedulers").entrySet().forEach(e -> System.setProperty("rx." + (String)e.getKey(), ((ConfigValue)e.getValue()).unwrapped().toString()));
        HashMap<String, Executor> executors = new HashMap<String, Executor>();
        super.configure(env, conf, binder, executors::put);
        this.trySchedulerHook(executors);
        env.onStop(() -> {
            try {
                Schedulers.shutdown();
            }
            catch (Throwable ex) {
                this.log.debug("Schedulers.shutdown() resulted in error", ex);
            }
        });
    }

    public Config config() {
        return ConfigFactory.parseResources(((Object)((Object)this)).getClass(), (String)"rx.conf");
    }

    private void trySchedulerHook(Map<String, Executor> executors) {
        block2: {
            RxJavaPlugins plugins = RxJavaPlugins.getInstance();
            try {
                plugins.registerSchedulersHook((RxJavaSchedulersHook)new ExecSchedulerHook(executors));
            }
            catch (IllegalStateException ex) {
                RxJavaSchedulersHook hook = plugins.getSchedulersHook();
                if (hook instanceof ExecSchedulerHook) break block2;
                throw ex;
            }
        }
    }

    static class DeferredSubscriber
    extends Subscriber<Object> {
        private Deferred deferred;
        private AtomicBoolean done = new AtomicBoolean(false);

        public DeferredSubscriber(Deferred deferred) {
            this.deferred = deferred;
        }

        public void onCompleted() {
            if (this.done.compareAndSet(false, true)) {
                this.deferred.resolve(null);
            }
            this.deferred = null;
        }

        public void onError(Throwable cause) {
            this.done.set(true);
            this.deferred.reject(cause);
        }

        public void onNext(Object value) {
            if (this.done.compareAndSet(false, true)) {
                this.deferred.resolve(value);
            }
        }
    }
}

