/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import java.util.Locale;
import java.util.Set;
import org.mapstruct.ap.conversion.SimpleConversion;
import org.mapstruct.ap.model.common.ConversionContext;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.util.Collections;
import org.mapstruct.ap.util.Strings;

public abstract class AbstractJodaTypeToStringConversion
extends SimpleConversion {
    @Override
    protected String getToExpression(ConversionContext conversionContext) {
        return this.conversionString(conversionContext, "print");
    }

    @Override
    protected Set<Type> getToConversionImportTypes(ConversionContext conversionContext) {
        return Collections.asSet(conversionContext.getTypeFactory().getType("org.joda.time.format.DateTimeFormat"), conversionContext.getTypeFactory().getType(Locale.class));
    }

    @Override
    protected String getFromExpression(ConversionContext conversionContext) {
        return this.conversionString(conversionContext, this.parseMethod());
    }

    @Override
    protected Set<Type> getFromConversionImportTypes(ConversionContext conversionContext) {
        return Collections.asSet(conversionContext.getTypeFactory().getType("org.joda.time.format.DateTimeFormat"));
    }

    private String conversionString(ConversionContext conversionContext, String method) {
        StringBuilder conversionString = new StringBuilder("DateTimeFormat");
        conversionString.append(this.dateFormatPattern(conversionContext));
        conversionString.append(".");
        conversionString.append(method);
        conversionString.append("( <SOURCE> )");
        return conversionString.toString();
    }

    private String dateFormatPattern(ConversionContext conversionContext) {
        StringBuilder conversionString = new StringBuilder();
        conversionString.append(".forPattern(");
        String dateFormat = conversionContext.getDateFormat();
        if (Strings.isEmpty(dateFormat)) {
            conversionString.append(this.defaultDateFormatPattern());
        } else {
            conversionString.append(" \"");
            conversionString.append(dateFormat);
            conversionString.append("\"");
        }
        conversionString.append(")");
        return conversionString.toString();
    }

    private String defaultDateFormatPattern() {
        return "DateTimeFormat.patternForStyle( \"" + this.formatStyle() + "\", Locale.getDefault() )";
    }

    protected abstract String formatStyle();

    protected abstract String parseMethod();
}

