/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import java.math.BigInteger;
import java.util.Set;
import org.mapstruct.ap.conversion.SimpleConversion;
import org.mapstruct.ap.model.common.ConversionContext;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.util.Collections;
import org.mapstruct.ap.util.NativeTypes;

public class BigIntegerToWrapperConversion
extends SimpleConversion {
    private final Class<?> targetType;

    public BigIntegerToWrapperConversion(Class<?> targetType) {
        if (targetType.isPrimitive()) {
            throw new IllegalArgumentException(targetType + " is a primitive type.");
        }
        this.targetType = NativeTypes.getPrimitiveType(targetType);
    }

    @Override
    public String getToExpression(ConversionContext conversionContext) {
        return "<SOURCE>." + this.targetType.getName() + "Value()";
    }

    @Override
    public String getFromExpression(ConversionContext conversionContext) {
        String toLongValueStr = "";
        if (this.targetType == Float.TYPE || this.targetType == Double.TYPE) {
            toLongValueStr = ".longValue()";
        }
        return "BigInteger.valueOf( <SOURCE>" + toLongValueStr + " )";
    }

    @Override
    protected Set<Type> getFromConversionImportTypes(ConversionContext conversionContext) {
        return Collections.asSet(conversionContext.getTypeFactory().getType(BigInteger.class));
    }
}

