/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

class IndentationCorrectingWriter
extends Writer {
    private final Writer delegate;
    private State state = State.IN_TEXT;
    private int indentationLevel = 0;

    IndentationCorrectingWriter(Writer out) {
        super((Object)out);
        this.delegate = out;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int start = off;
        int length = 0;
        for (int i = off; i < len; ++i) {
            char c = cbuf[i];
            if (c == '{' || c == '(') {
                ++this.indentationLevel;
            } else if (c == '}' || c == ')') {
                --this.indentationLevel;
            }
            State newState = this.state.handleCharacter(c);
            ++length;
            if (this.state == State.IN_TEXT && newState == State.AFTER_LINE_BREAK) {
                this.delegate.write(cbuf, start, length);
            } else if (this.state == State.AFTER_LINE_BREAK && newState == State.IN_TEXT) {
                char[] indentation = IndentationCorrectingWriter.getIndentation(this.indentationLevel);
                this.delegate.write(indentation, 0, indentation.length);
                start = i;
                length = 1;
            } else if (this.state == State.AFTER_LINE_BREAK && (c == '\n' || c == '\r')) {
                this.delegate.write(c);
            }
            this.state = newState;
        }
        if (this.state == State.IN_TEXT) {
            this.delegate.write(cbuf, start, length);
        }
    }

    private static char[] getIndentation(int indentationLevel) {
        char[] indentation = new char[indentationLevel * 4];
        Arrays.fill(indentation, ' ');
        return indentation;
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private static enum State {
        IN_TEXT,
        AFTER_LINE_BREAK;


        State handleCharacter(char c) {
            if (this == IN_TEXT) {
                if (c == '\n' || c == '\r') {
                    return AFTER_LINE_BREAK;
                }
                return IN_TEXT;
            }
            if (this == AFTER_LINE_BREAK) {
                if (c == ' ') {
                    return AFTER_LINE_BREAK;
                }
                if (c == '\n' || c == '\r') {
                    return AFTER_LINE_BREAK;
                }
                return IN_TEXT;
            }
            throw new IllegalStateException("Unexpected state or character.");
        }
    }
}

