/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.writer;

import freemarker.core.Environment;
import freemarker.ext.beans.BeanModel;
import freemarker.template.Configuration;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mapstruct.ap.writer.ModelWriter;
import org.mapstruct.ap.writer.Writable;

public class ModelIncludeDirective
implements TemplateDirectiveModel {
    private final Configuration configuration;

    public ModelIncludeDirective(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Writable modelElement = this.getModelElement(params);
        ModelWriter.DefaultModelElementWriterContext context = this.createContext(params);
        try {
            modelElement.write(context, env.getOut());
        }
        catch (TemplateException te) {
            throw te;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Writable getModelElement(Map params) {
        if (!params.containsKey("object")) {
            throw new IllegalArgumentException("Object to be included must be passed to this directive via the 'object' parameter");
        }
        BeanModel objectModel = (BeanModel)params.get("object");
        if (objectModel == null) {
            throw new IllegalArgumentException("Object passed to this directive via the 'object' parameter must not be null");
        }
        if (!(objectModel.getWrappedObject() instanceof Writable)) {
            throw new IllegalArgumentException("Given object isn't a ModelElement:" + objectModel.getWrappedObject());
        }
        return (Writable)objectModel.getWrappedObject();
    }

    private ModelWriter.DefaultModelElementWriterContext createContext(Map params) {
        HashMap ext = new HashMap(params);
        ext.remove("object");
        HashMap values = new HashMap();
        values.put(Configuration.class, this.configuration);
        values.put(Map.class, ext);
        return new ModelWriter.DefaultModelElementWriterContext(values);
    }
}

