/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.io.IOException;
import java.io.StringReader;
import org.mapstruct.ap.shaded.freemarker.core.DollarVariable;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.FMParser;
import org.mapstruct.ap.shaded.freemarker.core.FMParserTokenManager;
import org.mapstruct.ap.shaded.freemarker.core.ParameterRole;
import org.mapstruct.ap.shaded.freemarker.core.ParseException;
import org.mapstruct.ap.shaded.freemarker.core.SimpleCharStream;
import org.mapstruct.ap.shaded.freemarker.core.TemplateElement;
import org.mapstruct.ap.shaded.freemarker.core._MiscTemplateException;
import org.mapstruct.ap.shaded.freemarker.template.SimpleScalar;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateExceptionHandler;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateScalarModel;
import org.mapstruct.ap.shaded.freemarker.template.utility.StringUtil;

final class StringLiteral
extends Expression
implements TemplateScalarModel {
    private final String value;
    private TemplateElement dynamicValue;

    StringLiteral(String value) {
        this.value = value;
    }

    void checkInterpolation() throws ParseException {
        if (this.value.length() > 3 && (this.value.indexOf("${") >= 0 || this.value.indexOf("#{") >= 0)) {
            SimpleCharStream scs = new SimpleCharStream(new StringReader(this.value), this.beginLine, this.beginColumn + 1, this.value.length());
            FMParserTokenManager token_source = new FMParserTokenManager(scs);
            token_source.onlyTextOutput = true;
            FMParser parser = new FMParser(token_source);
            parser.setTemplate(this.getTemplate());
            try {
                this.dynamicValue = parser.FreeMarkerText();
            }
            catch (ParseException e) {
                e.setTemplateName(this.getTemplate().getName());
                throw e;
            }
            this.constantValue = null;
        }
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        return new SimpleScalar(this.evalAndCoerceToString(env));
    }

    public String getAsString() {
        return this.value;
    }

    boolean isSingleInterpolationLiteral() {
        return this.dynamicValue != null && this.dynamicValue.getChildCount() == 1 && this.dynamicValue.getChildAt(0) instanceof DollarVariable;
    }

    String evalAndCoerceToString(Environment env) throws TemplateException {
        if (this.dynamicValue == null) {
            return this.value;
        }
        TemplateExceptionHandler teh = env.getTemplateExceptionHandler();
        env.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            String string = env.renderElementToString(this.dynamicValue);
            return string;
        }
        catch (IOException ioe) {
            throw new _MiscTemplateException((Throwable)ioe, env);
        }
        finally {
            env.setTemplateExceptionHandler(teh);
        }
    }

    public String getCanonicalForm() {
        return "\"" + StringUtil.FTLStringLiteralEnc(this.value) + "\"";
    }

    String getNodeTypeSymbol() {
        return this.dynamicValue == null ? this.getCanonicalForm() : "dynamic \"...\"";
    }

    boolean isLiteral() {
        return this.dynamicValue == null;
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        StringLiteral cloned = new StringLiteral(this.value);
        cloned.dynamicValue = this.dynamicValue;
        return cloned;
    }

    int getParameterCount() {
        return 1;
    }

    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.dynamicValue;
    }

    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.EMBEDDED_TEMPLATE;
    }
}

