/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.gem.SubclassMappingGem;
import org.mapstruct.ap.internal.gem.SubclassMappingsGem;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.BeanMappingOptions;
import org.mapstruct.ap.internal.model.source.DelegatingOptions;
import org.mapstruct.ap.internal.model.source.SubclassValidator;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.TypeUtils;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

public class SubclassMappingOptions
extends DelegatingOptions {
    private final TypeMirror source;
    private final TypeMirror target;

    public SubclassMappingOptions(TypeMirror source, TypeMirror target, DelegatingOptions next) {
        super(next);
        this.source = source;
        this.target = target;
    }

    @Override
    public boolean hasAnnotation() {
        return this.source != null && this.target != null;
    }

    private static boolean isConsistent(SubclassMappingGem gem, ExecutableElement method, FormattingMessager messager, TypeUtils typeUtils, List<Parameter> sourceParameters, Type resultType, SubclassValidator subclassValidator) {
        if (resultType == null) {
            messager.printMessage((Element)method, gem.mirror(), Message.SUBCLASSMAPPING_UPDATE_METHODS_NOT_SUPPORTED, new Object[0]);
            return false;
        }
        TypeMirror sourceSubclass = gem.source().getValue();
        TypeMirror targetSubclass = gem.target().getValue();
        TypeMirror targetParentType = resultType.getTypeMirror();
        SubclassMappingOptions.validateTypeMirrors(sourceSubclass, targetSubclass, targetParentType);
        boolean isConsistent = true;
        boolean isChildOfAParameter = false;
        for (Parameter sourceParameter : sourceParameters) {
            TypeMirror sourceParentType = sourceParameter.getType().getTypeMirror();
            SubclassMappingOptions.validateTypeMirrors(sourceParentType);
            isChildOfAParameter = isChildOfAParameter || SubclassMappingOptions.isChildOfParent(typeUtils, sourceSubclass, sourceParentType);
        }
        if (!isChildOfAParameter) {
            messager.printMessage((Element)method, gem.mirror(), Message.SUBCLASSMAPPING_NO_VALID_SUPERCLASS, sourceSubclass.toString());
            isConsistent = false;
        }
        if (!SubclassMappingOptions.isChildOfParent(typeUtils, targetSubclass, targetParentType)) {
            messager.printMessage((Element)method, gem.mirror(), Message.SUBCLASSMAPPING_ILLEGAL_SUBCLASS, targetParentType.toString(), targetSubclass.toString());
            isConsistent = false;
        }
        subclassValidator.isInCorrectOrder(method, gem.mirror(), targetSubclass);
        return isConsistent;
    }

    private static void validateTypeMirrors(TypeMirror ... typeMirrors) {
        for (TypeMirror typeMirror : typeMirrors) {
            if (typeMirror != null) continue;
            throw new TypeHierarchyErroneousException(typeMirror);
        }
    }

    private static boolean isChildOfParent(TypeUtils typeUtils, TypeMirror childType, TypeMirror parentType) {
        return typeUtils.isSubtype(childType, parentType);
    }

    public TypeMirror getSource() {
        return this.source;
    }

    public TypeMirror getTarget() {
        return this.target;
    }

    public static void addInstances(SubclassMappingsGem gem, ExecutableElement method, BeanMappingOptions beanMappingOptions, FormattingMessager messager, TypeUtils typeUtils, Set<SubclassMappingOptions> mappings, List<Parameter> sourceParameters, Type resultType) {
        SubclassValidator subclassValidator = new SubclassValidator(messager, typeUtils);
        for (SubclassMappingGem subclassMappingGem : gem.value().get()) {
            SubclassMappingOptions.addAndValidateInstance(subclassMappingGem, method, beanMappingOptions, messager, typeUtils, mappings, sourceParameters, resultType, subclassValidator);
        }
    }

    public static void addInstance(SubclassMappingGem subclassMapping, ExecutableElement method, BeanMappingOptions beanMappingOptions, FormattingMessager messager, TypeUtils typeUtils, Set<SubclassMappingOptions> mappings, List<Parameter> sourceParameters, Type resultType) {
        SubclassMappingOptions.addAndValidateInstance(subclassMapping, method, beanMappingOptions, messager, typeUtils, mappings, sourceParameters, resultType, new SubclassValidator(messager, typeUtils));
    }

    private static void addAndValidateInstance(SubclassMappingGem subclassMapping, ExecutableElement method, BeanMappingOptions beanMappingOptions, FormattingMessager messager, TypeUtils typeUtils, Set<SubclassMappingOptions> mappings, List<Parameter> sourceParameters, Type resultType, SubclassValidator subclassValidator) {
        if (!SubclassMappingOptions.isConsistent(subclassMapping, method, messager, typeUtils, sourceParameters, resultType, subclassValidator)) {
            return;
        }
        TypeMirror sourceSubclass = subclassMapping.source().getValue();
        TypeMirror targetSubclass = subclassMapping.target().getValue();
        mappings.add(new SubclassMappingOptions(sourceSubclass, targetSubclass, beanMappingOptions));
    }
}

