/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.syntax.JEditTextArea;
import processing.app.ui.Toolkit;
import processing.mode.java.JavaEditor;
import processing.mode.java.pdex.CompletionCandidate;
import processing.mode.java.pdex.JavaTextArea;

public class CompletionPanel {
    private JList<CompletionCandidate> completionList;
    private JPopupMenu popupMenu;
    private String subWord;
    private int insertionPosition;
    private JavaTextArea textarea;
    private JScrollPane scrollPane;
    protected JavaEditor editor;
    protected static final int MOUSE_COMPLETION = 10;
    protected static final int KEYBOARD_COMPLETION = 20;
    private boolean horizontalScrollBarVisible = false;
    public static ImageIcon classIcon;
    public static ImageIcon fieldIcon;
    public static ImageIcon methodIcon;
    public static ImageIcon localVarIcon;
    static Color selectionBgColor;
    static Color textColor;

    public CompletionPanel(JEditTextArea textarea, int position, String subWord, DefaultListModel<CompletionCandidate> items, Point location, JavaEditor editor) {
        this.textarea = (JavaTextArea)textarea;
        this.editor = editor;
        this.insertionPosition = position;
        this.subWord = subWord.indexOf(46) != -1 && subWord.indexOf(46) != subWord.length() - 1 ? subWord.substring(subWord.lastIndexOf(46) + 1) : subWord;
        if (classIcon == null) {
            Mode mode = editor.getMode();
            File dir = new File(mode.getFolder(), "theme/completion");
            classIcon = Toolkit.getIconX((File)dir, (String)"class_obj");
            methodIcon = Toolkit.getIconX((File)dir, (String)"methpub_obj");
            fieldIcon = Toolkit.getIconX((File)dir, (String)"field_protected_obj");
            localVarIcon = Toolkit.getIconX((File)dir, (String)"field_default_obj");
            selectionBgColor = new Color(-986896);
            textColor = new Color(-14540254);
        }
        this.popupMenu = new JPopupMenu();
        this.popupMenu.removeAll();
        this.popupMenu.setOpaque(false);
        this.popupMenu.setBorder(null);
        this.scrollPane = new JScrollPane();
        this.completionList = new JList<CompletionCandidate>(items){
            {
                this.setSelectionMode(0);
                this.setSelectedIndex(0);
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            CompletionPanel.this.insertSelection(10);
                            CompletionPanel.this.setInvisible();
                        }
                    }
                });
                this.setCellRenderer(new CustomListRenderer());
                this.setFocusable(false);
                this.setFont(Toolkit.getSansFont((int)12, (int)0));
            }
        };
        this.scrollPane.setViewportView(this.completionList);
        this.scrollPane.setBorder(null);
        this.popupMenu.add((Component)this.scrollPane, "Center");
        this.popupMenu.setPopupSize(this.calcWidth(), this.calcHeight(items.getSize()));
        this.popupMenu.setFocusable(false);
        this.popupMenu.show((Component)textarea, location.x, textarea.getBaseline(0, 0) + location.y);
    }

    public boolean isVisible() {
        return this.popupMenu.isVisible();
    }

    public void setInvisible() {
        this.popupMenu.setVisible(false);
    }

    private int calcHeight(int itemCount) {
        int maxHeight = 250;
        FontMetrics fm = this.textarea.getGraphics().getFontMetrics();
        float itemHeight = Math.max((float)fm.getHeight() + (float)fm.getDescent() * 0.5f, (float)classIcon.getIconHeight() * 1.2f);
        if (this.horizontalScrollBarVisible) {
            ++itemCount;
        }
        if (itemCount < 4) {
            itemHeight *= 1.3f;
        }
        float h = itemHeight * (float)itemCount;
        if (itemCount >= 4) {
            h = (float)((double)h + (double)itemHeight * 0.3);
        }
        return Math.min(maxHeight, (int)h);
    }

    private int calcWidth() {
        int maxWidth = 300;
        float min = 0.0f;
        FontMetrics fm = this.textarea.getGraphics().getFontMetrics();
        for (int i = 0; i < this.completionList.getModel().getSize(); ++i) {
            float h = fm.stringWidth(this.completionList.getModel().getElementAt(i).getLabel());
            min = Math.max(min, h);
        }
        int w = Math.min((int)min, maxWidth);
        this.horizontalScrollBarVisible = w == maxWidth;
        w += classIcon.getIconWidth();
        return w += fm.stringWidth("           ");
    }

    protected boolean insertSelection(int completionSource) {
        if (this.completionList.getSelectedValue() != null) {
            try {
                String currentSubword = this.fetchCurrentSubword();
                int currentSubwordLen = currentSubword == null ? 0 : currentSubword.length();
                String selectedSuggestion = this.completionList.getSelectedValue().getCompletionString();
                if (currentSubword != null) {
                    selectedSuggestion = selectedSuggestion.substring(currentSubwordLen);
                } else {
                    currentSubword = "";
                }
                String completionString = this.completionList.getSelectedValue().getCompletionString();
                if (selectedSuggestion.endsWith(" )") && completionString.endsWith(" )")) {
                    completionString = completionString.substring(0, completionString.length() - 2) + ")";
                }
                boolean mouseClickOnOverloadedMethods = false;
                if (completionSource == 10 && completionString.endsWith("(")) {
                    mouseClickOnOverloadedMethods = true;
                }
                Messages.loge((String)(this.subWord + " <= subword, Inserting suggestion=> " + selectedSuggestion + " Current sub: " + currentSubword));
                if (currentSubword.length() > 0) {
                    this.textarea.getDocument().remove(this.insertionPosition - currentSubwordLen, currentSubwordLen);
                }
                this.textarea.getDocument().insertString(this.insertionPosition - currentSubwordLen, completionString, null);
                if (selectedSuggestion.endsWith(")") && !selectedSuggestion.endsWith("()")) {
                    int x = selectedSuggestion.indexOf(44);
                    if (x == -1) {
                        this.textarea.setCaretPosition(this.textarea.getCaretPosition() - 1);
                    } else {
                        this.textarea.setCaretPosition(this.insertionPosition + x);
                    }
                }
                Messages.log((String)("Suggestion inserted: " + System.currentTimeMillis()));
                if (!this.completionList.getSelectedValue().getLabel().contains("...")) {
                    this.setInvisible();
                }
                if (mouseClickOnOverloadedMethods) {
                    ((JavaTextArea)this.editor.getTextArea()).fetchPhrase();
                }
                return true;
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setInvisible();
        }
        return false;
    }

    private String fetchCurrentSubword() {
        JEditTextArea ta = this.editor.getTextArea();
        int off = ta.getCaretPosition();
        if (off < 0) {
            return null;
        }
        int line = ta.getCaretLine();
        if (line < 0) {
            return null;
        }
        String s = ta.getLineText(line);
        int x = ta.getCaretPosition() - ta.getLineStartOffset(line) - 1;
        int x1 = x - 1;
        if (x >= s.length() || x < 0) {
            return null;
        }
        if (Base.DEBUG) {
            System.out.print(" x char: " + s.charAt(x));
        }
        String word = (x < s.length() ? Character.valueOf(s.charAt(x)) : "") + "";
        if (s.trim().length() == 1) {
            if ((word = word.trim()).endsWith(".")) {
                word = word.substring(0, word.length() - 1);
            }
            return word;
        }
        if (word.equals(".")) {
            return null;
        }
        int i = 0;
        do {
            ++i;
            if (x1 < 0 || !Character.isLetterOrDigit(s.charAt(x1)) && s.charAt(x1) != '_') break;
            word = s.charAt(x1--) + word;
        } while (i <= 200);
        if (Character.isDigit(word.charAt(0))) {
            return null;
        }
        if ((word = word.trim()).endsWith(".")) {
            word = word.substring(0, word.length() - 1);
        }
        return word;
    }

    protected void moveUp() {
        if (this.completionList.getSelectedIndex() == 0) {
            this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
            this.selectIndex(this.completionList.getModel().getSize() - 1);
        } else {
            int index = Math.max(this.completionList.getSelectedIndex() - 1, 0);
            this.selectIndex(index);
            int step = this.scrollPane.getVerticalScrollBar().getMaximum() / this.completionList.getModel().getSize();
            this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getValue() - step);
        }
    }

    protected void moveDown() {
        if (this.completionList.getSelectedIndex() == this.completionList.getModel().getSize() - 1) {
            this.scrollPane.getVerticalScrollBar().setValue(0);
            this.selectIndex(0);
        } else {
            int index = Math.min(this.completionList.getSelectedIndex() + 1, this.completionList.getModel().getSize() - 1);
            this.selectIndex(index);
            int step = this.scrollPane.getVerticalScrollBar().getMaximum() / this.completionList.getModel().getSize();
            this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getValue() + step);
        }
    }

    private void selectIndex(int index) {
        this.completionList.setSelectedIndex(index);
    }

    private static class CustomListRenderer
    extends DefaultListCellRenderer {
        private CustomListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (isSelected) {
                label.setBackground(selectionBgColor);
            }
            label.setForeground(textColor);
            if (value instanceof CompletionCandidate) {
                CompletionCandidate cc = (CompletionCandidate)value;
                switch (cc.getType()) {
                    case 6: {
                        label.setIcon(localVarIcon);
                        break;
                    }
                    case 1: 
                    case 5: {
                        label.setIcon(fieldIcon);
                        break;
                    }
                    case 2: 
                    case 4: {
                        label.setIcon(methodIcon);
                        break;
                    }
                    case 0: 
                    case 3: {
                        label.setIcon(classIcon);
                        break;
                    }
                    default: {
                        Messages.log((String)("(CustomListRenderer)Unknown CompletionCandidate type " + cc.getType()));
                        break;
                    }
                }
            } else {
                Messages.log((String)("(CustomListRenderer)Unknown CompletionCandidate object " + value));
            }
            return label;
        }
    }
}

