// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

import java.io.File;

import org.refcodes.struct.Relation;

/**
 * The {@link FileOption} represents an {@link Option} holding <code>File</code>
 * values.
 */
public class FileOption extends AbstractOption<File> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new file option.
	 *
	 * @param aShortOption the short option
	 * @param aLongOption the long option
	 * @param aAlias the option arg name
	 * @param aDescription the description
	 */
	public FileOption( String aShortOption, String aLongOption, String aAlias, String aDescription ) {
		super( aShortOption, aLongOption, File.class, aAlias, aDescription );
	}

	/**
	 * Instantiates a new file option.
	 *
	 * @param aLongOption the long option
	 * @param aAlias the option arg name
	 * @param aDescription the description
	 */
	public FileOption( String aLongOption, String aAlias, String aDescription ) {
		this( null, aLongOption, aAlias, aDescription );
	}

	/**
	 * Instantiates a new file option.
	 *
	 * @param aProperty The key (= alias) and the value for the operand.
	 */
	public FileOption( Relation<String, File> aProperty ) {
		super( aProperty, File.class );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected File toType( String aArg ) throws ParseArgsException {
		return new File( aArg );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
