/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractSyntaxable;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.UnknownArgsException;

public class ArrayOperand<T>
extends AbstractSyntaxable
implements Operand<T[]> {
    private Operand<T> _operand;
    private T[] _values = null;
    private int _minLength;
    private int _maxLength;
    private Class<T[]> _type;

    public ArrayOperand(Operand<T> operand) {
        this(operand, -1, -1);
    }

    public ArrayOperand(Operand<T> operand, int n) {
        this(operand, n, n);
    }

    public ArrayOperand(Operand<T> operand, int n, int n2) {
        if (n2 == 0 || n != -1 && n2 != -1 && n > n2 || n2 < -1 || n2 < -1) {
            throw new IllegalArgumentException("The minimum length <" + n + "> must be less or equal than the maximum length <" + n2 + ">, both values must be greater (minimum and maximum) or equal (minimum) than <0> (or <-1> when to be ignored)!");
        }
        this._operand = operand;
        this._minLength = n;
        this._maxLength = n2;
        this._type = Array.newInstance(operand.getType(), 0).getClass();
    }

    @Override
    public T[] getValue() {
        return this._values;
    }

    @Override
    public String[] getArgs() {
        return this._operand.getArgs();
    }

    @Override
    public String getAlias() {
        return this._operand.getAlias();
    }

    @Override
    public String toSyntax(SyntaxNotation syntaxNotation, String string, String string2, String string3) {
        string2 = string2 == null ? "" : string2;
        string3 = string3 == null ? "" : string3;
        return CliUtility.toParameterSpec(this, this._minLength, this._maxLength, string2, string3);
    }

    public Class<T[]> getType() {
        return this._type;
    }

    public List<Operand<?>> parseArgs(String[] stringArray, String[] stringArray2) throws ArgsSyntaxException {
        int n;
        ArrayList arrayList;
        ArrayList<T> arrayList2;
        block7: {
            arrayList2 = new ArrayList<T>();
            arrayList = new ArrayList();
            try {
                for (n = 0; this._maxLength == -1 || n < this._maxLength; ++n) {
                    List list = this._operand.parseArgs(stringArray, stringArray2);
                    for (Operand operand : list) {
                        Object object;
                        try {
                            object = operand.clone();
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            throw new ParseArgsException(stringArray, "The type <" + this._operand.getType().getSimpleName() + "> does not support cloning: " + cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                        }
                        arrayList.add((Operand)object);
                    }
                    arrayList2.add(this._operand.getValue());
                    stringArray = CliUtility.toDiff(stringArray, list);
                }
            }
            catch (AmbiguousArgsException | ParseArgsException | UnknownArgsException argsSyntaxException) {
                if (this._maxLength == -1 || n <= this._maxLength) break block7;
                throw argsSyntaxException;
            }
        }
        if (arrayList2.size() == 0 || this._minLength != -1 && n < this._minLength) {
            throw new UnknownArgsException(stringArray, "Not one argument matched (as of \"" + CliUtility.toSpec(this) + "\")");
        }
        this._values = arrayList2.toArray((Object[])Array.newInstance(this._operand.getType(), arrayList2.size()));
        return arrayList;
    }

    @Override
    public String toState() {
        return this._operand.toState();
    }

    public void reset() {
        this._operand.reset();
        this._values = null;
    }

    public String getDescription() {
        return this._operand.getDescription();
    }

    @Override
    public int compareTo(Operand<?> operand) {
        return this._operand.compareTo(operand);
    }

    public int getMinLength() {
        return this._minLength;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected Operand<T> getOperand() {
        return this._operand;
    }
}

